###############################################################################
# 
#                    MSM8X26 PANTECH MODEL config makefile
#
###############################################################################
# 2012-08-08 shpark : Created
###############################################################################
export TARGET_BUILD_PRJ_NAME=$(shell echo $(TARGET_BUILD_PROJECT) | tr a-z A-Z)

export TARGET_BUILD_MODEL_NAME=IM-A920S#
TARGET_BUILD_VER_PREFIX=S0225#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)001#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)002# SI-1 04-22
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)003# SI-2 04-25
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)004# SMT 04-29
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)005# SI-4 05-08
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)100# SR-1 IOT-1 05-14
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)101# SR-2 05-15
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)102# IOT-2 05-23
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)103# SR-3 05-28
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)104# IOT-3 05-30
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)105# SR-4 06-02
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)106# PP 06-05
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)107# 14/06/13 IOT-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)108# 14/06/13 SR-6
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)109# 14/06/15 SR-7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)110# 14/06/16 SR-8
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)111# 14/06/16 SR-9
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)112# 14/06/17 SR-10
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)113# 14/07/09 RC1-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)114# 14/07/17 RC1-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)115# 14/07/28 RC1-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)116# 14/07/28 RC1-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)117# 14/08/13 RC1-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)118# 14/11/21 RC1-6
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)119# 14/11/27 RC1-7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)120# 14/12/02 RC1-8
TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)121# 14/12/04 RC1-9
TARGET_BUILD_VERSION_HIDDEN=$(TARGET_BUILD_VERSION)# hidden version
TARGET_BUILD_FS_VER=4# android userdata ext4 filesystem version
TARGET_BUILD_NV_VER=4# mdm efs version
TARGET_BUILD_CARRIER=SKT-KOR#
TARGET_INTERNAL_SD_PARTITION=26

TARGET_BUILD_BRAND=VEGA
TARGET_BUILD_BRAND_MODEL_NAME=$(TARGET_BUILD_BRAND)_$(TARGET_BUILD_MODEL_NAME)

###############################################################################
# OEM_ environment variable
###############################################################################
# eMMC, sdcard
#    PANTECH_STORAGE_DEFAULT : no internal memory SD card
#    PANTECH_STORAGE_INTERNAL_EMUL : emulated primary volume
#    PANTECH_STORAGE_INTERNAL_FAT : primary volume is FAT
PANTECH_STORAGE_USE_TYPE=PANTECH_STORAGE_INTERNAL_FAT

PANTECH_GLOBAL_FLAGS= -DPROJECT_NAME=\"$(TARGET_BUILD_PROJECT)\"
PANTECH_GLOBAL_FLAGS+= -DPROJECT_NAME_UPPER=\"$(TARGET_BUILD_PRJ_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DMODEL_NAME=\"$(TARGET_BUILD_MODEL_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_VER=\"$(TARGET_BUILD_VERSION)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_FS_VER=$(TARGET_BUILD_FS_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_EFS_VER=$(TARGET_BUILD_NV_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BOARD_VER=$(TARGET_BUILD_BOARDVER)
PANTECH_GLOBAL_FLAGS+= -DMSM8974_$(TARGET_PRODUCT_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_PRELOAD_CHECKSUM=778548053
#PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_CARRIER=$(TARGET_BUILD_CARRIER)

#lsi@ls1 FEATURE_PANTECH_DXHDCP_PROVISIONING
ifeq ($(CMD_V_HDCP_SUPPORT), yes)
PANTECH_GLOBAL_FLAGS+= -DFEATURE_PANTECH_DxHDCP_PROVISIONING
endif

PANTECH_KERNEL_FLAGS:=$(PANTECH_GLOBAL_FLAGS)

PANTECH_GLOBAL_FLAGS+= -DT_$(TARGET_BUILD_PRJ_NAME)

PANTECH_GLOBAL_FLAGS+= -DT_BUILD_USER
PANTECH_GLOBAL_FLAGS+= -DFEATURE_AARM_RELEASE_MODE


# PANTECH_SECBOOT
ifeq ($(CMD_V_SECURE_BOOT),enable)
PANTECH_GLOBAL_FLAGS+= -DFEATURE_PANTECH_SEC_BUILD
endif

PANTECH_GLOBAL_FLAGS+= -I$(PANTECH_BUILD_SYSTEM)
PANTECH_SCONS_FLAGS := '$(PANTECH_GLOBAL_FLAGS) --preinclude=$(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h'
PANTECH_GLOBAL_FLAGS+=  -include $(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h
PANTECH_SCONS_HEXAGON_FLAGS := '$(PANTECH_GLOBAL_FLAGS)'


PANTECH_SCONS_NO_DEBUG = PANTECH_NO_DEBUG=yes#
PANTECH_USES_NO_DEBUG = USES_NO_DEBUG=yes#


#FEATURE_GOTA_UPGRADE
PANTECH_GLOBAL_FLAGS+= -DGOTA_UPDATE_FILE_TIMESTAMP=$(START_TIME)

