###############################################################################
# 
#                    MSM8X26 PANTECH MODEL config makefile
#
###############################################################################
# 2012-08-08 shpark : Created
###############################################################################

TARGET_BUILD_PROJECT=ef63s
TARGET_BUILD_BOARDVER=tp20
TARGET_PRODUCT_VER=V30

export TARGET_BUILD_PRJ_NAME=$(shell echo $(TARGET_BUILD_PROJECT) | tr a-z A-Z)

export TARGET_BUILD_MODEL_NAME=IM-A910S#
TARGET_BUILD_VER_PREFIX=S0224#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)002#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)003# 2014-02-11 SI-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)004# 2014-02-18 SI-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)005# 2014-02-19 TP10_SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)006# 2014-02-26 TP10_user_SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)007# 2014-02-27 SI-6
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)008# 2014-03-05 SI-7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)009# 2014-03-11 IOT-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)100# 2014-03-13 IOT-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)101# 2014-03-18 SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)102# 2014-03-19 SR-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)103# 2014-03-25 CTS
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)104# 2014-03-27 SR-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)105# 2014-04-02 SR-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)106# 2014-04-07 SR-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)107# 2014-04-11 SR-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)108# 2014-04-15 PP_SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)109# 2014-04-19 SR-7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)110# 2014-04-21 SR-7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)111# 2014-04-23 SR-8
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)112# 2014-04-24 SR-9
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)113# 2014-04-26 SR-10
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)114# 2014-05-12 RC1-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)115# 2014-05-19 RC1-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)116# 2014-05-21 RC1-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)117# 2014-05-23 RC1-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)118# 2014-05-27 RC1-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)119# 2014-06-16 RC2-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)120# 2014-07-01 RC2-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)121# 2014-07-08 RC2-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)122# 14/07/09 RC2-2-re
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)123# 14/07/14 RC2-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)124# 14/07/14 RC2-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)125# 14/08/26 RC3-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)126# 14/10/21 RC4-12
TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)127# 14/11/25 RC4-12
TARGET_BUILD_VERSION_HIDDEN=$(TARGET_BUILD_VERSION)# hidden version
TARGET_BUILD_FS_VER=9# android userdata ext4 filesystem version
TARGET_BUILD_NV_VER=7# mdm efs version
export TARGET_BUILD_CARRIER=SKT-KOR#
TARGET_INTERNAL_SD_PARTITION=26

TARGET_BUILD_BRAND=VEGA
TARGET_BUILD_BRAND_MODEL_NAME=$(TARGET_BUILD_BRAND)_$(TARGET_BUILD_MODEL_NAME)

###############################################################################
# OEM_ environment variable
###############################################################################
# eMMC, sdcard
#    PANTECH_STORAGE_DEFAULT : no internal memory SD card
#    PANTECH_STORAGE_INTERNAL_EMUL : emulated primary volume
#    PANTECH_STORAGE_INTERNAL_FAT : primary volume is FAT
PANTECH_STORAGE_USE_TYPE=PANTECH_STORAGE_INTERNAL_FAT

PANTECH_GLOBAL_FLAGS= -DPROJECT_NAME=\"$(TARGET_BUILD_PROJECT)\"
PANTECH_GLOBAL_FLAGS+= -DPROJECT_NAME_UPPER=\"$(TARGET_BUILD_PRJ_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DMODEL_NAME=\"$(TARGET_BUILD_MODEL_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_VER=\"$(TARGET_BUILD_VERSION)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_FS_VER=$(TARGET_BUILD_FS_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_EFS_VER=$(TARGET_BUILD_NV_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BOARD_VER=$(TARGET_BUILD_BOARDVER)
PANTECH_GLOBAL_FLAGS+= -DMSM8974_$(TARGET_PRODUCT_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_PRELOAD_CHECKSUM=444693969
#PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_CARRIER=$(TARGET_BUILD_CARRIER)

PANTECH_KERNEL_FLAGS:=$(PANTECH_GLOBAL_FLAGS)

PANTECH_GLOBAL_FLAGS+= -DT_$(TARGET_BUILD_PRJ_NAME)

PANTECH_GLOBAL_FLAGS+= -DT_BUILD_USER
PANTECH_GLOBAL_FLAGS+= -DFEATURE_AARM_RELEASE_MODE


# PANTECH_SECBOOT
ifeq ($(CMD_V_SECURE_BOOT),enable)
PANTECH_GLOBAL_FLAGS+= -DFEATURE_PANTECH_SEC_BUILD
endif

PANTECH_GLOBAL_FLAGS+= -I$(PANTECH_BUILD_SYSTEM)
PANTECH_SCONS_FLAGS := '$(PANTECH_GLOBAL_FLAGS) --preinclude=$(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h'
PANTECH_GLOBAL_FLAGS+=  -include $(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h
PANTECH_SCONS_HEXAGON_FLAGS := '$(PANTECH_GLOBAL_FLAGS)'


PANTECH_SCONS_NO_DEBUG = PANTECH_NO_DEBUG=yes#
PANTECH_USES_NO_DEBUG = USES_NO_DEBUG=yes#


#FEATURE_GOTA_UPGRADE
PANTECH_GLOBAL_FLAGS+= -DGOTA_UPDATE_FILE_TIMESTAMP=$(START_TIME)

