package org.chromium.ui.clipboard; 

import android.content.Context;
import android.view.MenuItem;
import java.lang.reflect.Constructor;

public class VegaClipBoardController {

  VegaClipBoardInterface mClipboard;

  public interface ActionHandler {
    boolean onPasteText(String text);
  }

  public VegaClipBoardController(Context context) {
  	createVegaClipBoardInstance(context, null);
  }	

  public VegaClipBoardController(Context context, VegaClipBoardController.ActionHandler actionHandler) {
  	createVegaClipBoardInstance(context, actionHandler);
  }	

  private void createVegaClipBoardInstance(Context context, VegaClipBoardController.ActionHandler actionHandler) {
       try {       
          Class VClipBoardInterfaceClass = null;	   	
          VClipBoardInterfaceClass = Class.forName("com.pantech.org.chromium.ui.clipboard.VegaClipBoardManager");
          Class[] paramCtor = {Context.class, VegaClipBoardController.ActionHandler.class};			   
          Constructor ctor = VClipBoardInterfaceClass.getConstructor(paramCtor);
          mClipboard = (VegaClipBoardInterface)ctor.newInstance(context, actionHandler);	       
       } catch (ClassNotFoundException e) {   
       } catch (Throwable e) {
       }    
  }  

   public void registerVegaClipBoardPasteListener() {
       if (mClipboard != null) {
          mClipboard.registerVegaClipBoardPasteListener();		  
       }
   }	
   
   public void unregisterVegaClipBoardPasteListener() {
       if (mClipboard != null) {
         mClipboard.unregisterVegaClipBoardPasteListener();	  
       } 		
   }	
   
   public boolean isVegaClipBoardShowing() {
    return (mClipboard != null)  ? mClipboard.isVegaClipBoardShowing() : false;     
   }    

   public void closeVegaClipBoard() {
     if (mClipboard != null) mClipboard.closeVegaClipBoard();     
   }
  
   public void showVegaClipBoard(boolean originalImage,  boolean enalbeImage, VegaClipBoardController.ActionHandler actionHandler) {
    if (mClipboard != null) mClipboard.showVegaClipBoard(false,false, actionHandler);     
   }

   public int getVegaClipDataSize() {
    return (mClipboard != null)  ? mClipboard.getVegaClipDataSize() : 0;     
   }  

   public boolean canVegaClipBoard() {
     return (mClipboard != null)  ? mClipboard.canVegaClipBoard():false;  	
   } 	
}