/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebDevToolsFrontendClient_h
#define WebDevToolsFrontendClient_h

namespace WebKit {

class WebString;
struct WebFloatPoint;
struct WebDevToolsMessageData;

class WebDevToolsFrontendClient {
public:
    WebDevToolsFrontendClient() { }

    virtual void sendMessageToBackend(const WebString&) { }

    virtual void activateWindow() { }
    virtual void changeAttachedWindowHeight(unsigned height) { }
    virtual void closeWindow() { }
    virtual void requestDockWindow() { }
    virtual void requestUndockWindow() { }
    virtual void requestSetDockSide(const WebString& side) { }
    virtual void moveWindowBy(const WebFloatPoint&) { }
    virtual void openInNewTab(const WebString& side) { }
    virtual void save(const WebString& url, const WebString& content, bool saveAs) { }
    virtual void append(const WebString& url, const WebString& content) { }

    virtual void requestFileSystems() { }
    virtual void addFileSystem() { }
    virtual void removeFileSystem(const WebString& fileSystemPath) { }

    virtual void indexPath(int requestId, const WebString& fileSystemPath) { }
    virtual void stopIndexing(int requestId) { }
    virtual void searchInPath(int requestId, const WebString& fileSystemPath, const WebString& query) { }

    virtual bool isUnderTest() { return false; }

protected:
    virtual ~WebDevToolsFrontendClient() {}
};

} // namespace WebKit

#endif
