// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef AW_RENDERER_PLUGINS_PLUGIN_PLACEHOLDER_H_
#define AW_RENDERER_PLUGINS_PLUGIN_PLACEHOLDER_H_

#include "android_webview/renderer/webview_plugin.h"
#include "content/public/common/webplugininfo.h"
#include "content/public/renderer/render_process_observer.h"
#include "content/public/renderer/render_view_observer.h"
#include "third_party/WebKit/public/web/WebPluginParams.h"
#include "webkit/renderer/cpp_bound_class.h"

// Placeholders can be used if a plug-in is missing or not available
// (blocked or disabled).
class PluginPlaceholder : public content::RenderViewObserver,
                          public content::RenderProcessObserver,
                          public webkit_glue::CppBoundClass,
                          public WebViewPlugin::Delegate {
 public:
  // Creates a new WebViewPlugin with a MissingPlugin as a delegate.
  static PluginPlaceholder* CreateMissingPlugin(
      content::RenderView* render_view,
      WebKit::WebFrame* frame,
      const WebKit::WebPluginParams& params);

#if defined(ENABLE_MOBILE_YOUTUBE_PLUGIN)
  // Placeholder for old style embedded youtube video on mobile device. For old
  // style embedded youtube video, it has a url in the form of
  // http://www.youtube.com/v/VIDEO_ID. This placeholder replaces the url with a
  // simple html page and clicking the play image redirects the user to the
  // mobile youtube app.
  static PluginPlaceholder* CreateMobileYoutubePlugin(
       content::RenderView* render_view,
       WebKit::WebFrame* frame,
       const WebKit::WebPluginParams& params);

  // Whether this is a youtube url.
  static bool IsYouTubeURL(const GURL& url, const std::string& mime_type);
#endif

  WebViewPlugin* plugin() { return plugin_; }

 private:
  // |render_view| and |frame| are weak pointers. If either one is going away,
  // our |plugin_| will be destroyed as well and will notify us.
  PluginPlaceholder(content::RenderView* render_view,
                    WebKit::WebFrame* frame,
                    const WebKit::WebPluginParams& params,
                    const std::string& html_data,
                    const string16& title);

  virtual ~PluginPlaceholder();

  // WebViewPlugin::Delegate methods:
  virtual void BindWebFrame(WebKit::WebFrame* frame) OVERRIDE;
  virtual void WillDestroyPlugin() OVERRIDE;
  virtual void ShowContextMenu(const WebKit::WebMouseEvent&) OVERRIDE {};

  // content::RenderProcessObserver methods:
  virtual void PluginListChanged() OVERRIDE;

  // Replace this placeholder with a different plugin (which could be
  // a placeholder again).
  void ReplacePlugin(WebKit::WebPlugin* new_plugin);

  // Hide this placeholder.
  void HidePlugin();

  // Hide the blocked plugin by calling HidePlugin().
  // Takes no arguments, and returns nothing.
  void HideCallback(const webkit_glue::CppArgumentList& args,
                    webkit_glue::CppVariant* result);

  void DidFinishLoadingCallback(const webkit_glue::CppArgumentList& args,
                                webkit_glue::CppVariant* result);

#if defined(ENABLE_MOBILE_YOUTUBE_PLUGIN)
 // Check whether the url is valid.
  static bool IsValidYouTubeVideo(const std::string& path);

  // Opens a youtube app in the current tab.
  void OpenYoutubeUrlCallback(const webkit_glue::CppArgumentList& args,
                              webkit_glue::CppVariant* result);
#endif

  WebKit::WebFrame* frame_;
  WebKit::WebPluginParams plugin_params_;
  WebViewPlugin* plugin_;

  string16 title_;

  DISALLOW_COPY_AND_ASSIGN(PluginPlaceholder);
};

#endif  // AW_RENDERER_PLUGINS_PLUGIN_PLACEHOLDER_H_