// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "android_webview/native/aw_render_thread_watchdog.h"

#include "android_webview/common/render_view_messages.h"
#include "content/public/browser/render_process_host.h"
#include "jni/AwRenderThreadWatchdog_jni.h"

namespace android_webview {
namespace AwRenderThreadWatchdog {

void SendToBrowserHeartbeat() {
  JNIEnv* env = base::android::AttachCurrentThread();
  Java_AwRenderThreadWatchdog_heartBeat(env);   
}

static void SendToRenderIsAlive(JNIEnv* env, jclass obj, jint pid) {
  content::RenderProcessHost* host = content::RenderProcessHost::FromID(pid);
  if (host) {
    host->Send(new AwViewMsg_RenderIsAlive());
  }
}

bool RegisterAwRenderThreadWatchdog(JNIEnv* env) {
  return RegisterNativesImpl(env) >= 0;
}

}  // namespace AwRenderThreadWatchdog
}  // namespa
