#Android makefile for the ipsecdrvtl

LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)

ifeq ($(TARGET_BUILD_CARRIER),LGT-KOR)

MODULE_NAME := ipsecdrvtl
IPSECDRVTL_MODE := CONFIG_IPSECDRVTL=m
IPSECDRVTL_BLD_DIR : = $(LOCAL_PATH)

# DLKM_DIR was moved for JELLY_BEAN (PLATFORM_SDK 16)
ifeq (1,$(filter 1,$(shell echo "$$(( $(PLATFORM_SDK_VERSION) >= 16 ))" )))
       DLKM_DIR := $(TOP)/device/qcom/common/dlkm
else
       DLKM_DIR := build/dlkm
endif

# Build ipsecdrvtl.ko
###########################################################

KBUILD_OPTIONS := IPSECDRVTL_ROOT=$(IPSECDRVTL_BLD_DIR)
KBUILD_OPTIONS += MODNAME=ipsecdrvtl
KBUILD_OPTIONS += $(IPSECDRVTL_MODE)
KBUILD_OPTIONS += PANTECH_ANDROID_MODEL_NAME=$(TARGET_BUILD_MODEL_NAME)
KBUILD_OPTIONS += PANTECH_ANDROID_PLATFORM_VERSION=$(PLATFORM_VERSION)

VERSION=$(shell grep -w "VERSION =" $(TOP)/kernel/Makefile | sed 's/^VERSION = //' )
PATCHLEVEL=$(shell grep -w "PATCHLEVEL =" $(TOP)/kernel/Makefile | sed 's/^PATCHLEVEL = //' )

LOCAL_MODULE              := $(MODULE_NAME).ko
LOCAL_MODULE_TAGS         := eng optional
LOCAL_MODULE_PATH         := $(TARGET_OUT)/lib/modules

include $(DLKM_DIR)/AndroidKernelModule.mk

###########################################################

endif

