package com.pantech.app.test_menu.apps;

import com.pantech.app.test_menu.R;
import android.app.Activity;
import android.content.Context;
import android.graphics.*;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewParent;
import android.widget.TextView; 
import android.content.Intent;
import android.util.Log;

class PictureActLayout extends ViewGroup {
	
    private final Picture mPicture = new Picture();

    public PictureActLayout(Context context) {
        super(context);
    }

    public PictureActLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }    

    @Override
    public void addView(View child) {
        if (getChildCount() > 1) {
            throw new IllegalStateException("PictureActLayout can host only one direct child");
        }

        super.addView(child);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        final int count = getChildCount();

        int maxHeight = 0;
        int maxWidth = 0;

        for (int i = 0; i < count; i++) {
            final View child = getChildAt(i);
            if (child.getVisibility() != GONE) {
                measureChild(child, widthMeasureSpec, heightMeasureSpec);
            }
        }

        maxWidth += getPaddingLeft() + getPaddingRight();
        maxHeight += getPaddingTop() + getPaddingBottom();

        Drawable drawable = getBackground();
        if (drawable != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }

        setMeasuredDimension(resolveSize(maxWidth, widthMeasureSpec),
                resolveSize(maxHeight, heightMeasureSpec));
    }
    
    private void drawPict(Canvas canvas, int x, int y, int w, int h,
                          float sx, float sy) {
        canvas.save();
        canvas.translate(x, y);
        canvas.clipRect(0, 0, w, h);
        canvas.scale(0.5f, 0.5f);
        canvas.scale(sx, sy, w, h);
        canvas.drawPicture(mPicture);
        canvas.restore();
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(mPicture.beginRecording(getWidth(), getHeight()));
        mPicture.endRecording();
        
        int x = getWidth()/2;
        int y = getHeight()/2;
        
        if (false) {
            canvas.drawPicture(mPicture);
        } else {
            drawPict(canvas, 0, 0, x, y,  1,  1);
            drawPict(canvas, x, 0, x, y, -1,  1);
            drawPict(canvas, 0, y, x, y,  1, -1);
            drawPict(canvas, x, y, x, y, -1, -1);
        }
    }

    @Override
    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        location[0] = getLeft();
        location[1] = getTop();
        dirty.set(0, 0, getWidth(), getHeight());
        return getParent();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        final int count = super.getChildCount();

        for (int i = 0; i < count; i++) {
            final View child = getChildAt(i);
            if (child.getVisibility() != GONE) {
                final int childLeft = getPaddingLeft();
                final int childTop = getPaddingTop();
                child.layout(childLeft, childTop,
                        childLeft + child.getMeasuredWidth(),
                        childTop + child.getMeasuredHeight());

            }
        }
    }
}

class GraphicsActActivity extends Activity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void setContentView(View view) {
        if (false) { // set to true to test Picture
            ViewGroup vg = new PictureActLayout(this);
            vg.addView(view);
            view = vg;
        }
        
        super.setContentView(view);
    }
}

public class TouchPanelActTest extends GraphicsActActivity {    

    static int active_back;
    static int touch_count;
    static int block_cnt[];
    private boolean fkeyevent;
    private boolean fboot;

    static String touch_panelact_count;
    static String touch_panelact_line;	
    static String touch_panelact_result;	

    private static final String TAG = "TouchPanelActTest";
    private static final String ACTION_HOLD_STATUS="com.pantech.intent.action.HOLD_STATUS";
		//private static final String ACTION_HOME_STATUS="com.pantech.intent.action.HOME_STATUS";    // p11223_HOME_Key

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(new MyView(this));

    	// Stop Hold key!
        setHoldKey(true);

    	// Stop home key!
    	//Intent homeIntent = new Intent(ACTION_HOME_STATUS);  // mirinae_testmode
    	//homeIntent.putExtra("callSet","TRUE");
    	//sendBroadcast(homeIntent);

        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setDither(true);
        mPaint.setColor(Color.WHITE);
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeJoin(Paint.Join.ROUND);
        mPaint.setStrokeCap(Paint.Cap.ROUND);
        mPaint.setStrokeWidth(2);

        touch_panelact_count = getString(R.string.touch_panelact_count);
        touch_panelact_line = getString(R.string.touch_panelact_line);
        touch_panelact_result = getString(R.string.touch_panelact_result);

        active_back = 0;
        touch_count = 0;

	block_cnt = new int [5]; 
		
        for(int i=0; i<5; i++)
        	block_cnt[i]=0;
        fkeyevent = false;
        fboot = true;
    }

    public void onDestroy(){
    	super.onDestroy();

	//Start Hold key!
        setHoldKey(false);

	// Start home key!
	//Intent homeIntent = new Intent(ACTION_HOME_STATUS);      // p11223_HOME_Key
	//homeIntent.putExtra("callSet","FALSE");
	//sendBroadcast(homeIntent);

    }

    public void onResume(){
	super.onResume();
	
	// Stop Hold key!
        setHoldKey(true);

	// Stop home key!
	//Intent homeIntent = new Intent(ACTION_HOME_STATUS);     // p11223_HOME_Key
	//homeIntent.putExtra("callSet","TRUE");
	//sendBroadcast(homeIntent);

    }

    public void onPause(){
	super.onPause();
	
	//Start Hold key!
        setHoldKey(false);

	// Start home key!
	//Intent homeIntent = new Intent(ACTION_HOME_STATUS);      // p11223_HOME_Key
	//homeIntent.putExtra("callSet","FALSE");
	//sendBroadcast(homeIntent);
    }
    
    private Paint       mPaint;
    private String codeName;
    
    public void colorChanged(int color) {
        mPaint.setColor(color);
    }
    
    public boolean onKeyDown( int keyCode, KeyEvent event )
    {
        codeName = "KEY_UNKNOWN";

/*
        if(keyCode == KeyEvent.KEYCODE_BACK)
        {
        	super.onKeyDown(keyCode, event);
        	return true;
        }
*/
        switch(keyCode)
        {
                case KeyEvent.KEYCODE_MENU:
                        codeName = "KEY_MENU";
                        block_cnt[1]++;
                        touch_count++;
                        fkeyevent = true;
                        fboot = false;
                        break;
                /*
                case KeyEvent.KEYCODE_HOME:
                        codeName = "KEY_HOME";
                        block_cnt[2]++;
                        touch_count++;
                        fkeyevent = true;
                        fboot = false;
                        break;
                */        
                case KeyEvent.KEYCODE_BACK:
                        if(active_back == 1){
                            super.onKeyDown(keyCode, event);
                            fkeyevent = false;
                        }    
                        else{
                            codeName = "KEY_BACK";
                            block_cnt[2]++;
                            touch_count++;
                            fkeyevent = true;
                            fboot = false;
                        }    
                    	break;
                case KeyEvent.KEYCODE_VOLUME_UP:
                case KeyEvent.KEYCODE_VOLUME_DOWN:
                case KeyEvent.KEYCODE_SEARCH:
//                case KeyEvent.KEYCODE_HOLD:
                case KeyEvent.KEYCODE_HOME:    
                        setContentView(new ResultTextView(this));
                        active_back = 1;
                        fkeyevent = false;
                        break;
        }

        if(fkeyevent)
        {
            codeName = "Touch count: " + (int)touch_count + "  [" + codeName + "]";
            TextView tv = new TextView(this);
        	tv.setText(codeName);

        	setContentView(tv);
        	setContentView(new MyView(this));
        }    
        return true;
    }

    public static class ResultTextView extends View {
    	
        // 
        public ResultTextView(Context context) {
        	super(context);
        	setBackgroundColor(Color.BLACK);
        }
        
        // ׸
        protected void onDraw(Canvas canvas) {
        	// Ʈ ü 
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            
            int line=0;
            int success_total =0;
            final int line_step =40;
            String text;
            
            line += line_step;
            paint.setColor(Color.YELLOW);
    	 paint.setTextSize(30);
            canvas.drawText(touch_panelact_count, 10, line, paint); // ؽƮ ǥ
            line += line_step;	        
            canvas.drawText(touch_panelact_line, 10, line, paint); // ؽƮ ǥ
            
            paint.setColor(Color.WHITE);
            for(int i=0; i<3; i++)
            {
    		String result_count;
            	success_total += block_cnt[i];
            	line += line_step;

    		if(i==1)
    		 	result_count = "[MENU]" + "   " + block_cnt[i];
                /*
    		else if(i==2)
            		result_count = "[HOME]" + "   " + block_cnt[i];
            	*/	
    		else if(i==2)
            		result_count = "[BACK]" + "   " + block_cnt[i];
    		else
            		result_count = "[WINDOW AREA]" + "   " + block_cnt[i];
            	canvas.drawText(result_count, 10, line, paint); // ؽƮ ǥ
            }	
            
            paint.setColor(Color.YELLOW);
            line += line_step;
            canvas.drawText(touch_panelact_line, 10, line, paint); // ؽƮ ǥ
            line += line_step;
            
            paint.setColor(Color.WHITE);
            String result_per = touch_panelact_result + " " + 
            	success_total;
            canvas.drawText(result_per, 10, line, paint); // ؽƮ ǥ
        }	    
        
    }

    public class MyView extends View {       
        private Bitmap  mBitmap;
        private Canvas  mCanvas;
        private Path    mPath;
        private float     startx, starty;
        
        public MyView(Context c) {
            super(c);
            
            mBitmap = Bitmap.createBitmap(320, 480, Bitmap.Config.ARGB_8888);
            mCanvas = new Canvas(mBitmap);
            mPath = new Path();
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
        }
        
        @Override
        protected void onDraw(Canvas canvas) {
            canvas.drawColor(Color.BLACK);
            canvas.drawPath(mPath, mPaint);
            
            String strDraw;
            Paint  textPaint = new Paint();
            textPaint.setAntiAlias(true);
            textPaint.setDither(true);
            textPaint.setColor(Color.WHITE);
            textPaint.setStyle(Paint.Style.STROKE);
            textPaint.setStrokeJoin(Paint.Join.ROUND);
            textPaint.setStrokeCap(Paint.Cap.ROUND);
            textPaint.setStrokeWidth(1);
            
            if(fkeyevent == true)
            {
            	strDraw = new String(codeName);
            }
            else{
                strDraw = new String("Touch count: " + (int)touch_count + "  [" + "X:" + (int)mX + " Y:"+ (int)mY + "]");
            }    
            
            canvas.drawText(strDraw, 10, 20, textPaint);
            if(fkeyevent == false && fboot == false)
                canvas.drawCircle(startx, starty, 1, mPaint);
        }

        private float mX, mY;
        private static final float TOUCH_TOLERANCE = 4;
        
        private void touch_start(float x, float y) {
            mPath.reset();
            mPath.moveTo(x, y);
            mX = x;
            mY = y;
        }
        private void touch_move(float x, float y) {
            float dx = Math.abs(x - mX);
            float dy = Math.abs(y - mY);
            if (dx >= TOUCH_TOLERANCE || dy >= TOUCH_TOLERANCE) {
                mPath.quadTo(mX, mY, (x + mX)/2, (y + mY)/2);
                mX = x;
                mY = y;
            }
        }
        private void touch_up() {
            mPath.lineTo(mX, mY);
            // commit the path to our offscreen
            mCanvas.drawPath(mPath, mPaint);
            // kill this so we don't double draw
            //mPath.reset();
        }
        
        @Override
        public boolean onTouchEvent(MotionEvent event) {
 //           float x = event.getX();
 //           float y = event.getY();
            float x = event.getRawX();
            float y = event.getRawY();
            
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    touch_start(x, y);
                    startx = x;
                    starty = y;
                    touch_count++;
                    block_cnt[0]++;
                    fkeyevent = false;
                    fboot = false;
                    invalidate();
                    break;
                case MotionEvent.ACTION_MOVE:
                    touch_move(x, y);
                    invalidate();
                    break;
                case MotionEvent.ACTION_UP:
                    touch_up();
                    invalidate();
                    break;
            }
            return true;
        }
    }

    private void setHoldKey(boolean flag) {
        Intent intent = new Intent();

        intent.setAction(ACTION_HOLD_STATUS);
        
        if(flag) {
              // Event Ѱ ޶.
              intent.putExtra("callSet", "TRUE");
        }
        else {
              // Event ̻ ѱ ƶ.
             intent.putExtra("callSet", "FALSE");
        }
        
        // Event û/  ü .
        intent.putExtra("TAG",TAG);
        sendBroadcast(intent);

    }
}



