package com.pantech.providers.lgucallmsgsettings;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.util.Log;

public class LGUCallMsgBlockNumberProvider extends ContentProvider {
	
    private static final String TAG = "LGUCallMsgBlockNumberProvider";

    private static final String DATABASE_NAME = "callmsgblocknumber.db";
    private static final int DATABASE_VERSION = 1;
    
    public interface Tables {
        public static final String BLOCK_TABLE = "callmsgblocknumber";
    }

	private static final int BLOCK_NUMBER_ID = 1;
	private static final int BLOCK_NAMES = 2;
    private static final int BLOCK_NUMBERS = 3;
    
    private static final UriMatcher uriMatcher;
    static {
	    uriMatcher = new UriMatcher(UriMatcher.NO_MATCH);
	    uriMatcher.addURI(LGUCallMsgBlockNumber.AUTHORITY, "callmsgblocknumber", BLOCK_NUMBERS);
	    uriMatcher.addURI(LGUCallMsgBlockNumber.AUTHORITY, "callmsgblocknumber/#", BLOCK_NUMBER_ID);
    }
    
    private SQLiteDatabase callmsgblocknumberDB;
    
	@Override
	public boolean onCreate() {
		Context context = getContext();
		  
		CallMsgBlockNumberDatabseHelper dbHelper;
	    dbHelper = new CallMsgBlockNumberDatabseHelper(context, DATABASE_NAME, null, DATABASE_VERSION);
	    callmsgblocknumberDB = dbHelper.getWritableDatabase();
	    return (callmsgblocknumberDB == null) ? false : true;
	}

	@Override
	public String getType(Uri url) {
		int match = uriMatcher.match(url);
		switch(match) {
			case BLOCK_NUMBERS:
				return "vnd.android.cursor.dir/callmsgblocknumber";
			case BLOCK_NUMBER_ID:
				return "vnd.android.cursor.item/callmsgblocknumber";
			default:
                throw new IllegalArgumentException("Unknown URL " + url);
		}
	}
	
	private String getTableName(Uri url) {
		switch(uriMatcher.match(url)) {
			case BLOCK_NUMBERS:
			case BLOCK_NUMBER_ID:
				return Tables.BLOCK_TABLE;

			default:
	            throw new IllegalArgumentException("Unknown URL " + url);		
		}
	}

	@Override
	public Uri insert(Uri uri, ContentValues values) {
		String table = getTableName(uri);
 		
 		long rowID = callmsgblocknumberDB.insert(table, "", values);

 		if (rowID > 0){
 			Uri _uri = ContentUris.withAppendedId(uri, rowID);
 			getContext().getContentResolver().notifyChange(_uri, null);
 			return _uri;
 		}
 		throw new SQLException("Failed to insert row into " + uri);
	}
	
	@Override
	public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count = 0;
        String table = getTableName(uri);
        if(selection.isEmpty()) {
        	// delete all rows
        	count = callmsgblocknumberDB.delete(table, null, null);
        } else {
        	count = callmsgblocknumberDB.delete(table, selection, selectionArgs);
        }        
        return count;
	}
	
	@Override
	public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
		String table = getTableName(uri);
		int count = callmsgblocknumberDB.update(table, values, selection, selectionArgs);
		if(count > 0) {
			getContext().getContentResolver().notifyChange(uri, null);			
		}
		return count;
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
		SQLiteQueryBuilder sqlBuilder = new SQLiteQueryBuilder();
		sqlBuilder.setTables(getTableName(uri));
		Cursor c = sqlBuilder.query(callmsgblocknumberDB, projection, selection, selectionArgs, null, null, sortOrder);
		c.setNotificationUri(getContext().getContentResolver(), uri);
		return c;
	}
	
	public class CallMsgBlockNumberDatabseHelper extends SQLiteOpenHelper {

		public CallMsgBlockNumberDatabseHelper(Context context, String name,
				CursorFactory factory, int version) {
			super(context, name, factory, version);
			Log.d("YDING", "database helper instance created");
		}

		@Override
		public void onCreate(SQLiteDatabase db) {
			db.execSQL("create table " + Tables.BLOCK_TABLE + " (" 
				      + LGUCallMsgBlockNumber.KEY_ID + " integer primary key autoincrement, "
				      + LGUCallMsgBlockNumber.KEY_NUMBER + " TEXT, "
					  + LGUCallMsgBlockNumber.KEY_NAME + " TEXT);");

		}

		@Override
		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
	    	Log.w(TAG, "Upgrading database from version " + oldVersion + " to "
	                  + newVersion + ", which will destroy all old data");
	    	db.execSQL("DROP TABLE IF EXISTS " + Tables.BLOCK_TABLE);
	    	
	    	onCreate(db);
		}
		
		@Override
		public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
	    	Log.w(TAG, "Downgrading database from version " + oldVersion + " to "
	                  + newVersion + ", which will destroy all old data");			
	    	db.execSQL("DROP TABLE IF EXISTS " + Tables.BLOCK_TABLE);
	    	
	    	onCreate(db);
		}
	}
}
