/**
 * The skeleton code demonstrates how to implement
 * your own Overlay class by overriding the draw
 * and onTap handlers.
 */

package com.pantech.providers.lgucallmsgsettings;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.provider.Settings.SettingNotFoundException;

public class LGUCallMsgSettings
{	
	public static final String AUTHORITY 						= "callmsgsettings";

	public static final Uri CONTENT_URI 						= Uri.parse("content://"+ AUTHORITY + "/lgucallmsgsettings");


	// Column Names
	public static final String	KEY_ID 						= "_id";
	public static final String	KEY_NAME 					= "_name";
	public static final String	KEY_VALUE 					= "_value";
	
	public static final String	CALL_MSG_BLOCK				= "call_msg_block";										
	public static final int   	CALL_MSG_BLOCK_DEFAULT		= 0;	
	
    public synchronized static String getString(ContentResolver cr, String name) 
    {	
    	String	strTemp;
    	String  strValue = null;    	
    	Cursor 	cur = cr.query(LGUCallMsgSettings.CONTENT_URI, null, null, null, null);    	
    	
    	if (cur == null)
    		return null;
    	
    	cur.moveToFirst();
    	
    	do {
    		strTemp = cur.getString(cur.getColumnIndex(KEY_NAME));    		
    		if (strTemp.equalsIgnoreCase(name) == true)
    			break;
    		
    		if (cur.isLast() == true) {
    	    	if (cur != null)
    	    		cur.close();

    			return null;
    		}
    	} while (cur.moveToNext());  
    	
    	strValue = cur.getString(cur.getColumnIndex(KEY_VALUE));
    	
    	if (cur != null)
    		cur.close();
    	
    	return strValue;
    }

    public static int getInt(ContentResolver cr, String name)
    	throws SettingNotFoundException 
	{
    	String v = getString(cr, name);
    	try {
    			return Integer.parseInt(v);
    	} catch (NumberFormatException e) { 
    		throw new SettingNotFoundException(name);
    	}
    } 
    
    public synchronized static boolean putString(ContentResolver cr, String name, String value) 
    {	
    	String 				where;
    	
    	where = KEY_NAME + "= '" + name + "'";
    	
        try {
            ContentValues values = new ContentValues();
            values.put(KEY_NAME, name);
            values.put(KEY_VALUE, value);          
            cr.update(LGUCallMsgSettings.CONTENT_URI, values, where, null);
            
            return true;
        } catch (SQLException e) {            
            return false;
        }    	

    }

    public static boolean putInt(ContentResolver cr, String name, int value) 
    {
    	return putString(cr, name, Integer.toString(value));
    }    
}
