###############################################################################
# 
#                    MSM8X26 PANTECH MODEL config makefile
#
###############################################################################
# 2012-08-08 shpark : Created
###############################################################################

TARGET_BUILD_PROJECT=ef63l#
export TARGET_BUILD_PRJ_NAME=$(shell echo $(TARGET_BUILD_PROJECT) | tr a-z A-Z)

ifeq ($(TARGET_BUILD_PROJECT),ef63l)
export TARGET_BUILD_MODEL_NAME=IM-A910L#
TARGET_BUILD_VER_PREFIX=S1239#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)001#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)006# 2014-02-26 SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)007# 2014-02-27 SI3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)008# 2014-03-04 SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)009# 2014-03-06 SI-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)100# 2014-03-10 SI-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)101# 2014-03-17 SMT TP20
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)102# 2014-03-18 SMT TP20
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)103# 2014-03-19 SR-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)104# 2014-03-26 SR-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)105# 2014-03-31 SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)106# 2014-04-01 TP20_SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)107# 2014-04-01 SR3&IOT2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)108# 2014-04-07 SR4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)109# 2014-04-08 IOT-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)110# 2014-04-11 SR5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)111# 2014-04-15 TP20 PP SMT
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)112# 2014-04-16 SR6
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)113# 2014-04-19 SR7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)114# 2014-04-23 SR8
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)115# 14/05/07 SR-9
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)116# 14/05/12 SR-10
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)117# 14/05/14 SR-11
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)118# 14/05/15 SR-12_IOT-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)119# 14/05/? RC-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)120# 14/06/12 RC1-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)121# 14/06/18 RC1-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)122# 14/07/08 RC1-4
TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)123# 14/07/09 RC1-5
TARGET_BUILD_VERSION_HIDDEN=$(TARGET_BUILD_VERSION)# hidden version
TARGET_BUILD_FS_VER=7# android userdata ext4 filesystem version
TARGET_BUILD_NV_VER=6# mdm efs version
export TARGET_BUILD_CARRIER=LGT-KOR#
TARGET_INTERNAL_SD_PARTITION=26
endif



TARGET_BUILD_BRAND=VEGA
TARGET_BUILD_BRAND_MODEL_NAME=$(TARGET_BUILD_BRAND)_$(TARGET_BUILD_MODEL_NAME)

###############################################################################
# OEM_ environment variable
###############################################################################
# eMMC, sdcard
#    PANTECH_STORAGE_DEFAULT : no internal memory SD card
#    PANTECH_STORAGE_INTERNAL_EMUL : emulated primary volume
#    PANTECH_STORAGE_INTERNAL_FAT : primary volume is FAT
PANTECH_STORAGE_USE_TYPE=PANTECH_STORAGE_INTERNAL_FAT

PANTECH_GLOBAL_FLAGS= -DPROJECT_NAME=\"$(TARGET_BUILD_PROJECT)\"
PANTECH_GLOBAL_FLAGS+= -DPROJECT_NAME_UPPER=\"$(TARGET_BUILD_PRJ_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DMODEL_NAME=\"$(TARGET_BUILD_MODEL_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_VER=\"$(TARGET_BUILD_VERSION)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_FS_VER=$(TARGET_BUILD_FS_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_EFS_VER=$(TARGET_BUILD_NV_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BOARD_VER=tp20
PANTECH_GLOBAL_FLAGS+= -DMSM8974_V30
PANTECH_GLOBAL_FLAGS+= -DPANTECH_PRELOAD_CHECKSUM=2790427170
#PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_CARRIER=$(TARGET_BUILD_CARRIER)

PANTECH_KERNEL_FLAGS:=$(PANTECH_GLOBAL_FLAGS)

PANTECH_GLOBAL_FLAGS+= -DT_$(TARGET_BUILD_PRJ_NAME)
PANTECH_GLOBAL_FLAGS+= -DT_BUILD_USER
PANTECH_GLOBAL_FLAGS+= -DFEATURE_AARM_RELEASE_MODE

# PANTECH_SECBOOT
ifeq ($(CMD_V_SECURE_BOOT),enable)
PANTECH_GLOBAL_FLAGS+= -DFEATURE_PANTECH_SEC_BUILD
endif

PANTECH_GLOBAL_FLAGS+= -I$(PANTECH_BUILD_SYSTEM)
PANTECH_SCONS_FLAGS := '$(PANTECH_GLOBAL_FLAGS) --preinclude=$(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h'
PANTECH_GLOBAL_FLAGS+=  -include $(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h
PANTECH_SCONS_HEXAGON_FLAGS := '$(PANTECH_GLOBAL_FLAGS)'

ifeq ($(TARGET_BUILD_JTAGSYM),disable)
PANTECH_SCONS_NO_DEBUG = PANTECH_NO_DEBUG=yes#
PANTECH_USES_NO_DEBUG = USES_NO_DEBUG=yes#
else
PANTECH_SCONS_NO_DEBUG = PANTECH_NO_DEBUG=no#
PANTECH_USES_NO_DEBUG =#
endif

#FEATURE_GOTA_UPGRADE
PANTECH_GLOBAL_FLAGS+= -DGOTA_UPDATE_FILE_TIMESTAMP=$(START_TIME)

