###############################################################################
# 
#                    MSM8X26 PANTECH MODEL config makefile
#
###############################################################################
# 2012-08-08 shpark : Created
###############################################################################


TARGET_BUILD_PROJECT=ef60s
TARGET_BUILD_BOARDVER=tp20
TARGET_PRODUCT_VER=V23

export TARGET_BUILD_PRJ_NAME=$(shell echo $(TARGET_BUILD_PROJECT) | tr a-z A-Z)

export TARGET_BUILD_MODEL_NAME=IM-A900S#
TARGET_BUILD_VER_PREFIX=S0223#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)205#
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)206# 2014-02-19 SR-6
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)207# 2014-02-24 SR-7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)208# 2014-02-27 SR-8
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)209# 2014-02-27 SR-9
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)210# 2014-03-04 SR-10
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)211# 2014-03-11 SR-11
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)212# 2014-03-17 SR-12
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)213# 2014-03-20 SR-13
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)214# 2014-03-25 SR-14
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)215# 2014-03-27 SR-15
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)216# 2014-04-14 RC-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)217# 2014-04-21 RC-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)218# 2014-04-25 RC-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)219# 2014-04-28 RC-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)220# 2014-05-19 RC2-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)221# 2014-06-25 RC2-2
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)222# 2014-07-04 RC2-3
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)223# 14/08/13 RC2-4
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)224# 14/09/03 RC2-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)225# 14/09/04 RC2-5
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)226# 14/09/16 RC2-7
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)227# 14/09/17 RC2-8
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)228# 14/09/22 
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)229# 14/10/20 RC3-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)230# 14/11/03 RC4-1
#TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)231# 14/11/10 RC4-2
TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)232# 14/11/24 RC5-1
TARGET_BUILD_VERSION_HIDDEN=$(TARGET_BUILD_VERSION)# hidden version
TARGET_BUILD_FS_VER=0x0B# android userdata ext4 filesystem version
TARGET_BUILD_NV_VER=11# mdm efs version
export TARGET_BUILD_CARRIER=SKT-KOR#
TARGET_INTERNAL_SD_PARTITION=26

TARGET_BUILD_BRAND=VEGA
TARGET_BUILD_BRAND_MODEL_NAME=$(TARGET_BUILD_BRAND)_$(TARGET_BUILD_MODEL_NAME)

###############################################################################
# OEM_ environment variable
###############################################################################
# eMMC, sdcard
#    PANTECH_STORAGE_DEFAULT : no internal memory SD card
#    PANTECH_STORAGE_INTERNAL_EMUL : emulated primary volume
#    PANTECH_STORAGE_INTERNAL_FAT : primary volume is FAT
PANTECH_STORAGE_USE_TYPE=PANTECH_STORAGE_INTERNAL_FAT

PANTECH_GLOBAL_FLAGS= -DPROJECT_NAME=\"$(TARGET_BUILD_PROJECT)\"
PANTECH_GLOBAL_FLAGS+= -DPROJECT_NAME_UPPER=\"$(TARGET_BUILD_PRJ_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DMODEL_NAME=\"$(TARGET_BUILD_MODEL_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_VER=\"$(TARGET_BUILD_VERSION)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_FS_VER=$(TARGET_BUILD_FS_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_EFS_VER=$(TARGET_BUILD_NV_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BOARD_VER=$(TARGET_BUILD_BOARDVER)
PANTECH_GLOBAL_FLAGS+= -DMSM8974_$(TARGET_PRODUCT_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_PRELOAD_CHECKSUM=1085921329
#PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_CARRIER=$(TARGET_BUILD_CARRIER)

PANTECH_KERNEL_FLAGS:=$(PANTECH_GLOBAL_FLAGS)

PANTECH_GLOBAL_FLAGS+= -DT_$(TARGET_BUILD_PRJ_NAME)

PANTECH_GLOBAL_FLAGS+= -DT_BUILD_USER
PANTECH_GLOBAL_FLAGS+= -DFEATURE_AARM_RELEASE_MODE


# PANTECH_SECBOOT
ifeq ($(CMD_V_SECURE_BOOT),enable)
PANTECH_GLOBAL_FLAGS+= -DFEATURE_PANTECH_SEC_BUILD
endif

PANTECH_GLOBAL_FLAGS+= -I$(PANTECH_BUILD_SYSTEM)
PANTECH_SCONS_FLAGS := '$(PANTECH_GLOBAL_FLAGS) --preinclude=$(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h'
PANTECH_GLOBAL_FLAGS+=  -include $(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h
PANTECH_SCONS_HEXAGON_FLAGS := '$(PANTECH_GLOBAL_FLAGS)'


PANTECH_SCONS_NO_DEBUG = PANTECH_NO_DEBUG=yes#
PANTECH_USES_NO_DEBUG = USES_NO_DEBUG=yes#


#FEATURE_GOTA_UPGRADE
PANTECH_GLOBAL_FLAGS+= -DGOTA_UPDATE_FILE_TIMESTAMP=$(START_TIME)

