###############################################################################
# 
#                    MSM8X26 PANTECH MODEL config makefile
#
###############################################################################
# 2012-08-08 shpark : Created
###############################################################################

TARGET_BUILD_PROJECT=ef59l#
export TARGET_BUILD_PRJ_NAME=$(shell echo $(TARGET_BUILD_PROJECT) | tr a-z A-Z)


ifeq ($(TARGET_BUILD_PROJECT),ef59l)
export TARGET_BUILD_MODEL_NAME=IM-A890L#
TARGET_BUILD_VER_PREFIX=S1237#
TARGET_BUILD_VERSION=$(TARGET_BUILD_VER_PREFIX)219#
#2.19...2014-10-31 version up RC1-SR9 / IOT-1
#2.18...2014-10-28 version up RC1-SR8
#2.17...2014-10-27 version up RC1-SR7
#2.16...2014-10-23 version up RC1-SR6
#2.15...2014-10-17 version up RC1-SR5
#2.14...2014-10-07 version up RC1-SR4
#2.13...2014-09-29 version up RC1-SR3
#2.12...2014-06-24 version up RC1-SR2
#2.11...2014-06-10 version up RC1-SR1
#2.10...2014-05-13 version up SR-12 / IOT-3
#2.09...2014-04-30 version up SR-11
#2.08...2014-04-28 version up SR-10
#2.07...2014-04-25 version up SR-9
#2.06...2014-04-18 version up SR-8
#2.05...2014-04-14 version up SR-7 / IOT-2
#2.04...2014-04-08 version up SR-6
#2.03...2014-04-01 version up SR-5 / IOT-1
#2.02...2014-03-24 version up SR-4
#2.01...2014-03-17 version up SR-3
#2.00...2014-03-05 version up SR-2
#1.51...2014-02-28 version up SR-1
TARGET_BUILD_VERSION_HIDDEN=$(TARGET_BUILD_VERSION)# hidden version
TARGET_BUILD_FS_VER=9# android userdata ext4 filesystem version
TARGET_BUILD_NV_VER=0x09# mdm efs version
export TARGET_BUILD_CARRIER=LGT-KOR#
TARGET_INTERNAL_SD_PARTITION=26
endif

TARGET_BUILD_BRAND=VEGA
TARGET_BUILD_BRAND_MODEL_NAME=$(TARGET_BUILD_BRAND)_$(TARGET_BUILD_MODEL_NAME)

###############################################################################
# OEM_ environment variable
###############################################################################
# eMMC, sdcard
#    PANTECH_STORAGE_DEFAULT : no internal memory SD card
#    PANTECH_STORAGE_INTERNAL_EMUL : emulated primary volume
#    PANTECH_STORAGE_INTERNAL_FAT : primary volume is FAT
PANTECH_STORAGE_USE_TYPE=PANTECH_STORAGE_INTERNAL_FAT

PANTECH_GLOBAL_FLAGS= -DPROJECT_NAME=\"$(TARGET_BUILD_PROJECT)\"
PANTECH_GLOBAL_FLAGS+= -DPROJECT_NAME_UPPER=\"$(TARGET_BUILD_PRJ_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DMODEL_NAME=\"$(TARGET_BUILD_MODEL_NAME)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_VER=\"$(TARGET_BUILD_VERSION)\"
PANTECH_GLOBAL_FLAGS+= -DPANTECH_FS_VER=$(TARGET_BUILD_FS_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_EFS_VER=$(TARGET_BUILD_NV_VER)
PANTECH_GLOBAL_FLAGS+= -DPANTECH_BOARD_VER=tp20
PANTECH_GLOBAL_FLAGS+= -DMSM8974_V22
PANTECH_GLOBAL_FLAGS+= -DPANTECH_PRELOAD_CHECKSUM=1376558170
#PANTECH_GLOBAL_FLAGS+= -DPANTECH_BUILD_CARRIER=$(TARGET_BUILD_CARRIER)

PANTECH_KERNEL_FLAGS:=$(PANTECH_GLOBAL_FLAGS)

PANTECH_GLOBAL_FLAGS+= -DT_$(TARGET_BUILD_PRJ_NAME)
PANTECH_GLOBAL_FLAGS+= -DT_BUILD_USER
PANTECH_GLOBAL_FLAGS+= -DFEATURE_AARM_RELEASE_MODE

# PANTECH_SECBOOT
ifeq ($(CMD_V_SECURE_BOOT),enable)
PANTECH_GLOBAL_FLAGS+= -DFEATURE_PANTECH_SEC_BUILD
endif

PANTECH_GLOBAL_FLAGS+= -I$(PANTECH_BUILD_SYSTEM)
PANTECH_SCONS_FLAGS := '$(PANTECH_GLOBAL_FLAGS) --preinclude=$(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h'
PANTECH_GLOBAL_FLAGS+=  -include $(PANTECH_BUILD_SYSTEM)/CUST_PANTECH.h
PANTECH_SCONS_HEXAGON_FLAGS := '$(PANTECH_GLOBAL_FLAGS)'

ifeq ($(TARGET_BUILD_JTAGSYM),disable)
PANTECH_SCONS_NO_DEBUG = PANTECH_NO_DEBUG=yes#
PANTECH_USES_NO_DEBUG = USES_NO_DEBUG=yes#
else
PANTECH_SCONS_NO_DEBUG = PANTECH_NO_DEBUG=no#
PANTECH_USES_NO_DEBUG =#
endif

#FEATURE_GOTA_UPGRADE
PANTECH_GLOBAL_FLAGS+= -DGOTA_UPDATE_FILE_TIMESTAMP=$(START_TIME)

