//=============================================================================
// File       : T3900_rf_ctrl500.c
//
// Description: 
//
// Revision History:
//
// Version         Date           Author        Description of Changes
//-----------------------------------------------------------------------------
//  1.0.0       2009/xx/xx       INC Tech       Draft
//  1.1.0       2009/04/28       yschoi         Android Porting
//  1.2.0       2010/07/30       wgyoo          T3900 porting
//=============================================================================

#include <linux/kernel.h>

#include "../tdmb_comdef.h"

#include "t3a00_includes.h"


extern PLL_MODE m_ucPLL_Mode;

static INC_UINT32 g_uiKOREnsembleFullFreq[MAX_KOREABAND_FULL_CHANNEL] = 
{
	175280,177008,178736,
	181280,183008,184736,
	187280,189008,190736,
	193280,195008,196736,
	199280,201008,202736,
	205280,207008,208736,
	211280,213008,214736
};

static INC_UINT32 g_uiKOREnsembleNormalFreq[MAX_KOREABAND_NORMAL_CHANNEL] = 
{
	181280,183008,184736,
	205280,207008,208736
};
#if 0
static INC_UINT32 g_uiBandIIIEnsemblVal[MAX_BAND_III_CHANNEL] = 
{
	174928,176640,178352,180064,181936,
	183648,185360,187072,188928,190640,
	192352,194064,195936,197648,199360,
	201072,202928,204640,206352,208064,
	209936,211648,213360,215072,210096,
	216928,218640,220352,222064,217088,
	223936,225648,227360,229072,224096,
	230784,232496,234208,235776,237488,
	239200,
};

static INC_UINT32 g_uiLBandEnsemblVal[MAX_L_BAND_CHANNEL] = 
{
	1452960,1454672,1456384,1458096,1459808,
	1461520,1463232,1464944,1466656,1468368,
	1470080,1471792,1473504,1475216,1476928,
	1478640,1480352,1482064,1483776,1485488,
	1487200,1488912,1490624
};

static INC_UINT32 g_uiChinaEnsemblVal[MAX_CHINA_CHANNEL] = 
{
	168160,169872,171584,173296,175008,
	176720,178432,180144,181856,184160,
	185872,187584,189296,191008,192720,
	194432,196144,197856,200160,201872,
	203584,205296,207008,208720,210432,
	212144,213856,216432,218144,219856,
	221568,
};

static INC_UINT32 g_uiRoamingEnsemblVal[MAX_ROAMING_CHANNEL] = 
{
	217280,219008,220736,223280,225008,
	226736,229280,231008,232736,235280,
	237008, 238736
};
#endif

static INC_UINT8 g_acT3A00KorI2CValue_19200[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
{	//19200KHz 7AK.dat (175.280Mhz)
0x14, 0x01, 0x6A, 0x00, 0xAD, 0x05, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x08, 0x88, 0x77, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 7BK.dat (177.008Mhz)
0x00, 0x01, 0x72, 0x00, 0xAD, 0x18, 0x88, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xF5, 0xF0, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x77, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 7CK.dat (178.736Mhz)
0x10, 0x01, 0x72, 0x00, 0xAD, 0x0B, 0xBB, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x9A, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x96, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 8AK.dat (181.280Mhz)
0x04, 0x01, 0x7A, 0x00, 0xAD, 0x15, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 8BK.dat (183.008Mhz)
0x14, 0x01, 0x7A, 0x00, 0xAD, 0x08, 0x88, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 8CK.dat (184.736Mhz)
0x00, 0x01, 0x82, 0x00, 0xAD, 0x1B, 0xBB, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 9AK.dat (187.280Mhz)
0x18, 0x01, 0x82, 0x00, 0xAD, 0x05, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x55, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 9BK.dat (189.008Mhz)
0x04, 0x01, 0x8A, 0x00, 0xAD, 0x18, 0x88, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x55, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 9CK.dat (190.736Mhz)
0x14, 0x01, 0x8A, 0x00, 0xAD, 0x0B, 0xBB, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xE3, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x55, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 10AK.dat (193.280Mhz)
0x08, 0x01, 0x92, 0x00, 0xAD, 0x15, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 10BK.dat (195.008Mhz)
0x18, 0x01, 0x92, 0x00, 0xAD, 0x08, 0x88, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 10CK.dat (196.736Mhz)
0x04, 0x01, 0x9A, 0x00, 0xAD, 0x1B, 0xBB, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 11AK.dat (199.280Mhz)
0x1C, 0x01, 0x9A, 0x00, 0xAD, 0x05, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 11BK.dat (201.008Mhz)
0x08, 0x01, 0xA2, 0x00, 0xAD, 0x18, 0x88, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 11CK.dat (202.736Mhz)
0x18, 0x01, 0xA2, 0x00, 0xAD, 0x0B, 0xBB, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 12AK.dat (205.280Mhz)
0x0C, 0x01, 0xAA, 0x00, 0xAD, 0x15, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 12BK.dat (207.008Mhz)
0x1C, 0x01, 0xAA, 0x00, 0xAD, 0x08, 0x88, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 12CK.dat (208.736Mhz)
0x00, 0x02, 0x62, 0x00, 0xED, 0x1A, 0x06, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 13AK.dat (211.280Mhz)
0x00, 0x01, 0xBA, 0x00, 0xAD, 0x05, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 13BK.dat (213.008Mhz)
0x0C, 0x01, 0xBA, 0x00, 0xAD, 0x18, 0x88, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x22, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//19200KHz 13CK.dat (214.736Mhz)
0x1C, 0x01, 0xBA, 0x00, 0xAD, 0x0B, 0xBB, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x22, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x80, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

};


static INC_UINT8 g_acT3A00KorI2CValue_24576[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
{	//24576KHz 7AK.dat (175.280Mhz)
0x10, 0x00, 0xE2, 0x00, 0x8D, 0x07, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x08, 0x88, 0x77, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 7BK.dat (177.008Mhz)
0x18, 0x00, 0xE2, 0x00, 0x8D, 0x0F, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xF5, 0xF0, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x77, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 7CK.dat (178.736Mhz)
0x00, 0x00, 0xEA, 0x00, 0x8D, 0x17, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 8AK.dat (181.280Mhz)
0x10, 0x00, 0xEA, 0x00, 0x8D, 0x01, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 8BK.dat (183.008Mhz)
0x18, 0x00, 0xEA, 0x00, 0x8D, 0x09, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x07, 0x77, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 8CK.dat (184.736Mhz)
0x00, 0x00, 0xF2, 0x00, 0x8D, 0x11, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x66, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 9AK.dat (187.280Mhz)
0x0C, 0x00, 0xF2, 0x00, 0x8D, 0x1B, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x55, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 9BK.dat (189.008Mhz)
0x18, 0x00, 0xF2, 0x00, 0x8D, 0x03, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x55, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 9CK.dat (190.736Mhz)
0x00, 0x00, 0xFA, 0x00, 0x8D, 0x0B, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xE3, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x55, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 10AK.dat (193.280Mhz)
0x08, 0x01, 0x3A, 0x00, 0xAD, 0x12, 0xAA, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 10BK.dat (195.008Mhz)
0x14, 0x00, 0xFA, 0x00, 0x8D, 0x1D, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x06, 0x66, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 10CK.dat (196.736Mhz)
0x00, 0x01, 0x42, 0x00, 0xAD, 0x06, 0xAA, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 11AK.dat (199.280Mhz)
0x10, 0x01, 0x42, 0x00, 0xAD, 0x0B, 0x2C, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 11BK.dat (201.008Mhz)
0x14, 0x01, 0x02, 0x00, 0x8D, 0x17, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x44, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 11CK.dat (202.736Mhz)
0x1C, 0x01, 0x02, 0x00, 0x8D, 0x1F, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 12AK.dat (205.280Mhz)
0x18, 0x01, 0x4A, 0x00, 0xAD, 0x03, 0xAC, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x05, 0x55, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 12BK.dat (207.008Mhz)
0x18, 0x00, 0x82, 0x00, 0x4D, 0x18, 0xAB, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 12CK.dat (208.736Mhz)
0x1C, 0x01, 0x0A, 0x00, 0x8D, 0x19, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x03, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 13AK.dat (211.280Mhz)
0x1C, 0x01, 0x52, 0x00, 0xAD, 0x1C, 0x2C, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x33, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 13BK.dat (213.008Mhz)
0x14, 0x01, 0x12, 0x00, 0x8D, 0x0B, 0x55, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x22, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

{	//24576KHz 13CK.dat (214.736Mhz)
0x14, 0x01, 0x5A, 0x00, 0xAD, 0x10, 0x2A, 0x03, 0xE8, 0x43, 0x66, 0x0C, 0x21, 0x20, 0xD8, 0xB8, 
0x3C, 0x7C, 0x48, 0x00, 0x00, 0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
0x07, 0x60, 0x9A, 0x7B, 0xF1, 0xF7, 0x00, 0x28, 0x05, 0xF5, 0xF0, 0xFF, 0xFA, 0x92, 0xF1, 0x3F, 
0x00, 0x32, 0x28, 0x27, 0x00, 0x00, 0x00, 0x00, 0x28, 0x16, 0x12, 0x38, 0x38, 0x34, 0x34, 0x55, 
0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x71, 0xD1, 0x4B, 0x4B, 0x48, 0x48, 0x48, 0x48, 0x48, 
0x49, 0x40, 0x00, 0x04, 0x44, 0x22, 0x00, 0x87, 0x00, 0x47, 0x00, 0x37, 0x00, 0x0F, 0x34, 0x00, 
0x0A, 0xE0, 0x01, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x9E, 0x0F, 0x9A, 
0x7D, 0x3B, 0x79, 0x64, 0x02, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE7, 0xFF, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xE6, 0x00, 0x20, 0x33, 
0x97, 0xE4, 0x94, 0x18, 0xEE, 0x00, 0x00, 0x40, 0x00, 0x00, 0x11, 0x00, 0x00, 0x9F, 0x38, 0xB5, 
0x78, 0x9B, 0xA0, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x46, 0x46, 0x00, 0x46, 
0x46, 0x46, 0xC4, 0x47, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 
},

};



INC_UINT32 INC_GET_KOREABAND_FULL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_FULL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleFullFreq[uiIndex];
}

INC_UINT32 INC_GET_KOREABAND_NORMAL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_NORMAL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleNormalFreq[uiIndex];
}

INC_UINT16 INC_FIND_KOR_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_KOREABAND_FULL_CHANNEL; uiLoop++){
		if(g_uiKOREnsembleFullFreq[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT8 INC_RF500_I2C_WRITE(INC_UINT8 ucI2CID, INC_UINT8 *pucData, INC_UINT32 uLength)
{
	INC_INT16 nLoop;

	for(nLoop = 0 ;nLoop < (INC_INT16)uLength; nLoop++){
		INC_CMD_WRITE(ucI2CID, APB_RF_BASE+nLoop, (INC_UINT16)pucData[nLoop]);
	}

	return INC_SUCCESS;
}

void INC_RF500_COMPARE(INC_UINT8 ucI2CID, INC_UINT8 *pucData, INC_UINT32 uLength)
{
  INC_INT16 nLoop;
  INC_UINT16 unReg;
  for(nLoop = 0 ;nLoop < (INC_INT16)uLength; nLoop++){
    unReg = INC_CMD_READ(ucI2CID, APB_RF_BASE+nLoop);
    if((INC_UINT16)pucData[nLoop] != unReg)
    {
      TDMB_MSG_INC_BB("[%s] ADDR[0x%.4X] SET[0x%.4X] READ[0x%.4X]\n", __func__,
        APB_RF_BASE+nLoop, pucData[nLoop], unReg);
    }
  }
}

INC_UINT8 INC_RF500_START(INC_UINT8 ucI2CID, INC_UINT32 ulRFChannel, ENSEMBLE_BAND ucBand)
{
	INC_UINT16 uiPos;
	INC_UINT8* pDataBuff = INC_NULL;
	INC_UINT16 unRegCnt;

	unRegCnt = RF500_REG_CTRL;
	if(ucBand == KOREA_BAND_ENABLE){
		uiPos = INC_FIND_KOR_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_19200KHZ : pDataBuff = g_acT3A00KorI2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : pDataBuff = g_acT3A00KorI2CValue_24576[uiPos]; break;
		default : pDataBuff = g_acT3A00KorI2CValue_19200[uiPos]; break;
		}
	}
	else if(ucBand == EXTERNAL_ENABLE) 
		return INC_SUCCESS;
	else 
		return INC_ERROR;

	if(pDataBuff == INC_NULL) return INC_ERROR;
	if(INC_RF500_I2C_WRITE(ucI2CID, pDataBuff, unRegCnt) == INC_ERROR)
		return INC_ERROR;

#if CONFIG_BOARD_VER < CONFIG_TP10 //use for I/F debugging.
    INC_RF500_COMPARE(ucI2CID, pDataBuff, RF500_REG_CTRL);
#endif

	return INC_SUCCESS;
}


