/* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef __EF63_DISPLAY_H_
#define __EF63_DISPLAY_H_

char aor_dim[32][5] = 
{
	{0xB2,0x00,0x06,0x07,0x3d},
	{0xB2,0x00,0x06,0x06,0xE8},
	{0xB2,0x00,0x06,0x06,0x48},
	{0xB2,0x00,0x06,0x05,0xAB},
	{0xB2,0x00,0x06,0x04,0xFF},
	{0xB2,0x00,0x06,0x04,0x4D},
	{0xB2,0x00,0x06,0x03,0x98},
	{0xB2,0x00,0x06,0x02,0xD2},
	{0xB2,0x00,0x06,0x02,0x1D},
	{0xB2,0x00,0x06,0x01,0x52},
	{0xB2,0x00,0x06,0x00,0xB7},
	{0xB2,0x00,0x06,0x00,0x0A},
	
	{0xB2,0x00,0x06,0x03,0x07},
	{0xB2,0x00,0x06,0x03,0x07},
	{0xB2,0x00,0x06,0x03,0x07},
	{0xB2,0x00,0x06,0x03,0x07},
	{0xB2,0x00,0x06,0x03,0x07},
	{0xB2,0x00,0x06,0x03,0x07},
	{0xB2,0x00,0x06,0x03,0x07},
	{0xB2,0x00,0x06,0x03,0x07},

	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},
	{0xB2,0x00,0x06,0x00,0x0A},

};

char aor_dim_lsi[32][5] = 
{
	{0xB2,0x00,0x06,0x07,0x3C},//5
	{0xB2,0x00,0x06,0x06,0xF1},//10
	{0xB2,0x00,0x06,0x06,0x4F},//20
	{0xB2,0x00,0x06,0x05,0xA4},//30
	{0xB2,0x00,0x06,0x04,0xE4},//41
	{0xB2,0x00,0x06,0x04,0x41},//50
	{0xB2,0x00,0x06,0x03,0x82},//60
	{0xB2,0x00,0x06,0x02,0xEE},//68

	{0xB2,0x00,0x06,0x02,0xEE},//77
	{0xB2,0x00,0x06,0x02,0xEE},//87
	{0xB2,0x00,0x06,0x02,0xEE},//98
	{0xB2,0x00,0x06,0x02,0xEE},//105
	{0xB2,0x00,0x06,0x02,0xEE},//111
	{0xB2,0x00,0x06,0x02,0xEE},//119
	{0xB2,0x00,0x06,0x02,0xEE},//126
	{0xB2,0x00,0x06,0x02,0xEE},//134
	{0xB2,0x00,0x06,0x02,0xEE},//143
	{0xB2,0x00,0x06,0x02,0xEE},//152
	{0xB2,0x00,0x06,0x02,0xEE},//162
	{0xB2,0x00,0x06,0x02,0xEE},//172

	{0xB2,0x00,0x06,0x02,0x8D},//183
	{0xB2,0x00,0x06,0x02,0x27},//195
	{0xB2,0x00,0x06,0x01,0xB2},//207
	{0xB2,0x00,0x06,0x01,0x35},//220
	{0xB2,0x00,0x06,0x00,0xA8},//234

	{0xB2,0x00,0x06,0x00,0x0A},//249
	{0xB2,0x00,0x06,0x00,0x0A},//265
	{0xB2,0x00,0x06,0x00,0x0A},//282
	{0xB2,0x00,0x06,0x00,0x0A},//300
	{0xB2,0x00,0x06,0x00,0x0A},//316
	{0xB2,0x00,0x06,0x00,0x0A},//333
	{0xB2,0x00,0x06,0x00,0x0A},//350

};

char elvss_set[32][3] = {
	{0xB6,0x4C,0x96},//5
	{0xB6,0x4C,0x96},//10
	{0xB6,0x4C,0x96},//20
	{0xB6,0x4C,0x96},//30
	{0xB6,0x4C,0x96},//40
	{0xB6,0x4C,0x96},//50
	{0xB6,0x4C,0x96},//60
	{0xB6,0x4C,0x96},//70
	{0xB6,0x4C,0x96},//80
	{0xB6,0x4C,0x96},//90
	{0xB6,0x4C,0x96},//98
	{0xB6,0x4C,0x96}, //105

	{0xB6,0x4C,0x95},//111
	{0xB6,0x4C,0x95},
	{0xB6,0x4C,0x94},
	{0xB6,0x4C,0x94},
	{0xB6,0x4C,0x93},
	{0xB6,0x4C,0x92},
	{0xB6,0x4C,0x92},
	{0xB6,0x4C,0x91},
	
	{0xB6,0x4C,0x93}, //183
	{0xB6,0x4C,0x93},
	{0xB6,0x4C,0x92},
	{0xB6,0x4C,0x92},
	{0xB6,0x4C,0x91},
	{0xB6,0x4C,0x90},
	{0xB6,0x4C,0x8F},
	{0xB6,0x4C,0x8E},
	{0xB6,0x4C,0x8E},
	{0xB6,0x4C,0x8D},
	{0xB6,0x4C,0x8C},
	{0xB6,0x4C,0x8B}  
};


char elvss_set_lsi[32][3] = {
	{0xB6,0x8C,0x1D},//5
	{0xB6,0x8C,0x1D},//10
	{0xB6,0x8C,0x1D},//20
	{0xB6,0x8C,0x1D},//30
	{0xB6,0x8C,0x1D},//41
	{0xB6,0x8C,0x1D},//50
	{0xB6,0x8C,0x1D},//60
	{0xB6,0x8C,0x1D},//68

	{0xB6,0x8C,0x1C},//77
	{0xB6,0x8C,0x1B},//87
	{0xB6,0x8C,0x1A},//98
	{0xB6,0x8C,0x19},//105
	{0xB6,0x8C,0x19},//111
	{0xB6,0x8C,0x18},//119

	{0xB6,0x8C,0x17},//126
	{0xB6,0x8C,0x17},//134
	{0xB6,0x8C,0x16},//143
	{0xB6,0x8C,0x15},//152
	{0xB6,0x8C,0x14},//162
	{0xB6,0x8C,0x13},//172
	{0xB6,0x8C,0x13},//183 

	{0xB6,0x8C,0x12},//195
	{0xB6,0x8C,0x12},//207
	{0xB6,0x8C,0x12},//220
	{0xB6,0x8C,0x12},//234

	{0xB6,0x8C,0x11},//249
	{0xB6,0x8C,0x10},//265
	{0xB6,0x8C,0x0F},//282
	{0xB6,0x8C,0x0E},//300
	{0xB6,0x8C,0x0D},//316
	{0xB6,0x8C,0x0C},//333
	{0xB6,0x8C,0x0B} //350
};

int gamma_level[32] = {
	5,10,20,30,40,50,60,70,80,90,
	98,105,111,119,126,134,143,152,162,172,
	183,195,207,220,234,249,265,282,300,316,
	333,350
};

int gamma_level_lsi[32] = {
	5,10,20,30,41,50,60,68,77,87,98,105,111,119,126,134,143,152,162,
	172,183,195,207,220,234,249,265,282,300,316,333,350
};

char oled_gamma[34] = {
	0xca,0x0,0xcc,0x0,0xd6,0x0,0xc7,0x84,
	0x87,0x84,0x8b,0x87,0x8b,0x84,0x85,0x83,
	0x81,0x7e,0x86,0x83,0x88,0x82,0x7f,0x81,
	0x7d,0x8c,0x8c,0x88,0xc4,0x8e,0x90,0x0,
	0x0,0x0
};
char oled_gamma_lsi[34] = {
	0xca,0x0,0xe6,0x0,0xe9,0x0,0xe5,0x83,0x83,0x82,
	0x85,0x85,0x84,0x83,0x85,0x84,0x81,0x81,0x82,0x82,
	0x84,0x82,0x80,0x82,0x7f,0x85,0x87,0x82,0x8e,0x87,
	0x86,0x0,0x0,0x0
};


char locking[2] = {0xf7,0x01};
char locking_lsi[2] = {0xf7,0x03};
char temp_set[5] = {0xb8,0x00,0x04,0x00,0x00};
char mtp_unlock[3] = {0xf0, 0x5a, 0x5a};

#ifdef CONFIG_F_SKYDISP_HBM_FOR_AMOLED
char hbm_gamma[34] = {0xca,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
					     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
					     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
					     0x80,0x00,0x00,0x00};
char elvss_hbm_cmd[18] = {0xb6,0x8c,0x0a,0x00,0x00,0x00,0x00
						,0x00,0x03,0x55,0x54,0x20
						,0x00,0x06,0x66,0x6c,0x0c
						,0x00};
char elvss_hbm_cmd_backup[18] = {0xb6,0x8c,0x0a,0x00,0x00,0x00,0x00
						,0x00,0x03,0x55,0x54,0x20
						,0x00,0x06,0x66,0x6c,0x0c
						,0x00};
#endif

struct dsi_cmd_desc backlight_cmd = {
	{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(oled_gamma)},
	oled_gamma
};
struct dsi_cmd_desc locking_cmd = {
	{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(locking)},
	locking
};

struct dsi_cmd_desc aor_cmd = {
	{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(aor_dim[0])},
	aor_dim[0]
};
struct dsi_cmd_desc elvss_cmd = {
	{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(elvss_set[0])},
	elvss_set[0]
};
struct dsi_cmd_desc temp_cmd = {
	{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(temp_set)},
	temp_set
};
struct dsi_cmd_desc mtp_unlock_cmd = {
	{DTYPE_DCS_LWRITE, 1, 0, 0, 1, sizeof(mtp_unlock)},
	mtp_unlock
};
#endif
