/* Copyright (c) 2011, PANTECH. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

/* Sysctl registers */
#if 1
#define AS0260_MCU_BOOT_MODE_REGISTER 	0x001C
#define AS0260_MCU_BOOT_MODE_MASK 	0xFF00
#define AS0260_MCU_BOOT_MODE_INIT 	(1 << 0)
#define AS0260_MCU_BOOT_MODE_STANDBY 	(1 << 1)

#define AS0260_COMMAND_REGISTER                0x0080
#define AS0260_COMMAND_REGISTER_APPLY_PATCH    (1 << 0)
#define AS0260_COMMAND_REGISTER_SET_STATE      (1 << 1)
#define AS0260_COMMAND_REGISTER_REFRESH        (1 << 2)
#define AS0260_COMMAND_REGISTER_WAIT_FOR_EVENT (1 << 3)
#define AS0260_COMMAND_REGISTER_OK             (1 << 15)
#endif

#if 1
#define F_STREAM_ON_OFF

#ifdef F_STREAM_ON_OFF
static struct msm_camera_i2c_reg_conf as0260_start_settings[] = {
#if 0
	{0xDC00, 0x54, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, // SYSMGR_NEXT_STATE
	{0x0080, 0x8002,},                 // COMMAND_REGISTER
	//POLL_FIELD=COMMAND_REGISTER, HOST_COMMAND_1, !=0, DELAY=10, TIMEOUT=100  // 0x0080[1] Ʈ 0 ƴҶ  delay 10 ms  ݺ polling 
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
#else
	{0x098E, 0xDC00,},                // LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
	{0xDC00, 0x34, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, // SYSMGR_NEXT_STATE
	{0x0080, 0x8002,},                 // COMMAND_REGISTER
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
#endif
};

static struct msm_camera_i2c_reg_conf as0260_stop_settings[] = {
#if 0
	{0x098E, 0xDC00,},                // LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
	{0xDC00, 0x50, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, // SYSMGR_NEXT_STATE
	{0x0080, 0x8002,},                 // COMMAND_REGISTER
	//POLL_FIELD=COMMAND_REGISTER, HOST_COMMAND_1, !=0, DELAY=10, TIMEOUT=100 // 0x0080[1] Ʈ 0 ƴҶ  10 ms  ݺ polling 
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//POLL_FIELD=MCU_BOOT_MODE, MCU_INFO_CODE, !=48, DELAY=10, TIMEOUT=10     //0x001C [8:15] Ʈ   0x30  ƴҶ  10ms  ݺ polling 
	//  POLL  MCU_BOOT_MODE::MCU_INFO_CODE =>  0x30
	{AS0260_MCU_BOOT_MODE_REGISTER, (AS0260_MCU_BOOT_MODE_MASK | AS0260_MCU_BOOT_MODE_STANDBY),
	  	MSM_CAMERA_I2C_WORD_DATA, MSM_CAMERA_I2C_CMD_MCU, 0},
#else
	{0x098E, 0xDC00,},                // LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
	{0xDC00, 0x40, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, // SYSMGR_NEXT_STATE
	{0x0080, 0x8002,},                 // COMMAND_REGISTER
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
#endif
};
#endif

#if 0
static struct msm_camera_i2c_reg_conf as0260_prev_settings[] = {
	//[800*480 15-30fps]
	{0xA804, 0x00BF,},	//[AE unlock]
	{0xC86C, 0x0320,}, 	// CAM_OUTPUT_WIDTH
	{0xC86E, 0x01E0,}, 	// CAM_OUTPUT_HEIGHT
	{0x098E, 0xDC00,}, 	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
	{0x0080, 0x8002,},
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
};
#endif
static struct msm_camera_i2c_reg_conf as0260_hd_settings[] = {
	//[720]
	{0xA804, 0x00BF,},	//[AE unlock]
	{0xC86C, 0x0500,}, 	// CAM_OUTPUT_WIDTH
	{0xC86E, 0x02D0,},	// CAM_OUTPUT_HEIGHT
	{0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
	{0x0080, 0x8002,},
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
};

static struct msm_camera_i2c_reg_conf as0260_1088_settings[] = {
	//[1088P]

	{0xA804, 0x00BF,},	//[AE unlock]
	{0xC86C, 0x0780,}, 	// CAM_OUTPUT_WIDTH
	{0xC86E, 0x0440,}, 	// CAM_OUTPUT_HEIGHT
	{0x098E, 0xDC00,}, 	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
	{0x0080, 0x8002,},
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
};

static struct msm_camera_i2c_reg_conf as0260_recommend_settings[] = {
       { 0x0982, 0x0001, }, 	// ACCESS_CTL_STAT
	{ 0x098A, 0x6A44, }, 	// PHYSICAL_ADDRESS_ACCESS
	{ 0xEA44, 0xC0F1, },
	{ 0xEA46, 0x0A2E, },
	{ 0xEA48, 0x0720, },
	{ 0xEA4A, 0xD81D, },
	{ 0xEA4C, 0x0876, },
	{ 0xEA4E, 0x0740, },
	{ 0xEA50, 0xE080, },
	{ 0xEA52, 0x0066, },
	{ 0xEA54, 0x0001, },
	{ 0xEA56, 0x0ED2, },
	{ 0xEA58, 0x07E0, },
	{ 0xEA5A, 0xD802, },
	{ 0xEA5C, 0xD900, },
	{ 0xEA5E, 0x70CF, },
	{ 0xEA60, 0xFF00, },
	{ 0xEA62, 0x31B0, },
	{ 0xEA64, 0xB038, },
	{ 0xEA66, 0x1CFC, },
	{ 0xEA68, 0xB388, },
	{ 0xEA6A, 0x76CF, },
	{ 0xEA6C, 0xFF00, },
	{ 0xEA6E, 0x33CC, },
	{ 0xEA70, 0x200A, },
	{ 0xEA72, 0x0F80, },
	{ 0xEA74, 0xFFFF, },
	{ 0xEA76, 0xEA8C, },
	{ 0xEA78, 0x1CFC, },
	{ 0xEA7A, 0xB008, },
	{ 0xEA7C, 0x2022, },
	{ 0xEA7E, 0x0F80, },
	{ 0xEA80, 0x0000, },
	{ 0xEA82, 0xFC3C, },
	{ 0xEA84, 0x2020, },
	{ 0xEA86, 0x0F80, },
	{ 0xEA88, 0x0000, },
	{ 0xEA8A, 0xEA34, },
	{ 0xEA8C, 0x1404, },
	{ 0xEA8E, 0x340E, },
	{ 0xEA90, 0x70CF, },
	{ 0xEA92, 0xFF00, },
	{ 0xEA94, 0x31B0, },
	{ 0xEA96, 0xD901, },
	{ 0xEA98, 0xB038, },
	{ 0xEA9A, 0x70CF, },
	{ 0xEA9C, 0xFF00, },
	{ 0xEA9E, 0x0078, },
	{ 0xEAA0, 0x9012, },
	{ 0xEAA2, 0x0817, },
	{ 0xEAA4, 0x035E, },
	{ 0xEAA6, 0x09CE, },
	{ 0xEAA8, 0x0720, },
	{ 0xEAAA, 0xD83C, },
	{ 0xEAAC, 0x0C16, },
	{ 0xEAAE, 0x0840, },
	{ 0xEAB0, 0x216F, },
	{ 0xEAB2, 0x003F, },
	{ 0xEAB4, 0xF1FC, },
	{ 0xEAB6, 0x09BE, },
	{ 0xEAB8, 0x0720, },
	{ 0xEABA, 0xD81E, },
	{ 0xEABC, 0xC0D1, },
	{ 0xEABE, 0x7EE0, },
	{ 0xEAC0, 0xC0F1, },
	{ 0xEAC2, 0xE889, },
	{ 0xEAC4, 0x70CF, },
	{ 0xEAC6, 0xFF00, },
	{ 0xEAC8, 0x0000, },
	{ 0xEACA, 0x900E, },
	{ 0xEACC, 0xB8E7, },
	{ 0xEACE, 0x0F78, },
	{ 0xEAD0, 0xFFC1, },
	{ 0xEAD2, 0xD800, },
	{ 0xEAD4, 0xF1F4, },
	{ 0x098E, 0x0000, }, 	// LOGICAL_ADDRESS_ACCESS
	{ 0x098A, 0x5F38, }, 	// PHYSICAL_ADDRESS_ACCESS
	{ 0x0990, 0xFFFF, },
	{ 0x0992, 0xEAC0, },
	{ 0x001C, 0x0600, }, 	// MCU_BOOT_MODE
	//  POLL  MCU_BOOT_MODE::MCU_INFO_CODE =>  0x0F, 0x18, 0x22, 0x33 (4 reads)
	//DELAY=100
	//  POLL  MCU_BOOT_MODE::MCU_INFO_CODE =>  0x05, 0x1D, 0x33 (3 reads)
	{AS0260_MCU_BOOT_MODE_REGISTER, (AS0260_MCU_BOOT_MODE_MASK | AS0260_MCU_BOOT_MODE_INIT),
	  	MSM_CAMERA_I2C_WORD_DATA, MSM_CAMERA_I2C_CMD_MCU, 0},
	{ 0x098E, 0xCA12,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SYSCTL_PLL_ENABLE]
       { 0xCA12, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_SYSCTL_PLL_ENABLE
       { 0xCA13, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_SYSCTL_SENSOR_CLK_DIV2_EN
       { 0xCA14, 0x0120,}, 	// CAM_SYSCTL_PLL_DIVIDER_M_N
       { 0xCA16, 0x0070,}, 	// CAM_SYSCTL_PLL_DIVIDER_P
       { 0xCA18, 0x7F7D,}, 	// CAM_SYSCTL_PLL_DIVIDER_P4_P5_P6
       { 0xCA1A, 0x1007,}, 	// CAM_SYSCTL_PLL_DIVIDER_P7
       { 0xC808, 0x0345,},
       { 0xC80A, 0x0DB6,}, 	// CAM_SENSOR_CFG_PIXCLK
	   //STATE= Master Clock, 109714284 //DevWare needs to be told it is twice the actual frequency
       {0xC800, 0x0018,}, 	// CAM_SENSOR_CFG_Y_ADDR_START
       {0xC802, 0x0020,}, 	// CAM_SENSOR_CFG_X_ADDR_START
       {0xC804, 0x045F,}, 	// CAM_SENSOR_CFG_Y_ADDR_END
       {0xC806, 0x07A7,}, 	// CAM_SENSOR_CFG_X_ADDR_END
       {0xC80E, 0x0336,}, 	// CAM_SENSOR_CFG_FINE_INTEG_TIME_MIN
       {0xC810, 0x0A7A,}, 	// CAM_SENSOR_CFG_FINE_INTEG_TIME_MAX
       {0xC812, 0x049A,}, 	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
       {0xC814, 0x0C38,}, 	// CAM_SENSOR_CFG_LINE_LENGTH_PCK
       {0xC816, 0x00D4,}, 	// CAM_SENSOR_CFG_FINE_CORRECTION
       {0xC818, 0x043B,}, 	// CAM_SENSOR_CFG_CPIPE_LAST_ROW
       {0xC830, 0x0002,}, 	// CAM_SENSOR_CONTROL_READ_MODE
       {0xC858, 0x0000,}, 	// CAM_CROP_WINDOW_XOFFSET
       {0xC85A, 0x0000,}, 	// CAM_CROP_WINDOW_YOFFSET
       {0xC85C, 0x0780,}, 	// CAM_CROP_WINDOW_WIDTH
       {0xC85E, 0x0440,}, 	// CAM_CROP_WINDOW_HEIGHT
       {0xC86C, 0x0780,}, 	// CAM_OUTPUT_WIDTH
       {0xC86E, 0x0440,}, 	// CAM_OUTPUT_HEIGHT
       {0xC88E, 0x1E01,}, 	// CAM_AET_MAX_FRAME_RATE
       {0xC890, 0x0A00,}, 	// 1129_tune f00-->a00 (15-->10fps)CAM_AET_MIN_FRAME_RATE
       {0xC94C, 0x0000,}, 	// CAM_STAT_AWB_CLIP_WINDOW_XSTART
       {0xC94E, 0x0000,}, 	// CAM_STAT_AWB_CLIP_WINDOW_YSTART
       {0xC950, 0x077F,}, 	// CAM_STAT_AWB_CLIP_WINDOW_XEND
       {0xC952, 0x0437,}, 	// CAM_STAT_AWB_CLIP_WINDOW_YEND
       {0xC954, 0x00E6,}, 	// CAM_STAT_AE_INITIAL_WINDOW_XSTART
       {0xC956, 0x000E,}, 	// CAM_STAT_AE_INITIAL_WINDOW_YSTART
       {0xC958, 0x020A,}, 	// CAM_STAT_AE_INITIAL_WINDOW_XEND
       {0xC95A, 0x00E3,}, 	// CAM_STAT_AE_INITIAL_WINDOW_YEND
       {0xC870, 0x4010,}, 	// CAM_OUTPUT_FORMAT
	{0x3E00, 0x042D,}, 	// DYNAMIC_SEQRAM_00
	{0x3E02, 0x39FF,}, 	// DYNAMIC_SEQRAM_02
	{0x3E04, 0x49FF,}, 	// DYNAMIC_SEQRAM_04
	{0x3E06, 0xFFFF,}, 	// DYNAMIC_SEQRAM_06
	{0x3E08, 0x8071,}, 	// DYNAMIC_SEQRAM_08
	{0x3E0A, 0x7211,}, 	// DYNAMIC_SEQRAM_0A
	{0x3E0C, 0xE040,}, 	// DYNAMIC_SEQRAM_0C
	{0x3E0E, 0xA840,}, 	// DYNAMIC_SEQRAM_0E
	{0x3E10, 0x4100,}, 	// DYNAMIC_SEQRAM_10
	{0x3E12, 0x1846,}, 	// DYNAMIC_SEQRAM_12
	{0x3E14, 0xA547,}, 	// DYNAMIC_SEQRAM_14
	{0x3E16, 0xAD57,}, 	// DYNAMIC_SEQRAM_16
	{0x3E18, 0x8149,}, 	// DYNAMIC_SEQRAM_18
	{0x3E1A, 0x9D49,}, 	// DYNAMIC_SEQRAM_1A
	{0x3E1C, 0x9F46,}, 	// DYNAMIC_SEQRAM_1C
	{0x3E1E, 0x8000,}, 	// DYNAMIC_SEQRAM_1E
	{0x3E20, 0x1842,}, 	// DYNAMIC_SEQRAM_20
	{0x3E22, 0x4180,}, 	// DYNAMIC_SEQRAM_22
	{0x3E24, 0x0018,}, 	// DYNAMIC_SEQRAM_24
	{0x3E26, 0x8149,}, 	// DYNAMIC_SEQRAM_26
	{0x3E28, 0x9C49,}, 	// DYNAMIC_SEQRAM_28
	{0x3E2A, 0x9347,}, 	// DYNAMIC_SEQRAM_2A
	{0x3E2C, 0x804D,}, 	// DYNAMIC_SEQRAM_2C
	{0x3E2E, 0x804A,}, 	// DYNAMIC_SEQRAM_2E
	{0x3E30, 0x100C,}, 	// DYNAMIC_SEQRAM_30
	{0x3E32, 0x8000,}, 	// DYNAMIC_SEQRAM_32
	{0x3E34, 0x1841,}, 	// DYNAMIC_SEQRAM_34
	{0x3E36, 0x4280,}, 	// DYNAMIC_SEQRAM_36
	{0x3E38, 0x0018,}, 	// DYNAMIC_SEQRAM_38
	{0x3E3A, 0x9710,}, 	// DYNAMIC_SEQRAM_3A
	{0x3E3C, 0x0C80,}, 	// DYNAMIC_SEQRAM_3C
	{0x3E3E, 0x4DA2,}, 	// DYNAMIC_SEQRAM_3E
	{0x3E40, 0x4BA0,}, 	// DYNAMIC_SEQRAM_40
	{0x3E42, 0x4A00,}, 	// DYNAMIC_SEQRAM_42
	{0x3E44, 0x1880,}, 	// DYNAMIC_SEQRAM_44
	{0x3E46, 0x4241,}, 	// DYNAMIC_SEQRAM_46
	{0x3E48, 0x0018,}, 	// DYNAMIC_SEQRAM_48
	{0x3E4A, 0xB54B,}, 	// DYNAMIC_SEQRAM_4A
	{0x3E4C, 0x1C00,}, 	// DYNAMIC_SEQRAM_4C
	{0x3E4E, 0x8000,}, 	// DYNAMIC_SEQRAM_4E
	{0x3E50, 0x1C10,}, 	// DYNAMIC_SEQRAM_50
	{0x3E52, 0x6081,}, 	// DYNAMIC_SEQRAM_52
	{0x3E54, 0x1580,}, 	// DYNAMIC_SEQRAM_54
	{0x3E56, 0x7C09,}, 	// DYNAMIC_SEQRAM_56
	{0x3E58, 0x7000,}, 	// DYNAMIC_SEQRAM_58
	{0x3E5A, 0x8082,}, 	// DYNAMIC_SEQRAM_5A
	{0x3E5C, 0x7281,}, 	// DYNAMIC_SEQRAM_5C
	{0x3E5E, 0x4C40,}, 	// DYNAMIC_SEQRAM_5E
	{0x3E60, 0x8E4D,}, 	// DYNAMIC_SEQRAM_60
	{0x3E62, 0x8110,}, 	// DYNAMIC_SEQRAM_62
	{0x3E64, 0x0CAF,}, 	// DYNAMIC_SEQRAM_64
	{0x3E66, 0x4D80,}, 	// DYNAMIC_SEQRAM_66
	{0x3E68, 0x100C,}, 	// DYNAMIC_SEQRAM_68
	{0x3E6A, 0x8440,}, 	// DYNAMIC_SEQRAM_6A
	{0x3E6C, 0x4C81,}, 	// DYNAMIC_SEQRAM_6C
	{0x3E6E, 0x7C5B,}, 	// DYNAMIC_SEQRAM_6E
	{0x3E70, 0x7000,}, 	// DYNAMIC_SEQRAM_70
	{0x3E72, 0x8054,}, 	// DYNAMIC_SEQRAM_72
	{0x3E74, 0x924C,}, 	// DYNAMIC_SEQRAM_74
	{0x3E76, 0x4078,}, 	// DYNAMIC_SEQRAM_76
	{0x3E78, 0x4D4F,}, 	// DYNAMIC_SEQRAM_78
	{0x3E7A, 0x4E98,}, 	// DYNAMIC_SEQRAM_7A
	{0x3E7C, 0x504E,}, 	// DYNAMIC_SEQRAM_7C
	{0x3E7E, 0x4F97,}, 	// DYNAMIC_SEQRAM_7E
	{0x3E80, 0x4F4E,}, 	// DYNAMIC_SEQRAM_80
	{0x3E82, 0x507C,}, 	// DYNAMIC_SEQRAM_82
	{0x3E84, 0x7B8D,}, 	// DYNAMIC_SEQRAM_84
	{0x3E86, 0x4D88,}, 	// DYNAMIC_SEQRAM_86
	{0x3E88, 0x4E10,}, 	// DYNAMIC_SEQRAM_88
	{0x3E8A, 0x0940,}, 	// DYNAMIC_SEQRAM_8A
	{0x3E8C, 0x8879,}, 	// DYNAMIC_SEQRAM_8C
	{0x3E8E, 0x5481,}, 	// DYNAMIC_SEQRAM_8E
	{0x3E90, 0x7000,}, 	// DYNAMIC_SEQRAM_90
	{0x3E92, 0x8082,}, 	// DYNAMIC_SEQRAM_92
	{0x3E94, 0x7281,}, 	// DYNAMIC_SEQRAM_94
	{0x3E96, 0x4C40,}, 	// DYNAMIC_SEQRAM_96
	{0x3E98, 0x8E4D,}, 	// DYNAMIC_SEQRAM_98
	{0x3E9A, 0x8110,}, 	// DYNAMIC_SEQRAM_9A
	{0x3E9C, 0x0CAF,}, 	// DYNAMIC_SEQRAM_9C
	{0x3E9E, 0x4D80,}, 	// DYNAMIC_SEQRAM_9E
	{0x3EA0, 0x100C,}, 	// DYNAMIC_SEQRAM_A0
	{0x3EA2, 0x8440,}, 	// DYNAMIC_SEQRAM_A2
	{0x3EA4, 0x4C81,}, 	// DYNAMIC_SEQRAM_A4
	{0x3EA6, 0x7C93,}, 	// DYNAMIC_SEQRAM_A6
	{0x3EA8, 0x7000,}, 	// DYNAMIC_SEQRAM_A8
	{0x3EAA, 0x0000,}, 	// DYNAMIC_SEQRAM_AA
	{0x3EAC, 0x0000,}, 	// DYNAMIC_SEQRAM_AC
	{0x3EAE, 0x0000,}, 	// DYNAMIC_SEQRAM_AE
	{0x3EB0, 0x0000,}, 	// DYNAMIC_SEQRAM_B0
	{0x3EB2, 0x0000,}, 	// DYNAMIC_SEQRAM_B2
	{0x3EB4, 0x0000,}, 	// DYNAMIC_SEQRAM_B4
	{0x3EB6, 0x0000,}, 	// DYNAMIC_SEQRAM_B6
	{0x3EB8, 0x0000,}, 	// DYNAMIC_SEQRAM_B8
	{0x3EBA, 0x0000,}, 	// DYNAMIC_SEQRAM_BA
	{0x3EBC, 0x0000,}, 	// DYNAMIC_SEQRAM_BC
	{0x3EBE, 0x0000,}, 	// DYNAMIC_SEQRAM_BE
	{0x3EC0, 0x0000,}, 	// DYNAMIC_SEQRAM_C0
	{0x3EC2, 0x0000,}, 	// DYNAMIC_SEQRAM_C2
	{0x3EC4, 0x0000,}, 	// DYNAMIC_SEQRAM_C4
	{0x3EC6, 0x0000,}, 	// DYNAMIC_SEQRAM_C6
	{0x3EC8, 0x0000,}, 	// DYNAMIC_SEQRAM_C8
	{0x3ECA, 0x0000,}, 	// DYNAMIC_SEQRAM_CA
	{0x3084, 0x0000, MSM_CAMERA_I2C_WORD_DATA, MSM_CAMERA_I2C_CMD_TRIM,0},

	{0x30B2, 0xC000,}, 	// CALIB_TIED_OFFSET
	{0x30D4, 0x9400,}, 	// COLUMN_CORRECTION
	{0x31C0, 0x0000,}, 	// FUSE_REF_ADDR
	{0x316A, 0x8200,}, 	// DAC_FBIAS
	{0x316C, 0x8200,}, 	// DAC_TXLO
	{0x3EFE, 0x2808,}, 	// DAC_LD_TXLO
	{0x3EFC, 0x2868,}, 	// DAC_LD_FBIAS
	{0x3ED2, 0xD165,}, 	// DAC_LD_6_7
	{0x3EF2, 0xD165,}, 	// DAC_LP_6_7
	{0x3ED8, 0x7F1A,}, 	// DAC_LD_12_13
	{0x3EDA, 0x2828,}, 	// DAC_LD_14_15
	{0x3EE2, 0x0058,}, 	// DAC_LD_22_23
	{0x3EFE, 0x280A,}, 	// DAC_LD_TXLO
	{0x3170, 0x000A,}, 	// ANALOG_CONTROL
	{0x3174, 0x8060,}, 	// ANALOG_CONTROL3
	{0x317A, 0x000A,}, 	// ANALOG_CONTROL6
	{0x3ECC, 0x22B0,}, 	// DAC_LD_0_1

       //[AutoPGA Settings 80% 2012/11/26 02:51:35]
       {0x098E, 0x0000,}, 	//  LOGICAL addressing
       {0xD1BC, 0x0170,}, 	//  PGA_TABLE_A_DATA_0
       {0xD1BE, 0xA32D,}, 	//  PGA_TABLE_A_DATA_1
       {0xD1C0, 0x6F51,}, 	//  PGA_TABLE_A_DATA_2
       {0xD1C2, 0x5F4C,}, 	//  PGA_TABLE_A_DATA_3
       {0xD1C4, 0xF091,}, 	//  PGA_TABLE_A_DATA_4
       {0xD1C6, 0x0150,}, 	//  PGA_TABLE_A_DATA_5
       {0xD1C8, 0x392E,}, 	//  PGA_TABLE_A_DATA_6
       {0xD1CA, 0x6AB2,}, 	//  130213_tune_bsy_PGA_TABLE_A_DATA_7
       {0xD1CC, 0x71AE,}, 	//  PGA_TABLE_A_DATA_8
       {0xD1CE, 0xBB93,}, 	//  PGA_TABLE_A_DATA_9
       {0xD1D0, 0x01F0,}, 	//  PGA_TABLE_A_DATA_10
       {0xD1D2, 0xCCEC,}, 	//  PGA_TABLE_A_DATA_11
       {0xD1D4, 0x680F,}, 	//  PGA_TABLE_A_DATA_12
       {0xD1D6, 0xB0AF,}, 	//  PGA_TABLE_A_DATA_13
       {0xD1D8, 0x8ECD,}, 	//  PGA_TABLE_A_DATA_14
       {0xD1DA, 0x1010,}, 	//  PGA_TABLE_A_DATA_15
       {0xD1DC, 0x67CD,}, 	//  PGA_TABLE_A_DATA_16
       {0xD1DE, 0x1BD2,}, 	//  PGA_TABLE_A_DATA_17
       {0xD1E0, 0x9C0E,}, 	//  PGA_TABLE_A_DATA_18
       {0xD1E2, 0xFD92,}, 	//  PGA_TABLE_A_DATA_19
       {0xD1E4, 0x552C,}, 	//  PGA_TABLE_A_DATA_20
       {0xD1E6, 0xDECE,}, 	//  PGA_TABLE_A_DATA_21
       {0xD1E8, 0xFE2F,}, 	//  PGA_TABLE_A_DATA_22
       {0xD1EA, 0x9E8D,}, 	//  PGA_TABLE_A_DATA_23
       {0xD1EC, 0x0E32,}, 	//  PGA_TABLE_A_DATA_24
       {0xD1EE, 0x01AC,}, 	//  130213_tune_bsy_PGA_TABLE_A_DATA_25
       {0xD1F0, 0x1D90,}, 	//  PGA_TABLE_A_DATA_26
       {0xD1F2, 0x85EE,}, 	//  PGA_TABLE_A_DATA_27
       {0xD1F4, 0xF7F1,}, 	//  PGA_TABLE_A_DATA_28
       {0xD1F6, 0x8AB0,}, 	//  PGA_TABLE_A_DATA_29
       {0xD1F8, 0xE9AC,}, 	//  130213_tune_bsy_PGA_TABLE_A_DATA_30
       {0xD1FA, 0x1FB0,}, 	//  PGA_TABLE_A_DATA_31
       {0xD1FC, 0x8790,}, 	//  PGA_TABLE_A_DATA_32
       {0xD1FE, 0x8992,}, 	//  PGA_TABLE_A_DATA_33
       {0xD200, 0x7652,}, 	//  PGA_TABLE_A_DATA_34
       {0xD202, 0xD9CB,}, 	//  PGA_TABLE_A_DATA_35
       {0xD204, 0x802F,}, 	//  PGA_TABLE_A_DATA_36
       {0xD206, 0x0CEF,}, 	//  PGA_TABLE_A_DATA_37
       {0xD208, 0x1A0F,}, 	//  PGA_TABLE_A_DATA_38
       {0xD20A, 0x6731,}, 	//  PGA_TABLE_A_DATA_39
       {0xD20C, 0x1C12,}, 	//  PGA_TABLE_A_DATA_40
       {0xD20E, 0x0131,}, 	//  PGA_TABLE_A_DATA_41
       {0xD210, 0xE553,}, 	//  PGA_TABLE_A_DATA_42
       {0xD212, 0xE3F3,}, 	//  PGA_TABLE_A_DATA_43
       {0xD214, 0x33B5,}, 	//  PGA_TABLE_A_DATA_44
       {0xD216, 0x0853,}, 	//  130213_tune_bsy_PGA_TABLE_A_DATA_45
       {0xD218, 0x4EB1,}, 	//  PGA_TABLE_A_DATA_46
       {0xD21A, 0xD213,}, 	//  PGA_TABLE_A_DATA_47
       {0xD21C, 0xC215,}, 	//  PGA_TABLE_A_DATA_48
       {0xD21E, 0x9FB3,}, 	//  PGA_TABLE_A_DATA_49
       {0xD220, 0x0FD1,}, 	//  PGA_TABLE_A_DATA_50
       {0xD222, 0x63B0,}, 	//  PGA_TABLE_A_DATA_51
       {0xD224, 0xD173,}, 	//  PGA_TABLE_A_DATA_52
       {0xD226, 0xB413,}, 	//  PGA_TABLE_A_DATA_53
       {0xD228, 0x20B6,}, 	//  PGA_TABLE_A_DATA_54
       {0xD22A, 0x0A12,}, 	//  PGA_TABLE_A_DATA_55
       {0xD22C, 0x69CF,}, 	//  PGA_TABLE_A_DATA_56
       {0xD22E, 0xAC34,}, 	//  PGA_TABLE_A_DATA_57
       {0xD230, 0xECB4,}, 	//  PGA_TABLE_A_DATA_58
       {0xD232, 0x2156,}, 	//  PGA_TABLE_A_DATA_59
       {0xD234, 0x7B90,}, 	//  PGA_TABLE_A_DATA_60
       {0xD236, 0x02D0,}, 	//  PGA_TABLE_A_DATA_61
       {0xD238, 0xA611,}, 	//  PGA_TABLE_A_DATA_62
       {0xD23A, 0x0914,}, 	//  PGA_TABLE_A_DATA_63
       {0xD23C, 0x4AF5,}, 	//  PGA_TABLE_A_DATA_64
       {0xD23E, 0x5971,}, 	//  PGA_TABLE_A_DATA_65
       {0xD240, 0x2670,}, 	//  PGA_TABLE_A_DATA_66
       {0xD242, 0x9274,}, 	//  PGA_TABLE_A_DATA_67
       {0xD244, 0x91B1,}, 	//  PGA_TABLE_A_DATA_68
       {0xD246, 0x48B6,}, 	//  PGA_TABLE_A_DATA_69
       {0xD248, 0x6F8F,}, 	//  PGA_TABLE_A_DATA_70
       {0xD24A, 0xDB31,}, 	//  PGA_TABLE_A_DATA_71
       {0xD24C, 0x7C33,}, 	//  PGA_TABLE_A_DATA_72
       {0xD24E, 0x49B4,}, 	//  PGA_TABLE_A_DATA_73
       {0xD250, 0xAAB4,}, 	//  PGA_TABLE_A_DATA_74
       {0xD252, 0x1950,}, 	//  PGA_TABLE_A_DATA_75
       {0xD254, 0x2831,}, 	//  PGA_TABLE_A_DATA_76
       {0xD256, 0x2293,}, 	//  PGA_TABLE_A_DATA_77
       {0xD258, 0x34B2,}, 	//  PGA_TABLE_A_DATA_78
       {0xD25A, 0x1454,}, 	//  PGA_TABLE_A_DATA_79
       {0xD25C, 0xC673,}, 	//  PGA_TABLE_A_DATA_80
       {0xD25E, 0x9534,}, 	//  PGA_TABLE_A_DATA_81
       {0xD260, 0xFAD6,}, 	//  PGA_TABLE_A_DATA_82
       {0xD262, 0x78F7,}, 	//  PGA_TABLE_A_DATA_83
       {0xD264, 0x7DF8,}, 	//  PGA_TABLE_A_DATA_84
       {0xD266, 0xEE33,}, 	//  PGA_TABLE_A_DATA_85
       {0xD268, 0xD674,}, 	//  PGA_TABLE_A_DATA_86
       {0xD26A, 0xB478,}, 	//  PGA_TABLE_A_DATA_87
       {0xD26C, 0x3178,}, 	//  PGA_TABLE_A_DATA_88
       {0xD26E, 0x25FA,}, 	//  PGA_TABLE_A_DATA_89
       {0xD270, 0x9DB3,}, 	//  PGA_TABLE_A_DATA_90
       {0xD272, 0x8293,}, 	//  PGA_TABLE_A_DATA_91
       {0xD274, 0x5835,}, 	//  PGA_TABLE_A_DATA_92
       {0xD276, 0x4B37,}, 	//  PGA_TABLE_A_DATA_93
       {0xD278, 0x8B78,}, 	//  PGA_TABLE_A_DATA_94
       {0xD27A, 0x8D93,}, 	//  PGA_TABLE_A_DATA_95
       {0xD27C, 0xC5D2,}, 	//  PGA_TABLE_A_DATA_96
       {0xD27E, 0xCA16,}, 	//  PGA_TABLE_A_DATA_97
       {0xD280, 0x6B17,}, 	//  PGA_TABLE_A_DATA_98
       {0xD282, 0x22D8,}, 	//  PGA_TABLE_A_DATA_99
       {0xD286, 0x0400,}, 	//  PGA_TABLE_A_CENTER_COLUMN
       {0xD284, 0x024C,}, 	//  PGA_TABLE_A_CENTER_ROW
       {0xC9F4, 0x0AF0,}, 	//  CAM_PGA_L_CONFIG_COLOUR_TEMP
       {0xC9F6, 0x8000,}, 	//  CAM_PGA_L_CONFIG_GREEN_RED_Q14
       {0xC9F8, 0x8000,}, 	//  CAM_PGA_L_CONFIG_RED_Q14
       {0xC9FA, 0x8000,}, 	//  CAM_PGA_L_CONFIG_GREEN_BLUE_Q14
       {0xC9FC, 0x8000,}, 	//  CAM_PGA_L_CONFIG_BLUE_Q14
{0xD0F0, 0x00F0,}, 	//  PGA_TABLE_CWF_DATA_0
{0xD0F2, 0xA48D,}, 	//  PGA_TABLE_CWF_DATA_1
{0xD0F4, 0x0652,}, 	//  PGA_TABLE_CWF_DATA_2
{0xD0F6, 0xB0AC,}, 	//  PGA_TABLE_CWF_DATA_3
{0xD0F8, 0xA512,}, 	//  PGA_TABLE_CWF_DATA_4
{0xD0FA, 0x1110,}, 	// 130213_tune_bsy_ 20130123_SKT_01F0-->0110_PGA_TABLE_CWF_DATA_5
{0xD0FC, 0x28CE,}, 	//  PGA_TABLE_CWF_DATA_6
{0xD0FE, 0x3272,}, 	//  130213_tune_bsy_20130123_SKT_4072-->5E72_PGA_TABLE_CWF_DATA_7
{0xD100, 0x2C2E,}, 	//  PGA_TABLE_CWF_DATA_8
{0xD102, 0xA273,}, 	//  PGA_TABLE_CWF_DATA_9
{0xD104, 0x0130,}, 	//  PGA_TABLE_CWF_DATA_10
{0xD106, 0xB4ED,}, 	//  PGA_TABLE_CWF_DATA_11
{0xD108, 0x3D10,}, 	//  130213_tune_bsy_20130123_0911-->0131_PGA_TABLE_CWF_DATA_12
{0xD10A, 0x8CEF,}, 	//  PGA_TABLE_CWF_DATA_13
{0xD10C, 0x9E11,}, 	//  PGA_TABLE_CWF_DATA_14
{0xD10E, 0x0C50,}, 	//  PGA_TABLE_CWF_DATA_15
{0xD110, 0x500D,}, 	//  PGA_TABLE_CWF_DATA_16
{0xD112, 0x1472,}, 	//  PGA_TABLE_CWF_DATA_17
{0xD114, 0xCFCE,}, 	//  PGA_TABLE_CWF_DATA_18
{0xD116, 0xFE72,}, 	//  PGA_TABLE_CWF_DATA_19
{0xD118, 0x396B,}, 	//  PGA_TABLE_CWF_DATA_20
{0xD11A, 0x988F,}, 	//  PGA_TABLE_CWF_DATA_21
{0xD11C, 0x88F0,}, 	//  PGA_TABLE_CWF_DATA_22
{0xD11E, 0x6ECE,}, 	//  PGA_TABLE_CWF_DATA_23
{0xD120, 0x1B92,}, 	//  PGA_TABLE_CWF_DATA_24
{0xD122, 0x13AD,}, 	//  PGA_TABLE_CWF_DATA_25
{0xD124, 0x734F,}, 	//  PGA_TABLE_CWF_DATA_26
{0xD126, 0xAC0E,}, 	//  PGA_TABLE_CWF_DATA_27
{0xD128, 0xB391,}, 	//  PGA_TABLE_CWF_DATA_28
{0xD12A, 0x560E,}, 	//  PGA_TABLE_CWF_DATA_29
{0xD12C, 0x8D0A,}, 	//  PGA_TABLE_CWF_DATA_30
{0xD12E, 0x556F,}, 	//  PGA_TABLE_CWF_DATA_31
{0xD130, 0xFD0B,}, 	//  PGA_TABLE_CWF_DATA_32
{0xD132, 0xA2F1,}, 	//  PGA_TABLE_CWF_DATA_33
{0xD134, 0x2CF1,}, 	//  PGA_TABLE_CWF_DATA_34
{0xD136, 0xA52C,}, 	//  PGA_TABLE_CWF_DATA_35
{0xD138, 0xAD2F,}, 	//  PGA_TABLE_CWF_DATA_36
{0xD13A, 0x3B0F,}, 	//  PGA_TABLE_CWF_DATA_37
{0xD13C, 0x6550,}, 	//  PGA_TABLE_CWF_DATA_38
{0xD13E, 0x2571,}, 	//  PGA_TABLE_CWF_DATA_39
{0xD140, 0x15D2,}, 	//  PGA_TABLE_CWF_DATA_40
{0xD142, 0x22AF,}, 	//  PGA_TABLE_CWF_DATA_41
{0xD144, 0xC213,}, 	//  PGA_TABLE_CWF_DATA_42
{0xD146, 0x1411,}, 	//  PGA_TABLE_CWF_DATA_43
{0xD148, 0x29F4,}, 	//  PGA_TABLE_CWF_DATA_44
{0xD14A, 0x7C52,}, 	//  PGA_TABLE_CWF_DATA_45
{0xD14C, 0x31D0,}, 	//  PGA_TABLE_CWF_DATA_46
{0xD14E, 0xF873,}, 	//  PGA_TABLE_CWF_DATA_47
{0xD150, 0xC2D4,}, 	//  PGA_TABLE_CWF_DATA_48
{0xD152, 0xD532,}, 	//  PGA_TABLE_CWF_DATA_49
{0xD154, 0x4011,}, 	//  PGA_TABLE_CWF_DATA_50
{0xD156, 0x6B4D,}, 	//  PGA_TABLE_CWF_DATA_51
{0xD158, 0xAF92,}, 	//  PGA_TABLE_CWF_DATA_52
{0xD15A, 0x16F2,}, 	//  PGA_TABLE_CWF_DATA_53
{0xD15C, 0x5F33,}, 	//  PGA_TABLE_CWF_DATA_54
{0xD15E, 0x0FF2,}, 	//  PGA_TABLE_CWF_DATA_55
{0xD160, 0x854F,}, 	//  PGA_TABLE_CWF_DATA_56
{0xD162, 0x8454,}, 	//  PGA_TABLE_CWF_DATA_57
{0xD164, 0xCF13,}, 	//  PGA_TABLE_CWF_DATA_58
{0xD166, 0x1DF5,}, 	//  PGA_TABLE_CWF_DATA_59
{0xD168, 0x59B0,}, 	//  PGA_TABLE_CWF_DATA_60
{0xD16A, 0x60CF,}, 	//  PGA_TABLE_CWF_DATA_61
{0xD16C, 0x4673,}, 	//  PGA_TABLE_CWF_DATA_62
{0xD16E, 0x5DD1,}, 	//  PGA_TABLE_CWF_DATA_63
{0xD170, 0x9135,}, 	//  PGA_TABLE_CWF_DATA_64
{0xD172, 0x58B1,}, 	//  PGA_TABLE_CWF_DATA_65
{0xD174, 0x1E4F,}, 	//  PGA_TABLE_CWF_DATA_66
{0xD176, 0x0F31,}, 	//  PGA_TABLE_CWF_DATA_67
{0xD178, 0x99F4,}, 	//  PGA_TABLE_CWF_DATA_68
{0xD17A, 0xC753,}, 	//  PGA_TABLE_CWF_DATA_69
{0xD17C, 0x1F8F,}, 	//  PGA_TABLE_CWF_DATA_70
{0xD17E, 0xFFCF,}, 	//  PGA_TABLE_CWF_DATA_71
{0xD180, 0x2494,}, 	//  PGA_TABLE_CWF_DATA_72
{0xD182, 0xF330,}, 	//  PGA_TABLE_CWF_DATA_73
{0xD184, 0xC2F5,}, 	//  PGA_TABLE_CWF_DATA_74
{0xD186, 0x15CF,}, 	//  PGA_TABLE_CWF_DATA_75
{0xD188, 0x1311,}, 	//  PGA_TABLE_CWF_DATA_76
{0xD18A, 0x3934,}, 	//  PGA_TABLE_CWF_DATA_77
{0xD18C, 0xBF93,}, 	//  PGA_TABLE_CWF_DATA_78
{0xD18E, 0xC355,}, 	//  PGA_TABLE_CWF_DATA_79
{0xD190, 0xE293,}, 	//  PGA_TABLE_CWF_DATA_80
{0xD192, 0xD773,}, 	//  PGA_TABLE_CWF_DATA_81
{0xD194, 0x9777,}, 	//  PGA_TABLE_CWF_DATA_82
{0xD196, 0x38B6,}, 	//  PGA_TABLE_CWF_DATA_83
{0xD198, 0x5DB9,}, 	//  PGA_TABLE_CWF_DATA_84
{0xD19A, 0xA354,}, 	//  PGA_TABLE_CWF_DATA_85
{0xD19C, 0x9334,}, 	//  PGA_TABLE_CWF_DATA_86
{0xD19E, 0xFD97,}, 	//  PGA_TABLE_CWF_DATA_87
{0xD1A0, 0x1A57,}, 	//  PGA_TABLE_CWF_DATA_88
{0xD1A2, 0x409A,}, 	//  PGA_TABLE_CWF_DATA_89
{0xD1A4, 0xA0B3,}, 	//  PGA_TABLE_CWF_DATA_90
{0xD1A6, 0xA3F1,}, 	//  PGA_TABLE_CWF_DATA_91
{0xD1A8, 0xC296,}, 	//  PGA_TABLE_CWF_DATA_92
{0xD1AA, 0x1636,}, 	//  PGA_TABLE_CWF_DATA_93
{0xD1AC, 0x5159,}, 	//  PGA_TABLE_CWF_DATA_94
{0xD1AE, 0xB693,}, 	//  PGA_TABLE_CWF_DATA_95
{0xD1B0, 0x4330,}, 	//  PGA_TABLE_CWF_DATA_96
{0xD1B2, 0x9437,}, 	//  PGA_TABLE_CWF_DATA_97
{0xD1B4, 0x0996,}, 	//  PGA_TABLE_CWF_DATA_98
{0xD1B6, 0x5E79,}, 	//  PGA_TABLE_CWF_DATA_99
       {0xD1BA, 0x040C,}, 	//  PGA_TABLE_CWF_CENTER_COLUMN
       {0xD1B8, 0x024C,}, 	//  PGA_TABLE_CWF_CENTER_ROW
       {0xC9FE, 0x0FA0,}, 	//  CAM_PGA_M_CONFIG_COLOUR_TEMP
       {0xCA00, 0x8000,}, 	//  CAM_PGA_M_CONFIG_GREEN_RED_Q14
       {0xCA02, 0x8000,}, 	//  CAM_PGA_M_CONFIG_RED_Q14
       {0xCA04, 0x8000,}, 	//  CAM_PGA_M_CONFIG_GREEN_BLUE_Q14
       {0xCA06, 0x8000,}, 	//  CAM_PGA_M_CONFIG_BLUE_Q14    
       /* D65 Color shading original*/
       /*
       {0xD024, 0x0010,}, 	//  20130228_tune_PGA_TABLE_D65_DATA_0
       {0xD026, 0xA48D,}, 	//  PGA_TABLE_D65_DATA_1
       {0xD028, 0x0652,}, 	//  PGA_TABLE_D65_DATA_2
       {0xD02A, 0xB0AC,}, 	//  PGA_TABLE_D65_DATA_3
       {0xD02C, 0xA512,}, 	//  PGA_TABLE_D65_DATA_4
       {0xD02E, 0x0370,}, 	//  20130228_tune_PGA_TABLE_D65_DATA_5
       {0xD030, 0x28CE,}, 	//  PGA_TABLE_D65_DATA_6
       {0xD032, 0x3F72,}, 	// 20130228_tune_20130215_tune_ PGA_TABLE_D65_DATA_7
       {0xD034, 0x2C2C,}, 	//  20130228_tune_PGA_TABLE_D65_DATA_8
       {0xD036, 0xA273,}, 	//  PGA_TABLE_D65_DATA_9
       {0xD038, 0x0730,}, 	//  20130228_tune_PGA_TABLE_D65_DATA_10
       {0xD03A, 0x94ED,}, 	//  20130228_tune_20130215_tune_PGA_TABLE_D65_DATA_11
      {0xD03C, 0x1311,}, 	//  PGA_TABLE_D65_DATA_12
       {0xD03E, 0x8CEF,}, 	//  PGA_TABLE_D65_DATA_13
       {0xD040, 0x9E11,}, 	//  PGA_TABLE_D65_DATA_14
       {0xD042, 0x0850,}, 	//  PGA_TABLE_D65_DATA_15
       {0xD044, 0x500D,}, 	//  PGA_TABLE_D65_DATA_16
       {0xD046, 0x1472,}, 	//  PGA_TABLE_D65_DATA_17
       {0xD048, 0xCFCE,}, 	//  PGA_TABLE_D65_DATA_18
       {0xD04A, 0xFE72,}, 	//  PGA_TABLE_D65_DATA_19
       {0xD04C, 0x396B,}, 	//  PGA_TABLE_D65_DATA_20
       {0xD04E, 0x988F,}, 	//  PGA_TABLE_D65_DATA_21
       {0xD050, 0x88F0,}, 	//  PGA_TABLE_D65_DATA_22
       {0xD052, 0x6ECE,}, 	//  PGA_TABLE_D65_DATA_23
       {0xD054, 0x1B92,}, 	//  PGA_TABLE_D65_DATA_24
       {0xD056, 0x13AC,}, 	//  20130215_tune_PGA_TABLE_D65_DATA_25
       {0xD058, 0x734F,}, 	//  PGA_TABLE_D65_DATA_26
       {0xD05A, 0xAC0E,}, 	//  PGA_TABLE_D65_DATA_27
       {0xD05C, 0xB391,}, 	//  PGA_TABLE_D65_DATA_28
       {0xD05E, 0x560E,}, 	//  PGA_TABLE_D65_DATA_29
       {0xD060, 0x8D0A,}, 	//  PGA_TABLE_D65_DATA_30
       {0xD062, 0x556F,}, 	//  PGA_TABLE_D65_DATA_31
       {0xD064, 0xFD0B,}, 	//  PGA_TABLE_D65_DATA_32
       {0xD066, 0xA2F1,}, 	//  PGA_TABLE_D65_DATA_33
       {0xD068, 0x2CF1,}, 	//  PGA_TABLE_D65_DATA_34
       {0xD06A, 0xA52C,}, 	//  PGA_TABLE_D65_DATA_35
       {0xD06C, 0xAD2F,}, 	//  PGA_TABLE_D65_DATA_36
       {0xD06E, 0x3B0F,}, 	//  PGA_TABLE_D65_DATA_37
       {0xD070, 0x6550,}, 	//  PGA_TABLE_D65_DATA_38
       {0xD072, 0x2571,}, 	//  PGA_TABLE_D65_DATA_39
       {0xD074, 0x15D2,}, 	//  PGA_TABLE_D65_DATA_40
       {0xD076, 0x22AF,}, 	//  PGA_TABLE_D65_DATA_41
       {0xD078, 0xC213,}, 	//  PGA_TABLE_D65_DATA_42
       {0xD07A, 0x1411,}, 	//  PGA_TABLE_D65_DATA_43
       {0xD07C, 0x29F4,}, 	//  PGA_TABLE_D65_DATA_44
       {0xD07E, 0x7C52,}, 	//  PGA_TABLE_D65_DATA_45
       {0xD080, 0x31D0,}, 	//  PGA_TABLE_D65_DATA_46
       {0xD082, 0xF873,}, 	//  PGA_TABLE_D65_DATA_47
       {0xD084, 0xC2D4,}, 	//  PGA_TABLE_D65_DATA_48
       {0xD086, 0xD532,}, 	//  PGA_TABLE_D65_DATA_49
       {0xD088, 0x4011,}, 	//  PGA_TABLE_D65_DATA_50
       {0xD08A, 0x6B4D,}, 	//  PGA_TABLE_D65_DATA_51
       {0xD08C, 0xAF92,}, 	//  PGA_TABLE_D65_DATA_52
       {0xD08E, 0x16F2,}, 	//  PGA_TABLE_D65_DATA_53
       {0xD090, 0x5F33,}, 	//  PGA_TABLE_D65_DATA_54
       {0xD092, 0x0FF2,}, 	//  PGA_TABLE_D65_DATA_55
       {0xD094, 0x854F,}, 	//  PGA_TABLE_D65_DATA_56
       {0xD096, 0x8454,}, 	//  PGA_TABLE_D65_DATA_57
       {0xD098, 0xCF13,}, 	//  PGA_TABLE_D65_DATA_58
       {0xD09A, 0x1DF5,}, 	//  PGA_TABLE_D65_DATA_59
       {0xD09C, 0x59B0,}, 	//  PGA_TABLE_D65_DATA_60
       {0xD09E, 0x60CF,}, 	//  PGA_TABLE_D65_DATA_61
       {0xD0A0, 0x4673,}, 	//  PGA_TABLE_D65_DATA_62
       {0xD0A2, 0x5DD1,}, 	//  PGA_TABLE_D65_DATA_63
       {0xD0A4, 0x9135,}, 	//  PGA_TABLE_D65_DATA_64
       {0xD0A6, 0x58B1,}, 	//  PGA_TABLE_D65_DATA_65
       {0xD0A8, 0x1E4F,}, 	//  PGA_TABLE_D65_DATA_66
       {0xD0AA, 0x0F31,}, 	//  PGA_TABLE_D65_DATA_67
       {0xD0AC, 0x99F4,}, 	//  PGA_TABLE_D65_DATA_68
       {0xD0AE, 0xC753,}, 	//  PGA_TABLE_D65_DATA_69
       {0xD0B0, 0x1F8F,}, 	//  PGA_TABLE_D65_DATA_70
       {0xD0B2, 0xFFCF,}, 	//  PGA_TABLE_D65_DATA_71
       {0xD0B4, 0x2494,}, 	//  PGA_TABLE_D65_DATA_72
       {0xD0B6, 0xF330,}, 	//  PGA_TABLE_D65_DATA_73
       {0xD0B8, 0xC2F5,}, 	//  PGA_TABLE_D65_DATA_74
       {0xD0BA, 0x15CF,}, 	//  PGA_TABLE_D65_DATA_75
       {0xD0BC, 0x1311,}, 	//  PGA_TABLE_D65_DATA_76
       {0xD0BE, 0x3934,}, 	//  PGA_TABLE_D65_DATA_77
       {0xD0C0, 0xBF93,}, 	//  PGA_TABLE_D65_DATA_78
       {0xD0C2, 0xC355,}, 	//  PGA_TABLE_D65_DATA_79
       {0xD0C4, 0xE293,}, 	//  PGA_TABLE_D65_DATA_80
       {0xD0C6, 0xD773,}, 	//  PGA_TABLE_D65_DATA_81
       {0xD0C8, 0x9777,}, 	//  PGA_TABLE_D65_DATA_82
       {0xD0CA, 0x38B6,}, 	//  PGA_TABLE_D65_DATA_83
       {0xD0CC, 0x5DB9,}, 	//  PGA_TABLE_D65_DATA_84
       {0xD0CE, 0xA354,}, 	//  PGA_TABLE_D65_DATA_85
       {0xD0D0, 0x9334,}, 	//  PGA_TABLE_D65_DATA_86
       {0xD0D2, 0xFD97,}, 	//  PGA_TABLE_D65_DATA_87
       {0xD0D4, 0x1A57,}, 	//  PGA_TABLE_D65_DATA_88
       {0xD0D6, 0x409A,}, 	//  PGA_TABLE_D65_DATA_89
       {0xD0D8, 0xA0B3,}, 	//  PGA_TABLE_D65_DATA_90
       {0xD0DA, 0xA3F1,}, 	//  PGA_TABLE_D65_DATA_91
       {0xD0DC, 0xC296,}, 	//  PGA_TABLE_D65_DATA_92
       {0xD0DE, 0x1636,}, 	//  PGA_TABLE_D65_DATA_93
       {0xD0E0, 0x5159,}, 	//  PGA_TABLE_D65_DATA_94
       {0xD0E2, 0xB693,}, 	//  PGA_TABLE_D65_DATA_95
       {0xD0E4, 0x4330,}, 	//  PGA_TABLE_D65_DATA_96
       {0xD0E6, 0x9437,}, 	//  PGA_TABLE_D65_DATA_97
       {0xD0E8, 0x0996,}, 	//  PGA_TABLE_D65_DATA_98
       {0xD0EA, 0x5E79,}, 	//  PGA_TABLE_D65_DATA_99    
       */    
       
       /*D65 shading_20130322*/
       
        {0xD024, 0x0350 ,},
        {0xD026, 0xA10D,},
        {0xD028, 0x7B71,},
        {0xD02A, 0x16EB,},
        {0xD02C, 0xA4B2,},
        {0xD02E, 0x0350 ,},
        {0xD030, 0x1B4E,},
        {0xD032, 0x2E92 ,},
        {0xD034, 0x23EE,},
        {0xD036, 0x9AD3,},
        {0xD038, 0x0170 ,},
        {0xD03A, 0x876D,},
        {0xD03C, 0x16D1,},
        {0xD03E, 0xBD6F,},
        {0xD040, 0xA7B1,},
        {0xD042, 0x01D0,},
        {0xD044, 0x078D,},
        {0xD046, 0x1212 ,},
        {0xD048, 0x93CC,},
        {0xD04A, 0xE1D2,},
        {0xD04C, 0x0DAD,},
        {0xD04E, 0x9F4F ,},
        {0xD050, 0xCEB0,},
        {0xD052, 0x45B0,},
        {0xD054, 0x3912 ,},
        {0xD056, 0x6CEC,},
        {0xD058, 0x63AF ,},
        {0xD05A, 0xC9ED,},
        {0xD05C, 0xA271,},
        {0xD05E, 0x9790 ,},
        {0xD060, 0x210C,},
        {0xD062, 0x6A8F,},
        {0xD064, 0xBC8C,},
        {0xD066, 0xA671,},
        {0xD068, 0x2771,},
        {0xD06A, 0x3D84,},
        {0xD06C, 0xA4EF,},
        {0xD06E, 0x3D4D,},
        {0xD070, 0x7D4E,},
        {0xD072, 0x35B1,},
        {0xD074, 0x0132 ,},
        {0xD076, 0xA7ED,},
        {0xD078, 0xDC13,},
        {0xD07A, 0x1172 ,},
        {0xD07C, 0x2AD4,},
        {0xD07E, 0x2CF2,},
        {0xD080, 0x25B0,},
        {0xD082, 0xF753 ,},
        {0xD084, 0xAA74,},
        {0xD086, 0x3F93 ,},
        {0xD088, 0x5811 ,},
        {0xD08A, 0x02ED,},
        {0xD08C, 0xF133,},
        {0xD08E, 0x2493 ,},
        {0xD090, 0x7BF5,},
        {0xD092, 0x5671,},
        {0xD094, 0x9F8B,},
        {0xD096, 0xAA73,},
        {0xD098, 0xA853 ,},
        {0xD09A, 0x2AF4,},
        {0xD09C, 0x790F,},
        {0xD09E, 0x4F6E,},
        {0xD0A0, 0x370F ,},
        {0xD0A2, 0x7BF3,},
        {0xD0A4, 0x1772 ,},
        {0xD0A6, 0x2B91,},
        {0xD0A8, 0xDA4F,},
        {0xD0AA, 0xF913,},
        {0xD0AC, 0x9E6A,},
        {0xD0AE, 0x3495,},
        {0xD0B0, 0x97F0,},
        {0xD0B2, 0xAE91,},
        {0xD0B4, 0x4773,},
        {0xD0B6, 0x0AF4,},
        {0xD0B8, 0xEBF2,},
        {0xD0BA, 0x6EEE,},
        {0xD0BC, 0x654F,},
        {0xD0BE, 0x5A52,},
        {0xD0C0, 0x2993,},
        {0xD0C2, 0xDAB2,},
        {0xD0C4, 0x9A4F,},
        {0xD0C6, 0x28F3,},
        {0xD0C8, 0x8FD6,},
        {0xD0CA, 0x6296,},
        {0xD0CC, 0x2AB9,},
        {0xD0CE, 0xA08F,},
        {0xD0D0, 0x9153,},
        {0xD0D2, 0x8BB7,},
        {0xD0D4, 0x0937,},
        {0xD0D6, 0x5519,},
        {0xD0D8, 0xD013,},
        {0xD0DA, 0x1F52,},
        {0xD0DC, 0x3B32,},
        {0xD0DE, 0x6D14,},
        {0xD0E0, 0x0898 ,},
        {0xD0E2, 0x1292 ,},
        {0xD0E4, 0x3092 ,},
        {0xD0E6, 0xE0B6,},
        {0xD0E8, 0x5D16,},
        {0xD0EA, 0x3779,},
       
       
       {0xD0EE, 0x0400,}, 	//  PGA_TABLE_D65_CENTER_COLUMN
       {0xD0EC, 0x023C,}, 	//  PGA_TABLE_D65_CENTER_ROW
	{0xCA08, 0x1964,}, 	//  CAM_PGA_R_CONFIG_COLOUR_TEMP
	{0xCA0A, 0x8000,}, 	//  CAM_PGA_R_CONFIG_GREEN_RED_Q14
	{0xCA0C, 0x8000,}, 	//  CAM_PGA_R_CONFIG_RED_Q14
	{0xCA0E, 0x8000,}, 	//  CAM_PGA_R_CONFIG_GREEN_BLUE_Q14
	{0xCA10, 0x8000,}, 	//  CAM_PGA_R_CONFIG_BLUE_Q14
	{0xC9F2, 0x0011,}, 	//  CAM_PGA_PGA_CONTROL
	{0xD018, 0x00FF,}, 	//  PGA_CURRENT_ZONE

	{0xD01C, 0x32, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	//20130227_reddish_tune PGA_ZONE_LO_0
	{0xD01D, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	//20130227_reddish_tune PGA_ZONE_LO_1
	{0xD01E, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// PGA_ZONE_LO_2
	{0xD01F, 0xFF, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// PGA_ZONE_HI_0
	{0xD020, 0x3C, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130227_reddish_tunePGA_ZONE_HI_1
	{0xD021, 0x2D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	//20130227_reddish_tune PGA_ZONE_HI_2
	
	{0xD01B, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// PGA_NUMBER_ZONES
	{0xC9F2, 0x0011,}, 	// CAM_PGA_PGA_CONTROL

	{0xAC0A, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// AWB_R_SCENE_RATIO_LOWER
	{0xAC0B, 0x5E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130227_Reddish_tune_ 4C AWB_R_SCENE_RATIO_UPPER
	{0xAC0C, 0x23, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130227_Reddish_tune_29AWB_B_SCENE_RATIO_LOWER
	{0xAC0D, 0xFF, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// AWB_B_SCENE_RATIO_UPPER
	{0xC8EE, 0x09C4,}, 	// CAM_AWB_COLOR_TEMPERATURE_MIN
	{0xC8F0, 0x1964,}, 	// CAM_AWB_COLOR_TEMPERATURE_MAX
	{0xAC06, 0x63, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// AWB_R_RATIO_LOWER
	{0xAC07, 0x65, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// AWB_R_RATIO_UPPER
	{0xAC08, 0x63, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// AWB_B_RATIO_LOWER
	{0xAC09, 0x65, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// AWB_B_RATIO_UPPER
	{0xC94A, 0x08, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_STAT_LUMA_THRESH_LOW
	{0xC94B, 0xF7, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// CAM_STAT_LUMA_THRESH_HIGH
	
      //[AWB and CCMs 11/14/12 15:19:39]
      {0xC877, 0xFE ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// ADD
      
      /* for MCNEX
      {0xC894, 0x0165,}, 	// CAM_AWB_CCM_L_0
      {0xC896, 0xFFA3,}, 	// CAM_AWB_CCM_L_1
      {0xC898, 0xFFEE,}, 	// CAM_AWB_CCM_L_2
      {0xC89A, 0xFFAE,}, 	// CAM_AWB_CCM_L_3
      {0xC89C, 0x0163,}, 	// CAM_AWB_CCM_L_4
      {0xC89E, 0xFFD9,}, 	// CAM_AWB_CCM_L_5
      {0xC8A0, 0xFFCB,}, 	// CAM_AWB_CCM_L_6
      {0xC8A2, 0xFF9B,}, 	// CAM_AWB_CCM_L_7
      {0xC8A4, 0x01A0,}, 	// CAM_AWB_CCM_L_8
      {0xC8A6, 0x019C,}, 	// CAM_AWB_CCM_M_0
      {0xC8A8, 0xFF7B,}, 	// CAM_AWB_CCM_M_1
      {0xC8AA, 0xFFEA,}, 	// CAM_AWB_CCM_M_2
      {0xC8AC, 0xFFC8,}, 	// CAM_AWB_CCM_M_3
      {0xC8AE, 0x014F,}, 	// CAM_AWB_CCM_M_4
      {0xC8B0, 0xFFED,}, 	// CAM_AWB_CCM_M_5
      {0xC8B2, 0xFFC4,}, 	// CAM_AWB_CCM_M_6
      {0xC8B4, 0xFF89,}, 	// CAM_AWB_CCM_M_7
      {0xC8B6, 0x0186,}, 	// CAM_AWB_CCM_M_8
      {0xC8B8, 0x0137,}, 	// 0108_color_noise_tune 015C    CAM_AWB_CCM_R_0
      {0xC8BA, 0xFFAF,}, 	// 0108_color_noise_tune FF8B    CAM_AWB_CCM_R_1
      {0xC8BC, 0x0015,}, 	// 0108_color_noise_tune 0014 CAM_AWB_CCM_R_2
      {0xC8BE, 0xFFD9,}, 	// 0108_color_noise_tune FFC7    CAM_AWB_CCM_R_3
      {0xC8C0, 0x0153,}, 	// 0108_color_noise_tune 0171 CAM_AWB_CCM_R_4
      {0xC8C2, 0xFFBB,}, 	// 0108_color_noise_tune FFAB    CAM_AWB_CCM_R_5
      {0xC8C4, 0xFFCB,}, 	// 0108_color_noise_tune FFB7    CAM_AWB_CCM_R_6
      {0xC8C6, 0xFFF3,}, 	// 0108_color_noise_tune FFD9    CAM_AWB_CCM_R_7
      {0xC8C8, 0x0163,}, 	// 0108_color_noise_tune 0196 CAM_AWB_CCM_R_8
      */
      
      /*for Cresyne_20130228*/
      {0xC894, 0x01EE ,},  // 130213_tune_bsy_CAM_AWB_CCM_L_0     
      {0xC896, 0xFF33,},  // 130213_tune_bsy_CAM_AWB_CCM_L_1
      {0xC898, 0xFFD8 ,},  // 130213_tune_bsy_CAM_AWB_CCM_L_2
      {0xC89A, 0xFF97 ,},  // 130213_tune_bsy_CAM_AWB_CCM_L_3
      {0xC89C, 0x0189 ,}, // 130213_tune_bsy_CAM_AWB_CCM_L_4
      {0xC89E, 0xFFD8 ,}, // 130213_tune_bsy_ CAM_AWB_CCM_L_5
      {0xC8A0, 0xFF97 ,},  // 130213_tune_bsy_CAM_AWB_CCM_L_6
      {0xC8A2, 0xFF33 ,},   // 130213_tune_bsy_CAM_AWB_CCM_L_7
      {0xC8A4, 0x022E ,},  // 130213_tune_bsy_CAM_AWB_CCM_L_8
      {0xC8A6, 0x0170 ,},   //   CAM_AWB_CCM_M_0
      {0xC8A8, 0xFF71,},   //   CAM_AWB_CCM_M_1
      {0xC8AA, 0xFFE9 ,},   // CAM_AWB_CCM_M_2
      {0xC8AC, 0xFF96,},   // CAM_AWB_CCM_M_3
      {0xC8AE, 0x0199 ,},   // CAM_AWB_CCM_M_4
      {0xC8B0, 0xFFD9 ,},  //CAM_AWB_CCM_M_5
      {0xC8B2, 0xFFB8 ,},   //CAM_AWB_CCM_M_6
      {0xC8B4, 0xFF62 ,},   //   CAM_AWB_CCM_M_7
      {0xC8B6, 0x0199 ,},   //  CAM_AWB_CCM_M_8
      {0xC8B8, 0x014A ,},   //CAM_AWB_CCM_R_0
      {0xC8BA, 0xFF6E,},   //CAM_AWB_CCM_R_1
      {0xC8BC, 0x0012,},   //CAM_AWB_CCM_R_2
      {0xC8BE, 0xFFA8,},   //CAM_AWB_CCM_R_3
      {0xC8C0, 0x01E4 ,},   //CAM_AWB_CCM_R_4
      {0xC8C2, 0xFF92 ,},   // CAM_AWB_CCM_R_5
      {0xC8C4, 0xFFAE ,},   //CAM_AWB_CCM_R_6
      {0xC8C6, 0xFFC0 ,},   //CAM_AWB_CCM_R_7
      {0xC8C8, 0x01A3 ,},   //CAM_AWB_CCM_R_8                     
      
      {0xC8CA, 0x007D,}, 	// CAM_AWB_CCM_L_RG_GAIN
      {0xC8CC, 0x018F,}, 	// CAM_AWB_CCM_L_BG_GAIN    
      {0xC8CE, 0x0085,}, 	// CAM_AWB_CCM_M_RG_GAIN
      {0xC8D0, 0x0142,}, 	// CAM_AWB_CCM_M_BG_GAIN
      {0xC8D2, 0x00BF,}, 	// CAM_AWB_CCM_R_RG_GAIN
      {0xC8D4, 0x00DD,}, 	// CAM_AWB_CCM_R_BG_GAIN    		
	{0xC8D6, 0x09C4,}, 	// CAM_AWB_CCM_L_CTEMP
	{0xC8D8, 0x0D67,}, 	// CAM_AWB_CCM_M_CTEMP
	{0xC8DA, 0x1964,}, 	// CAM_AWB_CCM_R_CTEMP
	{0xC94C, 0x0000,}, 	// CAM_STAT_AWB_CLIP_WINDOW_XSTART
	{0xC94E, 0x0000,}, 	// CAM_STAT_AWB_CLIP_WINDOW_YSTART
	{0xC950, 0x077F,}, 	// CAM_STAT_AWB_CLIP_WINDOW_XEND
	{0xC952, 0x0437,}, 	// CAM_STAT_AWB_CLIP_WINDOW_YEND
	{0xC95C, 0x0020,}, 	// CAM_STAT_AWB_X_SHIFT
	{0xC95E, 0x000C,}, 	// CAM_STAT_AWB_Y_SHIFT
	{0xC8F4, 0x0080,}, 	// CAM_AWB_AWB_XSCALE
	{0xC8F6, 0x00AB,}, 	// CAM_AWB_AWB_YSCALE
	{0xC8F8, 0x03F8,}, 	// CAM_AWB_AWB_ROT_CENTER_X
	{0xC8FA, 0x03DB,}, 	// CAM_AWB_AWB_ROT_CENTER_Y
	{0xC8FD, 0x1A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_AWB_ROT_ANGLE_SIN
	{0xC8FC, 0x2D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_AWB_ROT_ANGLE_COS
	{0xC900, 0x0000,}, 	// CAM_AWB_AWB_WEIGHTS_0
       {0xC902, 0x0001,}, 	// CAM_AWB_AWB_WEIGHTS_1
       {0xC904, 0x1000,}, 	// CAM_AWB_AWB_WEIGHTS_2
	{0xC906, 0x0000,}, 	// CAM_AWB_AWB_WEIGHTS_3
	{0xC908, 0x0000,}, 	// CAM_AWB_AWB_WEIGHTS_4
       {0xC90A, 0x0011,}, 	// CAM_AWB_AWB_WEIGHTS_5
	{0xC90C, 0x1110,}, 	// CAM_AWB_AWB_WEIGHTS_6
	{0xC90E, 0x0000,}, 	// CAM_AWB_AWB_WEIGHTS_7
       {0xC910, 0x0122,}, 	// CAM_AWB_AWB_WEIGHTS_8
       {0xC912, 0x2222,}, 	// CAM_AWB_AWB_WEIGHTS_9
       {0xC914, 0x2332,}, 	// CAM_AWB_AWB_WEIGHTS_10
       {0xC916, 0x2211,}, 	// CAM_AWB_AWB_WEIGHTS_11
       {0xC918, 0x1244,}, 	// CAM_AWB_AWB_WEIGHTS_12
       {0xC91A, 0x4455,}, 	// CAM_AWB_AWB_WEIGHTS_13
       {0xC91C, 0x4444,}, 	// CAM_AWB_AWB_WEIGHTS_14
       {0xC91E, 0x4432,}, 	// CAM_AWB_AWB_WEIGHTS_15
       {0xC920, 0x1245,}, 	// CAM_AWB_AWB_WEIGHTS_16
       {0xC922, 0x5555,}, 	// CAM_AWB_AWB_WEIGHTS_17
       {0xC924, 0x4445,}, 	// CAM_AWB_AWB_WEIGHTS_18
       {0xC926, 0x5442,}, 	// CAM_AWB_AWB_WEIGHTS_19
       {0xC928, 0x1233,}, 	// CAM_AWB_AWB_WEIGHTS_20
       {0xC92A, 0x3444,}, 	// CAM_AWB_AWB_WEIGHTS_21
       {0xC92C, 0x3223,}, 	// CAM_AWB_AWB_WEIGHTS_22
       {0xC92E, 0x3322,}, 	// CAM_AWB_AWB_WEIGHTS_23
       {0xC930, 0x0111,}, 	// CAM_AWB_AWB_WEIGHTS_24
       {0xC932, 0x1222,}, 	// CAM_AWB_AWB_WEIGHTS_25
       {0xC934, 0x1111,}, 	// CAM_AWB_AWB_WEIGHTS_26
       {0xC936, 0x1111,}, 	// CAM_AWB_AWB_WEIGHTS_27
       {0xC938, 0x0000,}, 	// CAM_AWB_AWB_WEIGHTS_28
       {0xC93A, 0x0011,}, 	// CAM_AWB_AWB_WEIGHTS_29
       {0xC93C, 0x0000,}, 	// CAM_AWB_AWB_WEIGHTS_30
       {0xC93E, 0x0000,}, 	// CAM_AWB_AWB_WEIGHTS_31
       {0xC966, 0x72, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130322_8c-->72 CAM_LL_START_SATURATION
	{0x33F4, 0x0515,}, 	// KERNEL_CONFIG
	{0xC81A, 0x003D,}, 	// CAM_SENSOR_CFG_MIN_ANALOG_GAIN
	{0xC81C, 0x00F4,}, 	// CAM_SENSOR_CFG_MAX_ANALOG_GAIN
	{0xC96C, 0x30, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 0108_color noise 2b-->30  CAM_LL_START_DEMOSAIC
	{0xC971, 0x76, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 0102_noise_tune 2b -->76 CAM_LL_STOP_DEMOSAIC
	{0xC96E, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_NOISE_GAIN
	{0xC96D, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_NOISE_KNEE
	{0xC973, 0x53, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_AP_NOISE_GAIN
	{0xC972, 0x74, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 0102_noise_tune 0x1c -->0x74 CAM_LL_STOP_AP_NOISE_KNEE
	{0xC96F, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_GAIN_POS
	{0xC970, 0x0F, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_GAIN_NEG
	{0xC974, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_AP_GAIN_POS
	{0xC975, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_AP_GAIN_NEG
	{0xC976, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_GRB_APOS
	{0xC977, 0x07, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_GRB_BPOS
	{0xC978, 0x0A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_GRB_ANEG
	{0xC979, 0x32, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_GRB_BNEG
	{0xC97A, 0xE3, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_GRB_APOS
	{0xC97C, 0x3B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_GRB_ANEG
	{0xC97B, 0x9D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_GRB_BPOS
	{0xC97D, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_GRB_BNEG
	{0x33F4, 0x0515,}, 	// KERNEL_CONFIG
	{0xC9CE, 0x0040,}, 	// CAM_LL_START_MAX_GAIN_METRIC
	{0xC9D0, 0x0400,}, 	// CAM_LL_MID_MAX_GAIN_METRIC
	{0xC9D2, 0x1000,}, 	// CAM_LL_STOP_MAX_GAIN_METRIC
	{0xC984, 0x00E2,}, 	// 0102_noise_tune 0x0136 -->0x00e2 CAM_LL_START_CDC_HI_THR_COMB
	{0xC988, 0x00D1,}, 	// 0102_noise_tune 0X00d2-->0x00D1 CAM_LL_START_CDC_HI_THR_SATUR
	{0xC98C, 0x00DE,}, 	// 0102_noise_tune 0X00FC-->0x00DE CAM_LL_MID_CDC_HI_THR_COMB
	{0xC990, 0x00D4,}, 	// 0102_noise_tune 0x0132-->0x00D4 CAM_LL_MID_CDC_HI_THR_SATUR
	{0xC994, 0x0319,}, 	// 0102_noise_tune 0x07B6-->0x0319 CAM_LL_STOP_CDC_HI_THR_COMB
	{0xC998, 0x01AD,}, 	// 0102_noise_tune 0x035E-->0x01AD CAM_LL_STOP_CDC_HI_THR_SATUR
	{0xC986, 0x00A0,}, 	// 0102_noise_tune 0x00A9-->0x00A0 CAM_LL_START_CDC_LO_THR_COMB
	{0xC98A, 0x00B5,}, 	// 0102_noise_tune 0x00A6 -->0x00B5 CAM_LL_START_CDC_LO_THR_SATUR
	{0xC98E, 0x0127,}, 	// 0102_noise_tune 0x0119-->0x0127 CAM_LL_MID_CDC_LO_THR_COMB
	{0xC992, 0x00DD,}, 	// 0102_noise_tune 0x0134-->0x00DD CAM_LL_MID_CDC_LO_THR_SATUR
	{0xC996, 0x027D,}, 	// 0102_noise_tune 0x062E-->0x027D CAM_LL_STOP_CDC_LO_THR_COMB
	{0xC99A, 0x011B,}, 	// 0102_noise_tune 0x026F-->0x011B CAM_LL_STOP_CDC_LO_THR_SATUR
	{0xC97E, 0x0000,}, 	//0108_color noise 0f-->06  //CAM_LL_START_DC_SINGLE_PIXEL_THR
	{0xC980, 0x0000,}, 	//0108_color noise 05-->03 //  CAM_LL_STOP_DC_SINGLE_PIXEL_THR
	{0xC99C, 0x0017,}, 	// CAM_LL_START_CDC_CC_NOISE_SLOPE
	{0xC99E, 0x0008,}, 	// CAM_LL_START_CDC_CC_NOISE_KNEE
	{0xC9A0, 0x0026,}, 	// CAM_LL_MID_CDC_CC_NOISE_SLOPE
	{0xC9A2, 0x003E,}, 	// CAM_LL_MID_CDC_CC_NOISE_KNEE
	{0xC9A4, 0x0055,}, 	// CAM_LL_STOP_CDC_CC_NOISE_SLOPE	
	{0xC9A6, 0x00FF,}, 	// CAM_LL_STOP_CDC_CC_NOISE_KNEE
	{0x33F4, 0x0515,}, 	// KERNEL_CONFIG
       {0xC9A8, 0x0030,},	// 0108_noise_tune 003a-->0030 //CAM_LL_ADACD_LUT_GAIN_0
       {0xC9AE, 0x04, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},// 0108_noise_tune 03-->04 //00CAM_LL_ADACD_LUT_SIGMA_0
	{0xC9B2, 0x004C,}, 	// 0108_noise_tune 0034-->004c// CAM_LL_ADACD_LUT_K_0
	{0xC9AA, 0x00B0,}, 	// CAM_LL_ADACD_LUT_GAIN_1
	{0xC9AF, 0x04, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 1129_tune 06-->07CAM_LL_ADACD_LUT_SIGMA_1
	{0xC9B4, 0x005A,}, 	// 0108_noise_tune 0034-->005A //CAM_LL_ADACD_LUT_K_1
	{0xC9AC, 0x00E0,}, 	// CAM_LL_ADACD_LUT_GAIN_2
	{0xC9B0, 0x08, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 0102_noise_tune 0x09-->0x08  CAM_LL_ADACD_LUT_SIGMA_2
	{0xC9B6, 0x006B,}, 	// 0102_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2s
	{0xBC02, 0x0013,}, 	// LL_MODE
	{0xC9BE, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_ADACD_LL_MODE_EN
	{0x3398, 0x2230,},
	{0xC9B1, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_ADACD_PATCH
	{0xC9B8, 0x021F,}, 	// CAM_LL_ADACD_TRT
	{0x326E, 0x0086,}, 	// LOW_PASS_YUV_FILTER
	{0x3270, 0x0FAA,}, 	// THRESHOLD_FOR_Y_FILTER_R_CHANNEL
	{0x3272, 0x0FE4,}, 	// THRESHOLD_FOR_Y_FILTER_G_CHANNEL
	{0xC9CA, 0x0040,}, 	// CAM_LL_START_GAIN_METRIC
	{0xC9CC, 0x1000,}, 	// CAM_LL_STOP_GAIN_METRIC
	{0xC9CE, 0x0040,}, 	// CAM_LL_START_MAX_GAIN_METRIC
	{0xC9D2, 0x1000,}, 	// CAM_LL_STOP_MAX_GAIN_METRIC
	{0xC944, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_R_L
	{0xC945, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_G_L
	{0xC946, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_B_L
	{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne 7e-->80 1129_tune 7c-->7f CAM_AWB_K_R_R
	{0xC948, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_G_R
	{0xC949, 0x7E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130215_tune_ for cresyne 7d-->80 CAM_AWB_K_B_R
	{0xC962, 0x0032,}, 	// CAM_LL_START_BRIGHTNESS
	{0xC964, 0x024D,}, 	// CAM_LL_STOP_BRIGHTNESS
	{0xC87E, 0x3f, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 0108_target 38-->3f //CAM_AET_TARGET_AVERAGE_LUMA
	{0xC87F, 0x51, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AET_TARGET_AVERAGE_LUMA_DARK
	{0x32B2, 0x2314,}, 	// DKDELTA_CCM_CTL
	{0xB402, 0x0002,}, 	// CCM_MODE
	{0xC967, 0x3c, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},  	// CAM_LL_END_SATURATION
	{0xC968, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_DESATURATION
	{0xC969, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_END_DESATURATION
	{0xC96A, 0x18, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_DARK_DELTA_CCM_THR
	{0xC96B, 0x0F, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_DARK_DELTA_CCM_THR
	{0xB42A, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CCM_DELTA_GAIN
	{0xC8DC, 0x0100,}, 	// CAM_AWB_LL_CCM_0
	{0xC8DE, 0x0000,}, 	// CAM_AWB_LL_CCM_1
	{0xC8E0, 0x0000,}, 	// CAM_AWB_LL_CCM_2
	{0xC8E2, 0x0000,}, 	// CAM_AWB_LL_CCM_3
	{0xC8E4, 0x0100,}, 	// CAM_AWB_LL_CCM_4
	{0xC8E6, 0x0000,}, 	// CAM_AWB_LL_CCM_5
	{0xC8E8, 0x0000,}, 	// CAM_AWB_LL_CCM_6
	{0xC8EA, 0x0000,}, 	// CAM_AWB_LL_CCM_7
	{0xC8EC, 0x0100,}, 	// CAM_AWB_LL_CCM_8
	{0xC9EF, 0x25, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_SEQ_DARK_COLOR_KILL
	{0xC9D4, 0x001e,}, 	// CAM_LL_START_FADE_TO_BLACK_LUMA
	{0xC9D6, 0x0012,}, 	// CAM_LL_STOP_FADE_TO_BLACK_LUMA
	{0xCA1C, 0x8040,}, 	// CAM_PORT_OUTPUT_CONTROL
	{0x001E, 0x0777,}, 	// PAD_SLEW
	{0xCA1C, 0x8043,}, 	// CAM_PORT_OUTPUT_CONTROL
	{0xC88A, 0x00D0,}, 	// 0102_noise_tune 0100 -->0x0d0       1129_tune 200-->100 CAM_AET_AE_MAX_VIRT_DGAIN
	
	/* ae weight */
	
	    { 0xA408, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_0
	    { 0xA409, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_1
	    { 0xA40A, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_2
	    { 0xA40B, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_3
	    { 0xA40C, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_4
	    { 0xA40D, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// 0108_AE_weight 01-->64 AE_RULE_AE_WEIGHT_TABLE_1_0
	    { 0xA40E, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_1
	    { 0xA40F, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_2
	    { 0xA410, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_3
	    { 0xA411, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// 0108_AE_weight 01-->64 AE_RULE_AE_WEIGHT_TABLE_1_4
	    { 0xA412, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// 0108_AE_weight 01-->64 AE_RULE_AE_WEIGHT_TABLE_2_0
	    { 0xA413, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_1
	    { 0xA414, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_2
	    { 0xA415, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_3
	    { 0xA416, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// 0108_AE_weight 01-->64 AE_RULE_AE_WEIGHT_TABLE_2_4
	    { 0xA417, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// 0108_AE_weight 01-->64 AE_RULE_AE_WEIGHT_TABLE_3_0
	    { 0xA418, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_1
	    { 0xA419, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_2
	    { 0xA41A, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_3
	    { 0xA41B, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// 0108_AE_weight 01-->64 AE_RULE_AE_WEIGHT_TABLE_3_4
	    { 0xA41C, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_0
	    { 0xA41D, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_1
	    { 0xA41E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_2
	    { 0xA41F, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_3
	    { 0xA420, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_4
	    
	  
	{0xC882, 0x0012,}, 	// 20130123_SKT_0A-->12_CAM_AET_BLACK_CLIPPING_TARGET
       {0xC892, 0x0083,},	// CAM_AET_TARGET_GAIN
	{0xC874, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_OUTPUT_Y_OFFSET
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
	{0x0080, 0x8002,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	{0x0982, 0x0001,}, 	// ACCESS_CTL_STAT
	{0x098A, 0x6000,}, 	// PHYSICAL_ADDRESS_ACCESS
	{0xE000, 0xC0F1,},
	{0xE002, 0x0C3E,},
	{0xE004, 0x08C0,},
	{0xE006, 0xC1A3,},
	{0xE008, 0x7508,},
	{0xE00A, 0x90C3,},
	{0xE00C, 0x71CF,},
	{0xE00E, 0x0000,},
	{0xE010, 0x0E5E,},
	{0xE012, 0x7960,},
	{0xE014, 0x90E1,},
	{0xE016, 0x70CF,},
	{0xE018, 0xFFFF,},
	{0xE01A, 0xD078,},
	{0xE01C, 0x9036,},
	{0xE01E, 0x9019,},
	{0xE020, 0x091F,},
	{0xE022, 0x0003,},
	{0xE024, 0xD915,},
	{0xE026, 0x70CF,},
	{0xE028, 0xFFFF,},
	{0xE02A, 0xD2B8,},
	{0xE02C, 0xA826,},
	{0xE02E, 0xB5C3,},
	{0xE030, 0xB5E1,},
	{0xE032, 0xD800,},
	{0xE034, 0x1C00,},
	{0xE036, 0x3004,},
	{0xE038, 0x0CB6,},
	{0xE03A, 0x06E0,},
	{0xE03C, 0x708B,},
	{0xE03E, 0x0411,},
	{0xE040, 0x08E0,},
	{0xE042, 0xC0A3,},
	{0xE044, 0xD900,},
	{0xE046, 0xF00A,},
	{0xE048, 0x70CF,},
	{0xE04A, 0xFFFF,},
	{0xE04C, 0xE060,},
	{0xE04E, 0x7835,},
	{0xE050, 0x8041,},
	{0xE052, 0x8000,},
	{0xE054, 0xE102,},
	{0xE056, 0xA040,},
	{0xE058, 0x09F1,},
	{0xE05A, 0x8094,},
	{0xE05C, 0x7FE0,},
	{0xE05E, 0xD800,},
	{0xE060, 0xFFFF,},
	{0xE062, 0xDA84,},
	{0xE064, 0xFFFF,},
	{0xE066, 0xE000,},
	{0x098E, 0x0000,}, 	// LOGICAL_ADDRESS_ACCESS
	{0xE000, 0x0044,}, 	// PATCHLDR_LOADER_ADDRESS
	{0xE002, 0x0005,}, 	// PATCHLDR_PATCH_ID
	//{0xE004, 0x51000000 	// PATCHLDR_FIRMWARE_ID
	{0xE004, 0x5100,}, 	// PATCHLDR_FIRMWARE_ID
	{0xE006, 0x0000,}, 	// PATCHLDR_FIRMWARE_ID
	{0x0080, 0xFFF0,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	{0x0080, 0xFFF1,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},

	{0x0982, 0x0001,}, 	// ACCESS_CTL_STAT
	{0x098A, 0x6568,}, 	// PHYSICAL_ADDRESS_ACCESS
	{0xE568, 0xC0F1,},
	{0xE56A, 0xC5E1,},
	{0xE56C, 0x75CF,},
	{0xE56E, 0xFFFF,},
	{0xE570, 0xD5C8,},
	{0xE572, 0x0E42,},
	{0xE574, 0x0820,},
	{0xE576, 0x156C,},
	{0xE578, 0x1100,},
	{0xE57A, 0x71CF,},
	{0xE57C, 0xFF00,},
	{0xE57E, 0x41DC,},
	{0xE580, 0x913B,},
	{0xE582, 0x09FB,},
	{0xE584, 0x821E,},
	{0xE586, 0xE896,},
	{0xE588, 0x9500,},
	{0xE58A, 0xB882,},
	{0xE58C, 0xB500,},
	{0xE58E, 0x1568,},
	{0xE590, 0x1100,},
	{0xE592, 0xE001,},
	{0xE594, 0x1D68,},
	{0xE596, 0x1004,},
	{0xE598, 0x1568,},
	{0xE59A, 0x1100,},
	{0xE59C, 0xE884,},
	{0xE59E, 0xD801,},
	{0xE5A0, 0x1D68,},
	{0xE5A2, 0x1004,},
	{0xE5A4, 0x208A,},
	{0xE5A6, 0x0010,},
	{0xE5A8, 0x0B1E,},
	{0xE5AA, 0x06E0,},
	{0xE5AC, 0xD901,},
	{0xE5AE, 0xF004,},
	{0xE5B0, 0x1D70,},
	{0xE5B2, 0x1002,},
	{0xE5B4, 0x06A9,},
	{0xE5B6, 0x0880,},
	{0xE5B8, 0xD900,},
	{0xE5BA, 0xF00A,},
	{0xE5BC, 0x70CF,},
	{0xE5BE, 0xFFFF,},
	{0xE5C0, 0xE5D4,},
	{0xE5C2, 0x7835,},
	{0xE5C4, 0x8041,},
	{0xE5C6, 0x8000,},
	{0xE5C8, 0xE102,},
	{0xE5CA, 0xA040,},
	{0xE5CC, 0x09F1,},
	{0xE5CE, 0x8094,},
	{0xE5D0, 0x7FE0,},
	{0xE5D2, 0xD800,},
	{0xE5D4, 0xFFFF,},
	{0xE5D6, 0xDCA8,},
	{0xE5D8, 0xFFFF,},
	{0xE5DA, 0xE568,},
	{0x098E, 0x0000,}, 	// LOGICAL_ADDRESS_ACCESS
	{0xE000, 0x05B8,}, 	// PATCHLDR_LOADER_ADDRESS
	{0xE002, 0x0205,}, 	// PATCHLDR_PATCH_ID
	//{0xE004, 0x51000000 	// PATCHLDR_FIRMWARE_ID
	{0xE004, 0x5100,}, 	// PATCHLDR_FIRMWARE_ID
	{0xE006, 0x0000,}, 	// PATCHLDR_FIRMWARE_ID
	{0x0080, 0xFFF0,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	{0x0080, 0xFFF1,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	{0x0982, 0x0001,}, 	// ACCESS_CTL_STAT
	{0x098A, 0x65DC,}, 	// PHYSICAL_ADDRESS_ACCESS
	{0xE5DC, 0xC0F1,},
	{0xE5DE, 0x0E62,},
	{0xE5E0, 0x0880,},
	{0xE5E2, 0x75CF,},
	{0xE5E4, 0xFFFF,},
	{0xE5E6, 0xD78C,},
	{0xE5E8, 0x85EF,},
	{0xE5EA, 0x95C8,},
	{0xE5EC, 0x70E9,},
	{0xE5EE, 0x0E86,},
	{0xE5F0, 0x08A0,},
	{0xE5F2, 0x71C9,},
	{0xE5F4, 0xE084,},
	{0xE5F6, 0x20CA,},
	{0xE5F8, 0x0125,},
	{0xE5FA, 0xF783,},
	{0xE5FC, 0x7810,},
	{0xE5FE, 0x7A30,},
	{0xE600, 0xB52E,},
	{0xE602, 0xD980,},
	{0xE604, 0xA52E,},
	{0xE606, 0xD900,},
	{0xE608, 0xB52B,},
	{0xE60A, 0x9522,},
	{0xE60C, 0xB50F,},
	{0xE60E, 0x093D,},
	{0xE610, 0x015E,},
	{0xE612, 0x208C,},
	{0xE614, 0x8002,},
	{0xE616, 0xF65A,},
	{0xE618, 0x73CF,},
	{0xE61A, 0xFFFF,},
	{0xE61C, 0xD03C,},
	{0xE61E, 0x9327,},
	{0xE620, 0x0A15,},
	{0xE622, 0x0043,},
	{0xE624, 0x0811,},
	{0xE626, 0x0152,},
	{0xE628, 0x6829,},
	{0xE62A, 0x7830,},
	{0xE62C, 0xB52F,},
	{0xE62E, 0x62D9,},
	{0xE630, 0x7A30,},
	{0xE632, 0xB52E,},
	{0xE634, 0x9328,},
	{0xE636, 0x0915,},
	{0xE638, 0x0083,},
	{0xE63A, 0xB52E,},
	{0xE63C, 0x78CC,},
	{0xE63E, 0x7127,},
	{0xE640, 0x0E32,},
	{0xE642, 0x08A0,},
	{0xE644, 0x6F17,},
	{0xE646, 0xA50E,},
	{0xE648, 0x0605,},
	{0xE64A, 0x0880,},
	{0xE64C, 0xD900,},
	{0xE64E, 0xF00A,},
	{0xE650, 0x70CF,},
	{0xE652, 0xFFFF,},
	{0xE654, 0xE668,},
	{0xE656, 0x7835,},
	{0xE658, 0x8041,},
	{0xE65A, 0x8000,},
	{0xE65C, 0xE102,},
	{0xE65E, 0xA040,},
	{0xE660, 0x09F1,},
	{0xE662, 0x8094,},
	{0xE664, 0x7FE0,},
	{0xE666, 0xD800,},
	{0xE668, 0xFFFF,},
	{0xE66A, 0xDD18,},
	{0xE66C, 0xFFFF,},
	{0xE66E, 0xE5DC,},
	{0x098E, 0x0000,}, 	// LOGICAL_ADDRESS_ACCESS
	{0xE000, 0x064C,}, 	// PATCHLDR_LOADER_ADDRESS
	{0xE002, 0x0305,}, 	// PATCHLDR_PATCH_ID
	//{0xE004, 0x51000000 	// PATCHLDR_FIRMWARE_ID
	{0xE004, 0x5100,}, 	// PATCHLDR_FIRMWARE_ID 
	{0xE006, 0x0000,}, 	// PATCHLDR_FIRMWARE_ID 
	{0x0080, 0xFFF0,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	{0x0080, 0xFFF1,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	{0x0982, 0x0001,}, 	// ACCESS_CTL_STAT
	{0x098A, 0x6670,}, 	// PHYSICAL_ADDRESS_ACCESS
	{0xE670, 0xC0F1,},
	{0xE672, 0x0DCE,},
	{0xE674, 0x08A0,},
	{0xE676, 0x2256,},
	{0xE678, 0x0802,},
	{0xE67A, 0xC1A3,},
	{0xE67C, 0x73CF,},
	{0xE67E, 0xFFFF,},
	{0xE680, 0xD2F0,},
	{0xE682, 0x7F50,},
	{0xE684, 0x220A,},
	{0xE686, 0x1F80,},
	{0xE688, 0xFFFF,},
	{0xE68A, 0xD825,},
	{0xE68C, 0x72CF,},
	{0xE68E, 0xFFFF,},
	{0xE690, 0xD1FC,},
	{0xE692, 0xC040,},
	{0xE694, 0x080D,},
	{0xE696, 0x0281,},
	{0xE698, 0x8B00,},
	{0xE69A, 0xC041,},
	{0xE69C, 0x8AA8,},
	{0xE69E, 0xF005,},
	{0xE6A0, 0x8B01,},
	{0xE6A2, 0x8AA9,},
	{0xE6A4, 0xC041,},
	{0xE6A6, 0xD819,},
	{0xE6A8, 0x0DDA,},
	{0xE6AA, 0x08A0,},
	{0xE6AC, 0xB80A,},
	{0xE6AE, 0x7810,},
	{0xE6B0, 0xC042,},
	{0xE6B2, 0xDE00,},
	{0xE6B4, 0xF006,},
	{0xE6B6, 0xD800,},
	{0xE6B8, 0xC100,},
	{0xE6BA, 0x61D9,},
	{0xE6BC, 0xE601,},
	{0xE6BE, 0xA900,},
	{0xE6C0, 0x0EB3,},
	{0xE6C2, 0x14D5,},
	{0xE6C4, 0x70CF,},
	{0xE6C6, 0xFFFF,},
	{0xE6C8, 0xE794,},
	{0xE6CA, 0x8000,},
	{0xE6CC, 0x60CB,},
	{0xE6CE, 0x2302,},
	{0xE6D0, 0x0340,},
	{0xE6D2, 0x780E,},
	{0xE6D4, 0x0B2F,},
	{0xE6D6, 0x0363,},
	{0xE6D8, 0x2D40,},
	{0xE6DA, 0x1202,},
	{0xE6DC, 0x71E9,},
	{0xE6DE, 0x2182,},
	{0xE6E0, 0x0008,},
	{0xE6E2, 0x790C,},
	{0xE6E4, 0x7227,},
	{0xE6E6, 0x7A6C,},
	{0xE6E8, 0xC201,},
	{0xE6EA, 0x712F,},
	{0xE6EC, 0x784C,},
	{0xE6EE, 0x2904,},
	{0xE6F0, 0x703E,},
	{0xE6F2, 0x7127,},
	{0xE6F4, 0x796C,},
	{0xE6F6, 0x702F,},
	{0xE6F8, 0x0D8A,},
	{0xE6FA, 0x08A0,},
	{0xE6FC, 0x71A9,},
	{0xE6FE, 0x71A9,},
	{0xE700, 0xF012,},
	{0xE702, 0x250E,},
	{0xE704, 0x1F81,},
	{0xE706, 0x0000,},
	{0xE708, 0x0100,},
	{0xE70A, 0x792E,},
	{0xE70C, 0x270E,},
	{0xE70E, 0x1F83,},
	{0xE710, 0x0000,},
	{0xE712, 0x0100,},
	{0xE714, 0x7B0C,},
	{0xE716, 0x732F,},
	{0xE718, 0x79EC,},
	{0xE71A, 0x7327,},
	{0xE71C, 0x7B0C,},
	{0xE71E, 0x702F,},
	{0xE720, 0x7A2C,},
	{0xE722, 0x7027,},
	{0xE724, 0x0D5E,},
	{0xE726, 0x0880,},
	{0xE728, 0xE080,},
	{0xE72A, 0x0040,},
	{0xE72C, 0x002C,},
	{0xE72E, 0x20CA,},
	{0xE730, 0x002C,},
	{0xE732, 0x0B82,},
	{0xE734, 0x0320,},
	{0xE736, 0xD908,},
	{0xE738, 0xC102,},
	{0xE73A, 0x2099,},
	{0xE73C, 0x0008,},
	{0xE73E, 0xDC80,},
	{0xE740, 0x782C,},
	{0xE742, 0x210E,},
	{0xE744, 0xF300,},
	{0xE746, 0xDCFF,},
	{0xE748, 0x20C0,},
	{0xE74A, 0x0304,},
	{0xE74C, 0xB848,},
	{0xE74E, 0xD908,},
	{0xE750, 0x0AF6,},
	{0xE752, 0x0320,},
	{0xE754, 0x7228,},
	{0xE756, 0x7108,},
	{0xE758, 0xB83F,},
	{0xE75A, 0x6038,},
	{0xE75C, 0x781C,},
	{0xE75E, 0x70C7,},
	{0xE760, 0x0001,},
	{0xE762, 0x0000,},
	{0xE764, 0x0D1E,},
	{0xE766, 0x0880,},
	{0xE768, 0x084F,},
	{0xE76A, 0x8012,},
	{0xE76C, 0x2089,},
	{0xE76E, 0x0FC3,},
	{0xE770, 0xF1A4,},
	{0xE772, 0x04DD,},
	{0xE774, 0x08A0,},
	{0xE776, 0xC0A3,},
	{0xE778, 0xD900,},
	{0xE77A, 0xF00A,},
	{0xE77C, 0x70CF,},
	{0xE77E, 0xFFFF,},
	{0xE780, 0xE798,},
	{0xE782, 0x7835,},
	{0xE784, 0x8041,},
	{0xE786, 0x8000,},
	{0xE788, 0xE102,},
	{0xE78A, 0xA040,},
	{0xE78C, 0x09F1,},
	{0xE78E, 0x8094,},
	{0xE790, 0x7FE0,},
	{0xE792, 0xD800,},
	{0xE794, 0x0001,},
	{0xE796, 0x03A8,},
	{0xE798, 0xFFFF,},
	{0xE79A, 0xDD68,},
	{0xE79C, 0xFFFF,},
	{0xE79E, 0xE670,},
	{0x098E, 0x0000,}, 	// LOGICAL_ADDRESS_ACCESS
	{0xE000, 0x0778,}, 	// PATCHLDR_LOADER_ADDRESS
	{0xE002, 0x0405,}, 	// PATCHLDR_PATCH_ID
	//{0xE004, 0x51000000 	// PATCHLDR_FIRMWARE_ID
	{0xE004, 0x5100,}, 	// PATCHLDR_FIRMWARE_ID 
	{0xE006, 0x0000,}, 	// PATCHLDR_FIRMWARE_ID
	{0x0080, 0xFFF0,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	{0x0080, 0xFFF1,}, 	// COMMAND_REGISTER
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_0 =>  0x00
	{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_APPLY_PATCH,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},

	{0xBC02, 0x001B,}, 	// LL_MODE
	{0xC960, 0x0003,}, 	// CAM_LL_LLMODE
	{0xBC08, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// LL_GAMMA_SELECT
	{0xC9C4, 0x00e3,}, 	// CAM_LL_GAMMA
	{0xC9C6, 0x52, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	{0xC9C7, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_STOP_CONTRAST_GRADIENT
	{0xC9C8, 0x2E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	{0xC9C9, 0x04, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tuneCAM_LL_STOP_CONTRAST_LUMA_PERCENTAGE
	{0xE400, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// PATCHVARS_START_ORIGIN_GRADIENT
	{0xE401, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// PATCHVARS_STOP_ORIGIN_GRADIENT
	{0xC9C0, 0x0266,}, 	// CAM_LL_START_CONTRAST_BM
	{0xC9C2, 0x0400,}, 	// 20130727_reddish_tuneCAM_LL_STOP_CONTRAST_BM
	{0x3C40, 0x7820,},	// Non-continuous mode
       {0xC860, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},// CAM_CROP_CROPMODE
       
       {0xA808, 0x004B ,},	// AE_TRACK_GATE
       
       	    
	/* AE speed*/
	{ 0xA82C, 0x0000,},    // AE_TRACK_MODE
	{ 0xA82E, 0x00C0,},    // AE_TRACK_STOP_DAMPING_EXPOSURE_LOG
	{ 0xA830, 0x0010,},     // AE_TRACK_START_DAMPING_VALUE
	{ 0xA832, 0x0080,},     // AE_TRACK_STOP_DAMPING_VALUE
	{ 0xA834, 0x0008,},    // AE_TRACK_MIN_STEP_SIZE
	{ 0xA836, 0x00C0,},    // AE_TRACK_MAX_STEP_SIZE
	{ 0xA802, 0x0008,},     // AE_TRACK_MODE
       { 0xA807, 0x20, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, // AE_TRACK_AE_TRACKING_SPEED
       { 0xAC17, 0x20 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},   // AWB_STATISTICS_TRACKING_SPEED
       //{ 0xA830, 0x0060},   // AE_TRACK_AE_TRACKING_SPEED
       //{ 0xA832, 0x0200},   // AWB_STATISTICS_TRACKING_SPEED
                                                                                                                                                              
                                                                                 
	{0x098E, 0xDC00,}, 	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
	{0x0080, 0x8002,}, 	
	//  POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00	
};


static struct msm_camera_i2c_reg_conf as0260_cfg_brightness[][AS0260_BRIGHTNESS_PARM] = {
{//[brightness-4]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x0064,}, 	// CAM_LL_GAMMA
},
{//[brightness-3]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x0082,}, 	// CAM_LL_GAMMA
},	
{//[brightness-2]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x00A0,}, 	// CAM_LL_GAMMA
},
{//[brightness-1]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x00BE,}, 	// CAM_LL_GAMMA
},
{//[brightness 0]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x00E3,}, 	// CAM_LL_GAMMA // default modi 20130123
},
{//[brightness+1]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x00F0,}, 	// CAM_LL_GAMMA
},
{//[brightness+2]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x0104,}, 	// CAM_LL_GAMMA
},
{//[brightness+3]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x0118,}, 	// CAM_LL_GAMMA
},
{//[brightness+4]
	{0x098E, 0x49C4,}, 	// LOGICAL_ADDRESS_ACCESS {//[CAM_LL_GAMMA]
	{0xC9C4, 0x012C,}, 	// CAM_LL_GAMMA
},
};

static struct msm_camera_i2c_reg_conf as0260_cfg_effect[][AS0260_EFFECT_PARM] = {
{	//[effect auto]
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[mono]
	{0x098E, 0xC878 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0x098E, 0xC878 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0x098E, 0xC878 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0xC878, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[nagative]
	{0x098E, 0xC878 ,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0x098E, 0xC878 ,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0x098E, 0xC878 ,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0xC878, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[solarize]
	{0x098E, 0xC878 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0x098E, 0xC878 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0x098E, 0xC878 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0xC878, 0x04, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[Sepia]
	{0xC87A, 0x23, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_SEPIA_CR
	{0xC87B, 0xb2, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_SEPIA_CB
	{0x098E, 0xC878 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SFX_CONTROL]
	{0xC878, 0x02, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[effect auto], //POSTERIZE,
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[effect auto], //WHITEBOARD
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[effect auto], //BLACKBOARD
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xC878, 0x00, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
{	//[aqua]
	{0xC87A, 0xD8, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_SEPIA_CR
	{0xC87B, 0x2D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_SFX_SEPIA_CB
	{0x098E, 0xC878 ,},
	{0xC878, 0x02, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },    // CAM_SFX_CONTROL
	{0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// SYSMGR_NEXT_STATE
	{0x0080, 0x8004 ,},
},
};


static struct msm_camera_i2c_reg_conf as0260_cfg_exposure_mode[][AS0260_EXPOSURE_MODE_PARM] = {
	{//Default AE Weight //[AE center weight]
	    { 0xA404, 0x0001,}, 	// AE_RULE_ALGO               
	    { 0xA408, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_0
	    { 0xA409, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_1
	    { 0xA40A, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_2
	    { 0xA40B, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_3
	    { 0xA40C, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_4
	    { 0xA40D, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_0
	    { 0xA40E, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_1
	    { 0xA40F, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_2
	    { 0xA410, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_3
	    { 0xA411, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_4
	    { 0xA412, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_0
	    { 0xA413, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_1
	    { 0xA414, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_2
	    { 0xA415, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_3
	    { 0xA416, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_4
	    { 0xA417, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_0
	    { 0xA418, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_1
	    { 0xA419, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_2
	    { 0xA41A, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_3
	    { 0xA41B, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_4
	    { 0xA41C, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_0
	    { 0xA41D, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_1
	    { 0xA41E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_2
	    { 0xA41F, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_3
	    { 0xA420, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_4
	},
	{
		//[AE average]
	    { 0xA404, 0x0001 ,},	// AE_RULE_ALGO
	    { 0xA408, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_0
	    { 0xA409, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_1
	    { 0xA40A, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_2
	    { 0xA40B, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_3
	    { 0xA40C, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_4
	    { 0xA40D, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_0
	    { 0xA40E, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_1
	    { 0xA40F, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_2
	    { 0xA410, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_3
	    { 0xA411, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_4
	    { 0xA412, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_0
	    { 0xA413, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_1
	    { 0xA414, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_2
	    { 0xA415, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_3
	    { 0xA416, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_4
	    { 0xA417, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_0
	    { 0xA418, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_1
	    { 0xA419, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_2
	    { 0xA41A, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_3
	    { 0xA41B, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_4
	    { 0xA41C, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_0
	    { 0xA41D, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_1
	    { 0xA41E, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_2
	    { 0xA41F, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_3
	    { 0xA420, 0x32 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_4
	},
	{
		//[AE center weight]
	    { 0xA404, 0x0001,}, 	// AE_RULE_ALGO               
	    { 0xA408, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_0
	    { 0xA409, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_1
	    { 0xA40A, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_2
	    { 0xA40B, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_3
	    { 0xA40C, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_0_4
	    { 0xA40D, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_0
	    { 0xA40E, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_1
	    { 0xA40F, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_2
	    { 0xA410, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_3
	    { 0xA411, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_1_4
	    { 0xA412, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_0
	    { 0xA413, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_1
	    { 0xA414, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_2
	    { 0xA415, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_3
	    { 0xA416, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_2_4
	    { 0xA417, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_0
	    { 0xA418, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_1
	    { 0xA419, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_2
	    { 0xA41A, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_3
	    { 0xA41B, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_3_4
	    { 0xA41C, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_0
	    { 0xA41D, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_1
	    { 0xA41E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_2
	    { 0xA41F, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_3
	    { 0xA420, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// AE_RULE_AE_WEIGHT_TABLE_4_4
	},
	{
		//[AE SPOT]
	    { 0xA404, 0x0001 ,},	// AE_RULE_ALGO
	    { 0xA408, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_0_0
	    { 0xA409, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_0_1
	    { 0xA40A, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_0_2
	    { 0xA40B, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_0_3
	    { 0xA40C, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_0_4
	    { 0xA40D, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_1_0
	    { 0xA40E, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_1_1
	    { 0xA40F, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_1_2
	    { 0xA410, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_1_3
	    { 0xA411, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_1_4
	    { 0xA412, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_2_0
	    { 0xA413, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_2_1
	    { 0xA414, 0x64 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_2_2
	    { 0xA415, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_2_3
	    { 0xA416, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_2_4
	    { 0xA417, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_3_0
	    { 0xA418, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_3_1
	    { 0xA419, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_3_2
	    { 0xA41A, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_3_3
	    { 0xA41B, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_3_4
	    { 0xA41C, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_4_0
	    { 0xA41D, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_4_1
	    { 0xA41E, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_4_2
	    { 0xA41F, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_4_3
	    { 0xA420, 0x00 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// AE_RULE_AE_WEIGHT_TABLE_4_4
	},
};

static struct msm_camera_i2c_reg_conf as0260_cfg_reflect[][AS0260_REFLECT_PARM] = {
	{//[mirror flip off]
	    { 0x098E, 0x4830 ,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CONTROL_READ_MODE]
	    { 0xC830, 0x0002 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xC830, 0x0002 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
	},
	{//[Mirror flip]
	    { 0x098E, 0x4830 ,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CONTROL_READ_MODE]
	    { 0xC830, 0x0003 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xC830, 0x0003 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
	},
	{//[vertical flip]
	    { 0x098E, 0x4830 ,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CONTROL_READ_MODE]
	    { 0xC830, 0x0002 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xC830, 0x0000 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
	},
	{//[Horizontal Mirror]
	    { 0x098E, 0x4830 ,}, 	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CONTROL_READ_MODE]
	    { 0xC830, 0x0003 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xC830, 0x0001 ,}, 	// CAM_SENSOR_CONTROL_READ_MODE
	    { 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
	},
};

static struct msm_camera_i2c_reg_conf as0260_cfg_wb[][AS0260_WB_PARM] = {
{//	[Auto]
	{ 0xC941, 0x03 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0xC941, 0x03 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0x098E, 0xC944 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_AWB_K_R_L]
	{ 0xC944, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_L
	{ 0xC945, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_L
	{ 0xC946, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//CAM_AWB_K_B_L
	{ 0xC947,  0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201_7e-->80 1129_tune 7c-->7f CAM_AWB_K_R_R
	{ 0xC948,  0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_G_R
	{ 0xC949,  0x7E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130215_tune for cresyne_20130201_7D-->80CAM_AWB_K_B_R
},
{//	[Auto]
	{ 0xC941, 0x03 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0xC941, 0x03 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0x098E, 0xC944 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_AWB_K_R_L]
	{ 0xC944, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_L
	{ 0xC945, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_L
	{ 0xC946, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_L
	{ 0xC947,  0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201_7e-->80 1129_tune 7c-->7f CAM_AWB_K_R_R
	{ 0xC948,  0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_G_R
	{ 0xC949,  0x7E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130215_tunefor cresyne_201
},
{//	[Auto]
	{ 0xC941, 0x03 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0xC941, 0x03 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0x098E, 0xC944 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_AWB_K_R_L]
	{ 0xC944, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_L
	{ 0xC945, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_L
	{ 0xC946, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_L
	{ 0xC947,  0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 7c-->7f CAM_AWB_K_R_R
	{ 0xC948,  0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_G_R
	{ 0xC949,  0x7E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130215_tune CAM_AWB_K_B_R
},
{//	[A], Inca
	{ 0xC941, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0x098E, 0xC944 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_AWB_K_R_L]
	{ 0xC944, 0x72 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_L
	{ 0xC945, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_L
	{ 0xC946, 0x90 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_L
	{ 0xC947, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_R
	{ 0xC948, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_R
	{ 0xC949, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_R
	{ 0xC8F2, 0x09C4 ,},	// CAM_AWB_COLOR_TEMPERATURE
},
{//	[CWF], Fluorescent
	{ 0xC941, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0x098E, 0xC947 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_AWB_K_R_R]
	{ 0xC944, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_L
	{ 0xC945, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_L
	{ 0xC946, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_L
	{ 0xC947, 0xA9 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_R
	{ 0xC948, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_R
	{ 0xC949, 0x8C , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_R
	{ 0xC8F2, 0x0FA0 ,},	// CAM_AWB_COLOR_TEMPERATURE
},
{//	[day] 
	{ 0xC941, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0x098E, 0xC947 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_AWB_K_R_R]
	{ 0xC944, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_L
	{ 0xC945, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_L
	{ 0xC946, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_L
	{ 0xC947, 0xA7 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_R
	{ 0xC948, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_R
	{ 0xC949, 0x7E , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_R
	{ 0xC8F2, 0x1964 ,},	// CAM_AWB_COLOR_TEMPERATURE
},
{//	[cloudy]
	{ 0xC941, 0x01 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_AWBMODE
	{ 0x098E, 0xC947 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_AWB_K_R_R]
	{ 0xC944, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_L
	{ 0xC945, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_L
	{ 0xC946, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_L
	{ 0xC947, 0xCB , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_R_R
	{ 0xC948, 0x80 , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_G_R
	{ 0xC949, 0x6D , MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_AWB_K_B_R
	{ 0xC8F2, 0x1964 ,},	// CAM_AWB_COLOR_TEMPERATURE
},
};

static struct msm_camera_i2c_reg_conf as0260_cfg_aec_lock[][AS0260_AEC_LOCK] = {
	//[AE lock]
	{{ 0xA804, 0x00BE ,},},
	//[AE unlock]
	{{ 0xA804, 0x00BF ,},},
};


static struct msm_camera_i2c_reg_conf as0260_cfg_preview_fps[][AS0260_PREVIEW_FPS_PARM] = {
	{//[5fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS 
		{ 0xC812, 0x1B58 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0500 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0500 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2
				
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config
	},
	{//[6fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x16DA ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0600 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0600 ,},	// CAM_AET_MIN_FRAME_RATE
		
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2
              
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[7fps]				
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x1388 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0700 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0700 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2
		
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[8fps]		
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x1130 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0800 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0800 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C
		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2
              
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[9fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0F3C ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0900 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0900 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2
              
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[10fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0DAC ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0A00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0A00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2
              
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[11fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0C7F ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0B00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0B00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//20130727_reddish_tune 20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[12fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0B72 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0C00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0C00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//20130727_reddish_tune 20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[13fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0A8C ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0D00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0D00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//20130727_reddish_tune 20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[14fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x09D8 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0E00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0E00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[15fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x092E ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x0F00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0F00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


	/* variabl noise*/
		{0xC9AE, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_tune 0x07-->0x08 CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0034,},     // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004C,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0107_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[16fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x089B ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1000 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1000 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[17fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x081B ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1100 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1100 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[18fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x07A8 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1200 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1200 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},					   
	{//[19fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0740 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1300 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1300 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//20130727_reddish_tune 20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
            {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},					   
	{//[20fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x06E3 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1400 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1400 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[21fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0690 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1500 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1500 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_	1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[22fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0640 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1600 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1600 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//20130727_reddish_tune 20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
            {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},					   
	{//[23fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x05FF ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1700 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1700 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
              {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	    {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[24fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x05BE ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1800 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1800 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
              {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[25fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0582 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1900 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1900 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
              {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[26fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x054B ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1a00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1a00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//20130727_reddish_tune 20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
              {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},					   
						 
	{//[27fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x0519 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1b00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1b00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
              {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
		
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
     	{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[28fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x04ec ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1c00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1c00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	//20130727_reddish_tune 20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
        {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
		
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C

		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},
	{//[29fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x04c2 ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1d00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1d00 ,},	// CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
		{0xAC0B, 0x71, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130727_reddish_tune20130214_Skt_TUNE_for cresyne_20130201 5A-->6B 20130123_SKT_57-->5a_AWB_R_SCENE_RATIO_UPPER	//0x46
              {0xAC0C, 0x21, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201 25-->21 20130123_SKT_ADD_29-->28AWB_B_SCENE_RATIO_LOWER

		{0xC96E, 0x01, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x0E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x17, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0x6E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x06, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	       {0xC9C8, 0x24, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
		
		
		{0xD01C, 0x96, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_LO_0	//0x8C
		{0xD020, 0x9A, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x46, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 }, 	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_8e-->32_PGA_ZONE_LO_1  //0x8E
		{0xD021, 0x4D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// 20130228_tune20130214_Skt_TUNE_20130123_SKT_PGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x7B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_87-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		
		
		{0xC877, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x64, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C


		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1
              {0xC9B0, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config 
	},										  
	{//[30fps]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	// LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x049A ,},	// CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1e00 ,},	// CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x1e00 ,},	// CAM_AET_MIN_FRAME_RATE
		{ 0xC88A, 0x0200  ,}, 	// CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		
	 	{0xAC0B, 0x5E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tune0103_reddish_modi 46-->4c AWB_R_SCENE_RATIO_UPPER	//0x46
             {0xAC0C, 0x23, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tune20130123_SKT_ADD_AWB_B_SCENE_RATIO_LOWER
		
		{0xC96E, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_GAIN_POS		//0x09
		{0xC970, 0x0f, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0xf7, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x52, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	    {0xC9C8, 0x2E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	       
		{0xD01C, 0x32, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tunePGA_ZONE_LO_0	//0x8C
		{0xD020, 0x3C, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	//20130727_reddish_tune PGA_ZONE_HI_1  //0x90
		{0xD01D, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tunePGA_ZONE_LO_1  //0x82
		{0xD021, 0x2D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tunePGA_ZONE_HI_2  //0x87
         
		 /*20130228_add*/
		{0xC946, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130228_tune CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201_7e-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x7C, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		{0xC877, 0xfe, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x72, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130322_8c-->72 CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201CAM_AWB_CCM_M_RG_GAIN  //0x8C   
		
		
		/* 30fps noise modi*/
		{0xC9AE, 0x05, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_0 
              {0xC9AF, 0x0B, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1 
              {0xC9B0, 0x08, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},         // 0103_noise_tune 09-->08 CAM_LL_ADACD_LUT_SIGMA_2  
              {0xC9B2, 0x0058,},    // CAM_LL_ADACD_LUT_K_0
              {0xC9B4, 0x004A,},     // CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x0048,},     // CAM_LL_ADACD_LUT_K_2

		
				
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config
	},
	{//[variable frame]
		{ 0xA804, 0x00BF ,},	//[AE unlock]
		{ 0x098E, 0x4812 ,},	  // LOGICAL_ADDRESS_ACCESS [CAM_SENSOR_CFG_FRAME_LENGTH_LINES]
		{ 0xC812, 0x049A ,},	  // CAM_SENSOR_CFG_FRAME_LENGTH_LINES
		{ 0xC88E, 0x1e00 ,},	  // CAM_AET_MAX_FRAME_RATE
		{ 0xC890, 0x0A00 ,},	   // CAM_AET_MIN_FRAME_RATE
		{0xC88A, 0x00D0  ,}, 	   // 0102_noise_tune 0100 -->0x0d0  CAM_AET_AE_MAX_VIRT_DGAIN  //0x0100
		{0xAC0B, 0x5E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	//20130727_reddish_tune 0102_reddish_modi 46-->4c AWB_R_SCENE_RATIO_UPPER	//0x46
		{0xAC0C, 0x23, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tune20130123_SKT_ADD_AWB_B_SCENE_RATIO_LOWER
		

		{0xC96E, 0x03, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_NOISE_GAIN  //0x03
		{0xC96F, 0x09, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_GAIN_POS		//0x09       
		{0xC970, 0x0f, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_AP_GAIN_NEG   //0x0f
		{0xC94B, 0xf7, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_STAT_LUMA_THRESH_HIGH	//0xf7
		
		/*20130228_add*/
		{0xC9C6, 0x52, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_LL_START_CONTRAST_GRADIENT
	    {0xC9C8, 0x2E, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130213_SKT_tune_CAM_LL_START_CONTRAST_LUMA_PERCENTAGE
	
		{0xD01C, 0x32, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tunePGA_ZONE_LO_0	//0x8C
		{0xD020, 0x3C, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tunePGA_ZONE_HI_1  //0x90
		{0xD01D, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tunePGA_ZONE_LO_1  //0x82
		{0xD021, 0x2D, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130727_reddish_tunePGA_ZONE_HI_2  //0x87
		
		/*20130228_add*/
		{0xC946, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_AWB_K_B_L
		
		{0xC947, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// for cresyne_20130201_7e-->80 CAM_AWB_K_R_R  //0x80
		//{0xC949, 0x7C, MSM_CAMERA_I2C_BYTE_DATA, 0, 0 },	// for cresyne_20130201_7c-->80 CAM_AWB_K_R_R  //0x80
		{0xC877, 0xfe, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// CAM_HUE_ANGLE	//0xfe
		{0xC966, 0x72, MSM_CAMERA_I2C_BYTE_DATA, 0, 0}, 	// 20130322_8c-->72 CAM_LL_START_SATURATION
		{0xC8CE, 0x0085,}, 	//92--> 85 for cresyne_20130201 CAM_AWB_CCM_M_RG_GAIN  //0x8C   
		
		
		/* variabl noise*/
		{0xC9AE, 0x04, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // 0108_noise_tune 0x03-->0x04 // CAM_LL_ADACD_LUT_SIGMA_0  
              {0xC9AF, 0x04 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},        // CAM_LL_ADACD_LUT_SIGMA_1 
              {0xC9B0, 0x08 ,MSM_CAMERA_I2C_BYTE_DATA, 0, 0},       //0102_noise_tune 0x07 -->0x08  // CAM_LL_ADACD_LUT_SIGMA_2
              {0xC9B2, 0x004c,},     // 0108_noise_tune_ 34-->4c CAM_LL_ADACD_LUT_K_0 
              {0xC9B4, 0x005A,},     // 0108_noise_tune_ 34-->5A CAM_LL_ADACD_LUT_K_1
              {0xC9B6, 0x006B,},     // 0102_noise_tune 57 -->6B CAM_LL_ADACD_LUT_K_2
	
		
		{ 0x098E, 0xDC00 ,},	// LOGICAL_ADDRESS_ACCESS [SYSMGR_NEXT_STATE]
		{ 0xDC00, 0x28, MSM_CAMERA_I2C_BYTE_DATA, 0, 0},	// SYSMGR_NEXT_STATE
		{ 0x0080, 0x8002 ,},
		//	POLL  COMMAND_REGISTER::HOST_COMMAND_1 =>  0x00
		{AS0260_COMMAND_REGISTER, AS0260_COMMAND_REGISTER_SET_STATE,
		MSM_CAMERA_I2C_UNSET_WORD_MASK, MSM_CAMERA_I2C_CMD_POLL, 0},
	//LOAD = Change-Config
	},
};

#if 0
static struct msm_camera_i2c_reg_conf as0260_cfg_preview_24fps_for_motion_detect[][AS0260_PREVIEW_24FPS_PARM] = {
};

static struct msm_camera_i2c_reg_conf as0260_cfg_checkzsl[][AS0260_CHECK_ZSL_PARM] = {
};
#endif
#endif
