//*****************************************************************************
//*****************************************************************************
//  FILENAME: Driver.h
//  TrueTouch Host Emulator Version Information: 2.1.441
//  TrueTouch Firmware Version Information: 1.0.338632
//
//  DESCRIPTION: This file contains configuration values.
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2012. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
//-----------------------------------------------------------------------------
/* Touchscreen Parameters Endianess (Endianess: 0:Little; 1:Big)*/
static const uint8_t cyttsp4_param_endianess = 0;

/* Touchscreen Parameters */
static const uint8_t cyttsp4_param_regs[] = {
/*	Value	Name	*/
	0x7C, 0x17,  /* CONFIG_DATA_SIZE */
	0x7C, 0x17,  /* CONFIG_DATA_MAX_SIZE */
	0x56, 0x00, 0x00, 0x00,  /* SDK_CTRL_CFG_SIZE */
	0x02, 0x00,  /* CONFIG_VER */
	0x01,  /* PANELID_ENABLE */
	0x30,  /* IMO_FREQ_MHZ */
	0xF6, 0x19,  /* X_LEN_PHY */
	0xEA, 0x2D,  /* Y_LEN_PHY */
	0x14,  /* HST_MODE0 */
	0x00,  /* ACT_DIST0 */
	0x00,  /* SCAN_TYP0 */
	0x0C,  /* ACT_INTRVL0 */
	0x03,  /* ACT_LFT_INTRVL0 */
	0x00,  /* Reserved21 */
	0x64, 0x00,  /* LP_INTRVL0 */
	0xE8, 0x03,  /* TCH_TMOUT0 */
	0x01,  /* PWR_CFG */
	0x00,  /* Reserved27 */
	0x32,  /* INT_PULSE_DATA */
	0x20,  /* OPMODE_CFG */
	0xF4, 0x01,  /* HANDSHAKE_TIMEOUT */
	0x1E,  /* TIMER_CAL_INTERVAL */
	0x00,  /* Reserved33 */
	0x00, 0x00,  /* RP2P_MIN */
	0x50, 0xC3,  /* ILEAK_MAX */
	0xF4, 0x01,  /* RFB_P2P */
	0xF4, 0x01,  /* RFB_EXT */
	0x00,  /* IDACOPEN_LOW */
	0x00,  /* IDACOPEN_HIGH */
	0x00,  /* IDACOPEN_BUTTON_LOW */
	0x00,  /* IDACOPEN_BUTTON_HIGH */
	0x00,  /* GIDAC_OPEN */
	0x00,  /* GAIN_OPEN */
	0x00,  /* GIDAC_BUTTON_OPEN */
	0x00,  /* GAIN_BUTTON_OPEN */
	0x00,  /* POST_CFG */
	0x00,  /* GESTURE_CFG */
	0x00,  /* GEST_EN0 */
	0x00,  /* GEST_EN1 */
	0x00,  /* GEST_EN2 */
	0x00,  /* GEST_EN3 */
	0x00,  /* GEST_EN4 */
	0x00,  /* GEST_EN5 */
	0x00,  /* GEST_EN6 */
	0x00,  /* GEST_EN7 */
	0x00,  /* GEST_EN8 */
	0x00,  /* GEST_EN9 */
	0x00,  /* GEST_EN10 */
	0x00,  /* GEST_EN11 */
	0x00,  /* GEST_EN12 */
	0x00,  /* GEST_EN13 */
	0x00,  /* GEST_EN14 */
	0x00,  /* GEST_EN15 */
	0x00,  /* GEST_EN16 */
	0x00,  /* GEST_EN17 */
	0x00,  /* GEST_EN18 */
	0x00,  /* GEST_EN19 */
	0x00,  /* GEST_EN20 */
	0x00,  /* GEST_EN21 */
	0x00,  /* GEST_EN22 */
	0x00,  /* GEST_EN23 */
	0x00,  /* GEST_EN24 */
	0x00,  /* GEST_EN25 */
	0x00,  /* GEST_EN26 */
	0x00,  /* GEST_EN27 */
	0x00,  /* GEST_EN28 */
	0x00,  /* GEST_EN29 */
	0x00,  /* GEST_EN30 */
	0x00,  /* GEST_EN31 */
	0x00,  /* ACT_DIST2 */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00,  /* Reserved85 */
	0x18, 0x00, 0x00, 0x00,  /* GRIP_CFG_SIZE */
	0x00, 0x00,  /* GRIP_XEDG_A */
	0x00, 0x00,  /* GRIP_XEDG_B */
	0x00, 0x00,  /* GRIP_XEXC_A */
	0x00, 0x00,  /* GRIP_XEXC_B */
	0x00, 0x00,  /* GRIP_YEDG_A */
	0x00, 0x00,  /* GRIP_YEDG_B */
	0x00, 0x00,  /* GRIP_YEXC_A */
	0x00, 0x00,  /* GRIP_YEXC_B */
	0x00,  /* GRIP_FIRST_EXC */
	0x00,  /* GRIP_EXC_EDGE_ORIGIN */
	0x00, 0x00,  /* Reserved118 */
	0x6C, 0x00, 0x00, 0x00,  /* TRUETOUCH_CFG_SIZE */
	0x64, 0x00, 0x00, 0x00,  /* MAX_SELF_SCAN_INTERVAL */
	0x64, 0x00, 0x00, 0x00,  /* MAX_MUTUAL_SCAN_INTERVAL */
	0x64, 0x00, 0x00, 0x00,  /* MAX_BALANCED_SCAN_INTERVAL */
	0x0A, 0x00, 0x00, 0x00,  /* SELF_Z_THRSH */
	0x01, 0x00, 0x00, 0x00,  /* SELF_Z_MODE */
	0x00, 0x00, 0x00, 0x00,  /* SMART_SCAN_ENABLE */
	0x01, 0x00, 0x00, 0x00,  /* T_COMP_ENABLE */
	0xD0, 0x07, 0x00, 0x00,  /* T_COMP_INTERVAL */
	0x64, 0x00, 0x00, 0x00,  /* T_COMP_RECAL_MUTUAL_SENSOR_LIMIT */
	0x55, 0x00, 0x00, 0x00,  /* T_COMP_RECAL_MUTUAL_HIGH */
	0xB0, 0xFF, 0xFF, 0xFF,  /* T_COMP_RECAL_MUTUAL_LOW */
	0x0A, 0x00, 0x00, 0x00,  /* T_COMP_RECAL_SELF_SENSOR_LIMIT */
	0x8C, 0x00, 0x00, 0x00,  /* T_COMP_RECAL_SELF_HIGH */
	0xD8, 0xFF, 0xFF, 0xFF,  /* T_COMP_RECAL_SELF_LOW */
	0x01, 0x00, 0x00, 0x00,  /* CHARGER_ARMOR_ENABLE */
	0x00, 0x00, 0x00, 0x00,  /* AFH_ENABLE */
	0x08, 0x00, 0x00, 0x00,  /* AFH_LISTENING_SCAN_COUNT */
	0x06, 0x00, 0x00, 0x00,  /* AFH_LISTEN_SCAN_CYCLE_REPEATS */
	0xC8, 0x00, 0x00, 0x00,  /* CA_BLOCK_NOISE_THRESHOLD */
	0x01, 0x00, 0x00, 0x00,  /* CA_BLOCK_NOISE_HYSTERESIS */
	0xD0, 0x07, 0x00, 0x00,  /* CA_DEFAULT_REVERT_TIME */
	0x00, 0x00,  /* CA_SMART_H2O_REJECT */
	0x00, 0x00,  /* CA_HOST_CONTROLLED_CHARGER */
	0xA0, 0x00,  /* T_COMP_BUTTON_MUTUAL_HIGH */
	0xC4, 0xFF,  /* T_COMP_BUTTON_MUTUAL_LOW */
	0xA0, 0x00,  /* T_COMP_BUTTON_SELF_HIGH */
	0xC4, 0xFF,  /* T_COMP_BUTTON_SELF_LOW */
	0x10, 0x00, 0x00, 0x00,  /* CA_NUM_SUB_CONV_BASE_SELF */
	0x20, 0x00, 0x00, 0x00,  /* CA_ALT_NUM_SUB_CONV_SELF */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* Reserved228 */
	0x0C,  /* CA_ALT_NUM_SUB_CONV_MUTUAL */
	0x02,  /* CA_ALT_ACQUISITION_FLAGS */
	0x28,  /* AFH_ALT_TX_PERIOD1_MUTUAL */
	0x50,  /* AFH_ALT_TX_PERIOD1_MUTUAL_SCALE_FACTOR */
	0x0F,  /* AFH_ALT_TX_PERIOD1_MUTUAL_TX_VOLTAGE */
	0x45,  /* AFH_ALT_TX_PERIOD2_MUTUAL */
	0x50,  /* AFH_ALT_TX_PERIOD2_MUTUAL_SCALE_FACTOR */
	0x0F,  /* AFH_ALT_TX_PERIOD2_MUTUAL_TX_VOLTAGE */
	0x00, 0x00, 0x00, 0x00,  /* Reserved248 */
	0x2A,  /* GEST_CFG_SIZE */
	0x01,  /* PAN_ACT_DSTX */
	0x12,  /* PAN_ACT_DSTY */
	0x12,  /* ZOOM_ACT_DSTX */
	0x12,  /* ZOOM_ACT_DSTY */
	0x23,  /* FLICK_ACT_DISTX */
	0x23,  /* FLICK_ACT_DISTY */
	0x50,  /* FLICK_TIME */
	0x02,  /* ST_DEBOUNCE */
	0x03,  /* MT_DEBOUNCE_PAN */
	0x02,  /* MT_DEBOUNCE_ZOOM */
	0x0A,  /* MT_DEBOUNCE_P2Z */
	0x14,  /* ROT_DEBOUNCE */
	0x02,  /* COMPL_DEBOUNCE */
	0x28, 0x00,  /* MT_TIMEOUT */
	0x32,  /* ST_DBLCLK_RMAX */
	0x1E,  /* ST_CLICK_DISTX */
	0x1E,  /* ST_CLICK_DISTY */
	0x00,  /* Reserved271 */
	0xC8, 0x00,  /* MT_CLICK_TMAX */
	0x14, 0x00,  /* MT_CLICK_TMIN */
	0xC8, 0x00,  /* ST_CLICK_TMAX */
	0x14, 0x00,  /* ST_CLICK_TMIN */
	0xC8, 0x00,  /* ST_DBLCLK_TMAX */
	0x14, 0x00,  /* ST_DBLCLK_TMIN */
	0xF0,  /* GESTURE_GROUP_MASK */
	0x28,  /* GESTURE_GROUP1_START */
	0x29,  /* GESTURE_GROUP1_END */
	0x30,  /* GESTURE_GROUP2_START */
	0x3F,  /* GESTURE_GROUP2_END */
	0x48,  /* GESTURE_GROUP3_START */
	0x49,  /* GESTURE_GROUP3_END */
	0x90,  /* GESTURE_GROUP4_START */
	0x9F,  /* GESTURE_GROUP4_END */
	0x00, 0x00, 0x00,  /* Reserved293 */
	0x2C, 0x00, 0x00, 0x00,  /* XY_FILT_CFG_SIZE */
	0xF0, 0x00, 0x00, 0x00,  /* XY_FILTER_MASK */
	0x02, 0x00, 0x00, 0x00,  /* XY_FILT_IIR_COEFF */
	0x01, 0x00, 0x00, 0x00,  /* XY_FILT_Z_IIR_COEFF */
	0x00,  /* XY_FILT_XY_FAST_THR */
	0x00,  /* XY_FILT_XY_SLOW_THR */
	0x01,  /* XY_FILT_IIR_FAST_COEFF */
	0x00,  /* Reserved315 */
	0xF0, 0x00, 0x00, 0x00,  /* XY_FILTER_MASK_CA */
	0x02, 0x00, 0x00, 0x00,  /* XY_FILT_IIR_COEFF_CA */
	0x02, 0x00, 0x00, 0x00,  /* XY_FILT_Z_IIR_COEFF_CA */
	0x00,  /* XY_FILT_XY_FAST_THR_CA */
	0x00,  /* XY_FILT_XY_SLOW_THR_CA */
	0x01,  /* XY_FILT_IIR_FAST_COEFF_CA */
	0x00,  /* Reserved331 */
	0x00,  /* XY_FILT_ADAPTIVE_IIR_FILTER */
	0x0C,  /* XY_FILT_ADAPTIVE_IIR_FILTER_DISTANCE */
	0x00,  /* XY_FILT_TOUCH_SIZE_IIR_COEFF */
	0x00,  /* XY_FILT_TOUCH_SIZE_HYST */
	0x00,  /* XY_FILT_TOUCH_ORIENTATION_IIR_COEFF */
	0x00,  /* XY_FILT_TOUCH_ORIENTATION_HYST */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00,  /* Reserved338 */
	0x10, 0x00, 0x00, 0x00,  /* FINGER_ID_CFG_SIZE */
	0x00, 0x00, 0x00, 0x00,  /* Reserved352 */
	0x40, 0x0D, 0x03, 0x00,  /* FINGER_ID_MAX_FINGER_VELOCITY2 */
	0x00,  /* LIFTOFF_DEBOUNCE */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00,  /* Reserved361 */
	0x18, 0x00, 0x00, 0x00,  /* CENTROID_SH_CFG_SIZE */
	0x14, 0x00, 0x00, 0x00,  /* STYLUS_THRSH */
	0x05, 0x00, 0x00, 0x00,  /* STYLUS_HYST */
	0xFF, 0x00, 0x00, 0x00,  /* S2F_THRESHOLD */
	0x00, 0x00, 0x00, 0x00,  /* HOVER_THRSH */
	0x00, 0x00, 0x00, 0x00,  /* HOVER_HYST */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* Reserved392 */
	0x30, 0x00, 0x00, 0x00,  /* ID_COORDS_CFG_SIZE */
	0x02,  /* LRG_OBJ_CFG */
	0x51,  /* MAX_FAT_FINGER_SIZE */
	0x08,  /* MIN_FAT_FINGER_SIZE */
	0x11,  /* FINGER_THRESH_MUTUAL */
	0x05, 0x00,  /* FINGER_THRESH_SELF */
	0x0F,  /* INNER_EDGE_GAIN */
	0x09,  /* OUTER_EDGE_GAIN */
	0xD0, 0x02, 0x00, 0x00,  /* X_RESOLUTION */
	0x00, 0x05, 0x00, 0x00,  /* Y_RESOLUTION */
	0x01, 0x00, 0x00, 0x00,  /* SENSOR_ASSIGNMENT */
	0x20, 0x00, 0x00, 0x00,  /* Z_SCALING */
	0x00,  /* RX_LINE_FILTER */
	0x0A,  /* BYPASS_THRESHOLD_GAIN */
	0x02,  /* BYPASS_THRESHOLD_EDGE_GAIN */
	0x03,  /* FINGER_THR_MUT_HYST */
	0x00,  /* MAX_FAT_FINGER_SIZE_HYST */
	0x00,  /* MIN_FAT_FINGER_SIZE_HYST */
	0x02,  /* MULTI_TOUCH_DEBOUNCE */
	0x1C,  /* CA_FINGER_THRESHOLD_MUTUAL */
	0x20,  /* FAT_FINGER_THRESHOLD_COEFF */
	0x03,  /* SIZE_ORIENTATION_ENABLE */
	0x50,  /* MAJOR_AXIS_OFFSET */
	0x0E,  /* MAJOR_AXIS_SCALE */
	0x50,  /* MINOR_AXIS_OFFSET */
	0x0E,  /* MINOR_AXIS_SCALE */
	0x02,  /* RX_LINE_FILTER_DEBOUNCE */
	0x00,  /* CLIPPING_X_LOW */
	0x00,  /* CLIPPING_X_HIGH */
	0x00,  /* CLIPPING_Y_LOW */
	0x00,  /* CLIPPING_Y_HIGH */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00,  /* Reserved447 */
	0x1C, 0x00, 0x00, 0x00,  /* BTN_CFG_SIZE */
	0x64, 0x00,  /* BTN_THRSH_MUT */
	0x64, 0x00,  /* BTN_THRSH_MUT_1 */
	0x64, 0x00,  /* BTN_THRSH_MUT_2 */
	0x64, 0x00,  /* BTN_THRSH_MUT_3 */
	0x14,  /* BTN_HYST_MUT */
	0x00,  /* Reserved477 */
	0x00,  /* Reserved478 */
	0x00,  /* Reserved479 */
	0x32, 0x00,  /* BTN_THRSH_SELF */
	0x64, 0x00,  /* BTN_THRSH_SELF_1 */
	0x64, 0x00,  /* BTN_THRSH_SELF_2 */
	0x64, 0x00,  /* BTN_THRSH_SELF_3 */
	0x0A,  /* BTN_HYST_SELF */
	0x00,  /* Reserved489 */
	0x00,  /* Reserved490 */
	0x00,  /* Reserved491 */
	0x40, 0x00, 0x00, 0x00,  /* RAW_PROC_CFG_SIZE */
	0xF7, 0x77,  /* RAW_FILTER_MASK */
	0x00,  /* RAW_FILT_IIR_COEFF_MUTUAL */
	0x1E,  /* RAW_FILT_IIR_THRESHOLD_MUTUAL */
	0x00,  /* RAW_FILT_IIR_COEFF_SELF */
	0x28,  /* RAW_FILT_IIR_THRESHOLD_SELF */
	0x00,  /* RAW_FILT_IIR_COEFF_BALANCED */
	0x14,  /* RAW_FILT_IIR_THRESHOLD_BALANCED */
	0x00,  /* RAW_FILT_IIR_COEFF_BUTTONS */
	0x14,  /* RAW_FILT_IIR_THRESHOLD_BUTTONS */
	0x00, 0x00,  /* Reserved506 */
	0xF7, 0x77,  /* RAW_FILTER_MASK_CA */
	0x00,  /* RAW_FILT_IIR_COEFF_MUTUAL_CA */
	0x28,  /* RAW_FILT_IIR_THRESHOLD_MUTUAL_CA */
	0x00,  /* RAW_FILT_IIR_COEFF_SELF_CA */
	0x0F,  /* RAW_FILT_IIR_THRESHOLD_SELF_CA */
	0x01,  /* RAW_FILT_IIR_COEFF_BALANCED_CA */
	0x14,  /* RAW_FILT_IIR_THRESHOLD_BALANCED_CA */
	0x01,  /* RAW_FILT_IIR_COEFF_BUTTONS_CA */
	0x14,  /* RAW_FILT_IIR_THRESHOLD_BUTTONS_CA */
	0x00, 0x00,  /* Reserved518 */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* Reserved520 */
	0x03,  /* BL_DELAY_MUT */
	0x03,  /* BL_DELAY_SELF */
	0x14,  /* BL_DELAY_BAL */
	0x03,  /* BL_DELAY_BTN */
	0x0F,  /* BL_THR_MUT */
	0x0A,  /* BL_THR_SELF */
	0x0A,  /* BL_THR_BAL */
	0x0A,  /* BL_THR_BTN_MUT */
	0x00,  /* BL_H20_RJCT */
	0x0A,  /* BL_THR_BTN_SELF */
	0x14,  /* BL_MUT_SIG_THRESHOLD_CA */
	0x50,  /* BL_FILT_MUT */
	0x50,  /* BL_FILT_SELF */
	0x50,  /* BL_FILT_BAL */
	0x50,  /* BL_FILT_BTN_MUT */
	0x50,  /* BL_FILT_BTN_SELF */
	0x0C,  /* CMF_THR_MUT */
	0x0C,  /* CMF_THR_SELF */
	0x0C,  /* CMF_THR_BAL */
	0x0C,  /* CMF_THR_BTN_MUT */
	0x0C,  /* CMF_THR_BTN_SELF */
	0x00, 0x00, 0x00,  /* Reserved553 */
	0xB4, 0x01, 0x00, 0x00,  /* CDC_CFG_SIZE */
	0x05, 0x04, 0xFF, 0x81,  /* TSS_CONTROL_MUT */
	0x03, 0x08, 0x00, 0x00,  /* TSS_LENGTH_MUT */
	0xFF, 0x00, 0xAF, 0xC0,  /* TSS_TX_CONFIG_MUT */
	0xFF, 0xFF, 0xB0, 0x00,  /* TSS_TX_CONTROL_MUT */
	0x22, 0x02, 0x7F, 0x81,  /* TSS_SEQ_CONFIG1_MUT */
	0x7F, 0x72, 0x01, 0x80,  /* TSS_SEQ_CONFIG2_MUT */
	0x06, 0x01, 0x46, 0x04,  /* TSS_SEQ_CONFIG3_MUT */
	0x5A, 0x2F, 0x5A, 0x28,  /* TSS_SEQ_CONFIG4_MUT */
	0x12, 0x01, 0x01, 0x00,  /* TSS_SEQ_CONFIG5_MUT */
	0x04, 0x01, 0x08, 0x10,  /* TSS_SEQ_CONFIG6_MUT */
	0x01, 0x04, 0x00, 0x00,  /* TSS_SEQ_CONFIG7_MUT */
	0x44, 0x01, 0x02, 0x80,  /* TSS_SEQ_CONFIG8_MUT */
	0x01, 0x01, 0x00, 0x00,  /* TSS_EXT_CONFIG1_MUT */
	0x80, 0x00, 0x01, 0x00,  /* TSS_EXT_CONFIG2_MUT */
	0x00, 0x00, 0x00, 0x00,  /* TSS_EXT_INTERVAL_MUT */
	0x01, 0x01, 0x00, 0x90,  /* TSS_INT_CONFIG1_MUT */
	0x80, 0x00, 0xFE, 0x0B,  /* TSS_INT_CONFIG2_MUT */
	0x00, 0x00, 0x00, 0x00,  /* TSS_INT_INTERVAL_MUT */
	0x00, 0x00, 0x00, 0x00,  /* TSS_MCS_CONFIG_MUT */
	0x7A, 0xA0, 0x00, 0xD0,  /* TSS_RX_CONFIG_MUT */
	0x00, 0x00, 0x00, 0x00,  /* Reserved640 */
	0x05, 0x04, 0xFF, 0x81,  /* TSS_CONTROL_SELF */
	0x03, 0x08, 0x00, 0x00,  /* TSS_LENGTH_SELF */
	0xAA, 0x02, 0xAF, 0xC0,  /* TSS_TX_CONFIG_SELF */
	0xFF, 0xFF, 0xD0, 0x00,  /* TSS_TX_CONTROL_SELF */
	0x22, 0x02, 0x7F, 0x81,  /* TSS_SEQ_CONFIG1_SELF */
	0x7F, 0x72, 0x01, 0x80,  /* TSS_SEQ_CONFIG2_SELF */
	0x06, 0x81, 0x46, 0x04,  /* TSS_SEQ_CONFIG3_SELF */
	0x50, 0x1E, 0x50, 0x1E,  /* TSS_SEQ_CONFIG4_SELF */
	0x12, 0x01, 0x01, 0x00,  /* TSS_SEQ_CONFIG5_SELF */
	0x04, 0x01, 0x08, 0x10,  /* TSS_SEQ_CONFIG6_SELF */
	0x01, 0x04, 0x00, 0x00,  /* TSS_SEQ_CONFIG7_SELF */
	0x44, 0x01, 0x02, 0x80,  /* TSS_SEQ_CONFIG8_SELF */
	0x01, 0x01, 0x00, 0x00,  /* TSS_EXT_CONFIG1_SELF */
	0x80, 0x00, 0x01, 0x00,  /* TSS_EXT_CONFIG2_SELF */
	0x00, 0x00, 0x00, 0x00,  /* TSS_EXT_INTERVAL_SELF */
	0x01, 0x01, 0x00, 0x90,  /* TSS_INT_CONFIG1_SELF */
	0x80, 0x00, 0xFE, 0x0B,  /* TSS_INT_CONFIG2_SELF */
	0x00, 0x00, 0x00, 0x00,  /* TSS_INT_INTERVAL_SELF */
	0x00, 0x00, 0x00, 0x00,  /* TSS_MCS_CONFIG_SELF */
	0x7A, 0xA6, 0x00, 0xD0,  /* TSS_RX_CONFIG_SELF */
	0x00, 0x00, 0x00, 0x00,  /* Reserved724 */
	0x05, 0x04, 0xFF, 0x80,  /* TSS_CONTROL_BAL */
	0x03, 0x20, 0x00, 0x00,  /* TSS_LENGTH_BAL */
	0xAF, 0x08, 0xAF, 0xC0,  /* TSS_TX_CONFIG_BAL */
	0xFF, 0xFF, 0xB0, 0x00,  /* TSS_TX_CONTROL_BAL */
	0x22, 0x02, 0x7F, 0x81,  /* TSS_SEQ_CONFIG1_BAL */
	0x7F, 0x72, 0x01, 0x80,  /* TSS_SEQ_CONFIG2_BAL */
	0x01, 0x81, 0x40, 0x04,  /* TSS_SEQ_CONFIG3_BAL */
	0x96, 0x0F, 0x96, 0x0F,  /* TSS_SEQ_CONFIG4_BAL */
	0x12, 0x01, 0x01, 0x00,  /* TSS_SEQ_CONFIG5_BAL */
	0x04, 0x01, 0x08, 0x10,  /* TSS_SEQ_CONFIG6_BAL */
	0x01, 0x04, 0x00, 0x00,  /* TSS_SEQ_CONFIG7_BAL */
	0x44, 0x01, 0x02, 0x80,  /* TSS_SEQ_CONFIG8_BAL */
	0x01, 0x01, 0x00, 0x00,  /* TSS_EXT_CONFIG1_BAL */
	0x80, 0x00, 0x01, 0x00,  /* TSS_EXT_CONFIG2_BAL */
	0x00, 0x00, 0x00, 0x00,  /* TSS_EXT_INTERVAL_BAL */
	0x01, 0x01, 0x00, 0x90,  /* TSS_INT_CONFIG1_BAL */
	0x80, 0x00, 0xFE, 0x0B,  /* TSS_INT_CONFIG2_BAL */
	0x00, 0x00, 0x00, 0x00,  /* TSS_INT_INTERVAL_BAL */
	0x00, 0x00, 0x00, 0x00,  /* TSS_MCS_CONFIG_BAL */
	0x3A, 0xA0, 0x00, 0xD0,  /* TSS_RX_CONFIG_BAL */
	0x05, 0x04, 0xFF, 0x80,  /* TSS_CONTROL_BTN */
	0x02, 0x04, 0x00, 0x00,  /* TSS_LENGTH_BTN_MUT */
	0xFF, 0x00, 0xAF, 0xC0,  /* TSS_TX_CONFIG_BTN */
	0xFF, 0xFF, 0xB0, 0x00,  /* TSS_TX_CONTROL_BTN */
	0x22, 0x02, 0x7F, 0x81,  /* TSS_SEQ_CONFIG1_BTN */
	0x7F, 0x72, 0x01, 0x80,  /* TSS_SEQ_CONFIG2_BTN */
	0x01, 0x81, 0x40, 0x04,  /* TSS_SEQ_CONFIG3_BTN */
	0x96, 0x0F, 0x96, 0x0F,  /* TSS_SEQ_CONFIG4_BTN */
	0x12, 0x01, 0x01, 0x00,  /* TSS_SEQ_CONFIG5_BTN */
	0x04, 0x01, 0x08, 0x10,  /* TSS_SEQ_CONFIG6_BTN */
	0x01, 0x04, 0x00, 0x00,  /* TSS_SEQ_CONFIG7_BTN */
	0x44, 0x01, 0x02, 0x80,  /* TSS_SEQ_CONFIG8_BTN */
	0x01, 0x01, 0x00, 0x00,  /* TSS_EXT_CONFIG1_BTN */
	0x80, 0x00, 0x01, 0x00,  /* TSS_EXT_CONFIG2_BTN */
	0x00, 0x00, 0x00, 0x00,  /* TSS_EXT_INTERVAL_BTN */
	0x01, 0x01, 0x00, 0x90,  /* TSS_INT_CONFIG1_BTN */
	0x80, 0x00, 0xFE, 0x0B,  /* TSS_INT_CONFIG2_BTN */
	0x00, 0x00, 0x00, 0x00,  /* TSS_INT_INTERVAL_BTN */
	0x00, 0x00, 0x00, 0x00,  /* TSS_MCS_CONFIG_BTN */
	0x3A, 0xA0, 0x00, 0xD0,  /* TSS_RX_CONFIG_BTN */
	0x08, 0x04, 0x00, 0x00,  /* TSS_LENGTH_BTN_SELF */
	0x00, 0x00, 0x30, 0x30,  /* TSS_RX_VREF */
	0x40, 0x03, 0x07, 0x40,  /* TSS_RX_LX_CONFIG */
	0x11, 0x00, 0x00, 0x00,  /* TX_NUM */
	0x1C, 0x00, 0x00, 0x00,  /* RX_NUM */
	0x2D, 0x00, 0x00, 0x00,  /* SENS_NUM */
	0xDC, 0x01, 0x00, 0x00,  /* CROSS_NUM */
	0x00, 0x00, 0x00, 0x00,  /* BUTTON_NUM */
	0x05, 0x00, 0x00, 0x00,  /* SLOTS_MUT */
	0x05, 0x00, 0x00, 0x00,  /* SLOTS_SELF_RX */
	0x03, 0x00, 0x00, 0x00,  /* SLOTS_SELF_TX */
	0x08, 0x00, 0x00, 0x00,  /* SLOTS_SELF */
	0x10, 0x00, 0x00, 0x00,  /* SLOTS_BAL */
	0x41, 0x00, 0x00, 0x00,  /* SCALE_MUT */
	0x3C, 0x00, 0x00, 0x00,  /* SCALE_SELF */
	0x64, 0x00, 0x00, 0x00,  /* SCALE_BAL */
	0x64, 0x00, 0x00, 0x00,  /* SCALE_BUTTON */
	0x00, 0x00, 0x00, 0x00,  /* LX_MODE */
	0x50, 0x00, 0x00, 0x00,  /* LX_SCALE */
	0x01, 0x00, 0x00, 0x00,  /* ABSOLUTE_CR_CORRECTION_ENABLE */
	0x02, 0x00, 0x00, 0x00,  /* SCANNING_MODE_MUTUAL */
	0x03, 0x00, 0x00, 0x00,  /* SCANNING_MODE_BUTTON */
	0x23, 0x00,  /* DETECT_CHARGER_THRESHOLD */
	0x01,  /* CA_LX_SCAN_MODE */
	0x00,  /* SUB_SLOT_SCAN */
	0x28,  /* CDC_AFH1_THRESHOLD_2 */
	0x0F,  /* CDC_AFH1_THRESHOLD_1 */
	0x00,  /* CDC_AFH2_THRESHOLD_2 */
	0x05,  /* CDC_AFH2_THRESHOLD_1 */
	0x04,  /* ADC_CONFIG */
	0x00,  /* Reserved985 */
	0x04,  /* TSS_LDO_PROG */
	0x02,  /* TX_PERIOD_DUMMY_SCAN */
	0x00, 0x00,  /* LISTEN_MIN_VALUE */
	0x00, 0x00,  /* Reserved990 */
	0x48, 0x00, 0x00, 0x00,  /* CALIBRATION_PARAM_SIZE */
	0x01, 0x00, 0x00, 0x00,  /* Reserved996 */
	0x01, 0x00, 0x00, 0x00,  /* Reserved1000 */
	0x01, 0x00, 0x00, 0x00,  /* Reserved1004 */
	0x01, 0x00, 0x00, 0x00,  /* Reserved1008 */
	0x00, 0x00, 0x00, 0x00,  /* GLOBAL_IDAC_LSB_MUTUAL */
	0x01, 0x00, 0x00, 0x00,  /* GLOBAL_IDAC_LSB_SELF */
	0x01, 0x00, 0x00, 0x00,  /* GLOBAL_IDAC_LSB_BALANCED */
	0x01, 0x00, 0x00, 0x00,  /* GLOBAL_IDAC_LSB_BUTTON */
	0xD8, 0xFF, 0xFF, 0xFF,  /* TARGET_LEVEL_MUTUAL */
	0x00, 0x00, 0x00, 0x00,  /* TARGET_LEVEL_SELF */
	0x00, 0x00, 0x00, 0x00,  /* TARGET_LEVEL_BALANCED */
	0x00, 0x00, 0x00, 0x00,  /* TARGET_LEVEL_BUTTON */
	0x02, 0x00, 0x00, 0x00,  /* GAIN_MUTUAL */
	0x01, 0x00, 0x00, 0x00,  /* GAIN_SELF */
	0x01, 0x00, 0x00, 0x00,  /* GAIN_BALANCED */
	0x01, 0x00, 0x00, 0x00,  /* GAIN_BTN_MUTUAL */
	0x03, 0x00, 0x00, 0x00,  /* GAIN_BTN_SELF */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1064 */
	0x08, 0x00, 0x00, 0x00,  /* SPREADER_CFG_SIZE */
	0x00, 0x00, 0x00, 0x00,  /* CLK_IMO_SPREAD */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1076 */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x02, 0x02, 
	0x02, 0x02, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 
	0x04, 0x04, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x04, 
	0x05, 0x05, 0x05, 0x05, 
	0x05, 0x05, 0x06, 0x06, 
	0x06, 0x06, 0x06, 0x07, 
	0x07, 0x07, 0x07, 0x07, 
	0x07, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00,  /* CDC_SENSOR_TO_SLOT_TABLE */
	0x00, 0x00, 0x00,  /* Reserved1145 */
	0x17, 0x14, 0x0B, 0x08, 
	0x05, 0x0E, 0x0A, 0x0C, 
	0x09, 0x07, 0x06, 0x22, 
	0x24, 0x27, 0x2F, 0x2C, 
	0x2D, 0x2E, 0x38, 0x39, 
	0x30, 0x31, 0x32, 0x33, 
	0x34, 0x35, 0x36, 0x37, 
	0x29, 0x2B, 0x28, 0x2A, 
	0x25, 0x26, 0x23, 0x18, 
	0x19, 0x15, 0x16, 0x13, 
	0x11, 0x12, 0x10, 0x0F, 
	0x0D, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00,  /* CDC_PIN_INDEX_TABLE */
	0x00, 0x00, 0x00,  /* Reserved1213 */
	0xB9, 0x00, 0x05, 0x1C, 
	0x03, 0x00, 0x00, 0x02, 
	0x01, 0x04, 0x00, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0A, 0x09, 
	0x0B, 0x0B, 0x0A, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xD6, 0x00, 0x05, 0x1C, 
	0x00, 0x08, 0x06, 0x00, 
	0x07, 0x00, 0x05, 0x09, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x09, 
	0x0B, 0x0A, 0x0B, 0x0A, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xD4, 0x00, 0x04, 0x1C, 
	0x00, 0x00, 0x0B, 0x00, 
	0x0C, 0x00, 0x0A, 0x0D, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0B, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xF3, 0x00, 0x06, 0x1C, 
	0x12, 0x13, 0x00, 0x00, 
	0x0F, 0x10, 0x11, 0x0E, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x0B, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xFF, 0x00, 0x08, 0x1C, 
	0x14, 0x15, 0x16, 0x17, 
	0x18, 0x19, 0x1A, 0x1B, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0B, 0x0A, 
	0x0B, 0x0B, 0x0A, 0x0A, 
	0x0A, 0x0A, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xB9, 0x00, 0x05, 0x2D, 
	0x03, 0x00, 0x00, 0x02, 
	0x01, 0x04, 0x00, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0A, 0x09, 
	0x0B, 0x0B, 0x0A, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0xD6, 0x00, 0x05, 0x2D, 
	0x00, 0x08, 0x06, 0x00, 
	0x07, 0x00, 0x05, 0x09, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x09, 
	0x0B, 0x0A, 0x0B, 0x0A, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0xD4, 0x00, 0x04, 0x2D, 
	0x00, 0x00, 0x0B, 0x00, 
	0x0C, 0x00, 0x0A, 0x0D, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x0A, 0x0B, 0x0B, 0x0B, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0xF3, 0x00, 0x06, 0x2D, 
	0x12, 0x13, 0x00, 0x00, 
	0x0F, 0x10, 0x11, 0x0E, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x0B, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0xFF, 0x00, 0x08, 0x2D, 
	0x14, 0x15, 0x16, 0x17, 
	0x18, 0x19, 0x1A, 0x1B, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0B, 0x0A, 
	0x0B, 0x0B, 0x0A, 0x0A, 
	0x0A, 0x0A, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0x6F, 0x00, 0x06, 0x2D, 
	0x1E, 0x1C, 0x1F, 0x1D, 
	0x00, 0x20, 0x21, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0B, 0x0B, 
	0x0B, 0x0B, 0x0B, 0x0B, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0x6B, 0x00, 0x05, 0x2D, 
	0x23, 0x24, 0x00, 0x22, 
	0x00, 0x25, 0x26, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0xAF, 0x00, 0x06, 0x2D, 
	0x2A, 0x28, 0x29, 0x27, 
	0x00, 0x2C, 0x00, 0x2B, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x09, 0x0B, 0x0A, 
	0x0B, 0x0A, 0x0A, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x00, 
	0xB9, 0x00, 0x05, 0x2D, 
	0x03, 0x00, 0x00, 0x02, 
	0x01, 0x04, 0x00, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0A, 0x09, 
	0x0B, 0x0B, 0x0A, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xB9, 0x00, 0x05, 0x2D, 
	0x30, 0x00, 0x00, 0x2F, 
	0x2E, 0x31, 0x00, 0x2D, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0A, 0x09, 
	0x0B, 0x0B, 0x0A, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0C, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xD6, 0x00, 0x05, 0x2D, 
	0x00, 0x08, 0x06, 0x00, 
	0x07, 0x00, 0x05, 0x09, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x09, 
	0x0B, 0x0A, 0x0B, 0x0A, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xD6, 0x00, 0x05, 0x2D, 
	0x00, 0x35, 0x33, 0x00, 
	0x34, 0x00, 0x32, 0x36, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x09, 
	0x0B, 0x0A, 0x0B, 0x0A, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0C, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xD4, 0x00, 0x04, 0x2D, 
	0x00, 0x00, 0x0B, 0x00, 
	0x0C, 0x00, 0x0A, 0x0D, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0B, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xD4, 0x00, 0x04, 0x2D, 
	0x00, 0x00, 0x38, 0x00, 
	0x39, 0x00, 0x37, 0x3A, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0B, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0C, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xF3, 0x00, 0x06, 0x2D, 
	0x12, 0x13, 0x00, 0x00, 
	0x0F, 0x10, 0x11, 0x0E, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x0B, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xF3, 0x00, 0x06, 0x2D, 
	0x3F, 0x40, 0x00, 0x00, 
	0x3C, 0x3D, 0x3E, 0x3B, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x0B, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0C, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xFF, 0x00, 0x08, 0x2D, 
	0x14, 0x15, 0x16, 0x17, 
	0x18, 0x19, 0x1A, 0x1B, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0B, 0x0A, 
	0x0B, 0x0B, 0x0A, 0x0A, 
	0x0A, 0x0A, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xFF, 0x00, 0x08, 0x2D, 
	0x41, 0x42, 0x43, 0x44, 
	0x45, 0x46, 0x47, 0x48, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0B, 0x0A, 
	0x0B, 0x0B, 0x0A, 0x0A, 
	0x0A, 0x0A, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x0C, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0x6F, 0x00, 0x06, 0x2D, 
	0x1E, 0x1C, 0x1F, 0x1D, 
	0x00, 0x20, 0x21, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0B, 0x0B, 
	0x0B, 0x0B, 0x0B, 0x0B, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0C, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0x6F, 0x00, 0x06, 0x2D, 
	0x4B, 0x49, 0x4C, 0x4A, 
	0x00, 0x4D, 0x4E, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0B, 0x0B, 
	0x0B, 0x0B, 0x0B, 0x0B, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0C, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0x6B, 0x00, 0x05, 0x2D, 
	0x23, 0x24, 0x00, 0x22, 
	0x00, 0x25, 0x26, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0C, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0x6B, 0x00, 0x05, 0x2D, 
	0x50, 0x51, 0x00, 0x4F, 
	0x00, 0x52, 0x53, 0x00, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0C, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xAF, 0x00, 0x06, 0x2D, 
	0x2A, 0x28, 0x29, 0x27, 
	0x00, 0x2C, 0x00, 0x2B, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x09, 0x0B, 0x0A, 
	0x0B, 0x0A, 0x0A, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0xAF, 0x00, 0x06, 0x2D, 
	0x57, 0x55, 0x56, 0x54, 
	0x00, 0x59, 0x00, 0x58, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x02, 
	0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x0C, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x09, 0x0B, 0x0A, 
	0x0B, 0x0A, 0x0A, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x0F, 
	0x0F, 0x0F, 0x0F, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x00, 0x08, 0x1D, 
	0x14, 0x15, 0x16, 0x17, 
	0x18, 0x19, 0x1A, 0x1B, 
	0x00, 0x17, 0x14, 0x0B, 
	0x08, 0x05, 0x0E, 0x0A, 
	0x0C, 0x09, 0x07, 0x06, 
	0x22, 0x24, 0x27, 0x2F, 
	0x2C, 0x2D, 0x2E, 0x38, 
	0x39, 0x30, 0x31, 0x32, 
	0x33, 0x34, 0x35, 0x36, 
	0x37, 0x29, 0x2B, 0x28, 
	0x2A, 0x25, 0x26, 0x23, 
	0x18, 0x19, 0x15, 0x16, 
	0x13, 0x11, 0x12, 0x10, 
	0x0F, 0x0D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0A, 0x09, 
	0x0B, 0x0B, 0x0A, 0x09, 
	0x0B, 0x0A, 0x0B, 0x0A, 
	0x0A, 0x0B, 0x0B, 0x0B, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0A, 0x0B, 0x0B, 0x0A, 
	0x0B, 0x0B, 0x0A, 0x0A, 
	0x0A, 0x0A, 0x0C, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_SLOT_TABLE */
	0xCF, 0xDE,  /* CONFIG_CRC */
};

/* Touchscreen Parameters Field Sizes (Writable: 0:Readonly; 1:Writable) */
static const uint16_t cyttsp4_param_size[] = {
/*	Size	Name	*/
	2, /* CONFIG_DATA_SIZE */
	2, /* CONFIG_DATA_MAX_SIZE */
	4, /* SDK_CTRL_CFG_SIZE */
	2, /* CONFIG_VER */
	1, /* PANELID_ENABLE */
	1, /* IMO_FREQ_MHZ */
	2, /* X_LEN_PHY */
	2, /* Y_LEN_PHY */
	1, /* HST_MODE0 */
	1, /* ACT_DIST0 */
	1, /* SCAN_TYP0 */
	1, /* ACT_INTRVL0 */
	1, /* ACT_LFT_INTRVL0 */
	1, /* Reserved21 */
	2, /* LP_INTRVL0 */
	2, /* TCH_TMOUT0 */
	1, /* PWR_CFG */
	1, /* Reserved27 */
	1, /* INT_PULSE_DATA */
	1, /* OPMODE_CFG */
	2, /* HANDSHAKE_TIMEOUT */
	1, /* TIMER_CAL_INTERVAL */
	1, /* Reserved33 */
	2, /* RP2P_MIN */
	2, /* ILEAK_MAX */
	2, /* RFB_P2P */
	2, /* RFB_EXT */
	1, /* IDACOPEN_LOW */
	1, /* IDACOPEN_HIGH */
	1, /* IDACOPEN_BUTTON_LOW */
	1, /* IDACOPEN_BUTTON_HIGH */
	1, /* GIDAC_OPEN */
	1, /* GAIN_OPEN */
	1, /* GIDAC_BUTTON_OPEN */
	1, /* GAIN_BUTTON_OPEN */
	1, /* POST_CFG */
	1, /* GESTURE_CFG */
	1, /* GEST_EN0 */
	1, /* GEST_EN1 */
	1, /* GEST_EN2 */
	1, /* GEST_EN3 */
	1, /* GEST_EN4 */
	1, /* GEST_EN5 */
	1, /* GEST_EN6 */
	1, /* GEST_EN7 */
	1, /* GEST_EN8 */
	1, /* GEST_EN9 */
	1, /* GEST_EN10 */
	1, /* GEST_EN11 */
	1, /* GEST_EN12 */
	1, /* GEST_EN13 */
	1, /* GEST_EN14 */
	1, /* GEST_EN15 */
	1, /* GEST_EN16 */
	1, /* GEST_EN17 */
	1, /* GEST_EN18 */
	1, /* GEST_EN19 */
	1, /* GEST_EN20 */
	1, /* GEST_EN21 */
	1, /* GEST_EN22 */
	1, /* GEST_EN23 */
	1, /* GEST_EN24 */
	1, /* GEST_EN25 */
	1, /* GEST_EN26 */
	1, /* GEST_EN27 */
	1, /* GEST_EN28 */
	1, /* GEST_EN29 */
	1, /* GEST_EN30 */
	1, /* GEST_EN31 */
	1, /* ACT_DIST2 */
	11, /* Reserved85 */
	4, /* GRIP_CFG_SIZE */
	2, /* GRIP_XEDG_A */
	2, /* GRIP_XEDG_B */
	2, /* GRIP_XEXC_A */
	2, /* GRIP_XEXC_B */
	2, /* GRIP_YEDG_A */
	2, /* GRIP_YEDG_B */
	2, /* GRIP_YEXC_A */
	2, /* GRIP_YEXC_B */
	1, /* GRIP_FIRST_EXC */
	1, /* GRIP_EXC_EDGE_ORIGIN */
	2, /* Reserved118 */
	4, /* TRUETOUCH_CFG_SIZE */
	4, /* MAX_SELF_SCAN_INTERVAL */
	4, /* MAX_MUTUAL_SCAN_INTERVAL */
	4, /* MAX_BALANCED_SCAN_INTERVAL */
	4, /* SELF_Z_THRSH */
	4, /* SELF_Z_MODE */
	4, /* SMART_SCAN_ENABLE */
	4, /* T_COMP_ENABLE */
	4, /* T_COMP_INTERVAL */
	4, /* T_COMP_RECAL_MUTUAL_SENSOR_LIMIT */
	4, /* T_COMP_RECAL_MUTUAL_HIGH */
	4, /* T_COMP_RECAL_MUTUAL_LOW */
	4, /* T_COMP_RECAL_SELF_SENSOR_LIMIT */
	4, /* T_COMP_RECAL_SELF_HIGH */
	4, /* T_COMP_RECAL_SELF_LOW */
	4, /* CHARGER_ARMOR_ENABLE */
	4, /* AFH_ENABLE */
	4, /* AFH_LISTENING_SCAN_COUNT */
	4, /* AFH_LISTEN_SCAN_CYCLE_REPEATS */
	4, /* CA_BLOCK_NOISE_THRESHOLD */
	4, /* CA_BLOCK_NOISE_HYSTERESIS */
	4, /* CA_DEFAULT_REVERT_TIME */
	2, /* CA_SMART_H2O_REJECT */
	2, /* CA_HOST_CONTROLLED_CHARGER */
	2, /* T_COMP_BUTTON_MUTUAL_HIGH */
	2, /* T_COMP_BUTTON_MUTUAL_LOW */
	2, /* T_COMP_BUTTON_SELF_HIGH */
	2, /* T_COMP_BUTTON_SELF_LOW */
	4, /* CA_NUM_SUB_CONV_BASE_SELF */
	4, /* CA_ALT_NUM_SUB_CONV_SELF */
	12, /* Reserved228 */
	1, /* CA_ALT_NUM_SUB_CONV_MUTUAL */
	1, /* CA_ALT_ACQUISITION_FLAGS */
	1, /* AFH_ALT_TX_PERIOD1_MUTUAL */
	1, /* AFH_ALT_TX_PERIOD1_MUTUAL_SCALE_FACTOR */
	1, /* AFH_ALT_TX_PERIOD1_MUTUAL_TX_VOLTAGE */
	1, /* AFH_ALT_TX_PERIOD2_MUTUAL */
	1, /* AFH_ALT_TX_PERIOD2_MUTUAL_SCALE_FACTOR */
	1, /* AFH_ALT_TX_PERIOD2_MUTUAL_TX_VOLTAGE */
	4, /* Reserved248 */
	1, /* GEST_CFG_SIZE */
	1, /* PAN_ACT_DSTX */
	1, /* PAN_ACT_DSTY */
	1, /* ZOOM_ACT_DSTX */
	1, /* ZOOM_ACT_DSTY */
	1, /* FLICK_ACT_DISTX */
	1, /* FLICK_ACT_DISTY */
	1, /* FLICK_TIME */
	1, /* ST_DEBOUNCE */
	1, /* MT_DEBOUNCE_PAN */
	1, /* MT_DEBOUNCE_ZOOM */
	1, /* MT_DEBOUNCE_P2Z */
	1, /* ROT_DEBOUNCE */
	1, /* COMPL_DEBOUNCE */
	2, /* MT_TIMEOUT */
	1, /* ST_DBLCLK_RMAX */
	1, /* ST_CLICK_DISTX */
	1, /* ST_CLICK_DISTY */
	1, /* Reserved271 */
	2, /* MT_CLICK_TMAX */
	2, /* MT_CLICK_TMIN */
	2, /* ST_CLICK_TMAX */
	2, /* ST_CLICK_TMIN */
	2, /* ST_DBLCLK_TMAX */
	2, /* ST_DBLCLK_TMIN */
	1, /* GESTURE_GROUP_MASK */
	1, /* GESTURE_GROUP1_START */
	1, /* GESTURE_GROUP1_END */
	1, /* GESTURE_GROUP2_START */
	1, /* GESTURE_GROUP2_END */
	1, /* GESTURE_GROUP3_START */
	1, /* GESTURE_GROUP3_END */
	1, /* GESTURE_GROUP4_START */
	1, /* GESTURE_GROUP4_END */
	3, /* Reserved293 */
	4, /* XY_FILT_CFG_SIZE */
	4, /* XY_FILTER_MASK */
	4, /* XY_FILT_IIR_COEFF */
	4, /* XY_FILT_Z_IIR_COEFF */
	1, /* XY_FILT_XY_FAST_THR */
	1, /* XY_FILT_XY_SLOW_THR */
	1, /* XY_FILT_IIR_FAST_COEFF */
	1, /* Reserved315 */
	4, /* XY_FILTER_MASK_CA */
	4, /* XY_FILT_IIR_COEFF_CA */
	4, /* XY_FILT_Z_IIR_COEFF_CA */
	1, /* XY_FILT_XY_FAST_THR_CA */
	1, /* XY_FILT_XY_SLOW_THR_CA */
	1, /* XY_FILT_IIR_FAST_COEFF_CA */
	1, /* Reserved331 */
	1, /* XY_FILT_ADAPTIVE_IIR_FILTER */
	1, /* XY_FILT_ADAPTIVE_IIR_FILTER_DISTANCE */
	1, /* XY_FILT_TOUCH_SIZE_IIR_COEFF */
	1, /* XY_FILT_TOUCH_SIZE_HYST */
	1, /* XY_FILT_TOUCH_ORIENTATION_IIR_COEFF */
	1, /* XY_FILT_TOUCH_ORIENTATION_HYST */
	10, /* Reserved338 */
	4, /* FINGER_ID_CFG_SIZE */
	4, /* Reserved352 */
	4, /* FINGER_ID_MAX_FINGER_VELOCITY2 */
	1, /* LIFTOFF_DEBOUNCE */
	7, /* Reserved361 */
	4, /* CENTROID_SH_CFG_SIZE */
	4, /* STYLUS_THRSH */
	4, /* STYLUS_HYST */
	4, /* S2F_THRESHOLD */
	4, /* HOVER_THRSH */
	4, /* HOVER_HYST */
	8, /* Reserved392 */
	4, /* ID_COORDS_CFG_SIZE */
	1, /* LRG_OBJ_CFG */
	1, /* MAX_FAT_FINGER_SIZE */
	1, /* MIN_FAT_FINGER_SIZE */
	1, /* FINGER_THRESH_MUTUAL */
	2, /* FINGER_THRESH_SELF */
	1, /* INNER_EDGE_GAIN */
	1, /* OUTER_EDGE_GAIN */
	4, /* X_RESOLUTION */
	4, /* Y_RESOLUTION */
	4, /* SENSOR_ASSIGNMENT */
	4, /* Z_SCALING */
	1, /* RX_LINE_FILTER */
	1, /* BYPASS_THRESHOLD_GAIN */
	1, /* BYPASS_THRESHOLD_EDGE_GAIN */
	1, /* FINGER_THR_MUT_HYST */
	1, /* MAX_FAT_FINGER_SIZE_HYST */
	1, /* MIN_FAT_FINGER_SIZE_HYST */
	1, /* MULTI_TOUCH_DEBOUNCE */
	1, /* CA_FINGER_THRESHOLD_MUTUAL */
	1, /* FAT_FINGER_THRESHOLD_COEFF */
	1, /* SIZE_ORIENTATION_ENABLE */
	1, /* MAJOR_AXIS_OFFSET */
	1, /* MAJOR_AXIS_SCALE */
	1, /* MINOR_AXIS_OFFSET */
	1, /* MINOR_AXIS_SCALE */
	1, /* RX_LINE_FILTER_DEBOUNCE */
	1, /* CLIPPING_X_LOW */
	1, /* CLIPPING_X_HIGH */
	1, /* CLIPPING_Y_LOW */
	1, /* CLIPPING_Y_HIGH */
	17, /* Reserved447 */
	4, /* BTN_CFG_SIZE */
	2, /* BTN_THRSH_MUT */
	2, /* BTN_THRSH_MUT_1 */
	2, /* BTN_THRSH_MUT_2 */
	2, /* BTN_THRSH_MUT_3 */
	1, /* BTN_HYST_MUT */
	1, /* Reserved477 */
	1, /* Reserved478 */
	1, /* Reserved479 */
	2, /* BTN_THRSH_SELF */
	2, /* BTN_THRSH_SELF_1 */
	2, /* BTN_THRSH_SELF_2 */
	2, /* BTN_THRSH_SELF_3 */
	1, /* BTN_HYST_SELF */
	1, /* Reserved489 */
	1, /* Reserved490 */
	1, /* Reserved491 */
	4, /* RAW_PROC_CFG_SIZE */
	2, /* RAW_FILTER_MASK */
	1, /* RAW_FILT_IIR_COEFF_MUTUAL */
	1, /* RAW_FILT_IIR_THRESHOLD_MUTUAL */
	1, /* RAW_FILT_IIR_COEFF_SELF */
	1, /* RAW_FILT_IIR_THRESHOLD_SELF */
	1, /* RAW_FILT_IIR_COEFF_BALANCED */
	1, /* RAW_FILT_IIR_THRESHOLD_BALANCED */
	1, /* RAW_FILT_IIR_COEFF_BUTTONS */
	1, /* RAW_FILT_IIR_THRESHOLD_BUTTONS */
	2, /* Reserved506 */
	2, /* RAW_FILTER_MASK_CA */
	1, /* RAW_FILT_IIR_COEFF_MUTUAL_CA */
	1, /* RAW_FILT_IIR_THRESHOLD_MUTUAL_CA */
	1, /* RAW_FILT_IIR_COEFF_SELF_CA */
	1, /* RAW_FILT_IIR_THRESHOLD_SELF_CA */
	1, /* RAW_FILT_IIR_COEFF_BALANCED_CA */
	1, /* RAW_FILT_IIR_THRESHOLD_BALANCED_CA */
	1, /* RAW_FILT_IIR_COEFF_BUTTONS_CA */
	1, /* RAW_FILT_IIR_THRESHOLD_BUTTONS_CA */
	2, /* Reserved518 */
	12, /* Reserved520 */
	1, /* BL_DELAY_MUT */
	1, /* BL_DELAY_SELF */
	1, /* BL_DELAY_BAL */
	1, /* BL_DELAY_BTN */
	1, /* BL_THR_MUT */
	1, /* BL_THR_SELF */
	1, /* BL_THR_BAL */
	1, /* BL_THR_BTN_MUT */
	1, /* BL_H20_RJCT */
	1, /* BL_THR_BTN_SELF */
	1, /* BL_MUT_SIG_THRESHOLD_CA */
	1, /* BL_FILT_MUT */
	1, /* BL_FILT_SELF */
	1, /* BL_FILT_BAL */
	1, /* BL_FILT_BTN_MUT */
	1, /* BL_FILT_BTN_SELF */
	1, /* CMF_THR_MUT */
	1, /* CMF_THR_SELF */
	1, /* CMF_THR_BAL */
	1, /* CMF_THR_BTN_MUT */
	1, /* CMF_THR_BTN_SELF */
	3, /* Reserved553 */
	4, /* CDC_CFG_SIZE */
	4, /* TSS_CONTROL_MUT */
	4, /* TSS_LENGTH_MUT */
	4, /* TSS_TX_CONFIG_MUT */
	4, /* TSS_TX_CONTROL_MUT */
	4, /* TSS_SEQ_CONFIG1_MUT */
	4, /* TSS_SEQ_CONFIG2_MUT */
	4, /* TSS_SEQ_CONFIG3_MUT */
	4, /* TSS_SEQ_CONFIG4_MUT */
	4, /* TSS_SEQ_CONFIG5_MUT */
	4, /* TSS_SEQ_CONFIG6_MUT */
	4, /* TSS_SEQ_CONFIG7_MUT */
	4, /* TSS_SEQ_CONFIG8_MUT */
	4, /* TSS_EXT_CONFIG1_MUT */
	4, /* TSS_EXT_CONFIG2_MUT */
	4, /* TSS_EXT_INTERVAL_MUT */
	4, /* TSS_INT_CONFIG1_MUT */
	4, /* TSS_INT_CONFIG2_MUT */
	4, /* TSS_INT_INTERVAL_MUT */
	4, /* TSS_MCS_CONFIG_MUT */
	4, /* TSS_RX_CONFIG_MUT */
	4, /* Reserved640 */
	4, /* TSS_CONTROL_SELF */
	4, /* TSS_LENGTH_SELF */
	4, /* TSS_TX_CONFIG_SELF */
	4, /* TSS_TX_CONTROL_SELF */
	4, /* TSS_SEQ_CONFIG1_SELF */
	4, /* TSS_SEQ_CONFIG2_SELF */
	4, /* TSS_SEQ_CONFIG3_SELF */
	4, /* TSS_SEQ_CONFIG4_SELF */
	4, /* TSS_SEQ_CONFIG5_SELF */
	4, /* TSS_SEQ_CONFIG6_SELF */
	4, /* TSS_SEQ_CONFIG7_SELF */
	4, /* TSS_SEQ_CONFIG8_SELF */
	4, /* TSS_EXT_CONFIG1_SELF */
	4, /* TSS_EXT_CONFIG2_SELF */
	4, /* TSS_EXT_INTERVAL_SELF */
	4, /* TSS_INT_CONFIG1_SELF */
	4, /* TSS_INT_CONFIG2_SELF */
	4, /* TSS_INT_INTERVAL_SELF */
	4, /* TSS_MCS_CONFIG_SELF */
	4, /* TSS_RX_CONFIG_SELF */
	4, /* Reserved724 */
	4, /* TSS_CONTROL_BAL */
	4, /* TSS_LENGTH_BAL */
	4, /* TSS_TX_CONFIG_BAL */
	4, /* TSS_TX_CONTROL_BAL */
	4, /* TSS_SEQ_CONFIG1_BAL */
	4, /* TSS_SEQ_CONFIG2_BAL */
	4, /* TSS_SEQ_CONFIG3_BAL */
	4, /* TSS_SEQ_CONFIG4_BAL */
	4, /* TSS_SEQ_CONFIG5_BAL */
	4, /* TSS_SEQ_CONFIG6_BAL */
	4, /* TSS_SEQ_CONFIG7_BAL */
	4, /* TSS_SEQ_CONFIG8_BAL */
	4, /* TSS_EXT_CONFIG1_BAL */
	4, /* TSS_EXT_CONFIG2_BAL */
	4, /* TSS_EXT_INTERVAL_BAL */
	4, /* TSS_INT_CONFIG1_BAL */
	4, /* TSS_INT_CONFIG2_BAL */
	4, /* TSS_INT_INTERVAL_BAL */
	4, /* TSS_MCS_CONFIG_BAL */
	4, /* TSS_RX_CONFIG_BAL */
	4, /* TSS_CONTROL_BTN */
	4, /* TSS_LENGTH_BTN_MUT */
	4, /* TSS_TX_CONFIG_BTN */
	4, /* TSS_TX_CONTROL_BTN */
	4, /* TSS_SEQ_CONFIG1_BTN */
	4, /* TSS_SEQ_CONFIG2_BTN */
	4, /* TSS_SEQ_CONFIG3_BTN */
	4, /* TSS_SEQ_CONFIG4_BTN */
	4, /* TSS_SEQ_CONFIG5_BTN */
	4, /* TSS_SEQ_CONFIG6_BTN */
	4, /* TSS_SEQ_CONFIG7_BTN */
	4, /* TSS_SEQ_CONFIG8_BTN */
	4, /* TSS_EXT_CONFIG1_BTN */
	4, /* TSS_EXT_CONFIG2_BTN */
	4, /* TSS_EXT_INTERVAL_BTN */
	4, /* TSS_INT_CONFIG1_BTN */
	4, /* TSS_INT_CONFIG2_BTN */
	4, /* TSS_INT_INTERVAL_BTN */
	4, /* TSS_MCS_CONFIG_BTN */
	4, /* TSS_RX_CONFIG_BTN */
	4, /* TSS_LENGTH_BTN_SELF */
	4, /* TSS_RX_VREF */
	4, /* TSS_RX_LX_CONFIG */
	4, /* TX_NUM */
	4, /* RX_NUM */
	4, /* SENS_NUM */
	4, /* CROSS_NUM */
	4, /* BUTTON_NUM */
	4, /* SLOTS_MUT */
	4, /* SLOTS_SELF_RX */
	4, /* SLOTS_SELF_TX */
	4, /* SLOTS_SELF */
	4, /* SLOTS_BAL */
	4, /* SCALE_MUT */
	4, /* SCALE_SELF */
	4, /* SCALE_BAL */
	4, /* SCALE_BUTTON */
	4, /* LX_MODE */
	4, /* LX_SCALE */
	4, /* ABSOLUTE_CR_CORRECTION_ENABLE */
	4, /* SCANNING_MODE_MUTUAL */
	4, /* SCANNING_MODE_BUTTON */
	2, /* DETECT_CHARGER_THRESHOLD */
	1, /* CA_LX_SCAN_MODE */
	1, /* SUB_SLOT_SCAN */
	1, /* CDC_AFH1_THRESHOLD_2 */
	1, /* CDC_AFH1_THRESHOLD_1 */
	1, /* CDC_AFH2_THRESHOLD_2 */
	1, /* CDC_AFH2_THRESHOLD_1 */
	1, /* ADC_CONFIG */
	1, /* Reserved985 */
	1, /* TSS_LDO_PROG */
	1, /* TX_PERIOD_DUMMY_SCAN */
	2, /* LISTEN_MIN_VALUE */
	2, /* Reserved990 */
	4, /* CALIBRATION_PARAM_SIZE */
	4, /* Reserved996 */
	4, /* Reserved1000 */
	4, /* Reserved1004 */
	4, /* Reserved1008 */
	4, /* GLOBAL_IDAC_LSB_MUTUAL */
	4, /* GLOBAL_IDAC_LSB_SELF */
	4, /* GLOBAL_IDAC_LSB_BALANCED */
	4, /* GLOBAL_IDAC_LSB_BUTTON */
	4, /* TARGET_LEVEL_MUTUAL */
	4, /* TARGET_LEVEL_SELF */
	4, /* TARGET_LEVEL_BALANCED */
	4, /* TARGET_LEVEL_BUTTON */
	4, /* GAIN_MUTUAL */
	4, /* GAIN_SELF */
	4, /* GAIN_BALANCED */
	4, /* GAIN_BTN_MUTUAL */
	4, /* GAIN_BTN_SELF */
	4, /* Reserved1064 */
	4, /* SPREADER_CFG_SIZE */
	4, /* CLK_IMO_SPREAD */
	4, /* Reserved1076 */
	65, /* CDC_SENSOR_TO_SLOT_TABLE */
	3, /* Reserved1145 */
	65, /* CDC_PIN_INDEX_TABLE */
	3, /* Reserved1213 */
	4796, /* CDC_SLOT_TABLE */
	2, /* CONFIG_CRC */
};

/* Touchscreen Parameters Field Address*/
static const uint8_t cyttsp4_param_addr[] = {
/*	Address	Name	*/
	0xCA, 0x80, /* CONFIG_DATA_SIZE */
	0xCA, 0x82, /* CONFIG_DATA_MAX_SIZE */
	0xCA, 0x84, /* SDK_CTRL_CFG_SIZE */
	0xCA, 0x88, /* CONFIG_VER */
	0xCA, 0x8A, /* PANELID_ENABLE */
	0xCA, 0x8B, /* IMO_FREQ_MHZ */
	0xCA, 0x8C, /* X_LEN_PHY */
	0xCA, 0x8E, /* Y_LEN_PHY */
	0xCA, 0x90, /* HST_MODE0 */
	0xCA, 0x91, /* ACT_DIST0 */
	0xCA, 0x92, /* SCAN_TYP0 */
	0xCA, 0x93, /* ACT_INTRVL0 */
	0xCA, 0x94, /* ACT_LFT_INTRVL0 */
	0xCA, 0x95, /* Reserved21 */
	0xCA, 0x96, /* LP_INTRVL0 */
	0xCA, 0x98, /* TCH_TMOUT0 */
	0xCA, 0x9A, /* PWR_CFG */
	0xCA, 0x9B, /* Reserved27 */
	0xCA, 0x9C, /* INT_PULSE_DATA */
	0xCA, 0x9D, /* OPMODE_CFG */
	0xCA, 0x9E, /* HANDSHAKE_TIMEOUT */
	0xCA, 0xA0, /* TIMER_CAL_INTERVAL */
	0xCA, 0xA1, /* Reserved33 */
	0xCA, 0xA2, /* RP2P_MIN */
	0xCA, 0xA4, /* ILEAK_MAX */
	0xCA, 0xA6, /* RFB_P2P */
	0xCA, 0xA8, /* RFB_EXT */
	0xCA, 0xAA, /* IDACOPEN_LOW */
	0xCA, 0xAB, /* IDACOPEN_HIGH */
	0xCA, 0xAC, /* IDACOPEN_BUTTON_LOW */
	0xCA, 0xAD, /* IDACOPEN_BUTTON_HIGH */
	0xCA, 0xAE, /* GIDAC_OPEN */
	0xCA, 0xAF, /* GAIN_OPEN */
	0xCA, 0xB0, /* GIDAC_BUTTON_OPEN */
	0xCA, 0xB1, /* GAIN_BUTTON_OPEN */
	0xCA, 0xB2, /* POST_CFG */
	0xCA, 0xB3, /* GESTURE_CFG */
	0xCA, 0xB4, /* GEST_EN0 */
	0xCA, 0xB5, /* GEST_EN1 */
	0xCA, 0xB6, /* GEST_EN2 */
	0xCA, 0xB7, /* GEST_EN3 */
	0xCA, 0xB8, /* GEST_EN4 */
	0xCA, 0xB9, /* GEST_EN5 */
	0xCA, 0xBA, /* GEST_EN6 */
	0xCA, 0xBB, /* GEST_EN7 */
	0xCA, 0xBC, /* GEST_EN8 */
	0xCA, 0xBD, /* GEST_EN9 */
	0xCA, 0xBE, /* GEST_EN10 */
	0xCA, 0xBF, /* GEST_EN11 */
	0xCA, 0xC0, /* GEST_EN12 */
	0xCA, 0xC1, /* GEST_EN13 */
	0xCA, 0xC2, /* GEST_EN14 */
	0xCA, 0xC3, /* GEST_EN15 */
	0xCA, 0xC4, /* GEST_EN16 */
	0xCA, 0xC5, /* GEST_EN17 */
	0xCA, 0xC6, /* GEST_EN18 */
	0xCA, 0xC7, /* GEST_EN19 */
	0xCA, 0xC8, /* GEST_EN20 */
	0xCA, 0xC9, /* GEST_EN21 */
	0xCA, 0xCA, /* GEST_EN22 */
	0xCA, 0xCB, /* GEST_EN23 */
	0xCA, 0xCC, /* GEST_EN24 */
	0xCA, 0xCD, /* GEST_EN25 */
	0xCA, 0xCE, /* GEST_EN26 */
	0xCA, 0xCF, /* GEST_EN27 */
	0xCA, 0xD0, /* GEST_EN28 */
	0xCA, 0xD1, /* GEST_EN29 */
	0xCA, 0xD2, /* GEST_EN30 */
	0xCA, 0xD3, /* GEST_EN31 */
	0xCA, 0xD4, /* ACT_DIST2 */
	0xCA, 0xD5, /* Reserved85 */
	0xCA, 0xE0, /* GRIP_CFG_SIZE */
	0xCA, 0xE4, /* GRIP_XEDG_A */
	0xCA, 0xE6, /* GRIP_XEDG_B */
	0xCA, 0xE8, /* GRIP_XEXC_A */
	0xCA, 0xEA, /* GRIP_XEXC_B */
	0xCA, 0xEC, /* GRIP_YEDG_A */
	0xCA, 0xEE, /* GRIP_YEDG_B */
	0xCA, 0xF0, /* GRIP_YEXC_A */
	0xCA, 0xF2, /* GRIP_YEXC_B */
	0xCA, 0xF4, /* GRIP_FIRST_EXC */
	0xCA, 0xF5, /* GRIP_EXC_EDGE_ORIGIN */
	0xCA, 0xF6, /* Reserved118 */
	0xCA, 0xF8, /* TRUETOUCH_CFG_SIZE */
	0xCA, 0xFC, /* MAX_SELF_SCAN_INTERVAL */
	0xCB, 0x00, /* MAX_MUTUAL_SCAN_INTERVAL */
	0xCB, 0x04, /* MAX_BALANCED_SCAN_INTERVAL */
	0xCB, 0x08, /* SELF_Z_THRSH */
	0xCB, 0x0C, /* SELF_Z_MODE */
	0xCB, 0x10, /* SMART_SCAN_ENABLE */
	0xCB, 0x14, /* T_COMP_ENABLE */
	0xCB, 0x18, /* T_COMP_INTERVAL */
	0xCB, 0x1C, /* T_COMP_RECAL_MUTUAL_SENSOR_LIMIT */
	0xCB, 0x20, /* T_COMP_RECAL_MUTUAL_HIGH */
	0xCB, 0x24, /* T_COMP_RECAL_MUTUAL_LOW */
	0xCB, 0x28, /* T_COMP_RECAL_SELF_SENSOR_LIMIT */
	0xCB, 0x2C, /* T_COMP_RECAL_SELF_HIGH */
	0xCB, 0x30, /* T_COMP_RECAL_SELF_LOW */
	0xCB, 0x34, /* CHARGER_ARMOR_ENABLE */
	0xCB, 0x38, /* AFH_ENABLE */
	0xCB, 0x3C, /* AFH_LISTENING_SCAN_COUNT */
	0xCB, 0x40, /* AFH_LISTEN_SCAN_CYCLE_REPEATS */
	0xCB, 0x44, /* CA_BLOCK_NOISE_THRESHOLD */
	0xCB, 0x48, /* CA_BLOCK_NOISE_HYSTERESIS */
	0xCB, 0x4C, /* CA_DEFAULT_REVERT_TIME */
	0xCB, 0x50, /* CA_SMART_H2O_REJECT */
	0xCB, 0x52, /* CA_HOST_CONTROLLED_CHARGER */
	0xCB, 0x54, /* T_COMP_BUTTON_MUTUAL_HIGH */
	0xCB, 0x56, /* T_COMP_BUTTON_MUTUAL_LOW */
	0xCB, 0x58, /* T_COMP_BUTTON_SELF_HIGH */
	0xCB, 0x5A, /* T_COMP_BUTTON_SELF_LOW */
	0xCB, 0x5C, /* CA_NUM_SUB_CONV_BASE_SELF */
	0xCB, 0x60, /* CA_ALT_NUM_SUB_CONV_SELF */
	0xCB, 0x64, /* Reserved228 */
	0xCB, 0x70, /* CA_ALT_NUM_SUB_CONV_MUTUAL */
	0xCB, 0x71, /* CA_ALT_ACQUISITION_FLAGS */
	0xCB, 0x72, /* AFH_ALT_TX_PERIOD1_MUTUAL */
	0xCB, 0x73, /* AFH_ALT_TX_PERIOD1_MUTUAL_SCALE_FACTOR */
	0xCB, 0x74, /* AFH_ALT_TX_PERIOD1_MUTUAL_TX_VOLTAGE */
	0xCB, 0x75, /* AFH_ALT_TX_PERIOD2_MUTUAL */
	0xCB, 0x76, /* AFH_ALT_TX_PERIOD2_MUTUAL_SCALE_FACTOR */
	0xCB, 0x77, /* AFH_ALT_TX_PERIOD2_MUTUAL_TX_VOLTAGE */
	0xCB, 0x78, /* Reserved248 */
	0xCB, 0x7C, /* GEST_CFG_SIZE */
	0xCB, 0x7D, /* PAN_ACT_DSTX */
	0xCB, 0x7E, /* PAN_ACT_DSTY */
	0xCB, 0x7F, /* ZOOM_ACT_DSTX */
	0xCB, 0x80, /* ZOOM_ACT_DSTY */
	0xCB, 0x81, /* FLICK_ACT_DISTX */
	0xCB, 0x82, /* FLICK_ACT_DISTY */
	0xCB, 0x83, /* FLICK_TIME */
	0xCB, 0x84, /* ST_DEBOUNCE */
	0xCB, 0x85, /* MT_DEBOUNCE_PAN */
	0xCB, 0x86, /* MT_DEBOUNCE_ZOOM */
	0xCB, 0x87, /* MT_DEBOUNCE_P2Z */
	0xCB, 0x88, /* ROT_DEBOUNCE */
	0xCB, 0x89, /* COMPL_DEBOUNCE */
	0xCB, 0x8A, /* MT_TIMEOUT */
	0xCB, 0x8C, /* ST_DBLCLK_RMAX */
	0xCB, 0x8D, /* ST_CLICK_DISTX */
	0xCB, 0x8E, /* ST_CLICK_DISTY */
	0xCB, 0x8F, /* Reserved271 */
	0xCB, 0x90, /* MT_CLICK_TMAX */
	0xCB, 0x92, /* MT_CLICK_TMIN */
	0xCB, 0x94, /* ST_CLICK_TMAX */
	0xCB, 0x96, /* ST_CLICK_TMIN */
	0xCB, 0x98, /* ST_DBLCLK_TMAX */
	0xCB, 0x9A, /* ST_DBLCLK_TMIN */
	0xCB, 0x9C, /* GESTURE_GROUP_MASK */
	0xCB, 0x9D, /* GESTURE_GROUP1_START */
	0xCB, 0x9E, /* GESTURE_GROUP1_END */
	0xCB, 0x9F, /* GESTURE_GROUP2_START */
	0xCB, 0xA0, /* GESTURE_GROUP2_END */
	0xCB, 0xA1, /* GESTURE_GROUP3_START */
	0xCB, 0xA2, /* GESTURE_GROUP3_END */
	0xCB, 0xA3, /* GESTURE_GROUP4_START */
	0xCB, 0xA4, /* GESTURE_GROUP4_END */
	0xCB, 0xA5, /* Reserved293 */
	0xCB, 0xA8, /* XY_FILT_CFG_SIZE */
	0xCB, 0xAC, /* XY_FILTER_MASK */
	0xCB, 0xB0, /* XY_FILT_IIR_COEFF */
	0xCB, 0xB4, /* XY_FILT_Z_IIR_COEFF */
	0xCB, 0xB8, /* XY_FILT_XY_FAST_THR */
	0xCB, 0xB9, /* XY_FILT_XY_SLOW_THR */
	0xCB, 0xBA, /* XY_FILT_IIR_FAST_COEFF */
	0xCB, 0xBB, /* Reserved315 */
	0xCB, 0xBC, /* XY_FILTER_MASK_CA */
	0xCB, 0xC0, /* XY_FILT_IIR_COEFF_CA */
	0xCB, 0xC4, /* XY_FILT_Z_IIR_COEFF_CA */
	0xCB, 0xC8, /* XY_FILT_XY_FAST_THR_CA */
	0xCB, 0xC9, /* XY_FILT_XY_SLOW_THR_CA */
	0xCB, 0xCA, /* XY_FILT_IIR_FAST_COEFF_CA */
	0xCB, 0xCB, /* Reserved331 */
	0xCB, 0xCC, /* XY_FILT_ADAPTIVE_IIR_FILTER */
	0xCB, 0xCD, /* XY_FILT_ADAPTIVE_IIR_FILTER_DISTANCE */
	0xCB, 0xCE, /* XY_FILT_TOUCH_SIZE_IIR_COEFF */
	0xCB, 0xCF, /* XY_FILT_TOUCH_SIZE_HYST */
	0xCB, 0xD0, /* XY_FILT_TOUCH_ORIENTATION_IIR_COEFF */
	0xCB, 0xD1, /* XY_FILT_TOUCH_ORIENTATION_HYST */
	0xCB, 0xD2, /* Reserved338 */
	0xCB, 0xDC, /* FINGER_ID_CFG_SIZE */
	0xCB, 0xE0, /* Reserved352 */
	0xCB, 0xE4, /* FINGER_ID_MAX_FINGER_VELOCITY2 */
	0xCB, 0xE8, /* LIFTOFF_DEBOUNCE */
	0xCB, 0xE9, /* Reserved361 */
	0xCB, 0xF0, /* CENTROID_SH_CFG_SIZE */
	0xCB, 0xF4, /* STYLUS_THRSH */
	0xCB, 0xF8, /* STYLUS_HYST */
	0xCB, 0xFC, /* S2F_THRESHOLD */
	0xCC, 0x00, /* HOVER_THRSH */
	0xCC, 0x04, /* HOVER_HYST */
	0xCC, 0x08, /* Reserved392 */
	0xCC, 0x10, /* ID_COORDS_CFG_SIZE */
	0xCC, 0x14, /* LRG_OBJ_CFG */
	0xCC, 0x15, /* MAX_FAT_FINGER_SIZE */
	0xCC, 0x16, /* MIN_FAT_FINGER_SIZE */
	0xCC, 0x17, /* FINGER_THRESH_MUTUAL */
	0xCC, 0x18, /* FINGER_THRESH_SELF */
	0xCC, 0x1A, /* INNER_EDGE_GAIN */
	0xCC, 0x1B, /* OUTER_EDGE_GAIN */
	0xCC, 0x1C, /* X_RESOLUTION */
	0xCC, 0x20, /* Y_RESOLUTION */
	0xCC, 0x24, /* SENSOR_ASSIGNMENT */
	0xCC, 0x28, /* Z_SCALING */
	0xCC, 0x2C, /* RX_LINE_FILTER */
	0xCC, 0x2D, /* BYPASS_THRESHOLD_GAIN */
	0xCC, 0x2E, /* BYPASS_THRESHOLD_EDGE_GAIN */
	0xCC, 0x2F, /* FINGER_THR_MUT_HYST */
	0xCC, 0x30, /* MAX_FAT_FINGER_SIZE_HYST */
	0xCC, 0x31, /* MIN_FAT_FINGER_SIZE_HYST */
	0xCC, 0x32, /* MULTI_TOUCH_DEBOUNCE */
	0xCC, 0x33, /* CA_FINGER_THRESHOLD_MUTUAL */
	0xCC, 0x34, /* FAT_FINGER_THRESHOLD_COEFF */
	0xCC, 0x35, /* SIZE_ORIENTATION_ENABLE */
	0xCC, 0x36, /* MAJOR_AXIS_OFFSET */
	0xCC, 0x37, /* MAJOR_AXIS_SCALE */
	0xCC, 0x38, /* MINOR_AXIS_OFFSET */
	0xCC, 0x39, /* MINOR_AXIS_SCALE */
	0xCC, 0x3A, /* RX_LINE_FILTER_DEBOUNCE */
	0xCC, 0x3B, /* CLIPPING_X_LOW */
	0xCC, 0x3C, /* CLIPPING_X_HIGH */
	0xCC, 0x3D, /* CLIPPING_Y_LOW */
	0xCC, 0x3E, /* CLIPPING_Y_HIGH */
	0xCC, 0x3F, /* Reserved447 */
	0xCC, 0x50, /* BTN_CFG_SIZE */
	0xCC, 0x54, /* BTN_THRSH_MUT */
	0xCC, 0x56, /* BTN_THRSH_MUT_1 */
	0xCC, 0x58, /* BTN_THRSH_MUT_2 */
	0xCC, 0x5A, /* BTN_THRSH_MUT_3 */
	0xCC, 0x5C, /* BTN_HYST_MUT */
	0xCC, 0x5D, /* Reserved477 */
	0xCC, 0x5E, /* Reserved478 */
	0xCC, 0x5F, /* Reserved479 */
	0xCC, 0x60, /* BTN_THRSH_SELF */
	0xCC, 0x62, /* BTN_THRSH_SELF_1 */
	0xCC, 0x64, /* BTN_THRSH_SELF_2 */
	0xCC, 0x66, /* BTN_THRSH_SELF_3 */
	0xCC, 0x68, /* BTN_HYST_SELF */
	0xCC, 0x69, /* Reserved489 */
	0xCC, 0x6A, /* Reserved490 */
	0xCC, 0x6B, /* Reserved491 */
	0xCC, 0x6C, /* RAW_PROC_CFG_SIZE */
	0xCC, 0x70, /* RAW_FILTER_MASK */
	0xCC, 0x72, /* RAW_FILT_IIR_COEFF_MUTUAL */
	0xCC, 0x73, /* RAW_FILT_IIR_THRESHOLD_MUTUAL */
	0xCC, 0x74, /* RAW_FILT_IIR_COEFF_SELF */
	0xCC, 0x75, /* RAW_FILT_IIR_THRESHOLD_SELF */
	0xCC, 0x76, /* RAW_FILT_IIR_COEFF_BALANCED */
	0xCC, 0x77, /* RAW_FILT_IIR_THRESHOLD_BALANCED */
	0xCC, 0x78, /* RAW_FILT_IIR_COEFF_BUTTONS */
	0xCC, 0x79, /* RAW_FILT_IIR_THRESHOLD_BUTTONS */
	0xCC, 0x7A, /* Reserved506 */
	0xCC, 0x7C, /* RAW_FILTER_MASK_CA */
	0xCC, 0x7E, /* RAW_FILT_IIR_COEFF_MUTUAL_CA */
	0xCC, 0x7F, /* RAW_FILT_IIR_THRESHOLD_MUTUAL_CA */
	0xCC, 0x80, /* RAW_FILT_IIR_COEFF_SELF_CA */
	0xCC, 0x81, /* RAW_FILT_IIR_THRESHOLD_SELF_CA */
	0xCC, 0x82, /* RAW_FILT_IIR_COEFF_BALANCED_CA */
	0xCC, 0x83, /* RAW_FILT_IIR_THRESHOLD_BALANCED_CA */
	0xCC, 0x84, /* RAW_FILT_IIR_COEFF_BUTTONS_CA */
	0xCC, 0x85, /* RAW_FILT_IIR_THRESHOLD_BUTTONS_CA */
	0xCC, 0x86, /* Reserved518 */
	0xCC, 0x88, /* Reserved520 */
	0xCC, 0x94, /* BL_DELAY_MUT */
	0xCC, 0x95, /* BL_DELAY_SELF */
	0xCC, 0x96, /* BL_DELAY_BAL */
	0xCC, 0x97, /* BL_DELAY_BTN */
	0xCC, 0x98, /* BL_THR_MUT */
	0xCC, 0x99, /* BL_THR_SELF */
	0xCC, 0x9A, /* BL_THR_BAL */
	0xCC, 0x9B, /* BL_THR_BTN_MUT */
	0xCC, 0x9C, /* BL_H20_RJCT */
	0xCC, 0x9D, /* BL_THR_BTN_SELF */
	0xCC, 0x9E, /* BL_MUT_SIG_THRESHOLD_CA */
	0xCC, 0x9F, /* BL_FILT_MUT */
	0xCC, 0xA0, /* BL_FILT_SELF */
	0xCC, 0xA1, /* BL_FILT_BAL */
	0xCC, 0xA2, /* BL_FILT_BTN_MUT */
	0xCC, 0xA3, /* BL_FILT_BTN_SELF */
	0xCC, 0xA4, /* CMF_THR_MUT */
	0xCC, 0xA5, /* CMF_THR_SELF */
	0xCC, 0xA6, /* CMF_THR_BAL */
	0xCC, 0xA7, /* CMF_THR_BTN_MUT */
	0xCC, 0xA8, /* CMF_THR_BTN_SELF */
	0xCC, 0xA9, /* Reserved553 */
	0xCC, 0xAC, /* CDC_CFG_SIZE */
	0xCC, 0xB0, /* TSS_CONTROL_MUT */
	0xCC, 0xB4, /* TSS_LENGTH_MUT */
	0xCC, 0xB8, /* TSS_TX_CONFIG_MUT */
	0xCC, 0xBC, /* TSS_TX_CONTROL_MUT */
	0xCC, 0xC0, /* TSS_SEQ_CONFIG1_MUT */
	0xCC, 0xC4, /* TSS_SEQ_CONFIG2_MUT */
	0xCC, 0xC8, /* TSS_SEQ_CONFIG3_MUT */
	0xCC, 0xCC, /* TSS_SEQ_CONFIG4_MUT */
	0xCC, 0xD0, /* TSS_SEQ_CONFIG5_MUT */
	0xCC, 0xD4, /* TSS_SEQ_CONFIG6_MUT */
	0xCC, 0xD8, /* TSS_SEQ_CONFIG7_MUT */
	0xCC, 0xDC, /* TSS_SEQ_CONFIG8_MUT */
	0xCC, 0xE0, /* TSS_EXT_CONFIG1_MUT */
	0xCC, 0xE4, /* TSS_EXT_CONFIG2_MUT */
	0xCC, 0xE8, /* TSS_EXT_INTERVAL_MUT */
	0xCC, 0xEC, /* TSS_INT_CONFIG1_MUT */
	0xCC, 0xF0, /* TSS_INT_CONFIG2_MUT */
	0xCC, 0xF4, /* TSS_INT_INTERVAL_MUT */
	0xCC, 0xF8, /* TSS_MCS_CONFIG_MUT */
	0xCC, 0xFC, /* TSS_RX_CONFIG_MUT */
	0xCD, 0x00, /* Reserved640 */
	0xCD, 0x04, /* TSS_CONTROL_SELF */
	0xCD, 0x08, /* TSS_LENGTH_SELF */
	0xCD, 0x0C, /* TSS_TX_CONFIG_SELF */
	0xCD, 0x10, /* TSS_TX_CONTROL_SELF */
	0xCD, 0x14, /* TSS_SEQ_CONFIG1_SELF */
	0xCD, 0x18, /* TSS_SEQ_CONFIG2_SELF */
	0xCD, 0x1C, /* TSS_SEQ_CONFIG3_SELF */
	0xCD, 0x20, /* TSS_SEQ_CONFIG4_SELF */
	0xCD, 0x24, /* TSS_SEQ_CONFIG5_SELF */
	0xCD, 0x28, /* TSS_SEQ_CONFIG6_SELF */
	0xCD, 0x2C, /* TSS_SEQ_CONFIG7_SELF */
	0xCD, 0x30, /* TSS_SEQ_CONFIG8_SELF */
	0xCD, 0x34, /* TSS_EXT_CONFIG1_SELF */
	0xCD, 0x38, /* TSS_EXT_CONFIG2_SELF */
	0xCD, 0x3C, /* TSS_EXT_INTERVAL_SELF */
	0xCD, 0x40, /* TSS_INT_CONFIG1_SELF */
	0xCD, 0x44, /* TSS_INT_CONFIG2_SELF */
	0xCD, 0x48, /* TSS_INT_INTERVAL_SELF */
	0xCD, 0x4C, /* TSS_MCS_CONFIG_SELF */
	0xCD, 0x50, /* TSS_RX_CONFIG_SELF */
	0xCD, 0x54, /* Reserved724 */
	0xCD, 0x58, /* TSS_CONTROL_BAL */
	0xCD, 0x5C, /* TSS_LENGTH_BAL */
	0xCD, 0x60, /* TSS_TX_CONFIG_BAL */
	0xCD, 0x64, /* TSS_TX_CONTROL_BAL */
	0xCD, 0x68, /* TSS_SEQ_CONFIG1_BAL */
	0xCD, 0x6C, /* TSS_SEQ_CONFIG2_BAL */
	0xCD, 0x70, /* TSS_SEQ_CONFIG3_BAL */
	0xCD, 0x74, /* TSS_SEQ_CONFIG4_BAL */
	0xCD, 0x78, /* TSS_SEQ_CONFIG5_BAL */
	0xCD, 0x7C, /* TSS_SEQ_CONFIG6_BAL */
	0xCD, 0x80, /* TSS_SEQ_CONFIG7_BAL */
	0xCD, 0x84, /* TSS_SEQ_CONFIG8_BAL */
	0xCD, 0x88, /* TSS_EXT_CONFIG1_BAL */
	0xCD, 0x8C, /* TSS_EXT_CONFIG2_BAL */
	0xCD, 0x90, /* TSS_EXT_INTERVAL_BAL */
	0xCD, 0x94, /* TSS_INT_CONFIG1_BAL */
	0xCD, 0x98, /* TSS_INT_CONFIG2_BAL */
	0xCD, 0x9C, /* TSS_INT_INTERVAL_BAL */
	0xCD, 0xA0, /* TSS_MCS_CONFIG_BAL */
	0xCD, 0xA4, /* TSS_RX_CONFIG_BAL */
	0xCD, 0xA8, /* TSS_CONTROL_BTN */
	0xCD, 0xAC, /* TSS_LENGTH_BTN_MUT */
	0xCD, 0xB0, /* TSS_TX_CONFIG_BTN */
	0xCD, 0xB4, /* TSS_TX_CONTROL_BTN */
	0xCD, 0xB8, /* TSS_SEQ_CONFIG1_BTN */
	0xCD, 0xBC, /* TSS_SEQ_CONFIG2_BTN */
	0xCD, 0xC0, /* TSS_SEQ_CONFIG3_BTN */
	0xCD, 0xC4, /* TSS_SEQ_CONFIG4_BTN */
	0xCD, 0xC8, /* TSS_SEQ_CONFIG5_BTN */
	0xCD, 0xCC, /* TSS_SEQ_CONFIG6_BTN */
	0xCD, 0xD0, /* TSS_SEQ_CONFIG7_BTN */
	0xCD, 0xD4, /* TSS_SEQ_CONFIG8_BTN */
	0xCD, 0xD8, /* TSS_EXT_CONFIG1_BTN */
	0xCD, 0xDC, /* TSS_EXT_CONFIG2_BTN */
	0xCD, 0xE0, /* TSS_EXT_INTERVAL_BTN */
	0xCD, 0xE4, /* TSS_INT_CONFIG1_BTN */
	0xCD, 0xE8, /* TSS_INT_CONFIG2_BTN */
	0xCD, 0xEC, /* TSS_INT_INTERVAL_BTN */
	0xCD, 0xF0, /* TSS_MCS_CONFIG_BTN */
	0xCD, 0xF4, /* TSS_RX_CONFIG_BTN */
	0xCD, 0xF8, /* TSS_LENGTH_BTN_SELF */
	0xCD, 0xFC, /* TSS_RX_VREF */
	0xCE, 0x00, /* TSS_RX_LX_CONFIG */
	0xCE, 0x04, /* TX_NUM */
	0xCE, 0x08, /* RX_NUM */
	0xCE, 0x0C, /* SENS_NUM */
	0xCE, 0x10, /* CROSS_NUM */
	0xCE, 0x14, /* BUTTON_NUM */
	0xCE, 0x18, /* SLOTS_MUT */
	0xCE, 0x1C, /* SLOTS_SELF_RX */
	0xCE, 0x20, /* SLOTS_SELF_TX */
	0xCE, 0x24, /* SLOTS_SELF */
	0xCE, 0x28, /* SLOTS_BAL */
	0xCE, 0x2C, /* SCALE_MUT */
	0xCE, 0x30, /* SCALE_SELF */
	0xCE, 0x34, /* SCALE_BAL */
	0xCE, 0x38, /* SCALE_BUTTON */
	0xCE, 0x3C, /* LX_MODE */
	0xCE, 0x40, /* LX_SCALE */
	0xCE, 0x44, /* ABSOLUTE_CR_CORRECTION_ENABLE */
	0xCE, 0x48, /* SCANNING_MODE_MUTUAL */
	0xCE, 0x4C, /* SCANNING_MODE_BUTTON */
	0xCE, 0x50, /* DETECT_CHARGER_THRESHOLD */
	0xCE, 0x52, /* CA_LX_SCAN_MODE */
	0xCE, 0x53, /* SUB_SLOT_SCAN */
	0xCE, 0x54, /* CDC_AFH1_THRESHOLD_2 */
	0xCE, 0x55, /* CDC_AFH1_THRESHOLD_1 */
	0xCE, 0x56, /* CDC_AFH2_THRESHOLD_2 */
	0xCE, 0x57, /* CDC_AFH2_THRESHOLD_1 */
	0xCE, 0x58, /* ADC_CONFIG */
	0xCE, 0x59, /* Reserved985 */
	0xCE, 0x5A, /* TSS_LDO_PROG */
	0xCE, 0x5B, /* TX_PERIOD_DUMMY_SCAN */
	0xCE, 0x5C, /* LISTEN_MIN_VALUE */
	0xCE, 0x5E, /* Reserved990 */
	0xCE, 0x60, /* CALIBRATION_PARAM_SIZE */
	0xCE, 0x64, /* Reserved996 */
	0xCE, 0x68, /* Reserved1000 */
	0xCE, 0x6C, /* Reserved1004 */
	0xCE, 0x70, /* Reserved1008 */
	0xCE, 0x74, /* GLOBAL_IDAC_LSB_MUTUAL */
	0xCE, 0x78, /* GLOBAL_IDAC_LSB_SELF */
	0xCE, 0x7C, /* GLOBAL_IDAC_LSB_BALANCED */
	0xCE, 0x80, /* GLOBAL_IDAC_LSB_BUTTON */
	0xCE, 0x84, /* TARGET_LEVEL_MUTUAL */
	0xCE, 0x88, /* TARGET_LEVEL_SELF */
	0xCE, 0x8C, /* TARGET_LEVEL_BALANCED */
	0xCE, 0x90, /* TARGET_LEVEL_BUTTON */
	0xCE, 0x94, /* GAIN_MUTUAL */
	0xCE, 0x98, /* GAIN_SELF */
	0xCE, 0x9C, /* GAIN_BALANCED */
	0xCE, 0xA0, /* GAIN_BTN_MUTUAL */
	0xCE, 0xA4, /* GAIN_BTN_SELF */
	0xCE, 0xA8, /* Reserved1064 */
	0xCE, 0xAC, /* SPREADER_CFG_SIZE */
	0xCE, 0xB0, /* CLK_IMO_SPREAD */
	0xCE, 0xB4, /* Reserved1076 */
	0xCE, 0xB8, /* CDC_SENSOR_TO_SLOT_TABLE */
	0xCE, 0xF9, /* Reserved1145 */
	0xCE, 0xFC, /* CDC_PIN_INDEX_TABLE */
	0xCF, 0x3D, /* Reserved1213 */
	0xCF, 0x40, /* CDC_SLOT_TABLE */
	0xE1, 0xFC, /* CONFIG_CRC */
};

