#ifndef __SMB347_CHARGER_H
#define __SMB347_CHARGER_H

#include <linux/errno.h>
#include <linux/power_supply.h>

#define CHARGER_DEV_NAME "smb347_charger"

#if (defined(CONFIG_MACH_APQ8064_EF48S) || defined(CONFIG_MACH_APQ8064_EF49K) || defined(CONFIG_MACH_APQ8064_EF50L)) && (CONFIG_BOARD_VER == CONFIG_WS10)
#define USE_USBPHY_CABLE_DETECTION	1
#else
#define USE_SMB347_CABLE_DETECTION	1
#endif

#if (defined(CONFIG_SKY_EF52S_BOARD) || defined(CONFIG_SKY_EF52K_BOARD) || defined(CONFIG_SKY_EF52L_BOARD)) && (CONFIG_BOARD_VER < CONFIG_WS20)
#define SMB358_CHARGER_IC
#else
#define SMB347_CHARGER_IC
#endif

/*******************************************************
*	
*	CHARGER IC(SMB347/SMB358) Registers
*
*******************************************************/
#define REG_CHG_CURRENT			0x00
#define REG_INPUT_CURRENT_LIMIT	0x01
#define REG_VARIOUS_FUNCTIONS		0x02
#define REG_FLOAT_VOLTAGE			0x03
#define REG_CHG_CTRL	 			0x04
#define REG_STAT_TIMERS_CTRL		0x05
#define REG_PIN_ENABLE_CTRL		0x06
#define REG_SYSTEM_CTRL			0x07
#define REG_SYSOK_USB_SEL			0x08
#define REG_OTHER_CTRL				0x09
#define REG_OTG_TLIM_THERM_CTRL	0x0A
#define REG_TRIP_POINT				0x0B
#define REG_FAULT_INTERRUPT		0x0C
#define REG_STAT_INTERRUPT			0x0D
#define REG_CMD_REG_A				0x30
#define REG_CMD_REG_B				0x31
#define REG_INT_STAT_C				0x37
#define REG_STAT_REG_C				0x3D
#define REG_STAT_REG_D				0x3E
#define REG_STAT_REG_E				0x3F

#ifdef SMB347_CHARGER_IC
/*******************************************************
*	
*	CHARGER IC(SMB347) Config
*
*******************************************************/
#if defined(CONFIG_SKY_EF50L_BOARD)
#define DEFAULT_CHG_CURRENT			0x9A
#elif defined(CONFIG_SKY_EF48S_BOARD) || defined(CONFIG_SKY_EF49K_BOARD)
#define DEFAULT_CHG_CURRENT			0x99
#elif defined(CONFIG_SKY_EF51S_BOARD) || defined(CONFIG_SKY_EF51K_BOARD) || defined(CONFIG_SKY_EF51L_BOARD)
#define DEFAULT_CHG_CURRENT			0x98
#else
#define DEFAULT_CHG_CURRENT			0x79		
#endif
#define DEFAULT_INPUT_CURRENT_LIMIT	0x17		
#define DEFAULT_VARIOUS_FUNCTIONS	0x9F	
#define DEFAULT_FLOAT_VOLTAGE			0x6A
#define DEFAULT_CHG_CTRL	 			0xAE
#define DEFAULT_STAT_TIMERS_CTRL		0x1E
#define DEFAULTG_PIN_ENABLE_CTRL		0x08		
#define DEFAULT_SYSTEM_CTRL			0xFF
#define DEFAULT_SYSOK_USB_SEL			0x18
#define DEFAULT_OTHER_CTRL				0x1D
#define DEFAULT_OTG_TLIM_THERM_CTRL	0xB7
#define DEFAULT_TRIP_POINT				0x01
#define DEFAULT_FAULT_INTERRUPT		0x00
#define DEFAULT_STAT_INTERRUPT		0x10
#if (defined(CONFIG_SKY_EF51S_BOARD) || defined(CONFIG_SKY_EF51K_BOARD) || defined(CONFIG_SKY_EF51L_BOARD)) && (CONFIG_BOARD_VER == CONFIG_WS20)
#define DEFAULT_CMD_REG_A				0xC6
#else	// (defined(CONFIG_SKY_EF51S_BOARD) || defined(CONFIG_SKY_EF51K_BOARD) || defined(CONFIG_SKY_EF51L_BOARD)) && (CONFIG_BOARD_VER == CONFIG_WS20)
#define DEFAULT_CMD_REG_A				0xC0
#endif
#define DEFAULT_CMD_REG_B				0x03

#define FACTORY_CHG_CURRENT 	((DEFAULT_CHG_CURRENT&0x1F)|(0<<5))
#if defined(CONFIG_SKY_EF50L_BOARD) || defined(CONFIG_SKY_EF48S_BOARD) || defined(CONFIG_SKY_EF49K_BOARD)
#define WARM_CHG_CURRENT		((DEFAULT_CHG_CURRENT&0x1F)|(3<<5))
#else
#define WARM_CHG_CURRENT		((DEFAULT_CHG_CURRENT&0x1F)|(2<<5))
#endif
#define CRITICAL_CHG_CURRENT	((DEFAULT_CHG_CURRENT&0x1F)|(0<<5))

#define FACTORY_INPUT_LIMIT	((DEFAULT_INPUT_CURRENT_LIMIT&0xF0)|0x09)

#else //#ifdef SMB347_CHARGER_IC
/*******************************************************
*	
*	CHARGER IC(SMB358) Config
*
*******************************************************/
#define DEFAULT_CHG_CURRENT			0xC8		
#define DEFAULT_INPUT_CURRENT_LIMIT	0x72		
#define DEFAULT_VARIOUS_FUNCTIONS	0xDB	
#define DEFAULT_FLOAT_VOLTAGE			0x6A
#define DEFAULT_CHG_CTRL	 			0x24
#define DEFAULT_STAT_TIMERS_CTRL		0x1E
#define DEFAULTG_PIN_ENABLE_CTRL		0x09		
#define DEFAULT_SYSTEM_CTRL			0x7F
#define DEFAULT_SYSOK_USB_SEL			0x18
#define DEFAULT_OTHER_CTRL				0x1D
#define DEFAULT_OTG_TLIM_THERM_CTRL	0xF3
#define DEFAULT_TRIP_POINT				0x01
#define DEFAULT_FAULT_INTERRUPT		0x00
#define DEFAULT_STAT_INTERRUPT		0x10
#define DEFAULT_CMD_REG_A				0xC0
#define DEFAULT_CMD_REG_B				0x03

#define FACTORY_CHG_CURRENT 	((DEFAULT_CHG_CURRENT&0x1F)|(1<<5))
#define WARM_CHG_CURRENT		((DEFAULT_CHG_CURRENT&0x1F)|(5<<5))
#define CRITICAL_CHG_CURRENT	((DEFAULT_CHG_CURRENT&0x1F)|(1<<5))

#define FACTORY_INPUT_LIMIT	(DEFAULT_INPUT_CURRENT_LIMIT)
#endif

#define DISABLE_APSD			((DEFAULT_CHG_CTRL&0xFB)|(0<<2))

#define CHG_ENABLE				(DEFAULT_CMD_REG_A|(1<<1))
#define OTG_ENABLE				0x91

#define USB_MODE				((DEFAULT_CMD_REG_B&0xFE)|(0<<0))
#define HC_MODE					((DEFAULT_CMD_REG_B&0xFE)|(1<<0))
#define OTG_MODE				(DEFAULT_CMD_REG_B&0x00)

enum battery_thermal_trip_type {
	BATT_THERM_FATAL_COLD = 0,
	BATT_THERM_CRITICAL_COLD,
	BATT_THERM_NORMAL,
	BATT_THERM_WARM,
	BATT_THERM_CRITICAL_HOT,
	BATT_THERM_FATAL_HOT,
	BATT_THERM_UNKNOWN,
};

struct pantech_therm_trip_info {
	int batt_temp;
	int therm_trip;
};

static const struct pantech_therm_trip_info batt_therm_table[] = {
		/* {temperature , battery thermal trip} */
		{-70, BATT_THERM_FATAL_COLD},
		{30, BATT_THERM_CRITICAL_COLD},
#if defined(CONFIG_SKY_EF50L_BOARD) || defined(CONFIG_SKY_EF48S_BOARD) || defined(CONFIG_SKY_EF49K_BOARD)
		{351, BATT_THERM_NORMAL},
		{481, BATT_THERM_WARM},
#else
		{381, BATT_THERM_NORMAL},
		{431, BATT_THERM_WARM},
#endif
		{601, BATT_THERM_CRITICAL_HOT},
		{681, BATT_THERM_FATAL_HOT},
};

enum pantech_cable_type {
	PANTECH_CABLE_NONE=0,
	PANTECH_OTG,
	PANTECH_USB,
	PANTECH_AC,
	PANTECH_FACTORY,
	PANTECH_AUDIO_DOCKING_STATION,
	PANTECH_CABLE_MAX,
};

enum
{
	APSD_NOT_RUN	= 0,
	APSD_CDP,
	APSD_DCP,
	APSD_OCP,
	APSD_SDP,
	APSD_ACA,
	APSD_NOT_USED,
};

struct smb347_regs_value {
	u8 charge_current;
	u8 input_cur_limit; 
	u8 float_voltage;
	u8 cmd_reg_a;
	u8 cmd_reg_b;
};

struct pantech_cable_id_info {
	int cable;
	int min_adc;
	int max_adc;
};

static const struct pantech_cable_id_info pantech_cable_info[] = {
		{PANTECH_OTG, 0, 1000000},
		{PANTECH_FACTORY, 1100000, 1350000},
#ifdef CONFIG_SKY_SND_DOCKING_CRADLE		
#if !(defined(CONFIG_MACH_APQ8064_EF48S) || defined(CONFIG_MACH_APQ8064_EF49K) || defined(CONFIG_MACH_APQ8064_EF50L))
		{PANTECH_AUDIO_DOCKING_STATION, 1520000, 1620000},
#endif
#endif
};

static const struct smb347_regs_value therm_normal_val[PANTECH_CABLE_MAX] = {
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE}, 	/* PANTECH_CABLE_NONE */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, OTG_ENABLE, OTG_MODE},	/* PANTECH_OTG */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, USB_MODE},	/* PANTECH_USB */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_AC */
	{FACTORY_CHG_CURRENT, FACTORY_INPUT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_FACTORY */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_AUDIO_DOCKING_STATION */
};
static const struct smb347_regs_value therm_warm_val[PANTECH_CABLE_MAX] = {
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, DEFAULT_CMD_REG_A, HC_MODE}, 	/* PANTECH_CABLE_NONE */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, OTG_ENABLE, OTG_MODE},	/* PANTECH_OTG */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, USB_MODE},	/* PANTECH_USB */
	{WARM_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_AC */
	{WARM_CHG_CURRENT, FACTORY_INPUT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_FACTORY */
	{WARM_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_AUDIO_DOCKING_STATION */
};
static const struct smb347_regs_value therm_critical_val[PANTECH_CABLE_MAX] = {
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, DEFAULT_CMD_REG_A, HC_MODE}, 	/* PANTECH_CABLE_NONE */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, OTG_ENABLE, OTG_MODE},	/* PANTECH_OTG */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, USB_MODE},	/* PANTECH_USB */
	{CRITICAL_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_AC */
	{CRITICAL_CHG_CURRENT, FACTORY_INPUT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_FACTORY */
	{CRITICAL_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, CHG_ENABLE, HC_MODE},	/* PANTECH_AUDIO_DOCKING_STATION */
};
static const struct smb347_regs_value therm_fatal_val[PANTECH_CABLE_MAX] = {
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, DEFAULT_CMD_REG_A, HC_MODE}, 	/* PANTECH_CABLE_NONE */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, OTG_ENABLE, OTG_MODE},	/* PANTECH_OTG */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, DEFAULT_CMD_REG_A, USB_MODE},	/* PANTECH_USB */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, DEFAULT_CMD_REG_A, HC_MODE},	/* PANTECH_AC */
	{DEFAULT_CHG_CURRENT, FACTORY_INPUT_LIMIT, DEFAULT_FLOAT_VOLTAGE, DEFAULT_CMD_REG_A, HC_MODE},	/* PANTECH_FACTORY */
	{DEFAULT_CHG_CURRENT, DEFAULT_INPUT_CURRENT_LIMIT, DEFAULT_FLOAT_VOLTAGE, DEFAULT_CMD_REG_A, HC_MODE},	/* PANTECH_AUDIO_DOCKING_STATION */
};

struct temp_adc_info {
	int offset;
	int min_temp;
};

static const struct temp_adc_info dischg_offset_table[] = {
	{0, -110},
	{10, 270},
	{20, 510},
	{30, 600},
	{20, 700},
	{0, 900},
};

static const struct temp_adc_info dc_chg_offset_table[] = {
	{0, -110},
	{15, 330},
	{30, 510},
	{20, 600},
	{10, 700},
	{0, 900},
};

#if defined(CONFIG_PANTECH_SMB347_CHARGER)
int smb347_charger_register_vbus_sn(void (*callback)(int));
void smb347_charger_unregister_vbus_sn(void (*callback)(int));

int smb347_set_usb_power_supply_type(enum power_supply_type type);
void smb347_charger_vbus_draw(unsigned int mA, unsigned int chg_type);
#endif

#endif
