#define NUM_ROT_SIZE            46
#define NUM_ROT_SIZE_IN_CMDS    7
#define SIZE_INIT               51
char veil_init_1[5] ={0xDF, 0x55,0xAA,0x52,0x08};
char veil_init_2[9] ={0xB0, 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
char veil_init_3[5] ={0xDF, 0x55,0xAA,0x52,0x00};

char veil_init[SIZE_INIT][2] = {
    // part 1
    {0x93, 0x03},{0xC2, 0x02},{0xC3, 0x03},{0xC4, 0x04},{0xC5, 0x05},
    {0xC6, 0x06},{0xC7, 0x07},{0xC8, 0x08},{0xC9, 0x09},{0xCA, 0x0A},
    {0xCC, 0x00},{0xCD, 0x00},{0xCE, 0xD8},{0xCF, 0x81},{0xD0, 0xAE},
    {0xD1, 0x79},{0xD2, 0x7A},{0xD4, 0x00},{0xD5, 0x00},{0xD6, 0xCF},
    {0xD7, 0xFF},{0xD8, 0x40},{0xD9, 0x20},{0xE8, 0x38},{0xE9, 0x47},
    {0xEA, 0x62},{0xEB, 0x4B},{0xEC, 0x84},

    // part 2
    
    {0x93, 0x03},{0xE0, 0x3F},{0xE1, 0x03},{0xE2, 0x0C},{0xE3, 0x0F},
    {0xE4, 0x30},{0xE5, 0x33},{0xE6, 0x3C},{0xE7, 0x00},

    //part 3
    {0x91, 0x84},{0x92, 0x01},{0x93, 0x00},

    // part 4
    {0x93, 0x03},{0xC0, 0x18},{0xC1, 0x01},{0xCB, 0x00},{0xD3, 0x10},
    {0xDD, 0x03},{0xDE, 0x01},{0xDF, 0x22},{0x90, 0x01},{0x91, 0x84},
    {0x93, 0x00}
    
};
#define MAX_ROT     8
#define MAX_SIZE    3

#define NUM_LUT     27
#define SIZE_LUT    783
char veil_lut[NUM_LUT][SIZE_LUT][2] = {

    // [0] Strong -6
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x4B},{0xC1, 0x4B},{0xC2, 0x4C},{0xC3, 0x4C},{0xC4, 0x4D},{0xC5, 0x4D},{0xC6, 0x4E},{0xC7, 0x4F},
        {0xC8, 0x50},{0xC9, 0x51},{0xCA, 0x52},{0xCB, 0x53},{0xCC, 0x54},{0xCD, 0x56},{0xCE, 0x57},{0xCF, 0x59},{0xD0, 0x5B},{0xD1, 0x5B},
        {0xD2, 0x5D},{0xD3, 0x5F},{0xD4, 0x62},{0xD5, 0x64},{0xD6, 0x65},{0xD7, 0x67},{0xD8, 0x6A},{0xD9, 0x6C},{0xDA, 0x6D},{0xDB, 0x6F},
        {0xDC, 0x71},{0xDD, 0x73},{0xDE, 0x75},{0xDF, 0x77},{0xE0, 0x7B},{0xE1, 0x7D},{0xE2, 0x7F},{0xE3, 0x81},{0xE4, 0x83},{0xE5, 0x85},
        {0xE6, 0x87},{0xE7, 0x89},{0xE8, 0x8B},{0xE9, 0x8F},{0xEA, 0x91},{0xEB, 0x93},{0xEC, 0x95},{0xED, 0x97},{0xEE, 0x99},{0xEF, 0x9C},
        {0xF0, 0x9E},{0xF1, 0xA0},{0xF2, 0xA3},{0xF3, 0xA5},{0xF4, 0xA8},{0xF5, 0xAA},{0xF6, 0xAC},{0xF7, 0xAE},{0xF8, 0xB1},{0xF9, 0xB3},
        {0xFA, 0xB6},{0xFB, 0xB8},{0xFC, 0xBC},{0xFD, 0xBE},{0xFE, 0xC1},{0xFF, 0xC3},{0x93, 0x09},{0xC0, 0x51},{0xC1, 0x51},{0xC2, 0x51},
        {0xC3, 0x52},{0xC4, 0x52},{0xC5, 0x53},{0xC6, 0x54},{0xC7, 0x55},{0xC8, 0x56},{0xC9, 0x58},{0xCA, 0x5A},{0xCB, 0x5B},{0xCC, 0x5C},
        {0xCD, 0x5E},{0xCE, 0x61},{0xCF, 0x64},{0xD0, 0x65},{0xD1, 0x67},{0xD2, 0x6A},{0xD3, 0x6D},{0xD4, 0x6E},{0xD5, 0x71},{0xD6, 0x73},
        {0xD7, 0x76},{0xD8, 0x79},{0xD9, 0x7C},{0xDA, 0x7E},{0xDB, 0x80},{0xDC, 0x83},{0xDD, 0x86},{0xDE, 0x88},{0xDF, 0x8A},{0xE0, 0x8F},
        {0xE1, 0x92},{0xE2, 0x95},{0xE3, 0x96},{0xE4, 0x98},{0xE5, 0x9B},{0xE6, 0x9E},{0xE7, 0xA1},{0xE8, 0xA4},{0xE9, 0xA7},{0xEA, 0xAA},
        {0xEB, 0xAC},{0xEC, 0xAF},{0xED, 0xB2},{0xEE, 0xB5},{0xEF, 0xB9},{0xF0, 0xBD},{0xF1, 0xC0},{0xF2, 0xC3},{0xF3, 0xC5},{0xF4, 0xC7},
        {0xF5, 0xCB},{0xF6, 0xCE},{0xF7, 0xD0},{0xF8, 0xD3},{0xF9, 0xD6},{0xFA, 0xD9},{0xFB, 0xDC},{0xFC, 0xDE},{0xFD, 0xE1},{0xFE, 0xE4},
        {0xFF, 0xE7},{0x93, 0x0A},{0xC0, 0x2B},{0xC1, 0x2B},{0xC2, 0x2B},{0xC3, 0x2B},{0xC4, 0x2C},{0xC5, 0x2C},{0xC6, 0x2E},{0xC7, 0x2F},
        {0xC8, 0x30},{0xC9, 0x31},{0xCA, 0x32},{0xCB, 0x33},{0xCC, 0x34},{0xCD, 0x35},{0xCE, 0x36},{0xCF, 0x38},{0xD0, 0x39},{0xD1, 0x3A},
        {0xD2, 0x3B},{0xD3, 0x3C},{0xD4, 0x3D},{0xD5, 0x3E},{0xD6, 0x3F},{0xD7, 0x41},{0xD8, 0x42},{0xD9, 0x45},{0xDA, 0x46},{0xDB, 0x48},
        {0xDC, 0x49},{0xDD, 0x4A},{0xDE, 0x4B},{0xDF, 0x4D},{0xE0, 0x4F},{0xE1, 0x50},{0xE2, 0x52},{0xE3, 0x53},{0xE4, 0x54},{0xE5, 0x56},
        {0xE6, 0x57},{0xE7, 0x59},{0xE8, 0x5B},{0xE9, 0x5B},{0xEA, 0x5D},{0xEB, 0x5F},{0xEC, 0x61},{0xED, 0x63},{0xEE, 0x64},{0xEF, 0x66},
        {0xF0, 0x67},{0xF1, 0x6A},{0xF2, 0x6C},{0xF3, 0x6D},{0xF4, 0x6E},{0xF5, 0x70},{0xF6, 0x71},{0xF7, 0x73},{0xF8, 0x75},{0xF9, 0x76},
        {0xFA, 0x79},{0xFB, 0x7B},{0xFC, 0x7C},{0xFD, 0x7E},{0xFE, 0x7F},{0xFF, 0x81},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x47},{0xC1, 0x47},{0xC2, 0x48},{0xC3, 0x48},{0xC4, 0x49},{0xC5, 0x49},{0xC6, 0x4A},{0xC7, 0x4B},
        {0xC8, 0x4C},{0xC9, 0x4D},{0xCA, 0x4D},{0xCB, 0x4F},{0xCC, 0x50},{0xCD, 0x52},{0xCE, 0x52},{0xCF, 0x54},{0xD0, 0x55},{0xD1, 0x56},
        {0xD2, 0x57},{0xD3, 0x59},{0xD4, 0x5B},{0xD5, 0x5D},{0xD6, 0x5E},{0xD7, 0x60},{0xD8, 0x62},{0xD9, 0x63},{0xDA, 0x65},{0xDB, 0x67},
        {0xDC, 0x69},{0xDD, 0x6B},{0xDE, 0x6D},{0xDF, 0x6F},{0xE0, 0x72},{0xE1, 0x74},{0xE2, 0x77},{0xE3, 0x79},{0xE4, 0x7B},{0xE5, 0x7D},
        {0xE6, 0x80},{0xE7, 0x82},{0xE8, 0x83},{0xE9, 0x86},{0xEA, 0x87},{0xEB, 0x89},{0xEC, 0x8C},{0xED, 0x8E},{0xEE, 0x90},{0xEF, 0x93},
        {0xF0, 0x95},{0xF1, 0x97},{0xF2, 0x9A},{0xF3, 0x9C},{0xF4, 0x9F},{0xF5, 0xA1},{0xF6, 0xA4},{0xF7, 0xA5},{0xF8, 0xA8},{0xF9, 0xAA},
        {0xFA, 0xAD},{0xFB, 0xAF},{0xFC, 0xB2},{0xFD, 0xB5},{0xFE, 0xB8},{0xFF, 0xBA},{0x93, 0x0D},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4D},
        {0xC3, 0x4D},{0xC4, 0x4E},{0xC5, 0x4F},{0xC6, 0x50},{0xC7, 0x51},{0xC8, 0x52},{0xC9, 0x53},{0xCA, 0x55},{0xCB, 0x55},{0xCC, 0x57},
        {0xCD, 0x58},{0xCE, 0x5A},{0xCF, 0x5D},{0xD0, 0x5E},{0xD1, 0x60},{0xD2, 0x62},{0xD3, 0x64},{0xD4, 0x66},{0xD5, 0x69},{0xD6, 0x6B},
        {0xD7, 0x6E},{0xD8, 0x70},{0xD9, 0x73},{0xDA, 0x76},{0xDB, 0x78},{0xDC, 0x7B},{0xDD, 0x7E},{0xDE, 0x81},{0xDF, 0x83},{0xE0, 0x86},
        {0xE1, 0x88},{0xE2, 0x8B},{0xE3, 0x8D},{0xE4, 0x90},{0xE5, 0x92},{0xE6, 0x95},{0xE7, 0x98},{0xE8, 0x9B},{0xE9, 0x9E},{0xEA, 0xA1},
        {0xEB, 0xA4},{0xEC, 0xA6},{0xED, 0xA9},{0xEE, 0xAC},{0xEF, 0xB0},{0xF0, 0xB3},{0xF1, 0xB7},{0xF2, 0xBA},{0xF3, 0xBD},{0xF4, 0xC0},
        {0xF5, 0xC3},{0xF6, 0xC6},{0xF7, 0xC9},{0xF8, 0xCB},{0xF9, 0xCE},{0xFA, 0xD1},{0xFB, 0xD5},{0xFC, 0xD8},{0xFD, 0xDC},{0xFE, 0xDF},
        {0xFF, 0xE2},{0x93, 0x0E},{0xC0, 0x29},{0xC1, 0x29},{0xC2, 0x29},{0xC3, 0x29},{0xC4, 0x2A},{0xC5, 0x2A},{0xC6, 0x2B},{0xC7, 0x2C},
        {0xC8, 0x2D},{0xC9, 0x2E},{0xCA, 0x2F},{0xCB, 0x30},{0xCC, 0x31},{0xCD, 0x32},{0xCE, 0x33},{0xCF, 0x34},{0xD0, 0x35},{0xD1, 0x36},
        {0xD2, 0x38},{0xD3, 0x39},{0xD4, 0x3A},{0xD5, 0x3C},{0xD6, 0x3D},{0xD7, 0x3E},{0xD8, 0x3F},{0xD9, 0x41},{0xDA, 0x41},{0xDB, 0x43},
        {0xDC, 0x44},{0xDD, 0x46},{0xDE, 0x47},{0xDF, 0x49},{0xE0, 0x4B},{0xE1, 0x4C},{0xE2, 0x4D},{0xE3, 0x4F},{0xE4, 0x50},{0xE5, 0x52},
        {0xE6, 0x52},{0xE7, 0x54},{0xE8, 0x55},{0xE9, 0x56},{0xEA, 0x57},{0xEB, 0x59},{0xEC, 0x5A},{0xED, 0x5C},{0xEE, 0x5D},{0xEF, 0x5F},
        {0xF0, 0x60},{0xF1, 0x62},{0xF2, 0x63},{0xF3, 0x64},{0xF4, 0x66},{0xF5, 0x68},{0xF6, 0x69},{0xF7, 0x6B},{0xF8, 0x6D},{0xF9, 0x6E},
        {0xFA, 0x70},{0xFB, 0x72},{0xFC, 0x73},{0xFD, 0x75},{0xFE, 0x77},{0xFF, 0x79},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x3F},{0xC1, 0x3F},{0xC2, 0x40},{0xC3, 0x40},{0xC4, 0x41},{0xC5, 0x41},{0xC6, 0x42},{0xC7, 0x43},
        {0xC8, 0x43},{0xC9, 0x44},{0xCA, 0x45},{0xCB, 0x47},{0xCC, 0x48},{0xCD, 0x49},{0xCE, 0x4A},{0xCF, 0x4B},{0xD0, 0x4D},{0xD1, 0x4D},
        {0xD2, 0x4F},{0xD3, 0x50},{0xD4, 0x52},{0xD5, 0x54},{0xD6, 0x55},{0xD7, 0x57},{0xD8, 0x58},{0xD9, 0x59},{0xDA, 0x5B},{0xDB, 0x5C},
        {0xDC, 0x5E},{0xDD, 0x5F},{0xDE, 0x61},{0xDF, 0x63},{0xE0, 0x65},{0xE1, 0x67},{0xE2, 0x69},{0xE3, 0x6B},{0xE4, 0x6D},{0xE5, 0x6F},
        {0xE6, 0x72},{0xE7, 0x74},{0xE8, 0x75},{0xE9, 0x78},{0xEA, 0x7A},{0xEB, 0x7C},{0xEC, 0x7E},{0xED, 0x7F},{0xEE, 0x82},{0xEF, 0x84},
        {0xF0, 0x86},{0xF1, 0x88},{0xF2, 0x8B},{0xF3, 0x8C},{0xF4, 0x8F},{0xF5, 0x90},{0xF6, 0x93},{0xF7, 0x95},{0xF8, 0x98},{0xF9, 0x9A},
        {0xFA, 0x9C},{0xFB, 0x9E},{0xFC, 0xA1},{0xFD, 0xA4},{0xFE, 0xA7},{0xFF, 0xA8},{0x93, 0x11},{0xC0, 0x44},{0xC1, 0x44},{0xC2, 0x44},
        {0xC3, 0x45},{0xC4, 0x46},{0xC5, 0x47},{0xC6, 0x48},{0xC7, 0x48},{0xC8, 0x49},{0xC9, 0x4B},{0xCA, 0x4C},{0xCB, 0x4D},{0xCC, 0x4E},
        {0xCD, 0x4F},{0xCE, 0x51},{0xCF, 0x54},{0xD0, 0x55},{0xD1, 0x57},{0xD2, 0x58},{0xD3, 0x5A},{0xD4, 0x5B},{0xD5, 0x5E},{0xD6, 0x5F},
        {0xD7, 0x62},{0xD8, 0x63},{0xD9, 0x66},{0xDA, 0x68},{0xDB, 0x6A},{0xDC, 0x6D},{0xDD, 0x70},{0xDE, 0x73},{0xDF, 0x74},{0xE0, 0x78},
        {0xE1, 0x7B},{0xE2, 0x7D},{0xE3, 0x7F},{0xE4, 0x81},{0xE5, 0x83},{0xE6, 0x86},{0xE7, 0x89},{0xE8, 0x8B},{0xE9, 0x8E},{0xEA, 0x90},
        {0xEB, 0x93},{0xEC, 0x96},{0xED, 0x99},{0xEE, 0x9B},{0xEF, 0x9F},{0xF0, 0xA3},{0xF1, 0xA6},{0xF2, 0xA8},{0xF3, 0xAB},{0xF4, 0xAE},
        {0xF5, 0xB2},{0xF6, 0xB6},{0xF7, 0xBA},{0xF8, 0xBD},{0xF9, 0xC0},{0xFA, 0xC3},{0xFB, 0xC6},{0xFC, 0xC8},{0xFD, 0xCC},{0xFE, 0xCF},
        {0xFF, 0xD3},{0x93, 0x12},{0xC0, 0x25},{0xC1, 0x25},{0xC2, 0x25},{0xC3, 0x25},{0xC4, 0x26},{0xC5, 0x26},{0xC6, 0x27},{0xC7, 0x28},
        {0xC8, 0x29},{0xC9, 0x2A},{0xCA, 0x2B},{0xCB, 0x2C},{0xCC, 0x2D},{0xCD, 0x2D},{0xCE, 0x2E},{0xCF, 0x30},{0xD0, 0x30},{0xD1, 0x31},
        {0xD2, 0x33},{0xD3, 0x34},{0xD4, 0x35},{0xD5, 0x37},{0xD6, 0x38},{0xD7, 0x39},{0xD8, 0x3A},{0xD9, 0x3B},{0xDA, 0x3C},{0xDB, 0x3D},
        {0xDC, 0x3D},{0xDD, 0x3F},{0xDE, 0x3F},{0xDF, 0x41},{0xE0, 0x43},{0xE1, 0x43},{0xE2, 0x45},{0xE3, 0x47},{0xE4, 0x48},{0xE5, 0x49},
        {0xE6, 0x4A},{0xE7, 0x4B},{0xE8, 0x4D},{0xE9, 0x4D},{0xEA, 0x4F},{0xEB, 0x50},{0xEC, 0x51},{0xED, 0x53},{0xEE, 0x54},{0xEF, 0x56},
        {0xF0, 0x57},{0xF1, 0x58},{0xF2, 0x59},{0xF3, 0x5A},{0xF4, 0x5B},{0xF5, 0x5D},{0xF6, 0x5E},{0xF7, 0x5F},{0xF8, 0x61},{0xF9, 0x62},
        {0xFA, 0x63},{0xFB, 0x65},{0xFC, 0x66},{0xFD, 0x68},{0xFE, 0x69},{0xFF, 0x6B},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [1] Strong -5
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x50},{0xC1, 0x50},{0xC2, 0x50},{0xC3, 0x51},{0xC4, 0x51},{0xC5, 0x52},{0xC6, 0x52},{0xC7, 0x52},
        {0xC8, 0x53},{0xC9, 0x54},{0xCA, 0x55},{0xCB, 0x56},{0xCC, 0x58},{0xCD, 0x59},{0xCE, 0x5A},{0xCF, 0x5B},{0xD0, 0x5D},{0xD1, 0x5E},
        {0xD2, 0x61},{0xD3, 0x63},{0xD4, 0x65},{0xD5, 0x65},{0xD6, 0x67},{0xD7, 0x6A},{0xD8, 0x6C},{0xD9, 0x6D},{0xDA, 0x6F},{0xDB, 0x71},
        {0xDC, 0x73},{0xDD, 0x75},{0xDE, 0x77},{0xDF, 0x7B},{0xE0, 0x7D},{0xE1, 0x7F},{0xE2, 0x81},{0xE3, 0x83},{0xE4, 0x85},{0xE5, 0x87},
        {0xE6, 0x89},{0xE7, 0x8B},{0xE8, 0x8F},{0xE9, 0x91},{0xEA, 0x93},{0xEB, 0x95},{0xEC, 0x97},{0xED, 0x99},{0xEE, 0x9B},{0xEF, 0x9E},
        {0xF0, 0xA1},{0xF1, 0xA3},{0xF2, 0xA5},{0xF3, 0xA8},{0xF4, 0xAA},{0xF5, 0xAC},{0xF6, 0xAE},{0xF7, 0xB1},{0xF8, 0xB3},{0xF9, 0xB6},
        {0xFA, 0xB8},{0xFB, 0xBC},{0xFC, 0xBF},{0xFD, 0xC1},{0xFE, 0xC3},{0xFF, 0xC5},{0x93, 0x09},{0xC0, 0x55},{0xC1, 0x55},{0xC2, 0x56},
        {0xC3, 0x56},{0xC4, 0x57},{0xC5, 0x58},{0xC6, 0x59},{0xC7, 0x5A},{0xC8, 0x5B},{0xC9, 0x5B},{0xCA, 0x5D},{0xCB, 0x5E},{0xCC, 0x61},
        {0xCD, 0x63},{0xCE, 0x64},{0xCF, 0x66},{0xD0, 0x68},{0xD1, 0x6B},{0xD2, 0x6D},{0xD3, 0x6E},{0xD4, 0x71},{0xD5, 0x73},{0xD6, 0x76},
        {0xD7, 0x79},{0xD8, 0x7C},{0xD9, 0x7E},{0xDA, 0x80},{0xDB, 0x82},{0xDC, 0x85},{0xDD, 0x87},{0xDE, 0x89},{0xDF, 0x8D},{0xE0, 0x91},
        {0xE1, 0x93},{0xE2, 0x95},{0xE3, 0x97},{0xE4, 0x9A},{0xE5, 0x9D},{0xE6, 0xA0},{0xE7, 0xA3},{0xE8, 0xA6},{0xE9, 0xA9},{0xEA, 0xAC},
        {0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB4},{0xEE, 0xB7},{0xEF, 0xBC},{0xF0, 0xBF},{0xF1, 0xC2},{0xF2, 0xC4},{0xF3, 0xC6},{0xF4, 0xC9},
        {0xF5, 0xCC},{0xF6, 0xCE},{0xF7, 0xD1},{0xF8, 0xD4},{0xF9, 0xD8},{0xFA, 0xDB},{0xFB, 0xDD},{0xFC, 0xE0},{0xFD, 0xE2},{0xFE, 0xE5},
        {0xFF, 0xE8},{0x93, 0x0A},{0xC0, 0x2F},{0xC1, 0x2F},{0xC2, 0x2F},{0xC3, 0x30},{0xC4, 0x30},{0xC5, 0x31},{0xC6, 0x31},{0xC7, 0x32},
        {0xC8, 0x33},{0xC9, 0x34},{0xCA, 0x34},{0xCB, 0x35},{0xCC, 0x37},{0xCD, 0x38},{0xCE, 0x39},{0xCF, 0x3A},{0xD0, 0x3B},{0xD1, 0x3C},
        {0xD2, 0x3D},{0xD3, 0x3E},{0xD4, 0x3F},{0xD5, 0x40},{0xD6, 0x42},{0xD7, 0x43},{0xD8, 0x46},{0xD9, 0x47},{0xDA, 0x49},{0xDB, 0x4A},
        {0xDC, 0x4B},{0xDD, 0x4D},{0xDE, 0x4E},{0xDF, 0x50},{0xE0, 0x52},{0xE1, 0x52},{0xE2, 0x54},{0xE3, 0x56},{0xE4, 0x57},{0xE5, 0x59},
        {0xE6, 0x5B},{0xE7, 0x5B},{0xE8, 0x5D},{0xE9, 0x5F},{0xEA, 0x61},{0xEB, 0x63},{0xEC, 0x65},{0xED, 0x66},{0xEE, 0x67},{0xEF, 0x6A},
        {0xF0, 0x6C},{0xF1, 0x6D},{0xF2, 0x6F},{0xF3, 0x70},{0xF4, 0x72},{0xF5, 0x74},{0xF6, 0x76},{0xF7, 0x77},{0xF8, 0x7A},{0xF9, 0x7C},
        {0xFA, 0x7E},{0xFB, 0x7E},{0xFC, 0x80},{0xFD, 0x82},{0xFE, 0x84},{0xFF, 0x85},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x4C},{0xC1, 0x4C},{0xC2, 0x4C},{0xC3, 0x4D},{0xC4, 0x4D},{0xC5, 0x4D},{0xC6, 0x4D},{0xC7, 0x4E},
        {0xC8, 0x4F},{0xC9, 0x50},{0xCA, 0x51},{0xCB, 0x52},{0xCC, 0x53},{0xCD, 0x54},{0xCE, 0x55},{0xCF, 0x56},{0xD0, 0x57},{0xD1, 0x58},
        {0xD2, 0x5A},{0xD3, 0x5C},{0xD4, 0x5D},{0xD5, 0x5E},{0xD6, 0x60},{0xD7, 0x62},{0xD8, 0x63},{0xD9, 0x65},{0xDA, 0x67},{0xDB, 0x69},
        {0xDC, 0x6B},{0xDD, 0x6D},{0xDE, 0x6F},{0xDF, 0x72},{0xE0, 0x74},{0xE1, 0x77},{0xE2, 0x79},{0xE3, 0x7B},{0xE4, 0x7D},{0xE5, 0x80},
        {0xE6, 0x82},{0xE7, 0x83},{0xE8, 0x86},{0xE9, 0x87},{0xEA, 0x89},{0xEB, 0x8C},{0xEC, 0x8E},{0xED, 0x90},{0xEE, 0x92},{0xEF, 0x95},
        {0xF0, 0x98},{0xF1, 0x9A},{0xF2, 0x9C},{0xF3, 0x9F},{0xF4, 0xA1},{0xF5, 0xA4},{0xF6, 0xA5},{0xF7, 0xA8},{0xF8, 0xAA},{0xF9, 0xAD},
        {0xFA, 0xAF},{0xFB, 0xB2},{0xFC, 0xB6},{0xFD, 0xB8},{0xFE, 0xBB},{0xFF, 0xBD},{0x93, 0x0D},{0xC0, 0x51},{0xC1, 0x51},{0xC2, 0x52},
        {0xC3, 0x52},{0xC4, 0x52},{0xC5, 0x53},{0xC6, 0x54},{0xC7, 0x55},{0xC8, 0x55},{0xC9, 0x56},{0xCA, 0x57},{0xCB, 0x58},{0xCC, 0x5A},
        {0xCD, 0x5C},{0xCE, 0x5D},{0xCF, 0x5F},{0xD0, 0x61},{0xD1, 0x62},{0xD2, 0x64},{0xD3, 0x66},{0xD4, 0x69},{0xD5, 0x6B},{0xD6, 0x6E},
        {0xD7, 0x70},{0xD8, 0x73},{0xD9, 0x75},{0xDA, 0x78},{0xDB, 0x7A},{0xDC, 0x7D},{0xDD, 0x80},{0xDE, 0x82},{0xDF, 0x84},{0xE0, 0x87},
        {0xE1, 0x89},{0xE2, 0x8C},{0xE3, 0x8F},{0xE4, 0x91},{0xE5, 0x94},{0xE6, 0x97},{0xE7, 0x9A},{0xE8, 0x9D},{0xE9, 0xA0},{0xEA, 0xA3},
        {0xEB, 0xA5},{0xEC, 0xA8},{0xED, 0xAB},{0xEE, 0xAE},{0xEF, 0xB2},{0xF0, 0xB6},{0xF1, 0xB9},{0xF2, 0xBC},{0xF3, 0xBF},{0xF4, 0xC2},
        {0xF5, 0xC4},{0xF6, 0xC7},{0xF7, 0xCA},{0xF8, 0xCC},{0xF9, 0xD0},{0xFA, 0xD4},{0xFB, 0xD7},{0xFC, 0xDA},{0xFD, 0xDD},{0xFE, 0xE0},
        {0xFF, 0xE3},{0x93, 0x0E},{0xC0, 0x2C},{0xC1, 0x2C},{0xC2, 0x2C},{0xC3, 0x2D},{0xC4, 0x2D},{0xC5, 0x2E},{0xC6, 0x2E},{0xC7, 0x2F},
        {0xC8, 0x30},{0xC9, 0x31},{0xCA, 0x31},{0xCB, 0x32},{0xCC, 0x34},{0xCD, 0x34},{0xCE, 0x35},{0xCF, 0x36},{0xD0, 0x38},{0xD1, 0x39},
        {0xD2, 0x3A},{0xD3, 0x3C},{0xD4, 0x3D},{0xD5, 0x3E},{0xD6, 0x3F},{0xD7, 0x40},{0xD8, 0x41},{0xD9, 0x42},{0xDA, 0x44},{0xDB, 0x45},
        {0xDC, 0x47},{0xDD, 0x49},{0xDE, 0x4A},{0xDF, 0x4C},{0xE0, 0x4D},{0xE1, 0x4E},{0xE2, 0x50},{0xE3, 0x52},{0xE4, 0x52},{0xE5, 0x54},
        {0xE6, 0x55},{0xE7, 0x56},{0xE8, 0x57},{0xE9, 0x59},{0xEA, 0x5A},{0xEB, 0x5C},{0xEC, 0x5D},{0xED, 0x5F},{0xEE, 0x60},{0xEF, 0x62},
        {0xF0, 0x63},{0xF1, 0x65},{0xF2, 0x67},{0xF3, 0x68},{0xF4, 0x6A},{0xF5, 0x6C},{0xF6, 0x6E},{0xF7, 0x6F},{0xF8, 0x71},{0xF9, 0x73},
        {0xFA, 0x75},{0xFB, 0x76},{0xFC, 0x78},{0xFD, 0x7A},{0xFE, 0x7C},{0xFF, 0x7D},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x43},{0xC1, 0x43},{0xC2, 0x43},{0xC3, 0x44},{0xC4, 0x44},{0xC5, 0x45},{0xC6, 0x45},{0xC7, 0x46},
        {0xC8, 0x47},{0xC9, 0x48},{0xCA, 0x48},{0xCB, 0x49},{0xCC, 0x4B},{0xCD, 0x4B},{0xCE, 0x4C},{0xCF, 0x4D},{0xD0, 0x4F},{0xD1, 0x4F},
        {0xD2, 0x51},{0xD3, 0x53},{0xD4, 0x55},{0xD5, 0x55},{0xD6, 0x57},{0xD7, 0x58},{0xD8, 0x59},{0xD9, 0x5B},{0xDA, 0x5C},{0xDB, 0x5E},
        {0xDC, 0x5F},{0xDD, 0x61},{0xDE, 0x63},{0xDF, 0x65},{0xE0, 0x67},{0xE1, 0x69},{0xE2, 0x6B},{0xE3, 0x6D},{0xE4, 0x6F},{0xE5, 0x72},
        {0xE6, 0x74},{0xE7, 0x75},{0xE8, 0x78},{0xE9, 0x7A},{0xEA, 0x7C},{0xEB, 0x7E},{0xEC, 0x7F},{0xED, 0x82},{0xEE, 0x83},{0xEF, 0x86},
        {0xF0, 0x89},{0xF1, 0x8B},{0xF2, 0x8C},{0xF3, 0x8F},{0xF4, 0x90},{0xF5, 0x93},{0xF6, 0x95},{0xF7, 0x98},{0xF8, 0x9A},{0xF9, 0x9C},
        {0xFA, 0x9E},{0xFB, 0xA1},{0xFC, 0xA5},{0xFD, 0xA7},{0xFE, 0xA9},{0xFF, 0xAB},{0x93, 0x11},{0xC0, 0x48},{0xC1, 0x48},{0xC2, 0x49},
        {0xC3, 0x49},{0xC4, 0x4A},{0xC5, 0x4B},{0xC6, 0x4B},{0xC7, 0x4C},{0xC8, 0x4D},{0xC9, 0x4D},{0xCA, 0x4F},{0xCB, 0x4F},{0xCC, 0x51},
        {0xCD, 0x53},{0xCE, 0x54},{0xCF, 0x56},{0xD0, 0x57},{0xD1, 0x59},{0xD2, 0x5A},{0xD3, 0x5B},{0xD4, 0x5E},{0xD5, 0x5F},{0xD6, 0x62},
        {0xD7, 0x63},{0xD8, 0x66},{0xD9, 0x68},{0xDA, 0x6A},{0xDB, 0x6C},{0xDC, 0x6F},{0xDD, 0x72},{0xDE, 0x74},{0xDF, 0x76},{0xE0, 0x7A},
        {0xE1, 0x7C},{0xE2, 0x7E},{0xE3, 0x80},{0xE4, 0x83},{0xE5, 0x85},{0xE6, 0x88},{0xE7, 0x8B},{0xE8, 0x8D},{0xE9, 0x90},{0xEA, 0x92},
        {0xEB, 0x95},{0xEC, 0x98},{0xED, 0x9A},{0xEE, 0x9D},{0xEF, 0xA1},{0xF0, 0xA5},{0xF1, 0xA8},{0xF2, 0xAA},{0xF3, 0xAD},{0xF4, 0xB0},
        {0xF5, 0xB4},{0xF6, 0xB7},{0xF7, 0xBB},{0xF8, 0xBE},{0xF9, 0xC2},{0xFA, 0xC5},{0xFB, 0xC7},{0xFC, 0xCA},{0xFD, 0xCD},{0xFE, 0xD1},
        {0xFF, 0xD4},{0x93, 0x12},{0xC0, 0x28},{0xC1, 0x28},{0xC2, 0x28},{0xC3, 0x29},{0xC4, 0x29},{0xC5, 0x2A},{0xC6, 0x2A},{0xC7, 0x2B},
        {0xC8, 0x2C},{0xC9, 0x2D},{0xCA, 0x2D},{0xCB, 0x2D},{0xCC, 0x2F},{0xCD, 0x30},{0xCE, 0x30},{0xCF, 0x31},{0xD0, 0x33},{0xD1, 0x34},
        {0xD2, 0x35},{0xD3, 0x37},{0xD4, 0x38},{0xD5, 0x38},{0xD6, 0x3A},{0xD7, 0x3A},{0xD8, 0x3C},{0xD9, 0x3C},{0xDA, 0x3D},{0xDB, 0x3E},
        {0xDC, 0x3F},{0xDD, 0x41},{0xDE, 0x42},{0xDF, 0x43},{0xE0, 0x45},{0xE1, 0x46},{0xE2, 0x48},{0xE3, 0x49},{0xE4, 0x4A},{0xE5, 0x4B},
        {0xE6, 0x4D},{0xE7, 0x4D},{0xE8, 0x4F},{0xE9, 0x50},{0xEA, 0x51},{0xEB, 0x53},{0xEC, 0x55},{0xED, 0x56},{0xEE, 0x57},{0xEF, 0x58},
        {0xF0, 0x59},{0xF1, 0x5B},{0xF2, 0x5C},{0xF3, 0x5D},{0xF4, 0x5E},{0xF5, 0x60},{0xF6, 0x62},{0xF7, 0x63},{0xF8, 0x64},{0xF9, 0x66},
        {0xFA, 0x68},{0xFB, 0x68},{0xFC, 0x6A},{0xFD, 0x6C},{0xFE, 0x6E},{0xFF, 0x6F},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [2] Strong -4
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x54},{0xC1, 0x54},{0xC2, 0x54},{0xC3, 0x54},{0xC4, 0x54},{0xC5, 0x55},{0xC6, 0x56},{0xC7, 0x56},
        {0xC8, 0x57},{0xC9, 0x58},{0xCA, 0x59},{0xCB, 0x5A},{0xCC, 0x5B},{0xCD, 0x5B},{0xCE, 0x5D},{0xCF, 0x5E},{0xD0, 0x61},{0xD1, 0x62},
        {0xD2, 0x64},{0xD3, 0x65},{0xD4, 0x66},{0xD5, 0x68},{0xD6, 0x6B},{0xD7, 0x6D},{0xD8, 0x6E},{0xD9, 0x6F},{0xDA, 0x71},{0xDB, 0x73},
        {0xDC, 0x76},{0xDD, 0x79},{0xDE, 0x7B},{0xDF, 0x7D},{0xE0, 0x7F},{0xE1, 0x81},{0xE2, 0x83},{0xE3, 0x85},{0xE4, 0x87},{0xE5, 0x89},
        {0xE6, 0x8B},{0xE7, 0x8F},{0xE8, 0x91},{0xE9, 0x93},{0xEA, 0x95},{0xEB, 0x97},{0xEC, 0x98},{0xED, 0x9B},{0xEE, 0x9D},{0xEF, 0xA0},
        {0xF0, 0xA3},{0xF1, 0xA5},{0xF2, 0xA8},{0xF3, 0xAA},{0xF4, 0xAC},{0xF5, 0xAE},{0xF6, 0xB1},{0xF7, 0xB3},{0xF8, 0xB6},{0xF9, 0xB9},
        {0xFA, 0xBC},{0xFB, 0xBF},{0xFC, 0xC1},{0xFD, 0xC3},{0xFE, 0xC5},{0xFF, 0xC7},{0x93, 0x09},{0xC0, 0x5B},{0xC1, 0x5B},{0xC2, 0x5B},
        {0xC3, 0x5B},{0xC4, 0x5B},{0xC5, 0x5B},{0xC6, 0x5C},{0xC7, 0x5D},{0xC8, 0x5E},{0xC9, 0x5F},{0xCA, 0x62},{0xCB, 0x63},{0xCC, 0x64},
        {0xCD, 0x65},{0xCE, 0x67},{0xCF, 0x6A},{0xD0, 0x6C},{0xD1, 0x6D},{0xD2, 0x6F},{0xD3, 0x71},{0xD4, 0x73},{0xD5, 0x75},{0xD6, 0x79},
        {0xD7, 0x7B},{0xD8, 0x7E},{0xD9, 0x7F},{0xDA, 0x82},{0xDB, 0x84},{0xDC, 0x87},{0xDD, 0x88},{0xDE, 0x8B},{0xDF, 0x8F},{0xE0, 0x92},
        {0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x99},{0xE4, 0x9B},{0xE5, 0x9E},{0xE6, 0xA1},{0xE7, 0xA4},{0xE8, 0xA7},{0xE9, 0xAA},{0xEA, 0xAC},
        {0xEB, 0xAF},{0xEC, 0xB2},{0xED, 0xB5},{0xEE, 0xB8},{0xEF, 0xBD},{0xF0, 0xC0},{0xF1, 0xC3},{0xF2, 0xC5},{0xF3, 0xC7},{0xF4, 0xCA},
        {0xF5, 0xCD},{0xF6, 0xCF},{0xF7, 0xD3},{0xF8, 0xD6},{0xF9, 0xD9},{0xFA, 0xDC},{0xFB, 0xDE},{0xFC, 0xE1},{0xFD, 0xE3},{0xFE, 0xE7},
        {0xFF, 0xE9},{0x93, 0x0A},{0xC0, 0x33},{0xC1, 0x33},{0xC2, 0x33},{0xC3, 0x33},{0xC4, 0x33},{0xC5, 0x34},{0xC6, 0x34},{0xC7, 0x35},
        {0xC8, 0x36},{0xC9, 0x36},{0xCA, 0x37},{0xCB, 0x38},{0xCC, 0x39},{0xCD, 0x3A},{0xCE, 0x3A},{0xCF, 0x3C},{0xD0, 0x3D},{0xD1, 0x3E},
        {0xD2, 0x3F},{0xD3, 0x40},{0xD4, 0x42},{0xD5, 0x43},{0xD6, 0x45},{0xD7, 0x47},{0xD8, 0x48},{0xD9, 0x4A},{0xDA, 0x4A},{0xDB, 0x4C},
        {0xDC, 0x4E},{0xDD, 0x4F},{0xDE, 0x51},{0xDF, 0x52},{0xE0, 0x54},{0xE1, 0x55},{0xE2, 0x57},{0xE3, 0x59},{0xE4, 0x5A},{0xE5, 0x5B},
        {0xE6, 0x5D},{0xE7, 0x5E},{0xE8, 0x61},{0xE9, 0x63},{0xEA, 0x65},{0xEB, 0x65},{0xEC, 0x67},{0xED, 0x6A},{0xEE, 0x6C},{0xEF, 0x6D},
        {0xF0, 0x6F},{0xF1, 0x71},{0xF2, 0x72},{0xF3, 0x74},{0xF4, 0x76},{0xF5, 0x79},{0xF6, 0x7B},{0xF7, 0x7C},{0xF8, 0x7E},{0xF9, 0x7F},
        {0xFA, 0x81},{0xFB, 0x83},{0xFC, 0x84},{0xFD, 0x86},{0xFE, 0x87},{0xFF, 0x89},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x50},{0xC1, 0x50},{0xC2, 0x50},{0xC3, 0x50},{0xC4, 0x50},{0xC5, 0x51},{0xC6, 0x52},{0xC7, 0x52},
        {0xC8, 0x52},{0xC9, 0x53},{0xCA, 0x54},{0xCB, 0x55},{0xCC, 0x55},{0xCD, 0x56},{0xCE, 0x57},{0xCF, 0x58},{0xD0, 0x5A},{0xD1, 0x5B},
        {0xD2, 0x5D},{0xD3, 0x5E},{0xD4, 0x5F},{0xD5, 0x61},{0xD6, 0x62},{0xD7, 0x64},{0xD8, 0x66},{0xD9, 0x67},{0xDA, 0x69},{0xDB, 0x6B},
        {0xDC, 0x6E},{0xDD, 0x70},{0xDE, 0x72},{0xDF, 0x74},{0xE0, 0x77},{0xE1, 0x79},{0xE2, 0x7B},{0xE3, 0x7D},{0xE4, 0x80},{0xE5, 0x82},
        {0xE6, 0x83},{0xE7, 0x86},{0xE8, 0x87},{0xE9, 0x89},{0xEA, 0x8C},{0xEB, 0x8E},{0xEC, 0x90},{0xED, 0x92},{0xEE, 0x94},{0xEF, 0x97},
        {0xF0, 0x9A},{0xF1, 0x9C},{0xF2, 0x9F},{0xF3, 0xA1},{0xF4, 0xA4},{0xF5, 0xA5},{0xF6, 0xA8},{0xF7, 0xAA},{0xF8, 0xAD},{0xF9, 0xB0},
        {0xFA, 0xB2},{0xFB, 0xB6},{0xFC, 0xB8},{0xFD, 0xBB},{0xFE, 0xBD},{0xFF, 0xC0},{0x93, 0x0D},{0xC0, 0x55},{0xC1, 0x55},{0xC2, 0x55},
        {0xC3, 0x55},{0xC4, 0x56},{0xC5, 0x56},{0xC6, 0x57},{0xC7, 0x57},{0xC8, 0x58},{0xC9, 0x59},{0xCA, 0x5B},{0xCB, 0x5C},{0xCC, 0x5D},
        {0xCD, 0x5E},{0xCE, 0x60},{0xCF, 0x62},{0xD0, 0x63},{0xD1, 0x65},{0xD2, 0x67},{0xD3, 0x69},{0xD4, 0x6B},{0xD5, 0x6D},{0xD6, 0x70},
        {0xD7, 0x72},{0xD8, 0x75},{0xD9, 0x77},{0xDA, 0x7A},{0xDB, 0x7C},{0xDC, 0x7F},{0xDD, 0x81},{0xDE, 0x83},{0xDF, 0x86},{0xE0, 0x88},
        {0xE1, 0x8B},{0xE2, 0x8E},{0xE3, 0x90},{0xE4, 0x92},{0xE5, 0x95},{0xE6, 0x98},{0xE7, 0x9B},{0xE8, 0x9E},{0xE9, 0xA1},{0xEA, 0xA4},
        {0xEB, 0xA6},{0xEC, 0xA9},{0xED, 0xAC},{0xEE, 0xAF},{0xEF, 0xB3},{0xF0, 0xB7},{0xF1, 0xBA},{0xF2, 0xBD},{0xF3, 0xC0},{0xF4, 0xC3},
        {0xF5, 0xC5},{0xF6, 0xC8},{0xF7, 0xCB},{0xF8, 0xCE},{0xF9, 0xD1},{0xFA, 0xD5},{0xFB, 0xD8},{0xFC, 0xDB},{0xFD, 0xDE},{0xFE, 0xE2},
        {0xFF, 0xE5},{0x93, 0x0E},{0xC0, 0x30},{0xC1, 0x30},{0xC2, 0x30},{0xC3, 0x30},{0xC4, 0x30},{0xC5, 0x31},{0xC6, 0x31},{0xC7, 0x32},
        {0xC8, 0x33},{0xC9, 0x33},{0xCA, 0x34},{0xCB, 0x34},{0xCC, 0x35},{0xCD, 0x36},{0xCE, 0x37},{0xCF, 0x39},{0xD0, 0x3A},{0xD1, 0x3B},
        {0xD2, 0x3D},{0xD3, 0x3E},{0xD4, 0x3F},{0xD5, 0x40},{0xD6, 0x41},{0xD7, 0x42},{0xD8, 0x43},{0xD9, 0x45},{0xDA, 0x46},{0xDB, 0x48},
        {0xDC, 0x4A},{0xDD, 0x4B},{0xDE, 0x4D},{0xDF, 0x4D},{0xE0, 0x50},{0xE1, 0x51},{0xE2, 0x52},{0xE3, 0x54},{0xE4, 0x55},{0xE5, 0x56},
        {0xE6, 0x57},{0xE7, 0x58},{0xE8, 0x5A},{0xE9, 0x5C},{0xEA, 0x5D},{0xEB, 0x5E},{0xEC, 0x60},{0xED, 0x62},{0xEE, 0x63},{0xEF, 0x65},
        {0xF0, 0x67},{0xF1, 0x69},{0xF2, 0x6A},{0xF3, 0x6C},{0xF4, 0x6E},{0xF5, 0x70},{0xF6, 0x72},{0xF7, 0x73},{0xF8, 0x75},{0xF9, 0x77},
        {0xFA, 0x79},{0xFB, 0x7B},{0xFC, 0x7C},{0xFD, 0x7E},{0xFE, 0x80},{0xFF, 0x82},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x48},{0xC1, 0x48},{0xC2, 0x48},{0xC3, 0x48},{0xC4, 0x48},{0xC5, 0x48},{0xC6, 0x49},{0xC7, 0x49},
        {0xC8, 0x4A},{0xC9, 0x4B},{0xCA, 0x4B},{0xCB, 0x4C},{0xCC, 0x4D},{0xCD, 0x4D},{0xCE, 0x4F},{0xCF, 0x4F},{0xD0, 0x51},{0xD1, 0x52},
        {0xD2, 0x54},{0xD3, 0x55},{0xD4, 0x56},{0xD5, 0x57},{0xD6, 0x59},{0xD7, 0x5A},{0xD8, 0x5B},{0xD9, 0x5C},{0xDA, 0x5E},{0xDB, 0x5F},
        {0xDC, 0x62},{0xDD, 0x63},{0xDE, 0x65},{0xDF, 0x67},{0xE0, 0x69},{0xE1, 0x6B},{0xE2, 0x6D},{0xE3, 0x6F},{0xE4, 0x72},{0xE5, 0x74},
        {0xE6, 0x75},{0xE7, 0x78},{0xE8, 0x7A},{0xE9, 0x7C},{0xEA, 0x7E},{0xEB, 0x7F},{0xEC, 0x81},{0xED, 0x83},{0xEE, 0x85},{0xEF, 0x88},
        {0xF0, 0x8B},{0xF1, 0x8C},{0xF2, 0x8F},{0xF3, 0x90},{0xF4, 0x93},{0xF5, 0x95},{0xF6, 0x98},{0xF7, 0x9A},{0xF8, 0x9C},{0xF9, 0x9F},
        {0xFA, 0xA1},{0xFB, 0xA5},{0xFC, 0xA7},{0xFD, 0xA9},{0xFE, 0xAB},{0xFF, 0xAE},{0x93, 0x11},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4D},
        {0xC3, 0x4D},{0xC4, 0x4D},{0xC5, 0x4D},{0xC6, 0x4E},{0xC7, 0x4F},{0xC8, 0x4F},{0xC9, 0x50},{0xCA, 0x52},{0xCB, 0x53},{0xCC, 0x54},
        {0xCD, 0x55},{0xCE, 0x57},{0xCF, 0x58},{0xD0, 0x59},{0xD1, 0x5B},{0xD2, 0x5C},{0xD3, 0x5E},{0xD4, 0x5F},{0xD5, 0x61},{0xD6, 0x63},
        {0xD7, 0x65},{0xD8, 0x68},{0xD9, 0x69},{0xDA, 0x6C},{0xDB, 0x6E},{0xDC, 0x71},{0xDD, 0x73},{0xDE, 0x75},{0xDF, 0x78},{0xE0, 0x7B},
        {0xE1, 0x7D},{0xE2, 0x7F},{0xE3, 0x82},{0xE4, 0x83},{0xE5, 0x86},{0xE6, 0x89},{0xE7, 0x8B},{0xE8, 0x8E},{0xE9, 0x90},{0xEA, 0x93},
        {0xEB, 0x96},{0xEC, 0x99},{0xED, 0x9B},{0xEE, 0x9E},{0xEF, 0xA3},{0xF0, 0xA6},{0xF1, 0xA8},{0xF2, 0xAB},{0xF3, 0xAE},{0xF4, 0xB1},
        {0xF5, 0xB5},{0xF6, 0xB8},{0xF7, 0xBD},{0xF8, 0xC0},{0xF9, 0xC3},{0xFA, 0xC6},{0xFB, 0xC8},{0xFC, 0xCB},{0xFD, 0xCE},{0xFE, 0xD3},
        {0xFF, 0xD7},{0x93, 0x12},{0xC0, 0x2C},{0xC1, 0x2C},{0xC2, 0x2C},{0xC3, 0x2C},{0xC4, 0x2C},{0xC5, 0x2D},{0xC6, 0x2D},{0xC7, 0x2D},
        {0xC8, 0x2E},{0xC9, 0x2E},{0xCA, 0x2F},{0xCB, 0x30},{0xCC, 0x30},{0xCD, 0x31},{0xCE, 0x32},{0xCF, 0x34},{0xD0, 0x35},{0xD1, 0x36},
        {0xD2, 0x38},{0xD3, 0x38},{0xD4, 0x3A},{0xD5, 0x3A},{0xD6, 0x3B},{0xD7, 0x3C},{0xD8, 0x3D},{0xD9, 0x3E},{0xDA, 0x3F},{0xDB, 0x40},
        {0xDC, 0x42},{0xDD, 0x43},{0xDE, 0x44},{0xDF, 0x45},{0xE0, 0x48},{0xE1, 0x48},{0xE2, 0x4A},{0xE3, 0x4B},{0xE4, 0x4C},{0xE5, 0x4D},
        {0xE6, 0x4F},{0xE7, 0x4F},{0xE8, 0x51},{0xE9, 0x53},{0xEA, 0x55},{0xEB, 0x55},{0xEC, 0x57},{0xED, 0x58},{0xEE, 0x59},{0xEF, 0x5B},
        {0xF0, 0x5C},{0xF1, 0x5E},{0xF2, 0x5E},{0xF3, 0x60},{0xF4, 0x62},{0xF5, 0x63},{0xF6, 0x65},{0xF7, 0x66},{0xF8, 0x68},{0xF9, 0x69},
        {0xFA, 0x6B},{0xFB, 0x6D},{0xFC, 0x6E},{0xFD, 0x70},{0xFE, 0x72},{0xFF, 0x74},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [3] Strong -3
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x58},{0xC1, 0x58},{0xC2, 0x58},{0xC3, 0x58},{0xC4, 0x59},{0xC5, 0x59},{0xC6, 0x5A},{0xC7, 0x5A},
        {0xC8, 0x5B},{0xC9, 0x5B},{0xCA, 0x5C},{0xCB, 0x5C},{0xCC, 0x5D},{0xCD, 0x5F},{0xCE, 0x61},{0xCF, 0x62},{0xD0, 0x64},{0xD1, 0x65},
        {0xD2, 0x66},{0xD3, 0x67},{0xD4, 0x6A},{0xD5, 0x6C},{0xD6, 0x6D},{0xD7, 0x6E},{0xD8, 0x70},{0xD9, 0x72},{0xDA, 0x74},{0xDB, 0x76},
        {0xDC, 0x79},{0xDD, 0x7B},{0xDE, 0x7D},{0xDF, 0x7E},{0xE0, 0x81},{0xE1, 0x83},{0xE2, 0x85},{0xE3, 0x87},{0xE4, 0x89},{0xE5, 0x8B},
        {0xE6, 0x8E},{0xE7, 0x91},{0xE8, 0x93},{0xE9, 0x95},{0xEA, 0x97},{0xEB, 0x98},{0xEC, 0x9B},{0xED, 0x9D},{0xEE, 0x9F},{0xEF, 0xA3},
        {0xF0, 0xA5},{0xF1, 0xA8},{0xF2, 0xAA},{0xF3, 0xAC},{0xF4, 0xAE},{0xF5, 0xB1},{0xF6, 0xB3},{0xF7, 0xB6},{0xF8, 0xB8},{0xF9, 0xBC},
        {0xFA, 0xBF},{0xFB, 0xC1},{0xFC, 0xC3},{0xFD, 0xC5},{0xFE, 0xC7},{0xFF, 0xCA},{0x93, 0x09},{0xC0, 0x5E},{0xC1, 0x5F},{0xC2, 0x5F},
        {0xC3, 0x5F},{0xC4, 0x5F},{0xC5, 0x61},{0xC6, 0x62},{0xC7, 0x62},{0xC8, 0x63},{0xC9, 0x64},{0xCA, 0x65},{0xCB, 0x66},{0xCC, 0x67},
        {0xCD, 0x68},{0xCE, 0x6B},{0xCF, 0x6D},{0xD0, 0x6E},{0xD1, 0x70},{0xD2, 0x72},{0xD3, 0x74},{0xD4, 0x76},{0xD5, 0x79},{0xD6, 0x7B},
        {0xD7, 0x7D},{0xD8, 0x7F},{0xD9, 0x81},{0xDA, 0x83},{0xDB, 0x86},{0xDC, 0x87},{0xDD, 0x8A},{0xDE, 0x8E},{0xDF, 0x90},{0xE0, 0x94},
        {0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x9A},{0xE4, 0x9D},{0xE5, 0xA0},{0xE6, 0xA2},{0xE7, 0xA5},{0xE8, 0xA8},{0xE9, 0xAB},{0xEA, 0xAD},
        {0xEB, 0xB0},{0xEC, 0xB3},{0xED, 0xB6},{0xEE, 0xB9},{0xEF, 0xBE},{0xF0, 0xC1},{0xF1, 0xC3},{0xF2, 0xC6},{0xF3, 0xC8},{0xF4, 0xCB},
        {0xF5, 0xCE},{0xF6, 0xD1},{0xF7, 0xD4},{0xF8, 0xD7},{0xF9, 0xDA},{0xFA, 0xDD},{0xFB, 0xDF},{0xFC, 0xE2},{0xFD, 0xE5},{0xFE, 0xE8},
        {0xFF, 0xEA},{0x93, 0x0A},{0xC0, 0x36},{0xC1, 0x36},{0xC2, 0x36},{0xC3, 0x36},{0xC4, 0x37},{0xC5, 0x37},{0xC6, 0x38},{0xC7, 0x38},
        {0xC8, 0x39},{0xC9, 0x39},{0xCA, 0x3A},{0xCB, 0x3A},{0xCC, 0x3B},{0xCD, 0x3C},{0xCE, 0x3D},{0xCF, 0x3E},{0xD0, 0x3F},{0xD1, 0x40},
        {0xD2, 0x41},{0xD3, 0x43},{0xD4, 0x45},{0xD5, 0x46},{0xD6, 0x48},{0xD7, 0x49},{0xD8, 0x4A},{0xD9, 0x4B},{0xDA, 0x4D},{0xDB, 0x4F},
        {0xDC, 0x50},{0xDD, 0x52},{0xDE, 0x52},{0xDF, 0x54},{0xE0, 0x56},{0xE1, 0x58},{0xE2, 0x5A},{0xE3, 0x5B},{0xE4, 0x5C},{0xE5, 0x5E},
        {0xE6, 0x61},{0xE7, 0x62},{0xE8, 0x64},{0xE9, 0x65},{0xEA, 0x67},{0xEB, 0x6A},{0xEC, 0x6B},{0xED, 0x6D},{0xEE, 0x6E},{0xEF, 0x70},
        {0xF0, 0x72},{0xF1, 0x74},{0xF2, 0x76},{0xF3, 0x79},{0xF4, 0x7B},{0xF5, 0x7C},{0xF6, 0x7E},{0xF7, 0x7F},{0xF8, 0x81},{0xF9, 0x83},
        {0xFA, 0x85},{0xFB, 0x87},{0xFC, 0x88},{0xFD, 0x89},{0xFE, 0x8B},{0xFF, 0x8E},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x53},{0xC1, 0x53},{0xC2, 0x53},{0xC3, 0x53},{0xC4, 0x54},{0xC5, 0x54},{0xC6, 0x55},{0xC7, 0x55},
        {0xC8, 0x55},{0xC9, 0x56},{0xCA, 0x57},{0xCB, 0x57},{0xCC, 0x57},{0xCD, 0x59},{0xCE, 0x5A},{0xCF, 0x5B},{0xD0, 0x5D},{0xD1, 0x5D},
        {0xD2, 0x5F},{0xD3, 0x60},{0xD4, 0x62},{0xD5, 0x63},{0xD6, 0x64},{0xD7, 0x66},{0xD8, 0x68},{0xD9, 0x6A},{0xDA, 0x6C},{0xDB, 0x6E},
        {0xDC, 0x70},{0xDD, 0x72},{0xDE, 0x74},{0xDF, 0x76},{0xE0, 0x79},{0xE1, 0x7B},{0xE2, 0x7D},{0xE3, 0x7F},{0xE4, 0x82},{0xE5, 0x83},
        {0xE6, 0x85},{0xE7, 0x87},{0xE8, 0x89},{0xE9, 0x8B},{0xEA, 0x8E},{0xEB, 0x90},{0xEC, 0x92},{0xED, 0x94},{0xEE, 0x96},{0xEF, 0x9A},
        {0xF0, 0x9C},{0xF1, 0x9F},{0xF2, 0xA1},{0xF3, 0xA4},{0xF4, 0xA5},{0xF5, 0xA8},{0xF6, 0xAA},{0xF7, 0xAD},{0xF8, 0xAF},{0xF9, 0xB2},
        {0xFA, 0xB6},{0xFB, 0xB8},{0xFC, 0xBB},{0xFD, 0xBD},{0xFE, 0xC0},{0xFF, 0xC3},{0x93, 0x0D},{0xC0, 0x58},{0xC1, 0x59},{0xC2, 0x59},
        {0xC3, 0x59},{0xC4, 0x59},{0xC5, 0x5A},{0xC6, 0x5B},{0xC7, 0x5B},{0xC8, 0x5C},{0xC9, 0x5D},{0xCA, 0x5D},{0xCB, 0x5F},{0xCC, 0x60},
        {0xCD, 0x61},{0xCE, 0x62},{0xCF, 0x64},{0xD0, 0x66},{0xD1, 0x68},{0xD2, 0x6A},{0xD3, 0x6C},{0xD4, 0x6E},{0xD5, 0x70},{0xD6, 0x72},
        {0xD7, 0x74},{0xD8, 0x77},{0xD9, 0x79},{0xDA, 0x7B},{0xDB, 0x7E},{0xDC, 0x80},{0xDD, 0x83},{0xDE, 0x85},{0xDF, 0x87},{0xE0, 0x8A},
        {0xE1, 0x8C},{0xE2, 0x8F},{0xE3, 0x91},{0xE4, 0x94},{0xE5, 0x97},{0xE6, 0x99},{0xE7, 0x9C},{0xE8, 0x9F},{0xE9, 0xA2},{0xEA, 0xA5},
        {0xEB, 0xA7},{0xEC, 0xAA},{0xED, 0xAD},{0xEE, 0xB0},{0xEF, 0xB5},{0xF0, 0xB8},{0xF1, 0xBB},{0xF2, 0xBE},{0xF3, 0xC1},{0xF4, 0xC3},
        {0xF5, 0xC6},{0xF6, 0xCA},{0xF7, 0xCC},{0xF8, 0xCF},{0xF9, 0xD2},{0xFA, 0xD6},{0xFB, 0xD9},{0xFC, 0xDD},{0xFD, 0xE0},{0xFE, 0xE3},
        {0xFF, 0xE6},{0x93, 0x0E},{0xC0, 0x33},{0xC1, 0x33},{0xC2, 0x33},{0xC3, 0x33},{0xC4, 0x34},{0xC5, 0x34},{0xC6, 0x34},{0xC7, 0x34},
        {0xC8, 0x35},{0xC9, 0x35},{0xCA, 0x36},{0xCB, 0x37},{0xCC, 0x38},{0xCD, 0x39},{0xCE, 0x3A},{0xCF, 0x3C},{0xD0, 0x3D},{0xD1, 0x3E},
        {0xD2, 0x3E},{0xD3, 0x40},{0xD4, 0x41},{0xD5, 0x41},{0xD6, 0x43},{0xD7, 0x44},{0xD8, 0x46},{0xD9, 0x47},{0xDA, 0x49},{0xDB, 0x4B},
        {0xDC, 0x4C},{0xDD, 0x4D},{0xDE, 0x4E},{0xDF, 0x50},{0xE0, 0x52},{0xE1, 0x53},{0xE2, 0x55},{0xE3, 0x55},{0xE4, 0x57},{0xE5, 0x58},
        {0xE6, 0x5A},{0xE7, 0x5B},{0xE8, 0x5D},{0xE9, 0x5E},{0xEA, 0x60},{0xEB, 0x62},{0xEC, 0x62},{0xED, 0x64},{0xEE, 0x66},{0xEF, 0x68},
        {0xF0, 0x6A},{0xF1, 0x6C},{0xF2, 0x6E},{0xF3, 0x70},{0xF4, 0x72},{0xF5, 0x73},{0xF6, 0x75},{0xF7, 0x77},{0xF8, 0x79},{0xF9, 0x7B},
        {0xFA, 0x7D},{0xFB, 0x7F},{0xFC, 0x81},{0xFD, 0x82},{0xFE, 0x83},{0xFF, 0x85},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x4B},{0xC1, 0x4B},{0xC2, 0x4B},{0xC3, 0x4B},{0xC4, 0x4B},{0xC5, 0x4B},{0xC6, 0x4C},{0xC7, 0x4C},
        {0xC8, 0x4D},{0xC9, 0x4D},{0xCA, 0x4E},{0xCB, 0x4E},{0xCC, 0x4F},{0xCD, 0x50},{0xCE, 0x51},{0xCF, 0x52},{0xD0, 0x54},{0xD1, 0x55},
        {0xD2, 0x56},{0xD3, 0x57},{0xD4, 0x58},{0xD5, 0x59},{0xD6, 0x5A},{0xD7, 0x5B},{0xD8, 0x5D},{0xD9, 0x5E},{0xDA, 0x60},{0xDB, 0x62},
        {0xDC, 0x63},{0xDD, 0x65},{0xDE, 0x67},{0xDF, 0x68},{0xE0, 0x6B},{0xE1, 0x6D},{0xE2, 0x6F},{0xE3, 0x71},{0xE4, 0x74},{0xE5, 0x75},
        {0xE6, 0x77},{0xE7, 0x7A},{0xE8, 0x7C},{0xE9, 0x7D},{0xEA, 0x7F},{0xEB, 0x81},{0xEC, 0x83},{0xED, 0x85},{0xEE, 0x87},{0xEF, 0x8B},
        {0xF0, 0x8C},{0xF1, 0x8F},{0xF2, 0x90},{0xF3, 0x93},{0xF4, 0x95},{0xF5, 0x98},{0xF6, 0x9A},{0xF7, 0x9C},{0xF8, 0x9E},{0xF9, 0xA1},
        {0xFA, 0xA5},{0xFB, 0xA7},{0xFC, 0xA9},{0xFD, 0xAB},{0xFE, 0xAE},{0xFF, 0xB1},{0x93, 0x11},{0xC0, 0x4F},{0xC1, 0x50},{0xC2, 0x50},
        {0xC3, 0x50},{0xC4, 0x50},{0xC5, 0x51},{0xC6, 0x52},{0xC7, 0x52},{0xC8, 0x53},{0xC9, 0x54},{0xCA, 0x55},{0xCB, 0x56},{0xCC, 0x57},
        {0xCD, 0x57},{0xCE, 0x59},{0xCF, 0x5A},{0xD0, 0x5B},{0xD1, 0x5D},{0xD2, 0x5E},{0xD3, 0x60},{0xD4, 0x62},{0xD5, 0x63},{0xD6, 0x65},
        {0xD7, 0x67},{0xD8, 0x69},{0xD9, 0x6B},{0xDA, 0x6D},{0xDB, 0x70},{0xDC, 0x72},{0xDD, 0x74},{0xDE, 0x77},{0xDF, 0x79},{0xE0, 0x7C},
        {0xE1, 0x7E},{0xE2, 0x80},{0xE3, 0x83},{0xE4, 0x85},{0xE5, 0x88},{0xE6, 0x8A},{0xE7, 0x8C},{0xE8, 0x8F},{0xE9, 0x91},{0xEA, 0x94},
        {0xEB, 0x97},{0xEC, 0x9A},{0xED, 0x9C},{0xEE, 0x9F},{0xEF, 0xA4},{0xF0, 0xA7},{0xF1, 0xA9},{0xF2, 0xAC},{0xF3, 0xAF},{0xF4, 0xB2},
        {0xF5, 0xB6},{0xF6, 0xBB},{0xF7, 0xBE},{0xF8, 0xC1},{0xF9, 0xC4},{0xFA, 0xC6},{0xFB, 0xC9},{0xFC, 0xCD},{0xFD, 0xD1},{0xFE, 0xD4},
        {0xFF, 0xD8},{0x93, 0x12},{0xC0, 0x2E},{0xC1, 0x2E},{0xC2, 0x2E},{0xC3, 0x2E},{0xC4, 0x2F},{0xC5, 0x2F},{0xC6, 0x30},{0xC7, 0x30},
        {0xC8, 0x30},{0xC9, 0x30},{0xCA, 0x31},{0xCB, 0x32},{0xCC, 0x33},{0xCD, 0x34},{0xCE, 0x35},{0xCF, 0x37},{0xD0, 0x38},{0xD1, 0x38},
        {0xD2, 0x39},{0xD3, 0x3A},{0xD4, 0x3B},{0xD5, 0x3C},{0xD6, 0x3D},{0xD7, 0x3D},{0xD8, 0x3F},{0xD9, 0x3F},{0xDA, 0x41},{0xDB, 0x43},
        {0xDC, 0x43},{0xDD, 0x45},{0xDE, 0x46},{0xDF, 0x48},{0xE0, 0x49},{0xE1, 0x4B},{0xE2, 0x4C},{0xE3, 0x4D},{0xE4, 0x4E},{0xE5, 0x4F},
        {0xE6, 0x51},{0xE7, 0x52},{0xE8, 0x54},{0xE9, 0x55},{0xEA, 0x57},{0xEB, 0x58},{0xEC, 0x59},{0xED, 0x5A},{0xEE, 0x5B},{0xEF, 0x5D},
        {0xF0, 0x5E},{0xF1, 0x60},{0xF2, 0x62},{0xF3, 0x63},{0xF4, 0x65},{0xF5, 0x66},{0xF6, 0x68},{0xF7, 0x69},{0xF8, 0x6B},{0xF9, 0x6D},
        {0xFA, 0x6F},{0xFB, 0x71},{0xFC, 0x73},{0xFD, 0x74},{0xFE, 0x75},{0xFF, 0x77},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [4] Strong -2
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x5B},{0xC1, 0x5B},{0xC2, 0x5C},{0xC3, 0x5C},{0xC4, 0x5C},{0xC5, 0x5C},{0xC6, 0x5D},{0xC7, 0x5D},
        {0xC8, 0x5E},{0xC9, 0x5E},{0xCA, 0x5F},{0xCB, 0x61},{0xCC, 0x62},{0xCD, 0x63},{0xCE, 0x64},{0xCF, 0x65},{0xD0, 0x66},{0xD1, 0x67},
        {0xD2, 0x68},{0xD3, 0x6B},{0xD4, 0x6D},{0xD5, 0x6D},{0xD6, 0x6F},{0xD7, 0x71},{0xD8, 0x72},{0xD9, 0x74},{0xDA, 0x76},{0xDB, 0x79},
        {0xDC, 0x7B},{0xDD, 0x7D},{0xDE, 0x7E},{0xDF, 0x80},{0xE0, 0x83},{0xE1, 0x85},{0xE2, 0x87},{0xE3, 0x88},{0xE4, 0x8B},{0xE5, 0x8E},
        {0xE6, 0x90},{0xE7, 0x93},{0xE8, 0x95},{0xE9, 0x96},{0xEA, 0x98},{0xEB, 0x9A},{0xEC, 0x9D},{0xED, 0x9F},{0xEE, 0xA1},{0xEF, 0xA5},
        {0xF0, 0xA7},{0xF1, 0xAA},{0xF2, 0xAC},{0xF3, 0xAE},{0xF4, 0xB0},{0xF5, 0xB3},{0xF6, 0xB5},{0xF7, 0xB8},{0xF8, 0xBC},{0xF9, 0xBE},
        {0xFA, 0xC1},{0xFB, 0xC3},{0xFC, 0xC5},{0xFD, 0xC7},{0xFE, 0xC9},{0xFF, 0xCC},{0x93, 0x09},{0xC0, 0x64},{0xC1, 0x64},{0xC2, 0x64},
        {0xC3, 0x64},{0xC4, 0x65},{0xC5, 0x65},{0xC6, 0x65},{0xC7, 0x65},{0xC8, 0x66},{0xC9, 0x67},{0xCA, 0x68},{0xCB, 0x6A},{0xCC, 0x6B},
        {0xCD, 0x6D},{0xCE, 0x6D},{0xCF, 0x6F},{0xD0, 0x71},{0xD1, 0x72},{0xD2, 0x74},{0xD3, 0x76},{0xD4, 0x79},{0xD5, 0x7B},{0xD6, 0x7D},
        {0xD7, 0x7E},{0xD8, 0x81},{0xD9, 0x83},{0xDA, 0x85},{0xDB, 0x87},{0xDC, 0x89},{0xDD, 0x8D},{0xDE, 0x8F},{0xDF, 0x92},{0xE0, 0x95},
        {0xE1, 0x97},{0xE2, 0x98},{0xE3, 0x9B},{0xE4, 0x9E},{0xE5, 0xA1},{0xE6, 0xA4},{0xE7, 0xA7},{0xE8, 0xA9},{0xE9, 0xAC},{0xEA, 0xAE},
        {0xEB, 0xB1},{0xEC, 0xB4},{0xED, 0xB7},{0xEE, 0xBB},{0xEF, 0xBF},{0xF0, 0xC2},{0xF1, 0xC4},{0xF2, 0xC6},{0xF3, 0xC9},{0xF4, 0xCC},
        {0xF5, 0xCE},{0xF6, 0xD2},{0xF7, 0xD5},{0xF8, 0xD8},{0xF9, 0xDB},{0xFA, 0xDD},{0xFB, 0xE0},{0xFC, 0xE3},{0xFD, 0xE6},{0xFE, 0xE8},
        {0xFF, 0xEB},{0x93, 0x0A},{0xC0, 0x3A},{0xC1, 0x3A},{0xC2, 0x3A},{0xC3, 0x3A},{0xC4, 0x3A},{0xC5, 0x3A},{0xC6, 0x3A},{0xC7, 0x3A},
        {0xC8, 0x3B},{0xC9, 0x3B},{0xCA, 0x3C},{0xCB, 0x3D},{0xCC, 0x3E},{0xCD, 0x3E},{0xCE, 0x3F},{0xCF, 0x40},{0xD0, 0x41},{0xD1, 0x43},
        {0xD2, 0x45},{0xD3, 0x46},{0xD4, 0x47},{0xD5, 0x49},{0xD6, 0x4A},{0xD7, 0x4B},{0xD8, 0x4C},{0xD9, 0x4E},{0xDA, 0x4F},{0xDB, 0x51},
        {0xDC, 0x52},{0xDD, 0x53},{0xDE, 0x55},{0xDF, 0x57},{0xE0, 0x59},{0xE1, 0x5A},{0xE2, 0x5B},{0xE3, 0x5D},{0xE4, 0x5F},{0xE5, 0x62},
        {0xE6, 0x63},{0xE7, 0x65},{0xE8, 0x66},{0xE9, 0x68},{0xEA, 0x6B},{0xEB, 0x6C},{0xEC, 0x6D},{0xED, 0x6F},{0xEE, 0x71},{0xEF, 0x73},
        {0xF0, 0x75},{0xF1, 0x77},{0xF2, 0x7A},{0xF3, 0x7C},{0xF4, 0x7E},{0xF5, 0x7F},{0xF6, 0x81},{0xF7, 0x83},{0xF8, 0x85},{0xF9, 0x87},
        {0xFA, 0x88},{0xFB, 0x89},{0xFC, 0x8B},{0xFD, 0x8E},{0xFE, 0x90},{0xFF, 0x92},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x56},{0xC1, 0x56},{0xC2, 0x57},{0xC3, 0x57},{0xC4, 0x57},{0xC5, 0x57},{0xC6, 0x57},{0xC7, 0x57},
        {0xC8, 0x58},{0xC9, 0x58},{0xCA, 0x59},{0xCB, 0x5A},{0xCC, 0x5B},{0xCD, 0x5C},{0xCE, 0x5D},{0xCF, 0x5D},{0xD0, 0x5F},{0xD1, 0x60},
        {0xD2, 0x61},{0xD3, 0x62},{0xD4, 0x64},{0xD5, 0x65},{0xD6, 0x67},{0xD7, 0x69},{0xD8, 0x6A},{0xD9, 0x6C},{0xDA, 0x6E},{0xDB, 0x70},
        {0xDC, 0x72},{0xDD, 0x74},{0xDE, 0x76},{0xDF, 0x78},{0xE0, 0x7B},{0xE1, 0x7D},{0xE2, 0x7F},{0xE3, 0x81},{0xE4, 0x83},{0xE5, 0x85},
        {0xE6, 0x87},{0xE7, 0x89},{0xE8, 0x8B},{0xE9, 0x8D},{0xEA, 0x90},{0xEB, 0x91},{0xEC, 0x94},{0xED, 0x96},{0xEE, 0x98},{0xEF, 0x9C},
        {0xF0, 0x9E},{0xF1, 0xA1},{0xF2, 0xA3},{0xF3, 0xA5},{0xF4, 0xA7},{0xF5, 0xAA},{0xF6, 0xAC},{0xF7, 0xAF},{0xF8, 0xB2},{0xF9, 0xB5},
        {0xFA, 0xB8},{0xFB, 0xBA},{0xFC, 0xBD},{0xFD, 0xC0},{0xFE, 0xC2},{0xFF, 0xC4},{0x93, 0x0D},{0xC0, 0x5D},{0xC1, 0x5D},{0xC2, 0x5D},
        {0xC3, 0x5D},{0xC4, 0x5D},{0xC5, 0x5D},{0xC6, 0x5E},{0xC7, 0x5E},{0xC8, 0x5F},{0xC9, 0x60},{0xCA, 0x61},{0xCB, 0x62},{0xCC, 0x62},
        {0xCD, 0x64},{0xCE, 0x65},{0xCF, 0x67},{0xD0, 0x69},{0xD1, 0x6A},{0xD2, 0x6C},{0xD3, 0x6E},{0xD4, 0x70},{0xD5, 0x72},{0xD6, 0x74},
        {0xD7, 0x76},{0xD8, 0x79},{0xD9, 0x7B},{0xDA, 0x7D},{0xDB, 0x80},{0xDC, 0x82},{0xDD, 0x84},{0xDE, 0x86},{0xDF, 0x88},{0xE0, 0x8B},
        {0xE1, 0x8E},{0xE2, 0x90},{0xE3, 0x92},{0xE4, 0x95},{0xE5, 0x98},{0xE6, 0x9B},{0xE7, 0x9E},{0xE8, 0xA0},{0xE9, 0xA3},{0xEA, 0xA5},
        {0xEB, 0xA8},{0xEC, 0xAB},{0xED, 0xAE},{0xEE, 0xB1},{0xEF, 0xB6},{0xF0, 0xB9},{0xF1, 0xBC},{0xF2, 0xBF},{0xF3, 0xC2},{0xF4, 0xC4},
        {0xF5, 0xC7},{0xF6, 0xCB},{0xF7, 0xCD},{0xF8, 0xD0},{0xF9, 0xD4},{0xFA, 0xD7},{0xFB, 0xDA},{0xFC, 0xDE},{0xFD, 0xE1},{0xFE, 0xE4},
        {0xFF, 0xE7},{0x93, 0x0E},{0xC0, 0x36},{0xC1, 0x36},{0xC2, 0x36},{0xC3, 0x36},{0xC4, 0x36},{0xC5, 0x36},{0xC6, 0x37},{0xC7, 0x37},
        {0xC8, 0x38},{0xC9, 0x38},{0xCA, 0x39},{0xCB, 0x3A},{0xCC, 0x3B},{0xCD, 0x3C},{0xCE, 0x3D},{0xCF, 0x3E},{0xD0, 0x3E},{0xD1, 0x40},
        {0xD2, 0x41},{0xD3, 0x41},{0xD4, 0x42},{0xD5, 0x44},{0xD6, 0x45},{0xD7, 0x47},{0xD8, 0x48},{0xD9, 0x4A},{0xDA, 0x4B},{0xDB, 0x4D},
        {0xDC, 0x4E},{0xDD, 0x4F},{0xDE, 0x51},{0xDF, 0x52},{0xE0, 0x54},{0xE1, 0x55},{0xE2, 0x56},{0xE3, 0x57},{0xE4, 0x59},{0xE5, 0x5B},
        {0xE6, 0x5C},{0xE7, 0x5D},{0xE8, 0x5F},{0xE9, 0x61},{0xEA, 0x62},{0xEB, 0x63},{0xEC, 0x65},{0xED, 0x67},{0xEE, 0x69},{0xEF, 0x6B},
        {0xF0, 0x6D},{0xF1, 0x6F},{0xF2, 0x71},{0xF3, 0x73},{0xF4, 0x75},{0xF5, 0x77},{0xF6, 0x79},{0xF7, 0x7B},{0xF8, 0x7D},{0xF9, 0x7F},
        {0xFA, 0x81},{0xFB, 0x82},{0xFC, 0x83},{0xFD, 0x85},{0xFE, 0x87},{0xFF, 0x88},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4E},{0xC3, 0x4E},{0xC4, 0x4E},{0xC5, 0x4E},{0xC6, 0x4F},{0xC7, 0x4F},
        {0xC8, 0x4F},{0xC9, 0x4F},{0xCA, 0x50},{0xCB, 0x51},{0xCC, 0x52},{0xCD, 0x53},{0xCE, 0x54},{0xCF, 0x55},{0xD0, 0x56},{0xD1, 0x57},
        {0xD2, 0x57},{0xD3, 0x59},{0xD4, 0x5A},{0xD5, 0x5B},{0xD6, 0x5C},{0xD7, 0x5E},{0xD8, 0x5E},{0xD9, 0x60},{0xDA, 0x62},{0xDB, 0x63},
        {0xDC, 0x65},{0xDD, 0x67},{0xDE, 0x68},{0xDF, 0x6A},{0xE0, 0x6D},{0xE1, 0x6F},{0xE2, 0x71},{0xE3, 0x73},{0xE4, 0x75},{0xE5, 0x77},
        {0xE6, 0x79},{0xE7, 0x7C},{0xE8, 0x7D},{0xE9, 0x7F},{0xEA, 0x81},{0xEB, 0x83},{0xEC, 0x85},{0xED, 0x87},{0xEE, 0x89},{0xEF, 0x8C},
        {0xF0, 0x8E},{0xF1, 0x90},{0xF2, 0x92},{0xF3, 0x95},{0xF4, 0x97},{0xF5, 0x9A},{0xF6, 0x9B},{0xF7, 0x9E},{0xF8, 0xA1},{0xF9, 0xA4},
        {0xFA, 0xA7},{0xFB, 0xA8},{0xFC, 0xAB},{0xFD, 0xAE},{0xFE, 0xB0},{0xFF, 0xB4},{0x93, 0x11},{0xC0, 0x54},{0xC1, 0x54},{0xC2, 0x54},
        {0xC3, 0x54},{0xC4, 0x55},{0xC5, 0x55},{0xC6, 0x55},{0xC7, 0x55},{0xC8, 0x56},{0xC9, 0x57},{0xCA, 0x57},{0xCB, 0x58},{0xCC, 0x59},
        {0xCD, 0x5A},{0xCE, 0x5B},{0xCF, 0x5C},{0xD0, 0x5E},{0xD1, 0x5E},{0xD2, 0x60},{0xD3, 0x62},{0xD4, 0x63},{0xD5, 0x65},{0xD6, 0x67},
        {0xD7, 0x68},{0xD8, 0x6B},{0xD9, 0x6D},{0xDA, 0x6F},{0xDB, 0x72},{0xDC, 0x74},{0xDD, 0x76},{0xDE, 0x78},{0xDF, 0x7B},{0xE0, 0x7D},
        {0xE1, 0x7F},{0xE2, 0x81},{0xE3, 0x83},{0xE4, 0x86},{0xE5, 0x89},{0xE6, 0x8B},{0xE7, 0x8E},{0xE8, 0x90},{0xE9, 0x92},{0xEA, 0x95},
        {0xEB, 0x98},{0xEC, 0x9A},{0xED, 0x9D},{0xEE, 0xA0},{0xEF, 0xA5},{0xF0, 0xA8},{0xF1, 0xAA},{0xF2, 0xAD},{0xF3, 0xB0},{0xF4, 0xB4},
        {0xF5, 0xB7},{0xF6, 0xBC},{0xF7, 0xBF},{0xF8, 0xC2},{0xF9, 0xC5},{0xFA, 0xC7},{0xFB, 0xCA},{0xFC, 0xCE},{0xFD, 0xD2},{0xFE, 0xD5},
        {0xFF, 0xD9},{0x93, 0x12},{0xC0, 0x31},{0xC1, 0x31},{0xC2, 0x31},{0xC3, 0x31},{0xC4, 0x31},{0xC5, 0x31},{0xC6, 0x32},{0xC7, 0x32},
        {0xC8, 0x33},{0xC9, 0x33},{0xCA, 0x34},{0xCB, 0x35},{0xCC, 0x36},{0xCD, 0x37},{0xCE, 0x38},{0xCF, 0x38},{0xD0, 0x39},{0xD1, 0x3A},
        {0xD2, 0x3B},{0xD3, 0x3C},{0xD4, 0x3C},{0xD5, 0x3D},{0xD6, 0x3E},{0xD7, 0x3F},{0xD8, 0x40},{0xD9, 0x42},{0xDA, 0x43},{0xDB, 0x44},
        {0xDC, 0x46},{0xDD, 0x47},{0xDE, 0x48},{0xDF, 0x4A},{0xE0, 0x4B},{0xE1, 0x4C},{0xE2, 0x4D},{0xE3, 0x4F},{0xE4, 0x50},{0xE5, 0x52},
        {0xE6, 0x53},{0xE7, 0x55},{0xE8, 0x56},{0xE9, 0x57},{0xEA, 0x59},{0xEB, 0x59},{0xEC, 0x5B},{0xED, 0x5C},{0xEE, 0x5E},{0xEF, 0x5F},
        {0xF0, 0x61},{0xF1, 0x63},{0xF2, 0x64},{0xF3, 0x66},{0xF4, 0x68},{0xF5, 0x69},{0xF6, 0x6B},{0xF7, 0x6D},{0xF8, 0x6F},{0xF9, 0x71},
        {0xFA, 0x73},{0xFB, 0x74},{0xFC, 0x75},{0xFD, 0x77},{0xFE, 0x79},{0xFF, 0x7B},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [5] Strong -1
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x61},{0xC1, 0x61},{0xC2, 0x61},{0xC3, 0x61},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x62},{0xC7, 0x62},
        {0xC8, 0x62},{0xC9, 0x63},{0xCA, 0x64},{0xCB, 0x64},{0xCC, 0x65},{0xCD, 0x65},{0xCE, 0x66},{0xCF, 0x67},{0xD0, 0x6A},{0xD1, 0x6B},
        {0xD2, 0x6C},{0xD3, 0x6D},{0xD4, 0x6E},{0xD5, 0x70},{0xD6, 0x71},{0xD7, 0x73},{0xD8, 0x75},{0xD9, 0x76},{0xDA, 0x79},{0xDB, 0x7B},
        {0xDC, 0x7D},{0xDD, 0x7E},{0xDE, 0x80},{0xDF, 0x82},{0xE0, 0x85},{0xE1, 0x87},{0xE2, 0x88},{0xE3, 0x8A},{0xE4, 0x8D},{0xE5, 0x90},
        {0xE6, 0x92},{0xE7, 0x94},{0xE8, 0x96},{0xE9, 0x97},{0xEA, 0x99},{0xEB, 0x9C},{0xEC, 0x9E},{0xED, 0xA1},{0xEE, 0xA3},{0xEF, 0xA6},
        {0xF0, 0xA9},{0xF1, 0xAB},{0xF2, 0xAD},{0xF3, 0xB0},{0xF4, 0xB2},{0xF5, 0xB5},{0xF6, 0xB7},{0xF7, 0xBB},{0xF8, 0xBE},{0xF9, 0xC0},
        {0xFA, 0xC3},{0xFB, 0xC5},{0xFC, 0xC6},{0xFD, 0xC9},{0xFE, 0xCC},{0xFF, 0xCE},{0x93, 0x09},{0xC0, 0x68},{0xC1, 0x68},{0xC2, 0x68},
        {0xC3, 0x68},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x6A},{0xC7, 0x6A},{0xC8, 0x6B},{0xC9, 0x6C},{0xCA, 0x6D},{0xCB, 0x6D},{0xCC, 0x6E},
        {0xCD, 0x6F},{0xCE, 0x70},{0xCF, 0x72},{0xD0, 0x73},{0xD1, 0x75},{0xD2, 0x77},{0xD3, 0x79},{0xD4, 0x7B},{0xD5, 0x7D},{0xD6, 0x7E},
        {0xD7, 0x80},{0xD8, 0x82},{0xD9, 0x85},{0xDA, 0x87},{0xDB, 0x88},{0xDC, 0x8B},{0xDD, 0x8E},{0xDE, 0x91},{0xDF, 0x93},{0xE0, 0x95},
        {0xE1, 0x97},{0xE2, 0x9A},{0xE3, 0x9C},{0xE4, 0x9F},{0xE5, 0xA2},{0xE6, 0xA5},{0xE7, 0xA8},{0xE8, 0xAA},{0xE9, 0xAC},{0xEA, 0xAF},
        {0xEB, 0xB2},{0xEC, 0xB5},{0xED, 0xB8},{0xEE, 0xBC},{0xEF, 0xC0},{0xF0, 0xC3},{0xF1, 0xC5},{0xF2, 0xC7},{0xF3, 0xCA},{0xF4, 0xCD},
        {0xF5, 0xCF},{0xF6, 0xD3},{0xF7, 0xD6},{0xF8, 0xD9},{0xF9, 0xDC},{0xFA, 0xDE},{0xFB, 0xE1},{0xFC, 0xE4},{0xFD, 0xE7},{0xFE, 0xE9},
        {0xFF, 0xEC},{0x93, 0x0A},{0xC0, 0x3C},{0xC1, 0x3C},{0xC2, 0x3C},{0xC3, 0x3C},{0xC4, 0x3C},{0xC5, 0x3D},{0xC6, 0x3D},{0xC7, 0x3D},
        {0xC8, 0x3E},{0xC9, 0x3E},{0xCA, 0x3E},{0xCB, 0x3F},{0xCC, 0x40},{0xCD, 0x41},{0xCE, 0x42},{0xCF, 0x43},{0xD0, 0x45},{0xD1, 0x46},
        {0xD2, 0x47},{0xD3, 0x49},{0xD4, 0x4A},{0xD5, 0x4A},{0xD6, 0x4C},{0xD7, 0x4D},{0xD8, 0x4F},{0xD9, 0x50},{0xDA, 0x52},{0xDB, 0x52},
        {0xDC, 0x54},{0xDD, 0x56},{0xDE, 0x57},{0xDF, 0x59},{0xE0, 0x5B},{0xE1, 0x5C},{0xE2, 0x5E},{0xE3, 0x5F},{0xE4, 0x62},{0xE5, 0x64},
        {0xE6, 0x65},{0xE7, 0x67},{0xE8, 0x6A},{0xE9, 0x6B},{0xEA, 0x6D},{0xEB, 0x6E},{0xEC, 0x70},{0xED, 0x72},{0xEE, 0x74},{0xEF, 0x76},
        {0xF0, 0x79},{0xF1, 0x7B},{0xF2, 0x7D},{0xF3, 0x7E},{0xF4, 0x80},{0xF5, 0x82},{0xF6, 0x84},{0xF7, 0x86},{0xF8, 0x87},{0xF9, 0x89},
        {0xFA, 0x8B},{0xFB, 0x8E},{0xFC, 0x90},{0xFD, 0x92},{0xFE, 0x94},{0xFF, 0x95},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x5A},{0xC1, 0x5A},{0xC2, 0x5A},{0xC3, 0x5A},{0xC4, 0x5A},{0xC5, 0x5A},{0xC6, 0x5B},{0xC7, 0x5B},
        {0xC8, 0x5B},{0xC9, 0x5C},{0xCA, 0x5D},{0xCB, 0x5D},{0xCC, 0x5D},{0xCD, 0x5E},{0xCE, 0x5F},{0xCF, 0x60},{0xD0, 0x62},{0xD1, 0x62},
        {0xD2, 0x63},{0xD3, 0x65},{0xD4, 0x66},{0xD5, 0x68},{0xD6, 0x69},{0xD7, 0x6B},{0xD8, 0x6D},{0xD9, 0x6E},{0xDA, 0x70},{0xDB, 0x72},
        {0xDC, 0x74},{0xDD, 0x76},{0xDE, 0x78},{0xDF, 0x7A},{0xE0, 0x7D},{0xE1, 0x7F},{0xE2, 0x81},{0xE3, 0x83},{0xE4, 0x84},{0xE5, 0x87},
        {0xE6, 0x88},{0xE7, 0x8A},{0xE8, 0x8D},{0xE9, 0x8F},{0xEA, 0x90},{0xEB, 0x93},{0xEC, 0x95},{0xED, 0x98},{0xEE, 0x9A},{0xEF, 0x9D},
        {0xF0, 0xA0},{0xF1, 0xA2},{0xF2, 0xA5},{0xF3, 0xA7},{0xF4, 0xA9},{0xF5, 0xAC},{0xF6, 0xAE},{0xF7, 0xB1},{0xF8, 0xB5},{0xF9, 0xB7},
        {0xFA, 0xBA},{0xFB, 0xBD},{0xFC, 0xBF},{0xFD, 0xC2},{0xFE, 0xC4},{0xFF, 0xC6},{0x93, 0x0D},{0xC0, 0x61},{0xC1, 0x61},{0xC2, 0x61},
        {0xC3, 0x61},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x62},{0xC7, 0x62},{0xC8, 0x62},{0xC9, 0x63},{0xCA, 0x64},{0xCB, 0x65},{0xCC, 0x66},
        {0xCD, 0x67},{0xCE, 0x68},{0xCF, 0x6A},{0xD0, 0x6B},{0xD1, 0x6D},{0xD2, 0x6F},{0xD3, 0x70},{0xD4, 0x72},{0xD5, 0x74},{0xD6, 0x76},
        {0xD7, 0x78},{0xD8, 0x7A},{0xD9, 0x7D},{0xDA, 0x7F},{0xDB, 0x81},{0xDC, 0x83},{0xDD, 0x85},{0xDE, 0x87},{0xDF, 0x89},{0xE0, 0x8C},
        {0xE1, 0x8F},{0xE2, 0x91},{0xE3, 0x93},{0xE4, 0x96},{0xE5, 0x99},{0xE6, 0x9C},{0xE7, 0x9F},{0xE8, 0xA1},{0xE9, 0xA4},{0xEA, 0xA6},
        {0xEB, 0xA9},{0xEC, 0xAC},{0xED, 0xAF},{0xEE, 0xB2},{0xEF, 0xB7},{0xF0, 0xBA},{0xF1, 0xBD},{0xF2, 0xC0},{0xF3, 0xC3},{0xF4, 0xC5},
        {0xF5, 0xC8},{0xF6, 0xCB},{0xF7, 0xCE},{0xF8, 0xD1},{0xF9, 0xD5},{0xFA, 0xD8},{0xFB, 0xDB},{0xFC, 0xDF},{0xFD, 0xE2},{0xFE, 0xE5},
        {0xFF, 0xE8},{0x93, 0x0E},{0xC0, 0x39},{0xC1, 0x39},{0xC2, 0x39},{0xC3, 0x39},{0xC4, 0x39},{0xC5, 0x3A},{0xC6, 0x3A},{0xC7, 0x3A},
        {0xC8, 0x3B},{0xC9, 0x3C},{0xCA, 0x3C},{0xCB, 0x3D},{0xCC, 0x3E},{0xCD, 0x3E},{0xCE, 0x3F},{0xCF, 0x40},{0xD0, 0x41},{0xD1, 0x41},
        {0xD2, 0x42},{0xD3, 0x44},{0xD4, 0x45},{0xD5, 0x46},{0xD6, 0x48},{0xD7, 0x49},{0xD8, 0x4B},{0xD9, 0x4C},{0xDA, 0x4D},{0xDB, 0x4E},
        {0xDC, 0x50},{0xDD, 0x52},{0xDE, 0x52},{0xDF, 0x54},{0xE0, 0x55},{0xE1, 0x57},{0xE2, 0x58},{0xE3, 0x59},{0xE4, 0x5B},{0xE5, 0x5D},
        {0xE6, 0x5E},{0xE7, 0x60},{0xE8, 0x62},{0xE9, 0x62},{0xEA, 0x64},{0xEB, 0x66},{0xEC, 0x68},{0xED, 0x6A},{0xEE, 0x6C},{0xEF, 0x6E},
        {0xF0, 0x70},{0xF1, 0x72},{0xF2, 0x74},{0xF3, 0x76},{0xF4, 0x78},{0xF5, 0x7A},{0xF6, 0x7C},{0xF7, 0x7E},{0xF8, 0x80},{0xF9, 0x82},
        {0xFA, 0x83},{0xFB, 0x85},{0xFC, 0x87},{0xFD, 0x88},{0xFE, 0x8A},{0xFF, 0x8C},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x51},{0xC1, 0x51},{0xC2, 0x51},{0xC3, 0x51},{0xC4, 0x51},{0xC5, 0x51},{0xC6, 0x52},{0xC7, 0x52},
        {0xC8, 0x52},{0xC9, 0x53},{0xCA, 0x54},{0xCB, 0x54},{0xCC, 0x55},{0xCD, 0x55},{0xCE, 0x56},{0xCF, 0x57},{0xD0, 0x58},{0xD1, 0x59},
        {0xD2, 0x59},{0xD3, 0x5B},{0xD4, 0x5B},{0xD5, 0x5D},{0xD6, 0x5E},{0xD7, 0x5F},{0xD8, 0x61},{0xD9, 0x62},{0xDA, 0x63},{0xDB, 0x65},
        {0xDC, 0x67},{0xDD, 0x68},{0xDE, 0x6A},{0xDF, 0x6C},{0xE0, 0x6F},{0xE1, 0x71},{0xE2, 0x73},{0xE3, 0x74},{0xE4, 0x76},{0xE5, 0x79},
        {0xE6, 0x7B},{0xE7, 0x7C},{0xE8, 0x7F},{0xE9, 0x80},{0xEA, 0x82},{0xEB, 0x84},{0xEC, 0x86},{0xED, 0x89},{0xEE, 0x8B},{0xEF, 0x8D},
        {0xF0, 0x90},{0xF1, 0x91},{0xF2, 0x94},{0xF3, 0x97},{0xF4, 0x99},{0xF5, 0x9B},{0xF6, 0x9D},{0xF7, 0xA0},{0xF8, 0xA4},{0xF9, 0xA6},
        {0xFA, 0xA8},{0xFB, 0xAB},{0xFC, 0xAD},{0xFD, 0xB0},{0xFE, 0xB4},{0xFF, 0xB6},{0x93, 0x11},{0xC0, 0x57},{0xC1, 0x57},{0xC2, 0x57},
        {0xC3, 0x57},{0xC4, 0x57},{0xC5, 0x57},{0xC6, 0x58},{0xC7, 0x58},{0xC8, 0x59},{0xC9, 0x59},{0xCA, 0x5A},{0xCB, 0x5B},{0xCC, 0x5B},
        {0xCD, 0x5C},{0xCE, 0x5D},{0xCF, 0x5E},{0xD0, 0x5F},{0xD1, 0x61},{0xD2, 0x63},{0xD3, 0x63},{0xD4, 0x65},{0xD5, 0x67},{0xD6, 0x68},
        {0xD7, 0x6A},{0xD8, 0x6C},{0xD9, 0x6F},{0xDA, 0x71},{0xDB, 0x73},{0xDC, 0x75},{0xDD, 0x77},{0xDE, 0x7A},{0xDF, 0x7C},{0xE0, 0x7E},
        {0xE1, 0x80},{0xE2, 0x83},{0xE3, 0x84},{0xE4, 0x87},{0xE5, 0x8A},{0xE6, 0x8C},{0xE7, 0x8F},{0xE8, 0x90},{0xE9, 0x93},{0xEA, 0x96},
        {0xEB, 0x99},{0xEC, 0x9B},{0xED, 0x9E},{0xEE, 0xA1},{0xEF, 0xA6},{0xF0, 0xA8},{0xF1, 0xAB},{0xF2, 0xAE},{0xF3, 0xB1},{0xF4, 0xB5},
        {0xF5, 0xB8},{0xF6, 0xBD},{0xF7, 0xC0},{0xF8, 0xC3},{0xF9, 0xC6},{0xFA, 0xC8},{0xFB, 0xCB},{0xFC, 0xCF},{0xFD, 0xD3},{0xFE, 0xD7},
        {0xFF, 0xDB},{0x93, 0x12},{0xC0, 0x34},{0xC1, 0x34},{0xC2, 0x34},{0xC3, 0x34},{0xC4, 0x34},{0xC5, 0x35},{0xC6, 0x35},{0xC7, 0x35},
        {0xC8, 0x36},{0xC9, 0x37},{0xCA, 0x37},{0xCB, 0x38},{0xCC, 0x38},{0xCD, 0x39},{0xCE, 0x3A},{0xCF, 0x3A},{0xD0, 0x3B},{0xD1, 0x3C},
        {0xD2, 0x3C},{0xD3, 0x3D},{0xD4, 0x3E},{0xD5, 0x3F},{0xD6, 0x40},{0xD7, 0x41},{0xD8, 0x43},{0xD9, 0x43},{0xDA, 0x45},{0xDB, 0x46},
        {0xDC, 0x48},{0xDD, 0x49},{0xDE, 0x4A},{0xDF, 0x4B},{0xE0, 0x4D},{0xE1, 0x4E},{0xE2, 0x4F},{0xE3, 0x50},{0xE4, 0x52},{0xE5, 0x54},
        {0xE6, 0x55},{0xE7, 0x57},{0xE8, 0x58},{0xE9, 0x59},{0xEA, 0x5A},{0xEB, 0x5B},{0xEC, 0x5D},{0xED, 0x5E},{0xEE, 0x60},{0xEF, 0x62},
        {0xF0, 0x63},{0xF1, 0x65},{0xF2, 0x67},{0xF3, 0x68},{0xF4, 0x6A},{0xF5, 0x6C},{0xF6, 0x6E},{0xF7, 0x70},{0xF8, 0x72},{0xF9, 0x74},
        {0xFA, 0x75},{0xFB, 0x77},{0xFC, 0x79},{0xFD, 0x7B},{0xFE, 0x7C},{0xFF, 0x7E},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [6] Strong 0
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x65},{0xC1, 0x65},{0xC2, 0x65},{0xC3, 0x65},{0xC4, 0x65},{0xC5, 0x65},{0xC6, 0x65},{0xC7, 0x65},
        {0xC8, 0x65},{0xC9, 0x66},{0xCA, 0x66},{0xCB, 0x67},{0xCC, 0x68},{0xCD, 0x68},{0xCE, 0x6A},{0xCF, 0x6B},{0xD0, 0x6D},{0xD1, 0x6D},
        {0xD2, 0x6E},{0xD3, 0x6F},{0xD4, 0x71},{0xD5, 0x72},{0xD6, 0x74},{0xD7, 0x75},{0xD8, 0x77},{0xD9, 0x7A},{0xDA, 0x7B},{0xDB, 0x7D},
        {0xDC, 0x7E},{0xDD, 0x80},{0xDE, 0x82},{0xDF, 0x84},{0xE0, 0x87},{0xE1, 0x88},{0xE2, 0x8A},{0xE3, 0x8D},{0xE4, 0x8F},{0xE5, 0x91},
        {0xE6, 0x94},{0xE7, 0x95},{0xE8, 0x97},{0xE9, 0x99},{0xEA, 0x9B},{0xEB, 0x9E},{0xEC, 0xA0},{0xED, 0xA3},{0xEE, 0xA5},{0xEF, 0xA8},
        {0xF0, 0xAB},{0xF1, 0xAC},{0xF2, 0xAF},{0xF3, 0xB1},{0xF4, 0xB4},{0xF5, 0xB7},{0xF6, 0xB9},{0xF7, 0xBD},{0xF8, 0xBF},{0xF9, 0xC2},
        {0xFA, 0xC4},{0xFB, 0xC6},{0xFC, 0xC8},{0xFD, 0xCB},{0xFE, 0xCE},{0xFF, 0xCF},{0x93, 0x09},{0xC0, 0x6D},{0xC1, 0x6D},{0xC2, 0x6D},
        {0xC3, 0x6D},{0xC4, 0x6D},{0xC5, 0x6D},{0xC6, 0x6D},{0xC7, 0x6D},{0xC8, 0x6E},{0xC9, 0x6E},{0xCA, 0x6F},{0xCB, 0x70},{0xCC, 0x71},
        {0xCD, 0x72},{0xCE, 0x73},{0xCF, 0x75},{0xD0, 0x76},{0xD1, 0x77},{0xD2, 0x7A},{0xD3, 0x7C},{0xD4, 0x7D},{0xD5, 0x7E},{0xD6, 0x80},
        {0xD7, 0x82},{0xD8, 0x84},{0xD9, 0x86},{0xDA, 0x88},{0xDB, 0x8A},{0xDC, 0x8D},{0xDD, 0x90},{0xDE, 0x92},{0xDF, 0x94},{0xE0, 0x97},
        {0xE1, 0x98},{0xE2, 0x9B},{0xE3, 0x9D},{0xE4, 0xA0},{0xE5, 0xA3},{0xE6, 0xA6},{0xE7, 0xA9},{0xE8, 0xAB},{0xE9, 0xAD},{0xEA, 0xB0},
        {0xEB, 0xB3},{0xEC, 0xB6},{0xED, 0xB9},{0xEE, 0xBD},{0xEF, 0xC1},{0xF0, 0xC3},{0xF1, 0xC6},{0xF2, 0xC8},{0xF3, 0xCB},{0xF4, 0xCE},
        {0xF5, 0xD0},{0xF6, 0xD3},{0xF7, 0xD7},{0xF8, 0xDA},{0xF9, 0xDD},{0xFA, 0xDF},{0xFB, 0xE1},{0xFC, 0xE4},{0xFD, 0xE8},{0xFE, 0xEA},
        {0xFF, 0xED},{0x93, 0x0A},{0xC0, 0x3E},{0xC1, 0x3E},{0xC2, 0x3F},{0xC3, 0x3F},{0xC4, 0x3F},{0xC5, 0x3F},{0xC6, 0x3F},{0xC7, 0x40},
        {0xC8, 0x40},{0xC9, 0x41},{0xCA, 0x41},{0xCB, 0x42},{0xCC, 0x43},{0xCD, 0x43},{0xCE, 0x45},{0xCF, 0x46},{0xD0, 0x48},{0xD1, 0x49},
        {0xD2, 0x4A},{0xD3, 0x4A},{0xD4, 0x4B},{0xD5, 0x4D},{0xD6, 0x4E},{0xD7, 0x4F},{0xD8, 0x51},{0xD9, 0x52},{0xDA, 0x53},{0xDB, 0x55},
        {0xDC, 0x56},{0xDD, 0x58},{0xDE, 0x5A},{0xDF, 0x5B},{0xE0, 0x5C},{0xE1, 0x5E},{0xE2, 0x61},{0xE3, 0x63},{0xE4, 0x65},{0xE5, 0x66},
        {0xE6, 0x67},{0xE7, 0x6A},{0xE8, 0x6C},{0xE9, 0x6D},{0xEA, 0x6F},{0xEB, 0x71},{0xEC, 0x73},{0xED, 0x75},{0xEE, 0x77},{0xEF, 0x7A},
        {0xF0, 0x7C},{0xF1, 0x7E},{0xF2, 0x7F},{0xF3, 0x81},{0xF4, 0x83},{0xF5, 0x85},{0xF6, 0x87},{0xF7, 0x88},{0xF8, 0x8A},{0xF9, 0x8D},
        {0xFA, 0x8F},{0xFB, 0x91},{0xFC, 0x93},{0xFD, 0x95},{0xFE, 0x97},{0xFF, 0x98},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x5D},{0xC1, 0x5D},{0xC2, 0x5D},{0xC3, 0x5D},{0xC4, 0x5D},{0xC5, 0x5D},{0xC6, 0x5D},{0xC7, 0x5E},
        {0xC8, 0x5E},{0xC9, 0x5F},{0xCA, 0x5F},{0xCB, 0x60},{0xCC, 0x61},{0xCD, 0x61},{0xCE, 0x62},{0xCF, 0x62},{0xD0, 0x64},{0xD1, 0x65},
        {0xD2, 0x66},{0xD3, 0x67},{0xD4, 0x69},{0xD5, 0x6A},{0xD6, 0x6C},{0xD7, 0x6D},{0xD8, 0x6F},{0xD9, 0x71},{0xDA, 0x72},{0xDB, 0x74},
        {0xDC, 0x76},{0xDD, 0x78},{0xDE, 0x7A},{0xDF, 0x7C},{0xE0, 0x7F},{0xE1, 0x81},{0xE2, 0x83},{0xE3, 0x84},{0xE4, 0x86},{0xE5, 0x87},
        {0xE6, 0x8A},{0xE7, 0x8C},{0xE8, 0x8E},{0xE9, 0x90},{0xEA, 0x92},{0xEB, 0x95},{0xEC, 0x97},{0xED, 0x9A},{0xEE, 0x9C},{0xEF, 0x9F},
        {0xF0, 0xA2},{0xF1, 0xA4},{0xF2, 0xA6},{0xF3, 0xA8},{0xF4, 0xAB},{0xF5, 0xAE},{0xF6, 0xB0},{0xF7, 0xB3},{0xF8, 0xB6},{0xF9, 0xB9},
        {0xFA, 0xBC},{0xFB, 0xBE},{0xFC, 0xC1},{0xFD, 0xC3},{0xFE, 0xC6},{0xFF, 0xC8},{0x93, 0x0D},{0xC0, 0x64},{0xC1, 0x64},{0xC2, 0x64},
        {0xC3, 0x64},{0xC4, 0x64},{0xC5, 0x64},{0xC6, 0x65},{0xC7, 0x65},{0xC8, 0x66},{0xC9, 0x66},{0xCA, 0x67},{0xCB, 0x68},{0xCC, 0x69},
        {0xCD, 0x6A},{0xCE, 0x6B},{0xCF, 0x6D},{0xD0, 0x6E},{0xD1, 0x6F},{0xD2, 0x71},{0xD3, 0x73},{0xD4, 0x74},{0xD5, 0x76},{0xD6, 0x78},
        {0xD7, 0x7A},{0xD8, 0x7C},{0xD9, 0x7E},{0xDA, 0x81},{0xDB, 0x83},{0xDC, 0x84},{0xDD, 0x87},{0xDE, 0x88},{0xDF, 0x8A},{0xE0, 0x8E},
        {0xE1, 0x90},{0xE2, 0x92},{0xE3, 0x94},{0xE4, 0x97},{0xE5, 0x9A},{0xE6, 0x9D},{0xE7, 0xA0},{0xE8, 0xA2},{0xE9, 0xA5},{0xEA, 0xA7},
        {0xEB, 0xAA},{0xEC, 0xAD},{0xED, 0xB0},{0xEE, 0xB3},{0xEF, 0xB8},{0xF0, 0xBB},{0xF1, 0xBE},{0xF2, 0xC1},{0xF3, 0xC3},{0xF4, 0xC6},
        {0xF5, 0xC9},{0xF6, 0xCB},{0xF7, 0xCF},{0xF8, 0xD2},{0xF9, 0xD6},{0xFA, 0xD9},{0xFB, 0xDC},{0xFC, 0xDF},{0xFD, 0xE3},{0xFE, 0xE6},
        {0xFF, 0xE9},{0x93, 0x0E},{0xC0, 0x3C},{0xC1, 0x3C},{0xC2, 0x3D},{0xC3, 0x3D},{0xC4, 0x3D},{0xC5, 0x3D},{0xC6, 0x3D},{0xC7, 0x3E},
        {0xC8, 0x3E},{0xC9, 0x3E},{0xCA, 0x3E},{0xCB, 0x3F},{0xCC, 0x40},{0xCD, 0x40},{0xCE, 0x41},{0xCF, 0x41},{0xD0, 0x43},{0xD1, 0x44},
        {0xD2, 0x45},{0xD3, 0x46},{0xD4, 0x47},{0xD5, 0x49},{0xD6, 0x4A},{0xD7, 0x4B},{0xD8, 0x4D},{0xD9, 0x4D},{0xDA, 0x4F},{0xDB, 0x51},
        {0xDC, 0x52},{0xDD, 0x53},{0xDE, 0x55},{0xDF, 0x55},{0xE0, 0x57},{0xE1, 0x58},{0xE2, 0x5A},{0xE3, 0x5C},{0xE4, 0x5D},{0xE5, 0x5F},
        {0xE6, 0x60},{0xE7, 0x62},{0xE8, 0x63},{0xE9, 0x65},{0xEA, 0x67},{0xEB, 0x69},{0xEC, 0x6B},{0xED, 0x6D},{0xEE, 0x6F},{0xEF, 0x71},
        {0xF0, 0x73},{0xF1, 0x75},{0xF2, 0x77},{0xF3, 0x79},{0xF4, 0x7B},{0xF5, 0x7D},{0xF6, 0x7F},{0xF7, 0x81},{0xF8, 0x83},{0xF9, 0x84},
        {0xFA, 0x86},{0xFB, 0x87},{0xFC, 0x89},{0xFD, 0x8B},{0xFE, 0x8E},{0xFF, 0x90},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x55},{0xC1, 0x55},{0xC2, 0x55},{0xC3, 0x55},{0xC4, 0x55},{0xC5, 0x55},{0xC6, 0x55},{0xC7, 0x55},
        {0xC8, 0x55},{0xC9, 0x56},{0xCA, 0x56},{0xCB, 0x57},{0xCC, 0x57},{0xCD, 0x57},{0xCE, 0x58},{0xCF, 0x59},{0xD0, 0x5A},{0xD1, 0x5B},
        {0xD2, 0x5B},{0xD3, 0x5C},{0xD4, 0x5E},{0xD5, 0x5E},{0xD6, 0x60},{0xD7, 0x61},{0xD8, 0x63},{0xD9, 0x64},{0xDA, 0x65},{0xDB, 0x67},
        {0xDC, 0x68},{0xDD, 0x6A},{0xDE, 0x6C},{0xDF, 0x6E},{0xE0, 0x71},{0xE1, 0x73},{0xE2, 0x74},{0xE3, 0x76},{0xE4, 0x78},{0xE5, 0x7A},
        {0xE6, 0x7C},{0xE7, 0x7E},{0xE8, 0x7F},{0xE9, 0x82},{0xEA, 0x83},{0xEB, 0x86},{0xEC, 0x88},{0xED, 0x8B},{0xEE, 0x8C},{0xEF, 0x8F},
        {0xF0, 0x91},{0xF1, 0x93},{0xF2, 0x96},{0xF3, 0x98},{0xF4, 0x9A},{0xF5, 0x9D},{0xF6, 0x9F},{0xF7, 0xA3},{0xF8, 0xA5},{0xF9, 0xA8},
        {0xFA, 0xAA},{0xFB, 0xAC},{0xFC, 0xAF},{0xFD, 0xB2},{0xFE, 0xB6},{0xFF, 0xB8},{0x93, 0x11},{0xC0, 0x5A},{0xC1, 0x5A},{0xC2, 0x5A},
        {0xC3, 0x5A},{0xC4, 0x5A},{0xC5, 0x5A},{0xC6, 0x5B},{0xC7, 0x5B},{0xC8, 0x5B},{0xC9, 0x5B},{0xCA, 0x5C},{0xCB, 0x5D},{0xCC, 0x5E},
        {0xCD, 0x5E},{0xCE, 0x5F},{0xCF, 0x61},{0xD0, 0x62},{0xD1, 0x63},{0xD2, 0x64},{0xD3, 0x66},{0xD4, 0x67},{0xD5, 0x68},{0xD6, 0x6A},
        {0xD7, 0x6C},{0xD8, 0x6E},{0xD9, 0x70},{0xDA, 0x73},{0xDB, 0x74},{0xDC, 0x76},{0xDD, 0x79},{0xDE, 0x7B},{0xDF, 0x7C},{0xE0, 0x7F},
        {0xE1, 0x81},{0xE2, 0x83},{0xE3, 0x85},{0xE4, 0x88},{0xE5, 0x8B},{0xE6, 0x8D},{0xE7, 0x90},{0xE8, 0x91},{0xE9, 0x94},{0xEA, 0x97},
        {0xEB, 0x9A},{0xEC, 0x9C},{0xED, 0x9F},{0xEE, 0xA3},{0xEF, 0xA7},{0xF0, 0xA9},{0xF1, 0xAC},{0xF2, 0xAF},{0xF3, 0xB2},{0xF4, 0xB6},
        {0xF5, 0xBA},{0xF6, 0xBD},{0xF7, 0xC1},{0xF8, 0xC4},{0xF9, 0xC6},{0xFA, 0xC9},{0xFB, 0xCC},{0xFC, 0xCF},{0xFD, 0xD4},{0xFE, 0xD8},
        {0xFF, 0xDC},{0x93, 0x12},{0xC0, 0x37},{0xC1, 0x37},{0xC2, 0x38},{0xC3, 0x38},{0xC4, 0x38},{0xC5, 0x38},{0xC6, 0x38},{0xC7, 0x38},
        {0xC8, 0x38},{0xC9, 0x39},{0xCA, 0x39},{0xCB, 0x3A},{0xCC, 0x3A},{0xCD, 0x3A},{0xCE, 0x3B},{0xCF, 0x3C},{0xD0, 0x3D},{0xD1, 0x3D},
        {0xD2, 0x3E},{0xD3, 0x3F},{0xD4, 0x3F},{0xD5, 0x41},{0xD6, 0x42},{0xD7, 0x43},{0xD8, 0x44},{0xD9, 0x45},{0xDA, 0x47},{0xDB, 0x48},
        {0xDC, 0x49},{0xDD, 0x4B},{0xDE, 0x4C},{0xDF, 0x4D},{0xE0, 0x4E},{0xE1, 0x4F},{0xE2, 0x51},{0xE3, 0x53},{0xE4, 0x55},{0xE5, 0x56},
        {0xE6, 0x57},{0xE7, 0x58},{0xE8, 0x59},{0xE9, 0x5B},{0xEA, 0x5C},{0xEB, 0x5E},{0xEC, 0x5F},{0xED, 0x61},{0xEE, 0x63},{0xEF, 0x64},
        {0xF0, 0x66},{0xF1, 0x68},{0xF2, 0x69},{0xF3, 0x6B},{0xF4, 0x6D},{0xF5, 0x6F},{0xF6, 0x71},{0xF7, 0x73},{0xF8, 0x74},{0xF9, 0x76},
        {0xFA, 0x78},{0xFB, 0x7A},{0xFC, 0x7C},{0xFD, 0x7D},{0xFE, 0x7F},{0xFF, 0x81},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [7] Strong +1
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x67},{0xC1, 0x67},{0xC2, 0x67},{0xC3, 0x67},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x68},{0xC7, 0x68},
        {0xC8, 0x6A},{0xC9, 0x6A},{0xCA, 0x6B},{0xCB, 0x6B},{0xCC, 0x6C},{0xCD, 0x6C},{0xCE, 0x6D},{0xCF, 0x6D},{0xD0, 0x6E},{0xD1, 0x6F},
        {0xD2, 0x71},{0xD3, 0x72},{0xD4, 0x73},{0xD5, 0x75},{0xD6, 0x76},{0xD7, 0x77},{0xD8, 0x7A},{0xD9, 0x7C},{0xDA, 0x7D},{0xDB, 0x7E},
        {0xDC, 0x80},{0xDD, 0x82},{0xDE, 0x84},{0xDF, 0x86},{0xE0, 0x87},{0xE1, 0x89},{0xE2, 0x8D},{0xE3, 0x8F},{0xE4, 0x91},{0xE5, 0x93},
        {0xE6, 0x95},{0xE7, 0x97},{0xE8, 0x98},{0xE9, 0x9A},{0xEA, 0x9D},{0xEB, 0x9F},{0xEC, 0xA2},{0xED, 0xA4},{0xEE, 0xA7},{0xEF, 0xAA},
        {0xF0, 0xAC},{0xF1, 0xAE},{0xF2, 0xB0},{0xF3, 0xB3},{0xF4, 0xB6},{0xF5, 0xB8},{0xF6, 0xBC},{0xF7, 0xBF},{0xF8, 0xC1},{0xF9, 0xC3},
        {0xFA, 0xC6},{0xFB, 0xC7},{0xFC, 0xCA},{0xFD, 0xCD},{0xFE, 0xCE},{0xFF, 0xD1},{0x93, 0x09},{0xC0, 0x70},{0xC1, 0x70},{0xC2, 0x70},
        {0xC3, 0x70},{0xC4, 0x70},{0xC5, 0x70},{0xC6, 0x70},{0xC7, 0x71},{0xC8, 0x71},{0xC9, 0x72},{0xCA, 0x72},{0xCB, 0x73},{0xCC, 0x74},
        {0xCD, 0x75},{0xCE, 0x76},{0xCF, 0x77},{0xD0, 0x7A},{0xD1, 0x7B},{0xD2, 0x7C},{0xD3, 0x7E},{0xD4, 0x7F},{0xD5, 0x80},{0xD6, 0x82},
        {0xD7, 0x84},{0xD8, 0x86},{0xD9, 0x87},{0xDA, 0x89},{0xDB, 0x8B},{0xDC, 0x8F},{0xDD, 0x91},{0xDE, 0x93},{0xDF, 0x95},{0xE0, 0x97},
        {0xE1, 0x99},{0xE2, 0x9C},{0xE3, 0x9F},{0xE4, 0xA1},{0xE5, 0xA4},{0xE6, 0xA7},{0xE7, 0xA9},{0xE8, 0xAC},{0xE9, 0xAE},{0xEA, 0xB1},
        {0xEB, 0xB4},{0xEC, 0xB7},{0xED, 0xBB},{0xEE, 0xBE},{0xEF, 0xC2},{0xF0, 0xC4},{0xF1, 0xC6},{0xF2, 0xC9},{0xF3, 0xCC},{0xF4, 0xCE},
        {0xF5, 0xD1},{0xF6, 0xD4},{0xF7, 0xD7},{0xF8, 0xDA},{0xF9, 0xDD},{0xFA, 0xE0},{0xFB, 0xE2},{0xFC, 0xE5},{0xFD, 0xE8},{0xFE, 0xEB},
        {0xFF, 0xEE},{0x93, 0x0A},{0xC0, 0x42},{0xC1, 0x42},{0xC2, 0x42},{0xC3, 0x42},{0xC4, 0x42},{0xC5, 0x42},{0xC6, 0x42},{0xC7, 0x43},
        {0xC8, 0x43},{0xC9, 0x45},{0xCA, 0x45},{0xCB, 0x46},{0xCC, 0x46},{0xCD, 0x47},{0xCE, 0x48},{0xCF, 0x49},{0xD0, 0x4A},{0xD1, 0x4A},
        {0xD2, 0x4B},{0xD3, 0x4C},{0xD4, 0x4E},{0xD5, 0x4F},{0xD6, 0x50},{0xD7, 0x52},{0xD8, 0x52},{0xD9, 0x54},{0xDA, 0x55},{0xDB, 0x57},
        {0xDC, 0x58},{0xDD, 0x5A},{0xDE, 0x5B},{0xDF, 0x5D},{0xE0, 0x5F},{0xE1, 0x61},{0xE2, 0x63},{0xE3, 0x65},{0xE4, 0x66},{0xE5, 0x68},
        {0xE6, 0x6B},{0xE7, 0x6D},{0xE8, 0x6E},{0xE9, 0x6F},{0xEA, 0x71},{0xEB, 0x73},{0xEC, 0x75},{0xED, 0x77},{0xEE, 0x7A},{0xEF, 0x7D},
        {0xF0, 0x7E},{0xF1, 0x80},{0xF2, 0x82},{0xF3, 0x84},{0xF4, 0x86},{0xF5, 0x87},{0xF6, 0x89},{0xF7, 0x8B},{0xF8, 0x8E},{0xF9, 0x90},
        {0xFA, 0x92},{0xFB, 0x95},{0xFC, 0x96},{0xFD, 0x97},{0xFE, 0x99},{0xFF, 0x9B},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x60},{0xC1, 0x60},{0xC2, 0x60},{0xC3, 0x60},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x61},{0xC7, 0x61},
        {0xC8, 0x62},{0xC9, 0x62},{0xCA, 0x62},{0xCB, 0x62},{0xCC, 0x63},{0xCD, 0x63},{0xCE, 0x64},{0xCF, 0x65},{0xD0, 0x66},{0xD1, 0x67},
        {0xD2, 0x69},{0xD3, 0x6A},{0xD4, 0x6B},{0xD5, 0x6D},{0xD6, 0x6E},{0xD7, 0x6F},{0xD8, 0x71},{0xD9, 0x73},{0xDA, 0x74},{0xDB, 0x76},
        {0xDC, 0x78},{0xDD, 0x7A},{0xDE, 0x7C},{0xDF, 0x7E},{0xE0, 0x80},{0xE1, 0x82},{0xE2, 0x84},{0xE3, 0x86},{0xE4, 0x87},{0xE5, 0x89},
        {0xE6, 0x8B},{0xE7, 0x8E},{0xE8, 0x90},{0xE9, 0x91},{0xEA, 0x94},{0xEB, 0x96},{0xEC, 0x99},{0xED, 0x9B},{0xEE, 0x9E},{0xEF, 0xA1},
        {0xF0, 0xA3},{0xF1, 0xA5},{0xF2, 0xA7},{0xF3, 0xAA},{0xF4, 0xAD},{0xF5, 0xAF},{0xF6, 0xB2},{0xF7, 0xB6},{0xF8, 0xB8},{0xF9, 0xBB},
        {0xFA, 0xBE},{0xFB, 0xC0},{0xFC, 0xC3},{0xFD, 0xC5},{0xFE, 0xC7},{0xFF, 0xCA},{0x93, 0x0D},{0xC0, 0x68},{0xC1, 0x68},{0xC2, 0x68},
        {0xC3, 0x68},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x68},{0xC7, 0x69},{0xC8, 0x69},{0xC9, 0x6A},{0xCA, 0x6A},{0xCB, 0x6B},{0xCC, 0x6C},
        {0xCD, 0x6D},{0xCE, 0x6E},{0xCF, 0x6F},{0xD0, 0x71},{0xD1, 0x72},{0xD2, 0x73},{0xD3, 0x75},{0xD4, 0x77},{0xD5, 0x78},{0xD6, 0x7A},
        {0xD7, 0x7C},{0xD8, 0x7E},{0xD9, 0x80},{0xDA, 0x82},{0xDB, 0x83},{0xDC, 0x86},{0xDD, 0x87},{0xDE, 0x89},{0xDF, 0x8C},{0xE0, 0x8F},
        {0xE1, 0x90},{0xE2, 0x93},{0xE3, 0x96},{0xE4, 0x98},{0xE5, 0x9B},{0xE6, 0x9E},{0xE7, 0xA0},{0xE8, 0xA3},{0xE9, 0xA5},{0xEA, 0xA8},
        {0xEB, 0xAB},{0xEC, 0xAE},{0xED, 0xB1},{0xEE, 0xB5},{0xEF, 0xB9},{0xF0, 0xBC},{0xF1, 0xBF},{0xF2, 0xC2},{0xF3, 0xC4},{0xF4, 0xC7},
        {0xF5, 0xCA},{0xF6, 0xCC},{0xF7, 0xCF},{0xF8, 0xD2},{0xF9, 0xD7},{0xFA, 0xDA},{0xFB, 0xDD},{0xFC, 0xE0},{0xFD, 0xE3},{0xFE, 0xE7},
        {0xFF, 0xEB},{0x93, 0x0E},{0xC0, 0x3F},{0xC1, 0x3F},{0xC2, 0x3F},{0xC3, 0x3F},{0xC4, 0x3F},{0xC5, 0x3F},{0xC6, 0x3F},{0xC7, 0x40},
        {0xC8, 0x40},{0xC9, 0x41},{0xCA, 0x41},{0xCB, 0x41},{0xCC, 0x41},{0xCD, 0x42},{0xCE, 0x43},{0xCF, 0x44},{0xD0, 0x45},{0xD1, 0x46},
        {0xD2, 0x47},{0xD3, 0x48},{0xD4, 0x4A},{0xD5, 0x4B},{0xD6, 0x4C},{0xD7, 0x4D},{0xD8, 0x4E},{0xD9, 0x50},{0xDA, 0x51},{0xDB, 0x52},
        {0xDC, 0x53},{0xDD, 0x55},{0xDE, 0x56},{0xDF, 0x57},{0xE0, 0x59},{0xE1, 0x5A},{0xE2, 0x5C},{0xE3, 0x5D},{0xE4, 0x5F},{0xE5, 0x61},
        {0xE6, 0x62},{0xE7, 0x64},{0xE8, 0x66},{0xE9, 0x67},{0xEA, 0x69},{0xEB, 0x6B},{0xEC, 0x6D},{0xED, 0x6F},{0xEE, 0x71},{0xEF, 0x74},
        {0xF0, 0x76},{0xF1, 0x78},{0xF2, 0x7A},{0xF3, 0x7C},{0xF4, 0x7E},{0xF5, 0x80},{0xF6, 0x82},{0xF7, 0x83},{0xF8, 0x85},{0xF9, 0x87},
        {0xFA, 0x88},{0xFB, 0x8B},{0xFC, 0x8D},{0xFD, 0x8F},{0xFE, 0x90},{0xFF, 0x92},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x57},{0xC1, 0x57},{0xC2, 0x57},{0xC3, 0x57},{0xC4, 0x57},{0xC5, 0x57},{0xC6, 0x57},{0xC7, 0x57},
        {0xC8, 0x58},{0xC9, 0x58},{0xCA, 0x59},{0xCB, 0x59},{0xCC, 0x59},{0xCD, 0x59},{0xCE, 0x5A},{0xCF, 0x5B},{0xD0, 0x5B},{0xD1, 0x5C},
        {0xD2, 0x5E},{0xD3, 0x5E},{0xD4, 0x5F},{0xD5, 0x61},{0xD6, 0x62},{0xD7, 0x63},{0xD8, 0x64},{0xD9, 0x66},{0xDA, 0x67},{0xDB, 0x68},
        {0xDC, 0x6A},{0xDD, 0x6C},{0xDE, 0x6E},{0xDF, 0x70},{0xE0, 0x72},{0xE1, 0x74},{0xE2, 0x76},{0xE3, 0x78},{0xE4, 0x7A},{0xE5, 0x7C},
        {0xE6, 0x7D},{0xE7, 0x7F},{0xE8, 0x81},{0xE9, 0x83},{0xEA, 0x85},{0xEB, 0x87},{0xEC, 0x8A},{0xED, 0x8B},{0xEE, 0x8E},{0xEF, 0x90},
        {0xF0, 0x92},{0xF1, 0x95},{0xF2, 0x97},{0xF3, 0x9A},{0xF4, 0x9C},{0xF5, 0x9E},{0xF6, 0xA1},{0xF7, 0xA5},{0xF8, 0xA7},{0xF9, 0xA9},
        {0xFA, 0xAC},{0xFB, 0xAE},{0xFC, 0xB1},{0xFD, 0xB5},{0xFE, 0xB7},{0xFF, 0xBB},{0x93, 0x11},{0xC0, 0x5D},{0xC1, 0x5D},{0xC2, 0x5D},
        {0xC3, 0x5D},{0xC4, 0x5D},{0xC5, 0x5D},{0xC6, 0x5D},{0xC7, 0x5E},{0xC8, 0x5E},{0xC9, 0x5E},{0xCA, 0x5E},{0xCB, 0x5F},{0xCC, 0x60},
        {0xCD, 0x61},{0xCE, 0x62},{0xCF, 0x63},{0xD0, 0x64},{0xD1, 0x65},{0xD2, 0x66},{0xD3, 0x68},{0xD4, 0x69},{0xD5, 0x6A},{0xD6, 0x6C},
        {0xD7, 0x6E},{0xD8, 0x70},{0xD9, 0x72},{0xDA, 0x74},{0xDB, 0x75},{0xDC, 0x78},{0xDD, 0x7A},{0xDE, 0x7C},{0xDF, 0x7E},{0xE0, 0x80},
        {0xE1, 0x82},{0xE2, 0x84},{0xE3, 0x87},{0xE4, 0x89},{0xE5, 0x8B},{0xE6, 0x8E},{0xE7, 0x90},{0xE8, 0x92},{0xE9, 0x95},{0xEA, 0x98},
        {0xEB, 0x9A},{0xEC, 0x9D},{0xED, 0xA0},{0xEE, 0xA4},{0xEF, 0xA8},{0xF0, 0xAA},{0xF1, 0xAD},{0xF2, 0xB0},{0xF3, 0xB4},{0xF4, 0xB7},
        {0xF5, 0xBB},{0xF6, 0xBE},{0xF7, 0xC1},{0xF8, 0xC4},{0xF9, 0xC7},{0xFA, 0xCA},{0xFB, 0xCD},{0xFC, 0xD1},{0xFD, 0xD4},{0xFE, 0xD9},
        {0xFF, 0xDE},{0x93, 0x12},{0xC0, 0x3A},{0xC1, 0x3A},{0xC2, 0x3A},{0xC3, 0x3A},{0xC4, 0x3A},{0xC5, 0x3A},{0xC6, 0x3A},{0xC7, 0x3A},
        {0xC8, 0x3A},{0xC9, 0x3B},{0xCA, 0x3B},{0xCB, 0x3C},{0xCC, 0x3C},{0xCD, 0x3C},{0xCE, 0x3D},{0xCF, 0x3D},{0xD0, 0x3E},{0xD1, 0x3F},
        {0xD2, 0x3F},{0xD3, 0x40},{0xD4, 0x42},{0xD5, 0x43},{0xD6, 0x43},{0xD7, 0x45},{0xD8, 0x46},{0xD9, 0x48},{0xDA, 0x48},{0xDB, 0x4A},
        {0xDC, 0x4B},{0xDD, 0x4C},{0xDE, 0x4D},{0xDF, 0x4F},{0xE0, 0x50},{0xE1, 0x51},{0xE2, 0x53},{0xE3, 0x55},{0xE4, 0x56},{0xE5, 0x57},
        {0xE6, 0x59},{0xE7, 0x5A},{0xE8, 0x5B},{0xE9, 0x5C},{0xEA, 0x5E},{0xEB, 0x5F},{0xEC, 0x61},{0xED, 0x63},{0xEE, 0x64},{0xEF, 0x67},
        {0xF0, 0x68},{0xF1, 0x6A},{0xF2, 0x6C},{0xF3, 0x6E},{0xF4, 0x70},{0xF5, 0x72},{0xF6, 0x74},{0xF7, 0x75},{0xF8, 0x77},{0xF9, 0x79},
        {0xFA, 0x7B},{0xFB, 0x7D},{0xFC, 0x7F},{0xFD, 0x80},{0xFE, 0x82},{0xFF, 0x83},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [8] Strong +2
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x6C},{0xC1, 0x6C},{0xC2, 0x6C},{0xC3, 0x6C},{0xC4, 0x6C},{0xC5, 0x6C},{0xC6, 0x6D},{0xC7, 0x6D},
        {0xC8, 0x6D},{0xC9, 0x6D},{0xCA, 0x6D},{0xCB, 0x6D},{0xCC, 0x6E},{0xCD, 0x6F},{0xCE, 0x6F},{0xCF, 0x70},{0xD0, 0x71},{0xD1, 0x72},
        {0xD2, 0x73},{0xD3, 0x74},{0xD4, 0x76},{0xD5, 0x77},{0xD6, 0x79},{0xD7, 0x7B},{0xD8, 0x7C},{0xD9, 0x7E},{0xDA, 0x7E},{0xDB, 0x80},
        {0xDC, 0x82},{0xDD, 0x84},{0xDE, 0x86},{0xDF, 0x87},{0xE0, 0x89},{0xE1, 0x8B},{0xE2, 0x8E},{0xE3, 0x90},{0xE4, 0x92},{0xE5, 0x95},
        {0xE6, 0x96},{0xE7, 0x97},{0xE8, 0x9A},{0xE9, 0x9C},{0xEA, 0x9E},{0xEB, 0xA1},{0xEC, 0xA3},{0xED, 0xA6},{0xEE, 0xA8},{0xEF, 0xAB},
        {0xF0, 0xAD},{0xF1, 0xAF},{0xF2, 0xB2},{0xF3, 0xB5},{0xF4, 0xB7},{0xF5, 0xBB},{0xF6, 0xBD},{0xF7, 0xC0},{0xF8, 0xC3},{0xF9, 0xC4},
        {0xFA, 0xC6},{0xFB, 0xC9},{0xFC, 0xCC},{0xFD, 0xCE},{0xFE, 0xD0},{0xFF, 0xD3},{0x93, 0x09},{0xC0, 0x73},{0xC1, 0x73},{0xC2, 0x73},
        {0xC3, 0x73},{0xC4, 0x74},{0xC5, 0x74},{0xC6, 0x74},{0xC7, 0x74},{0xC8, 0x75},{0xC9, 0x75},{0xCA, 0x76},{0xCB, 0x76},{0xCC, 0x77},
        {0xCD, 0x79},{0xCE, 0x7A},{0xCF, 0x7B},{0xD0, 0x7C},{0xD1, 0x7E},{0xD2, 0x7E},{0xD3, 0x7F},{0xD4, 0x81},{0xD5, 0x82},{0xD6, 0x84},
        {0xD7, 0x86},{0xD8, 0x87},{0xD9, 0x89},{0xDA, 0x8B},{0xDB, 0x8E},{0xDC, 0x90},{0xDD, 0x92},{0xDE, 0x95},{0xDF, 0x96},{0xE0, 0x98},
        {0xE1, 0x9A},{0xE2, 0x9D},{0xE3, 0xA0},{0xE4, 0xA2},{0xE5, 0xA5},{0xE6, 0xA8},{0xE7, 0xAA},{0xE8, 0xAC},{0xE9, 0xAF},{0xEA, 0xB2},
        {0xEB, 0xB5},{0xEC, 0xB8},{0xED, 0xBC},{0xEE, 0xBF},{0xEF, 0xC2},{0xF0, 0xC4},{0xF1, 0xC6},{0xF2, 0xC9},{0xF3, 0xCC},{0xF4, 0xCF},
        {0xF5, 0xD2},{0xF6, 0xD5},{0xF7, 0xD8},{0xF8, 0xDB},{0xF9, 0xDD},{0xFA, 0xE1},{0xFB, 0xE3},{0xFC, 0xE6},{0xFD, 0xE8},{0xFE, 0xEB},
        {0xFF, 0xEF},{0x93, 0x0A},{0xC0, 0x46},{0xC1, 0x46},{0xC2, 0x46},{0xC3, 0x46},{0xC4, 0x46},{0xC5, 0x46},{0xC6, 0x47},{0xC7, 0x47},
        {0xC8, 0x47},{0xC9, 0x48},{0xCA, 0x48},{0xCB, 0x49},{0xCC, 0x49},{0xCD, 0x4A},{0xCE, 0x4A},{0xCF, 0x4B},{0xD0, 0x4C},{0xD1, 0x4D},
        {0xD2, 0x4E},{0xD3, 0x4F},{0xD4, 0x50},{0xD5, 0x51},{0xD6, 0x52},{0xD7, 0x53},{0xD8, 0x54},{0xD9, 0x56},{0xDA, 0x57},{0xDB, 0x59},
        {0xDC, 0x5B},{0xDD, 0x5B},{0xDE, 0x5D},{0xDF, 0x5F},{0xE0, 0x62},{0xE1, 0x64},{0xE2, 0x65},{0xE3, 0x66},{0xE4, 0x68},{0xE5, 0x6B},
        {0xE6, 0x6D},{0xE7, 0x6E},{0xE8, 0x70},{0xE9, 0x72},{0xEA, 0x74},{0xEB, 0x76},{0xEC, 0x79},{0xED, 0x7B},{0xEE, 0x7D},{0xEF, 0x7E},
        {0xF0, 0x80},{0xF1, 0x82},{0xF2, 0x85},{0xF3, 0x87},{0xF4, 0x88},{0xF5, 0x8A},{0xF6, 0x8D},{0xF7, 0x8F},{0xF8, 0x91},{0xF9, 0x93},
        {0xFA, 0x95},{0xFB, 0x97},{0xFC, 0x98},{0xFD, 0x9A},{0xFE, 0x9C},{0xFF, 0x9E},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x63},{0xC1, 0x63},{0xC2, 0x63},{0xC3, 0x63},{0xC4, 0x63},{0xC5, 0x63},{0xC6, 0x64},{0xC7, 0x64},
        {0xC8, 0x64},{0xC9, 0x64},{0xCA, 0x65},{0xCB, 0x65},{0xCC, 0x66},{0xCD, 0x67},{0xCE, 0x67},{0xCF, 0x68},{0xD0, 0x69},{0xD1, 0x6A},
        {0xD2, 0x6B},{0xD3, 0x6C},{0xD4, 0x6E},{0xD5, 0x6F},{0xD6, 0x70},{0xD7, 0x72},{0xD8, 0x73},{0xD9, 0x75},{0xDA, 0x76},{0xDB, 0x78},
        {0xDC, 0x7A},{0xDD, 0x7C},{0xDE, 0x7E},{0xDF, 0x80},{0xE0, 0x82},{0xE1, 0x83},{0xE2, 0x85},{0xE3, 0x87},{0xE4, 0x88},{0xE5, 0x8B},
        {0xE6, 0x8D},{0xE7, 0x8F},{0xE8, 0x91},{0xE9, 0x93},{0xEA, 0x95},{0xEB, 0x98},{0xEC, 0x9A},{0xED, 0x9D},{0xEE, 0x9F},{0xEF, 0xA2},
        {0xF0, 0xA5},{0xF1, 0xA6},{0xF2, 0xA9},{0xF3, 0xAC},{0xF4, 0xAE},{0xF5, 0xB1},{0xF6, 0xB3},{0xF7, 0xB7},{0xF8, 0xBA},{0xF9, 0xBC},
        {0xFA, 0xBF},{0xFB, 0xC2},{0xFC, 0xC4},{0xFD, 0xC6},{0xFE, 0xC9},{0xFF, 0xCB},{0x93, 0x0D},{0xC0, 0x6B},{0xC1, 0x6B},{0xC2, 0x6B},
        {0xC3, 0x6B},{0xC4, 0x6C},{0xC5, 0x6C},{0xC6, 0x6C},{0xC7, 0x6C},{0xC8, 0x6D},{0xC9, 0x6D},{0xCA, 0x6E},{0xCB, 0x6E},{0xCC, 0x6F},
        {0xCD, 0x70},{0xCE, 0x71},{0xCF, 0x72},{0xD0, 0x73},{0xD1, 0x75},{0xD2, 0x76},{0xD3, 0x77},{0xD4, 0x79},{0xD5, 0x7A},{0xD6, 0x7C},
        {0xD7, 0x7E},{0xD8, 0x80},{0xD9, 0x82},{0xDA, 0x83},{0xDB, 0x85},{0xDC, 0x87},{0xDD, 0x88},{0xDE, 0x8B},{0xDF, 0x8D},{0xE0, 0x90},
        {0xE1, 0x91},{0xE2, 0x94},{0xE3, 0x97},{0xE4, 0x99},{0xE5, 0x9C},{0xE6, 0x9F},{0xE7, 0xA1},{0xE8, 0xA4},{0xE9, 0xA6},{0xEA, 0xA9},
        {0xEB, 0xAC},{0xEC, 0xAF},{0xED, 0xB2},{0xEE, 0xB6},{0xEF, 0xB9},{0xF0, 0xBC},{0xF1, 0xBF},{0xF2, 0xC2},{0xF3, 0xC4},{0xF4, 0xC8},
        {0xF5, 0xCB},{0xF6, 0xCD},{0xF7, 0xD0},{0xF8, 0xD4},{0xF9, 0xD7},{0xFA, 0xDB},{0xFB, 0xDE},{0xFC, 0xE1},{0xFD, 0xE4},{0xFE, 0xE7},
        {0xFF, 0xEC},{0x93, 0x0E},{0xC0, 0x41},{0xC1, 0x41},{0xC2, 0x41},{0xC3, 0x41},{0xC4, 0x41},{0xC5, 0x41},{0xC6, 0x42},{0xC7, 0x42},
        {0xC8, 0x42},{0xC9, 0x43},{0xCA, 0x43},{0xCB, 0x44},{0xCC, 0x44},{0xCD, 0x45},{0xCE, 0x46},{0xCF, 0x47},{0xD0, 0x48},{0xD1, 0x49},
        {0xD2, 0x4A},{0xD3, 0x4B},{0xD4, 0x4C},{0xD5, 0x4D},{0xD6, 0x4E},{0xD7, 0x4F},{0xD8, 0x50},{0xD9, 0x52},{0xDA, 0x52},{0xDB, 0x54},
        {0xDC, 0x55},{0xDD, 0x56},{0xDE, 0x57},{0xDF, 0x59},{0xE0, 0x5B},{0xE1, 0x5D},{0xE2, 0x5D},{0xE3, 0x5F},{0xE4, 0x61},{0xE5, 0x62},
        {0xE6, 0x64},{0xE7, 0x66},{0xE8, 0x68},{0xE9, 0x6A},{0xEA, 0x6C},{0xEB, 0x6E},{0xEC, 0x70},{0xED, 0x72},{0xEE, 0x74},{0xEF, 0x76},
        {0xF0, 0x78},{0xF1, 0x7A},{0xF2, 0x7D},{0xF3, 0x7F},{0xF4, 0x81},{0xF5, 0x83},{0xF6, 0x84},{0xF7, 0x86},{0xF8, 0x87},{0xF9, 0x89},
        {0xFA, 0x8B},{0xFB, 0x8E},{0xFC, 0x90},{0xFD, 0x91},{0xFE, 0x93},{0xFF, 0x95},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x59},{0xC1, 0x59},{0xC2, 0x59},{0xC3, 0x59},{0xC4, 0x59},{0xC5, 0x59},{0xC6, 0x5A},{0xC7, 0x5A},
        {0xC8, 0x5A},{0xC9, 0x5A},{0xCA, 0x5B},{0xCB, 0x5B},{0xCC, 0x5B},{0xCD, 0x5C},{0xCE, 0x5C},{0xCF, 0x5D},{0xD0, 0x5E},{0xD1, 0x5E},
        {0xD2, 0x5F},{0xD3, 0x60},{0xD4, 0x62},{0xD5, 0x63},{0xD6, 0x63},{0xD7, 0x65},{0xD8, 0x66},{0xD9, 0x68},{0xDA, 0x68},{0xDB, 0x6A},
        {0xDC, 0x6C},{0xDD, 0x6E},{0xDE, 0x70},{0xDF, 0x72},{0xE0, 0x74},{0xE1, 0x75},{0xE2, 0x77},{0xE3, 0x79},{0xE4, 0x7B},{0xE5, 0x7D},
        {0xE6, 0x7F},{0xE7, 0x80},{0xE8, 0x83},{0xE9, 0x84},{0xEA, 0x86},{0xEB, 0x89},{0xEC, 0x8B},{0xED, 0x8D},{0xEE, 0x8F},{0xEF, 0x91},
        {0xF0, 0x94},{0xF1, 0x96},{0xF2, 0x99},{0xF3, 0x9B},{0xF4, 0x9D},{0xF5, 0xA0},{0xF6, 0xA3},{0xF7, 0xA6},{0xF8, 0xA8},{0xF9, 0xAA},
        {0xFA, 0xAD},{0xFB, 0xB0},{0xFC, 0xB4},{0xFD, 0xB6},{0xFE, 0xBA},{0xFF, 0xBD},{0x93, 0x11},{0xC0, 0x5F},{0xC1, 0x5F},{0xC2, 0x5F},
        {0xC3, 0x5F},{0xC4, 0x60},{0xC5, 0x60},{0xC6, 0x60},{0xC7, 0x60},{0xC8, 0x61},{0xC9, 0x61},{0xCA, 0x62},{0xCB, 0x62},{0xCC, 0x63},
        {0xCD, 0x63},{0xCE, 0x64},{0xCF, 0x65},{0xD0, 0x66},{0xD1, 0x68},{0xD2, 0x68},{0xD3, 0x69},{0xD4, 0x6B},{0xD5, 0x6C},{0xD6, 0x6E},
        {0xD7, 0x70},{0xD8, 0x72},{0xD9, 0x74},{0xDA, 0x75},{0xDB, 0x77},{0xDC, 0x79},{0xDD, 0x7B},{0xDE, 0x7D},{0xDF, 0x7F},{0xE0, 0x81},
        {0xE1, 0x83},{0xE2, 0x85},{0xE3, 0x88},{0xE4, 0x8A},{0xE5, 0x8C},{0xE6, 0x8F},{0xE7, 0x90},{0xE8, 0x93},{0xE9, 0x96},{0xEA, 0x99},
        {0xEB, 0x9B},{0xEC, 0x9E},{0xED, 0xA1},{0xEE, 0xA5},{0xEF, 0xA8},{0xF0, 0xAA},{0xF1, 0xAD},{0xF2, 0xB0},{0xF3, 0xB4},{0xF4, 0xB8},
        {0xF5, 0xBC},{0xF6, 0xBF},{0xF7, 0xC2},{0xF8, 0xC5},{0xF9, 0xC7},{0xFA, 0xCB},{0xFB, 0xCE},{0xFC, 0xD2},{0xFD, 0xD5},{0xFE, 0xD9},
        {0xFF, 0xDF},{0x93, 0x12},{0xC0, 0x3C},{0xC1, 0x3C},{0xC2, 0x3C},{0xC3, 0x3C},{0xC4, 0x3C},{0xC5, 0x3C},{0xC6, 0x3C},{0xC7, 0x3C},
        {0xC8, 0x3C},{0xC9, 0x3D},{0xCA, 0x3D},{0xCB, 0x3D},{0xCC, 0x3D},{0xCD, 0x3E},{0xCE, 0x3F},{0xCF, 0x3F},{0xD0, 0x40},{0xD1, 0x41},
        {0xD2, 0x42},{0xD3, 0x43},{0xD4, 0x43},{0xD5, 0x44},{0xD6, 0x46},{0xD7, 0x47},{0xD8, 0x48},{0xD9, 0x49},{0xDA, 0x4A},{0xDB, 0x4B},
        {0xDC, 0x4D},{0xDD, 0x4D},{0xDE, 0x4F},{0xDF, 0x50},{0xE0, 0x52},{0xE1, 0x54},{0xE2, 0x55},{0xE3, 0x56},{0xE4, 0x57},{0xE5, 0x59},
        {0xE6, 0x5A},{0xE7, 0x5B},{0xE8, 0x5D},{0xE9, 0x5E},{0xEA, 0x60},{0xEB, 0x62},{0xEC, 0x63},{0xED, 0x65},{0xEE, 0x67},{0xEF, 0x68},
        {0xF0, 0x6A},{0xF1, 0x6C},{0xF2, 0x6F},{0xF3, 0x71},{0xF4, 0x73},{0xF5, 0x74},{0xF6, 0x76},{0xF7, 0x78},{0xF8, 0x7A},{0xF9, 0x7C},
        {0xFA, 0x7D},{0xFB, 0x7F},{0xFC, 0x81},{0xFD, 0x83},{0xFE, 0x84},{0xFF, 0x86},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [9] Strong +3
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x6F},{0xC1, 0x6F},{0xC2, 0x6F},{0xC3, 0x6F},{0xC4, 0x6F},{0xC5, 0x6F},{0xC6, 0x6F},{0xC7, 0x6F},
        {0xC8, 0x6F},{0xC9, 0x70},{0xCA, 0x70},{0xCB, 0x71},{0xCC, 0x71},{0xCD, 0x72},{0xCE, 0x72},{0xCF, 0x73},{0xD0, 0x74},{0xD1, 0x75},
        {0xD2, 0x76},{0xD3, 0x77},{0xD4, 0x79},{0xD5, 0x7A},{0xD6, 0x7C},{0xD7, 0x7D},{0xD8, 0x7E},{0xD9, 0x7F},{0xDA, 0x80},{0xDB, 0x82},
        {0xDC, 0x84},{0xDD, 0x86},{0xDE, 0x87},{0xDF, 0x88},{0xE0, 0x8B},{0xE1, 0x8E},{0xE2, 0x90},{0xE3, 0x92},{0xE4, 0x94},{0xE5, 0x95},
        {0xE6, 0x97},{0xE7, 0x99},{0xE8, 0x9B},{0xE9, 0x9D},{0xEA, 0xA0},{0xEB, 0xA2},{0xEC, 0xA5},{0xED, 0xA7},{0xEE, 0xAA},{0xEF, 0xAC},
        {0xF0, 0xAE},{0xF1, 0xB1},{0xF2, 0xB3},{0xF3, 0xB6},{0xF4, 0xB9},{0xF5, 0xBC},{0xF6, 0xBF},{0xF7, 0xC2},{0xF8, 0xC3},{0xF9, 0xC6},
        {0xFA, 0xC8},{0xFB, 0xCA},{0xFC, 0xCD},{0xFD, 0xCF},{0xFE, 0xD2},{0xFF, 0xD5},{0x93, 0x09},{0xC0, 0x77},{0xC1, 0x77},{0xC2, 0x77},
        {0xC3, 0x77},{0xC4, 0x77},{0xC5, 0x77},{0xC6, 0x77},{0xC7, 0x79},{0xC8, 0x79},{0xC9, 0x79},{0xCA, 0x7A},{0xCB, 0x7A},{0xCC, 0x7B},
        {0xCD, 0x7C},{0xCE, 0x7D},{0xCF, 0x7E},{0xD0, 0x7E},{0xD1, 0x7F},{0xD2, 0x80},{0xD3, 0x82},{0xD4, 0x83},{0xD5, 0x84},{0xD6, 0x86},
        {0xD7, 0x87},{0xD8, 0x89},{0xD9, 0x8A},{0xDA, 0x8D},{0xDB, 0x8F},{0xDC, 0x91},{0xDD, 0x94},{0xDE, 0x95},{0xDF, 0x97},{0xE0, 0x99},
        {0xE1, 0x9C},{0xE2, 0x9E},{0xE3, 0xA1},{0xE4, 0xA3},{0xE5, 0xA6},{0xE6, 0xA8},{0xE7, 0xAB},{0xE8, 0xAD},{0xE9, 0xB0},{0xEA, 0xB3},
        {0xEB, 0xB5},{0xEC, 0xB8},{0xED, 0xBC},{0xEE, 0xBF},{0xEF, 0xC3},{0xF0, 0xC5},{0xF1, 0xC7},{0xF2, 0xCA},{0xF3, 0xCD},{0xF4, 0xCF},
        {0xF5, 0xD2},{0xF6, 0xD5},{0xF7, 0xD9},{0xF8, 0xDC},{0xF9, 0xDE},{0xFA, 0xE1},{0xFB, 0xE3},{0xFC, 0xE7},{0xFD, 0xE9},{0xFE, 0xEC},
        {0xFF, 0xEF},{0x93, 0x0A},{0xC0, 0x49},{0xC1, 0x49},{0xC2, 0x49},{0xC3, 0x49},{0xC4, 0x4A},{0xC5, 0x4A},{0xC6, 0x4A},{0xC7, 0x4A},
        {0xC8, 0x4A},{0xC9, 0x4A},{0xCA, 0x4A},{0xCB, 0x4B},{0xCC, 0x4B},{0xCD, 0x4C},{0xCE, 0x4C},{0xCF, 0x4D},{0xD0, 0x4E},{0xD1, 0x4F},
        {0xD2, 0x50},{0xD3, 0x51},{0xD4, 0x52},{0xD5, 0x53},{0xD6, 0x54},{0xD7, 0x55},{0xD8, 0x57},{0xD9, 0x58},{0xDA, 0x5A},{0xDB, 0x5B},
        {0xDC, 0x5C},{0xDD, 0x5D},{0xDE, 0x5F},{0xDF, 0x62},{0xE0, 0x64},{0xE1, 0x65},{0xE2, 0x67},{0xE3, 0x68},{0xE4, 0x6B},{0xE5, 0x6D},
        {0xE6, 0x6E},{0xE7, 0x70},{0xE8, 0x72},{0xE9, 0x74},{0xEA, 0x76},{0xEB, 0x79},{0xEC, 0x7B},{0xED, 0x7D},{0xEE, 0x7E},{0xEF, 0x81},
        {0xF0, 0x83},{0xF1, 0x85},{0xF2, 0x87},{0xF3, 0x88},{0xF4, 0x8A},{0xF5, 0x8D},{0xF6, 0x90},{0xF7, 0x92},{0xF8, 0x94},{0xF9, 0x95},
        {0xFA, 0x97},{0xFB, 0x98},{0xFC, 0x9B},{0xFD, 0x9D},{0xFE, 0x9F},{0xFF, 0xA1},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x67},{0xC1, 0x67},{0xC2, 0x67},{0xC3, 0x67},{0xC4, 0x67},{0xC5, 0x67},{0xC6, 0x67},{0xC7, 0x67},
        {0xC8, 0x67},{0xC9, 0x68},{0xCA, 0x68},{0xCB, 0x69},{0xCC, 0x69},{0xCD, 0x6A},{0xCE, 0x6A},{0xCF, 0x6B},{0xD0, 0x6C},{0xD1, 0x6D},
        {0xD2, 0x6E},{0xD3, 0x6F},{0xD4, 0x70},{0xD5, 0x71},{0xD6, 0x73},{0xD7, 0x74},{0xD8, 0x75},{0xD9, 0x77},{0xDA, 0x78},{0xDB, 0x7A},
        {0xDC, 0x7C},{0xDD, 0x7E},{0xDE, 0x7F},{0xDF, 0x81},{0xE0, 0x83},{0xE1, 0x85},{0xE2, 0x87},{0xE3, 0x88},{0xE4, 0x8A},{0xE5, 0x8C},
        {0xE6, 0x8E},{0xE7, 0x90},{0xE8, 0x92},{0xE9, 0x94},{0xEA, 0x97},{0xEB, 0x99},{0xEC, 0x9C},{0xED, 0x9E},{0xEE, 0xA1},{0xEF, 0xA4},
        {0xF0, 0xA5},{0xF1, 0xA8},{0xF2, 0xAA},{0xF3, 0xAD},{0xF4, 0xB0},{0xF5, 0xB2},{0xF6, 0xB6},{0xF7, 0xB9},{0xF8, 0xBB},{0xF9, 0xBE},
        {0xFA, 0xC1},{0xFB, 0xC3},{0xFC, 0xC5},{0xFD, 0xC8},{0xFE, 0xCB},{0xFF, 0xCD},{0x93, 0x0D},{0xC0, 0x6F},{0xC1, 0x6F},{0xC2, 0x6F},
        {0xC3, 0x6F},{0xC4, 0x6F},{0xC5, 0x6F},{0xC6, 0x6F},{0xC7, 0x70},{0xC8, 0x70},{0xC9, 0x70},{0xCA, 0x71},{0xCB, 0x71},{0xCC, 0x72},
        {0xCD, 0x73},{0xCE, 0x74},{0xCF, 0x75},{0xD0, 0x76},{0xD1, 0x77},{0xD2, 0x78},{0xD3, 0x7A},{0xD4, 0x7B},{0xD5, 0x7C},{0xD6, 0x7E},
        {0xD7, 0x80},{0xD8, 0x82},{0xD9, 0x83},{0xDA, 0x84},{0xDB, 0x86},{0xDC, 0x87},{0xDD, 0x8A},{0xDE, 0x8C},{0xDF, 0x8E},{0xE0, 0x90},
        {0xE1, 0x93},{0xE2, 0x95},{0xE3, 0x98},{0xE4, 0x9A},{0xE5, 0x9D},{0xE6, 0x9F},{0xE7, 0xA2},{0xE8, 0xA5},{0xE9, 0xA7},{0xEA, 0xAA},
        {0xEB, 0xAC},{0xEC, 0xAF},{0xED, 0xB2},{0xEE, 0xB6},{0xEF, 0xBA},{0xF0, 0xBD},{0xF1, 0xC0},{0xF2, 0xC3},{0xF3, 0xC5},{0xF4, 0xC8},
        {0xF5, 0xCB},{0xF6, 0xCD},{0xF7, 0xD1},{0xF8, 0xD5},{0xF9, 0xD8},{0xFA, 0xDB},{0xFB, 0xDE},{0xFC, 0xE2},{0xFD, 0xE5},{0xFE, 0xE8},
        {0xFF, 0xEC},{0x93, 0x0E},{0xC0, 0x44},{0xC1, 0x44},{0xC2, 0x44},{0xC3, 0x44},{0xC4, 0x45},{0xC5, 0x45},{0xC6, 0x45},{0xC7, 0x45},
        {0xC8, 0x45},{0xC9, 0x46},{0xCA, 0x46},{0xCB, 0x47},{0xCC, 0x47},{0xCD, 0x48},{0xCE, 0x48},{0xCF, 0x49},{0xD0, 0x4A},{0xD1, 0x4B},
        {0xD2, 0x4C},{0xD3, 0x4D},{0xD4, 0x4D},{0xD5, 0x4F},{0xD6, 0x50},{0xD7, 0x51},{0xD8, 0x52},{0xD9, 0x53},{0xDA, 0x55},{0xDB, 0x55},
        {0xDC, 0x57},{0xDD, 0x57},{0xDE, 0x59},{0xDF, 0x5B},{0xE0, 0x5D},{0xE1, 0x5E},{0xE2, 0x60},{0xE3, 0x61},{0xE4, 0x62},{0xE5, 0x64},
        {0xE6, 0x66},{0xE7, 0x68},{0xE8, 0x6A},{0xE9, 0x6C},{0xEA, 0x6E},{0xEB, 0x70},{0xEC, 0x72},{0xED, 0x74},{0xEE, 0x76},{0xEF, 0x79},
        {0xF0, 0x7B},{0xF1, 0x7D},{0xF2, 0x7F},{0xF3, 0x81},{0xF4, 0x83},{0xF5, 0x84},{0xF6, 0x87},{0xF7, 0x88},{0xF8, 0x8A},{0xF9, 0x8C},
        {0xFA, 0x8E},{0xFB, 0x90},{0xFC, 0x92},{0xFD, 0x94},{0xFE, 0x96},{0xFF, 0x98},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x5C},{0xC1, 0x5C},{0xC2, 0x5C},{0xC3, 0x5C},{0xC4, 0x5C},{0xC5, 0x5C},{0xC6, 0x5C},{0xC7, 0x5C},
        {0xC8, 0x5C},{0xC9, 0x5D},{0xCA, 0x5D},{0xCB, 0x5E},{0xCC, 0x5E},{0xCD, 0x5E},{0xCE, 0x5E},{0xCF, 0x5F},{0xD0, 0x60},{0xD1, 0x61},
        {0xD2, 0x62},{0xD3, 0x63},{0xD4, 0x63},{0xD5, 0x64},{0xD6, 0x66},{0xD7, 0x67},{0xD8, 0x68},{0xD9, 0x69},{0xDA, 0x6A},{0xDB, 0x6C},
        {0xDC, 0x6E},{0xDD, 0x70},{0xDE, 0x71},{0xDF, 0x73},{0xE0, 0x75},{0xE1, 0x77},{0xE2, 0x79},{0xE3, 0x7B},{0xE4, 0x7C},{0xE5, 0x7E},
        {0xE6, 0x7F},{0xE7, 0x82},{0xE8, 0x83},{0xE9, 0x85},{0xEA, 0x88},{0xEB, 0x8A},{0xEC, 0x8C},{0xED, 0x8E},{0xEE, 0x90},{0xEF, 0x93},
        {0xF0, 0x95},{0xF1, 0x98},{0xF2, 0x9A},{0xF3, 0x9C},{0xF4, 0x9F},{0xF5, 0xA1},{0xF6, 0xA5},{0xF7, 0xA8},{0xF8, 0xA9},{0xF9, 0xAC},
        {0xFA, 0xAF},{0xFB, 0xB1},{0xFC, 0xB5},{0xFD, 0xB8},{0xFE, 0xBC},{0xFF, 0xBF},{0x93, 0x11},{0xC0, 0x63},{0xC1, 0x63},{0xC2, 0x63},
        {0xC3, 0x63},{0xC4, 0x63},{0xC5, 0x63},{0xC6, 0x63},{0xC7, 0x63},{0xC8, 0x63},{0xC9, 0x63},{0xCA, 0x64},{0xCB, 0x64},{0xCC, 0x65},
        {0xCD, 0x66},{0xCE, 0x67},{0xCF, 0x68},{0xD0, 0x68},{0xD1, 0x69},{0xD2, 0x6A},{0xD3, 0x6C},{0xD4, 0x6D},{0xD5, 0x6E},{0xD6, 0x70},
        {0xD7, 0x72},{0xD8, 0x74},{0xD9, 0x74},{0xDA, 0x76},{0xDB, 0x78},{0xDC, 0x7A},{0xDD, 0x7C},{0xDE, 0x7E},{0xDF, 0x7F},{0xE0, 0x82},
        {0xE1, 0x84},{0xE2, 0x86},{0xE3, 0x89},{0xE4, 0x8B},{0xE5, 0x8D},{0xE6, 0x8F},{0xE7, 0x91},{0xE8, 0x94},{0xE9, 0x97},{0xEA, 0x9A},
        {0xEB, 0x9B},{0xEC, 0x9E},{0xED, 0xA1},{0xEE, 0xA5},{0xEF, 0xA8},{0xF0, 0xAB},{0xF1, 0xAE},{0xF2, 0xB1},{0xF3, 0xB5},{0xF4, 0xB8},
        {0xF5, 0xBC},{0xF6, 0xBF},{0xF7, 0xC3},{0xF8, 0xC6},{0xF9, 0xC8},{0xFA, 0xCB},{0xFB, 0xCE},{0xFC, 0xD3},{0xFD, 0xD7},{0xFE, 0xDB},
        {0xFF, 0xDF},{0x93, 0x12},{0xC0, 0x3D},{0xC1, 0x3D},{0xC2, 0x3D},{0xC3, 0x3D},{0xC4, 0x3E},{0xC5, 0x3E},{0xC6, 0x3E},{0xC7, 0x3E},
        {0xC8, 0x3E},{0xC9, 0x3F},{0xCA, 0x3F},{0xCB, 0x3F},{0xCC, 0x3F},{0xCD, 0x40},{0xCE, 0x40},{0xCF, 0x41},{0xD0, 0x42},{0xD1, 0x43},
        {0xD2, 0x43},{0xD3, 0x44},{0xD4, 0x45},{0xD5, 0x47},{0xD6, 0x48},{0xD7, 0x48},{0xD8, 0x4A},{0xD9, 0x4B},{0xDA, 0x4C},{0xDB, 0x4D},
        {0xDC, 0x4E},{0xDD, 0x4F},{0xDE, 0x50},{0xDF, 0x52},{0xE0, 0x54},{0xE1, 0x55},{0xE2, 0x57},{0xE3, 0x57},{0xE4, 0x59},{0xE5, 0x5A},
        {0xE6, 0x5B},{0xE7, 0x5D},{0xE8, 0x5E},{0xE9, 0x60},{0xEA, 0x62},{0xEB, 0x63},{0xEC, 0x65},{0xED, 0x67},{0xEE, 0x68},{0xEF, 0x6B},
        {0xF0, 0x6D},{0xF1, 0x6F},{0xF2, 0x71},{0xF3, 0x73},{0xF4, 0x74},{0xF5, 0x76},{0xF6, 0x79},{0xF7, 0x7B},{0xF8, 0x7C},{0xF9, 0x7E},
        {0xFA, 0x7F},{0xFB, 0x81},{0xFC, 0x83},{0xFD, 0x85},{0xFE, 0x87},{0xFF, 0x89},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [10] Strong +4
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x72},{0xC1, 0x72},{0xC2, 0x72},{0xC3, 0x72},{0xC4, 0x72},{0xC5, 0x72},{0xC6, 0x72},{0xC7, 0x72},
        {0xC8, 0x73},{0xC9, 0x73},{0xCA, 0x73},{0xCB, 0x74},{0xCC, 0x74},{0xCD, 0x75},{0xCE, 0x75},{0xCF, 0x76},{0xD0, 0x77},{0xD1, 0x79},
        {0xD2, 0x79},{0xD3, 0x7A},{0xD4, 0x7B},{0xD5, 0x7D},{0xD6, 0x7E},{0xD7, 0x7E},{0xD8, 0x7F},{0xD9, 0x81},{0xDA, 0x82},{0xDB, 0x84},
        {0xDC, 0x86},{0xDD, 0x87},{0xDE, 0x88},{0xDF, 0x8A},{0xE0, 0x8D},{0xE1, 0x8F},{0xE2, 0x91},{0xE3, 0x93},{0xE4, 0x95},{0xE5, 0x97},
        {0xE6, 0x98},{0xE7, 0x9A},{0xE8, 0x9C},{0xE9, 0x9F},{0xEA, 0xA1},{0xEB, 0xA3},{0xEC, 0xA6},{0xED, 0xA8},{0xEE, 0xAB},{0xEF, 0xAD},
        {0xF0, 0xB0},{0xF1, 0xB2},{0xF2, 0xB5},{0xF3, 0xB7},{0xF4, 0xBB},{0xF5, 0xBE},{0xF6, 0xC0},{0xF7, 0xC3},{0xF8, 0xC5},{0xF9, 0xC6},
        {0xFA, 0xC9},{0xFB, 0xCC},{0xFC, 0xCE},{0xFD, 0xD1},{0xFE, 0xD3},{0xFF, 0xD6},{0x93, 0x09},{0xC0, 0x7B},{0xC1, 0x7B},{0xC2, 0x7B},
        {0xC3, 0x7B},{0xC4, 0x7B},{0xC5, 0x7C},{0xC6, 0x7C},{0xC7, 0x7C},{0xC8, 0x7C},{0xC9, 0x7D},{0xCA, 0x7D},{0xCB, 0x7D},{0xCC, 0x7E},
        {0xCD, 0x7E},{0xCE, 0x7E},{0xCF, 0x7F},{0xD0, 0x80},{0xD1, 0x81},{0xD2, 0x83},{0xD3, 0x84},{0xD4, 0x85},{0xD5, 0x86},{0xD6, 0x87},
        {0xD7, 0x89},{0xD8, 0x8A},{0xD9, 0x8D},{0xDA, 0x8F},{0xDB, 0x91},{0xDC, 0x93},{0xDD, 0x95},{0xDE, 0x96},{0xDF, 0x97},{0xE0, 0x9A},
        {0xE1, 0x9D},{0xE2, 0x9F},{0xE3, 0xA2},{0xE4, 0xA4},{0xE5, 0xA7},{0xE6, 0xA9},{0xE7, 0xAC},{0xE8, 0xAE},{0xE9, 0xB0},{0xEA, 0xB3},
        {0xEB, 0xB6},{0xEC, 0xB9},{0xED, 0xBD},{0xEE, 0xC0},{0xEF, 0xC3},{0xF0, 0xC6},{0xF1, 0xC8},{0xF2, 0xCB},{0xF3, 0xCE},{0xF4, 0xD0},
        {0xF5, 0xD3},{0xF6, 0xD6},{0xF7, 0xD9},{0xF8, 0xDC},{0xF9, 0xDF},{0xFA, 0xE1},{0xFB, 0xE4},{0xFC, 0xE7},{0xFD, 0xE9},{0xFE, 0xED},
        {0xFF, 0xF0},{0x93, 0x0A},{0xC0, 0x4C},{0xC1, 0x4C},{0xC2, 0x4C},{0xC3, 0x4C},{0xC4, 0x4C},{0xC5, 0x4C},{0xC6, 0x4C},{0xC7, 0x4C},
        {0xC8, 0x4C},{0xC9, 0x4D},{0xCA, 0x4D},{0xCB, 0x4D},{0xCC, 0x4E},{0xCD, 0x4E},{0xCE, 0x4F},{0xCF, 0x50},{0xD0, 0x51},{0xD1, 0x52},
        {0xD2, 0x52},{0xD3, 0x53},{0xD4, 0x54},{0xD5, 0x55},{0xD6, 0x56},{0xD7, 0x57},{0xD8, 0x59},{0xD9, 0x5A},{0xDA, 0x5B},{0xDB, 0x5C},
        {0xDC, 0x5E},{0xDD, 0x5F},{0xDE, 0x62},{0xDF, 0x64},{0xE0, 0x65},{0xE1, 0x67},{0xE2, 0x6A},{0xE3, 0x6B},{0xE4, 0x6D},{0xE5, 0x6E},
        {0xE6, 0x70},{0xE7, 0x72},{0xE8, 0x74},{0xE9, 0x76},{0xEA, 0x79},{0xEB, 0x7B},{0xEC, 0x7D},{0xED, 0x7E},{0xEE, 0x80},{0xEF, 0x83},
        {0xF0, 0x85},{0xF1, 0x87},{0xF2, 0x88},{0xF3, 0x8A},{0xF4, 0x8E},{0xF5, 0x90},{0xF6, 0x92},{0xF7, 0x94},{0xF8, 0x95},{0xF9, 0x97},
        {0xFA, 0x99},{0xFB, 0x9B},{0xFC, 0x9D},{0xFD, 0x9F},{0xFE, 0xA2},{0xFF, 0xA4},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x6A},{0xC1, 0x6A},{0xC2, 0x6A},{0xC3, 0x6A},{0xC4, 0x6A},{0xC5, 0x6A},{0xC6, 0x6A},{0xC7, 0x6A},
        {0xC8, 0x6B},{0xC9, 0x6B},{0xCA, 0x6B},{0xCB, 0x6C},{0xCC, 0x6C},{0xCD, 0x6D},{0xCE, 0x6D},{0xCF, 0x6E},{0xD0, 0x6F},{0xD1, 0x70},
        {0xD2, 0x70},{0xD3, 0x71},{0xD4, 0x72},{0xD5, 0x74},{0xD6, 0x75},{0xD7, 0x76},{0xD8, 0x77},{0xD9, 0x79},{0xDA, 0x7A},{0xDB, 0x7C},
        {0xDC, 0x7E},{0xDD, 0x7F},{0xDE, 0x81},{0xDF, 0x83},{0xE0, 0x84},{0xE1, 0x86},{0xE2, 0x87},{0xE3, 0x89},{0xE4, 0x8B},{0xE5, 0x8E},
        {0xE6, 0x90},{0xE7, 0x91},{0xE8, 0x93},{0xE9, 0x96},{0xEA, 0x98},{0xEB, 0x9A},{0xEC, 0x9D},{0xED, 0x9F},{0xEE, 0xA2},{0xEF, 0xA5},
        {0xF0, 0xA7},{0xF1, 0xA9},{0xF2, 0xAC},{0xF3, 0xAE},{0xF4, 0xB1},{0xF5, 0xB5},{0xF6, 0xB7},{0xF7, 0xBA},{0xF8, 0xBD},{0xF9, 0xBF},
        {0xFA, 0xC2},{0xFB, 0xC4},{0xFC, 0xC7},{0xFD, 0xCA},{0xFE, 0xCB},{0xFF, 0xCE},{0x93, 0x0D},{0xC0, 0x72},{0xC1, 0x72},{0xC2, 0x72},
        {0xC3, 0x72},{0xC4, 0x72},{0xC5, 0x73},{0xC6, 0x73},{0xC7, 0x73},{0xC8, 0x73},{0xC9, 0x74},{0xCA, 0x74},{0xCB, 0x74},{0xCC, 0x75},
        {0xCD, 0x76},{0xCE, 0x76},{0xCF, 0x77},{0xD0, 0x78},{0xD1, 0x79},{0xD2, 0x7B},{0xD3, 0x7C},{0xD4, 0x7D},{0xD5, 0x7E},{0xD6, 0x80},
        {0xD7, 0x82},{0xD8, 0x83},{0xD9, 0x84},{0xDA, 0x86},{0xDB, 0x87},{0xDC, 0x89},{0xDD, 0x8B},{0xDE, 0x8D},{0xDF, 0x8F},{0xE0, 0x91},
        {0xE1, 0x94},{0xE2, 0x96},{0xE3, 0x99},{0xE4, 0x9B},{0xE5, 0x9E},{0xE6, 0xA0},{0xE7, 0xA3},{0xE8, 0xA5},{0xE9, 0xA7},{0xEA, 0xAA},
        {0xEB, 0xAD},{0xEC, 0xB0},{0xED, 0xB3},{0xEE, 0xB7},{0xEF, 0xBB},{0xF0, 0xBE},{0xF1, 0xC1},{0xF2, 0xC3},{0xF3, 0xC6},{0xF4, 0xC9},
        {0xF5, 0xCB},{0xF6, 0xCE},{0xF7, 0xD1},{0xF8, 0xD5},{0xF9, 0xD9},{0xFA, 0xDC},{0xFB, 0xDF},{0xFC, 0xE2},{0xFD, 0xE5},{0xFE, 0xE9},
        {0xFF, 0xED},{0x93, 0x0E},{0xC0, 0x48},{0xC1, 0x48},{0xC2, 0x48},{0xC3, 0x48},{0xC4, 0x48},{0xC5, 0x48},{0xC6, 0x48},{0xC7, 0x48},
        {0xC8, 0x48},{0xC9, 0x49},{0xCA, 0x49},{0xCB, 0x49},{0xCC, 0x4A},{0xCD, 0x4A},{0xCE, 0x4B},{0xCF, 0x4C},{0xD0, 0x4D},{0xD1, 0x4D},
        {0xD2, 0x4E},{0xD3, 0x4F},{0xD4, 0x50},{0xD5, 0x51},{0xD6, 0x52},{0xD7, 0x52},{0xD8, 0x54},{0xD9, 0x55},{0xDA, 0x56},{0xDB, 0x57},
        {0xDC, 0x58},{0xDD, 0x59},{0xDE, 0x5B},{0xDF, 0x5D},{0xE0, 0x5E},{0xE1, 0x60},{0xE2, 0x62},{0xE3, 0x62},{0xE4, 0x64},{0xE5, 0x66},
        {0xE6, 0x68},{0xE7, 0x6A},{0xE8, 0x6C},{0xE9, 0x6E},{0xEA, 0x70},{0xEB, 0x72},{0xEC, 0x74},{0xED, 0x76},{0xEE, 0x78},{0xEF, 0x7B},
        {0xF0, 0x7D},{0xF1, 0x7F},{0xF2, 0x81},{0xF3, 0x83},{0xF4, 0x85},{0xF5, 0x87},{0xF6, 0x88},{0xF7, 0x8A},{0xF8, 0x8C},{0xF9, 0x8F},
        {0xFA, 0x90},{0xFB, 0x92},{0xFC, 0x94},{0xFD, 0x96},{0xFE, 0x99},{0xFF, 0x9B},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x5E},{0xC1, 0x5E},{0xC2, 0x5E},{0xC3, 0x5E},{0xC4, 0x5E},{0xC5, 0x5E},{0xC6, 0x5E},{0xC7, 0x5E},
        {0xC8, 0x5F},{0xC9, 0x5F},{0xCA, 0x5F},{0xCB, 0x60},{0xCC, 0x60},{0xCD, 0x61},{0xCE, 0x61},{0xCF, 0x62},{0xD0, 0x63},{0xD1, 0x63},
        {0xD2, 0x63},{0xD3, 0x64},{0xD4, 0x65},{0xD5, 0x67},{0xD6, 0x68},{0xD7, 0x68},{0xD8, 0x69},{0xD9, 0x6B},{0xDA, 0x6C},{0xDB, 0x6E},
        {0xDC, 0x70},{0xDD, 0x71},{0xDE, 0x73},{0xDF, 0x74},{0xE0, 0x76},{0xE1, 0x78},{0xE2, 0x7A},{0xE3, 0x7C},{0xE4, 0x7D},{0xE5, 0x7F},
        {0xE6, 0x81},{0xE7, 0x83},{0xE8, 0x84},{0xE9, 0x87},{0xEA, 0x89},{0xEB, 0x8B},{0xEC, 0x8D},{0xED, 0x8F},{0xEE, 0x91},{0xEF, 0x94},
        {0xF0, 0x97},{0xF1, 0x99},{0xF2, 0x9B},{0xF3, 0x9D},{0xF4, 0xA0},{0xF5, 0xA4},{0xF6, 0xA6},{0xF7, 0xA8},{0xF8, 0xAB},{0xF9, 0xAD},
        {0xFA, 0xB0},{0xFB, 0xB4},{0xFC, 0xB7},{0xFD, 0xBB},{0xFE, 0xBD},{0xFF, 0xC0},{0x93, 0x11},{0xC0, 0x65},{0xC1, 0x65},{0xC2, 0x65},
        {0xC3, 0x65},{0xC4, 0x65},{0xC5, 0x66},{0xC6, 0x66},{0xC7, 0x66},{0xC8, 0x66},{0xC9, 0x67},{0xCA, 0x67},{0xCB, 0x67},{0xCC, 0x68},
        {0xCD, 0x68},{0xCE, 0x68},{0xCF, 0x69},{0xD0, 0x6A},{0xD1, 0x6B},{0xD2, 0x6D},{0xD3, 0x6E},{0xD4, 0x6F},{0xD5, 0x70},{0xD6, 0x72},
        {0xD7, 0x74},{0xD8, 0x74},{0xD9, 0x76},{0xDA, 0x78},{0xDB, 0x7A},{0xDC, 0x7C},{0xDD, 0x7D},{0xDE, 0x7F},{0xDF, 0x80},{0xE0, 0x83},
        {0xE1, 0x85},{0xE2, 0x87},{0xE3, 0x8A},{0xE4, 0x8B},{0xE5, 0x8E},{0xE6, 0x90},{0xE7, 0x92},{0xE8, 0x95},{0xE9, 0x97},{0xEA, 0x9A},
        {0xEB, 0x9C},{0xEC, 0x9F},{0xED, 0xA3},{0xEE, 0xA6},{0xEF, 0xA9},{0xF0, 0xAC},{0xF1, 0xAF},{0xF2, 0xB2},{0xF3, 0xB6},{0xF4, 0xBA},
        {0xF5, 0xBD},{0xF6, 0xC0},{0xF7, 0xC3},{0xF8, 0xC6},{0xF9, 0xC9},{0xFA, 0xCC},{0xFB, 0xCF},{0xFC, 0xD3},{0xFD, 0xD7},{0xFE, 0xDC},
        {0xFF, 0xE1},{0x93, 0x12},{0xC0, 0x40},{0xC1, 0x40},{0xC2, 0x40},{0xC3, 0x40},{0xC4, 0x40},{0xC5, 0x40},{0xC6, 0x40},{0xC7, 0x40},
        {0xC8, 0x40},{0xC9, 0x41},{0xCA, 0x41},{0xCB, 0x41},{0xCC, 0x42},{0xCD, 0x42},{0xCE, 0x43},{0xCF, 0x43},{0xD0, 0x44},{0xD1, 0x45},
        {0xD2, 0x46},{0xD3, 0x47},{0xD4, 0x48},{0xD5, 0x48},{0xD6, 0x49},{0xD7, 0x4A},{0xD8, 0x4B},{0xD9, 0x4C},{0xDA, 0x4D},{0xDB, 0x4E},
        {0xDC, 0x4F},{0xDD, 0x50},{0xDE, 0x52},{0xDF, 0x54},{0xE0, 0x55},{0xE1, 0x57},{0xE2, 0x58},{0xE3, 0x59},{0xE4, 0x5A},{0xE5, 0x5B},
        {0xE6, 0x5D},{0xE7, 0x5E},{0xE8, 0x60},{0xE9, 0x62},{0xEA, 0x63},{0xEB, 0x65},{0xEC, 0x67},{0xED, 0x68},{0xEE, 0x6A},{0xEF, 0x6D},
        {0xF0, 0x6F},{0xF1, 0x71},{0xF2, 0x73},{0xF3, 0x74},{0xF4, 0x77},{0xF5, 0x79},{0xF6, 0x7B},{0xF7, 0x7C},{0xF8, 0x7E},{0xF9, 0x80},
        {0xFA, 0x82},{0xFB, 0x83},{0xFC, 0x85},{0xFD, 0x87},{0xFE, 0x8A},{0xFF, 0x8B},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [11] Strong +5
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x75},{0xC1, 0x75},{0xC2, 0x75},{0xC3, 0x75},{0xC4, 0x75},{0xC5, 0x75},{0xC6, 0x75},{0xC7, 0x76},
        {0xC8, 0x76},{0xC9, 0x76},{0xCA, 0x76},{0xCB, 0x77},{0xCC, 0x77},{0xCD, 0x77},{0xCE, 0x79},{0xCF, 0x7A},{0xD0, 0x7A},{0xD1, 0x7B},
        {0xD2, 0x7C},{0xD3, 0x7D},{0xD4, 0x7E},{0xD5, 0x7E},{0xD6, 0x7F},{0xD7, 0x80},{0xD8, 0x82},{0xD9, 0x83},{0xDA, 0x84},{0xDB, 0x86},
        {0xDC, 0x87},{0xDD, 0x88},{0xDE, 0x8A},{0xDF, 0x8D},{0xE0, 0x8F},{0xE1, 0x91},{0xE2, 0x93},{0xE3, 0x95},{0xE4, 0x96},{0xE5, 0x97},
        {0xE6, 0x99},{0xE7, 0x9B},{0xE8, 0x9E},{0xE9, 0xA0},{0xEA, 0xA2},{0xEB, 0xA5},{0xEC, 0xA7},{0xED, 0xAA},{0xEE, 0xAC},{0xEF, 0xAE},
        {0xF0, 0xB1},{0xF1, 0xB3},{0xF2, 0xB6},{0xF3, 0xB9},{0xF4, 0xBC},{0xF5, 0xBF},{0xF6, 0xC2},{0xF7, 0xC3},{0xF8, 0xC6},{0xF9, 0xC8},
        {0xFA, 0xCB},{0xFB, 0xCD},{0xFC, 0xCF},{0xFD, 0xD2},{0xFE, 0xD5},{0xFF, 0xD8},{0x93, 0x09},{0xC0, 0x7E},{0xC1, 0x7E},{0xC2, 0x7E},
        {0xC3, 0x7E},{0xC4, 0x7E},{0xC5, 0x7E},{0xC6, 0x7E},{0xC7, 0x7E},{0xC8, 0x7E},{0xC9, 0x7F},{0xCA, 0x7F},{0xCB, 0x7F},{0xCC, 0x80},
        {0xCD, 0x80},{0xCE, 0x81},{0xCF, 0x82},{0xD0, 0x83},{0xD1, 0x84},{0xD2, 0x85},{0xD3, 0x86},{0xD4, 0x87},{0xD5, 0x87},{0xD6, 0x89},
        {0xD7, 0x8A},{0xD8, 0x8D},{0xD9, 0x8F},{0xDA, 0x90},{0xDB, 0x92},{0xDC, 0x94},{0xDD, 0x95},{0xDE, 0x97},{0xDF, 0x99},{0xE0, 0x9B},
        {0xE1, 0x9E},{0xE2, 0xA0},{0xE3, 0xA2},{0xE4, 0xA5},{0xE5, 0xA8},{0xE6, 0xAA},{0xE7, 0xAC},{0xE8, 0xAE},{0xE9, 0xB1},{0xEA, 0xB4},
        {0xEB, 0xB7},{0xEC, 0xBB},{0xED, 0xBE},{0xEE, 0xC0},{0xEF, 0xC3},{0xF0, 0xC6},{0xF1, 0xC8},{0xF2, 0xCB},{0xF3, 0xCE},{0xF4, 0xD0},
        {0xF5, 0xD4},{0xF6, 0xD7},{0xF7, 0xDA},{0xF8, 0xDD},{0xF9, 0xDF},{0xFA, 0xE1},{0xFB, 0xE5},{0xFC, 0xE8},{0xFD, 0xEA},{0xFE, 0xED},
        {0xFF, 0xF1},{0x93, 0x0A},{0xC0, 0x4F},{0xC1, 0x4F},{0xC2, 0x4F},{0xC3, 0x4F},{0xC4, 0x4F},{0xC5, 0x4F},{0xC6, 0x4F},{0xC7, 0x4F},
        {0xC8, 0x4F},{0xC9, 0x50},{0xCA, 0x50},{0xCB, 0x50},{0xCC, 0x51},{0xCD, 0x51},{0xCE, 0x52},{0xCF, 0x52},{0xD0, 0x52},{0xD1, 0x53},
        {0xD2, 0x54},{0xD3, 0x55},{0xD4, 0x56},{0xD5, 0x57},{0xD6, 0x58},{0xD7, 0x5A},{0xD8, 0x5B},{0xD9, 0x5B},{0xDA, 0x5D},{0xDB, 0x5E},
        {0xDC, 0x61},{0xDD, 0x62},{0xDE, 0x64},{0xDF, 0x65},{0xE0, 0x67},{0xE1, 0x6A},{0xE2, 0x6B},{0xE3, 0x6D},{0xE4, 0x6E},{0xE5, 0x70},
        {0xE6, 0x72},{0xE7, 0x74},{0xE8, 0x76},{0xE9, 0x79},{0xEA, 0x7B},{0xEB, 0x7D},{0xEC, 0x7E},{0xED, 0x80},{0xEE, 0x82},{0xEF, 0x85},
        {0xF0, 0x87},{0xF1, 0x88},{0xF2, 0x8B},{0xF3, 0x8E},{0xF4, 0x90},{0xF5, 0x92},{0xF6, 0x94},{0xF7, 0x96},{0xF8, 0x97},{0xF9, 0x99},
        {0xFA, 0x9B},{0xFB, 0x9E},{0xFC, 0xA0},{0xFD, 0xA2},{0xFE, 0xA4},{0xFF, 0xA7},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x6D},{0xC1, 0x6D},{0xC2, 0x6D},{0xC3, 0x6D},{0xC4, 0x6D},{0xC5, 0x6D},{0xC6, 0x6D},{0xC7, 0x6E},
        {0xC8, 0x6E},{0xC9, 0x6E},{0xCA, 0x6E},{0xCB, 0x6F},{0xCC, 0x6F},{0xCD, 0x6F},{0xCE, 0x70},{0xCF, 0x71},{0xD0, 0x71},{0xD1, 0x72},
        {0xD2, 0x73},{0xD3, 0x74},{0xD4, 0x75},{0xD5, 0x76},{0xD6, 0x77},{0xD7, 0x78},{0xD8, 0x7A},{0xD9, 0x7B},{0xDA, 0x7C},{0xDB, 0x7E},
        {0xDC, 0x7F},{0xDD, 0x81},{0xDE, 0x83},{0xDF, 0x84},{0xE0, 0x86},{0xE1, 0x87},{0xE2, 0x89},{0xE3, 0x8B},{0xE4, 0x8D},{0xE5, 0x8F},
        {0xE6, 0x90},{0xE7, 0x92},{0xE8, 0x95},{0xE9, 0x97},{0xEA, 0x99},{0xEB, 0x9C},{0xEC, 0x9E},{0xED, 0xA1},{0xEE, 0xA3},{0xEF, 0xA5},
        {0xF0, 0xA8},{0xF1, 0xAA},{0xF2, 0xAD},{0xF3, 0xB0},{0xF4, 0xB2},{0xF5, 0xB6},{0xF6, 0xB9},{0xF7, 0xBB},{0xF8, 0xBE},{0xF9, 0xC1},
        {0xFA, 0xC3},{0xFB, 0xC5},{0xFC, 0xC8},{0xFD, 0xCB},{0xFE, 0xCD},{0xFF, 0xD0},{0x93, 0x0D},{0xC0, 0x76},{0xC1, 0x76},{0xC2, 0x76},
        {0xC3, 0x76},{0xC4, 0x76},{0xC5, 0x76},{0xC6, 0x76},{0xC7, 0x76},{0xC8, 0x76},{0xC9, 0x77},{0xCA, 0x77},{0xCB, 0x77},{0xCC, 0x78},
        {0xCD, 0x78},{0xCE, 0x79},{0xCF, 0x7A},{0xD0, 0x7B},{0xD1, 0x7C},{0xD2, 0x7D},{0xD3, 0x7E},{0xD4, 0x7F},{0xD5, 0x80},{0xD6, 0x82},
        {0xD7, 0x83},{0xD8, 0x84},{0xD9, 0x86},{0xDA, 0x87},{0xDB, 0x88},{0xDC, 0x8A},{0xDD, 0x8C},{0xDE, 0x8E},{0xDF, 0x90},{0xE0, 0x92},
        {0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x99},{0xE4, 0x9C},{0xE5, 0x9F},{0xE6, 0xA1},{0xE7, 0xA4},{0xE8, 0xA5},{0xE9, 0xA8},{0xEA, 0xAB},
        {0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB5},{0xEE, 0xB7},{0xEF, 0xBB},{0xF0, 0xBE},{0xF1, 0xC1},{0xF2, 0xC3},{0xF3, 0xC6},{0xF4, 0xC9},
        {0xF5, 0xCC},{0xF6, 0xCF},{0xF7, 0xD2},{0xF8, 0xD6},{0xF9, 0xD9},{0xFA, 0xDC},{0xFB, 0xE0},{0xFC, 0xE3},{0xFD, 0xE6},{0xFE, 0xE9},
        {0xFF, 0xEE},{0x93, 0x0E},{0xC0, 0x4B},{0xC1, 0x4B},{0xC2, 0x4B},{0xC3, 0x4B},{0xC4, 0x4B},{0xC5, 0x4B},{0xC6, 0x4B},{0xC7, 0x4B},
        {0xC8, 0x4B},{0xC9, 0x4C},{0xCA, 0x4C},{0xCB, 0x4C},{0xCC, 0x4D},{0xCD, 0x4D},{0xCE, 0x4D},{0xCF, 0x4E},{0xD0, 0x4E},{0xD1, 0x4F},
        {0xD2, 0x50},{0xD3, 0x51},{0xD4, 0x52},{0xD5, 0x52},{0xD6, 0x53},{0xD7, 0x55},{0xD8, 0x55},{0xD9, 0x56},{0xDA, 0x57},{0xDB, 0x58},
        {0xDC, 0x5A},{0xDD, 0x5B},{0xDE, 0x5D},{0xDF, 0x5E},{0xE0, 0x60},{0xE1, 0x62},{0xE2, 0x62},{0xE3, 0x64},{0xE4, 0x66},{0xE5, 0x68},
        {0xE6, 0x6A},{0xE7, 0x6C},{0xE8, 0x6E},{0xE9, 0x70},{0xEA, 0x72},{0xEB, 0x74},{0xEC, 0x76},{0xED, 0x78},{0xEE, 0x7A},{0xEF, 0x7D},
        {0xF0, 0x7F},{0xF1, 0x81},{0xF2, 0x83},{0xF3, 0x85},{0xF4, 0x87},{0xF5, 0x88},{0xF6, 0x8A},{0xF7, 0x8D},{0xF8, 0x8F},{0xF9, 0x90},
        {0xFA, 0x92},{0xFB, 0x95},{0xFC, 0x97},{0xFD, 0x99},{0xFE, 0x9B},{0xFF, 0x9E},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x61},{0xC1, 0x61},{0xC2, 0x61},{0xC3, 0x61},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x61},{0xC7, 0x62},
        {0xC8, 0x62},{0xC9, 0x62},{0xCA, 0x62},{0xCB, 0x63},{0xCC, 0x63},{0xCD, 0x63},{0xCE, 0x63},{0xCF, 0x64},{0xD0, 0x64},{0xD1, 0x65},
        {0xD2, 0x66},{0xD3, 0x67},{0xD4, 0x68},{0xD5, 0x68},{0xD6, 0x69},{0xD7, 0x6A},{0xD8, 0x6C},{0xD9, 0x6D},{0xDA, 0x6E},{0xDB, 0x70},
        {0xDC, 0x71},{0xDD, 0x73},{0xDE, 0x74},{0xDF, 0x76},{0xE0, 0x78},{0xE1, 0x7A},{0xE2, 0x7C},{0xE3, 0x7D},{0xE4, 0x7F},{0xE5, 0x80},
        {0xE6, 0x82},{0xE7, 0x83},{0xE8, 0x86},{0xE9, 0x88},{0xEA, 0x8A},{0xEB, 0x8C},{0xEC, 0x8E},{0xED, 0x90},{0xEE, 0x92},{0xEF, 0x95},
        {0xF0, 0x98},{0xF1, 0x9A},{0xF2, 0x9C},{0xF3, 0x9F},{0xF4, 0xA1},{0xF5, 0xA5},{0xF6, 0xA8},{0xF7, 0xA9},{0xF8, 0xAC},{0xF9, 0xAF},
        {0xFA, 0xB2},{0xFB, 0xB5},{0xFC, 0xB8},{0xFD, 0xBC},{0xFE, 0xBF},{0xFF, 0xC2},{0x93, 0x11},{0xC0, 0x68},{0xC1, 0x68},{0xC2, 0x68},
        {0xC3, 0x68},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x68},{0xC7, 0x68},{0xC8, 0x68},{0xC9, 0x69},{0xCA, 0x69},{0xCB, 0x69},{0xCC, 0x6A},
        {0xCD, 0x6A},{0xCE, 0x6B},{0xCF, 0x6C},{0xD0, 0x6D},{0xD1, 0x6E},{0xD2, 0x6F},{0xD3, 0x70},{0xD4, 0x71},{0xD5, 0x72},{0xD6, 0x74},
        {0xD7, 0x74},{0xD8, 0x76},{0xD9, 0x78},{0xDA, 0x79},{0xDB, 0x7B},{0xDC, 0x7C},{0xDD, 0x7E},{0xDE, 0x7F},{0xDF, 0x82},{0xE0, 0x83},
        {0xE1, 0x86},{0xE2, 0x88},{0xE3, 0x8A},{0xE4, 0x8C},{0xE5, 0x8F},{0xE6, 0x90},{0xE7, 0x93},{0xE8, 0x95},{0xE9, 0x98},{0xEA, 0x9A},
        {0xEB, 0x9D},{0xEC, 0xA0},{0xED, 0xA4},{0xEE, 0xA6},{0xEF, 0xA9},{0xF0, 0xAC},{0xF1, 0xAF},{0xF2, 0xB2},{0xF3, 0xB6},{0xF4, 0xBA},
        {0xF5, 0xBE},{0xF6, 0xC1},{0xF7, 0xC4},{0xF8, 0xC6},{0xF9, 0xC9},{0xFA, 0xCC},{0xFB, 0xD1},{0xFC, 0xD4},{0xFD, 0xD8},{0xFE, 0xDC},
        {0xFF, 0xE2},{0x93, 0x12},{0xC0, 0x43},{0xC1, 0x43},{0xC2, 0x43},{0xC3, 0x43},{0xC4, 0x43},{0xC5, 0x43},{0xC6, 0x43},{0xC7, 0x43},
        {0xC8, 0x43},{0xC9, 0x43},{0xCA, 0x43},{0xCB, 0x43},{0xCC, 0x44},{0xCD, 0x44},{0xCE, 0x45},{0xCF, 0x46},{0xD0, 0x46},{0xD1, 0x47},
        {0xD2, 0x48},{0xD3, 0x48},{0xD4, 0x49},{0xD5, 0x4A},{0xD6, 0x4B},{0xD7, 0x4C},{0xD8, 0x4D},{0xD9, 0x4D},{0xDA, 0x4F},{0xDB, 0x4F},
        {0xDC, 0x51},{0xDD, 0x52},{0xDE, 0x54},{0xDF, 0x55},{0xE0, 0x57},{0xE1, 0x58},{0xE2, 0x59},{0xE3, 0x5A},{0xE4, 0x5B},{0xE5, 0x5D},
        {0xE6, 0x5E},{0xE7, 0x60},{0xE8, 0x62},{0xE9, 0x63},{0xEA, 0x65},{0xEB, 0x67},{0xEC, 0x68},{0xED, 0x6A},{0xEE, 0x6C},{0xEF, 0x6F},
        {0xF0, 0x71},{0xF1, 0x73},{0xF2, 0x75},{0xF3, 0x77},{0xF4, 0x79},{0xF5, 0x7B},{0xF6, 0x7C},{0xF7, 0x7F},{0xF8, 0x80},{0xF9, 0x82},
        {0xFA, 0x83},{0xFB, 0x86},{0xFC, 0x88},{0xFD, 0x8A},{0xFE, 0x8B},{0xFF, 0x8E},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [12] Strong +6
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x79},{0xC1, 0x79},{0xC2, 0x79},{0xC3, 0x79},{0xC4, 0x79},{0xC5, 0x79},{0xC6, 0x7A},{0xC7, 0x7A},
        {0xC8, 0x7A},{0xC9, 0x7A},{0xCA, 0x7A},{0xCB, 0x7B},{0xCC, 0x7B},{0xCD, 0x7B},{0xCE, 0x7C},{0xCF, 0x7C},{0xD0, 0x7D},{0xD1, 0x7E},
        {0xD2, 0x7E},{0xD3, 0x7E},{0xD4, 0x7F},{0xD5, 0x80},{0xD6, 0x81},{0xD7, 0x82},{0xD8, 0x84},{0xD9, 0x85},{0xDA, 0x86},{0xDB, 0x87},
        {0xDC, 0x88},{0xDD, 0x8A},{0xDE, 0x8B},{0xDF, 0x8E},{0xE0, 0x90},{0xE1, 0x92},{0xE2, 0x94},{0xE3, 0x95},{0xE4, 0x97},{0xE5, 0x98},
        {0xE6, 0x9B},{0xE7, 0x9D},{0xE8, 0x9F},{0xE9, 0xA1},{0xEA, 0xA4},{0xEB, 0xA6},{0xEC, 0xA8},{0xED, 0xAB},{0xEE, 0xAC},{0xEF, 0xAF},
        {0xF0, 0xB2},{0xF1, 0xB5},{0xF2, 0xB7},{0xF3, 0xBB},{0xF4, 0xBD},{0xF5, 0xC0},{0xF6, 0xC3},{0xF7, 0xC5},{0xF8, 0xC6},{0xF9, 0xC9},
        {0xFA, 0xCC},{0xFB, 0xCE},{0xFC, 0xD0},{0xFD, 0xD3},{0xFE, 0xD6},{0xFF, 0xD9},{0x93, 0x09},{0xC0, 0x81},{0xC1, 0x81},{0xC2, 0x81},
        {0xC3, 0x81},{0xC4, 0x81},{0xC5, 0x81},{0xC6, 0x81},{0xC7, 0x81},{0xC8, 0x81},{0xC9, 0x82},{0xCA, 0x82},{0xCB, 0x82},{0xCC, 0x83},
        {0xCD, 0x83},{0xCE, 0x84},{0xCF, 0x85},{0xD0, 0x85},{0xD1, 0x86},{0xD2, 0x87},{0xD3, 0x87},{0xD4, 0x88},{0xD5, 0x89},{0xD6, 0x8B},
        {0xD7, 0x8D},{0xD8, 0x8F},{0xD9, 0x90},{0xDA, 0x92},{0xDB, 0x94},{0xDC, 0x95},{0xDD, 0x97},{0xDE, 0x98},{0xDF, 0x9A},{0xE0, 0x9C},
        {0xE1, 0x9F},{0xE2, 0xA1},{0xE3, 0xA3},{0xE4, 0xA6},{0xE5, 0xA8},{0xE6, 0xAB},{0xE7, 0xAD},{0xE8, 0xAF},{0xE9, 0xB2},{0xEA, 0xB5},
        {0xEB, 0xB7},{0xEC, 0xBB},{0xED, 0xBE},{0xEE, 0xC1},{0xEF, 0xC4},{0xF0, 0xC6},{0xF1, 0xC9},{0xF2, 0xCC},{0xF3, 0xCE},{0xF4, 0xD1},
        {0xF5, 0xD4},{0xF6, 0xD7},{0xF7, 0xDA},{0xF8, 0xDD},{0xF9, 0xE0},{0xFA, 0xE2},{0xFB, 0xE5},{0xFC, 0xE8},{0xFD, 0xEB},{0xFE, 0xEE},
        {0xFF, 0xF1},{0x93, 0x0A},{0xC0, 0x52},{0xC1, 0x52},{0xC2, 0x52},{0xC3, 0x52},{0xC4, 0x52},{0xC5, 0x52},{0xC6, 0x52},{0xC7, 0x52},
        {0xC8, 0x52},{0xC9, 0x52},{0xCA, 0x52},{0xCB, 0x52},{0xCC, 0x52},{0xCD, 0x53},{0xCE, 0x53},{0xCF, 0x54},{0xD0, 0x55},{0xD1, 0x56},
        {0xD2, 0x56},{0xD3, 0x57},{0xD4, 0x58},{0xD5, 0x59},{0xD6, 0x5B},{0xD7, 0x5B},{0xD8, 0x5C},{0xD9, 0x5D},{0xDA, 0x5F},{0xDB, 0x61},
        {0xDC, 0x63},{0xDD, 0x64},{0xDE, 0x65},{0xDF, 0x67},{0xE0, 0x6A},{0xE1, 0x6C},{0xE2, 0x6D},{0xE3, 0x6E},{0xE4, 0x70},{0xE5, 0x72},
        {0xE6, 0x74},{0xE7, 0x76},{0xE8, 0x79},{0xE9, 0x7B},{0xEA, 0x7D},{0xEB, 0x7E},{0xEC, 0x80},{0xED, 0x82},{0xEE, 0x84},{0xEF, 0x87},
        {0xF0, 0x88},{0xF1, 0x8A},{0xF2, 0x8E},{0xF3, 0x90},{0xF4, 0x92},{0xF5, 0x94},{0xF6, 0x96},{0xF7, 0x97},{0xF8, 0x99},{0xF9, 0x9B},
        {0xFA, 0x9E},{0xFB, 0xA0},{0xFC, 0xA2},{0xFD, 0xA5},{0xFE, 0xA7},{0xFF, 0xA9},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x70},{0xC1, 0x70},{0xC2, 0x70},{0xC3, 0x70},{0xC4, 0x70},{0xC5, 0x70},{0xC6, 0x71},{0xC7, 0x71},
        {0xC8, 0x71},{0xC9, 0x71},{0xCA, 0x71},{0xCB, 0x72},{0xCC, 0x72},{0xCD, 0x72},{0xCE, 0x73},{0xCF, 0x73},{0xD0, 0x74},{0xD1, 0x75},
        {0xD2, 0x75},{0xD3, 0x76},{0xD4, 0x77},{0xD5, 0x78},{0xD6, 0x79},{0xD7, 0x7A},{0xD8, 0x7C},{0xD9, 0x7D},{0xDA, 0x7E},{0xDB, 0x80},
        {0xDC, 0x81},{0xDD, 0x83},{0xDE, 0x83},{0xDF, 0x85},{0xE0, 0x87},{0xE1, 0x88},{0xE2, 0x8A},{0xE3, 0x8C},{0xE4, 0x8E},{0xE5, 0x90},
        {0xE6, 0x92},{0xE7, 0x94},{0xE8, 0x96},{0xE9, 0x98},{0xEA, 0x9B},{0xEB, 0x9D},{0xEC, 0x9F},{0xED, 0xA2},{0xEE, 0xA4},{0xEF, 0xA6},
        {0xF0, 0xA9},{0xF1, 0xAC},{0xF2, 0xAE},{0xF3, 0xB1},{0xF4, 0xB3},{0xF5, 0xB7},{0xF6, 0xBA},{0xF7, 0xBD},{0xF8, 0xBF},{0xF9, 0xC2},
        {0xFA, 0xC4},{0xFB, 0xC7},{0xFC, 0xC9},{0xFD, 0xCB},{0xFE, 0xCE},{0xFF, 0xD1},{0x93, 0x0D},{0xC0, 0x79},{0xC1, 0x79},{0xC2, 0x79},
        {0xC3, 0x79},{0xC4, 0x79},{0xC5, 0x79},{0xC6, 0x79},{0xC7, 0x79},{0xC8, 0x79},{0xC9, 0x7A},{0xCA, 0x7A},{0xCB, 0x7A},{0xCC, 0x7B},
        {0xCD, 0x7B},{0xCE, 0x7C},{0xCF, 0x7D},{0xD0, 0x7D},{0xD1, 0x7E},{0xD2, 0x7F},{0xD3, 0x80},{0xD4, 0x81},{0xD5, 0x82},{0xD6, 0x83},
        {0xD7, 0x84},{0xD8, 0x86},{0xD9, 0x87},{0xDA, 0x88},{0xDB, 0x8A},{0xDC, 0x8C},{0xDD, 0x8E},{0xDE, 0x90},{0xDF, 0x91},{0xE0, 0x93},
        {0xE1, 0x96},{0xE2, 0x98},{0xE3, 0x9A},{0xE4, 0x9D},{0xE5, 0x9F},{0xE6, 0xA2},{0xE7, 0xA5},{0xE8, 0xA6},{0xE9, 0xA9},{0xEA, 0xAC},
        {0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB5},{0xEE, 0xB8},{0xEF, 0xBC},{0xF0, 0xBF},{0xF1, 0xC2},{0xF2, 0xC4},{0xF3, 0xC7},{0xF4, 0xCA},
        {0xF5, 0xCC},{0xF6, 0xCF},{0xF7, 0xD2},{0xF8, 0xD6},{0xF9, 0xDA},{0xFA, 0xDD},{0xFB, 0xE0},{0xFC, 0xE3},{0xFD, 0xE7},{0xFE, 0xEB},
        {0xFF, 0xEE},{0x93, 0x0E},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4D},{0xC3, 0x4D},{0xC4, 0x4D},{0xC5, 0x4D},{0xC6, 0x4D},{0xC7, 0x4D},
        {0xC8, 0x4D},{0xC9, 0x4D},{0xCA, 0x4E},{0xCB, 0x4E},{0xCC, 0x4E},{0xCD, 0x4F},{0xCE, 0x4F},{0xCF, 0x50},{0xD0, 0x51},{0xD1, 0x52},
        {0xD2, 0x52},{0xD3, 0x52},{0xD4, 0x53},{0xD5, 0x54},{0xD6, 0x55},{0xD7, 0x56},{0xD8, 0x57},{0xD9, 0x57},{0xDA, 0x59},{0xDB, 0x5A},
        {0xDC, 0x5C},{0xDD, 0x5D},{0xDE, 0x5E},{0xDF, 0x60},{0xE0, 0x62},{0xE1, 0x63},{0xE2, 0x64},{0xE3, 0x66},{0xE4, 0x68},{0xE5, 0x6A},
        {0xE6, 0x6C},{0xE7, 0x6E},{0xE8, 0x70},{0xE9, 0x72},{0xEA, 0x74},{0xEB, 0x76},{0xEC, 0x78},{0xED, 0x7A},{0xEE, 0x7C},{0xEF, 0x7F},
        {0xF0, 0x81},{0xF1, 0x83},{0xF2, 0x85},{0xF3, 0x87},{0xF4, 0x88},{0xF5, 0x8A},{0xF6, 0x8D},{0xF7, 0x8F},{0xF8, 0x90},{0xF9, 0x92},
        {0xFA, 0x95},{0xFB, 0x97},{0xFC, 0x99},{0xFD, 0x9C},{0xFE, 0x9E},{0xFF, 0xA0},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x63},{0xC1, 0x63},{0xC2, 0x63},{0xC3, 0x63},{0xC4, 0x63},{0xC5, 0x63},{0xC6, 0x64},{0xC7, 0x64},
        {0xC8, 0x64},{0xC9, 0x64},{0xCA, 0x64},{0xCB, 0x65},{0xCC, 0x65},{0xCD, 0x65},{0xCE, 0x66},{0xCF, 0x66},{0xD0, 0x67},{0xD1, 0x68},
        {0xD2, 0x68},{0xD3, 0x68},{0xD4, 0x69},{0xD5, 0x6A},{0xD6, 0x6B},{0xD7, 0x6C},{0xD8, 0x6E},{0xD9, 0x6F},{0xDA, 0x70},{0xDB, 0x72},
        {0xDC, 0x73},{0xDD, 0x74},{0xDE, 0x75},{0xDF, 0x77},{0xE0, 0x79},{0xE1, 0x7B},{0xE2, 0x7C},{0xE3, 0x7E},{0xE4, 0x7F},{0xE5, 0x81},
        {0xE6, 0x83},{0xE7, 0x85},{0xE8, 0x87},{0xE9, 0x89},{0xEA, 0x8B},{0xEB, 0x8D},{0xEC, 0x8F},{0xED, 0x91},{0xEE, 0x93},{0xEF, 0x96},
        {0xF0, 0x99},{0xF1, 0x9B},{0xF2, 0x9D},{0xF3, 0xA0},{0xF4, 0xA3},{0xF5, 0xA6},{0xF6, 0xA8},{0xF7, 0xAB},{0xF8, 0xAD},{0xF9, 0xB0},
        {0xFA, 0xB4},{0xFB, 0xB7},{0xFC, 0xBA},{0xFD, 0xBD},{0xFE, 0xC0},{0xFF, 0xC3},{0x93, 0x11},{0xC0, 0x6B},{0xC1, 0x6B},{0xC2, 0x6B},
        {0xC3, 0x6B},{0xC4, 0x6B},{0xC5, 0x6B},{0xC6, 0x6B},{0xC7, 0x6B},{0xC8, 0x6B},{0xC9, 0x6C},{0xCA, 0x6C},{0xCB, 0x6C},{0xCC, 0x6D},
        {0xCD, 0x6D},{0xCE, 0x6E},{0xCF, 0x6F},{0xD0, 0x6F},{0xD1, 0x70},{0xD2, 0x71},{0xD3, 0x72},{0xD4, 0x73},{0xD5, 0x74},{0xD6, 0x75},
        {0xD7, 0x76},{0xD8, 0x78},{0xD9, 0x79},{0xDA, 0x7B},{0xDB, 0x7C},{0xDC, 0x7E},{0xDD, 0x7F},{0xDE, 0x81},{0xDF, 0x83},{0xE0, 0x84},
        {0xE1, 0x87},{0xE2, 0x89},{0xE3, 0x8B},{0xE4, 0x8D},{0xE5, 0x8F},{0xE6, 0x91},{0xE7, 0x94},{0xE8, 0x96},{0xE9, 0x99},{0xEA, 0x9B},
        {0xEB, 0x9D},{0xEC, 0xA0},{0xED, 0xA4},{0xEE, 0xA7},{0xEF, 0xAA},{0xF0, 0xAD},{0xF1, 0xB0},{0xF2, 0xB4},{0xF3, 0xB7},{0xF4, 0xBB},
        {0xF5, 0xBE},{0xF6, 0xC1},{0xF7, 0xC4},{0xF8, 0xC6},{0xF9, 0xCA},{0xFA, 0xCD},{0xFB, 0xD1},{0xFC, 0xD4},{0xFD, 0xD9},{0xFE, 0xDE},
        {0xFF, 0xE2},{0x93, 0x12},{0xC0, 0x45},{0xC1, 0x45},{0xC2, 0x45},{0xC3, 0x45},{0xC4, 0x45},{0xC5, 0x45},{0xC6, 0x45},{0xC7, 0x45},
        {0xC8, 0x45},{0xC9, 0x45},{0xCA, 0x46},{0xCB, 0x46},{0xCC, 0x46},{0xCD, 0x47},{0xCE, 0x47},{0xCF, 0x48},{0xD0, 0x48},{0xD1, 0x49},
        {0xD2, 0x49},{0xD3, 0x4A},{0xD4, 0x4B},{0xD5, 0x4B},{0xD6, 0x4D},{0xD7, 0x4D},{0xD8, 0x4E},{0xD9, 0x4F},{0xDA, 0x50},{0xDB, 0x51},
        {0xDC, 0x53},{0xDD, 0x54},{0xDE, 0x55},{0xDF, 0x57},{0xE0, 0x58},{0xE1, 0x59},{0xE2, 0x5A},{0xE3, 0x5B},{0xE4, 0x5D},{0xE5, 0x5E},
        {0xE6, 0x60},{0xE7, 0x62},{0xE8, 0x63},{0xE9, 0x65},{0xEA, 0x67},{0xEB, 0x68},{0xEC, 0x6A},{0xED, 0x6C},{0xEE, 0x6E},{0xEF, 0x71},
        {0xF0, 0x73},{0xF1, 0x74},{0xF2, 0x77},{0xF3, 0x79},{0xF4, 0x7B},{0xF5, 0x7C},{0xF6, 0x7F},{0xF7, 0x80},{0xF8, 0x82},{0xF9, 0x83},
        {0xFA, 0x86},{0xFB, 0x88},{0xFC, 0x8A},{0xFD, 0x8C},{0xFE, 0x8E},{0xFF, 0x90},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [13] Medium -6
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x4B},{0xC1, 0x4B},{0xC2, 0x4C},{0xC3, 0x4C},{0xC4, 0x4D},{0xC5, 0x4E},{0xC6, 0x4F},{0xC7, 0x50},
        {0xC8, 0x52},{0xC9, 0x52},{0xCA, 0x54},{0xCB, 0x55},{0xCC, 0x57},{0xCD, 0x59},{0xCE, 0x5B},{0xCF, 0x5C},{0xD0, 0x5E},{0xD1, 0x61},
        {0xD2, 0x64},{0xD3, 0x65},{0xD4, 0x67},{0xD5, 0x6A},{0xD6, 0x6D},{0xD7, 0x6E},{0xD8, 0x71},{0xD9, 0x73},{0xDA, 0x76},{0xDB, 0x79},
        {0xDC, 0x7C},{0xDD, 0x7E},{0xDE, 0x80},{0xDF, 0x82},{0xE0, 0x86},{0xE1, 0x87},{0xE2, 0x8A},{0xE3, 0x8E},{0xE4, 0x91},{0xE5, 0x93},
        {0xE6, 0x95},{0xE7, 0x97},{0xE8, 0x9A},{0xE9, 0x9C},{0xEA, 0x9F},{0xEB, 0xA2},{0xEC, 0xA5},{0xED, 0xA8},{0xEE, 0xAB},{0xEF, 0xAD},
        {0xF0, 0xB0},{0xF1, 0xB3},{0xF2, 0xB6},{0xF3, 0xB9},{0xF4, 0xBD},{0xF5, 0xC0},{0xF6, 0xC2},{0xF7, 0xC4},{0xF8, 0xC6},{0xF9, 0xC9},
        {0xFA, 0xCC},{0xFB, 0xCE},{0xFC, 0xD1},{0xFD, 0xD4},{0xFE, 0xD7},{0xFF, 0xDA},{0x93, 0x09},{0xC0, 0x51},{0xC1, 0x51},{0xC2, 0x51},
        {0xC3, 0x52},{0xC4, 0x52},{0xC5, 0x53},{0xC6, 0x54},{0xC7, 0x55},{0xC8, 0x56},{0xC9, 0x58},{0xCA, 0x5A},{0xCB, 0x5B},{0xCC, 0x5C},
        {0xCD, 0x5E},{0xCE, 0x61},{0xCF, 0x64},{0xD0, 0x65},{0xD1, 0x67},{0xD2, 0x6A},{0xD3, 0x6D},{0xD4, 0x6E},{0xD5, 0x71},{0xD6, 0x73},
        {0xD7, 0x76},{0xD8, 0x79},{0xD9, 0x7C},{0xDA, 0x7E},{0xDB, 0x80},{0xDC, 0x83},{0xDD, 0x86},{0xDE, 0x88},{0xDF, 0x8A},{0xE0, 0x8F},
        {0xE1, 0x92},{0xE2, 0x95},{0xE3, 0x96},{0xE4, 0x98},{0xE5, 0x9B},{0xE6, 0x9E},{0xE7, 0xA1},{0xE8, 0xA4},{0xE9, 0xA7},{0xEA, 0xAA},
        {0xEB, 0xAC},{0xEC, 0xAF},{0xED, 0xB2},{0xEE, 0xB5},{0xEF, 0xB9},{0xF0, 0xBD},{0xF1, 0xC0},{0xF2, 0xC3},{0xF3, 0xC5},{0xF4, 0xC7},
        {0xF5, 0xCB},{0xF6, 0xCE},{0xF7, 0xD0},{0xF8, 0xD3},{0xF9, 0xD6},{0xFA, 0xD9},{0xFB, 0xDC},{0xFC, 0xDE},{0xFD, 0xE1},{0xFE, 0xE4},
        {0xFF, 0xE7},{0x93, 0x0A},{0xC0, 0x2B},{0xC1, 0x2B},{0xC2, 0x2B},{0xC3, 0x2B},{0xC4, 0x2B},{0xC5, 0x2B},{0xC6, 0x2B},{0xC7, 0x2C},
        {0xC8, 0x2C},{0xC9, 0x2C},{0xCA, 0x2E},{0xCB, 0x2E},{0xCC, 0x2F},{0xCD, 0x2F},{0xCE, 0x30},{0xCF, 0x30},{0xD0, 0x31},{0xD1, 0x31},
        {0xD2, 0x32},{0xD3, 0x32},{0xD4, 0x33},{0xD5, 0x34},{0xD6, 0x34},{0xD7, 0x35},{0xD8, 0x35},{0xD9, 0x36},{0xDA, 0x37},{0xDB, 0x38},
        {0xDC, 0x38},{0xDD, 0x39},{0xDE, 0x3A},{0xDF, 0x3A},{0xE0, 0x3A},{0xE1, 0x3B},{0xE2, 0x3C},{0xE3, 0x3D},{0xE4, 0x3D},{0xE5, 0x3E},
        {0xE6, 0x3E},{0xE7, 0x3F},{0xE8, 0x40},{0xE9, 0x40},{0xEA, 0x41},{0xEB, 0x42},{0xEC, 0x43},{0xED, 0x45},{0xEE, 0x46},{0xEF, 0x47},
        {0xF0, 0x47},{0xF1, 0x48},{0xF2, 0x49},{0xF3, 0x4A},{0xF4, 0x4A},{0xF5, 0x4B},{0xF6, 0x4C},{0xF7, 0x4C},{0xF8, 0x4D},{0xF9, 0x4E},
        {0xFA, 0x4F},{0xFB, 0x50},{0xFC, 0x51},{0xFD, 0x52},{0xFE, 0x52},{0xFF, 0x52},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x47},{0xC1, 0x47},{0xC2, 0x48},{0xC3, 0x48},{0xC4, 0x49},{0xC5, 0x4A},{0xC6, 0x4B},{0xC7, 0x4C},
        {0xC8, 0x4D},{0xC9, 0x4E},{0xCA, 0x50},{0xCB, 0x51},{0xCC, 0x52},{0xCD, 0x54},{0xCE, 0x55},{0xCF, 0x57},{0xD0, 0x58},{0xD1, 0x5A},
        {0xD2, 0x5D},{0xD3, 0x5E},{0xD4, 0x60},{0xD5, 0x62},{0xD6, 0x64},{0xD7, 0x66},{0xD8, 0x69},{0xD9, 0x6B},{0xDA, 0x6E},{0xDB, 0x70},
        {0xDC, 0x73},{0xDD, 0x75},{0xDE, 0x78},{0xDF, 0x7A},{0xE0, 0x7E},{0xE1, 0x80},{0xE2, 0x83},{0xE3, 0x85},{0xE4, 0x87},{0xE5, 0x89},
        {0xE6, 0x8C},{0xE7, 0x8F},{0xE8, 0x91},{0xE9, 0x93},{0xEA, 0x96},{0xEB, 0x99},{0xEC, 0x9C},{0xED, 0x9F},{0xEE, 0xA2},{0xEF, 0xA5},
        {0xF0, 0xA7},{0xF1, 0xAA},{0xF2, 0xAD},{0xF3, 0xB0},{0xF4, 0xB3},{0xF5, 0xB7},{0xF6, 0xB9},{0xF7, 0xBC},{0xF8, 0xBF},{0xF9, 0xC2},
        {0xFA, 0xC4},{0xFB, 0xC7},{0xFC, 0xCA},{0xFD, 0xCC},{0xFE, 0xCF},{0xFF, 0xD2},{0x93, 0x0D},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4D},
        {0xC3, 0x4D},{0xC4, 0x4E},{0xC5, 0x4F},{0xC6, 0x50},{0xC7, 0x51},{0xC8, 0x52},{0xC9, 0x53},{0xCA, 0x55},{0xCB, 0x55},{0xCC, 0x57},
        {0xCD, 0x58},{0xCE, 0x5A},{0xCF, 0x5D},{0xD0, 0x5E},{0xD1, 0x60},{0xD2, 0x62},{0xD3, 0x64},{0xD4, 0x66},{0xD5, 0x69},{0xD6, 0x6B},
        {0xD7, 0x6E},{0xD8, 0x70},{0xD9, 0x73},{0xDA, 0x76},{0xDB, 0x78},{0xDC, 0x7B},{0xDD, 0x7E},{0xDE, 0x81},{0xDF, 0x83},{0xE0, 0x86},
        {0xE1, 0x88},{0xE2, 0x8B},{0xE3, 0x8D},{0xE4, 0x90},{0xE5, 0x92},{0xE6, 0x95},{0xE7, 0x98},{0xE8, 0x9B},{0xE9, 0x9E},{0xEA, 0xA1},
        {0xEB, 0xA4},{0xEC, 0xA6},{0xED, 0xA9},{0xEE, 0xAC},{0xEF, 0xB0},{0xF0, 0xB3},{0xF1, 0xB7},{0xF2, 0xBA},{0xF3, 0xBD},{0xF4, 0xC0},
        {0xF5, 0xC3},{0xF6, 0xC6},{0xF7, 0xC9},{0xF8, 0xCB},{0xF9, 0xCE},{0xFA, 0xD1},{0xFB, 0xD5},{0xFC, 0xD8},{0xFD, 0xDC},{0xFE, 0xDF},
        {0xFF, 0xE2},{0x93, 0x0E},{0xC0, 0x29},{0xC1, 0x29},{0xC2, 0x29},{0xC3, 0x29},{0xC4, 0x29},{0xC5, 0x29},{0xC6, 0x29},{0xC7, 0x2A},
        {0xC8, 0x2A},{0xC9, 0x2A},{0xCA, 0x2B},{0xCB, 0x2B},{0xCC, 0x2C},{0xCD, 0x2C},{0xCE, 0x2D},{0xCF, 0x2D},{0xD0, 0x2E},{0xD1, 0x2E},
        {0xD2, 0x2F},{0xD3, 0x2F},{0xD4, 0x30},{0xD5, 0x31},{0xD6, 0x31},{0xD7, 0x32},{0xD8, 0x32},{0xD9, 0x33},{0xDA, 0x34},{0xDB, 0x34},
        {0xDC, 0x34},{0xDD, 0x35},{0xDE, 0x36},{0xDF, 0x36},{0xE0, 0x37},{0xE1, 0x38},{0xE2, 0x39},{0xE3, 0x3A},{0xE4, 0x3A},{0xE5, 0x3B},
        {0xE6, 0x3C},{0xE7, 0x3D},{0xE8, 0x3E},{0xE9, 0x3E},{0xEA, 0x3E},{0xEB, 0x3F},{0xEC, 0x40},{0xED, 0x41},{0xEE, 0x41},{0xEF, 0x42},
        {0xF0, 0x42},{0xF1, 0x43},{0xF2, 0x44},{0xF3, 0x45},{0xF4, 0x46},{0xF5, 0x47},{0xF6, 0x48},{0xF7, 0x48},{0xF8, 0x49},{0xF9, 0x4A},
        {0xFA, 0x4B},{0xFB, 0x4C},{0xFC, 0x4D},{0xFD, 0x4D},{0xFE, 0x4E},{0xFF, 0x4E},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x3F},{0xC1, 0x3F},{0xC2, 0x40},{0xC3, 0x40},{0xC4, 0x41},{0xC5, 0x42},{0xC6, 0x43},{0xC7, 0x43},
        {0xC8, 0x45},{0xC9, 0x46},{0xCA, 0x48},{0xCB, 0x48},{0xCC, 0x4A},{0xCD, 0x4B},{0xCE, 0x4D},{0xCF, 0x4E},{0xD0, 0x4F},{0xD1, 0x51},
        {0xD2, 0x54},{0xD3, 0x55},{0xD4, 0x57},{0xD5, 0x58},{0xD6, 0x5A},{0xD7, 0x5B},{0xD8, 0x5E},{0xD9, 0x5F},{0xDA, 0x62},{0xDB, 0x63},
        {0xDC, 0x66},{0xDD, 0x68},{0xDE, 0x6A},{0xDF, 0x6C},{0xE0, 0x70},{0xE1, 0x72},{0xE2, 0x74},{0xE3, 0x77},{0xE4, 0x7A},{0xE5, 0x7C},
        {0xE6, 0x7E},{0xE7, 0x80},{0xE8, 0x83},{0xE9, 0x84},{0xEA, 0x87},{0xEB, 0x8A},{0xEC, 0x8C},{0xED, 0x8F},{0xEE, 0x91},{0xEF, 0x94},
        {0xF0, 0x97},{0xF1, 0x9A},{0xF2, 0x9C},{0xF3, 0x9F},{0xF4, 0xA3},{0xF5, 0xA6},{0xF6, 0xA8},{0xF7, 0xAA},{0xF8, 0xAD},{0xF9, 0xB0},
        {0xFA, 0xB4},{0xFB, 0xB7},{0xFC, 0xBB},{0xFD, 0xBE},{0xFE, 0xC1},{0xFF, 0xC4},{0x93, 0x11},{0xC0, 0x44},{0xC1, 0x44},{0xC2, 0x44},
        {0xC3, 0x45},{0xC4, 0x46},{0xC5, 0x47},{0xC6, 0x48},{0xC7, 0x48},{0xC8, 0x49},{0xC9, 0x4B},{0xCA, 0x4C},{0xCB, 0x4D},{0xCC, 0x4E},
        {0xCD, 0x4F},{0xCE, 0x51},{0xCF, 0x54},{0xD0, 0x55},{0xD1, 0x57},{0xD2, 0x58},{0xD3, 0x5A},{0xD4, 0x5B},{0xD5, 0x5E},{0xD6, 0x5F},
        {0xD7, 0x62},{0xD8, 0x63},{0xD9, 0x66},{0xDA, 0x68},{0xDB, 0x6A},{0xDC, 0x6D},{0xDD, 0x70},{0xDE, 0x73},{0xDF, 0x74},{0xE0, 0x78},
        {0xE1, 0x7B},{0xE2, 0x7D},{0xE3, 0x7F},{0xE4, 0x81},{0xE5, 0x83},{0xE6, 0x86},{0xE7, 0x89},{0xE8, 0x8B},{0xE9, 0x8E},{0xEA, 0x90},
        {0xEB, 0x93},{0xEC, 0x96},{0xED, 0x99},{0xEE, 0x9B},{0xEF, 0x9F},{0xF0, 0xA3},{0xF1, 0xA6},{0xF2, 0xA8},{0xF3, 0xAB},{0xF4, 0xAE},
        {0xF5, 0xB2},{0xF6, 0xB6},{0xF7, 0xBA},{0xF8, 0xBD},{0xF9, 0xC0},{0xFA, 0xC3},{0xFB, 0xC6},{0xFC, 0xC8},{0xFD, 0xCC},{0xFE, 0xCF},
        {0xFF, 0xD3},{0x93, 0x12},{0xC0, 0x25},{0xC1, 0x25},{0xC2, 0x25},{0xC3, 0x25},{0xC4, 0x25},{0xC5, 0x25},{0xC6, 0x25},{0xC7, 0x26},
        {0xC8, 0x26},{0xC9, 0x26},{0xCA, 0x27},{0xCB, 0x27},{0xCC, 0x28},{0xCD, 0x28},{0xCE, 0x29},{0xCF, 0x29},{0xD0, 0x2A},{0xD1, 0x2A},
        {0xD2, 0x2B},{0xD3, 0x2B},{0xD4, 0x2C},{0xD5, 0x2D},{0xD6, 0x2D},{0xD7, 0x2D},{0xD8, 0x2D},{0xD9, 0x2E},{0xDA, 0x2F},{0xDB, 0x30},
        {0xDC, 0x30},{0xDD, 0x30},{0xDE, 0x31},{0xDF, 0x31},{0xE0, 0x32},{0xE1, 0x33},{0xE2, 0x34},{0xE3, 0x35},{0xE4, 0x35},{0xE5, 0x36},
        {0xE6, 0x37},{0xE7, 0x38},{0xE8, 0x38},{0xE9, 0x38},{0xEA, 0x39},{0xEB, 0x3A},{0xEC, 0x3A},{0xED, 0x3B},{0xEE, 0x3C},{0xEF, 0x3C},
        {0xF0, 0x3C},{0xF1, 0x3D},{0xF2, 0x3D},{0xF3, 0x3E},{0xF4, 0x3F},{0xF5, 0x3F},{0xF6, 0x40},{0xF7, 0x40},{0xF8, 0x41},{0xF9, 0x42},
        {0xFA, 0x43},{0xFB, 0x43},{0xFC, 0x44},{0xFD, 0x45},{0xFE, 0x46},{0xFF, 0x46},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [14] Medium -5
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x50},{0xC1, 0x50},{0xC2, 0x50},{0xC3, 0x51},{0xC4, 0x51},{0xC5, 0x52},{0xC6, 0x52},{0xC7, 0x53},
        {0xC8, 0x54},{0xC9, 0x56},{0xCA, 0x57},{0xCB, 0x58},{0xCC, 0x5A},{0xCD, 0x5B},{0xCE, 0x5D},{0xCF, 0x5F},{0xD0, 0x62},{0xD1, 0x64},
        {0xD2, 0x65},{0xD3, 0x67},{0xD4, 0x6A},{0xD5, 0x6C},{0xD6, 0x6E},{0xD7, 0x70},{0xD8, 0x73},{0xD9, 0x75},{0xDA, 0x77},{0xDB, 0x7B},
        {0xDC, 0x7D},{0xDD, 0x7F},{0xDE, 0x82},{0xDF, 0x84},{0xE0, 0x87},{0xE1, 0x89},{0xE2, 0x8D},{0xE3, 0x90},{0xE4, 0x92},{0xE5, 0x95},
        {0xE6, 0x97},{0xE7, 0x99},{0xE8, 0x9B},{0xE9, 0x9E},{0xEA, 0xA1},{0xEB, 0xA4},{0xEC, 0xA7},{0xED, 0xA9},{0xEE, 0xAC},{0xEF, 0xAF},
        {0xF0, 0xB2},{0xF1, 0xB5},{0xF2, 0xB8},{0xF3, 0xBC},{0xF4, 0xBE},{0xF5, 0xC1},{0xF6, 0xC3},{0xF7, 0xC6},{0xF8, 0xC8},{0xF9, 0xCB},
        {0xFA, 0xCE},{0xFB, 0xD0},{0xFC, 0xD3},{0xFD, 0xD6},{0xFE, 0xD9},{0xFF, 0xDC},{0x93, 0x09},{0xC0, 0x55},{0xC1, 0x55},{0xC2, 0x56},
        {0xC3, 0x56},{0xC4, 0x57},{0xC5, 0x58},{0xC6, 0x59},{0xC7, 0x5A},{0xC8, 0x5B},{0xC9, 0x5B},{0xCA, 0x5D},{0xCB, 0x5E},{0xCC, 0x61},
        {0xCD, 0x63},{0xCE, 0x64},{0xCF, 0x66},{0xD0, 0x68},{0xD1, 0x6B},{0xD2, 0x6D},{0xD3, 0x6E},{0xD4, 0x71},{0xD5, 0x73},{0xD6, 0x76},
        {0xD7, 0x79},{0xD8, 0x7C},{0xD9, 0x7E},{0xDA, 0x80},{0xDB, 0x82},{0xDC, 0x85},{0xDD, 0x87},{0xDE, 0x89},{0xDF, 0x8D},{0xE0, 0x91},
        {0xE1, 0x93},{0xE2, 0x95},{0xE3, 0x97},{0xE4, 0x9A},{0xE5, 0x9D},{0xE6, 0xA0},{0xE7, 0xA3},{0xE8, 0xA6},{0xE9, 0xA9},{0xEA, 0xAC},
        {0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB4},{0xEE, 0xB7},{0xEF, 0xBC},{0xF0, 0xBF},{0xF1, 0xC2},{0xF2, 0xC4},{0xF3, 0xC6},{0xF4, 0xC9},
        {0xF5, 0xCC},{0xF6, 0xCE},{0xF7, 0xD1},{0xF8, 0xD4},{0xF9, 0xD8},{0xFA, 0xDB},{0xFB, 0xDD},{0xFC, 0xE0},{0xFD, 0xE2},{0xFE, 0xE5},
        {0xFF, 0xE8},{0x93, 0x0A},{0xC0, 0x2F},{0xC1, 0x2F},{0xC2, 0x2F},{0xC3, 0x2F},{0xC4, 0x2F},{0xC5, 0x30},{0xC6, 0x30},{0xC7, 0x30},
        {0xC8, 0x30},{0xC9, 0x31},{0xCA, 0x31},{0xCB, 0x31},{0xCC, 0x32},{0xCD, 0x32},{0xCE, 0x33},{0xCF, 0x33},{0xD0, 0x34},{0xD1, 0x34},
        {0xD2, 0x35},{0xD3, 0x35},{0xD4, 0x36},{0xD5, 0x37},{0xD6, 0x37},{0xD7, 0x38},{0xD8, 0x39},{0xD9, 0x39},{0xDA, 0x3A},{0xDB, 0x3A},
        {0xDC, 0x3B},{0xDD, 0x3B},{0xDE, 0x3C},{0xDF, 0x3D},{0xE0, 0x3E},{0xE1, 0x3E},{0xE2, 0x3E},{0xE3, 0x3F},{0xE4, 0x40},{0xE5, 0x41},
        {0xE6, 0x42},{0xE7, 0x42},{0xE8, 0x43},{0xE9, 0x45},{0xEA, 0x46},{0xEB, 0x47},{0xEC, 0x48},{0xED, 0x49},{0xEE, 0x49},{0xEF, 0x4A},
        {0xF0, 0x4A},{0xF1, 0x4B},{0xF2, 0x4C},{0xF3, 0x4D},{0xF4, 0x4E},{0xF5, 0x4F},{0xF6, 0x50},{0xF7, 0x51},{0xF8, 0x52},{0xF9, 0x52},
        {0xFA, 0x53},{0xFB, 0x54},{0xFC, 0x55},{0xFD, 0x55},{0xFE, 0x56},{0xFF, 0x57},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x4C},{0xC1, 0x4C},{0xC2, 0x4C},{0xC3, 0x4D},{0xC4, 0x4D},{0xC5, 0x4D},{0xC6, 0x4E},{0xC7, 0x4F},
        {0xC8, 0x50},{0xC9, 0x52},{0xCA, 0x52},{0xCB, 0x53},{0xCC, 0x55},{0xCD, 0x56},{0xCE, 0x57},{0xCF, 0x59},{0xD0, 0x5B},{0xD1, 0x5D},
        {0xD2, 0x5E},{0xD3, 0x60},{0xD4, 0x62},{0xD5, 0x63},{0xD6, 0x66},{0xD7, 0x68},{0xD8, 0x6B},{0xD9, 0x6D},{0xDA, 0x6F},{0xDB, 0x72},
        {0xDC, 0x74},{0xDD, 0x77},{0xDE, 0x7A},{0xDF, 0x7C},{0xE0, 0x7F},{0xE1, 0x82},{0xE2, 0x84},{0xE3, 0x87},{0xE4, 0x88},{0xE5, 0x8B},
        {0xE6, 0x8E},{0xE7, 0x90},{0xE8, 0x92},{0xE9, 0x95},{0xEA, 0x98},{0xEB, 0x9B},{0xEC, 0x9E},{0xED, 0xA0},{0xEE, 0xA3},{0xEF, 0xA6},
        {0xF0, 0xA9},{0xF1, 0xAC},{0xF2, 0xAF},{0xF3, 0xB2},{0xF4, 0xB5},{0xF5, 0xB8},{0xF6, 0xBB},{0xF7, 0xBE},{0xF8, 0xC1},{0xF9, 0xC3},
        {0xFA, 0xC6},{0xFB, 0xC9},{0xFC, 0xCB},{0xFD, 0xCE},{0xFE, 0xD1},{0xFF, 0xD5},{0x93, 0x0D},{0xC0, 0x51},{0xC1, 0x51},{0xC2, 0x52},
        {0xC3, 0x52},{0xC4, 0x52},{0xC5, 0x53},{0xC6, 0x54},{0xC7, 0x55},{0xC8, 0x55},{0xC9, 0x56},{0xCA, 0x57},{0xCB, 0x58},{0xCC, 0x5A},
        {0xCD, 0x5C},{0xCE, 0x5D},{0xCF, 0x5F},{0xD0, 0x61},{0xD1, 0x62},{0xD2, 0x64},{0xD3, 0x66},{0xD4, 0x69},{0xD5, 0x6B},{0xD6, 0x6E},
        {0xD7, 0x70},{0xD8, 0x73},{0xD9, 0x75},{0xDA, 0x78},{0xDB, 0x7A},{0xDC, 0x7D},{0xDD, 0x80},{0xDE, 0x82},{0xDF, 0x84},{0xE0, 0x87},
        {0xE1, 0x89},{0xE2, 0x8C},{0xE3, 0x8F},{0xE4, 0x91},{0xE5, 0x94},{0xE6, 0x97},{0xE7, 0x9A},{0xE8, 0x9D},{0xE9, 0xA0},{0xEA, 0xA3},
        {0xEB, 0xA5},{0xEC, 0xA8},{0xED, 0xAB},{0xEE, 0xAE},{0xEF, 0xB2},{0xF0, 0xB6},{0xF1, 0xB9},{0xF2, 0xBC},{0xF3, 0xBF},{0xF4, 0xC2},
        {0xF5, 0xC4},{0xF6, 0xC7},{0xF7, 0xCA},{0xF8, 0xCC},{0xF9, 0xD0},{0xFA, 0xD4},{0xFB, 0xD7},{0xFC, 0xDA},{0xFD, 0xDD},{0xFE, 0xE0},
        {0xFF, 0xE3},{0x93, 0x0E},{0xC0, 0x2C},{0xC1, 0x2C},{0xC2, 0x2C},{0xC3, 0x2C},{0xC4, 0x2C},{0xC5, 0x2D},{0xC6, 0x2D},{0xC7, 0x2D},
        {0xC8, 0x2D},{0xC9, 0x2E},{0xCA, 0x2E},{0xCB, 0x2E},{0xCC, 0x2F},{0xCD, 0x2F},{0xCE, 0x30},{0xCF, 0x30},{0xD0, 0x31},{0xD1, 0x31},
        {0xD2, 0x32},{0xD3, 0x32},{0xD4, 0x33},{0xD5, 0x34},{0xD6, 0x34},{0xD7, 0x34},{0xD8, 0x35},{0xD9, 0x35},{0xDA, 0x36},{0xDB, 0x37},
        {0xDC, 0x38},{0xDD, 0x38},{0xDE, 0x39},{0xDF, 0x3A},{0xE0, 0x3B},{0xE1, 0x3C},{0xE2, 0x3C},{0xE3, 0x3D},{0xE4, 0x3E},{0xE5, 0x3E},
        {0xE6, 0x3F},{0xE7, 0x3F},{0xE8, 0x40},{0xE9, 0x41},{0xEA, 0x41},{0xEB, 0x42},{0xEC, 0x43},{0xED, 0x44},{0xEE, 0x44},{0xEF, 0x46},
        {0xF0, 0x46},{0xF1, 0x47},{0xF2, 0x48},{0xF3, 0x49},{0xF4, 0x4A},{0xF5, 0x4B},{0xF6, 0x4C},{0xF7, 0x4D},{0xF8, 0x4D},{0xF9, 0x4E},
        {0xFA, 0x4F},{0xFB, 0x50},{0xFC, 0x51},{0xFD, 0x51},{0xFE, 0x52},{0xFF, 0x52},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x43},{0xC1, 0x43},{0xC2, 0x43},{0xC3, 0x44},{0xC4, 0x44},{0xC5, 0x45},{0xC6, 0x46},{0xC7, 0x47},
        {0xC8, 0x48},{0xC9, 0x49},{0xCA, 0x4A},{0xCB, 0x4B},{0xCC, 0x4C},{0xCD, 0x4D},{0xCE, 0x4F},{0xCF, 0x50},{0xD0, 0x52},{0xD1, 0x54},
        {0xD2, 0x55},{0xD3, 0x57},{0xD4, 0x58},{0xD5, 0x59},{0xD6, 0x5B},{0xD7, 0x5D},{0xD8, 0x5F},{0xD9, 0x61},{0xDA, 0x63},{0xDB, 0x65},
        {0xDC, 0x67},{0xDD, 0x69},{0xDE, 0x6C},{0xDF, 0x6E},{0xE0, 0x71},{0xE1, 0x74},{0xE2, 0x76},{0xE3, 0x79},{0xE4, 0x7B},{0xE5, 0x7D},
        {0xE6, 0x7F},{0xE7, 0x82},{0xE8, 0x83},{0xE9, 0x86},{0xEA, 0x89},{0xEB, 0x8B},{0xEC, 0x8E},{0xED, 0x90},{0xEE, 0x92},{0xEF, 0x96},
        {0xF0, 0x99},{0xF1, 0x9B},{0xF2, 0x9E},{0xF3, 0xA1},{0xF4, 0xA4},{0xF5, 0xA7},{0xF6, 0xA9},{0xF7, 0xAC},{0xF8, 0xAF},{0xF9, 0xB2},
        {0xFA, 0xB6},{0xFB, 0xBA},{0xFC, 0xBD},{0xFD, 0xC0},{0xFE, 0xC3},{0xFF, 0xC6},{0x93, 0x11},{0xC0, 0x48},{0xC1, 0x48},{0xC2, 0x49},
        {0xC3, 0x49},{0xC4, 0x4A},{0xC5, 0x4B},{0xC6, 0x4B},{0xC7, 0x4C},{0xC8, 0x4D},{0xC9, 0x4D},{0xCA, 0x4F},{0xCB, 0x4F},{0xCC, 0x51},
        {0xCD, 0x53},{0xCE, 0x54},{0xCF, 0x56},{0xD0, 0x57},{0xD1, 0x59},{0xD2, 0x5A},{0xD3, 0x5B},{0xD4, 0x5E},{0xD5, 0x5F},{0xD6, 0x62},
        {0xD7, 0x63},{0xD8, 0x66},{0xD9, 0x68},{0xDA, 0x6A},{0xDB, 0x6C},{0xDC, 0x6F},{0xDD, 0x72},{0xDE, 0x74},{0xDF, 0x76},{0xE0, 0x7A},
        {0xE1, 0x7C},{0xE2, 0x7E},{0xE3, 0x80},{0xE4, 0x83},{0xE5, 0x85},{0xE6, 0x88},{0xE7, 0x8B},{0xE8, 0x8D},{0xE9, 0x90},{0xEA, 0x92},
        {0xEB, 0x95},{0xEC, 0x98},{0xED, 0x9A},{0xEE, 0x9D},{0xEF, 0xA1},{0xF0, 0xA5},{0xF1, 0xA8},{0xF2, 0xAA},{0xF3, 0xAD},{0xF4, 0xB0},
        {0xF5, 0xB4},{0xF6, 0xB7},{0xF7, 0xBB},{0xF8, 0xBE},{0xF9, 0xC2},{0xFA, 0xC5},{0xFB, 0xC7},{0xFC, 0xCA},{0xFD, 0xCD},{0xFE, 0xD1},
        {0xFF, 0xD4},{0x93, 0x12},{0xC0, 0x28},{0xC1, 0x28},{0xC2, 0x28},{0xC3, 0x28},{0xC4, 0x28},{0xC5, 0x29},{0xC6, 0x29},{0xC7, 0x29},
        {0xC8, 0x29},{0xC9, 0x2A},{0xCA, 0x2A},{0xCB, 0x2A},{0xCC, 0x2B},{0xCD, 0x2B},{0xCE, 0x2C},{0xCF, 0x2C},{0xD0, 0x2D},{0xD1, 0x2D},
        {0xD2, 0x2D},{0xD3, 0x2D},{0xD4, 0x2E},{0xD5, 0x2F},{0xD6, 0x2F},{0xD7, 0x30},{0xD8, 0x30},{0xD9, 0x30},{0xDA, 0x31},{0xDB, 0x32},
        {0xDC, 0x33},{0xDD, 0x33},{0xDE, 0x34},{0xDF, 0x35},{0xE0, 0x36},{0xE1, 0x37},{0xE2, 0x37},{0xE3, 0x38},{0xE4, 0x38},{0xE5, 0x39},
        {0xE6, 0x3A},{0xE7, 0x3A},{0xE8, 0x3A},{0xE9, 0x3B},{0xEA, 0x3C},{0xEB, 0x3C},{0xEC, 0x3D},{0xED, 0x3D},{0xEE, 0x3D},{0xEF, 0x3F},
        {0xF0, 0x3F},{0xF1, 0x3F},{0xF2, 0x40},{0xF3, 0x41},{0xF4, 0x42},{0xF5, 0x43},{0xF6, 0x43},{0xF7, 0x44},{0xF8, 0x45},{0xF9, 0x46},
        {0xFA, 0x47},{0xFB, 0x48},{0xFC, 0x48},{0xFD, 0x48},{0xFE, 0x49},{0xFF, 0x4A},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [15] Medium -4
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x54},{0xC1, 0x54},{0xC2, 0x54},{0xC3, 0x54},{0xC4, 0x55},{0xC5, 0x55},{0xC6, 0x56},{0xC7, 0x57},
        {0xC8, 0x58},{0xC9, 0x59},{0xCA, 0x5A},{0xCB, 0x5B},{0xCC, 0x5C},{0xCD, 0x5E},{0xCE, 0x5F},{0xCF, 0x63},{0xD0, 0x64},{0xD1, 0x65},
        {0xD2, 0x67},{0xD3, 0x6A},{0xD4, 0x6C},{0xD5, 0x6E},{0xD6, 0x70},{0xD7, 0x72},{0xD8, 0x74},{0xD9, 0x77},{0xDA, 0x7A},{0xDB, 0x7D},
        {0xDC, 0x7E},{0xDD, 0x81},{0xDE, 0x83},{0xDF, 0x86},{0xE0, 0x88},{0xE1, 0x8B},{0xE2, 0x8E},{0xE3, 0x91},{0xE4, 0x94},{0xE5, 0x96},
        {0xE6, 0x97},{0xE7, 0x9A},{0xE8, 0x9D},{0xE9, 0xA0},{0xEA, 0xA2},{0xEB, 0xA5},{0xEC, 0xA8},{0xED, 0xAB},{0xEE, 0xAD},{0xEF, 0xB0},
        {0xF0, 0xB3},{0xF1, 0xB6},{0xF2, 0xB9},{0xF3, 0xBD},{0xF4, 0xC0},{0xF5, 0xC3},{0xF6, 0xC5},{0xF7, 0xC7},{0xF8, 0xCA},{0xF9, 0xCD},
        {0xFA, 0xCF},{0xFB, 0xD2},{0xFC, 0xD5},{0xFD, 0xD8},{0xFE, 0xDB},{0xFF, 0xDD},{0x93, 0x09},{0xC0, 0x5B},{0xC1, 0x5B},{0xC2, 0x5B},
        {0xC3, 0x5B},{0xC4, 0x5B},{0xC5, 0x5B},{0xC6, 0x5C},{0xC7, 0x5D},{0xC8, 0x5E},{0xC9, 0x5F},{0xCA, 0x62},{0xCB, 0x63},{0xCC, 0x64},
        {0xCD, 0x65},{0xCE, 0x67},{0xCF, 0x6A},{0xD0, 0x6C},{0xD1, 0x6D},{0xD2, 0x6F},{0xD3, 0x71},{0xD4, 0x73},{0xD5, 0x75},{0xD6, 0x79},
        {0xD7, 0x7B},{0xD8, 0x7E},{0xD9, 0x7F},{0xDA, 0x82},{0xDB, 0x84},{0xDC, 0x87},{0xDD, 0x88},{0xDE, 0x8B},{0xDF, 0x8F},{0xE0, 0x92},
        {0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x99},{0xE4, 0x9B},{0xE5, 0x9E},{0xE6, 0xA1},{0xE7, 0xA4},{0xE8, 0xA7},{0xE9, 0xAA},{0xEA, 0xAC},
        {0xEB, 0xAF},{0xEC, 0xB2},{0xED, 0xB5},{0xEE, 0xB8},{0xEF, 0xBD},{0xF0, 0xC0},{0xF1, 0xC3},{0xF2, 0xC5},{0xF3, 0xC7},{0xF4, 0xCA},
        {0xF5, 0xCD},{0xF6, 0xCF},{0xF7, 0xD3},{0xF8, 0xD6},{0xF9, 0xD9},{0xFA, 0xDC},{0xFB, 0xDE},{0xFC, 0xE1},{0xFD, 0xE3},{0xFE, 0xE7},
        {0xFF, 0xE9},{0x93, 0x0A},{0xC0, 0x33},{0xC1, 0x33},{0xC2, 0x33},{0xC3, 0x33},{0xC4, 0x33},{0xC5, 0x33},{0xC6, 0x33},{0xC7, 0x33},
        {0xC8, 0x34},{0xC9, 0x34},{0xCA, 0x34},{0xCB, 0x35},{0xCC, 0x35},{0xCD, 0x35},{0xCE, 0x36},{0xCF, 0x36},{0xD0, 0x37},{0xD1, 0x38},
        {0xD2, 0x38},{0xD3, 0x39},{0xD4, 0x39},{0xD5, 0x3A},{0xD6, 0x3A},{0xD7, 0x3A},{0xD8, 0x3B},{0xD9, 0x3C},{0xDA, 0x3C},{0xDB, 0x3D},
        {0xDC, 0x3E},{0xDD, 0x3E},{0xDE, 0x3E},{0xDF, 0x3F},{0xE0, 0x40},{0xE1, 0x41},{0xE2, 0x42},{0xE3, 0x42},{0xE4, 0x43},{0xE5, 0x45},
        {0xE6, 0x46},{0xE7, 0x47},{0xE8, 0x48},{0xE9, 0x49},{0xEA, 0x4A},{0xEB, 0x4A},{0xEC, 0x4A},{0xED, 0x4B},{0xEE, 0x4C},{0xEF, 0x4D},
        {0xF0, 0x4E},{0xF1, 0x4F},{0xF2, 0x50},{0xF3, 0x51},{0xF4, 0x52},{0xF5, 0x52},{0xF6, 0x53},{0xF7, 0x54},{0xF8, 0x55},{0xF9, 0x56},
        {0xFA, 0x57},{0xFB, 0x58},{0xFC, 0x59},{0xFD, 0x5A},{0xFE, 0x5B},{0xFF, 0x5B},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x50},{0xC1, 0x50},{0xC2, 0x50},{0xC3, 0x50},{0xC4, 0x51},{0xC5, 0x51},{0xC6, 0x52},{0xC7, 0x52},
        {0xC8, 0x53},{0xC9, 0x54},{0xCA, 0x55},{0xCB, 0x56},{0xCC, 0x57},{0xCD, 0x58},{0xCE, 0x59},{0xCF, 0x5C},{0xD0, 0x5D},{0xD1, 0x5E},
        {0xD2, 0x60},{0xD3, 0x62},{0xD4, 0x63},{0xD5, 0x66},{0xD6, 0x68},{0xD7, 0x6A},{0xD8, 0x6C},{0xD9, 0x6F},{0xDA, 0x71},{0xDB, 0x74},
        {0xDC, 0x76},{0xDD, 0x79},{0xDE, 0x7B},{0xDF, 0x7E},{0xE0, 0x81},{0xE1, 0x83},{0xE2, 0x85},{0xE3, 0x87},{0xE4, 0x8A},{0xE5, 0x8D},
        {0xE6, 0x8F},{0xE7, 0x91},{0xE8, 0x94},{0xE9, 0x97},{0xEA, 0x99},{0xEB, 0x9C},{0xEC, 0x9F},{0xED, 0xA2},{0xEE, 0xA5},{0xEF, 0xA7},
        {0xF0, 0xAA},{0xF1, 0xAD},{0xF2, 0xB0},{0xF3, 0xB3},{0xF4, 0xB7},{0xF5, 0xBA},{0xF6, 0xBD},{0xF7, 0xC0},{0xF8, 0xC3},{0xF9, 0xC5},
        {0xFA, 0xC8},{0xFB, 0xCB},{0xFC, 0xCD},{0xFD, 0xD0},{0xFE, 0xD4},{0xFF, 0xD7},{0x93, 0x0D},{0xC0, 0x55},{0xC1, 0x55},{0xC2, 0x55},
        {0xC3, 0x55},{0xC4, 0x56},{0xC5, 0x56},{0xC6, 0x57},{0xC7, 0x57},{0xC8, 0x58},{0xC9, 0x59},{0xCA, 0x5B},{0xCB, 0x5C},{0xCC, 0x5D},
        {0xCD, 0x5E},{0xCE, 0x60},{0xCF, 0x62},{0xD0, 0x63},{0xD1, 0x65},{0xD2, 0x67},{0xD3, 0x69},{0xD4, 0x6B},{0xD5, 0x6D},{0xD6, 0x70},
        {0xD7, 0x72},{0xD8, 0x75},{0xD9, 0x77},{0xDA, 0x7A},{0xDB, 0x7C},{0xDC, 0x7F},{0xDD, 0x81},{0xDE, 0x83},{0xDF, 0x86},{0xE0, 0x88},
        {0xE1, 0x8B},{0xE2, 0x8E},{0xE3, 0x90},{0xE4, 0x92},{0xE5, 0x95},{0xE6, 0x98},{0xE7, 0x9B},{0xE8, 0x9E},{0xE9, 0xA1},{0xEA, 0xA4},
        {0xEB, 0xA6},{0xEC, 0xA9},{0xED, 0xAC},{0xEE, 0xAF},{0xEF, 0xB3},{0xF0, 0xB7},{0xF1, 0xBA},{0xF2, 0xBD},{0xF3, 0xC0},{0xF4, 0xC3},
        {0xF5, 0xC5},{0xF6, 0xC8},{0xF7, 0xCB},{0xF8, 0xCE},{0xF9, 0xD1},{0xFA, 0xD5},{0xFB, 0xD8},{0xFC, 0xDB},{0xFD, 0xDE},{0xFE, 0xE2},
        {0xFF, 0xE5},{0x93, 0x0E},{0xC0, 0x30},{0xC1, 0x30},{0xC2, 0x30},{0xC3, 0x30},{0xC4, 0x30},{0xC5, 0x30},{0xC6, 0x30},{0xC7, 0x30},
        {0xC8, 0x31},{0xC9, 0x31},{0xCA, 0x31},{0xCB, 0x32},{0xCC, 0x32},{0xCD, 0x32},{0xCE, 0x33},{0xCF, 0x33},{0xD0, 0x34},{0xD1, 0x34},
        {0xD2, 0x34},{0xD3, 0x35},{0xD4, 0x35},{0xD5, 0x36},{0xD6, 0x36},{0xD7, 0x37},{0xD8, 0x38},{0xD9, 0x39},{0xDA, 0x39},{0xDB, 0x3A},
        {0xDC, 0x3B},{0xDD, 0x3B},{0xDE, 0x3C},{0xDF, 0x3D},{0xE0, 0x3E},{0xE1, 0x3E},{0xE2, 0x3F},{0xE3, 0x3F},{0xE4, 0x40},{0xE5, 0x41},
        {0xE6, 0x41},{0xE7, 0x42},{0xE8, 0x43},{0xE9, 0x44},{0xEA, 0x45},{0xEB, 0x46},{0xEC, 0x46},{0xED, 0x47},{0xEE, 0x48},{0xEF, 0x49},
        {0xF0, 0x4A},{0xF1, 0x4B},{0xF2, 0x4C},{0xF3, 0x4D},{0xF4, 0x4D},{0xF5, 0x4E},{0xF6, 0x4F},{0xF7, 0x50},{0xF8, 0x51},{0xF9, 0x52},
        {0xFA, 0x52},{0xFB, 0x53},{0xFC, 0x54},{0xFD, 0x55},{0xFE, 0x55},{0xFF, 0x56},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x48},{0xC1, 0x48},{0xC2, 0x48},{0xC3, 0x48},{0xC4, 0x48},{0xC5, 0x48},{0xC6, 0x49},{0xC7, 0x4A},
        {0xC8, 0x4B},{0xC9, 0x4B},{0xCA, 0x4C},{0xCB, 0x4D},{0xCC, 0x4E},{0xCD, 0x4F},{0xCE, 0x50},{0xCF, 0x53},{0xD0, 0x54},{0xD1, 0x55},
        {0xD2, 0x57},{0xD3, 0x58},{0xD4, 0x59},{0xD5, 0x5B},{0xD6, 0x5D},{0xD7, 0x5E},{0xD8, 0x60},{0xD9, 0x63},{0xDA, 0x64},{0xDB, 0x67},
        {0xDC, 0x68},{0xDD, 0x6B},{0xDE, 0x6D},{0xDF, 0x70},{0xE0, 0x73},{0xE1, 0x75},{0xE2, 0x77},{0xE3, 0x7A},{0xE4, 0x7C},{0xE5, 0x7F},
        {0xE6, 0x80},{0xE7, 0x83},{0xE8, 0x85},{0xE9, 0x88},{0xEA, 0x8A},{0xEB, 0x8C},{0xEC, 0x8F},{0xED, 0x91},{0xEE, 0x94},{0xEF, 0x97},
        {0xF0, 0x9A},{0xF1, 0x9C},{0xF2, 0x9F},{0xF3, 0xA3},{0xF4, 0xA6},{0xF5, 0xA8},{0xF6, 0xAB},{0xF7, 0xAE},{0xF8, 0xB1},{0xF9, 0xB5},
        {0xFA, 0xB8},{0xFB, 0xBC},{0xFC, 0xBF},{0xFD, 0xC2},{0xFE, 0xC5},{0xFF, 0xC7},{0x93, 0x11},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4D},
        {0xC3, 0x4D},{0xC4, 0x4D},{0xC5, 0x4D},{0xC6, 0x4E},{0xC7, 0x4F},{0xC8, 0x4F},{0xC9, 0x50},{0xCA, 0x52},{0xCB, 0x53},{0xCC, 0x54},
        {0xCD, 0x55},{0xCE, 0x57},{0xCF, 0x58},{0xD0, 0x59},{0xD1, 0x5B},{0xD2, 0x5C},{0xD3, 0x5E},{0xD4, 0x5F},{0xD5, 0x61},{0xD6, 0x63},
        {0xD7, 0x65},{0xD8, 0x68},{0xD9, 0x69},{0xDA, 0x6C},{0xDB, 0x6E},{0xDC, 0x71},{0xDD, 0x73},{0xDE, 0x75},{0xDF, 0x78},{0xE0, 0x7B},
        {0xE1, 0x7D},{0xE2, 0x7F},{0xE3, 0x82},{0xE4, 0x83},{0xE5, 0x86},{0xE6, 0x89},{0xE7, 0x8B},{0xE8, 0x8E},{0xE9, 0x90},{0xEA, 0x93},
        {0xEB, 0x96},{0xEC, 0x99},{0xED, 0x9B},{0xEE, 0x9E},{0xEF, 0xA3},{0xF0, 0xA6},{0xF1, 0xA8},{0xF2, 0xAB},{0xF3, 0xAE},{0xF4, 0xB1},
        {0xF5, 0xB5},{0xF6, 0xB8},{0xF7, 0xBD},{0xF8, 0xC0},{0xF9, 0xC3},{0xFA, 0xC6},{0xFB, 0xC8},{0xFC, 0xCB},{0xFD, 0xCE},{0xFE, 0xD3},
        {0xFF, 0xD7},{0x93, 0x12},{0xC0, 0x2C},{0xC1, 0x2C},{0xC2, 0x2C},{0xC3, 0x2C},{0xC4, 0x2C},{0xC5, 0x2C},{0xC6, 0x2C},{0xC7, 0x2C},
        {0xC8, 0x2D},{0xC9, 0x2D},{0xCA, 0x2D},{0xCB, 0x2D},{0xCC, 0x2D},{0xCD, 0x2D},{0xCE, 0x2E},{0xCF, 0x2E},{0xD0, 0x2F},{0xD1, 0x30},
        {0xD2, 0x30},{0xD3, 0x30},{0xD4, 0x30},{0xD5, 0x31},{0xD6, 0x31},{0xD7, 0x32},{0xD8, 0x33},{0xD9, 0x34},{0xDA, 0x34},{0xDB, 0x35},
        {0xDC, 0x36},{0xDD, 0x36},{0xDE, 0x37},{0xDF, 0x38},{0xE0, 0x38},{0xE1, 0x39},{0xE2, 0x3A},{0xE3, 0x3A},{0xE4, 0x3A},{0xE5, 0x3B},
        {0xE6, 0x3C},{0xE7, 0x3C},{0xE8, 0x3D},{0xE9, 0x3D},{0xEA, 0x3E},{0xEB, 0x3F},{0xEC, 0x3F},{0xED, 0x3F},{0xEE, 0x40},{0xEF, 0x41},
        {0xF0, 0x42},{0xF1, 0x43},{0xF2, 0x43},{0xF3, 0x44},{0xF4, 0x45},{0xF5, 0x46},{0xF6, 0x47},{0xF7, 0x48},{0xF8, 0x48},{0xF9, 0x49},
        {0xFA, 0x4A},{0xFB, 0x4B},{0xFC, 0x4B},{0xFD, 0x4C},{0xFE, 0x4D},{0xFF, 0x4D},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [16] Medium -3
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x58},{0xC1, 0x58},{0xC2, 0x58},{0xC3, 0x59},{0xC4, 0x59},{0xC5, 0x59},{0xC6, 0x5A},{0xC7, 0x5B},
        {0xC8, 0x5B},{0xC9, 0x5C},{0xCA, 0x5D},{0xCB, 0x5E},{0xCC, 0x5F},{0xCD, 0x62},{0xCE, 0x63},{0xCF, 0x65},{0xD0, 0x66},{0xD1, 0x68},
        {0xD2, 0x6B},{0xD3, 0x6D},{0xD4, 0x6E},{0xD5, 0x70},{0xD6, 0x72},{0xD7, 0x74},{0xD8, 0x76},{0xD9, 0x7A},{0xDA, 0x7C},{0xDB, 0x7E},
        {0xDC, 0x80},{0xDD, 0x82},{0xDE, 0x85},{0xDF, 0x87},{0xE0, 0x8A},{0xE1, 0x8D},{0xE2, 0x90},{0xE3, 0x93},{0xE4, 0x95},{0xE5, 0x97},
        {0xE6, 0x99},{0xE7, 0x9B},{0xE8, 0x9E},{0xE9, 0xA1},{0xEA, 0xA4},{0xEB, 0xA7},{0xEC, 0xAA},{0xED, 0xAC},{0xEE, 0xAE},{0xEF, 0xB2},
        {0xF0, 0xB5},{0xF1, 0xB8},{0xF2, 0xBC},{0xF3, 0xBF},{0xF4, 0xC2},{0xF5, 0xC4},{0xF6, 0xC6},{0xF7, 0xC8},{0xF8, 0xCB},{0xF9, 0xCE},
        {0xFA, 0xD0},{0xFB, 0xD3},{0xFC, 0xD6},{0xFD, 0xDA},{0xFE, 0xDD},{0xFF, 0xDF},{0x93, 0x09},{0xC0, 0x5E},{0xC1, 0x5F},{0xC2, 0x5F},
        {0xC3, 0x5F},{0xC4, 0x5F},{0xC5, 0x61},{0xC6, 0x62},{0xC7, 0x62},{0xC8, 0x63},{0xC9, 0x64},{0xCA, 0x65},{0xCB, 0x66},{0xCC, 0x67},
        {0xCD, 0x68},{0xCE, 0x6B},{0xCF, 0x6D},{0xD0, 0x6E},{0xD1, 0x70},{0xD2, 0x72},{0xD3, 0x74},{0xD4, 0x76},{0xD5, 0x79},{0xD6, 0x7B},
        {0xD7, 0x7D},{0xD8, 0x7F},{0xD9, 0x81},{0xDA, 0x83},{0xDB, 0x86},{0xDC, 0x87},{0xDD, 0x8A},{0xDE, 0x8E},{0xDF, 0x90},{0xE0, 0x94},
        {0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x9A},{0xE4, 0x9D},{0xE5, 0xA0},{0xE6, 0xA2},{0xE7, 0xA5},{0xE8, 0xA8},{0xE9, 0xAB},{0xEA, 0xAD},
        {0xEB, 0xB0},{0xEC, 0xB3},{0xED, 0xB6},{0xEE, 0xB9},{0xEF, 0xBE},{0xF0, 0xC1},{0xF1, 0xC3},{0xF2, 0xC6},{0xF3, 0xC8},{0xF4, 0xCB},
        {0xF5, 0xCE},{0xF6, 0xD1},{0xF7, 0xD4},{0xF8, 0xD7},{0xF9, 0xDA},{0xFA, 0xDD},{0xFB, 0xDF},{0xFC, 0xE2},{0xFD, 0xE5},{0xFE, 0xE8},
        {0xFF, 0xEA},{0x93, 0x0A},{0xC0, 0x36},{0xC1, 0x36},{0xC2, 0x36},{0xC3, 0x36},{0xC4, 0x36},{0xC5, 0x36},{0xC6, 0x37},{0xC7, 0x37},
        {0xC8, 0x37},{0xC9, 0x37},{0xCA, 0x38},{0xCB, 0x38},{0xCC, 0x38},{0xCD, 0x39},{0xCE, 0x39},{0xCF, 0x3A},{0xD0, 0x3A},{0xD1, 0x3A},
        {0xD2, 0x3A},{0xD3, 0x3B},{0xD4, 0x3B},{0xD5, 0x3C},{0xD6, 0x3D},{0xD7, 0x3D},{0xD8, 0x3E},{0xD9, 0x3E},{0xDA, 0x3E},{0xDB, 0x3F},
        {0xDC, 0x40},{0xDD, 0x41},{0xDE, 0x41},{0xDF, 0x42},{0xE0, 0x43},{0xE1, 0x45},{0xE2, 0x46},{0xE3, 0x47},{0xE4, 0x48},{0xE5, 0x49},
        {0xE6, 0x49},{0xE7, 0x4A},{0xE8, 0x4A},{0xE9, 0x4B},{0xEA, 0x4C},{0xEB, 0x4D},{0xEC, 0x4E},{0xED, 0x4F},{0xEE, 0x50},{0xEF, 0x51},
        {0xF0, 0x52},{0xF1, 0x52},{0xF2, 0x53},{0xF3, 0x54},{0xF4, 0x55},{0xF5, 0x56},{0xF6, 0x57},{0xF7, 0x58},{0xF8, 0x59},{0xF9, 0x5A},
        {0xFA, 0x5B},{0xFB, 0x5B},{0xFC, 0x5C},{0xFD, 0x5E},{0xFE, 0x5F},{0xFF, 0x61},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x53},{0xC1, 0x53},{0xC2, 0x53},{0xC3, 0x54},{0xC4, 0x54},{0xC5, 0x54},{0xC6, 0x55},{0xC7, 0x55},
        {0xC8, 0x56},{0xC9, 0x57},{0xCA, 0x57},{0xCB, 0x58},{0xCC, 0x59},{0xCD, 0x5B},{0xCE, 0x5C},{0xCF, 0x5D},{0xD0, 0x5F},{0xD1, 0x61},
        {0xD2, 0x62},{0xD3, 0x64},{0xD4, 0x66},{0xD5, 0x68},{0xD6, 0x6A},{0xD7, 0x6C},{0xD8, 0x6E},{0xD9, 0x71},{0xDA, 0x73},{0xDB, 0x75},
        {0xDC, 0x78},{0xDD, 0x7A},{0xDE, 0x7D},{0xDF, 0x7F},{0xE0, 0x83},{0xE1, 0x84},{0xE2, 0x87},{0xE3, 0x89},{0xE4, 0x8B},{0xE5, 0x8E},
        {0xE6, 0x90},{0xE7, 0x92},{0xE8, 0x95},{0xE9, 0x98},{0xEA, 0x9B},{0xEB, 0x9E},{0xEC, 0xA1},{0xED, 0xA3},{0xEE, 0xA5},{0xEF, 0xA9},
        {0xF0, 0xAC},{0xF1, 0xAF},{0xF2, 0xB2},{0xF3, 0xB6},{0xF4, 0xB9},{0xF5, 0xBC},{0xF6, 0xBE},{0xF7, 0xC1},{0xF8, 0xC3},{0xF9, 0xC6},
        {0xFA, 0xC9},{0xFB, 0xCB},{0xFC, 0xCE},{0xFD, 0xD2},{0xFE, 0xD6},{0xFF, 0xD9},{0x93, 0x0D},{0xC0, 0x58},{0xC1, 0x59},{0xC2, 0x59},
        {0xC3, 0x59},{0xC4, 0x59},{0xC5, 0x5A},{0xC6, 0x5B},{0xC7, 0x5B},{0xC8, 0x5C},{0xC9, 0x5D},{0xCA, 0x5D},{0xCB, 0x5F},{0xCC, 0x60},
        {0xCD, 0x61},{0xCE, 0x62},{0xCF, 0x64},{0xD0, 0x66},{0xD1, 0x68},{0xD2, 0x6A},{0xD3, 0x6C},{0xD4, 0x6E},{0xD5, 0x70},{0xD6, 0x72},
        {0xD7, 0x74},{0xD8, 0x77},{0xD9, 0x79},{0xDA, 0x7B},{0xDB, 0x7E},{0xDC, 0x80},{0xDD, 0x83},{0xDE, 0x85},{0xDF, 0x87},{0xE0, 0x8A},
        {0xE1, 0x8C},{0xE2, 0x8F},{0xE3, 0x91},{0xE4, 0x94},{0xE5, 0x97},{0xE6, 0x99},{0xE7, 0x9C},{0xE8, 0x9F},{0xE9, 0xA2},{0xEA, 0xA5},
        {0xEB, 0xA7},{0xEC, 0xAA},{0xED, 0xAD},{0xEE, 0xB0},{0xEF, 0xB5},{0xF0, 0xB8},{0xF1, 0xBB},{0xF2, 0xBE},{0xF3, 0xC1},{0xF4, 0xC3},
        {0xF5, 0xC6},{0xF6, 0xCA},{0xF7, 0xCC},{0xF8, 0xCF},{0xF9, 0xD2},{0xFA, 0xD6},{0xFB, 0xD9},{0xFC, 0xDD},{0xFD, 0xE0},{0xFE, 0xE3},
        {0xFF, 0xE6},{0x93, 0x0E},{0xC0, 0x33},{0xC1, 0x33},{0xC2, 0x33},{0xC3, 0x33},{0xC4, 0x33},{0xC5, 0x33},{0xC6, 0x34},{0xC7, 0x34},
        {0xC8, 0x34},{0xC9, 0x34},{0xCA, 0x34},{0xCB, 0x34},{0xCC, 0x34},{0xCD, 0x35},{0xCE, 0x35},{0xCF, 0x36},{0xD0, 0x36},{0xD1, 0x37},
        {0xD2, 0x37},{0xD3, 0x38},{0xD4, 0x38},{0xD5, 0x39},{0xD6, 0x3A},{0xD7, 0x3A},{0xD8, 0x3B},{0xD9, 0x3C},{0xDA, 0x3C},{0xDB, 0x3D},
        {0xDC, 0x3E},{0xDD, 0x3E},{0xDE, 0x3E},{0xDF, 0x3F},{0xE0, 0x40},{0xE1, 0x41},{0xE2, 0x41},{0xE3, 0x42},{0xE4, 0x43},{0xE5, 0x44},
        {0xE6, 0x44},{0xE7, 0x45},{0xE8, 0x46},{0xE9, 0x47},{0xEA, 0x48},{0xEB, 0x49},{0xEC, 0x4A},{0xED, 0x4B},{0xEE, 0x4C},{0xEF, 0x4D},
        {0xF0, 0x4D},{0xF1, 0x4E},{0xF2, 0x4F},{0xF3, 0x50},{0xF4, 0x51},{0xF5, 0x52},{0xF6, 0x52},{0xF7, 0x53},{0xF8, 0x54},{0xF9, 0x55},
        {0xFA, 0x55},{0xFB, 0x56},{0xFC, 0x57},{0xFD, 0x58},{0xFE, 0x59},{0xFF, 0x5A},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x4B},{0xC1, 0x4B},{0xC2, 0x4B},{0xC3, 0x4B},{0xC4, 0x4B},{0xC5, 0x4B},{0xC6, 0x4C},{0xC7, 0x4D},
        {0xC8, 0x4D},{0xC9, 0x4E},{0xCA, 0x4F},{0xCB, 0x4F},{0xCC, 0x50},{0xCD, 0x52},{0xCE, 0x53},{0xCF, 0x55},{0xD0, 0x56},{0xD1, 0x57},
        {0xD2, 0x59},{0xD3, 0x5A},{0xD4, 0x5B},{0xD5, 0x5D},{0xD6, 0x5E},{0xD7, 0x60},{0xD8, 0x62},{0xD9, 0x64},{0xDA, 0x66},{0xDB, 0x68},
        {0xDC, 0x6A},{0xDD, 0x6C},{0xDE, 0x6F},{0xDF, 0x71},{0xE0, 0x74},{0xE1, 0x76},{0xE2, 0x79},{0xE3, 0x7C},{0xE4, 0x7D},{0xE5, 0x7F},
        {0xE6, 0x82},{0xE7, 0x83},{0xE8, 0x86},{0xE9, 0x89},{0xEA, 0x8B},{0xEB, 0x8E},{0xEC, 0x90},{0xED, 0x92},{0xEE, 0x95},{0xEF, 0x99},
        {0xF0, 0x9B},{0xF1, 0x9E},{0xF2, 0xA1},{0xF3, 0xA5},{0xF4, 0xA8},{0xF5, 0xAA},{0xF6, 0xAC},{0xF7, 0xAF},{0xF8, 0xB2},{0xF9, 0xB6},
        {0xFA, 0xBA},{0xFB, 0xBD},{0xFC, 0xC0},{0xFD, 0xC4},{0xFE, 0xC6},{0xFF, 0xC9},{0x93, 0x11},{0xC0, 0x4F},{0xC1, 0x50},{0xC2, 0x50},
        {0xC3, 0x50},{0xC4, 0x50},{0xC5, 0x51},{0xC6, 0x52},{0xC7, 0x52},{0xC8, 0x53},{0xC9, 0x54},{0xCA, 0x55},{0xCB, 0x56},{0xCC, 0x57},
        {0xCD, 0x57},{0xCE, 0x59},{0xCF, 0x5A},{0xD0, 0x5B},{0xD1, 0x5D},{0xD2, 0x5E},{0xD3, 0x60},{0xD4, 0x62},{0xD5, 0x63},{0xD6, 0x65},
        {0xD7, 0x67},{0xD8, 0x69},{0xD9, 0x6B},{0xDA, 0x6D},{0xDB, 0x70},{0xDC, 0x72},{0xDD, 0x74},{0xDE, 0x77},{0xDF, 0x79},{0xE0, 0x7C},
        {0xE1, 0x7E},{0xE2, 0x80},{0xE3, 0x83},{0xE4, 0x85},{0xE5, 0x88},{0xE6, 0x8A},{0xE7, 0x8C},{0xE8, 0x8F},{0xE9, 0x91},{0xEA, 0x94},
        {0xEB, 0x97},{0xEC, 0x9A},{0xED, 0x9C},{0xEE, 0x9F},{0xEF, 0xA4},{0xF0, 0xA7},{0xF1, 0xA9},{0xF2, 0xAC},{0xF3, 0xAF},{0xF4, 0xB2},
        {0xF5, 0xB6},{0xF6, 0xBB},{0xF7, 0xBE},{0xF8, 0xC1},{0xF9, 0xC4},{0xFA, 0xC6},{0xFB, 0xC9},{0xFC, 0xCD},{0xFD, 0xD1},{0xFE, 0xD4},
        {0xFF, 0xD8},{0x93, 0x12},{0xC0, 0x2E},{0xC1, 0x2E},{0xC2, 0x2E},{0xC3, 0x2E},{0xC4, 0x2E},{0xC5, 0x2E},{0xC6, 0x2F},{0xC7, 0x2F},
        {0xC8, 0x2F},{0xC9, 0x2F},{0xCA, 0x30},{0xCB, 0x30},{0xCC, 0x30},{0xCD, 0x30},{0xCE, 0x30},{0xCF, 0x31},{0xD0, 0x31},{0xD1, 0x32},
        {0xD2, 0x32},{0xD3, 0x33},{0xD4, 0x33},{0xD5, 0x34},{0xD6, 0x35},{0xD7, 0x35},{0xD8, 0x36},{0xD9, 0x37},{0xDA, 0x37},{0xDB, 0x38},
        {0xDC, 0x38},{0xDD, 0x39},{0xDE, 0x39},{0xDF, 0x3A},{0xE0, 0x3A},{0xE1, 0x3B},{0xE2, 0x3C},{0xE3, 0x3C},{0xE4, 0x3D},{0xE5, 0x3D},
        {0xE6, 0x3D},{0xE7, 0x3E},{0xE8, 0x3F},{0xE9, 0x3F},{0xEA, 0x40},{0xEB, 0x41},{0xEC, 0x42},{0xED, 0x43},{0xEE, 0x43},{0xEF, 0x44},
        {0xF0, 0x45},{0xF1, 0x46},{0xF2, 0x47},{0xF3, 0x48},{0xF4, 0x48},{0xF5, 0x49},{0xF6, 0x4A},{0xF7, 0x4B},{0xF8, 0x4B},{0xF9, 0x4C},
        {0xFA, 0x4D},{0xFB, 0x4D},{0xFC, 0x4E},{0xFD, 0x4F},{0xFE, 0x50},{0xFF, 0x51},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [17] Medium -2
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x5B},{0xC1, 0x5B},{0xC2, 0x5C},{0xC3, 0x5C},{0xC4, 0x5C},{0xC5, 0x5C},{0xC6, 0x5D},{0xC7, 0x5E},
        {0xC8, 0x5E},{0xC9, 0x5F},{0xCA, 0x61},{0xCB, 0x62},{0xCC, 0x63},{0xCD, 0x65},{0xCE, 0x65},{0xCF, 0x67},{0xD0, 0x6A},{0xD1, 0x6B},
        {0xD2, 0x6D},{0xD3, 0x6E},{0xD4, 0x70},{0xD5, 0x72},{0xD6, 0x74},{0xD7, 0x76},{0xD8, 0x79},{0xD9, 0x7B},{0xDA, 0x7E},{0xDB, 0x7F},
        {0xDC, 0x81},{0xDD, 0x84},{0xDE, 0x86},{0xDF, 0x88},{0xE0, 0x8B},{0xE1, 0x8F},{0xE2, 0x91},{0xE3, 0x94},{0xE4, 0x96},{0xE5, 0x97},
        {0xE6, 0x9A},{0xE7, 0x9D},{0xE8, 0xA0},{0xE9, 0xA2},{0xEA, 0xA5},{0xEB, 0xA8},{0xEC, 0xAB},{0xED, 0xAD},{0xEE, 0xB0},{0xEF, 0xB3},
        {0xF0, 0xB6},{0xF1, 0xB9},{0xF2, 0xBD},{0xF3, 0xC0},{0xF4, 0xC3},{0xF5, 0xC5},{0xF6, 0xC7},{0xF7, 0xCA},{0xF8, 0xCD},{0xF9, 0xCF},
        {0xFA, 0xD2},{0xFB, 0xD5},{0xFC, 0xD8},{0xFD, 0xDB},{0xFE, 0xDD},{0xFF, 0xE0},{0x93, 0x09},{0xC0, 0x64},{0xC1, 0x64},{0xC2, 0x64},
        {0xC3, 0x64},{0xC4, 0x65},{0xC5, 0x65},{0xC6, 0x65},{0xC7, 0x65},{0xC8, 0x66},{0xC9, 0x67},{0xCA, 0x68},{0xCB, 0x6A},{0xCC, 0x6B},
        {0xCD, 0x6D},{0xCE, 0x6D},{0xCF, 0x6F},{0xD0, 0x71},{0xD1, 0x72},{0xD2, 0x74},{0xD3, 0x76},{0xD4, 0x79},{0xD5, 0x7B},{0xD6, 0x7D},
        {0xD7, 0x7E},{0xD8, 0x81},{0xD9, 0x83},{0xDA, 0x85},{0xDB, 0x87},{0xDC, 0x89},{0xDD, 0x8D},{0xDE, 0x8F},{0xDF, 0x92},{0xE0, 0x95},
        {0xE1, 0x97},{0xE2, 0x98},{0xE3, 0x9B},{0xE4, 0x9E},{0xE5, 0xA1},{0xE6, 0xA4},{0xE7, 0xA7},{0xE8, 0xA9},{0xE9, 0xAC},{0xEA, 0xAE},
        {0xEB, 0xB1},{0xEC, 0xB4},{0xED, 0xB7},{0xEE, 0xBB},{0xEF, 0xBF},{0xF0, 0xC2},{0xF1, 0xC4},{0xF2, 0xC6},{0xF3, 0xC9},{0xF4, 0xCC},
        {0xF5, 0xCE},{0xF6, 0xD2},{0xF7, 0xD5},{0xF8, 0xD8},{0xF9, 0xDB},{0xFA, 0xDD},{0xFB, 0xE0},{0xFC, 0xE3},{0xFD, 0xE6},{0xFE, 0xE8},
        {0xFF, 0xEB},{0x93, 0x0A},{0xC0, 0x3A},{0xC1, 0x3A},{0xC2, 0x3A},{0xC3, 0x3A},{0xC4, 0x3A},{0xC5, 0x3A},{0xC6, 0x3A},{0xC7, 0x3A},
        {0xC8, 0x3A},{0xC9, 0x3A},{0xCA, 0x3A},{0xCB, 0x3A},{0xCC, 0x3B},{0xCD, 0x3B},{0xCE, 0x3B},{0xCF, 0x3C},{0xD0, 0x3C},{0xD1, 0x3D},
        {0xD2, 0x3D},{0xD3, 0x3E},{0xD4, 0x3E},{0xD5, 0x3E},{0xD6, 0x3F},{0xD7, 0x3F},{0xD8, 0x40},{0xD9, 0x41},{0xDA, 0x41},{0xDB, 0x42},
        {0xDC, 0x43},{0xDD, 0x45},{0xDE, 0x45},{0xDF, 0x46},{0xE0, 0x47},{0xE1, 0x48},{0xE2, 0x49},{0xE3, 0x4A},{0xE4, 0x4A},{0xE5, 0x4B},
        {0xE6, 0x4C},{0xE7, 0x4D},{0xE8, 0x4E},{0xE9, 0x4E},{0xEA, 0x4F},{0xEB, 0x50},{0xEC, 0x51},{0xED, 0x52},{0xEE, 0x52},{0xEF, 0x54},
        {0xF0, 0x55},{0xF1, 0x56},{0xF2, 0x57},{0xF3, 0x58},{0xF4, 0x59},{0xF5, 0x5A},{0xF6, 0x5B},{0xF7, 0x5B},{0xF8, 0x5C},{0xF9, 0x5D},
        {0xFA, 0x5E},{0xFB, 0x61},{0xFC, 0x62},{0xFD, 0x63},{0xFE, 0x64},{0xFF, 0x65},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x56},{0xC1, 0x56},{0xC2, 0x57},{0xC3, 0x57},{0xC4, 0x57},{0xC5, 0x57},{0xC6, 0x57},{0xC7, 0x58},
        {0xC8, 0x58},{0xC9, 0x59},{0xCA, 0x5A},{0xCB, 0x5B},{0xCC, 0x5C},{0xCD, 0x5D},{0xCE, 0x5E},{0xCF, 0x60},{0xD0, 0x62},{0xD1, 0x62},
        {0xD2, 0x64},{0xD3, 0x66},{0xD4, 0x68},{0xD5, 0x6A},{0xD6, 0x6C},{0xD7, 0x6E},{0xD8, 0x70},{0xD9, 0x72},{0xDA, 0x75},{0xDB, 0x77},
        {0xDC, 0x79},{0xDD, 0x7C},{0xDE, 0x7E},{0xDF, 0x81},{0xE0, 0x83},{0xE1, 0x86},{0xE2, 0x87},{0xE3, 0x8A},{0xE4, 0x8D},{0xE5, 0x8F},
        {0xE6, 0x91},{0xE7, 0x94},{0xE8, 0x97},{0xE9, 0x99},{0xEA, 0x9C},{0xEB, 0x9F},{0xEC, 0xA2},{0xED, 0xA5},{0xEE, 0xA7},{0xEF, 0xAA},
        {0xF0, 0xAD},{0xF1, 0xB0},{0xF2, 0xB3},{0xF3, 0xB7},{0xF4, 0xBA},{0xF5, 0xBD},{0xF6, 0xC0},{0xF7, 0xC3},{0xF8, 0xC5},{0xF9, 0xC8},
        {0xFA, 0xCB},{0xFB, 0xCD},{0xFC, 0xD0},{0xFD, 0xD4},{0xFE, 0xD7},{0xFF, 0xDA},{0x93, 0x0D},{0xC0, 0x5D},{0xC1, 0x5D},{0xC2, 0x5D},
        {0xC3, 0x5D},{0xC4, 0x5D},{0xC5, 0x5D},{0xC6, 0x5E},{0xC7, 0x5E},{0xC8, 0x5F},{0xC9, 0x60},{0xCA, 0x61},{0xCB, 0x62},{0xCC, 0x62},
        {0xCD, 0x64},{0xCE, 0x65},{0xCF, 0x67},{0xD0, 0x69},{0xD1, 0x6A},{0xD2, 0x6C},{0xD3, 0x6E},{0xD4, 0x70},{0xD5, 0x72},{0xD6, 0x74},
        {0xD7, 0x76},{0xD8, 0x79},{0xD9, 0x7B},{0xDA, 0x7D},{0xDB, 0x80},{0xDC, 0x82},{0xDD, 0x84},{0xDE, 0x86},{0xDF, 0x88},{0xE0, 0x8B},
        {0xE1, 0x8E},{0xE2, 0x90},{0xE3, 0x92},{0xE4, 0x95},{0xE5, 0x98},{0xE6, 0x9B},{0xE7, 0x9E},{0xE8, 0xA0},{0xE9, 0xA3},{0xEA, 0xA5},
        {0xEB, 0xA8},{0xEC, 0xAB},{0xED, 0xAE},{0xEE, 0xB1},{0xEF, 0xB6},{0xF0, 0xB9},{0xF1, 0xBC},{0xF2, 0xBF},{0xF3, 0xC2},{0xF4, 0xC4},
        {0xF5, 0xC7},{0xF6, 0xCB},{0xF7, 0xCD},{0xF8, 0xD0},{0xF9, 0xD4},{0xFA, 0xD7},{0xFB, 0xDA},{0xFC, 0xDE},{0xFD, 0xE1},{0xFE, 0xE4},
        {0xFF, 0xE7},{0x93, 0x0E},{0xC0, 0x36},{0xC1, 0x36},{0xC2, 0x36},{0xC3, 0x36},{0xC4, 0x36},{0xC5, 0x36},{0xC6, 0x36},{0xC7, 0x36},
        {0xC8, 0x36},{0xC9, 0x37},{0xCA, 0x37},{0xCB, 0x37},{0xCC, 0x38},{0xCD, 0x38},{0xCE, 0x38},{0xCF, 0x39},{0xD0, 0x39},{0xD1, 0x3A},
        {0xD2, 0x3A},{0xD3, 0x3B},{0xD4, 0x3B},{0xD5, 0x3C},{0xD6, 0x3D},{0xD7, 0x3D},{0xD8, 0x3E},{0xD9, 0x3E},{0xDA, 0x3E},{0xDB, 0x3F},
        {0xDC, 0x40},{0xDD, 0x41},{0xDE, 0x41},{0xDF, 0x41},{0xE0, 0x42},{0xE1, 0x43},{0xE2, 0x44},{0xE3, 0x45},{0xE4, 0x46},{0xE5, 0x47},
        {0xE6, 0x48},{0xE7, 0x49},{0xE8, 0x4A},{0xE9, 0x4A},{0xEA, 0x4B},{0xEB, 0x4C},{0xEC, 0x4D},{0xED, 0x4D},{0xEE, 0x4E},{0xEF, 0x50},
        {0xF0, 0x51},{0xF1, 0x52},{0xF2, 0x52},{0xF3, 0x53},{0xF4, 0x54},{0xF5, 0x55},{0xF6, 0x55},{0xF7, 0x56},{0xF8, 0x57},{0xF9, 0x57},
        {0xFA, 0x58},{0xFB, 0x5A},{0xFC, 0x5B},{0xFD, 0x5C},{0xFE, 0x5D},{0xFF, 0x5D},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4E},{0xC3, 0x4E},{0xC4, 0x4E},{0xC5, 0x4E},{0xC6, 0x4F},{0xC7, 0x4F},
        {0xC8, 0x4F},{0xC9, 0x50},{0xCA, 0x51},{0xCB, 0x52},{0xCC, 0x53},{0xCD, 0x55},{0xCE, 0x55},{0xCF, 0x57},{0xD0, 0x58},{0xD1, 0x59},
        {0xD2, 0x5A},{0xD3, 0x5B},{0xD4, 0x5D},{0xD5, 0x5E},{0xD6, 0x60},{0xD7, 0x62},{0xD8, 0x63},{0xD9, 0x65},{0xDA, 0x68},{0xDB, 0x69},
        {0xDC, 0x6B},{0xDD, 0x6E},{0xDE, 0x70},{0xDF, 0x73},{0xE0, 0x75},{0xE1, 0x78},{0xE2, 0x7A},{0xE3, 0x7C},{0xE4, 0x7F},{0xE5, 0x80},
        {0xE6, 0x83},{0xE7, 0x85},{0xE8, 0x88},{0xE9, 0x8A},{0xEA, 0x8C},{0xEB, 0x8F},{0xEC, 0x91},{0xED, 0x94},{0xEE, 0x97},{0xEF, 0x9A},
        {0xF0, 0x9C},{0xF1, 0x9F},{0xF2, 0xA3},{0xF3, 0xA6},{0xF4, 0xA8},{0xF5, 0xAB},{0xF6, 0xAE},{0xF7, 0xB1},{0xF8, 0xB5},{0xF9, 0xB8},
        {0xFA, 0xBC},{0xFB, 0xBF},{0xFC, 0xC2},{0xFD, 0xC5},{0xFE, 0xC7},{0xFF, 0xCA},{0x93, 0x11},{0xC0, 0x54},{0xC1, 0x54},{0xC2, 0x54},
        {0xC3, 0x54},{0xC4, 0x55},{0xC5, 0x55},{0xC6, 0x55},{0xC7, 0x55},{0xC8, 0x56},{0xC9, 0x57},{0xCA, 0x57},{0xCB, 0x58},{0xCC, 0x59},
        {0xCD, 0x5A},{0xCE, 0x5B},{0xCF, 0x5C},{0xD0, 0x5E},{0xD1, 0x5E},{0xD2, 0x60},{0xD3, 0x62},{0xD4, 0x63},{0xD5, 0x65},{0xD6, 0x67},
        {0xD7, 0x68},{0xD8, 0x6B},{0xD9, 0x6D},{0xDA, 0x6F},{0xDB, 0x72},{0xDC, 0x74},{0xDD, 0x76},{0xDE, 0x78},{0xDF, 0x7B},{0xE0, 0x7D},
        {0xE1, 0x7F},{0xE2, 0x81},{0xE3, 0x83},{0xE4, 0x86},{0xE5, 0x89},{0xE6, 0x8B},{0xE7, 0x8E},{0xE8, 0x90},{0xE9, 0x92},{0xEA, 0x95},
        {0xEB, 0x98},{0xEC, 0x9A},{0xED, 0x9D},{0xEE, 0xA0},{0xEF, 0xA5},{0xF0, 0xA8},{0xF1, 0xAA},{0xF2, 0xAD},{0xF3, 0xB0},{0xF4, 0xB4},
        {0xF5, 0xB7},{0xF6, 0xBC},{0xF7, 0xBF},{0xF8, 0xC2},{0xF9, 0xC5},{0xFA, 0xC7},{0xFB, 0xCA},{0xFC, 0xCE},{0xFD, 0xD2},{0xFE, 0xD5},
        {0xFF, 0xD9},{0x93, 0x12},{0xC0, 0x31},{0xC1, 0x31},{0xC2, 0x31},{0xC3, 0x31},{0xC4, 0x31},{0xC5, 0x31},{0xC6, 0x31},{0xC7, 0x31},
        {0xC8, 0x31},{0xC9, 0x32},{0xCA, 0x32},{0xCB, 0x32},{0xCC, 0x33},{0xCD, 0x33},{0xCE, 0x33},{0xCF, 0x34},{0xD0, 0x34},{0xD1, 0x35},
        {0xD2, 0x35},{0xD3, 0x36},{0xD4, 0x36},{0xD5, 0x37},{0xD6, 0x38},{0xD7, 0x38},{0xD8, 0x38},{0xD9, 0x39},{0xDA, 0x39},{0xDB, 0x3A},
        {0xDC, 0x3A},{0xDD, 0x3B},{0xDE, 0x3B},{0xDF, 0x3C},{0xE0, 0x3C},{0xE1, 0x3D},{0xE2, 0x3D},{0xE3, 0x3E},{0xE4, 0x3F},{0xE5, 0x3F},
        {0xE6, 0x40},{0xE7, 0x41},{0xE8, 0x42},{0xE9, 0x42},{0xEA, 0x43},{0xEB, 0x43},{0xEC, 0x44},{0xED, 0x45},{0xEE, 0x46},{0xEF, 0x48},
        {0xF0, 0x48},{0xF1, 0x49},{0xF2, 0x4A},{0xF3, 0x4B},{0xF4, 0x4B},{0xF5, 0x4C},{0xF6, 0x4D},{0xF7, 0x4D},{0xF8, 0x4E},{0xF9, 0x4F},
        {0xFA, 0x4F},{0xFB, 0x51},{0xFC, 0x52},{0xFD, 0x53},{0xFE, 0x54},{0xFF, 0x55},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [18] Medium -1
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x61},{0xC1, 0x61},{0xC2, 0x61},{0xC3, 0x61},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x62},{0xC7, 0x62},
        {0xC8, 0x63},{0xC9, 0x64},{0xCA, 0x65},{0xCB, 0x65},{0xCC, 0x66},{0xCD, 0x67},{0xCE, 0x68},{0xCF, 0x6B},{0xD0, 0x6C},{0xD1, 0x6D},
        {0xD2, 0x6E},{0xD3, 0x70},{0xD4, 0x72},{0xD5, 0x74},{0xD6, 0x76},{0xD7, 0x79},{0xD8, 0x7B},{0xD9, 0x7D},{0xDA, 0x7E},{0xDB, 0x81},
        {0xDC, 0x83},{0xDD, 0x85},{0xDE, 0x87},{0xDF, 0x89},{0xE0, 0x8D},{0xE1, 0x90},{0xE2, 0x93},{0xE3, 0x95},{0xE4, 0x97},{0xE5, 0x99},
        {0xE6, 0x9B},{0xE7, 0x9E},{0xE8, 0xA1},{0xE9, 0xA4},{0xEA, 0xA6},{0xEB, 0xA9},{0xEC, 0xAC},{0xED, 0xAE},{0xEE, 0xB1},{0xEF, 0xB4},
        {0xF0, 0xB7},{0xF1, 0xBB},{0xF2, 0xBE},{0xF3, 0xC1},{0xF4, 0xC3},{0xF5, 0xC6},{0xF6, 0xC8},{0xF7, 0xCB},{0xF8, 0xCE},{0xF9, 0xD0},
        {0xFA, 0xD3},{0xFB, 0xD6},{0xFC, 0xD9},{0xFD, 0xDC},{0xFE, 0xDE},{0xFF, 0xE1},{0x93, 0x09},{0xC0, 0x68},{0xC1, 0x68},{0xC2, 0x68},
        {0xC3, 0x68},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x6A},{0xC7, 0x6A},{0xC8, 0x6B},{0xC9, 0x6C},{0xCA, 0x6D},{0xCB, 0x6D},{0xCC, 0x6E},
        {0xCD, 0x6F},{0xCE, 0x70},{0xCF, 0x72},{0xD0, 0x73},{0xD1, 0x75},{0xD2, 0x77},{0xD3, 0x79},{0xD4, 0x7B},{0xD5, 0x7D},{0xD6, 0x7E},
        {0xD7, 0x80},{0xD8, 0x82},{0xD9, 0x85},{0xDA, 0x87},{0xDB, 0x88},{0xDC, 0x8B},{0xDD, 0x8E},{0xDE, 0x91},{0xDF, 0x93},{0xE0, 0x95},
        {0xE1, 0x97},{0xE2, 0x9A},{0xE3, 0x9C},{0xE4, 0x9F},{0xE5, 0xA2},{0xE6, 0xA5},{0xE7, 0xA8},{0xE8, 0xAA},{0xE9, 0xAC},{0xEA, 0xAF},
        {0xEB, 0xB2},{0xEC, 0xB5},{0xED, 0xB8},{0xEE, 0xBC},{0xEF, 0xC0},{0xF0, 0xC3},{0xF1, 0xC5},{0xF2, 0xC7},{0xF3, 0xCA},{0xF4, 0xCD},
        {0xF5, 0xCF},{0xF6, 0xD3},{0xF7, 0xD6},{0xF8, 0xD9},{0xF9, 0xDC},{0xFA, 0xDE},{0xFB, 0xE1},{0xFC, 0xE4},{0xFD, 0xE7},{0xFE, 0xE9},
        {0xFF, 0xEC},{0x93, 0x0A},{0xC0, 0x3C},{0xC1, 0x3C},{0xC2, 0x3C},{0xC3, 0x3C},{0xC4, 0x3C},{0xC5, 0x3C},{0xC6, 0x3C},{0xC7, 0x3D},
        {0xC8, 0x3D},{0xC9, 0x3D},{0xCA, 0x3D},{0xCB, 0x3D},{0xCC, 0x3E},{0xCD, 0x3E},{0xCE, 0x3E},{0xCF, 0x3E},{0xD0, 0x3E},{0xD1, 0x3F},
        {0xD2, 0x3F},{0xD3, 0x40},{0xD4, 0x40},{0xD5, 0x41},{0xD6, 0x42},{0xD7, 0x42},{0xD8, 0x43},{0xD9, 0x45},{0xDA, 0x45},{0xDB, 0x46},
        {0xDC, 0x47},{0xDD, 0x48},{0xDE, 0x48},{0xDF, 0x49},{0xE0, 0x4A},{0xE1, 0x4A},{0xE2, 0x4B},{0xE3, 0x4C},{0xE4, 0x4D},{0xE5, 0x4E},
        {0xE6, 0x4F},{0xE7, 0x50},{0xE8, 0x51},{0xE9, 0x52},{0xEA, 0x52},{0xEB, 0x53},{0xEC, 0x54},{0xED, 0x55},{0xEE, 0x56},{0xEF, 0x57},
        {0xF0, 0x58},{0xF1, 0x59},{0xF2, 0x5A},{0xF3, 0x5B},{0xF4, 0x5C},{0xF5, 0x5D},{0xF6, 0x5E},{0xF7, 0x5F},{0xF8, 0x61},{0xF9, 0x62},
        {0xFA, 0x63},{0xFB, 0x65},{0xFC, 0x65},{0xFD, 0x66},{0xFE, 0x67},{0xFF, 0x68},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x5A},{0xC1, 0x5A},{0xC2, 0x5A},{0xC3, 0x5A},{0xC4, 0x5A},{0xC5, 0x5A},{0xC6, 0x5B},{0xC7, 0x5B},
        {0xC8, 0x5C},{0xC9, 0x5D},{0xCA, 0x5D},{0xCB, 0x5E},{0xCC, 0x5F},{0xCD, 0x60},{0xCE, 0x61},{0xCF, 0x62},{0xD0, 0x63},{0xD1, 0x65},
        {0xD2, 0x66},{0xD3, 0x68},{0xD4, 0x6A},{0xD5, 0x6C},{0xD6, 0x6E},{0xD7, 0x70},{0xD8, 0x72},{0xD9, 0x74},{0xDA, 0x76},{0xDB, 0x79},
        {0xDC, 0x7B},{0xDD, 0x7D},{0xDE, 0x80},{0xDF, 0x82},{0xE0, 0x84},{0xE1, 0x87},{0xE2, 0x89},{0xE3, 0x8B},{0xE4, 0x8E},{0xE5, 0x90},
        {0xE6, 0x92},{0xE7, 0x95},{0xE8, 0x98},{0xE9, 0x9B},{0xEA, 0x9D},{0xEB, 0xA0},{0xEC, 0xA3},{0xED, 0xA5},{0xEE, 0xA8},{0xEF, 0xAB},
        {0xF0, 0xAE},{0xF1, 0xB1},{0xF2, 0xB5},{0xF3, 0xB8},{0xF4, 0xBB},{0xF5, 0xBE},{0xF6, 0xC1},{0xF7, 0xC3},{0xF8, 0xC6},{0xF9, 0xC9},
        {0xFA, 0xCB},{0xFB, 0xCE},{0xFC, 0xD1},{0xFD, 0xD5},{0xFE, 0xD8},{0xFF, 0xDC},{0x93, 0x0D},{0xC0, 0x61},{0xC1, 0x61},{0xC2, 0x61},
        {0xC3, 0x61},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x62},{0xC7, 0x62},{0xC8, 0x62},{0xC9, 0x63},{0xCA, 0x64},{0xCB, 0x65},{0xCC, 0x66},
        {0xCD, 0x67},{0xCE, 0x68},{0xCF, 0x6A},{0xD0, 0x6B},{0xD1, 0x6D},{0xD2, 0x6F},{0xD3, 0x70},{0xD4, 0x72},{0xD5, 0x74},{0xD6, 0x76},
        {0xD7, 0x78},{0xD8, 0x7A},{0xD9, 0x7D},{0xDA, 0x7F},{0xDB, 0x81},{0xDC, 0x83},{0xDD, 0x85},{0xDE, 0x87},{0xDF, 0x89},{0xE0, 0x8C},
        {0xE1, 0x8F},{0xE2, 0x91},{0xE3, 0x93},{0xE4, 0x96},{0xE5, 0x99},{0xE6, 0x9C},{0xE7, 0x9F},{0xE8, 0xA1},{0xE9, 0xA4},{0xEA, 0xA6},
        {0xEB, 0xA9},{0xEC, 0xAC},{0xED, 0xAF},{0xEE, 0xB2},{0xEF, 0xB7},{0xF0, 0xBA},{0xF1, 0xBD},{0xF2, 0xC0},{0xF3, 0xC3},{0xF4, 0xC5},
        {0xF5, 0xC8},{0xF6, 0xCB},{0xF7, 0xCE},{0xF8, 0xD1},{0xF9, 0xD5},{0xFA, 0xD8},{0xFB, 0xDB},{0xFC, 0xDF},{0xFD, 0xE2},{0xFE, 0xE5},
        {0xFF, 0xE8},{0x93, 0x0E},{0xC0, 0x39},{0xC1, 0x39},{0xC2, 0x39},{0xC3, 0x39},{0xC4, 0x39},{0xC5, 0x39},{0xC6, 0x39},{0xC7, 0x3A},
        {0xC8, 0x3A},{0xC9, 0x3A},{0xCA, 0x3A},{0xCB, 0x3A},{0xCC, 0x3B},{0xCD, 0x3B},{0xCE, 0x3B},{0xCF, 0x3C},{0xD0, 0x3C},{0xD1, 0x3D},
        {0xD2, 0x3D},{0xD3, 0x3E},{0xD4, 0x3E},{0xD5, 0x3E},{0xD6, 0x3F},{0xD7, 0x3F},{0xD8, 0x40},{0xD9, 0x41},{0xDA, 0x41},{0xDB, 0x41},
        {0xDC, 0x42},{0xDD, 0x43},{0xDE, 0x43},{0xDF, 0x44},{0xE0, 0x45},{0xE1, 0x46},{0xE2, 0x47},{0xE3, 0x48},{0xE4, 0x49},{0xE5, 0x4A},
        {0xE6, 0x4B},{0xE7, 0x4C},{0xE8, 0x4D},{0xE9, 0x4D},{0xEA, 0x4E},{0xEB, 0x4F},{0xEC, 0x50},{0xED, 0x51},{0xEE, 0x52},{0xEF, 0x52},
        {0xF0, 0x53},{0xF1, 0x54},{0xF2, 0x55},{0xF3, 0x56},{0xF4, 0x57},{0xF5, 0x57},{0xF6, 0x58},{0xF7, 0x59},{0xF8, 0x5A},{0xF9, 0x5B},
        {0xFA, 0x5C},{0xFB, 0x5D},{0xFC, 0x5E},{0xFD, 0x5F},{0xFE, 0x60},{0xFF, 0x61},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x51},{0xC1, 0x51},{0xC2, 0x51},{0xC3, 0x51},{0xC4, 0x51},{0xC5, 0x51},{0xC6, 0x52},{0xC7, 0x52},
        {0xC8, 0x53},{0xC9, 0x54},{0xCA, 0x55},{0xCB, 0x55},{0xCC, 0x56},{0xCD, 0x57},{0xCE, 0x57},{0xCF, 0x59},{0xD0, 0x59},{0xD1, 0x5B},
        {0xD2, 0x5B},{0xD3, 0x5D},{0xD4, 0x5E},{0xD5, 0x60},{0xD6, 0x62},{0xD7, 0x63},{0xD8, 0x65},{0xD9, 0x67},{0xDA, 0x68},{0xDB, 0x6B},
        {0xDC, 0x6D},{0xDD, 0x6F},{0xDE, 0x72},{0xDF, 0x74},{0xE0, 0x76},{0xE1, 0x79},{0xE2, 0x7C},{0xE3, 0x7D},{0xE4, 0x7F},{0xE5, 0x82},
        {0xE6, 0x83},{0xE7, 0x86},{0xE8, 0x89},{0xE9, 0x8B},{0xEA, 0x8D},{0xEB, 0x90},{0xEC, 0x92},{0xED, 0x95},{0xEE, 0x98},{0xEF, 0x9A},
        {0xF0, 0x9D},{0xF1, 0xA0},{0xF2, 0xA4},{0xF3, 0xA7},{0xF4, 0xA9},{0xF5, 0xAC},{0xF6, 0xAF},{0xF7, 0xB2},{0xF8, 0xB6},{0xF9, 0xBA},
        {0xFA, 0xBD},{0xFB, 0xC0},{0xFC, 0xC3},{0xFD, 0xC6},{0xFE, 0xC8},{0xFF, 0xCC},{0x93, 0x11},{0xC0, 0x57},{0xC1, 0x57},{0xC2, 0x57},
        {0xC3, 0x57},{0xC4, 0x57},{0xC5, 0x57},{0xC6, 0x58},{0xC7, 0x58},{0xC8, 0x59},{0xC9, 0x59},{0xCA, 0x5A},{0xCB, 0x5B},{0xCC, 0x5B},
        {0xCD, 0x5C},{0xCE, 0x5D},{0xCF, 0x5E},{0xD0, 0x5F},{0xD1, 0x61},{0xD2, 0x63},{0xD3, 0x63},{0xD4, 0x65},{0xD5, 0x67},{0xD6, 0x68},
        {0xD7, 0x6A},{0xD8, 0x6C},{0xD9, 0x6F},{0xDA, 0x71},{0xDB, 0x73},{0xDC, 0x75},{0xDD, 0x77},{0xDE, 0x7A},{0xDF, 0x7C},{0xE0, 0x7E},
        {0xE1, 0x80},{0xE2, 0x83},{0xE3, 0x84},{0xE4, 0x87},{0xE5, 0x8A},{0xE6, 0x8C},{0xE7, 0x8F},{0xE8, 0x90},{0xE9, 0x93},{0xEA, 0x96},
        {0xEB, 0x99},{0xEC, 0x9B},{0xED, 0x9E},{0xEE, 0xA1},{0xEF, 0xA6},{0xF0, 0xA8},{0xF1, 0xAB},{0xF2, 0xAE},{0xF3, 0xB1},{0xF4, 0xB5},
        {0xF5, 0xB8},{0xF6, 0xBD},{0xF7, 0xC0},{0xF8, 0xC3},{0xF9, 0xC6},{0xFA, 0xC8},{0xFB, 0xCB},{0xFC, 0xCF},{0xFD, 0xD3},{0xFE, 0xD7},
        {0xFF, 0xDB},{0x93, 0x12},{0xC0, 0x34},{0xC1, 0x34},{0xC2, 0x34},{0xC3, 0x34},{0xC4, 0x34},{0xC5, 0x34},{0xC6, 0x34},{0xC7, 0x35},
        {0xC8, 0x35},{0xC9, 0x35},{0xCA, 0x35},{0xCB, 0x35},{0xCC, 0x36},{0xCD, 0x36},{0xCE, 0x36},{0xCF, 0x37},{0xD0, 0x37},{0xD1, 0x38},
        {0xD2, 0x38},{0xD3, 0x38},{0xD4, 0x38},{0xD5, 0x39},{0xD6, 0x3A},{0xD7, 0x3A},{0xD8, 0x3A},{0xD9, 0x3B},{0xDA, 0x3B},{0xDB, 0x3C},
        {0xDC, 0x3C},{0xDD, 0x3D},{0xDE, 0x3D},{0xDF, 0x3D},{0xE0, 0x3E},{0xE1, 0x3F},{0xE2, 0x3F},{0xE3, 0x40},{0xE4, 0x41},{0xE5, 0x42},
        {0xE6, 0x43},{0xE7, 0x43},{0xE8, 0x44},{0xE9, 0x45},{0xEA, 0x46},{0xEB, 0x47},{0xEC, 0x48},{0xED, 0x48},{0xEE, 0x49},{0xEF, 0x4A},
        {0xF0, 0x4B},{0xF1, 0x4B},{0xF2, 0x4C},{0xF3, 0x4D},{0xF4, 0x4E},{0xF5, 0x4F},{0xF6, 0x4F},{0xF7, 0x50},{0xF8, 0x51},{0xF9, 0x52},
        {0xFA, 0x53},{0xFB, 0x55},{0xFC, 0x55},{0xFD, 0x56},{0xFE, 0x57},{0xFF, 0x57},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [19] Medium 0
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x65},{0xC1, 0x65},{0xC2, 0x65},{0xC3, 0x65},{0xC4, 0x65},{0xC5, 0x65},{0xC6, 0x65},{0xC7, 0x65},
        {0xC8, 0x66},{0xC9, 0x66},{0xCA, 0x67},{0xCB, 0x68},{0xCC, 0x6A},{0xCD, 0x6B},{0xCE, 0x6C},{0xCF, 0x6D},{0xD0, 0x6E},{0xD1, 0x6F},
        {0xD2, 0x71},{0xD3, 0x72},{0xD4, 0x74},{0xD5, 0x76},{0xD6, 0x79},{0xD7, 0x7B},{0xD8, 0x7D},{0xD9, 0x7E},{0xDA, 0x80},{0xDB, 0x82},
        {0xDC, 0x85},{0xDD, 0x87},{0xDE, 0x88},{0xDF, 0x8B},{0xE0, 0x8F},{0xE1, 0x91},{0xE2, 0x94},{0xE3, 0x95},{0xE4, 0x97},{0xE5, 0x9A},
        {0xE6, 0x9C},{0xE7, 0x9F},{0xE8, 0xA2},{0xE9, 0xA5},{0xEA, 0xA8},{0xEB, 0xAA},{0xEC, 0xAC},{0xED, 0xAF},{0xEE, 0xB2},{0xEF, 0xB6},
        {0xF0, 0xB8},{0xF1, 0xBC},{0xF2, 0xBF},{0xF3, 0xC2},{0xF4, 0xC4},{0xF5, 0xC6},{0xF6, 0xC9},{0xF7, 0xCC},{0xF8, 0xCE},{0xF9, 0xD1},
        {0xFA, 0xD4},{0xFB, 0xD8},{0xFC, 0xDB},{0xFD, 0xDD},{0xFE, 0xE0},{0xFF, 0xE2},{0x93, 0x09},{0xC0, 0x6D},{0xC1, 0x6D},{0xC2, 0x6D},
        {0xC3, 0x6D},{0xC4, 0x6D},{0xC5, 0x6D},{0xC6, 0x6D},{0xC7, 0x6D},{0xC8, 0x6E},{0xC9, 0x6E},{0xCA, 0x6F},{0xCB, 0x70},{0xCC, 0x71},
        {0xCD, 0x72},{0xCE, 0x73},{0xCF, 0x75},{0xD0, 0x76},{0xD1, 0x77},{0xD2, 0x7A},{0xD3, 0x7C},{0xD4, 0x7D},{0xD5, 0x7E},{0xD6, 0x80},
        {0xD7, 0x82},{0xD8, 0x84},{0xD9, 0x86},{0xDA, 0x88},{0xDB, 0x8A},{0xDC, 0x8D},{0xDD, 0x90},{0xDE, 0x92},{0xDF, 0x94},{0xE0, 0x97},
        {0xE1, 0x98},{0xE2, 0x9B},{0xE3, 0x9D},{0xE4, 0xA0},{0xE5, 0xA3},{0xE6, 0xA6},{0xE7, 0xA9},{0xE8, 0xAB},{0xE9, 0xAD},{0xEA, 0xB0},
        {0xEB, 0xB3},{0xEC, 0xB6},{0xED, 0xB9},{0xEE, 0xBD},{0xEF, 0xC1},{0xF0, 0xC3},{0xF1, 0xC6},{0xF2, 0xC8},{0xF3, 0xCB},{0xF4, 0xCE},
        {0xF5, 0xD0},{0xF6, 0xD3},{0xF7, 0xD7},{0xF8, 0xDA},{0xF9, 0xDD},{0xFA, 0xDF},{0xFB, 0xE1},{0xFC, 0xE4},{0xFD, 0xE8},{0xFE, 0xEA},
        {0xFF, 0xED},{0x93, 0x0A},{0xC0, 0x3E},{0xC1, 0x3E},{0xC2, 0x3E},{0xC3, 0x3F},{0xC4, 0x3F},{0xC5, 0x3F},{0xC6, 0x3F},{0xC7, 0x3F},
        {0xC8, 0x3F},{0xC9, 0x3F},{0xCA, 0x3F},{0xCB, 0x40},{0xCC, 0x40},{0xCD, 0x40},{0xCE, 0x41},{0xCF, 0x41},{0xD0, 0x41},{0xD1, 0x42},
        {0xD2, 0x42},{0xD3, 0x43},{0xD4, 0x43},{0xD5, 0x45},{0xD6, 0x46},{0xD7, 0x46},{0xD8, 0x47},{0xD9, 0x48},{0xDA, 0x48},{0xDB, 0x49},
        {0xDC, 0x4A},{0xDD, 0x4A},{0xDE, 0x4A},{0xDF, 0x4B},{0xE0, 0x4C},{0xE1, 0x4D},{0xE2, 0x4E},{0xE3, 0x4F},{0xE4, 0x50},{0xE5, 0x51},
        {0xE6, 0x52},{0xE7, 0x52},{0xE8, 0x53},{0xE9, 0x54},{0xEA, 0x55},{0xEB, 0x56},{0xEC, 0x57},{0xED, 0x58},{0xEE, 0x59},{0xEF, 0x5A},
        {0xF0, 0x5B},{0xF1, 0x5C},{0xF2, 0x5D},{0xF3, 0x5E},{0xF4, 0x5F},{0xF5, 0x61},{0xF6, 0x62},{0xF7, 0x64},{0xF8, 0x65},{0xF9, 0x65},
        {0xFA, 0x66},{0xFB, 0x67},{0xFC, 0x6A},{0xFD, 0x6B},{0xFE, 0x6C},{0xFF, 0x6D},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x5D},{0xC1, 0x5D},{0xC2, 0x5D},{0xC3, 0x5D},{0xC4, 0x5D},{0xC5, 0x5D},{0xC6, 0x5E},{0xC7, 0x5E},
        {0xC8, 0x5F},{0xC9, 0x5F},{0xCA, 0x60},{0xCB, 0x61},{0xCC, 0x62},{0xCD, 0x62},{0xCE, 0x63},{0xCF, 0x64},{0xD0, 0x66},{0xD1, 0x67},
        {0xD2, 0x69},{0xD3, 0x6A},{0xD4, 0x6C},{0xD5, 0x6E},{0xD6, 0x70},{0xD7, 0x72},{0xD8, 0x74},{0xD9, 0x76},{0xDA, 0x78},{0xDB, 0x7A},
        {0xDC, 0x7D},{0xDD, 0x7F},{0xDE, 0x81},{0xDF, 0x83},{0xE0, 0x86},{0xE1, 0x87},{0xE2, 0x8A},{0xE3, 0x8C},{0xE4, 0x8F},{0xE5, 0x91},
        {0xE6, 0x93},{0xE7, 0x96},{0xE8, 0x99},{0xE9, 0x9C},{0xEA, 0x9F},{0xEB, 0xA1},{0xEC, 0xA4},{0xED, 0xA6},{0xEE, 0xA9},{0xEF, 0xAD},
        {0xF0, 0xAF},{0xF1, 0xB2},{0xF2, 0xB6},{0xF3, 0xB9},{0xF4, 0xBC},{0xF5, 0xBF},{0xF6, 0xC2},{0xF7, 0xC4},{0xF8, 0xC7},{0xF9, 0xCA},
        {0xFA, 0xCC},{0xFB, 0xD0},{0xFC, 0xD4},{0xFD, 0xD7},{0xFE, 0xDA},{0xFF, 0xDD},{0x93, 0x0D},{0xC0, 0x64},{0xC1, 0x64},{0xC2, 0x64},
        {0xC3, 0x64},{0xC4, 0x64},{0xC5, 0x64},{0xC6, 0x65},{0xC7, 0x65},{0xC8, 0x66},{0xC9, 0x66},{0xCA, 0x67},{0xCB, 0x68},{0xCC, 0x69},
        {0xCD, 0x6A},{0xCE, 0x6B},{0xCF, 0x6D},{0xD0, 0x6E},{0xD1, 0x6F},{0xD2, 0x71},{0xD3, 0x73},{0xD4, 0x74},{0xD5, 0x76},{0xD6, 0x78},
        {0xD7, 0x7A},{0xD8, 0x7C},{0xD9, 0x7E},{0xDA, 0x81},{0xDB, 0x83},{0xDC, 0x84},{0xDD, 0x87},{0xDE, 0x88},{0xDF, 0x8A},{0xE0, 0x8E},
        {0xE1, 0x90},{0xE2, 0x92},{0xE3, 0x94},{0xE4, 0x97},{0xE5, 0x9A},{0xE6, 0x9D},{0xE7, 0xA0},{0xE8, 0xA2},{0xE9, 0xA5},{0xEA, 0xA7},
        {0xEB, 0xAA},{0xEC, 0xAD},{0xED, 0xB0},{0xEE, 0xB3},{0xEF, 0xB8},{0xF0, 0xBB},{0xF1, 0xBE},{0xF2, 0xC1},{0xF3, 0xC3},{0xF4, 0xC6},
        {0xF5, 0xC9},{0xF6, 0xCB},{0xF7, 0xCF},{0xF8, 0xD2},{0xF9, 0xD6},{0xFA, 0xD9},{0xFB, 0xDC},{0xFC, 0xDF},{0xFD, 0xE3},{0xFE, 0xE6},
        {0xFF, 0xE9},{0x93, 0x0E},{0xC0, 0x3C},{0xC1, 0x3C},{0xC2, 0x3C},{0xC3, 0x3D},{0xC4, 0x3D},{0xC5, 0x3D},{0xC6, 0x3D},{0xC7, 0x3D},
        {0xC8, 0x3D},{0xC9, 0x3D},{0xCA, 0x3D},{0xCB, 0x3E},{0xCC, 0x3E},{0xCD, 0x3E},{0xCE, 0x3E},{0xCF, 0x3E},{0xD0, 0x3E},{0xD1, 0x3F},
        {0xD2, 0x3F},{0xD3, 0x40},{0xD4, 0x40},{0xD5, 0x41},{0xD6, 0x41},{0xD7, 0x41},{0xD8, 0x42},{0xD9, 0x43},{0xDA, 0x43},{0xDB, 0x44},
        {0xDC, 0x45},{0xDD, 0x46},{0xDE, 0x46},{0xDF, 0x47},{0xE0, 0x48},{0xE1, 0x49},{0xE2, 0x4A},{0xE3, 0x4B},{0xE4, 0x4C},{0xE5, 0x4D},
        {0xE6, 0x4D},{0xE7, 0x4E},{0xE8, 0x4F},{0xE9, 0x50},{0xEA, 0x51},{0xEB, 0x52},{0xEC, 0x52},{0xED, 0x53},{0xEE, 0x54},{0xEF, 0x55},
        {0xF0, 0x56},{0xF1, 0x57},{0xF2, 0x57},{0xF3, 0x58},{0xF4, 0x59},{0xF5, 0x5A},{0xF6, 0x5B},{0xF7, 0x5D},{0xF8, 0x5D},{0xF9, 0x5E},
        {0xFA, 0x5F},{0xFB, 0x60},{0xFC, 0x62},{0xFD, 0x62},{0xFE, 0x63},{0xFF, 0x64},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x55},{0xC1, 0x55},{0xC2, 0x55},{0xC3, 0x55},{0xC4, 0x55},{0xC5, 0x55},{0xC6, 0x55},{0xC7, 0x55},
        {0xC8, 0x56},{0xC9, 0x56},{0xCA, 0x57},{0xCB, 0x57},{0xCC, 0x58},{0xCD, 0x59},{0xCE, 0x59},{0xCF, 0x5A},{0xD0, 0x5B},{0xD1, 0x5C},
        {0xD2, 0x5E},{0xD3, 0x5E},{0xD4, 0x60},{0xD5, 0x62},{0xD6, 0x63},{0xD7, 0x65},{0xD8, 0x67},{0xD9, 0x68},{0xDA, 0x6A},{0xDB, 0x6C},
        {0xDC, 0x6F},{0xDD, 0x71},{0xDE, 0x73},{0xDF, 0x75},{0xE0, 0x78},{0xE1, 0x7A},{0xE2, 0x7C},{0xE3, 0x7E},{0xE4, 0x80},{0xE5, 0x83},
        {0xE6, 0x84},{0xE7, 0x87},{0xE8, 0x8A},{0xE9, 0x8C},{0xEA, 0x8F},{0xEB, 0x90},{0xEC, 0x93},{0xED, 0x96},{0xEE, 0x99},{0xEF, 0x9C},
        {0xF0, 0x9E},{0xF1, 0xA1},{0xF2, 0xA5},{0xF3, 0xA8},{0xF4, 0xAA},{0xF5, 0xAD},{0xF6, 0xB0},{0xF7, 0xB4},{0xF8, 0xB7},{0xF9, 0xBB},
        {0xFA, 0xBE},{0xFB, 0xC2},{0xFC, 0xC5},{0xFD, 0xC7},{0xFE, 0xCA},{0xFF, 0xCD},{0x93, 0x11},{0xC0, 0x5A},{0xC1, 0x5A},{0xC2, 0x5A},
        {0xC3, 0x5A},{0xC4, 0x5A},{0xC5, 0x5A},{0xC6, 0x5B},{0xC7, 0x5B},{0xC8, 0x5B},{0xC9, 0x5B},{0xCA, 0x5C},{0xCB, 0x5D},{0xCC, 0x5E},
        {0xCD, 0x5E},{0xCE, 0x5F},{0xCF, 0x61},{0xD0, 0x62},{0xD1, 0x63},{0xD2, 0x64},{0xD3, 0x66},{0xD4, 0x67},{0xD5, 0x68},{0xD6, 0x6A},
        {0xD7, 0x6C},{0xD8, 0x6E},{0xD9, 0x70},{0xDA, 0x73},{0xDB, 0x74},{0xDC, 0x76},{0xDD, 0x79},{0xDE, 0x7B},{0xDF, 0x7C},{0xE0, 0x7F},
        {0xE1, 0x81},{0xE2, 0x83},{0xE3, 0x85},{0xE4, 0x88},{0xE5, 0x8B},{0xE6, 0x8D},{0xE7, 0x90},{0xE8, 0x91},{0xE9, 0x94},{0xEA, 0x97},
        {0xEB, 0x9A},{0xEC, 0x9C},{0xED, 0x9F},{0xEE, 0xA3},{0xEF, 0xA7},{0xF0, 0xA9},{0xF1, 0xAC},{0xF2, 0xAF},{0xF3, 0xB2},{0xF4, 0xB6},
        {0xF5, 0xBA},{0xF6, 0xBD},{0xF7, 0xC1},{0xF8, 0xC4},{0xF9, 0xC6},{0xFA, 0xC9},{0xFB, 0xCC},{0xFC, 0xCF},{0xFD, 0xD4},{0xFE, 0xD8},
        {0xFF, 0xDC},{0x93, 0x12},{0xC0, 0x37},{0xC1, 0x37},{0xC2, 0x37},{0xC3, 0x38},{0xC4, 0x38},{0xC5, 0x38},{0xC6, 0x38},{0xC7, 0x38},
        {0xC8, 0x38},{0xC9, 0x38},{0xCA, 0x38},{0xCB, 0x38},{0xCC, 0x38},{0xCD, 0x38},{0xCE, 0x39},{0xCF, 0x39},{0xD0, 0x39},{0xD1, 0x3A},
        {0xD2, 0x3A},{0xD3, 0x3A},{0xD4, 0x3A},{0xD5, 0x3B},{0xD6, 0x3C},{0xD7, 0x3C},{0xD8, 0x3C},{0xD9, 0x3D},{0xDA, 0x3D},{0xDB, 0x3D},
        {0xDC, 0x3E},{0xDD, 0x3F},{0xDE, 0x3F},{0xDF, 0x3F},{0xE0, 0x40},{0xE1, 0x41},{0xE2, 0x42},{0xE3, 0x43},{0xE4, 0x43},{0xE5, 0x44},
        {0xE6, 0x45},{0xE7, 0x46},{0xE8, 0x47},{0xE9, 0x48},{0xEA, 0x48},{0xEB, 0x49},{0xEC, 0x4A},{0xED, 0x4B},{0xEE, 0x4B},{0xEF, 0x4C},
        {0xF0, 0x4D},{0xF1, 0x4E},{0xF2, 0x4F},{0xF3, 0x4F},{0xF4, 0x50},{0xF5, 0x51},{0xF6, 0x52},{0xF7, 0x54},{0xF8, 0x55},{0xF9, 0x55},
        {0xFA, 0x56},{0xFB, 0x57},{0xFC, 0x58},{0xFD, 0x59},{0xFE, 0x59},{0xFF, 0x5A},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [20] Medium +1
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x67},{0xC1, 0x67},{0xC2, 0x67},{0xC3, 0x67},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x68},{0xC7, 0x6A},
        {0xC8, 0x6A},{0xC9, 0x6B},{0xCA, 0x6B},{0xCB, 0x6C},{0xCC, 0x6D},{0xCD, 0x6D},{0xCE, 0x6E},{0xCF, 0x6F},{0xD0, 0x70},{0xD1, 0x72},
        {0xD2, 0x73},{0xD3, 0x75},{0xD4, 0x76},{0xD5, 0x79},{0xD6, 0x7B},{0xD7, 0x7D},{0xD8, 0x7E},{0xD9, 0x80},{0xDA, 0x82},{0xDB, 0x84},
        {0xDC, 0x86},{0xDD, 0x87},{0xDE, 0x8A},{0xDF, 0x8D},{0xE0, 0x90},{0xE1, 0x93},{0xE2, 0x95},{0xE3, 0x97},{0xE4, 0x98},{0xE5, 0x9B},
        {0xE6, 0x9E},{0xE7, 0xA0},{0xE8, 0xA3},{0xE9, 0xA6},{0xEA, 0xA9},{0xEB, 0xAB},{0xEC, 0xAD},{0xED, 0xB0},{0xEE, 0xB3},{0xEF, 0xB7},
        {0xF0, 0xBB},{0xF1, 0xBD},{0xF2, 0xC0},{0xF3, 0xC3},{0xF4, 0xC5},{0xF5, 0xC7},{0xF6, 0xCA},{0xF7, 0xCD},{0xF8, 0xD0},{0xF9, 0xD3},
        {0xFA, 0xD6},{0xFB, 0xD9},{0xFC, 0xDC},{0xFD, 0xDE},{0xFE, 0xE1},{0xFF, 0xE3},{0x93, 0x09},{0xC0, 0x70},{0xC1, 0x70},{0xC2, 0x70},
        {0xC3, 0x70},{0xC4, 0x70},{0xC5, 0x70},{0xC6, 0x70},{0xC7, 0x71},{0xC8, 0x71},{0xC9, 0x72},{0xCA, 0x72},{0xCB, 0x73},{0xCC, 0x74},
        {0xCD, 0x75},{0xCE, 0x76},{0xCF, 0x77},{0xD0, 0x7A},{0xD1, 0x7B},{0xD2, 0x7C},{0xD3, 0x7E},{0xD4, 0x7F},{0xD5, 0x80},{0xD6, 0x82},
        {0xD7, 0x84},{0xD8, 0x86},{0xD9, 0x87},{0xDA, 0x89},{0xDB, 0x8B},{0xDC, 0x8F},{0xDD, 0x91},{0xDE, 0x93},{0xDF, 0x95},{0xE0, 0x97},
        {0xE1, 0x99},{0xE2, 0x9C},{0xE3, 0x9F},{0xE4, 0xA1},{0xE5, 0xA4},{0xE6, 0xA7},{0xE7, 0xA9},{0xE8, 0xAC},{0xE9, 0xAE},{0xEA, 0xB1},
        {0xEB, 0xB4},{0xEC, 0xB7},{0xED, 0xBB},{0xEE, 0xBE},{0xEF, 0xC2},{0xF0, 0xC4},{0xF1, 0xC6},{0xF2, 0xC9},{0xF3, 0xCC},{0xF4, 0xCE},
        {0xF5, 0xD1},{0xF6, 0xD4},{0xF7, 0xD7},{0xF8, 0xDA},{0xF9, 0xDD},{0xFA, 0xE0},{0xFB, 0xE2},{0xFC, 0xE5},{0xFD, 0xE8},{0xFE, 0xEB},
        {0xFF, 0xEE},{0x93, 0x0A},{0xC0, 0x42},{0xC1, 0x42},{0xC2, 0x42},{0xC3, 0x42},{0xC4, 0x42},{0xC5, 0x42},{0xC6, 0x42},{0xC7, 0x42},
        {0xC8, 0x42},{0xC9, 0x42},{0xCA, 0x43},{0xCB, 0x43},{0xCC, 0x43},{0xCD, 0x43},{0xCE, 0x45},{0xCF, 0x45},{0xD0, 0x46},{0xD1, 0x46},
        {0xD2, 0x46},{0xD3, 0x47},{0xD4, 0x47},{0xD5, 0x48},{0xD6, 0x49},{0xD7, 0x49},{0xD8, 0x4A},{0xD9, 0x4A},{0xDA, 0x4A},{0xDB, 0x4B},
        {0xDC, 0x4C},{0xDD, 0x4C},{0xDE, 0x4D},{0xDF, 0x4E},{0xE0, 0x4F},{0xE1, 0x50},{0xE2, 0x51},{0xE3, 0x52},{0xE4, 0x52},{0xE5, 0x53},
        {0xE6, 0x54},{0xE7, 0x55},{0xE8, 0x56},{0xE9, 0x57},{0xEA, 0x58},{0xEB, 0x59},{0xEC, 0x5A},{0xED, 0x5B},{0xEE, 0x5B},{0xEF, 0x5D},
        {0xF0, 0x5E},{0xF1, 0x5F},{0xF2, 0x61},{0xF3, 0x62},{0xF4, 0x63},{0xF5, 0x65},{0xF6, 0x65},{0xF7, 0x66},{0xF8, 0x67},{0xF9, 0x68},
        {0xFA, 0x6B},{0xFB, 0x6C},{0xFC, 0x6D},{0xFD, 0x6D},{0xFE, 0x6F},{0xFF, 0x70},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x60},{0xC1, 0x60},{0xC2, 0x60},{0xC3, 0x60},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x61},{0xC7, 0x62},
        {0xC8, 0x62},{0xC9, 0x62},{0xCA, 0x62},{0xCB, 0x63},{0xCC, 0x64},{0xCD, 0x65},{0xCE, 0x66},{0xCF, 0x67},{0xD0, 0x68},{0xD1, 0x6A},
        {0xD2, 0x6B},{0xD3, 0x6D},{0xD4, 0x6E},{0xD5, 0x70},{0xD6, 0x72},{0xD7, 0x74},{0xD8, 0x76},{0xD9, 0x78},{0xDA, 0x7A},{0xDB, 0x7C},
        {0xDC, 0x7E},{0xDD, 0x80},{0xDE, 0x83},{0xDF, 0x84},{0xE0, 0x87},{0xE1, 0x89},{0xE2, 0x8B},{0xE3, 0x8E},{0xE4, 0x90},{0xE5, 0x92},
        {0xE6, 0x95},{0xE7, 0x97},{0xE8, 0x9A},{0xE9, 0x9D},{0xEA, 0xA0},{0xEB, 0xA2},{0xEC, 0xA5},{0xED, 0xA7},{0xEE, 0xAA},{0xEF, 0xAE},
        {0xF0, 0xB1},{0xF1, 0xB3},{0xF2, 0xB7},{0xF3, 0xBA},{0xF4, 0xBD},{0xF5, 0xC0},{0xF6, 0xC3},{0xF7, 0xC5},{0xF8, 0xC9},{0xF9, 0xCB},
        {0xFA, 0xCE},{0xFB, 0xD1},{0xFC, 0xD5},{0xFD, 0xD8},{0xFE, 0xDB},{0xFF, 0xDE},{0x93, 0x0D},{0xC0, 0x68},{0xC1, 0x68},{0xC2, 0x68},
        {0xC3, 0x68},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x68},{0xC7, 0x69},{0xC8, 0x69},{0xC9, 0x6A},{0xCA, 0x6A},{0xCB, 0x6B},{0xCC, 0x6C},
        {0xCD, 0x6D},{0xCE, 0x6E},{0xCF, 0x6F},{0xD0, 0x71},{0xD1, 0x72},{0xD2, 0x73},{0xD3, 0x75},{0xD4, 0x77},{0xD5, 0x78},{0xD6, 0x7A},
        {0xD7, 0x7C},{0xD8, 0x7E},{0xD9, 0x80},{0xDA, 0x82},{0xDB, 0x83},{0xDC, 0x86},{0xDD, 0x87},{0xDE, 0x89},{0xDF, 0x8C},{0xE0, 0x8F},
        {0xE1, 0x90},{0xE2, 0x93},{0xE3, 0x96},{0xE4, 0x98},{0xE5, 0x9B},{0xE6, 0x9E},{0xE7, 0xA0},{0xE8, 0xA3},{0xE9, 0xA5},{0xEA, 0xA8},
        {0xEB, 0xAB},{0xEC, 0xAE},{0xED, 0xB1},{0xEE, 0xB5},{0xEF, 0xB9},{0xF0, 0xBC},{0xF1, 0xBF},{0xF2, 0xC2},{0xF3, 0xC4},{0xF4, 0xC7},
        {0xF5, 0xCA},{0xF6, 0xCC},{0xF7, 0xCF},{0xF8, 0xD2},{0xF9, 0xD7},{0xFA, 0xDA},{0xFB, 0xDD},{0xFC, 0xE0},{0xFD, 0xE3},{0xFE, 0xE7},
        {0xFF, 0xEB},{0x93, 0x0E},{0xC0, 0x3F},{0xC1, 0x3F},{0xC2, 0x3F},{0xC3, 0x3F},{0xC4, 0x3F},{0xC5, 0x3F},{0xC6, 0x3F},{0xC7, 0x3F},
        {0xC8, 0x3F},{0xC9, 0x3F},{0xCA, 0x40},{0xCB, 0x40},{0xCC, 0x40},{0xCD, 0x40},{0xCE, 0x41},{0xCF, 0x41},{0xD0, 0x41},{0xD1, 0x41},
        {0xD2, 0x41},{0xD3, 0x42},{0xD4, 0x42},{0xD5, 0x43},{0xD6, 0x44},{0xD7, 0x44},{0xD8, 0x45},{0xD9, 0x45},{0xDA, 0x46},{0xDB, 0x47},
        {0xDC, 0x48},{0xDD, 0x48},{0xDE, 0x49},{0xDF, 0x4A},{0xE0, 0x4B},{0xE1, 0x4C},{0xE2, 0x4D},{0xE3, 0x4D},{0xE4, 0x4E},{0xE5, 0x4F},
        {0xE6, 0x50},{0xE7, 0x51},{0xE8, 0x52},{0xE9, 0x52},{0xEA, 0x53},{0xEB, 0x54},{0xEC, 0x55},{0xED, 0x55},{0xEE, 0x56},{0xEF, 0x57},
        {0xF0, 0x58},{0xF1, 0x59},{0xF2, 0x5A},{0xF3, 0x5B},{0xF4, 0x5C},{0xF5, 0x5D},{0xF6, 0x5E},{0xF7, 0x5F},{0xF8, 0x60},{0xF9, 0x61},
        {0xFA, 0x62},{0xFB, 0x63},{0xFC, 0x64},{0xFD, 0x65},{0xFE, 0x67},{0xFF, 0x68},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x57},{0xC1, 0x57},{0xC2, 0x57},{0xC3, 0x57},{0xC4, 0x57},{0xC5, 0x57},{0xC6, 0x57},{0xC7, 0x58},
        {0xC8, 0x58},{0xC9, 0x59},{0xCA, 0x59},{0xCB, 0x59},{0xCC, 0x5A},{0xCD, 0x5B},{0xCE, 0x5B},{0xCF, 0x5C},{0xD0, 0x5D},{0xD1, 0x5E},
        {0xD2, 0x5F},{0xD3, 0x61},{0xD4, 0x62},{0xD5, 0x63},{0xD6, 0x65},{0xD7, 0x67},{0xD8, 0x68},{0xD9, 0x6A},{0xDA, 0x6C},{0xDB, 0x6E},
        {0xDC, 0x70},{0xDD, 0x72},{0xDE, 0x74},{0xDF, 0x76},{0xE0, 0x79},{0xE1, 0x7C},{0xE2, 0x7D},{0xE3, 0x7F},{0xE4, 0x81},{0xE5, 0x83},
        {0xE6, 0x86},{0xE7, 0x88},{0xE8, 0x8B},{0xE9, 0x8D},{0xEA, 0x90},{0xEB, 0x91},{0xEC, 0x94},{0xED, 0x97},{0xEE, 0x9A},{0xEF, 0x9D},
        {0xF0, 0xA0},{0xF1, 0xA3},{0xF2, 0xA6},{0xF3, 0xA8},{0xF4, 0xAB},{0xF5, 0xAE},{0xF6, 0xB1},{0xF7, 0xB5},{0xF8, 0xBA},{0xF9, 0xBD},
        {0xFA, 0xC0},{0xFB, 0xC3},{0xFC, 0xC6},{0xFD, 0xC8},{0xFE, 0xCB},{0xFF, 0xCE},{0x93, 0x11},{0xC0, 0x5D},{0xC1, 0x5D},{0xC2, 0x5D},
        {0xC3, 0x5D},{0xC4, 0x5D},{0xC5, 0x5D},{0xC6, 0x5D},{0xC7, 0x5E},{0xC8, 0x5E},{0xC9, 0x5E},{0xCA, 0x5E},{0xCB, 0x5F},{0xCC, 0x60},
        {0xCD, 0x61},{0xCE, 0x62},{0xCF, 0x63},{0xD0, 0x64},{0xD1, 0x65},{0xD2, 0x66},{0xD3, 0x68},{0xD4, 0x69},{0xD5, 0x6A},{0xD6, 0x6C},
        {0xD7, 0x6E},{0xD8, 0x70},{0xD9, 0x72},{0xDA, 0x74},{0xDB, 0x75},{0xDC, 0x78},{0xDD, 0x7A},{0xDE, 0x7C},{0xDF, 0x7E},{0xE0, 0x80},
        {0xE1, 0x82},{0xE2, 0x84},{0xE3, 0x87},{0xE4, 0x89},{0xE5, 0x8B},{0xE6, 0x8E},{0xE7, 0x90},{0xE8, 0x92},{0xE9, 0x95},{0xEA, 0x98},
        {0xEB, 0x9A},{0xEC, 0x9D},{0xED, 0xA0},{0xEE, 0xA4},{0xEF, 0xA8},{0xF0, 0xAA},{0xF1, 0xAD},{0xF2, 0xB0},{0xF3, 0xB4},{0xF4, 0xB7},
        {0xF5, 0xBB},{0xF6, 0xBE},{0xF7, 0xC1},{0xF8, 0xC4},{0xF9, 0xC7},{0xFA, 0xCA},{0xFB, 0xCD},{0xFC, 0xD1},{0xFD, 0xD4},{0xFE, 0xD9},
        {0xFF, 0xDE},{0x93, 0x12},{0xC0, 0x3A},{0xC1, 0x3A},{0xC2, 0x3A},{0xC3, 0x3A},{0xC4, 0x3A},{0xC5, 0x3A},{0xC6, 0x3A},{0xC7, 0x3A},
        {0xC8, 0x3A},{0xC9, 0x3A},{0xCA, 0x3A},{0xCB, 0x3A},{0xCC, 0x3A},{0xCD, 0x3A},{0xCE, 0x3B},{0xCF, 0x3B},{0xD0, 0x3C},{0xD1, 0x3C},
        {0xD2, 0x3C},{0xD3, 0x3C},{0xD4, 0x3C},{0xD5, 0x3D},{0xD6, 0x3D},{0xD7, 0x3D},{0xD8, 0x3E},{0xD9, 0x3E},{0xDA, 0x3F},{0xDB, 0x3F},
        {0xDC, 0x40},{0xDD, 0x40},{0xDE, 0x41},{0xDF, 0x42},{0xE0, 0x43},{0xE1, 0x43},{0xE2, 0x44},{0xE3, 0x45},{0xE4, 0x46},{0xE5, 0x47},
        {0xE6, 0x48},{0xE7, 0x48},{0xE8, 0x49},{0xE9, 0x4A},{0xEA, 0x4B},{0xEB, 0x4B},{0xEC, 0x4C},{0xED, 0x4D},{0xEE, 0x4D},{0xEF, 0x4F},
        {0xF0, 0x4F},{0xF1, 0x50},{0xF2, 0x51},{0xF3, 0x52},{0xF4, 0x53},{0xF5, 0x55},{0xF6, 0x55},{0xF7, 0x56},{0xF8, 0x57},{0xF9, 0x57},
        {0xFA, 0x59},{0xFB, 0x59},{0xFC, 0x5A},{0xFD, 0x5B},{0xFE, 0x5C},{0xFF, 0x5D},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [21] Medium +2
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x6C},{0xC1, 0x6C},{0xC2, 0x6C},{0xC3, 0x6C},{0xC4, 0x6C},{0xC5, 0x6C},{0xC6, 0x6D},{0xC7, 0x6D},
        {0xC8, 0x6D},{0xC9, 0x6D},{0xCA, 0x6D},{0xCB, 0x6E},{0xCC, 0x6F},{0xCD, 0x70},{0xCE, 0x71},{0xCF, 0x72},{0xD0, 0x73},{0xD1, 0x74},
        {0xD2, 0x76},{0xD3, 0x77},{0xD4, 0x7A},{0xD5, 0x7B},{0xD6, 0x7D},{0xD7, 0x7E},{0xD8, 0x7F},{0xD9, 0x81},{0xDA, 0x83},{0xDB, 0x85},
        {0xDC, 0x87},{0xDD, 0x89},{0xDE, 0x8B},{0xDF, 0x8E},{0xE0, 0x91},{0xE1, 0x94},{0xE2, 0x95},{0xE3, 0x97},{0xE4, 0x99},{0xE5, 0x9C},
        {0xE6, 0x9F},{0xE7, 0xA1},{0xE8, 0xA4},{0xE9, 0xA7},{0xEA, 0xAA},{0xEB, 0xAC},{0xEC, 0xAE},{0xED, 0xB1},{0xEE, 0xB4},{0xEF, 0xB8},
        {0xF0, 0xBC},{0xF1, 0xBE},{0xF2, 0xC1},{0xF3, 0xC3},{0xF4, 0xC6},{0xF5, 0xC8},{0xF6, 0xCB},{0xF7, 0xCE},{0xF8, 0xD1},{0xF9, 0xD4},
        {0xFA, 0xD7},{0xFB, 0xDA},{0xFC, 0xDD},{0xFD, 0xDF},{0xFE, 0xE1},{0xFF, 0xE4},{0x93, 0x09},{0xC0, 0x73},{0xC1, 0x73},{0xC2, 0x73},
        {0xC3, 0x73},{0xC4, 0x74},{0xC5, 0x74},{0xC6, 0x74},{0xC7, 0x74},{0xC8, 0x75},{0xC9, 0x75},{0xCA, 0x76},{0xCB, 0x76},{0xCC, 0x77},
        {0xCD, 0x79},{0xCE, 0x7A},{0xCF, 0x7B},{0xD0, 0x7C},{0xD1, 0x7E},{0xD2, 0x7E},{0xD3, 0x7F},{0xD4, 0x81},{0xD5, 0x82},{0xD6, 0x84},
        {0xD7, 0x86},{0xD8, 0x87},{0xD9, 0x89},{0xDA, 0x8B},{0xDB, 0x8E},{0xDC, 0x90},{0xDD, 0x92},{0xDE, 0x95},{0xDF, 0x96},{0xE0, 0x98},
        {0xE1, 0x9A},{0xE2, 0x9D},{0xE3, 0xA0},{0xE4, 0xA2},{0xE5, 0xA5},{0xE6, 0xA8},{0xE7, 0xAA},{0xE8, 0xAC},{0xE9, 0xAF},{0xEA, 0xB2},
        {0xEB, 0xB5},{0xEC, 0xB8},{0xED, 0xBC},{0xEE, 0xBF},{0xEF, 0xC2},{0xF0, 0xC4},{0xF1, 0xC6},{0xF2, 0xC9},{0xF3, 0xCC},{0xF4, 0xCF},
        {0xF5, 0xD2},{0xF6, 0xD5},{0xF7, 0xD8},{0xF8, 0xDB},{0xF9, 0xDD},{0xFA, 0xE1},{0xFB, 0xE3},{0xFC, 0xE6},{0xFD, 0xE8},{0xFE, 0xEB},
        {0xFF, 0xEF},{0x93, 0x0A},{0xC0, 0x46},{0xC1, 0x46},{0xC2, 0x46},{0xC3, 0x46},{0xC4, 0x46},{0xC5, 0x46},{0xC6, 0x46},{0xC7, 0x46},
        {0xC8, 0x47},{0xC9, 0x47},{0xCA, 0x47},{0xCB, 0x47},{0xCC, 0x47},{0xCD, 0x48},{0xCE, 0x48},{0xCF, 0x48},{0xD0, 0x49},{0xD1, 0x49},
        {0xD2, 0x49},{0xD3, 0x4A},{0xD4, 0x4A},{0xD5, 0x4A},{0xD6, 0x4A},{0xD7, 0x4B},{0xD8, 0x4C},{0xD9, 0x4C},{0xDA, 0x4D},{0xDB, 0x4E},
        {0xDC, 0x4E},{0xDD, 0x4F},{0xDE, 0x50},{0xDF, 0x51},{0xE0, 0x52},{0xE1, 0x52},{0xE2, 0x53},{0xE3, 0x54},{0xE4, 0x55},{0xE5, 0x56},
        {0xE6, 0x57},{0xE7, 0x58},{0xE8, 0x59},{0xE9, 0x5A},{0xEA, 0x5B},{0xEB, 0x5B},{0xEC, 0x5C},{0xED, 0x5D},{0xEE, 0x5E},{0xEF, 0x61},
        {0xF0, 0x62},{0xF1, 0x63},{0xF2, 0x64},{0xF3, 0x65},{0xF4, 0x66},{0xF5, 0x67},{0xF6, 0x68},{0xF7, 0x6A},{0xF8, 0x6C},{0xF9, 0x6D},
        {0xFA, 0x6D},{0xFB, 0x6E},{0xFC, 0x70},{0xFD, 0x71},{0xFE, 0x72},{0xFF, 0x74},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x63},{0xC1, 0x63},{0xC2, 0x63},{0xC3, 0x63},{0xC4, 0x63},{0xC5, 0x63},{0xC6, 0x64},{0xC7, 0x64},
        {0xC8, 0x64},{0xC9, 0x65},{0xCA, 0x65},{0xCB, 0x66},{0xCC, 0x67},{0xCD, 0x68},{0xCE, 0x69},{0xCF, 0x6A},{0xD0, 0x6B},{0xD1, 0x6C},
        {0xD2, 0x6E},{0xD3, 0x6F},{0xD4, 0x71},{0xD5, 0x72},{0xD6, 0x74},{0xD7, 0x76},{0xD8, 0x77},{0xD9, 0x79},{0xDA, 0x7B},{0xDB, 0x7D},
        {0xDC, 0x80},{0xDD, 0x82},{0xDE, 0x83},{0xDF, 0x85},{0xE0, 0x87},{0xE1, 0x8A},{0xE2, 0x8C},{0xE3, 0x8F},{0xE4, 0x90},{0xE5, 0x93},
        {0xE6, 0x96},{0xE7, 0x98},{0xE8, 0x9B},{0xE9, 0x9E},{0xEA, 0xA1},{0xEB, 0xA3},{0xEC, 0xA5},{0xED, 0xA8},{0xEE, 0xAB},{0xEF, 0xAF},
        {0xF0, 0xB2},{0xF1, 0xB5},{0xF2, 0xB8},{0xF3, 0xBB},{0xF4, 0xBE},{0xF5, 0xC1},{0xF6, 0xC3},{0xF7, 0xC6},{0xF8, 0xCA},{0xF9, 0xCC},
        {0xFA, 0xCF},{0xFB, 0xD2},{0xFC, 0xD6},{0xFD, 0xD9},{0xFE, 0xDC},{0xFF, 0xDF},{0x93, 0x0D},{0xC0, 0x6B},{0xC1, 0x6B},{0xC2, 0x6B},
        {0xC3, 0x6B},{0xC4, 0x6C},{0xC5, 0x6C},{0xC6, 0x6C},{0xC7, 0x6C},{0xC8, 0x6D},{0xC9, 0x6D},{0xCA, 0x6E},{0xCB, 0x6E},{0xCC, 0x6F},
        {0xCD, 0x70},{0xCE, 0x71},{0xCF, 0x72},{0xD0, 0x73},{0xD1, 0x75},{0xD2, 0x76},{0xD3, 0x77},{0xD4, 0x79},{0xD5, 0x7A},{0xD6, 0x7C},
        {0xD7, 0x7E},{0xD8, 0x80},{0xD9, 0x82},{0xDA, 0x83},{0xDB, 0x85},{0xDC, 0x87},{0xDD, 0x88},{0xDE, 0x8B},{0xDF, 0x8D},{0xE0, 0x90},
        {0xE1, 0x91},{0xE2, 0x94},{0xE3, 0x97},{0xE4, 0x99},{0xE5, 0x9C},{0xE6, 0x9F},{0xE7, 0xA1},{0xE8, 0xA4},{0xE9, 0xA6},{0xEA, 0xA9},
        {0xEB, 0xAC},{0xEC, 0xAF},{0xED, 0xB2},{0xEE, 0xB6},{0xEF, 0xB9},{0xF0, 0xBC},{0xF1, 0xBF},{0xF2, 0xC2},{0xF3, 0xC4},{0xF4, 0xC8},
        {0xF5, 0xCB},{0xF6, 0xCD},{0xF7, 0xD0},{0xF8, 0xD4},{0xF9, 0xD7},{0xFA, 0xDB},{0xFB, 0xDE},{0xFC, 0xE1},{0xFD, 0xE4},{0xFE, 0xE7},
        {0xFF, 0xEC},{0x93, 0x0E},{0xC0, 0x41},{0xC1, 0x41},{0xC2, 0x41},{0xC3, 0x41},{0xC4, 0x41},{0xC5, 0x41},{0xC6, 0x41},{0xC7, 0x41},
        {0xC8, 0x42},{0xC9, 0x42},{0xCA, 0x42},{0xCB, 0x42},{0xCC, 0x42},{0xCD, 0x43},{0xCE, 0x43},{0xCF, 0x43},{0xD0, 0x44},{0xD1, 0x44},
        {0xD2, 0x44},{0xD3, 0x45},{0xD4, 0x45},{0xD5, 0x46},{0xD6, 0x46},{0xD7, 0x47},{0xD8, 0x48},{0xD9, 0x48},{0xDA, 0x49},{0xDB, 0x4A},
        {0xDC, 0x4A},{0xDD, 0x4B},{0xDE, 0x4C},{0xDF, 0x4D},{0xE0, 0x4D},{0xE1, 0x4E},{0xE2, 0x4F},{0xE3, 0x50},{0xE4, 0x51},{0xE5, 0x52},
        {0xE6, 0x52},{0xE7, 0x53},{0xE8, 0x54},{0xE9, 0x55},{0xEA, 0x55},{0xEB, 0x56},{0xEC, 0x57},{0xED, 0x57},{0xEE, 0x58},{0xEF, 0x5A},
        {0xF0, 0x5B},{0xF1, 0x5C},{0xF2, 0x5D},{0xF3, 0x5D},{0xF4, 0x5F},{0xF5, 0x60},{0xF6, 0x61},{0xF7, 0x62},{0xF8, 0x63},{0xF9, 0x64},
        {0xFA, 0x65},{0xFB, 0x66},{0xFC, 0x68},{0xFD, 0x69},{0xFE, 0x6A},{0xFF, 0x6C},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x59},{0xC1, 0x59},{0xC2, 0x59},{0xC3, 0x59},{0xC4, 0x59},{0xC5, 0x59},{0xC6, 0x5A},{0xC7, 0x5A},
        {0xC8, 0x5A},{0xC9, 0x5B},{0xCA, 0x5B},{0xCB, 0x5B},{0xCC, 0x5C},{0xCD, 0x5D},{0xCE, 0x5E},{0xCF, 0x5E},{0xD0, 0x5F},{0xD1, 0x60},
        {0xD2, 0x62},{0xD3, 0x63},{0xD4, 0x64},{0xD5, 0x65},{0xD6, 0x67},{0xD7, 0x68},{0xD8, 0x69},{0xD9, 0x6B},{0xDA, 0x6D},{0xDB, 0x6F},
        {0xDC, 0x72},{0xDD, 0x74},{0xDE, 0x75},{0xDF, 0x77},{0xE0, 0x7A},{0xE1, 0x7C},{0xE2, 0x7E},{0xE3, 0x80},{0xE4, 0x82},{0xE5, 0x84},
        {0xE6, 0x87},{0xE7, 0x89},{0xE8, 0x8B},{0xE9, 0x8E},{0xEA, 0x90},{0xEB, 0x92},{0xEC, 0x95},{0xED, 0x98},{0xEE, 0x9A},{0xEF, 0x9E},
        {0xF0, 0xA1},{0xF1, 0xA4},{0xF2, 0xA7},{0xF3, 0xA9},{0xF4, 0xAC},{0xF5, 0xAF},{0xF6, 0xB2},{0xF7, 0xB6},{0xF8, 0xBB},{0xF9, 0xBE},
        {0xFA, 0xC1},{0xFB, 0xC4},{0xFC, 0xC6},{0xFD, 0xC9},{0xFE, 0xCC},{0xFF, 0xCF},{0x93, 0x11},{0xC0, 0x5F},{0xC1, 0x5F},{0xC2, 0x5F},
        {0xC3, 0x5F},{0xC4, 0x60},{0xC5, 0x60},{0xC6, 0x60},{0xC7, 0x60},{0xC8, 0x61},{0xC9, 0x61},{0xCA, 0x62},{0xCB, 0x62},{0xCC, 0x63},
        {0xCD, 0x63},{0xCE, 0x64},{0xCF, 0x65},{0xD0, 0x66},{0xD1, 0x68},{0xD2, 0x68},{0xD3, 0x69},{0xD4, 0x6B},{0xD5, 0x6C},{0xD6, 0x6E},
        {0xD7, 0x70},{0xD8, 0x72},{0xD9, 0x74},{0xDA, 0x75},{0xDB, 0x77},{0xDC, 0x79},{0xDD, 0x7B},{0xDE, 0x7D},{0xDF, 0x7F},{0xE0, 0x81},
        {0xE1, 0x83},{0xE2, 0x85},{0xE3, 0x88},{0xE4, 0x8A},{0xE5, 0x8C},{0xE6, 0x8F},{0xE7, 0x90},{0xE8, 0x93},{0xE9, 0x96},{0xEA, 0x99},
        {0xEB, 0x9B},{0xEC, 0x9E},{0xED, 0xA1},{0xEE, 0xA5},{0xEF, 0xA8},{0xF0, 0xAA},{0xF1, 0xAD},{0xF2, 0xB0},{0xF3, 0xB4},{0xF4, 0xB8},
        {0xF5, 0xBC},{0xF6, 0xBF},{0xF7, 0xC2},{0xF8, 0xC5},{0xF9, 0xC7},{0xFA, 0xCB},{0xFB, 0xCE},{0xFC, 0xD2},{0xFD, 0xD5},{0xFE, 0xD9},
        {0xFF, 0xDF},{0x93, 0x12},{0xC0, 0x3C},{0xC1, 0x3C},{0xC2, 0x3C},{0xC3, 0x3C},{0xC4, 0x3C},{0xC5, 0x3C},{0xC6, 0x3C},{0xC7, 0x3C},
        {0xC8, 0x3C},{0xC9, 0x3C},{0xCA, 0x3C},{0xCB, 0x3C},{0xCC, 0x3C},{0xCD, 0x3D},{0xCE, 0x3D},{0xCF, 0x3D},{0xD0, 0x3D},{0xD1, 0x3D},
        {0xD2, 0x3D},{0xD3, 0x3E},{0xD4, 0x3E},{0xD5, 0x3F},{0xD6, 0x3F},{0xD7, 0x3F},{0xD8, 0x40},{0xD9, 0x40},{0xDA, 0x41},{0xDB, 0x42},
        {0xDC, 0x42},{0xDD, 0x43},{0xDE, 0x43},{0xDF, 0x44},{0xE0, 0x45},{0xE1, 0x46},{0xE2, 0x47},{0xE3, 0x48},{0xE4, 0x48},{0xE5, 0x49},
        {0xE6, 0x4A},{0xE7, 0x4B},{0xE8, 0x4B},{0xE9, 0x4C},{0xEA, 0x4D},{0xEB, 0x4D},{0xEC, 0x4E},{0xED, 0x4F},{0xEE, 0x4F},{0xEF, 0x51},
        {0xF0, 0x52},{0xF1, 0x53},{0xF2, 0x54},{0xF3, 0x55},{0xF4, 0x56},{0xF5, 0x57},{0xF6, 0x57},{0xF7, 0x58},{0xF8, 0x59},{0xF9, 0x5A},
        {0xFA, 0x5B},{0xFB, 0x5B},{0xFC, 0x5D},{0xFD, 0x5E},{0xFE, 0x5E},{0xFF, 0x60},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [22] Medium +3
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x6F},{0xC1, 0x6F},{0xC2, 0x6F},{0xC3, 0x6F},{0xC4, 0x6F},{0xC5, 0x6F},{0xC6, 0x6F},{0xC7, 0x6F},
        {0xC8, 0x70},{0xC9, 0x70},{0xCA, 0x71},{0xCB, 0x71},{0xCC, 0x72},{0xCD, 0x72},{0xCE, 0x73},{0xCF, 0x74},{0xD0, 0x76},{0xD1, 0x77},
        {0xD2, 0x79},{0xD3, 0x7A},{0xD4, 0x7C},{0xD5, 0x7D},{0xD6, 0x7E},{0xD7, 0x7F},{0xD8, 0x81},{0xD9, 0x83},{0xDA, 0x85},{0xDB, 0x87},
        {0xDC, 0x88},{0xDD, 0x8A},{0xDE, 0x8D},{0xDF, 0x90},{0xE0, 0x93},{0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x98},{0xE4, 0x9B},{0xE5, 0x9D},
        {0xE6, 0xA0},{0xE7, 0xA2},{0xE8, 0xA5},{0xE9, 0xA8},{0xEA, 0xAB},{0xEB, 0xAC},{0xEC, 0xAF},{0xED, 0xB2},{0xEE, 0xB5},{0xEF, 0xB9},
        {0xF0, 0xBC},{0xF1, 0xBF},{0xF2, 0xC2},{0xF3, 0xC4},{0xF4, 0xC6},{0xF5, 0xC9},{0xF6, 0xCC},{0xF7, 0xCE},{0xF8, 0xD2},{0xF9, 0xD5},
        {0xFA, 0xD8},{0xFB, 0xDB},{0xFC, 0xDD},{0xFD, 0xE0},{0xFE, 0xE2},{0xFF, 0xE5},{0x93, 0x09},{0xC0, 0x77},{0xC1, 0x77},{0xC2, 0x77},
        {0xC3, 0x77},{0xC4, 0x77},{0xC5, 0x77},{0xC6, 0x77},{0xC7, 0x79},{0xC8, 0x79},{0xC9, 0x79},{0xCA, 0x7A},{0xCB, 0x7A},{0xCC, 0x7B},
        {0xCD, 0x7C},{0xCE, 0x7D},{0xCF, 0x7E},{0xD0, 0x7E},{0xD1, 0x7F},{0xD2, 0x80},{0xD3, 0x82},{0xD4, 0x83},{0xD5, 0x84},{0xD6, 0x86},
        {0xD7, 0x87},{0xD8, 0x89},{0xD9, 0x8A},{0xDA, 0x8D},{0xDB, 0x8F},{0xDC, 0x91},{0xDD, 0x94},{0xDE, 0x95},{0xDF, 0x97},{0xE0, 0x99},
        {0xE1, 0x9C},{0xE2, 0x9E},{0xE3, 0xA1},{0xE4, 0xA3},{0xE5, 0xA6},{0xE6, 0xA8},{0xE7, 0xAB},{0xE8, 0xAD},{0xE9, 0xB0},{0xEA, 0xB3},
        {0xEB, 0xB5},{0xEC, 0xB8},{0xED, 0xBC},{0xEE, 0xBF},{0xEF, 0xC3},{0xF0, 0xC5},{0xF1, 0xC7},{0xF2, 0xCA},{0xF3, 0xCD},{0xF4, 0xCF},
        {0xF5, 0xD2},{0xF6, 0xD5},{0xF7, 0xD9},{0xF8, 0xDC},{0xF9, 0xDE},{0xFA, 0xE1},{0xFB, 0xE3},{0xFC, 0xE7},{0xFD, 0xE9},{0xFE, 0xEC},
        {0xFF, 0xEF},{0x93, 0x0A},{0xC0, 0x49},{0xC1, 0x49},{0xC2, 0x49},{0xC3, 0x49},{0xC4, 0x49},{0xC5, 0x49},{0xC6, 0x4A},{0xC7, 0x4A},
        {0xC8, 0x4A},{0xC9, 0x4A},{0xCA, 0x4A},{0xCB, 0x4A},{0xCC, 0x4A},{0xCD, 0x4A},{0xCE, 0x4A},{0xCF, 0x4A},{0xD0, 0x4B},{0xD1, 0x4B},
        {0xD2, 0x4B},{0xD3, 0x4C},{0xD4, 0x4C},{0xD5, 0x4D},{0xD6, 0x4D},{0xD7, 0x4E},{0xD8, 0x4E},{0xD9, 0x4F},{0xDA, 0x50},{0xDB, 0x50},
        {0xDC, 0x51},{0xDD, 0x52},{0xDE, 0x52},{0xDF, 0x52},{0xE0, 0x54},{0xE1, 0x54},{0xE2, 0x55},{0xE3, 0x56},{0xE4, 0x57},{0xE5, 0x58},
        {0xE6, 0x59},{0xE7, 0x5A},{0xE8, 0x5B},{0xE9, 0x5B},{0xEA, 0x5D},{0xEB, 0x5E},{0xEC, 0x5F},{0xED, 0x61},{0xEE, 0x62},{0xEF, 0x64},
        {0xF0, 0x65},{0xF1, 0x65},{0xF2, 0x66},{0xF3, 0x67},{0xF4, 0x6A},{0xF5, 0x6B},{0xF6, 0x6C},{0xF7, 0x6D},{0xF8, 0x6E},{0xF9, 0x6F},
        {0xFA, 0x70},{0xFB, 0x72},{0xFC, 0x73},{0xFD, 0x74},{0xFE, 0x76},{0xFF, 0x77},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x67},{0xC1, 0x67},{0xC2, 0x67},{0xC3, 0x67},{0xC4, 0x67},{0xC5, 0x67},{0xC6, 0x67},{0xC7, 0x67},
        {0xC8, 0x68},{0xC9, 0x68},{0xCA, 0x69},{0xCB, 0x69},{0xCC, 0x6A},{0xCD, 0x6A},{0xCE, 0x6B},{0xCF, 0x6C},{0xD0, 0x6E},{0xD1, 0x6F},
        {0xD2, 0x70},{0xD3, 0x71},{0xD4, 0x73},{0xD5, 0x74},{0xD6, 0x76},{0xD7, 0x77},{0xD8, 0x79},{0xD9, 0x7B},{0xDA, 0x7D},{0xDB, 0x7F},
        {0xDC, 0x81},{0xDD, 0x83},{0xDE, 0x84},{0xDF, 0x87},{0xE0, 0x89},{0xE1, 0x8B},{0xE2, 0x8E},{0xE3, 0x90},{0xE4, 0x92},{0xE5, 0x94},
        {0xE6, 0x97},{0xE7, 0x99},{0xE8, 0x9C},{0xE9, 0x9F},{0xEA, 0xA2},{0xEB, 0xA4},{0xEC, 0xA6},{0xED, 0xA9},{0xEE, 0xAC},{0xEF, 0xB0},
        {0xF0, 0xB2},{0xF1, 0xB6},{0xF2, 0xB9},{0xF3, 0xBC},{0xF4, 0xBF},{0xF5, 0xC2},{0xF6, 0xC4},{0xF7, 0xC7},{0xF8, 0xCB},{0xF9, 0xCD},
        {0xFA, 0xD0},{0xFB, 0xD4},{0xFC, 0xD7},{0xFD, 0xDA},{0xFE, 0xDD},{0xFF, 0xE0},{0x93, 0x0D},{0xC0, 0x6F},{0xC1, 0x6F},{0xC2, 0x6F},
        {0xC3, 0x6F},{0xC4, 0x6F},{0xC5, 0x6F},{0xC6, 0x6F},{0xC7, 0x70},{0xC8, 0x70},{0xC9, 0x70},{0xCA, 0x71},{0xCB, 0x71},{0xCC, 0x72},
        {0xCD, 0x73},{0xCE, 0x74},{0xCF, 0x75},{0xD0, 0x76},{0xD1, 0x77},{0xD2, 0x78},{0xD3, 0x7A},{0xD4, 0x7B},{0xD5, 0x7C},{0xD6, 0x7E},
        {0xD7, 0x80},{0xD8, 0x82},{0xD9, 0x83},{0xDA, 0x84},{0xDB, 0x86},{0xDC, 0x87},{0xDD, 0x8A},{0xDE, 0x8C},{0xDF, 0x8E},{0xE0, 0x90},
        {0xE1, 0x93},{0xE2, 0x95},{0xE3, 0x98},{0xE4, 0x9A},{0xE5, 0x9D},{0xE6, 0x9F},{0xE7, 0xA2},{0xE8, 0xA5},{0xE9, 0xA7},{0xEA, 0xAA},
        {0xEB, 0xAC},{0xEC, 0xAF},{0xED, 0xB2},{0xEE, 0xB6},{0xEF, 0xBA},{0xF0, 0xBD},{0xF1, 0xC0},{0xF2, 0xC3},{0xF3, 0xC5},{0xF4, 0xC8},
        {0xF5, 0xCB},{0xF6, 0xCD},{0xF7, 0xD1},{0xF8, 0xD5},{0xF9, 0xD8},{0xFA, 0xDB},{0xFB, 0xDE},{0xFC, 0xE2},{0xFD, 0xE5},{0xFE, 0xE8},
        {0xFF, 0xEC},{0x93, 0x0E},{0xC0, 0x44},{0xC1, 0x44},{0xC2, 0x44},{0xC3, 0x44},{0xC4, 0x44},{0xC5, 0x44},{0xC6, 0x45},{0xC7, 0x45},
        {0xC8, 0x45},{0xC9, 0x45},{0xCA, 0x45},{0xCB, 0x45},{0xCC, 0x45},{0xCD, 0x46},{0xCE, 0x46},{0xCF, 0x46},{0xD0, 0x47},{0xD1, 0x47},
        {0xD2, 0x47},{0xD3, 0x48},{0xD4, 0x48},{0xD5, 0x49},{0xD6, 0x49},{0xD7, 0x4A},{0xD8, 0x4A},{0xD9, 0x4B},{0xDA, 0x4C},{0xDB, 0x4C},
        {0xDC, 0x4D},{0xDD, 0x4D},{0xDE, 0x4E},{0xDF, 0x4E},{0xE0, 0x50},{0xE1, 0x50},{0xE2, 0x51},{0xE3, 0x52},{0xE4, 0x52},{0xE5, 0x53},
        {0xE6, 0x54},{0xE7, 0x55},{0xE8, 0x55},{0xE9, 0x56},{0xEA, 0x57},{0xEB, 0x58},{0xEC, 0x59},{0xED, 0x5A},{0xEE, 0x5B},{0xEF, 0x5D},
        {0xF0, 0x5D},{0xF1, 0x5E},{0xF2, 0x5F},{0xF3, 0x60},{0xF4, 0x62},{0xF5, 0x62},{0xF6, 0x63},{0xF7, 0x65},{0xF8, 0x66},{0xF9, 0x67},
        {0xFA, 0x68},{0xFB, 0x6A},{0xFC, 0x6B},{0xFD, 0x6C},{0xFE, 0x6E},{0xFF, 0x6F},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x5C},{0xC1, 0x5C},{0xC2, 0x5C},{0xC3, 0x5C},{0xC4, 0x5C},{0xC5, 0x5C},{0xC6, 0x5C},{0xC7, 0x5C},
        {0xC8, 0x5D},{0xC9, 0x5D},{0xCA, 0x5E},{0xCB, 0x5E},{0xCC, 0x5E},{0xCD, 0x5E},{0xCE, 0x5F},{0xCF, 0x60},{0xD0, 0x62},{0xD1, 0x63},
        {0xD2, 0x63},{0xD3, 0x64},{0xD4, 0x66},{0xD5, 0x67},{0xD6, 0x68},{0xD7, 0x69},{0xD8, 0x6B},{0xD9, 0x6D},{0xDA, 0x6F},{0xDB, 0x71},
        {0xDC, 0x73},{0xDD, 0x74},{0xDE, 0x76},{0xDF, 0x79},{0xE0, 0x7C},{0xE1, 0x7D},{0xE2, 0x7F},{0xE3, 0x81},{0xE4, 0x83},{0xE5, 0x85},
        {0xE6, 0x88},{0xE7, 0x8A},{0xE8, 0x8C},{0xE9, 0x8F},{0xEA, 0x91},{0xEB, 0x93},{0xEC, 0x96},{0xED, 0x99},{0xEE, 0x9B},{0xEF, 0x9F},
        {0xF0, 0xA1},{0xF1, 0xA5},{0xF2, 0xA8},{0xF3, 0xAA},{0xF4, 0xAD},{0xF5, 0xB0},{0xF6, 0xB4},{0xF7, 0xB7},{0xF8, 0xBC},{0xF9, 0xBF},
        {0xFA, 0xC2},{0xFB, 0xC5},{0xFC, 0xC7},{0xFD, 0xCA},{0xFE, 0xCD},{0xFF, 0xD1},{0x93, 0x11},{0xC0, 0x63},{0xC1, 0x63},{0xC2, 0x63},
        {0xC3, 0x63},{0xC4, 0x63},{0xC5, 0x63},{0xC6, 0x63},{0xC7, 0x63},{0xC8, 0x63},{0xC9, 0x63},{0xCA, 0x64},{0xCB, 0x64},{0xCC, 0x65},
        {0xCD, 0x66},{0xCE, 0x67},{0xCF, 0x68},{0xD0, 0x68},{0xD1, 0x69},{0xD2, 0x6A},{0xD3, 0x6C},{0xD4, 0x6D},{0xD5, 0x6E},{0xD6, 0x70},
        {0xD7, 0x72},{0xD8, 0x74},{0xD9, 0x74},{0xDA, 0x76},{0xDB, 0x78},{0xDC, 0x7A},{0xDD, 0x7C},{0xDE, 0x7E},{0xDF, 0x7F},{0xE0, 0x82},
        {0xE1, 0x84},{0xE2, 0x86},{0xE3, 0x89},{0xE4, 0x8B},{0xE5, 0x8D},{0xE6, 0x8F},{0xE7, 0x91},{0xE8, 0x94},{0xE9, 0x97},{0xEA, 0x9A},
        {0xEB, 0x9B},{0xEC, 0x9E},{0xED, 0xA1},{0xEE, 0xA5},{0xEF, 0xA8},{0xF0, 0xAB},{0xF1, 0xAE},{0xF2, 0xB1},{0xF3, 0xB5},{0xF4, 0xB8},
        {0xF5, 0xBC},{0xF6, 0xBF},{0xF7, 0xC3},{0xF8, 0xC6},{0xF9, 0xC8},{0xFA, 0xCB},{0xFB, 0xCE},{0xFC, 0xD3},{0xFD, 0xD7},{0xFE, 0xDB},
        {0xFF, 0xDF},{0x93, 0x12},{0xC0, 0x3D},{0xC1, 0x3D},{0xC2, 0x3D},{0xC3, 0x3D},{0xC4, 0x3D},{0xC5, 0x3D},{0xC6, 0x3E},{0xC7, 0x3E},
        {0xC8, 0x3E},{0xC9, 0x3E},{0xCA, 0x3E},{0xCB, 0x3E},{0xCC, 0x3E},{0xCD, 0x3F},{0xCE, 0x3F},{0xCF, 0x3F},{0xD0, 0x3F},{0xD1, 0x3F},
        {0xD2, 0x3F},{0xD3, 0x40},{0xD4, 0x40},{0xD5, 0x41},{0xD6, 0x41},{0xD7, 0x42},{0xD8, 0x42},{0xD9, 0x43},{0xDA, 0x43},{0xDB, 0x43},
        {0xDC, 0x44},{0xDD, 0x45},{0xDE, 0x46},{0xDF, 0x46},{0xE0, 0x48},{0xE1, 0x48},{0xE2, 0x48},{0xE3, 0x49},{0xE4, 0x4A},{0xE5, 0x4B},
        {0xE6, 0x4B},{0xE7, 0x4C},{0xE8, 0x4D},{0xE9, 0x4D},{0xEA, 0x4F},{0xEB, 0x4F},{0xEC, 0x50},{0xED, 0x51},{0xEE, 0x52},{0xEF, 0x54},
        {0xF0, 0x55},{0xF1, 0x55},{0xF2, 0x56},{0xF3, 0x57},{0xF4, 0x58},{0xF5, 0x59},{0xF6, 0x59},{0xF7, 0x5B},{0xF8, 0x5B},{0xF9, 0x5C},
        {0xFA, 0x5D},{0xFB, 0x5E},{0xFC, 0x5F},{0xFD, 0x60},{0xFE, 0x62},{0xFF, 0x63},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [23] Medium +4
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x72},{0xC1, 0x72},{0xC2, 0x72},{0xC3, 0x72},{0xC4, 0x72},{0xC5, 0x72},{0xC6, 0x72},{0xC7, 0x73},
        {0xC8, 0x73},{0xC9, 0x73},{0xCA, 0x74},{0xCB, 0x74},{0xCC, 0x75},{0xCD, 0x75},{0xCE, 0x76},{0xCF, 0x77},{0xD0, 0x79},{0xD1, 0x7A},
        {0xD2, 0x7B},{0xD3, 0x7C},{0xD4, 0x7E},{0xD5, 0x7E},{0xD6, 0x80},{0xD7, 0x81},{0xD8, 0x83},{0xD9, 0x85},{0xDA, 0x87},{0xDB, 0x88},
        {0xDC, 0x8A},{0xDD, 0x8D},{0xDE, 0x8F},{0xDF, 0x91},{0xE0, 0x94},{0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x99},{0xE4, 0x9C},{0xE5, 0x9E},
        {0xE6, 0xA1},{0xE7, 0xA3},{0xE8, 0xA6},{0xE9, 0xA9},{0xEA, 0xAC},{0xEB, 0xAD},{0xEC, 0xB0},{0xED, 0xB3},{0xEE, 0xB6},{0xEF, 0xB9},
        {0xF0, 0xBD},{0xF1, 0xC0},{0xF2, 0xC3},{0xF3, 0xC5},{0xF4, 0xC7},{0xF5, 0xCA},{0xF6, 0xCD},{0xF7, 0xCF},{0xF8, 0xD2},{0xF9, 0xD5},
        {0xFA, 0xD9},{0xFB, 0xDC},{0xFC, 0xDE},{0xFD, 0xE1},{0xFE, 0xE3},{0xFF, 0xE6},{0x93, 0x09},{0xC0, 0x7B},{0xC1, 0x7B},{0xC2, 0x7B},
        {0xC3, 0x7B},{0xC4, 0x7B},{0xC5, 0x7C},{0xC6, 0x7C},{0xC7, 0x7C},{0xC8, 0x7C},{0xC9, 0x7D},{0xCA, 0x7D},{0xCB, 0x7D},{0xCC, 0x7E},
        {0xCD, 0x7E},{0xCE, 0x7E},{0xCF, 0x7F},{0xD0, 0x80},{0xD1, 0x81},{0xD2, 0x83},{0xD3, 0x84},{0xD4, 0x85},{0xD5, 0x86},{0xD6, 0x87},
        {0xD7, 0x89},{0xD8, 0x8A},{0xD9, 0x8D},{0xDA, 0x8F},{0xDB, 0x91},{0xDC, 0x93},{0xDD, 0x95},{0xDE, 0x96},{0xDF, 0x97},{0xE0, 0x9A},
        {0xE1, 0x9D},{0xE2, 0x9F},{0xE3, 0xA2},{0xE4, 0xA4},{0xE5, 0xA7},{0xE6, 0xA9},{0xE7, 0xAC},{0xE8, 0xAE},{0xE9, 0xB0},{0xEA, 0xB3},
        {0xEB, 0xB6},{0xEC, 0xB9},{0xED, 0xBD},{0xEE, 0xC0},{0xEF, 0xC3},{0xF0, 0xC6},{0xF1, 0xC8},{0xF2, 0xCB},{0xF3, 0xCE},{0xF4, 0xD0},
        {0xF5, 0xD3},{0xF6, 0xD6},{0xF7, 0xD9},{0xF8, 0xDC},{0xF9, 0xDF},{0xFA, 0xE1},{0xFB, 0xE4},{0xFC, 0xE7},{0xFD, 0xE9},{0xFE, 0xED},
        {0xFF, 0xF0},{0x93, 0x0A},{0xC0, 0x4C},{0xC1, 0x4C},{0xC2, 0x4C},{0xC3, 0x4C},{0xC4, 0x4C},{0xC5, 0x4C},{0xC6, 0x4C},{0xC7, 0x4C},
        {0xC8, 0x4C},{0xC9, 0x4C},{0xCA, 0x4C},{0xCB, 0x4C},{0xCC, 0x4C},{0xCD, 0x4D},{0xCE, 0x4D},{0xCF, 0x4D},{0xD0, 0x4D},{0xD1, 0x4E},
        {0xD2, 0x4E},{0xD3, 0x4F},{0xD4, 0x4F},{0xD5, 0x4F},{0xD6, 0x50},{0xD7, 0x51},{0xD8, 0x51},{0xD9, 0x52},{0xDA, 0x52},{0xDB, 0x52},
        {0xDC, 0x53},{0xDD, 0x54},{0xDE, 0x54},{0xDF, 0x55},{0xE0, 0x56},{0xE1, 0x57},{0xE2, 0x58},{0xE3, 0x59},{0xE4, 0x5A},{0xE5, 0x5B},
        {0xE6, 0x5B},{0xE7, 0x5C},{0xE8, 0x5D},{0xE9, 0x5E},{0xEA, 0x5F},{0xEB, 0x61},{0xEC, 0x62},{0xED, 0x64},{0xEE, 0x65},{0xEF, 0x65},
        {0xF0, 0x67},{0xF1, 0x68},{0xF2, 0x6A},{0xF3, 0x6B},{0xF4, 0x6D},{0xF5, 0x6D},{0xF6, 0x6E},{0xF7, 0x70},{0xF8, 0x71},{0xF9, 0x72},
        {0xFA, 0x74},{0xFB, 0x75},{0xFC, 0x76},{0xFD, 0x79},{0xFE, 0x7A},{0xFF, 0x7C},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x6A},{0xC1, 0x6A},{0xC2, 0x6A},{0xC3, 0x6A},{0xC4, 0x6A},{0xC5, 0x6A},{0xC6, 0x6A},{0xC7, 0x6B},
        {0xC8, 0x6B},{0xC9, 0x6B},{0xCA, 0x6C},{0xCB, 0x6C},{0xCC, 0x6D},{0xCD, 0x6D},{0xCE, 0x6E},{0xCF, 0x6F},{0xD0, 0x70},{0xD1, 0x71},
        {0xD2, 0x72},{0xD3, 0x73},{0xD4, 0x75},{0xD5, 0x76},{0xD6, 0x78},{0xD7, 0x79},{0xD8, 0x7B},{0xD9, 0x7D},{0xDA, 0x7F},{0xDB, 0x81},
        {0xDC, 0x83},{0xDD, 0x84},{0xDE, 0x86},{0xDF, 0x87},{0xE0, 0x8A},{0xE1, 0x8C},{0xE2, 0x8F},{0xE3, 0x90},{0xE4, 0x93},{0xE5, 0x95},
        {0xE6, 0x98},{0xE7, 0x9A},{0xE8, 0x9D},{0xE9, 0xA0},{0xEA, 0xA3},{0xEB, 0xA5},{0xEC, 0xA7},{0xED, 0xAA},{0xEE, 0xAD},{0xEF, 0xB0},
        {0xF0, 0xB3},{0xF1, 0xB7},{0xF2, 0xBA},{0xF3, 0xBD},{0xF4, 0xC0},{0xF5, 0xC3},{0xF6, 0xC5},{0xF7, 0xC8},{0xF8, 0xCB},{0xF9, 0xCD},
        {0xFA, 0xD1},{0xFB, 0xD5},{0xFC, 0xD8},{0xFD, 0xDB},{0xFE, 0xDE},{0xFF, 0xE1},{0x93, 0x0D},{0xC0, 0x72},{0xC1, 0x72},{0xC2, 0x72},
        {0xC3, 0x72},{0xC4, 0x72},{0xC5, 0x73},{0xC6, 0x73},{0xC7, 0x73},{0xC8, 0x73},{0xC9, 0x74},{0xCA, 0x74},{0xCB, 0x74},{0xCC, 0x75},
        {0xCD, 0x76},{0xCE, 0x76},{0xCF, 0x77},{0xD0, 0x78},{0xD1, 0x79},{0xD2, 0x7B},{0xD3, 0x7C},{0xD4, 0x7D},{0xD5, 0x7E},{0xD6, 0x80},
        {0xD7, 0x82},{0xD8, 0x83},{0xD9, 0x84},{0xDA, 0x86},{0xDB, 0x87},{0xDC, 0x89},{0xDD, 0x8B},{0xDE, 0x8D},{0xDF, 0x8F},{0xE0, 0x91},
        {0xE1, 0x94},{0xE2, 0x96},{0xE3, 0x99},{0xE4, 0x9B},{0xE5, 0x9E},{0xE6, 0xA0},{0xE7, 0xA3},{0xE8, 0xA5},{0xE9, 0xA7},{0xEA, 0xAA},
        {0xEB, 0xAD},{0xEC, 0xB0},{0xED, 0xB3},{0xEE, 0xB7},{0xEF, 0xBB},{0xF0, 0xBE},{0xF1, 0xC1},{0xF2, 0xC3},{0xF3, 0xC6},{0xF4, 0xC9},
        {0xF5, 0xCB},{0xF6, 0xCE},{0xF7, 0xD1},{0xF8, 0xD5},{0xF9, 0xD9},{0xFA, 0xDC},{0xFB, 0xDF},{0xFC, 0xE2},{0xFD, 0xE5},{0xFE, 0xE9},
        {0xFF, 0xED},{0x93, 0x0E},{0xC0, 0x48},{0xC1, 0x48},{0xC2, 0x48},{0xC3, 0x48},{0xC4, 0x48},{0xC5, 0x48},{0xC6, 0x48},{0xC7, 0x48},
        {0xC8, 0x48},{0xC9, 0x48},{0xCA, 0x48},{0xCB, 0x48},{0xCC, 0x48},{0xCD, 0x49},{0xCE, 0x49},{0xCF, 0x49},{0xD0, 0x49},{0xD1, 0x4A},
        {0xD2, 0x4A},{0xD3, 0x4B},{0xD4, 0x4B},{0xD5, 0x4B},{0xD6, 0x4C},{0xD7, 0x4D},{0xD8, 0x4D},{0xD9, 0x4D},{0xDA, 0x4D},{0xDB, 0x4E},
        {0xDC, 0x4F},{0xDD, 0x50},{0xDE, 0x50},{0xDF, 0x51},{0xE0, 0x52},{0xE1, 0x52},{0xE2, 0x53},{0xE3, 0x54},{0xE4, 0x55},{0xE5, 0x55},
        {0xE6, 0x56},{0xE7, 0x57},{0xE8, 0x57},{0xE9, 0x58},{0xEA, 0x59},{0xEB, 0x5A},{0xEC, 0x5B},{0xED, 0x5D},{0xEE, 0x5D},{0xEF, 0x5E},
        {0xF0, 0x60},{0xF1, 0x61},{0xF2, 0x62},{0xF3, 0x62},{0xF4, 0x64},{0xF5, 0x65},{0xF6, 0x66},{0xF7, 0x68},{0xF8, 0x69},{0xF9, 0x6A},
        {0xFA, 0x6C},{0xFB, 0x6D},{0xFC, 0x6E},{0xFD, 0x70},{0xFE, 0x71},{0xFF, 0x73},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x5E},{0xC1, 0x5E},{0xC2, 0x5E},{0xC3, 0x5E},{0xC4, 0x5E},{0xC5, 0x5E},{0xC6, 0x5E},{0xC7, 0x5F},
        {0xC8, 0x5F},{0xC9, 0x5F},{0xCA, 0x60},{0xCB, 0x60},{0xCC, 0x61},{0xCD, 0x61},{0xCE, 0x62},{0xCF, 0x63},{0xD0, 0x63},{0xD1, 0x64},
        {0xD2, 0x65},{0xD3, 0x66},{0xD4, 0x68},{0xD5, 0x68},{0xD6, 0x6A},{0xD7, 0x6B},{0xD8, 0x6D},{0xD9, 0x6F},{0xDA, 0x71},{0xDB, 0x73},
        {0xDC, 0x74},{0xDD, 0x76},{0xDE, 0x78},{0xDF, 0x7A},{0xE0, 0x7C},{0xE1, 0x7E},{0xE2, 0x80},{0xE3, 0x82},{0xE4, 0x84},{0xE5, 0x86},
        {0xE6, 0x89},{0xE7, 0x8B},{0xE8, 0x8D},{0xE9, 0x90},{0xEA, 0x92},{0xEB, 0x94},{0xEC, 0x97},{0xED, 0x9A},{0xEE, 0x9C},{0xEF, 0x9F},
        {0xF0, 0xA3},{0xF1, 0xA6},{0xF2, 0xA8},{0xF3, 0xAB},{0xF4, 0xAE},{0xF5, 0xB1},{0xF6, 0xB5},{0xF7, 0xB8},{0xF8, 0xBC},{0xF9, 0xBF},
        {0xFA, 0xC3},{0xFB, 0xC6},{0xFC, 0xC8},{0xFD, 0xCB},{0xFE, 0xCE},{0xFF, 0xD2},{0x93, 0x11},{0xC0, 0x65},{0xC1, 0x65},{0xC2, 0x65},
        {0xC3, 0x65},{0xC4, 0x65},{0xC5, 0x66},{0xC6, 0x66},{0xC7, 0x66},{0xC8, 0x66},{0xC9, 0x67},{0xCA, 0x67},{0xCB, 0x67},{0xCC, 0x68},
        {0xCD, 0x68},{0xCE, 0x68},{0xCF, 0x69},{0xD0, 0x6A},{0xD1, 0x6B},{0xD2, 0x6D},{0xD3, 0x6E},{0xD4, 0x6F},{0xD5, 0x70},{0xD6, 0x72},
        {0xD7, 0x74},{0xD8, 0x74},{0xD9, 0x76},{0xDA, 0x78},{0xDB, 0x7A},{0xDC, 0x7C},{0xDD, 0x7D},{0xDE, 0x7F},{0xDF, 0x80},{0xE0, 0x83},
        {0xE1, 0x85},{0xE2, 0x87},{0xE3, 0x8A},{0xE4, 0x8B},{0xE5, 0x8E},{0xE6, 0x90},{0xE7, 0x92},{0xE8, 0x95},{0xE9, 0x97},{0xEA, 0x9A},
        {0xEB, 0x9C},{0xEC, 0x9F},{0xED, 0xA3},{0xEE, 0xA6},{0xEF, 0xA9},{0xF0, 0xAC},{0xF1, 0xAF},{0xF2, 0xB2},{0xF3, 0xB6},{0xF4, 0xBA},
        {0xF5, 0xBD},{0xF6, 0xC0},{0xF7, 0xC3},{0xF8, 0xC6},{0xF9, 0xC9},{0xFA, 0xCC},{0xFB, 0xCF},{0xFC, 0xD3},{0xFD, 0xD7},{0xFE, 0xDC},
        {0xFF, 0xE1},{0x93, 0x12},{0xC0, 0x40},{0xC1, 0x40},{0xC2, 0x40},{0xC3, 0x40},{0xC4, 0x40},{0xC5, 0x40},{0xC6, 0x40},{0xC7, 0x40},
        {0xC8, 0x40},{0xC9, 0x40},{0xCA, 0x40},{0xCB, 0x40},{0xCC, 0x40},{0xCD, 0x41},{0xCE, 0x41},{0xCF, 0x41},{0xD0, 0x41},{0xD1, 0x42},
        {0xD2, 0x42},{0xD3, 0x43},{0xD4, 0x43},{0xD5, 0x43},{0xD6, 0x43},{0xD7, 0x44},{0xD8, 0x44},{0xD9, 0x45},{0xDA, 0x45},{0xDB, 0x46},
        {0xDC, 0x47},{0xDD, 0x48},{0xDE, 0x48},{0xDF, 0x48},{0xE0, 0x49},{0xE1, 0x4A},{0xE2, 0x4B},{0xE3, 0x4B},{0xE4, 0x4C},{0xE5, 0x4D},
        {0xE6, 0x4D},{0xE7, 0x4E},{0xE8, 0x4F},{0xE9, 0x4F},{0xEA, 0x50},{0xEB, 0x51},{0xEC, 0x52},{0xED, 0x54},{0xEE, 0x55},{0xEF, 0x55},
        {0xF0, 0x57},{0xF1, 0x57},{0xF2, 0x58},{0xF3, 0x59},{0xF4, 0x5A},{0xF5, 0x5B},{0xF6, 0x5B},{0xF7, 0x5D},{0xF8, 0x5E},{0xF9, 0x5E},
        {0xFA, 0x60},{0xFB, 0x61},{0xFC, 0x62},{0xFD, 0x63},{0xFE, 0x64},{0xFF, 0x66},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [24] Medimu +5
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x75},{0xC1, 0x75},{0xC2, 0x75},{0xC3, 0x75},{0xC4, 0x75},{0xC5, 0x75},{0xC6, 0x76},{0xC7, 0x76},
        {0xC8, 0x76},{0xC9, 0x76},{0xCA, 0x77},{0xCB, 0x77},{0xCC, 0x79},{0xCD, 0x79},{0xCE, 0x7A},{0xCF, 0x7B},{0xD0, 0x7C},{0xD1, 0x7D},
        {0xD2, 0x7E},{0xD3, 0x7E},{0xD4, 0x7F},{0xD5, 0x80},{0xD6, 0x82},{0xD7, 0x83},{0xD8, 0x85},{0xD9, 0x87},{0xDA, 0x87},{0xDB, 0x89},
        {0xDC, 0x8B},{0xDD, 0x8E},{0xDE, 0x90},{0xDF, 0x92},{0xE0, 0x95},{0xE1, 0x96},{0xE2, 0x98},{0xE3, 0x9A},{0xE4, 0x9D},{0xE5, 0x9F},
        {0xE6, 0xA2},{0xE7, 0xA4},{0xE8, 0xA7},{0xE9, 0xAA},{0xEA, 0xAC},{0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB4},{0xEE, 0xB7},{0xEF, 0xBB},
        {0xF0, 0xBE},{0xF1, 0xC1},{0xF2, 0xC3},{0xF3, 0xC6},{0xF4, 0xC8},{0xF5, 0xCB},{0xF6, 0xCE},{0xF7, 0xD0},{0xF8, 0xD3},{0xF9, 0xD6},
        {0xFA, 0xD9},{0xFB, 0xDD},{0xFC, 0xDF},{0xFD, 0xE1},{0xFE, 0xE4},{0xFF, 0xE7},{0x93, 0x09},{0xC0, 0x7E},{0xC1, 0x7E},{0xC2, 0x7E},
        {0xC3, 0x7E},{0xC4, 0x7E},{0xC5, 0x7E},{0xC6, 0x7E},{0xC7, 0x7E},{0xC8, 0x7E},{0xC9, 0x7F},{0xCA, 0x7F},{0xCB, 0x7F},{0xCC, 0x80},
        {0xCD, 0x80},{0xCE, 0x81},{0xCF, 0x82},{0xD0, 0x83},{0xD1, 0x84},{0xD2, 0x85},{0xD3, 0x86},{0xD4, 0x87},{0xD5, 0x87},{0xD6, 0x89},
        {0xD7, 0x8A},{0xD8, 0x8D},{0xD9, 0x8F},{0xDA, 0x90},{0xDB, 0x92},{0xDC, 0x94},{0xDD, 0x95},{0xDE, 0x97},{0xDF, 0x99},{0xE0, 0x9B},
        {0xE1, 0x9E},{0xE2, 0xA0},{0xE3, 0xA2},{0xE4, 0xA5},{0xE5, 0xA8},{0xE6, 0xAA},{0xE7, 0xAC},{0xE8, 0xAE},{0xE9, 0xB1},{0xEA, 0xB4},
        {0xEB, 0xB7},{0xEC, 0xBB},{0xED, 0xBE},{0xEE, 0xC0},{0xEF, 0xC3},{0xF0, 0xC6},{0xF1, 0xC8},{0xF2, 0xCB},{0xF3, 0xCE},{0xF4, 0xD0},
        {0xF5, 0xD4},{0xF6, 0xD7},{0xF7, 0xDA},{0xF8, 0xDD},{0xF9, 0xDF},{0xFA, 0xE1},{0xFB, 0xE5},{0xFC, 0xE8},{0xFD, 0xEA},{0xFE, 0xED},
        {0xFF, 0xF1},{0x93, 0x0A},{0xC0, 0x4F},{0xC1, 0x4F},{0xC2, 0x4F},{0xC3, 0x4F},{0xC4, 0x4F},{0xC5, 0x4F},{0xC6, 0x4F},{0xC7, 0x4F},
        {0xC8, 0x4F},{0xC9, 0x4F},{0xCA, 0x4F},{0xCB, 0x4F},{0xCC, 0x4F},{0xCD, 0x50},{0xCE, 0x50},{0xCF, 0x50},{0xD0, 0x50},{0xD1, 0x51},
        {0xD2, 0x51},{0xD3, 0x51},{0xD4, 0x52},{0xD5, 0x52},{0xD6, 0x52},{0xD7, 0x52},{0xD8, 0x53},{0xD9, 0x53},{0xDA, 0x54},{0xDB, 0x55},
        {0xDC, 0x55},{0xDD, 0x56},{0xDE, 0x57},{0xDF, 0x58},{0xE0, 0x59},{0xE1, 0x5A},{0xE2, 0x5B},{0xE3, 0x5B},{0xE4, 0x5B},{0xE5, 0x5C},
        {0xE6, 0x5D},{0xE7, 0x5F},{0xE8, 0x61},{0xE9, 0x62},{0xEA, 0x63},{0xEB, 0x64},{0xEC, 0x65},{0xED, 0x65},{0xEE, 0x67},{0xEF, 0x68},
        {0xF0, 0x6A},{0xF1, 0x6C},{0xF2, 0x6D},{0xF3, 0x6D},{0xF4, 0x6E},{0xF5, 0x70},{0xF6, 0x71},{0xF7, 0x73},{0xF8, 0x74},{0xF9, 0x75},
        {0xFA, 0x77},{0xFB, 0x79},{0xFC, 0x7A},{0xFD, 0x7C},{0xFE, 0x7D},{0xFF, 0x7E},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x6D},{0xC1, 0x6D},{0xC2, 0x6D},{0xC3, 0x6D},{0xC4, 0x6D},{0xC5, 0x6D},{0xC6, 0x6E},{0xC7, 0x6E},
        {0xC8, 0x6E},{0xC9, 0x6E},{0xCA, 0x6F},{0xCB, 0x6F},{0xCC, 0x70},{0xCD, 0x70},{0xCE, 0x71},{0xCF, 0x72},{0xD0, 0x73},{0xD1, 0x74},
        {0xD2, 0x75},{0xD3, 0x76},{0xD4, 0x77},{0xD5, 0x78},{0xD6, 0x7A},{0xD7, 0x7B},{0xD8, 0x7D},{0xD9, 0x7F},{0xDA, 0x80},{0xDB, 0x82},
        {0xDC, 0x83},{0xDD, 0x85},{0xDE, 0x87},{0xDF, 0x88},{0xE0, 0x8B},{0xE1, 0x8D},{0xE2, 0x90},{0xE3, 0x91},{0xE4, 0x94},{0xE5, 0x96},
        {0xE6, 0x99},{0xE7, 0x9B},{0xE8, 0x9E},{0xE9, 0xA1},{0xEA, 0xA3},{0xEB, 0xA5},{0xEC, 0xA8},{0xED, 0xAB},{0xEE, 0xAE},{0xEF, 0xB1},
        {0xF0, 0xB5},{0xF1, 0xB8},{0xF2, 0xBB},{0xF3, 0xBE},{0xF4, 0xC1},{0xF5, 0xC3},{0xF6, 0xC6},{0xF7, 0xC9},{0xF8, 0xCB},{0xF9, 0xCE},
        {0xFA, 0xD1},{0xFB, 0xD6},{0xFC, 0xD9},{0xFD, 0xDC},{0xFE, 0xDF},{0xFF, 0xE2},{0x93, 0x0D},{0xC0, 0x76},{0xC1, 0x76},{0xC2, 0x76},
        {0xC3, 0x76},{0xC4, 0x76},{0xC5, 0x76},{0xC6, 0x76},{0xC7, 0x76},{0xC8, 0x76},{0xC9, 0x77},{0xCA, 0x77},{0xCB, 0x77},{0xCC, 0x78},
        {0xCD, 0x78},{0xCE, 0x79},{0xCF, 0x7A},{0xD0, 0x7B},{0xD1, 0x7C},{0xD2, 0x7D},{0xD3, 0x7E},{0xD4, 0x7F},{0xD5, 0x80},{0xD6, 0x82},
        {0xD7, 0x83},{0xD8, 0x84},{0xD9, 0x86},{0xDA, 0x87},{0xDB, 0x88},{0xDC, 0x8A},{0xDD, 0x8C},{0xDE, 0x8E},{0xDF, 0x90},{0xE0, 0x92},
        {0xE1, 0x95},{0xE2, 0x97},{0xE3, 0x99},{0xE4, 0x9C},{0xE5, 0x9F},{0xE6, 0xA1},{0xE7, 0xA4},{0xE8, 0xA5},{0xE9, 0xA8},{0xEA, 0xAB},
        {0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB5},{0xEE, 0xB7},{0xEF, 0xBB},{0xF0, 0xBE},{0xF1, 0xC1},{0xF2, 0xC3},{0xF3, 0xC6},{0xF4, 0xC9},
        {0xF5, 0xCC},{0xF6, 0xCF},{0xF7, 0xD2},{0xF8, 0xD6},{0xF9, 0xD9},{0xFA, 0xDC},{0xFB, 0xE0},{0xFC, 0xE3},{0xFD, 0xE6},{0xFE, 0xE9},
        {0xFF, 0xEE},{0x93, 0x0E},{0xC0, 0x4B},{0xC1, 0x4B},{0xC2, 0x4B},{0xC3, 0x4B},{0xC4, 0x4B},{0xC5, 0x4B},{0xC6, 0x4B},{0xC7, 0x4B},
        {0xC8, 0x4B},{0xC9, 0x4B},{0xCA, 0x4B},{0xCB, 0x4B},{0xCC, 0x4B},{0xCD, 0x4C},{0xCE, 0x4C},{0xCF, 0x4C},{0xD0, 0x4C},{0xD1, 0x4D},
        {0xD2, 0x4D},{0xD3, 0x4D},{0xD4, 0x4D},{0xD5, 0x4D},{0xD6, 0x4E},{0xD7, 0x4E},{0xD8, 0x4F},{0xD9, 0x4F},{0xDA, 0x50},{0xDB, 0x51},
        {0xDC, 0x51},{0xDD, 0x52},{0xDE, 0x52},{0xDF, 0x53},{0xE0, 0x54},{0xE1, 0x55},{0xE2, 0x55},{0xE3, 0x55},{0xE4, 0x56},{0xE5, 0x57},
        {0xE6, 0x57},{0xE7, 0x59},{0xE8, 0x5A},{0xE9, 0x5B},{0xEA, 0x5C},{0xEB, 0x5D},{0xEC, 0x5D},{0xED, 0x5E},{0xEE, 0x60},{0xEF, 0x61},
        {0xF0, 0x62},{0xF1, 0x63},{0xF2, 0x64},{0xF3, 0x65},{0xF4, 0x66},{0xF5, 0x68},{0xF6, 0x69},{0xF7, 0x6B},{0xF8, 0x6C},{0xF9, 0x6D},
        {0xFA, 0x6F},{0xFB, 0x70},{0xFC, 0x71},{0xFD, 0x73},{0xFE, 0x74},{0xFF, 0x76},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x61},{0xC1, 0x61},{0xC2, 0x61},{0xC3, 0x61},{0xC4, 0x61},{0xC5, 0x61},{0xC6, 0x62},{0xC7, 0x62},
        {0xC8, 0x62},{0xC9, 0x62},{0xCA, 0x63},{0xCB, 0x63},{0xCC, 0x63},{0xCD, 0x63},{0xCE, 0x64},{0xCF, 0x65},{0xD0, 0x66},{0xD1, 0x67},
        {0xD2, 0x68},{0xD3, 0x68},{0xD4, 0x69},{0xD5, 0x6A},{0xD6, 0x6C},{0xD7, 0x6D},{0xD8, 0x6F},{0xD9, 0x71},{0xDA, 0x72},{0xDB, 0x74},
        {0xDC, 0x75},{0xDD, 0x77},{0xDE, 0x79},{0xDF, 0x7B},{0xE0, 0x7D},{0xE1, 0x7F},{0xE2, 0x81},{0xE3, 0x83},{0xE4, 0x85},{0xE5, 0x87},
        {0xE6, 0x8A},{0xE7, 0x8B},{0xE8, 0x8E},{0xE9, 0x90},{0xEA, 0x92},{0xEB, 0x95},{0xEC, 0x98},{0xED, 0x9A},{0xEE, 0x9D},{0xEF, 0xA0},
        {0xF0, 0xA4},{0xF1, 0xA7},{0xF2, 0xA9},{0xF3, 0xAC},{0xF4, 0xAF},{0xF5, 0xB2},{0xF6, 0xB6},{0xF7, 0xBA},{0xF8, 0xBD},{0xF9, 0xC0},
        {0xFA, 0xC3},{0xFB, 0xC6},{0xFC, 0xC9},{0xFD, 0xCC},{0xFE, 0xCF},{0xFF, 0xD3},{0x93, 0x11},{0xC0, 0x68},{0xC1, 0x68},{0xC2, 0x68},
        {0xC3, 0x68},{0xC4, 0x68},{0xC5, 0x68},{0xC6, 0x68},{0xC7, 0x68},{0xC8, 0x68},{0xC9, 0x69},{0xCA, 0x69},{0xCB, 0x69},{0xCC, 0x6A},
        {0xCD, 0x6A},{0xCE, 0x6B},{0xCF, 0x6C},{0xD0, 0x6D},{0xD1, 0x6E},{0xD2, 0x6F},{0xD3, 0x70},{0xD4, 0x71},{0xD5, 0x72},{0xD6, 0x74},
        {0xD7, 0x74},{0xD8, 0x76},{0xD9, 0x78},{0xDA, 0x79},{0xDB, 0x7B},{0xDC, 0x7C},{0xDD, 0x7E},{0xDE, 0x7F},{0xDF, 0x82},{0xE0, 0x83},
        {0xE1, 0x86},{0xE2, 0x88},{0xE3, 0x8A},{0xE4, 0x8C},{0xE5, 0x8F},{0xE6, 0x90},{0xE7, 0x93},{0xE8, 0x95},{0xE9, 0x98},{0xEA, 0x9A},
        {0xEB, 0x9D},{0xEC, 0xA0},{0xED, 0xA4},{0xEE, 0xA6},{0xEF, 0xA9},{0xF0, 0xAC},{0xF1, 0xAF},{0xF2, 0xB2},{0xF3, 0xB6},{0xF4, 0xBA},
        {0xF5, 0xBE},{0xF6, 0xC1},{0xF7, 0xC4},{0xF8, 0xC6},{0xF9, 0xC9},{0xFA, 0xCC},{0xFB, 0xD1},{0xFC, 0xD4},{0xFD, 0xD8},{0xFE, 0xDC},
        {0xFF, 0xE2},{0x93, 0x12},{0xC0, 0x43},{0xC1, 0x43},{0xC2, 0x43},{0xC3, 0x43},{0xC4, 0x43},{0xC5, 0x43},{0xC6, 0x43},{0xC7, 0x43},
        {0xC8, 0x43},{0xC9, 0x43},{0xCA, 0x43},{0xCB, 0x43},{0xCC, 0x43},{0xCD, 0x43},{0xCE, 0x43},{0xCF, 0x43},{0xD0, 0x43},{0xD1, 0x44},
        {0xD2, 0x44},{0xD3, 0x44},{0xD4, 0x45},{0xD5, 0x45},{0xD6, 0x46},{0xD7, 0x46},{0xD8, 0x47},{0xD9, 0x47},{0xDA, 0x48},{0xDB, 0x48},
        {0xDC, 0x48},{0xDD, 0x49},{0xDE, 0x4A},{0xDF, 0x4B},{0xE0, 0x4B},{0xE1, 0x4C},{0xE2, 0x4D},{0xE3, 0x4D},{0xE4, 0x4D},{0xE5, 0x4E},
        {0xE6, 0x4F},{0xE7, 0x50},{0xE8, 0x51},{0xE9, 0x52},{0xEA, 0x53},{0xEB, 0x54},{0xEC, 0x55},{0xED, 0x55},{0xEE, 0x57},{0xEF, 0x57},
        {0xF0, 0x58},{0xF1, 0x59},{0xF2, 0x5A},{0xF3, 0x5B},{0xF4, 0x5B},{0xF5, 0x5D},{0xF6, 0x5E},{0xF7, 0x5F},{0xF8, 0x60},{0xF9, 0x61},
        {0xFA, 0x63},{0xFB, 0x63},{0xFC, 0x64},{0xFD, 0x66},{0xFE, 0x67},{0xFF, 0x68},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [25] Medium +6
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x79},{0xC1, 0x79},{0xC2, 0x79},{0xC3, 0x79},{0xC4, 0x79},{0xC5, 0x7A},{0xC6, 0x7A},{0xC7, 0x7A},
        {0xC8, 0x7A},{0xC9, 0x7A},{0xCA, 0x7A},{0xCB, 0x7B},{0xCC, 0x7B},{0xCD, 0x7C},{0xCE, 0x7C},{0xCF, 0x7D},{0xD0, 0x7E},{0xD1, 0x7E},
        {0xD2, 0x7F},{0xD3, 0x80},{0xD4, 0x81},{0xD5, 0x82},{0xD6, 0x84},{0xD7, 0x85},{0xD8, 0x87},{0xD9, 0x87},{0xDA, 0x89},{0xDB, 0x8B},
        {0xDC, 0x8E},{0xDD, 0x8F},{0xDE, 0x91},{0xDF, 0x94},{0xE0, 0x95},{0xE1, 0x97},{0xE2, 0x99},{0xE3, 0x9B},{0xE4, 0x9E},{0xE5, 0xA0},
        {0xE6, 0xA3},{0xE7, 0xA5},{0xE8, 0xA8},{0xE9, 0xAB},{0xEA, 0xAC},{0xEB, 0xAF},{0xEC, 0xB2},{0xED, 0xB5},{0xEE, 0xB7},{0xEF, 0xBC},
        {0xF0, 0xBF},{0xF1, 0xC2},{0xF2, 0xC4},{0xF3, 0xC6},{0xF4, 0xC9},{0xF5, 0xCC},{0xF6, 0xCE},{0xF7, 0xD1},{0xF8, 0xD4},{0xF9, 0xD7},
        {0xFA, 0xDA},{0xFB, 0xDD},{0xFC, 0xE0},{0xFD, 0xE2},{0xFE, 0xE5},{0xFF, 0xE8},{0x93, 0x09},{0xC0, 0x81},{0xC1, 0x81},{0xC2, 0x81},
        {0xC3, 0x81},{0xC4, 0x81},{0xC5, 0x81},{0xC6, 0x81},{0xC7, 0x81},{0xC8, 0x81},{0xC9, 0x82},{0xCA, 0x82},{0xCB, 0x82},{0xCC, 0x83},
        {0xCD, 0x83},{0xCE, 0x84},{0xCF, 0x85},{0xD0, 0x85},{0xD1, 0x86},{0xD2, 0x87},{0xD3, 0x87},{0xD4, 0x88},{0xD5, 0x89},{0xD6, 0x8B},
        {0xD7, 0x8D},{0xD8, 0x8F},{0xD9, 0x90},{0xDA, 0x92},{0xDB, 0x94},{0xDC, 0x95},{0xDD, 0x97},{0xDE, 0x98},{0xDF, 0x9A},{0xE0, 0x9C},
        {0xE1, 0x9F},{0xE2, 0xA1},{0xE3, 0xA3},{0xE4, 0xA6},{0xE5, 0xA8},{0xE6, 0xAB},{0xE7, 0xAD},{0xE8, 0xAF},{0xE9, 0xB2},{0xEA, 0xB5},
        {0xEB, 0xB7},{0xEC, 0xBB},{0xED, 0xBE},{0xEE, 0xC1},{0xEF, 0xC4},{0xF0, 0xC6},{0xF1, 0xC9},{0xF2, 0xCC},{0xF3, 0xCE},{0xF4, 0xD1},
        {0xF5, 0xD4},{0xF6, 0xD7},{0xF7, 0xDA},{0xF8, 0xDD},{0xF9, 0xE0},{0xFA, 0xE2},{0xFB, 0xE5},{0xFC, 0xE8},{0xFD, 0xEB},{0xFE, 0xEE},
        {0xFF, 0xF1},{0x93, 0x0A},{0xC0, 0x52},{0xC1, 0x52},{0xC2, 0x52},{0xC3, 0x52},{0xC4, 0x52},{0xC5, 0x52},{0xC6, 0x52},{0xC7, 0x52},
        {0xC8, 0x52},{0xC9, 0x52},{0xCA, 0x52},{0xCB, 0x52},{0xCC, 0x52},{0xCD, 0x52},{0xCE, 0x52},{0xCF, 0x52},{0xD0, 0x52},{0xD1, 0x52},
        {0xD2, 0x53},{0xD3, 0x53},{0xD4, 0x54},{0xD5, 0x54},{0xD6, 0x54},{0xD7, 0x55},{0xD8, 0x55},{0xD9, 0x56},{0xDA, 0x57},{0xDB, 0x57},
        {0xDC, 0x58},{0xDD, 0x59},{0xDE, 0x59},{0xDF, 0x5A},{0xE0, 0x5B},{0xE1, 0x5B},{0xE2, 0x5C},{0xE3, 0x5D},{0xE4, 0x5E},{0xE5, 0x5F},
        {0xE6, 0x61},{0xE7, 0x62},{0xE8, 0x63},{0xE9, 0x64},{0xEA, 0x65},{0xEB, 0x65},{0xEC, 0x67},{0xED, 0x68},{0xEE, 0x6A},{0xEF, 0x6C},
        {0xF0, 0x6D},{0xF1, 0x6D},{0xF2, 0x6F},{0xF3, 0x70},{0xF4, 0x71},{0xF5, 0x73},{0xF6, 0x74},{0xF7, 0x75},{0xF8, 0x77},{0xF9, 0x79},
        {0xFA, 0x7B},{0xFB, 0x7C},{0xFC, 0x7D},{0xFD, 0x7E},{0xFE, 0x7F},{0xFF, 0x81},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x70},{0xC1, 0x70},{0xC2, 0x70},{0xC3, 0x70},{0xC4, 0x70},{0xC5, 0x71},{0xC6, 0x71},{0xC7, 0x71},
        {0xC8, 0x71},{0xC9, 0x71},{0xCA, 0x71},{0xCB, 0x72},{0xCC, 0x72},{0xCD, 0x73},{0xCE, 0x73},{0xCF, 0x74},{0xD0, 0x75},{0xD1, 0x76},
        {0xD2, 0x77},{0xD3, 0x78},{0xD4, 0x79},{0xD5, 0x7A},{0xD6, 0x7C},{0xD7, 0x7D},{0xD8, 0x7F},{0xD9, 0x80},{0xDA, 0x82},{0xDB, 0x83},
        {0xDC, 0x85},{0xDD, 0x86},{0xDE, 0x87},{0xDF, 0x8A},{0xE0, 0x8C},{0xE1, 0x8F},{0xE2, 0x90},{0xE3, 0x92},{0xE4, 0x95},{0xE5, 0x97},
        {0xE6, 0x9A},{0xE7, 0x9C},{0xE8, 0x9F},{0xE9, 0xA2},{0xEA, 0xA4},{0xEB, 0xA6},{0xEC, 0xA9},{0xED, 0xAC},{0xEE, 0xAE},{0xEF, 0xB2},
        {0xF0, 0xB6},{0xF1, 0xB9},{0xF2, 0xBC},{0xF3, 0xBF},{0xF4, 0xC2},{0xF5, 0xC4},{0xF6, 0xC7},{0xF7, 0xCA},{0xF8, 0xCC},{0xF9, 0xCF},
        {0xFA, 0xD2},{0xFB, 0xD6},{0xFC, 0xDA},{0xFD, 0xDD},{0xFE, 0xE0},{0xFF, 0xE3},{0x93, 0x0D},{0xC0, 0x79},{0xC1, 0x79},{0xC2, 0x79},
        {0xC3, 0x79},{0xC4, 0x79},{0xC5, 0x79},{0xC6, 0x79},{0xC7, 0x79},{0xC8, 0x79},{0xC9, 0x7A},{0xCA, 0x7A},{0xCB, 0x7A},{0xCC, 0x7B},
        {0xCD, 0x7B},{0xCE, 0x7C},{0xCF, 0x7D},{0xD0, 0x7D},{0xD1, 0x7E},{0xD2, 0x7F},{0xD3, 0x80},{0xD4, 0x81},{0xD5, 0x82},{0xD6, 0x83},
        {0xD7, 0x84},{0xD8, 0x86},{0xD9, 0x87},{0xDA, 0x88},{0xDB, 0x8A},{0xDC, 0x8C},{0xDD, 0x8E},{0xDE, 0x90},{0xDF, 0x91},{0xE0, 0x93},
        {0xE1, 0x96},{0xE2, 0x98},{0xE3, 0x9A},{0xE4, 0x9D},{0xE5, 0x9F},{0xE6, 0xA2},{0xE7, 0xA5},{0xE8, 0xA6},{0xE9, 0xA9},{0xEA, 0xAC},
        {0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB5},{0xEE, 0xB8},{0xEF, 0xBC},{0xF0, 0xBF},{0xF1, 0xC2},{0xF2, 0xC4},{0xF3, 0xC7},{0xF4, 0xCA},
        {0xF5, 0xCC},{0xF6, 0xCF},{0xF7, 0xD2},{0xF8, 0xD6},{0xF9, 0xDA},{0xFA, 0xDD},{0xFB, 0xE0},{0xFC, 0xE3},{0xFD, 0xE7},{0xFE, 0xEB},
        {0xFF, 0xEE},{0x93, 0x0E},{0xC0, 0x4D},{0xC1, 0x4D},{0xC2, 0x4D},{0xC3, 0x4D},{0xC4, 0x4D},{0xC5, 0x4D},{0xC6, 0x4D},{0xC7, 0x4D},
        {0xC8, 0x4D},{0xC9, 0x4D},{0xCA, 0x4D},{0xCB, 0x4D},{0xCC, 0x4D},{0xCD, 0x4D},{0xCE, 0x4E},{0xCF, 0x4E},{0xD0, 0x4E},{0xD1, 0x4E},
        {0xD2, 0x4F},{0xD3, 0x4F},{0xD4, 0x50},{0xD5, 0x50},{0xD6, 0x50},{0xD7, 0x51},{0xD8, 0x51},{0xD9, 0x52},{0xDA, 0x52},{0xDB, 0x52},
        {0xDC, 0x53},{0xDD, 0x54},{0xDE, 0x54},{0xDF, 0x55},{0xE0, 0x55},{0xE1, 0x56},{0xE2, 0x57},{0xE3, 0x57},{0xE4, 0x58},{0xE5, 0x59},
        {0xE6, 0x5A},{0xE7, 0x5B},{0xE8, 0x5C},{0xE9, 0x5D},{0xEA, 0x5D},{0xEB, 0x5E},{0xEC, 0x60},{0xED, 0x61},{0xEE, 0x62},{0xEF, 0x63},
        {0xF0, 0x64},{0xF1, 0x65},{0xF2, 0x67},{0xF3, 0x68},{0xF4, 0x69},{0xF5, 0x6B},{0xF6, 0x6C},{0xF7, 0x6D},{0xF8, 0x6F},{0xF9, 0x70},
        {0xFA, 0x72},{0xFB, 0x73},{0xFC, 0x74},{0xFD, 0x76},{0xFE, 0x77},{0xFF, 0x79},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x63},{0xC1, 0x63},{0xC2, 0x63},{0xC3, 0x63},{0xC4, 0x63},{0xC5, 0x64},{0xC6, 0x64},{0xC7, 0x64},
        {0xC8, 0x64},{0xC9, 0x64},{0xCA, 0x64},{0xCB, 0x65},{0xCC, 0x65},{0xCD, 0x66},{0xCE, 0x66},{0xCF, 0x67},{0xD0, 0x68},{0xD1, 0x68},
        {0xD2, 0x69},{0xD3, 0x6A},{0xD4, 0x6B},{0xD5, 0x6C},{0xD6, 0x6E},{0xD7, 0x6F},{0xD8, 0x71},{0xD9, 0x72},{0xDA, 0x74},{0xDB, 0x75},
        {0xDC, 0x77},{0xDD, 0x78},{0xDE, 0x7A},{0xDF, 0x7C},{0xE0, 0x7E},{0xE1, 0x80},{0xE2, 0x82},{0xE3, 0x83},{0xE4, 0x86},{0xE5, 0x88},
        {0xE6, 0x8B},{0xE7, 0x8C},{0xE8, 0x8F},{0xE9, 0x91},{0xEA, 0x93},{0xEB, 0x96},{0xEC, 0x99},{0xED, 0x9B},{0xEE, 0x9D},{0xEF, 0xA1},
        {0xF0, 0xA5},{0xF1, 0xA8},{0xF2, 0xAA},{0xF3, 0xAD},{0xF4, 0xB0},{0xF5, 0xB4},{0xF6, 0xB7},{0xF7, 0xBB},{0xF8, 0xBE},{0xF9, 0xC1},
        {0xFA, 0xC4},{0xFB, 0xC6},{0xFC, 0xCA},{0xFD, 0xCD},{0xFE, 0xD1},{0xFF, 0xD4},{0x93, 0x11},{0xC0, 0x6B},{0xC1, 0x6B},{0xC2, 0x6B},
        {0xC3, 0x6B},{0xC4, 0x6B},{0xC5, 0x6B},{0xC6, 0x6B},{0xC7, 0x6B},{0xC8, 0x6B},{0xC9, 0x6C},{0xCA, 0x6C},{0xCB, 0x6C},{0xCC, 0x6D},
        {0xCD, 0x6D},{0xCE, 0x6E},{0xCF, 0x6F},{0xD0, 0x6F},{0xD1, 0x70},{0xD2, 0x71},{0xD3, 0x72},{0xD4, 0x73},{0xD5, 0x74},{0xD6, 0x75},
        {0xD7, 0x76},{0xD8, 0x78},{0xD9, 0x79},{0xDA, 0x7B},{0xDB, 0x7C},{0xDC, 0x7E},{0xDD, 0x7F},{0xDE, 0x81},{0xDF, 0x83},{0xE0, 0x84},
        {0xE1, 0x87},{0xE2, 0x89},{0xE3, 0x8B},{0xE4, 0x8D},{0xE5, 0x8F},{0xE6, 0x91},{0xE7, 0x94},{0xE8, 0x96},{0xE9, 0x99},{0xEA, 0x9B},
        {0xEB, 0x9D},{0xEC, 0xA0},{0xED, 0xA4},{0xEE, 0xA7},{0xEF, 0xAA},{0xF0, 0xAD},{0xF1, 0xB0},{0xF2, 0xB4},{0xF3, 0xB7},{0xF4, 0xBB},
        {0xF5, 0xBE},{0xF6, 0xC1},{0xF7, 0xC4},{0xF8, 0xC6},{0xF9, 0xCA},{0xFA, 0xCD},{0xFB, 0xD1},{0xFC, 0xD4},{0xFD, 0xD9},{0xFE, 0xDE},
        {0xFF, 0xE2},{0x93, 0x12},{0xC0, 0x45},{0xC1, 0x45},{0xC2, 0x45},{0xC3, 0x45},{0xC4, 0x45},{0xC5, 0x45},{0xC6, 0x45},{0xC7, 0x45},
        {0xC8, 0x45},{0xC9, 0x45},{0xCA, 0x45},{0xCB, 0x45},{0xCC, 0x45},{0xCD, 0x45},{0xCE, 0x46},{0xCF, 0x46},{0xD0, 0x46},{0xD1, 0x46},
        {0xD2, 0x47},{0xD3, 0x47},{0xD4, 0x48},{0xD5, 0x48},{0xD6, 0x48},{0xD7, 0x48},{0xD8, 0x48},{0xD9, 0x49},{0xDA, 0x4A},{0xDB, 0x4A},
        {0xDC, 0x4B},{0xDD, 0x4B},{0xDE, 0x4B},{0xDF, 0x4C},{0xE0, 0x4D},{0xE1, 0x4D},{0xE2, 0x4E},{0xE3, 0x4F},{0xE4, 0x4F},{0xE5, 0x50},
        {0xE6, 0x51},{0xE7, 0x52},{0xE8, 0x53},{0xE9, 0x54},{0xEA, 0x55},{0xEB, 0x55},{0xEC, 0x57},{0xED, 0x57},{0xEE, 0x58},{0xEF, 0x59},
        {0xF0, 0x5A},{0xF1, 0x5B},{0xF2, 0x5C},{0xF3, 0x5D},{0xF4, 0x5E},{0xF5, 0x5F},{0xF6, 0x60},{0xF7, 0x61},{0xF8, 0x63},{0xF9, 0x63},
        {0xFA, 0x65},{0xFB, 0x66},{0xFC, 0x67},{0xFD, 0x68},{0xFE, 0x69},{0xFF, 0x6B},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
    // [27] Weak 0
    {
        {0x91, 0x85},{0x93, 0x08},{0xC0, 0x65},{0xC1, 0x65},{0xC2, 0x65},{0xC3, 0x65},{0xC4, 0x65},{0xC5, 0x65},{0xC6, 0x65},{0xC7, 0x65},
        {0xC8, 0x66},{0xC9, 0x66},{0xCA, 0x67},{0xCB, 0x68},{0xCC, 0x6A},{0xCD, 0x6B},{0xCE, 0x6D},{0xCF, 0x6D},{0xD0, 0x6F},{0xD1, 0x70},
        {0xD2, 0x72},{0xD3, 0x74},{0xD4, 0x76},{0xD5, 0x79},{0xD6, 0x7B},{0xD7, 0x7D},{0xD8, 0x7E},{0xD9, 0x80},{0xDA, 0x82},{0xDB, 0x85},
        {0xDC, 0x87},{0xDD, 0x89},{0xDE, 0x8B},{0xDF, 0x8F},{0xE0, 0x92},{0xE1, 0x95},{0xE2, 0x96},{0xE3, 0x98},{0xE4, 0x9B},{0xE5, 0x9E},
        {0xE6, 0xA0},{0xE7, 0xA3},{0xE8, 0xA6},{0xE9, 0xA9},{0xEA, 0xAC},{0xEB, 0xAE},{0xEC, 0xB1},{0xED, 0xB4},{0xEE, 0xB7},{0xEF, 0xBC},
        {0xF0, 0xBF},{0xF1, 0xC2},{0xF2, 0xC4},{0xF3, 0xC6},{0xF4, 0xC9},{0xF5, 0xCC},{0xF6, 0xCF},{0xF7, 0xD2},{0xF8, 0xD5},{0xF9, 0xD8},
        {0xFA, 0xDB},{0xFB, 0xDE},{0xFC, 0xE1},{0xFD, 0xE3},{0xFE, 0xE6},{0xFF, 0xE8},{0x93, 0x09},{0xC0, 0x6D},{0xC1, 0x6D},{0xC2, 0x6D},
        {0xC3, 0x6D},{0xC4, 0x6D},{0xC5, 0x6D},{0xC6, 0x6D},{0xC7, 0x6D},{0xC8, 0x6E},{0xC9, 0x6E},{0xCA, 0x6F},{0xCB, 0x70},{0xCC, 0x71},
        {0xCD, 0x72},{0xCE, 0x73},{0xCF, 0x75},{0xD0, 0x76},{0xD1, 0x77},{0xD2, 0x7A},{0xD3, 0x7C},{0xD4, 0x7D},{0xD5, 0x7E},{0xD6, 0x80},
        {0xD7, 0x82},{0xD8, 0x84},{0xD9, 0x86},{0xDA, 0x88},{0xDB, 0x8A},{0xDC, 0x8D},{0xDD, 0x90},{0xDE, 0x92},{0xDF, 0x94},{0xE0, 0x97},
        {0xE1, 0x98},{0xE2, 0x9B},{0xE3, 0x9D},{0xE4, 0xA0},{0xE5, 0xA3},{0xE6, 0xA6},{0xE7, 0xA9},{0xE8, 0xAB},{0xE9, 0xAD},{0xEA, 0xB0},
        {0xEB, 0xB3},{0xEC, 0xB6},{0xED, 0xB9},{0xEE, 0xBD},{0xEF, 0xC1},{0xF0, 0xC3},{0xF1, 0xC6},{0xF2, 0xC8},{0xF3, 0xCB},{0xF4, 0xCE},
        {0xF5, 0xD0},{0xF6, 0xD3},{0xF7, 0xD7},{0xF8, 0xDA},{0xF9, 0xDD},{0xFA, 0xDF},{0xFB, 0xE1},{0xFC, 0xE4},{0xFD, 0xE8},{0xFE, 0xEA},
        {0xFF, 0xED},{0x93, 0x0A},{0xC0, 0x3E},{0xC1, 0x3E},{0xC2, 0x3E},{0xC3, 0x3E},{0xC4, 0x3E},{0xC5, 0x3F},{0xC6, 0x3F},{0xC7, 0x3F},
        {0xC8, 0x3F},{0xC9, 0x3F},{0xCA, 0x3F},{0xCB, 0x3F},{0xCC, 0x3F},{0xCD, 0x3F},{0xCE, 0x3F},{0xCF, 0x3F},{0xD0, 0x3F},{0xD1, 0x3F},
        {0xD2, 0x3F},{0xD3, 0x40},{0xD4, 0x40},{0xD5, 0x40},{0xD6, 0x40},{0xD7, 0x40},{0xD8, 0x40},{0xD9, 0x41},{0xDA, 0x41},{0xDB, 0x41},
        {0xDC, 0x41},{0xDD, 0x42},{0xDE, 0x42},{0xDF, 0x42},{0xE0, 0x42},{0xE1, 0x43},{0xE2, 0x43},{0xE3, 0x43},{0xE4, 0x45},{0xE5, 0x45},
        {0xE6, 0x45},{0xE7, 0x46},{0xE8, 0x46},{0xE9, 0x46},{0xEA, 0x47},{0xEB, 0x47},{0xEC, 0x47},{0xED, 0x48},{0xEE, 0x48},{0xEF, 0x49},
        {0xF0, 0x49},{0xF1, 0x49},{0xF2, 0x4A},{0xF3, 0x4A},{0xF4, 0x4A},{0xF5, 0x4A},{0xF6, 0x4B},{0xF7, 0x4B},{0xF8, 0x4C},{0xF9, 0x4C},
        {0xFA, 0x4D},{0xFB, 0x4D},{0xFC, 0x4E},{0xFD, 0x4E},{0xFE, 0x4F},{0xFF, 0x4F},{0x93, 0x0B},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x0C},{0xC0, 0x5D},{0xC1, 0x5D},{0xC2, 0x5D},{0xC3, 0x5D},{0xC4, 0x5D},{0xC5, 0x5D},{0xC6, 0x5E},{0xC7, 0x5E},
        {0xC8, 0x5F},{0xC9, 0x5F},{0xCA, 0x60},{0xCB, 0x61},{0xCC, 0x62},{0xCD, 0x62},{0xCE, 0x64},{0xCF, 0x65},{0xD0, 0x67},{0xD1, 0x68},
        {0xD2, 0x6A},{0xD3, 0x6C},{0xD4, 0x6E},{0xD5, 0x70},{0xD6, 0x72},{0xD7, 0x74},{0xD8, 0x76},{0xD9, 0x78},{0xDA, 0x7A},{0xDB, 0x7D},
        {0xDC, 0x7F},{0xDD, 0x82},{0xDE, 0x83},{0xDF, 0x86},{0xE0, 0x88},{0xE1, 0x8B},{0xE2, 0x8D},{0xE3, 0x90},{0xE4, 0x92},{0xE5, 0x95},
        {0xE6, 0x97},{0xE7, 0x9A},{0xE8, 0x9D},{0xE9, 0xA0},{0xEA, 0xA3},{0xEB, 0xA5},{0xEC, 0xA8},{0xED, 0xAB},{0xEE, 0xAE},{0xEF, 0xB2},
        {0xF0, 0xB6},{0xF1, 0xB9},{0xF2, 0xBC},{0xF3, 0xBF},{0xF4, 0xC2},{0xF5, 0xC4},{0xF6, 0xC8},{0xF7, 0xCB},{0xF8, 0xCD},{0xF9, 0xD0},
        {0xFA, 0xD4},{0xFB, 0xD8},{0xFC, 0xDB},{0xFD, 0xDE},{0xFE, 0xE1},{0xFF, 0xE4},{0x93, 0x0D},{0xC0, 0x64},{0xC1, 0x64},{0xC2, 0x64},
        {0xC3, 0x64},{0xC4, 0x64},{0xC5, 0x64},{0xC6, 0x65},{0xC7, 0x65},{0xC8, 0x66},{0xC9, 0x66},{0xCA, 0x67},{0xCB, 0x68},{0xCC, 0x69},
        {0xCD, 0x6A},{0xCE, 0x6B},{0xCF, 0x6D},{0xD0, 0x6E},{0xD1, 0x6F},{0xD2, 0x71},{0xD3, 0x73},{0xD4, 0x74},{0xD5, 0x76},{0xD6, 0x78},
        {0xD7, 0x7A},{0xD8, 0x7C},{0xD9, 0x7E},{0xDA, 0x81},{0xDB, 0x83},{0xDC, 0x84},{0xDD, 0x87},{0xDE, 0x88},{0xDF, 0x8A},{0xE0, 0x8E},
        {0xE1, 0x90},{0xE2, 0x92},{0xE3, 0x94},{0xE4, 0x97},{0xE5, 0x9A},{0xE6, 0x9D},{0xE7, 0xA0},{0xE8, 0xA2},{0xE9, 0xA5},{0xEA, 0xA7},
        {0xEB, 0xAA},{0xEC, 0xAD},{0xED, 0xB0},{0xEE, 0xB3},{0xEF, 0xB8},{0xF0, 0xBB},{0xF1, 0xBE},{0xF2, 0xC1},{0xF3, 0xC3},{0xF4, 0xC6},
        {0xF5, 0xC9},{0xF6, 0xCB},{0xF7, 0xCF},{0xF8, 0xD2},{0xF9, 0xD6},{0xFA, 0xD9},{0xFB, 0xDC},{0xFC, 0xDF},{0xFD, 0xE3},{0xFE, 0xE6},
        {0xFF, 0xE9},{0x93, 0x0E},{0xC0, 0x3C},{0xC1, 0x3C},{0xC2, 0x3C},{0xC3, 0x3C},{0xC4, 0x3C},{0xC5, 0x3D},{0xC6, 0x3D},{0xC7, 0x3D},
        {0xC8, 0x3D},{0xC9, 0x3D},{0xCA, 0x3D},{0xCB, 0x3D},{0xCC, 0x3D},{0xCD, 0x3D},{0xCE, 0x3D},{0xCF, 0x3D},{0xD0, 0x3D},{0xD1, 0x3D},
        {0xD2, 0x3D},{0xD3, 0x3E},{0xD4, 0x3E},{0xD5, 0x3E},{0xD6, 0x3E},{0xD7, 0x3E},{0xD8, 0x3E},{0xD9, 0x3E},{0xDA, 0x3E},{0xDB, 0x3E},
        {0xDC, 0x3E},{0xDD, 0x3F},{0xDE, 0x3F},{0xDF, 0x3F},{0xE0, 0x3F},{0xE1, 0x40},{0xE2, 0x40},{0xE3, 0x40},{0xE4, 0x41},{0xE5, 0x41},
        {0xE6, 0x41},{0xE7, 0x41},{0xE8, 0x41},{0xE9, 0x41},{0xEA, 0x42},{0xEB, 0x42},{0xEC, 0x42},{0xED, 0x43},{0xEE, 0x43},{0xEF, 0x44},
        {0xF0, 0x44},{0xF1, 0x44},{0xF2, 0x45},{0xF3, 0x45},{0xF4, 0x46},{0xF5, 0x46},{0xF6, 0x47},{0xF7, 0x47},{0xF8, 0x48},{0xF9, 0x48},
        {0xFA, 0x49},{0xFB, 0x49},{0xFC, 0x4A},{0xFD, 0x4A},{0xFE, 0x4B},{0xFF, 0x4B},{0x93, 0x0F},{0xC0, 0x16},{0xC1, 0x16},{0xC2, 0x16},
        {0xC3, 0x16},{0xC4, 0x16},{0xC5, 0x16},{0xC6, 0x16},{0xC7, 0x16},{0xC8, 0x16},{0xC9, 0x16},{0xCA, 0x16},{0xCB, 0x16},{0xCC, 0x16},
        {0xCD, 0x16},{0xCE, 0x16},{0xCF, 0x16},{0xD0, 0x16},{0xD1, 0x16},{0xD2, 0x16},{0xD3, 0x16},{0xD4, 0x16},{0xD5, 0x16},{0xD6, 0x16},
        {0xD7, 0x16},{0xD8, 0x16},{0xD9, 0x16},{0xDA, 0x16},{0xDB, 0x16},{0xDC, 0x16},{0xDD, 0x16},{0xDE, 0x16},{0xDF, 0x16},{0xE0, 0x16},
        {0xE1, 0x16},{0xE2, 0x16},{0xE3, 0x16},{0xE4, 0x16},{0xE5, 0x16},{0xE6, 0x16},{0xE7, 0x16},{0xE8, 0x16},{0xE9, 0x16},{0xEA, 0x16},
        {0xEB, 0x16},{0xEC, 0x16},{0xED, 0x16},{0xEE, 0x16},{0xEF, 0x16},{0xF0, 0x16},{0xF1, 0x16},{0xF2, 0x16},{0xF3, 0x16},{0xF4, 0x16},
        {0xF5, 0x16},{0xF6, 0x16},{0xF7, 0x16},{0xF8, 0x16},{0xF9, 0x16},{0xFA, 0x16},{0xFB, 0x16},{0xFC, 0x16},{0xFD, 0x16},{0xFE, 0x16},
        {0xFF, 0x16},{0x93, 0x10},{0xC0, 0x55},{0xC1, 0x55},{0xC2, 0x55},{0xC3, 0x55},{0xC4, 0x55},{0xC5, 0x55},{0xC6, 0x55},{0xC7, 0x55},
        {0xC8, 0x56},{0xC9, 0x56},{0xCA, 0x57},{0xCB, 0x57},{0xCC, 0x58},{0xCD, 0x59},{0xCE, 0x5A},{0xCF, 0x5B},{0xD0, 0x5C},{0xD1, 0x5D},
        {0xD2, 0x5E},{0xD3, 0x60},{0xD4, 0x62},{0xD5, 0x63},{0xD6, 0x65},{0xD7, 0x67},{0xD8, 0x68},{0xD9, 0x6A},{0xDA, 0x6C},{0xDB, 0x6F},
        {0xDC, 0x71},{0xDD, 0x74},{0xDE, 0x75},{0xDF, 0x78},{0xE0, 0x7B},{0xE1, 0x7D},{0xE2, 0x7F},{0xE3, 0x81},{0xE4, 0x83},{0xE5, 0x86},
        {0xE6, 0x88},{0xE7, 0x8B},{0xE8, 0x8D},{0xE9, 0x90},{0xEA, 0x92},{0xEB, 0x95},{0xEC, 0x98},{0xED, 0x9A},{0xEE, 0x9D},{0xEF, 0xA1},
        {0xF0, 0xA5},{0xF1, 0xA8},{0xF2, 0xAA},{0xF3, 0xAD},{0xF4, 0xB0},{0xF5, 0xB4},{0xF6, 0xB8},{0xF7, 0xBC},{0xF8, 0xBF},{0xF9, 0xC2},
        {0xFA, 0xC5},{0xFB, 0xC8},{0xFC, 0xCB},{0xFD, 0xCE},{0xFE, 0xD2},{0xFF, 0xD5},{0x93, 0x11},{0xC0, 0x5A},{0xC1, 0x5A},{0xC2, 0x5A},
        {0xC3, 0x5A},{0xC4, 0x5A},{0xC5, 0x5A},{0xC6, 0x5B},{0xC7, 0x5B},{0xC8, 0x5B},{0xC9, 0x5B},{0xCA, 0x5C},{0xCB, 0x5D},{0xCC, 0x5E},
        {0xCD, 0x5E},{0xCE, 0x5F},{0xCF, 0x61},{0xD0, 0x62},{0xD1, 0x63},{0xD2, 0x64},{0xD3, 0x66},{0xD4, 0x67},{0xD5, 0x68},{0xD6, 0x6A},
        {0xD7, 0x6C},{0xD8, 0x6E},{0xD9, 0x70},{0xDA, 0x73},{0xDB, 0x74},{0xDC, 0x76},{0xDD, 0x79},{0xDE, 0x7B},{0xDF, 0x7C},{0xE0, 0x7F},
        {0xE1, 0x81},{0xE2, 0x83},{0xE3, 0x85},{0xE4, 0x88},{0xE5, 0x8B},{0xE6, 0x8D},{0xE7, 0x90},{0xE8, 0x91},{0xE9, 0x94},{0xEA, 0x97},
        {0xEB, 0x9A},{0xEC, 0x9C},{0xED, 0x9F},{0xEE, 0xA3},{0xEF, 0xA7},{0xF0, 0xA9},{0xF1, 0xAC},{0xF2, 0xAF},{0xF3, 0xB2},{0xF4, 0xB6},
        {0xF5, 0xBA},{0xF6, 0xBD},{0xF7, 0xC1},{0xF8, 0xC4},{0xF9, 0xC6},{0xFA, 0xC9},{0xFB, 0xCC},{0xFC, 0xCF},{0xFD, 0xD4},{0xFE, 0xD8},
        {0xFF, 0xDC},{0x93, 0x12},{0xC0, 0x37},{0xC1, 0x37},{0xC2, 0x37},{0xC3, 0x37},{0xC4, 0x37},{0xC5, 0x38},{0xC6, 0x38},{0xC7, 0x38},
        {0xC8, 0x38},{0xC9, 0x38},{0xCA, 0x38},{0xCB, 0x38},{0xCC, 0x38},{0xCD, 0x38},{0xCE, 0x38},{0xCF, 0x38},{0xD0, 0x38},{0xD1, 0x38},
        {0xD2, 0x38},{0xD3, 0x38},{0xD4, 0x38},{0xD5, 0x38},{0xD6, 0x38},{0xD7, 0x38},{0xD8, 0x38},{0xD9, 0x39},{0xDA, 0x39},{0xDB, 0x39},
        {0xDC, 0x39},{0xDD, 0x3A},{0xDE, 0x3A},{0xDF, 0x3A},{0xE0, 0x3A},{0xE1, 0x3A},{0xE2, 0x3A},{0xE3, 0x3A},{0xE4, 0x3B},{0xE5, 0x3B},
        {0xE6, 0x3B},{0xE7, 0x3C},{0xE8, 0x3C},{0xE9, 0x3C},{0xEA, 0x3C},{0xEB, 0x3C},{0xEC, 0x3C},{0xED, 0x3D},{0xEE, 0x3D},{0xEF, 0x3D},
        {0xF0, 0x3D},{0xF1, 0x3D},{0xF2, 0x3E},{0xF3, 0x3E},{0xF4, 0x3F},{0xF5, 0x3F},{0xF6, 0x3F},{0xF7, 0x3F},{0xF8, 0x40},{0xF9, 0x40},
        {0xFA, 0x41},{0xFB, 0x41},{0xFC, 0x42},{0xFD, 0x42},{0xFE, 0x43},{0xFF, 0x43},{0x93, 0x13},{0xC0, 0x0E},{0xC1, 0x0E},{0xC2, 0x0E},
        {0xC3, 0x0E},{0xC4, 0x0E},{0xC5, 0x0E},{0xC6, 0x0E},{0xC7, 0x0E},{0xC8, 0x0E},{0xC9, 0x0E},{0xCA, 0x0E},{0xCB, 0x0E},{0xCC, 0x0E},
        {0xCD, 0x0E},{0xCE, 0x0E},{0xCF, 0x0E},{0xD0, 0x0E},{0xD1, 0x0E},{0xD2, 0x0E},{0xD3, 0x0E},{0xD4, 0x0E},{0xD5, 0x0E},{0xD6, 0x0E},
        {0xD7, 0x0E},{0xD8, 0x0E},{0xD9, 0x0E},{0xDA, 0x0E},{0xDB, 0x0E},{0xDC, 0x0E},{0xDD, 0x0E},{0xDE, 0x0E},{0xDF, 0x0E},{0xE0, 0x0E},
        {0xE1, 0x0E},{0xE2, 0x0E},{0xE3, 0x0E},{0xE4, 0x0E},{0xE5, 0x0E},{0xE6, 0x0E},{0xE7, 0x0E},{0xE8, 0x0E},{0xE9, 0x0E},{0xEA, 0x0E},
        {0xEB, 0x0E},{0xEC, 0x0E},{0xED, 0x0E},{0xEE, 0x0E},{0xEF, 0x0E},{0xF0, 0x0E},{0xF1, 0x0E},{0xF2, 0x0E},{0xF3, 0x0E},{0xF4, 0x0E},
        {0xF5, 0x0E},{0xF6, 0x0E},{0xF7, 0x0E},{0xF8, 0x0E},{0xF9, 0x0E},{0xFA, 0x0E},{0xFB, 0x0E},{0xFC, 0x0E},{0xFD, 0x0E},{0xFE, 0x0E},
        {0xFF, 0x0E},{0x91, 0x84},{0x93, 0x00}
    },
};

#define NUM_TEX    10
#define SIZE_TEX    131
char veil_tex[NUM_TEX][SIZE_TEX][2] = {
    // [0]
	{
#include "32x32_M_net_tex.h"
	},
    // [1]
	{
#include "32x32_M_sky_tex.h"
	},
    // [2]
    {
#include "32x32_M_mat_tex.h"
    },
    // [3]
    {
#include "32x32_M_waterdrop_tex.h"
    },
	// [4]
	{
#include "32x32_M_rabbit_tex.h"
	},
	// [5]
	{
#include "32x32_M_cat_tex.h"
	},
	// [6]
	{
#include "32x32_M_eat_tex.h"
	},
	// [7]
	{
#include "32x32_M_dont_see_tex.h"
	},
	{
#include "32x32_M_bird_tex.h"
	},
	{
#include "32x32_M_leaf_tex.h"
	},
};

#define NUM_MAP    3
#define SIZE_MAP   130
char veil_colormap[NUM_MAP][SIZE_MAP][3] = {
    // [0]
    {
#include "map_black.h"
	},
    // [1]
    {
#include "map_waterdrop.h"
	},
    // [2]
    {
#include "map_rabbit.h"
	}
};

char veil_on[4][2] = {
    {0x93, 0x03},
    {0xC0, 0x19},   //color mode
    {0x90, 0x01}, 
    {0x93, 0x00}
};

char veil_off[4][2] = {
    {0x93, 0x03},
    {0xC0, 0x18},
    {0x90, 0x01},
    {0x93, 0x00}
};


