/*
 *
 * pantech android cdrom support function list
 *
 *
 *
 */
#ifdef CONFIG_ANDROID_PANTECH_USB_MANAGER
#include "f_pantech_android.h"
#endif

// tarial fixed this code
// reason : after eject command, file pointer remove only.
/*
#define SETUP_CANCEL_TIMEOUT msecs_to_jiffies(30*1000)
struct delayed_work cancel_work;
void pantech_cancel_timeout_cdrom_mode(struct work_struct *w);
*/

#define backing_file_is_open(curlun)	((curlun)->filp != NULL)

static unsigned char pantech_cdrom_enabled;
static unsigned char pantech_cdrom_only;
unsigned char pantech_get_cdrom_enabled(void){
	return pantech_cdrom_enabled;
}

void pantech_set_cdrom_enabled(unsigned char enabled, unsigned char only)
{
	//xsemiyas_debug
	printk(KERN_ERR "xsemiyas[%s]:enabled[%d], only[%d]\n", __func__, enabled, only);
	pantech_cdrom_enabled = enabled;
	pantech_cdrom_only = only;
}

#define FPOS(type, field) \
	((u32)&((type*)0)->field)

typedef struct fsg_bulk_cb_wrap usbsdms_command_block_wrapper_type;

typedef enum
{
	USBSDMS_OS_NONE,
	USBSDMS_OS_WIN2K,
	USBSDMS_OS_WINXP,
	USBSDMS_OS_WINXP64, 
	USBSDMS_OS_WIN2003,
	USBSDMS_OS_WIN200364, 
	USBSDMS_OS_WINVISTA,
	USBSDMS_OS_WINVISTA64,
	USBSDMS_OS_WIN7,
	USBSDMS_OS_WIN764, 
	USBSDMS_OS_MAC0SX3 = 0x20,
	USBSDMS_OS_MAC0SX4,
	USBSDMS_OS_MAC0SX5,
	USBSDMS_OS_LINUX = 0x30,
	USBSDMS_OS_DEFAULT = 0x52,
	USBSDMS_OS_NUM
} usbsdms_os_info_type;

typedef enum
{
	USBSDMS_CLP_NONE,
	USBSDMS_CLP_ENABLECD_VT,
	USBSDMS_CLP_DISABLECD_VT,
	USBSDMS_CLP_ENABLECD_NV,
	USBSDMS_CLP_DISABLECD_NV,
	USBSDMS_CLP_NUM
} usbsdms_clp_type;


#define USBSDMS_MODE_CHANGE_VOLATILITY_CODE 	0xFF 
#define USBSDMS_MODE_CHANGE_CANCEL_TIMER     	0xFE 
#define USBSDMS_MODE_GET_DEVICEMODE				0xFD //p13120_EUT
#define CHECK_SWVERSION							0x01 //p13120_EUT

/* xsemiyas change */
#define USBSDMS_CDR_BUFFER_BLOCK_COUNT     4
#define USBSDMS_ISO9660_SECTOR_SIZE                   2048
#define USBSDMS_ISO9660_BLOCK_PER_SECTOR       4
#define USBSDMS_ISO9660_PHY_BYTES_PER_SECTOR   2352

#define USBSDMS_READCD_CODE        0xBE
#define USBSDMS_GET_CONFIGURATION_CODE      0x46
#define USBSDMS_READ_TOC_PMA_CODE       0x43  

#define PROFILE_LIST_FEATURE_CODE           0x0000
#define CORE_FEATURE_CODE                         0x0100
#define MORPHING_FEATURE_CODE                 0x0200
#define CDREAD_FEATURE_CODE                     0x1E00
#define RANDOM_READABLE_FEATURE_CODE  0x1000


/*---------------------------------------------------------------------------
  SCSI Read CD Command
---------------------------------------------------------------------------*/
typedef struct _usbsdms_readcd_scsi_cmd_type
{
   u8 op_code;  
   u8 expected_sector_type;  
   u32 block_addr;
   u8 reserved;
   u16 tranfer_block_len;
   u8 main_chan_sel_bits;  
   u8 sub_chan_sel_bits;
   u8 control;  
} __attribute__((__packed__)) usbsdms_readcd_scsi_cmd_type;

/*---------------------------------------------------------------------------
  SCSI Get Configuration Command
---------------------------------------------------------------------------*/
typedef  struct _usbsdms_get_configuration_scsi_cmd_type
{
  u8   op_code;
  u8   rt;
  u16  start_feature_no;
  u8   reserved1;
  u16  reserved2;
  u16  alloc_length;
}__attribute__((__packed__)) usbsdms_get_configuration_scsi_cmd_type;

typedef  struct _get_configuration_feature_type{
  u16  feature_code;
  u8   version_cur;
  u8   additional_len;
  u8   desc_data[4];
}__attribute__((__packed__)) get_configuration_feature_type;

typedef  struct _usbsdms_get_configuration_scsi_rsp_type
{
  u32 data_length;
  u16   reserved1;
  u16   current_profile;
  u8    feature_descriptors[40];
}__attribute__((__packed__)) usbsdms_get_configuration_scsi_rsp_type;

/* Lousi Kim 20090512 */
typedef  struct _usbsdms_get_start_stop_scsi_cmd_type
{
  u8   op_code;
  u8   immed;
  u8   reserved1;
  u8   reserved2;
  u8   power_conditions;
  u8   control;  
}__attribute__((__packed__)) usbsdms_get_start_stop_scsi_cmd_type;


/*---------------------------------------------------------------------------
  SCSI Read TOC/PMA/ATIP Command
---------------------------------------------------------------------------*/
typedef  struct _usbsdms_read_toc_scsi_cmd_type
{
  u8  op_code;
  u8  msf;
  u8  format_type;
  u16 reserved1;
  u8  reserved2;
  u8  track_no;
  u16 alloc_length;
  u8  control;
}__attribute__((__packed__)) usbsdms_read_toc_scsi_cmd_type;

typedef  struct _toc_track_desc_type
{
  u8      reserved1;
  u8      addr_control;
  u8      track_no;
  u8      reserved2;
  u32   track_start_addr;
}__attribute__((__packed__)) toc_track_desc_type;

typedef  struct _usbsdms_toc_rsp_type
{
  u16                        data_length;
  u8                         first_track_no;
  u8                         last_track_no;
  toc_track_desc_type  desc[2];
}__attribute__((__packed__)) usbsdms_toc_rsp_type;

usbsdms_get_configuration_scsi_rsp_type usbsdms_cdr_conf_rsp;
usbsdms_toc_rsp_type  usbsdms_cdr_toc_rsp;

/* xsemiyas : the code for what */
#ifdef NOUSE 
static u8 usbsdms_ro_inquiry_data[] __attribute__((__aligned__(4)))= {
   0x05,                        /*= Device class */
   0x80,                        /*= RMB BYTE is set by inquiry data */
   0x02,                        /* ANSI SCSI 2 */
   0x00,                        /*= Data format = 0,  */
   0x33,                        /*= Additional length   */
   0x00, 0x00, 0x00,
   /* Manufacturer = UM175 */
   0x55, 0x4D, 0x57, 0x31, 0x39, 0x30, 0x20, 0x20, 
   0x43, 0x44, 0x2D, 0x52, 0x4F, 0x4D, 0x20, 0x20, 
   /* = Product = CD-ROM */
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   /* = Revision = 2.31 for new transparent command */
   0x32, 0x2E, 0x33, 0x31, 
   0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,  
   0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20, /* 20 bytes */
   0x20,0x20,0x20,0x20
};


static u8 usbsdms_conf_rsp_data[] __attribute__((__aligned__(4)))= {
0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x08, 
0x00, 0x00, 0x03, 0x0C, 0x00, 0x08, 0x01, 0x00, 
0x00, 0x09, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00 
};
#endif

get_configuration_feature_type usbsdms_avail_features[5] =
{
  /* profile list feature*/
  {
    PROFILE_LIST_FEATURE_CODE,
    0x03,
    0x04,
    {0x00, 0x80, 0x00, 0x00}    /* CD-ROM */
  },
  /* core feature */
  {
    CORE_FEATURE_CODE,
    0x03,
    0x04,
    {0x00, 0x00, 0x00, 0x08}      /* USB */
  },
  /* morphing feature */
  {
    MORPHING_FEATURE_CODE,
    0x03,
    0x04,
    {0x00, 0x00, 0x00, 0x00}
  },
  /* random readable feature */
  {
    RANDOM_READABLE_FEATURE_CODE,
    0x01,
    0x04,
    {0x00, 0x00, 0x08, 0x00}
  },
  /* cdread feature */
  {
    CDREAD_FEATURE_CODE,
    0x05,
    0x04,
    {0x00, 0x00, 0x00, 0x00}
  },
};

static u8 usbsdms_toc_rsp_data[] __attribute__ ((__aligned__(4))) = {
  0x00, 0x2E,   /* TOC Length */
  0x01,            /* First track No */
  0x01,            /* Last track No */
  0x01,
  0x14,
  0x00,
  0xA0,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 
  0x14, 0x00, 0xA1, 0x00, 0x00, 0x00, 0x00, 0x01, 
  0x00, 0x00, 0x01, 0x14, 0x00, 0xA2, 0x00, 0x00, 
  0x00, 0x00, 0x38, 0x2E, 0x46, 0x01, 0x14, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00
};

static u8 usbsdms_mm_mode_sense10_data[] __attribute__ ((__aligned__(4))) = {
  0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,     /* mode parameter header */
  0x2A,             /* page code MM Capabilities */
  0x18,             /* page length */
  0x01,             /* CD-R read only */            
  0x00,             /* Write protected */             
  0x70,             /* CD format */ 
  0x00,             /* not used */
  0x00,             /* not used */
  0x00,             /* not used */
  0x10, 0x8A,         /* Obsolete */
  0x01, 0x00,         /* number of volume level */
  0x08, 0x00,         /* buffer size */
  0x10, 0x8A,         /* Obsolete */
  0x00,                  /* reserved */
  0x00,                  /* reserved */
  0x10, 0x8A, 0x10, 0x8A,         /* Oboloete */
  0x00, 0x00,         /* reserved */
  0x00, 0x00          /* reserved */
};

#ifdef NOUSE 
static u8 usbsdms_request_sense_data[] __attribute__ ((__aligned__(4))) = {
  0x70, 0x00, 0x06,            
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x28, 0x00, 0x00, 0x00, 0x00, 0x00
};
#endif

u8 void_cdr_sectors[USBSDMS_ISO9660_PHY_BYTES_PER_SECTOR*11];

const u8 void_edc_ecc[] = {
    0xC5, 0x13, 0x68, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0x00, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x35, 0xB8, 0x7D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF5, 0x00, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x97, 0x26, 0xD0, 0x56, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x17, 
    0x2E, 0x1B, 0xB1, 0x48, 0xB2, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x00, 0xC2, 0x00, 0xE6, 0x00, 0x43, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x45, 0x3C, 0x53, 0x75, 0x33, 0x2B, 0x25, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0xC1, 0x00, 0x12,

    0x54, 0x76, 0xF8, 0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xF5, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x9A, 0x15, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xF5, 0xF4, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xEC, 0xED, 0x9C, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1C, 
    0xE0, 0x75, 0x19, 0xCB, 0xF5, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x65, 0xBC, 0xC2, 0xD9, 0xE6, 0x00, 0x43, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xF4, 0x52, 0xA1, 0xD1, 0x08, 0xCD, 0x5D, 0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90, 0x48, 0xC1, 0xD8, 0x12,

    0xE7, 0xD8, 0x48, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xF7, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x75, 0xD8, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xF5, 0xF5, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD3, 0xAD, 0x90, 0xDD,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9E, 0x3E, 
    0x43, 0xF9, 0x38, 0xAC, 0xE5, 0x6B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCA, 0x65, 0x65, 0xC2, 0xAF, 0xE6, 0x00, 0x43, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xD6, 0xDE, 0x7C, 0x1C, 0x9C, 0x04, 0x36, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x90, 0x90, 0xC1, 0xAD, 0x12,

    0x76, 0xBD, 0xD8, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0x02, 0xF5,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9A, 0xDA, 0x75, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xF5, 0x01, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x67, 0xAD, 0x17, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x35, 
    0x8D, 0x97, 0x90, 0x2F, 0xA2, 0x8D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x65, 0xD9, 0xC2, 0x76, 0xE6, 0x00, 0x43, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x67, 0xB0, 0x8E, 0xB8, 0xA7, 0xE2, 0x4E, 0xEA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAD, 0x90, 0xD8, 0xC1, 0x75, 0x12,

    0x82, 0x85, 0x2A, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xF3, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9B, 0x92, 0x7E, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xF5, 0xF7, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x17, 0x54, 0x1A,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x26, 
    0xF7, 0x85, 0xDC, 0x60, 0x03, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0x65, 0xCA, 0xC2, 0x43, 0xE6, 0x00, 0x43, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x02, 0x2B, 0x0B, 0x17, 0x13, 0xE8, 0x1A, 0xD4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7A, 0x90, 0x3D, 0xC1, 0x47, 0x12,

    0x13, 0xE0, 0xBA, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0x06, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x3D, 0xD3, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF5, 0x03, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xDD, 0x69, 0xD0, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2D, 
    0x39, 0xEB, 0x74, 0xE3, 0x44, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x65, 0x76, 0xC2, 0x9A, 0xE6, 0x00, 0x43, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xB3, 0x45, 0xF9, 0xB3, 0x28, 0x0E, 0x62, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEA, 0x90, 0x75, 0xC1, 0x9F, 0x12,

    0xA0, 0x4E, 0x0A, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0x04, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xD2, 0x1E, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xF5, 0x02, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x9C, 0x14, 0x91,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9B, 0x0F, 
    0x9A, 0x67, 0x55, 0x84, 0x54, 0xEC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x65, 0xAF, 0xC2, 0xEC, 0xE6, 0x00, 0x43, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x91, 0xC9, 0x24, 0x7E, 0xBC, 0xC7, 0x09, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x90, 0xAD, 0xC1, 0xEA, 0x12,

    0x31, 0x2B, 0x9A, 0xA3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xF1, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x7D, 0xB3, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF5, 0xF6, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x56, 0x29, 0x5B, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBA, 0x04, 
    0x54, 0x09, 0xFD, 0x07, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x65, 0x13, 0xC2, 0x35, 0xE6, 0x00, 0x43, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0xA7, 0xD6, 0xDA, 0x87, 0x21, 0x71, 0x5C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD7, 0x90, 0xE5, 0xC1, 0x32, 0x12,

    0x4B, 0x3F, 0xED, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFB, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDD, 0x41, 0x2A, 0xA9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xF5, 0xF3, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0x7E, 0xC7, 0xCE, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x75,
    0xC0, 0xD8, 0x15, 0x23, 0xCD, 0x8E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x65, 0x89, 0xC2, 0x86, 0xE6, 0x00, 0x43, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF5, 0x12, 0xA1, 0x4E, 0x0F, 0xAC, 0x5B, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF4, 0x90, 0x7A, 0xC1, 0x8E, 0x12,

    0xDA, 0x5A, 0x7D, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0x0E, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0xEE, 0x87, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF5, 0x07, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA9, 0xB4, 0xFA, 0x04, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x7E, 
    0x0E, 0xB6, 0xBD, 0xA0, 0x8A, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6A, 0x65, 0x35, 0xC2, 0x5F, 0xE6, 0x00, 0x43, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x44, 0x7C, 0x53, 0xEA, 0x34, 0x4A, 0x23, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x90, 0x32, 0xC1, 0x56, 0x12,

    0xD9, 0x4A, 0x62, 0xB2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xEB, 0xF5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xDE, 0xA6, 0xCB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xF5, 0xFB, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x94, 0xC4, 0x79,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB6, 0xEC,
    0x03, 0xBE, 0x20, 0x61, 0x95, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x65, 0x0F, 0xC2, 0x11, 0xE6, 0x00, 0x43, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xD4, 0x5E, 0x7C, 0x3F, 0x92, 0xC6, 0x3A, 0xA7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5, 0x90, 0xF4, 0xC1, 0x01, 0x12,
};

typedef struct {
  u8 sync[12];
  u8 a_min;
  u8 a_sec;
  u8 a_frac;
  u8 mode;
  u8 user_data[2048];
  u8 edr_ecc[288];
} usbsdms_cdr_data_type;

usbsdms_cdr_data_type void_cdr_data = {
  { 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0 },
  0x0,
  0x0,
  0x0,
  0x1,
  { 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
  }
};

void usbsdms_build_void_cdr_sectors(void)
{
  u16 bytes_offset = 0;
  u8 sector_id;

  for (sector_id = 0; sector_id < 11; sector_id++)
  {
    memcpy( (void*)(void_cdr_sectors + bytes_offset), (void*)void_cdr_data.sync, 12);
    bytes_offset += 12;
    void_cdr_sectors[bytes_offset++] = 0x0;
    void_cdr_sectors[bytes_offset++] = 0x2;
    if (sector_id == 10) 
      void_cdr_sectors[bytes_offset++] = 0x10;
    else
      void_cdr_sectors[bytes_offset++] = sector_id;
    void_cdr_sectors[bytes_offset++] = 0x1;
    memcpy((void*)(void_cdr_sectors + bytes_offset), (void*)void_cdr_data.user_data, 2048);
    bytes_offset += 2048;
    memcpy((void*)(void_cdr_sectors + bytes_offset), 
      (void*)(void_edc_ecc+(sector_id*288)), 288);
    bytes_offset += 288;
  }  
}	

#define ISO_FILENAME "/system/media/pantech_usb.iso" //p13120 directory change_110129

// tarial fixed this code
// this function is not use. because after eject command, file pointer remove only.
/*
void pantech_f_cdrom_eject_cdrom(void)
{
	int current_type;	

	current_type = current_usb_enum_type();

	printk(KERN_ERR "Tarial [%s] eject cdrom old type : 0x%x\n", __func__, current_type);

	current_type &= ~CDROM_TYPE_FLAG;
	if (!current_type) // cdrom only type case
		current_type = MSC_TYPE_FLAG | ACM_TYPE_FLAG | DIAG_TYPE_FLAG; // PC_MODE

	type_switch_cb(current_type);

	printk(KERN_ERR "Tarial [%s] eject cdrom new type : 0x%x\n", __func__, current_type);
}

// timeout :30secs //
void pantech_cancel_timeout_cdrom_mode(struct work_struct *w)
{	
	if(pantech_get_cdrom_enabled()){		
		pantech_f_cdrom_eject_cdrom();
		printk(KERN_ERR "Tarial [%s] Time out!!! cdrom mode off\n", __func__);
	}
	else {
		printk(KERN_ERR "Tarial [%s] already cdrom mode off\n", __func__);
	}		
}
*/

static int pantech_cdrom_do_mode_get_device_information(struct fsg_common *common, struct fsg_buffhd *bh)
{
	u8 mode = common->cmnd[1];
	u8 *buf = (u8 *) bh->buf;
	int ret;
	int size;
	
	if(common->data_size == 0)
	{
		DBG(common, "device_info:[%d]\n", common->data_size);
		return -EINVAL;
	}

	if(mode == CHECK_SWVERSION) // CHECK_SWVERSION = 0x01
	{
		/* return SW version */
		size = strlen(FIRM_VER);
		sprintf(&buf[0], "%s", FIRM_VER);
		if(common->data_size > size)
		{
			common->residue = common->usb_amount_left = size;
			return size;
		}
		else
		{
			common->residue = common->usb_amount_left = common->data_size;
			return common->data_size;
		}
		return size; //temp
	}else{

#ifdef CONFIG_ANDROID_PANTECH_USB_MANAGER
		ret = pst_rsp_current_mode();
#else
		ret = 0;
#endif
		put_unaligned_be32(ret, &buf[0]);	
		if(common->data_size > 4)
		{
			common->residue = common->usb_amount_left = 4;
			return 4;
		}
		else
		{
			common->residue = common->usb_amount_left = common->data_size;
			return common->data_size;
		}
		return 4;
	}

	return -EINVAL;

} 

int pantech_cdrom_do_cancel_cdrom_mode_timer(struct fsg_common *common, struct fsg_buffhd *bh)
{
/*
	struct fsg_lun	*curlun = common->curlun;

	if (!curlun) {
		return -EINVAL;
	} else if (!curlun->removable) {
		curlun->sense_data = SS_INVALID_COMMAND;
		return -EINVAL;
	}

	// Are we allowed to unload the media? 
	if (curlun->prevent_medium_removal) {
		LDBG(curlun, "unload attempt prevented\n");
		curlun->sense_data = SS_MEDIUM_REMOVAL_PREVENTED;
		return -EINVAL;
	}

	// Simulate an unload/eject 
	if (common->ops && common->ops->pre_eject) {
		int r = common->ops->pre_eject(common, curlun,
					       curlun - common->luns);
		if (unlikely(r < 0))
			return r;
		else if (r)
			return 0;
	}

	up_read(&common->filesem);
	down_write(&common->filesem);
	fsg_lun_close(curlun);
	up_write(&common->filesem);
	down_read(&common->filesem);

	return common->ops && common->ops->post_eject
		? min(0, common->ops->post_eject(common, curlun,
						 curlun - common->luns))
		: 0;
*/
	return 0;
}

static int pantech_cdrom_do_mode_change_volatility_code(struct fsg_common *common, struct fsg_buffhd *bh)
{	
	u8 mode = common->cmnd[1];
	struct fsg_lun *curlun = common->curlun;

	if(4 == mode){ // eject command (for old model sync : APACHE)
		if (!curlun) {
			return -EINVAL;
		} else if (!curlun->removable) {
			curlun->sense_data = SS_INVALID_COMMAND;
			return -EINVAL;
		}

		// Are we allowed to unload the media? 
		if (curlun->prevent_medium_removal) {
			LDBG(curlun, "unload attempt prevented\n");
			curlun->sense_data = SS_MEDIUM_REMOVAL_PREVENTED;
			return -EINVAL;
		}

		// Simulate an unload/eject 
		if (common->ops && common->ops->pre_eject) {
			int r = common->ops->pre_eject(common, curlun,
						       curlun - common->luns);
			if (unlikely(r < 0))
				return r;
			else if (r)
				return 0;
		}

		up_read(&common->filesem);
		down_write(&common->filesem);
		fsg_lun_close(curlun);
		up_write(&common->filesem);
		down_read(&common->filesem);

		return common->ops && common->ops->post_eject
			? min(0, common->ops->post_eject(common, curlun,
							 curlun - common->luns))
			: 0;

	}else{ // mode change command (for old model sync : APACHE)
		pst_req_mode_switch_cb(mode);	
	}

	return 0;
}

static int pantech_cdrom_do_read_toc(struct fsg_common *common, struct fsg_buffhd *bh)
{
	u8	*buf = (u8 *) bh->buf;

	if((common->data_size == 0) && sizeof(usbsdms_toc_rsp_data))
	{
		DBG(common, "toc:[%d]\n", common->data_size);
		return -EINVAL;
	}

	memcpy(buf, usbsdms_toc_rsp_data, sizeof(usbsdms_toc_rsp_data));
	if(common->data_size > sizeof(usbsdms_toc_rsp_data))
	{
		common->residue = common->usb_amount_left = sizeof(usbsdms_toc_rsp_data);
		return sizeof(usbsdms_toc_rsp_data);
	}
	else
	{
		common->residue = common->usb_amount_left = common->data_size;
		return common->data_size;
	}
	return -EINVAL;
}

static int pantech_cdrom_do_mode_sense10(struct fsg_common *common, struct fsg_buffhd *bh)
{
	u8	*buf = (u8 *) bh->buf;

	if((common->data_size == 0) && sizeof(usbsdms_mm_mode_sense10_data))
	{
		return -EINVAL;
	}
	memcpy(buf, usbsdms_mm_mode_sense10_data, sizeof(usbsdms_mm_mode_sense10_data));
	if(common->data_size > sizeof(usbsdms_mm_mode_sense10_data))
	{
		common->residue = common->usb_amount_left = sizeof(usbsdms_mm_mode_sense10_data);
		return sizeof(usbsdms_mm_mode_sense10_data);
	}
	else
	{
		common->residue = common->usb_amount_left = common->data_size;
		return common->data_size;
	}
	return -EINVAL;
}

static u16 usbsdms_get_dword( u8 data[] )
{
	u32 value;

	value = (u32)((data[0] << 24)) + 
	        (u32)((data[1] << 16)) + 
	        (u32)((data[2] << 8)) + 
					(u32)data[3];
	return value;
}
static u16 usbsdms_get_word( u8 data[] )
{
	u16 value;

	value = (u16)((data[0] << 8)) + (u16)data[1];
	return value;
}

static int pantech_cdrom_do_get_configuration_code(struct fsg_common *common, struct fsg_buffhd *bh)
{
	u8	*buf = (u8 *) bh->buf;

	u16 feature_no;
	u16 alloc_len;
	u32 temp;
	u8 rt;
	u16 reply_len;
	u8 *scsi_cmd_ptr;

	/* SCSI command is encapsulated in the command block wrapper */
	/* Note that word and dword values will require byte swapping */
	DBG(common,"get_configuration[%d]\n", common->data_size);

	scsi_cmd_ptr = (u8 *) &common->cmnd[0];		

	if (common->data_size == 0)
	{
		DBG(common, "conf_data_size error[%d]\n", common->data_size);
		return -EINVAL;
	}
	else
	{
		rt = ((usbsdms_get_configuration_scsi_cmd_type *)(scsi_cmd_ptr))->rt;
		feature_no = usbsdms_get_word(scsi_cmd_ptr +
																	FPOS(usbsdms_get_configuration_scsi_cmd_type, start_feature_no));
	}

	alloc_len = usbsdms_get_word(scsi_cmd_ptr +
																FPOS(usbsdms_get_configuration_scsi_cmd_type, alloc_length));

	if (alloc_len == 0)
	{
		DBG(common, "alloc_len[%d]\n", alloc_len);
		return -EINVAL;
	}        

	switch (rt)
	{
		case 0:       /* should return all features and descriptors supported */
		case 1:
			temp = sizeof(get_configuration_feature_type)*5 + sizeof(u32);
			usbsdms_cdr_conf_rsp.data_length = usbsdms_get_dword((u8 *) &temp);
			usbsdms_cdr_conf_rsp.reserved1 = 0x0000;
			if (rt == 0)
			{
				usbsdms_cdr_conf_rsp.current_profile = 0x0000;
			}
			else
			{
				usbsdms_cdr_conf_rsp.current_profile = 0x0800;       /* cd-rom */
				usbsdms_avail_features[0].desc_data[2] = 0x01;      /* current_p */
			}

			memcpy((void*)usbsdms_cdr_conf_rsp.feature_descriptors,
							(void*)usbsdms_avail_features, sizeof(get_configuration_feature_type)*5);

			if ((common->data_size ==0) && sizeof(usbsdms_cdr_conf_rsp))
			{
				DBG(common, "data_size is zero\n");
				return -EINVAL;
			}

			memcpy(buf, (u8 *) &usbsdms_cdr_conf_rsp, temp+sizeof(u32));
			if (common->data_size > (temp+sizeof(u32)))
			{
				reply_len = temp+sizeof(u32);
			}
			else
			{
				reply_len = common->data_size;
			}

			common->residue = common->usb_amount_left = reply_len;
			return reply_len;			
			break;

		case 2:     /* should return only feature specified  */
			temp = sizeof(get_configuration_feature_type) + sizeof(u32);
			usbsdms_cdr_conf_rsp.data_length = usbsdms_get_dword((u8 *) &temp);
			usbsdms_cdr_conf_rsp.reserved1 = 0x0000;
			usbsdms_cdr_conf_rsp.current_profile = 0x0800;      /* cd-rom */

			feature_no = usbsdms_get_word((u8 *) &feature_no);

			if ((feature_no != PROFILE_LIST_FEATURE_CODE) && (feature_no != CORE_FEATURE_CODE)
					&& (feature_no != MORPHING_FEATURE_CODE) && (feature_no != CDREAD_FEATURE_CODE)
					&&(feature_no != RANDOM_READABLE_FEATURE_CODE))
			{
				DBG(common, "--------------08 get configuration code: rt: 0x%X, alloc_len:0x%X, feature_no:0x%X\n",rt,alloc_len,feature_no);			  					            
				/* RT value 2: If the Logical Unit does not support the specified feature, only the Feature Header shall be returned. */
				if ((common->data_size ==0) && sizeof(get_configuration_feature_type))
				{
					DBG(common, "common->data_size is zero.1\n");
					return -EINVAL;
				}
				memcpy(buf, (u8 *) &usbsdms_cdr_conf_rsp, sizeof(get_configuration_feature_type) /* Feature Header size is 8 bytes */);
				if (common->data_size > sizeof(get_configuration_feature_type))
				{
					reply_len = sizeof(get_configuration_feature_type);
				}
				else
				{
					reply_len = common->data_size;
				}
				DBG(common, "get configuration code: rt: 0x%X, alloc_len:0x%X, reply_len:0x%X\n",rt,alloc_len,reply_len);			  		
				common->residue = common->usb_amount_left = reply_len;
				return reply_len;

			}
			else
			{
				switch (feature_no)
				{
					DBG(common, "--------------09 get configuration code: rt: 0x%X, alloc_len:0x%X, feature_no:0x%X\n",rt,alloc_len,feature_no);			  					
				case PROFILE_LIST_FEATURE_CODE:
					memcpy((void*)usbsdms_cdr_conf_rsp.feature_descriptors,
									(void*)usbsdms_avail_features, sizeof(get_configuration_feature_type));
					break;
				case CORE_FEATURE_CODE:
					memcpy((void*)usbsdms_cdr_conf_rsp.feature_descriptors,
									(void*)(usbsdms_avail_features+1), sizeof(get_configuration_feature_type));
					break;
				case MORPHING_FEATURE_CODE:
					memcpy((void*)usbsdms_cdr_conf_rsp.feature_descriptors,
									(void*)(usbsdms_avail_features+2), sizeof(get_configuration_feature_type));
					break;
				case RANDOM_READABLE_FEATURE_CODE:
					memcpy((void*)usbsdms_cdr_conf_rsp.feature_descriptors,
									(void*)(usbsdms_avail_features+3), sizeof(get_configuration_feature_type));
					break;
				case CDREAD_FEATURE_CODE:
					memcpy((void*)usbsdms_cdr_conf_rsp.feature_descriptors,
									(void*)(usbsdms_avail_features+4), sizeof(get_configuration_feature_type));
					break;
				}

				if ((common->data_size ==0) && sizeof(usbsdms_cdr_conf_rsp))
				{
					DBG(common, "common->data_size is zero.2\n");
					return -EINVAL;
				}
				memcpy(buf, (u8 *) &usbsdms_cdr_conf_rsp, sizeof(usbsdms_cdr_conf_rsp));
				if (common->data_size > (temp+sizeof(u32)))
				{
					reply_len = temp+sizeof(u32);
					DBG(common, "--------------10 get configuration code: rt: 0x%X, alloc_len:0x%X, reply_len:0x%X\n",rt,alloc_len,reply_len);			  		
				}
				else
				{
					reply_len = common->data_size;
					DBG(common, "--------------11 get configuration code: rt: 0x%X, alloc_len:0x%X, reply_len:0x%X\n",rt,alloc_len,reply_len);			  					
				}
				DBG(common, "3: get configuration code: rt: 0x%X, alloc_len:0x%X, reply_len:0x%X\n",rt,alloc_len,reply_len);			  		
				common->residue = common->usb_amount_left = reply_len;
				return reply_len;
			}
			break;
		default:
			break;			
	}

	return -EINVAL;
}
