/* Copyright (c) 2011, PANTECH. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */


#if 1
#define F_STREAM_ON_OFF
#define F_PANTECH_CAMERA_2M_REG_TEST

#ifdef F_STREAM_ON_OFF
static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_start_settings[] = {
    {0x03, 0x00}, /*Sleep Off*/
    {0x01, 0x30}, //{0x01, 0xf0},//{0x01, 0xf8},
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_stop_settings[] = {
    {0x03, 0x00}, /*Sleep on*/
    {0x01, 0x31}, //{0x01, 0xf1},//{0x01, 0xf9},
};
#endif

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_prev_settings[] = {
#ifndef F_STREAM_ON_OFF	
    {0x03, 0x00},           
    {0x01, 0x31},           
#endif
    {0x03, 0x20},           
    {0x18, 0x30},           
    {0x10, 0x0c},           
    {0x03, 0x22},           
    {0x10, 0x69},           
    {0x03, 0x00},           
    {0x10, 0x15},           
    //{0x11, 0x90},                    
    {0x12, 0x04},           
    {0x20, 0x00},           
    {0x21, 0x0c},           
    {0x22, 0x00},           
    {0x23, 0x14},           
    {0x03, 0x18},           
    {0x10, 0x00},           
    {0x03, 0x22},           
    {0x80, 0x40}, //38}, //R gain
    {0x81, 0x20}, //G gain
    {0x82, 0x35}, //B gain        
    {0x03, 0x48},           
    {0x70, 0x05},           
    {0x71, 0x30},           
    {0x72, 0x85},           
    {0x70, 0x85},           
    {0x03, 0x48},           
    {0x03, 0x48},           
    {0x03, 0x48},           
    {0x03, 0x48},           
    {0x70, 0x95},           
    {0x10, 0x1c},           
    {0x11, 0x00},           
    {0x12, 0x00},           
    {0x14, 0x30},           
    {0x16, 0x04},           
    {0x19, 0x00},           
    {0x1a, 0x32},           
    {0x1b, 0x17},           
    {0x1c, 0x0e},           
    {0x1d, 0x0f},           
    {0x1e, 0x08},           
    {0x1f, 0x06},           
    {0x20, 0x00}, //0x02},           
    {0x23, 0x01},           
    {0x24, 0x1e},           
    {0x25, 0x00},           
    {0x26, 0x00},           
    {0x27, 0x01},           
    {0x28, 0x00},           
    {0x2a, 0x06},           
    {0x2b, 0x40},           
    {0x2c, 0x04},           
    {0x2d, 0xb0},           
    {0x30, 0x40},           
    {0x31, 0x06},           
    {0x32, 0x06},           
    {0x33, 0x0a},           
    {0x34, 0x02},           
    {0x35, 0x01},           
    {0x36, 0x03},           
    {0x37, 0x07},           
    {0x38, 0x02},           
    {0x39, 0x02},           
    {0x50, 0x00},           
    {0x03, 0x20},           
    {0x10, 0xcc},           
    {0x03, 0x22},           
    {0x10, 0xf9},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},           
    {0x03, 0x00},
#ifndef F_STREAM_ON_OFF	
    {0x03, 0x00},           
    {0x01, 0x30},
#endif	
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_snap_settings[] = {
#if 1//[AE, AWB ON snapshot]
#ifndef F_STREAM_ON_OFF	
    {0x03, 0x00},                     
    {0x01, 0x31},        
#endif
    {0x03, 0x00},         
    {0x10, 0x04},        
    //{0x11, 0x90},         
    {0x12, 0x04},        
    {0x20, 0x00},         
    {0x21, 0x0c},         
    {0x22, 0x00},         
    {0x23, 0x14}, 
    {0x03, 0x12},         
    {0xD2, 0x67},
    {0xD5, 0x02},
    {0xD7, 0x18},                           
    {0x03, 0x18},         
    {0x10, 0x00},        
    {0x03, 0x48},  
    {0x70, 0x05},         
    {0x71, 0x30},         
    {0x72, 0x81},         
    {0x70, 0x85},                              
    {0x03, 0x48},         
    {0x03, 0x48},         
    {0x03, 0x48},         
    {0x03, 0x48},        
    {0x70, 0x95},         
    {0x10, 0x1c},         
    {0x11, 0x00},         
    {0x12, 0x00},         
    {0x14, 0x30},         
    {0x16, 0x04},         
    {0x19, 0x00},         
    {0x1a, 0x32},         
    {0x1b, 0x17},         
    {0x1c, 0x0a},         
    {0x1d, 0x0e},       
    {0x1e, 0x07},         
    {0x1f, 0x05},         
    {0x20, 0x00},         
    {0x23, 0x01},         
    {0x24, 0x1e},         
    {0x25, 0x00},         
    {0x26, 0x00},         
    {0x27, 0x01},         
    {0x28, 0x00},         
    {0x2a, 0x06},         
    {0x2b, 0x40},         
    {0x2c, 0x04},         
    {0x2d, 0xb0},       
    {0x30, 0x80},         
    {0x31, 0x0c},         
    {0x32, 0x0f},         
    {0x33, 0x0a},         
    {0x34, 0x03},     
    {0x35, 0x03},         
    {0x36, 0x01},         
    {0x37, 0x07},         
    {0x38, 0x02},         
    {0x39, 0x03},         
    {0x50, 0x00},        
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},         
    {0x03, 0x00},              
#ifndef F_STREAM_ON_OFF	
    {0x03, 0x00},         
    {0x01, 0x30},  
#endif
#endif
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_recommend_settings[] = {
#ifdef T_OSCAR
#if 1	//20120615_Primia_Oscar_HI255_INIT_Mipi_AMOLED
#ifndef F_STREAM_ON_OFF	
{0x03, 0x00},
{0x01, 0x31}, //sleep on
#endif
{0x01, 0x33}, //soft reset
{0x01, 0x31},
{0x08, 0x2f}, //20}, 
{0x0A, 0x00}, //3F}, 
{0x03, 0x20}, //page 20
{0x10, 0x0c}, //ae off
{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off
{0x03, 0x00},
{0x0b, 0xaa}, //ESD Check Register
{0x0c, 0xaa}, //ESD Check Register
{0x0d, 0xaa}, //ESD Check Register
{0x10, 0x15}, //11}, //Sub 1 + Preview 1 mode
{0x11, 0x90}, //B[2] Fixed Frame XY flip (90:Default)
{0x12, 0x04},
{0x20, 0x00},
{0x21, 0x0c}, 
{0x22, 0x00},
{0x23, 0x14},
{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},
{0x28, 0x0c},
{0x29, 0x04},
{0x2A, 0x02},
{0x2B, 0x04},
{0x2C, 0x06},
{0x2D, 0x02},
{0x40, 0x01}, //Hblank 360
{0x41, 0x68}, 
{0x42, 0x00}, //Vblank 20
{0x43, 0x14}, 
{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},
{0x80, 0x2e}, //BLC
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x14}, //BLC_TIME_TH_ON
{0x91, 0x14}, //BLC_TIME_TH_OFF 
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},
{0x99, 0x43}, //OutDoor  BLC
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
{0xa0, 0x01}, //Dark BLC
{0xa2, 0x02},
{0xa4, 0x02},
{0xa6, 0x02},
{0xa8, 0x43}, //Normal BLC
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},
{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00}, //Power Saving
{0x2f, 0x00}, //Power Saving
{0x30, 0x05}, //For Hi-253 never no change 0x05
{0x50, 0x20},
{0x52, 0x01},
{0x53, 0xc1}, //Don't Touch Register
{0x54, 0xc0}, //Don't Touch Register
{0x55, 0x1c},
{0x56, 0x11},
{0x58, 0x22}, //Don't Touch Register 0404
{0x59, 0x20}, //Don't Touch Register 0404
{0x5d, 0xa2},
{0x5e, 0x5a},
{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},
{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},
{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},
{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},
{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},
{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},
{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},
{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa}, 
{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},
{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x14}, //DCDC_TIME_TH_ON
{0xd5, 0x14}, //DCDC_TIME_TH_OFF 
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},
{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},
{0x03, 0x03},
{0x10, 0x10},
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x00},
{0x40, 0x00},
{0x41, 0x10}, //14}, //Dy offset
{0x48, 0x80}, //Contrast Off (88:On)
{0x50, 0xd0}, //SKT 3 ߰
{0x60, 0x67},
{0x61, 0x70}, //80}, //60}, //70}, //Sat B 
{0x62, 0x80}, //5a}, //6b}, //Sat R
{0x63, 0xd0}, //Double_AG 50->d0
{0x64, 0x80}, //40->80 
{0x66, 0x42},
{0x67, 0x20},
{0x6a, 0x80}, //7a}, //8a}, 
{0x6b, 0x80}, //7b}, //74}, 
{0x6c, 0x80}, //91}, //7e}, 
{0x6d, 0x80}, //8a}, //8e}, 
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, //Blue Max-Filter Delete
{0x13, 0xbb},
{0x26, 0x31}, //Double_AG 31->20
{0x27, 0x34}, //Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},
{0x30, 0x70}, //Out2 D-LPF th
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},            
{0x36, 0x70},  //Out1 D-LPF th
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x09},
{0x3a, 0x06},
{0x3b, 0x03},
{0x3c, 0x80}, //Indoor D-LPF th
{0x3d, 0x18},
{0x3e, 0x40},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},
{0x42, 0x80}, //Dark1 D-LPF th
{0x43, 0x18},
{0x44, 0x40},
{0x45, 0x13},
{0x46, 0x10},
{0x47, 0x10},
{0x48, 0x90}, //Dark2 D-LPF th
{0x49, 0x40},
{0x4a, 0x58},
{0x4b, 0x13},
{0x4c, 0x10},
{0x4d, 0x11},
{0x4e, 0x80}, //Dark3 D-LPF th
{0x4f, 0x30},
{0x50, 0x80},
{0x51, 0x13},
{0x52, 0x10},
{0x53, 0x13},
{0x54, 0x11},
{0x55, 0x0D},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},
{0x5a, 0x1f},
{0x5b, 0x3F},
{0x5c, 0x00},
{0x60, 0x3f},
{0x62, 0x10},
{0x70, 0x06},
{0x03, 0x12},
{0x20, 0x0f},
{0x21, 0x0f},
{0x25, 0x30},
{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},
{0x30, 0x30},
{0x31, 0x38},
{0x32, 0x42},
{0x33, 0x60},
{0x34, 0x70},
{0x35, 0x80},
{0x36, 0xa0},
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xa0},
{0x49, 0x90},
{0x4a, 0x90},
{0x4b, 0x80},
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0xB0},
{0x4f, 0x90},
{0x50, 0xC0},
{0x51, 0x80},
{0x52, 0xb0},
{0x53, 0x60},
{0x54, 0xc0},
{0x55, 0xc0},
{0x56, 0xc0},
{0x57, 0x70},
{0x58, 0x90},
{0x59, 0x40},
{0x5a, 0xd0},
{0x5b, 0xd0},
{0x5c, 0xd0},
{0x5d, 0x70},
{0x5e, 0x88},
{0x5f, 0x40},
{0x60, 0xe0},
{0x61, 0xe0},
{0x62, 0xe0},
{0x63, 0x80},
{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register
{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register
{0x74, 0x25},
{0x75, 0x15},
{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x5d}, //For Preview
{0xD0, 0x0c}, //Don't Touch register
{0xD1, 0x80},
{0xD2, 0x17}, //67}, 0404
{0xD3, 0x00},
{0xD4, 0x00},
{0xD5, 0x0f}, //02}, 0404
{0xD6, 0xff},
{0xD7, 0xff}, //18},
{0x3b, 0x06},
{0x3c, 0x06},
{0xc5, 0x30}, //55->48
{0xc6, 0x2a}, //48->40     
{0x03, 0x13},
{0x10, 0xab},
{0x11, 0x7b},
{0x12, 0x02}, //06},
{0x14, 0x00},
{0x20, 0x08}, //15}, 
{0x21, 0x05}, //13}, 
{0x22, 0x33},
{0x23, 0x04},
{0x24, 0x09},
{0x25, 0x08}, 
{0x26, 0x20},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},
{0x2b, 0x06}, //Low clip th
{0x2c, 0x07},
{0x25, 0x08},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},
{0x50, 0x10}, //Out2 Edge
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0f},
{0x56, 0x10}, //Out1 Edge
{0x57, 0x13},
{0x58, 0x12},
{0x59, 0x0c},
{0x5a, 0x0f},
{0x5b, 0x0f},
{0x5c, 0x0a}, //Indoor Edge
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},
{0x62, 0x08}, //Dark1 Edge
{0x63, 0x09},
{0x64, 0x08},
{0x65, 0x06},
{0x66, 0x07},
{0x67, 0x06},
{0x68, 0x07}, //Dark2 Edge
{0x69, 0x08},
{0x6a, 0x07},
{0x6b, 0x06},
{0x6c, 0x07},
{0x6d, 0x06},
{0x6e, 0x07}, //Dark3 Edge
{0x6f, 0x08},
{0x70, 0x07},
{0x71, 0x06},
{0x72, 0x07},
{0x73, 0x06},
{0x80, 0xFD}, //2DY
{0x81, 0x1f},
{0x82, 0x01},
{0x83, 0x31},
{0x90, 0x3f}, 
{0x91, 0x3f}, 
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x05},
{0x95, 0x0a}, //18},
{0x97, 0x30},
{0x99, 0x35},
{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x02},
{0xa5, 0x04},
{0xa6, 0x04},
{0xa7, 0x06},
{0xa8, 0x05},
{0xa9, 0x08},
{0xaa, 0x05},
{0xab, 0x08},      
{0xb0, 0x22}, //Out2
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},
{0xb6, 0x22}, //Out1 
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},
{0xbc, 0x1e}, //27},    //Indoor       
{0xbd, 0x24}, //30},          
{0xbe, 0x20}, //2a},          
{0xbf, 0x1e}, //27},          
{0xc0, 0x24}, //30},          
{0xc1, 0x20}, //2a},
{0xc2, 0x1e}, //Dark1
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},
{0xc8, 0x18}, //Dark2
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},
{0xce, 0x18}, //Dark3 
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
{0x03, 0x14},
{0x10, 0x11},
{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY
{0x20, 0x80}, //X
{0x21, 0x80}, //Y
{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},
{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},
{0x40, 0x7a}, 
{0x50, 0x5e}, 
{0x60, 0x54}, 
{0x70, 0x5e}, 
{0x03, 0x15},
{0x10, 0x0f},
{0x14, 0x46}, 
{0x15, 0x36}, 
{0x16, 0x26}, 
{0x17, 0x3f}, 
{0x30, 0x93}, 
{0x31, 0x42}, 
{0x32, 0x11}, 
{0x33, 0x0d}, 
{0x34, 0x65}, 
{0x35, 0x18}, 
{0x36, 0x0a}, 
{0x37, 0x36}, 
{0x38, 0x80}, 
{0x40, 0xa0}, 
{0x41, 0x20},
{0x42, 0x00}, 
{0x43, 0x82}, 
{0x44, 0x87}, 
{0x45, 0x09}, 
{0x46, 0x81}, 
{0x47, 0x9d}, 
{0x48, 0x1e}, 
{0x50, 0x95}, 
{0x51, 0x07}, 
{0x52, 0x0e}, 
{0x53, 0x05}, 
{0x54, 0x8b}, 
{0x55, 0x06}, 
{0x56, 0x09}, 
{0x57, 0x07}, 
{0x58, 0x90}, 
{0x80, 0x03}, 
{0x85, 0x40}, 
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e}, // Double_AG 5e->37
{0x19, 0x5d}, // Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},        
{0x30, 0x00}, //Gamma indoor
{0x31, 0x08}, //05},
{0x32, 0x13}, //10},
{0x33, 0x2c}, //2a},
{0x34, 0x5b},
{0x35, 0x7e},
{0x36, 0x97},
{0x37, 0xa9},
{0x38, 0xba},
{0x39, 0xc8},
{0x3a, 0xd3},
{0x3b, 0xdc},
{0x3c, 0xe3},
{0x3d, 0xe9},
{0x3e, 0xee},
{0x3f, 0xf2},
{0x40, 0xf6},
{0x41, 0xfb},
{0x42, 0xff},
{0x50, 0x00}, //outdoor
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x64},
{0x55, 0x83},
{0x56, 0x97},
{0x57, 0xa6},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc8},
{0x5b, 0xd1},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},
{0x70, 0x05}, //Dark
{0x71, 0x17},
{0x72, 0x27},
{0x73, 0x41},
{0x74, 0x6c},
{0x75, 0x87},
{0x76, 0x9d},
{0x77, 0xb0},
{0x78, 0xc0},
{0x79, 0xcb},
{0x7a, 0xd3},
{0x7b, 0xdc},
{0x7c, 0xe3},
{0x7d, 0xe9},
{0x7e, 0xee},
{0x7f, 0xf2},
{0x80, 0xf6},
{0x81, 0xfb},
{0x82, 0xff},
{0x03, 0x17},
{0x10, 0xf7},
{0xC4, 0x3c}, //FLK200 
{0xC5, 0x32}, //FLK240 
{0x03, 0x18},
{0x10, 0x00}, //Scaling Off
{0x03, 0x20},
{0x11, 0x0c},//1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x01}, //05}, //AE Weight ON   
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},
{0x28, 0xef}, //DG enable
{0x29, 0x0d}, //ad->0d
{0x2a, 0xFF}, //FF->03, Fixed Frame set : 0x03
{0x2b, 0x34}, //34->35 Fixed Frame set : 0x35
{0x2c, 0xc3}, //c2},
{0x2d, 0xff},
{0x2e, 0x33}, //13}, //33}, adp off
{0x30, 0xf8}, //78}, //f8->78
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x26}, //22},
{0x3a, 0xde},
{0x3b, 0x26}, //22},
{0x3c, 0xde},
{0x41, 0xa0}, //Fast AE
{0x43, 0x08},
{0x44, 0x1a},
{0x45, 0x40},
{0x46, 0xf0},
{0x47, 0xff},
{0x4d, 0x04},
{0x50, 0x45},
{0x51, 0x88},
{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},
{0x60, 0x00},
{0x61, 0x00},
{0x62, 0x00}, 
{0x63, 0x00}, 
{0x64, 0x16}, //05}, 
{0x65, 0x94}, //50}, 
{0x66, 0x1a}, //06}, 
{0x67, 0xa4}, //90}, 
{0x68, 0x1a}, //06}, 
{0x69, 0xa4}, //90}, 
{0x6a, 0x16}, //05}, 
{0x6b, 0x94}, //50}, 
{0x6c, 0x00}, 
{0x6d, 0x00}, 
{0x6e, 0x00},
{0x6f, 0x00},
{0x70, 0x3d}, //3d}, //40}, //74}, Y Target
{0x71, 0x82}, //82(+8)
{0x76, 0x43},
{0x77, 0x02}, //04}, 
{0x78, 0x22}, //23}, //24
{0x79, 0x29}, //44}, //48}, //46}    
{0x7a, 0x23}, 
{0x7b, 0x22}, 
{0x7d, 0x23}, 
{0x83, 0x03}, //EXP Normal 15.00 fps 
{0x84, 0x0d}, 
{0x85, 0x40},  
{0x86, 0x01}, //EXPMin 6000.00 fps
{0x87, 0xf4}, 
{0x88, 0x09}, //EXP Max 5.00 fps 
{0x89, 0x27}, 
{0x8a, 0xc0}, 
{0x8B, 0x75}, //EXP100 
{0x8C, 0x30}, 
{0x8D, 0x61}, //EXP120 
{0x8E, 0xa8}, 
{0x9c, 0x0d}, //EXP Limit 857.14 fps 
{0x9d, 0xac}, 
{0x9e, 0x01}, //EXP Unit 
{0x9f, 0xf4},  
{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xe0}, 
{0xb3, 0x18},
{0xb4, 0x14}, //1a},
{0xb5, 0x38}, //44},
{0xb6, 0x26}, //2f},
{0xb7, 0x20}, //28},
{0xb8, 0x1d}, //25},
{0xb9, 0x1b}, //22},
{0xba, 0x1a}, //21},
{0xbb, 0x19}, //20},
{0xbc, 0x27}, //19}, //32},
{0xbd, 0x26}, //2b}, //18}, 
{0xc0, 0x10}, //14}, 
{0xc1, 0x21}, //14}, //2b},
{0xc2, 0x21}, //14}, //2b},
{0xc3, 0x21}, //14}, //2b},
{0xc4, 0x08}, //10}, //08},
{0xc8, 0x60}, //70}, //40->80 DG MAX 
{0xc9, 0x40},
{0x03, 0x22},
{0x10, 0xfd}, //AWB mode
{0x11, 0x2e},
{0x19, 0x01}, //Low On
{0x20, 0x10},
{0x21, 0x84}, //80},
{0x24, 0x01},
{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x22}, 
{0x39, 0x34},
{0x40, 0xd2}, //81}, //f1}, //fa}, //Y limit      
{0x41, 0x44}, //CDIFF
{0x42, 0x22}, //33}, //CSUM
{0x43, 0xd2}, //81}, //f6},
{0x44, 0x44},
{0x45, 0x22}, //33},
{0x46, 0x00},   
{0x50, 0xb2}, //skin_color_th1
{0x51, 0x81}, //skin_color_th2
{0x52, 0x98}, //skin_color_th3
{0x80, 0x40}, //38}, //R gain
{0x81, 0x20}, //G gain
{0x82, 0x35}, //B gain             
{0x83, 0x5e}, //50}, // Indoor
{0x84, 0x24}, //20}, 
{0x85, 0x50}, //59}, //53}, 
{0x86, 0x24}, //20},              
{0x87, 0x49}, //outdoor 1  
{0x88, 0x39},
{0x89, 0x37}, 
{0x8a, 0x29},             
{0x8b, 0x41}, //outdoor 2
{0x8c, 0x39}, 
{0x8d, 0x34}, 
{0x8e, 0x29}, 
{0x8f, 0x57}, //4F}, //Slope
{0x90, 0x55}, //4F}, 
{0x91, 0x52}, //4E}, 
{0x92, 0x4d}, //4B}, 
{0x93, 0x48}, //45}, 
{0x94, 0x3f}, //3b}, 
{0x95, 0x34}, 
{0x96, 0x2e}, 
{0x97, 0x26}, 
{0x98, 0x22}, 
{0x99, 0x21}, 
{0x9a, 0x21}, 
{0x9b, 0x66}, 
{0x9c, 0x66}, 
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},
{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},
{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, //700fps
{0xa6, 0xcf},
{0xad, 0x40},
{0xae, 0x4a},
{0xaf, 0x28}, //low temp Rgain
{0xb0, 0x26}, //low temp Rgain
{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xa0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
{0x03, 0x48},
{0x70, 0x05}, // PLL Setting //
{0x71, 0x30}, //18->30 Pllx1->Pllx2
{0x72, 0x85}, 
{0x70, 0x85}, // PLL Enable
{0x03, 0x48},
{0x03, 0x48},
{0x03, 0x48},
{0x03, 0x48},
{0x70, 0x95}, //CLK_GEN_ENABLE
{0x10, 0x1c}, // MIPI TX Setting
{0x11, 0x00}, //0x00 : not contious, 0x10 : continous
{0x12, 0x00},
{0x14, 0x30}, //0x10},
{0x16, 0x04},
{0x19, 0x00},
{0x1a, 0x32}, //0x22},
{0x1b, 0x17}, //0x0d},
{0x1c, 0x0e}, // hs_rqst_tlpx [ 5: 0]
{0x1d, 0x0f}, // hs_rqst_tlpx[5:0]
{0x1e, 0x08}, // 0x14}, HS GO Ths-zero  decimal 1 ~20 
{0x1f, 0x04}, // Ths_trail_time decimal 1 ~20
{0x20, 0x00}, // Ths_exit , lp ths exit time  [ 0 - 8 ]
{0x23, 0x01},
{0x24, 0x1e},
{0x25, 0x00},
{0x26, 0x00},
{0x27, 0x01},
{0x28, 0x00},
{0x2a, 0x06},
{0x2b, 0x40},
{0x2c, 0x04},
{0x2d, 0xb0},
{0x30, 0x40},
{0x31, 0x06},
{0x32, 0x06}, 
{0x33, 0x0a}, // Tclk_post , tclk post time [ 3:0]
{0x34, 0x02}, //01}, // HS_PRPR-Tclk prepare [ 2: 0]
{0x35, 0x01},
{0x36, 0x03}, //01},
{0x37, 0x07},
{0x38, 0x02},
{0x39, 0x02},
{0x50, 0x00},
{0x03, 0x20},
{0x10, 0xcc}, // AUTO
{0x03, 0x22},
{0x10, 0xf9},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
#ifndef F_STREAM_ON_OFF	
{0x03, 0x00},
{0x01, 0x30},
#endif

#else // 1

//20120405_Primia_Oscar_HI255_INIT_Mipi_AMOLED
#ifndef F_STREAM_ON_OFF	
{0x01, 0x31}, //sleep on
#endif
{0x01, 0x33}, //soft reset
{0x01, 0x31},
{0x08, 0x2f}, //20}, 
{0x0A, 0x00}, //3F}, 
{0x03, 0x20}, //page 20
{0x10, 0x0c}, //ae off
{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off
{0x03, 0x00},
{0x0b, 0xaa}, //ESD Check Register
{0x0c, 0xaa}, //ESD Check Register
{0x0d, 0xaa}, //ESD Check Register
{0x10, 0x15}, //11}, //Sub 1 + Preview 1 mode
{0x11, 0x80}, //B[2] Fixed Frame XY flip (90:Default)
{0x12, 0x04},
{0x20, 0x00},
{0x21, 0x0c}, 
{0x22, 0x00},
{0x23, 0x14},
{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},
{0x28, 0x0c},
{0x29, 0x04},
{0x2A, 0x02},
{0x2B, 0x04},
{0x2C, 0x06},
{0x2D, 0x02},
{0x40, 0x01}, //Hblank 360
{0x41, 0x68}, 
{0x42, 0x00}, //Vblank 20
{0x43, 0x14}, 
{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},
{0x80, 0x2e}, //BLC
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x14}, //BLC_TIME_TH_ON
{0x91, 0x14}, //BLC_TIME_TH_OFF 
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},
{0x99, 0x43}, //OutDoor  BLC
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
{0xa0, 0x01}, //Dark BLC
{0xa2, 0x02},
{0xa4, 0x02},
{0xa6, 0x02},
{0xa8, 0x43}, //Normal BLC
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},
{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00}, //Power Saving
{0x2f, 0x00}, //Power Saving
{0x30, 0x05}, //For Hi-253 never no change 0x05
{0x50, 0x20},
{0x52, 0x01},
{0x53, 0xc1}, //Don't Touch Register
{0x54, 0xc0}, //Don't Touch Register
{0x55, 0x1c},
{0x56, 0x11},
{0x58, 0x22}, //Don't Touch Register 0404
{0x59, 0x20}, //Don't Touch Register 0404
{0x5d, 0xa2},
{0x5e, 0x5a},
{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},
{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},
{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},
{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},
{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},
{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},
{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},
{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa}, 
{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},
{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x14}, //DCDC_TIME_TH_ON
{0xd5, 0x14}, //DCDC_TIME_TH_OFF 
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},
{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},
{0x03, 0x03},
{0x10, 0x10},
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x00},
{0x40, 0x00},
{0x41, 0x10}, //14}, //Dy offset
{0x48, 0x80}, //Contrast Off (88:On)
{0x50, 0xd0}, //SKT 3차 추가
{0x60, 0x67},
{0x61, 0x70}, //80}, //60}, //70}, //Sat B 
{0x62, 0x80}, //5a}, //6b}, //Sat R
{0x63, 0xd0}, //Double_AG 50->d0
{0x64, 0x80}, //40->80 
{0x66, 0x42},
{0x67, 0x20},
{0x6a, 0x80}, //7a}, //8a}, 
{0x6b, 0x80}, //7b}, //74}, 
{0x6c, 0x80}, //91}, //7e}, 
{0x6d, 0x80}, //8a}, //8e}, 
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, //Blue Max-Filter Delete
{0x13, 0xbb},
{0x26, 0x31}, //Double_AG 31->20
{0x27, 0x34}, //Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},
{0x30, 0x70}, //Out2 D-LPF th
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},            
{0x36, 0x70},  //Out1 D-LPF th
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x09},
{0x3a, 0x06},
{0x3b, 0x03},
{0x3c, 0x80}, //Indoor D-LPF th
{0x3d, 0x18},
{0x3e, 0x40},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},
{0x42, 0x80}, //Dark1 D-LPF th
{0x43, 0x18},
{0x44, 0x40},
{0x45, 0x13},
{0x46, 0x10},
{0x47, 0x10},
{0x48, 0x90}, //Dark2 D-LPF th
{0x49, 0x40},
{0x4a, 0x58},
{0x4b, 0x13},
{0x4c, 0x10},
{0x4d, 0x11},
{0x4e, 0x80}, //Dark3 D-LPF th
{0x4f, 0x30},
{0x50, 0x80},
{0x51, 0x13},
{0x52, 0x10},
{0x53, 0x13},
{0x54, 0x11},
{0x55, 0x0D},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},
{0x5a, 0x1f},
{0x5b, 0x3F},
{0x5c, 0x00},
{0x60, 0x3f},
{0x62, 0x10},
{0x70, 0x06},
{0x03, 0x12},
{0x20, 0x0f},
{0x21, 0x0f},
{0x25, 0x30},
{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},
{0x30, 0x30},
{0x31, 0x38},
{0x32, 0x42},
{0x33, 0x60},
{0x34, 0x70},
{0x35, 0x80},
{0x36, 0xa0},
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xa0},
{0x49, 0x90},
{0x4a, 0x90},
{0x4b, 0x80},
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0xB0},
{0x4f, 0x90},
{0x50, 0xC0},
{0x51, 0x80},
{0x52, 0xb0},
{0x53, 0x60},
{0x54, 0xc0},
{0x55, 0xc0},
{0x56, 0xc0},
{0x57, 0x70},
{0x58, 0x90},
{0x59, 0x40},
{0x5a, 0xd0},
{0x5b, 0xd0},
{0x5c, 0xd0},
{0x5d, 0x70},
{0x5e, 0x88},
{0x5f, 0x40},
{0x60, 0xe0},
{0x61, 0xe0},
{0x62, 0xe0},
{0x63, 0x80},
{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register
{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register
{0x74, 0x25},
{0x75, 0x15},
{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x5d}, //For Preview
{0xD0, 0x0c}, //Don't Touch register
{0xD1, 0x80},
{0xD2, 0x17}, //67}, 0404
{0xD3, 0x00},
{0xD4, 0x00},
{0xD5, 0x0f}, //02}, 0404
{0xD6, 0xff},
{0xD7, 0xff}, //18},
{0x3b, 0x06},
{0x3c, 0x06},
{0xc5, 0x30}, //55->48
{0xc6, 0x2a}, //48->40     
{0x03, 0x13},
{0x10, 0xab},
{0x11, 0x7b},
{0x12, 0x02}, //06},
{0x14, 0x00},
{0x20, 0x08}, //15}, 
{0x21, 0x05}, //13}, 
{0x22, 0x33},
{0x23, 0x04},
{0x24, 0x09},
{0x25, 0x08}, 
{0x26, 0x20},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},
{0x2b, 0x06}, //Low clip th
{0x2c, 0x07},
{0x25, 0x08},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},
{0x50, 0x10}, //Out2 Edge
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0f},
{0x56, 0x10}, //Out1 Edge
{0x57, 0x13},
{0x58, 0x12},
{0x59, 0x0c},
{0x5a, 0x0f},
{0x5b, 0x0f},
{0x5c, 0x0a}, //Indoor Edge
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},
{0x62, 0x08}, //Dark1 Edge
{0x63, 0x09},
{0x64, 0x08},
{0x65, 0x06},
{0x66, 0x07},
{0x67, 0x06},
{0x68, 0x07}, //Dark2 Edge
{0x69, 0x08},
{0x6a, 0x07},
{0x6b, 0x06},
{0x6c, 0x07},
{0x6d, 0x06},
{0x6e, 0x07}, //Dark3 Edge
{0x6f, 0x08},
{0x70, 0x07},
{0x71, 0x06},
{0x72, 0x07},
{0x73, 0x06},
{0x80, 0xFD}, //2DY
{0x81, 0x1f},
{0x82, 0x01},
{0x83, 0x31},
{0x90, 0x3f}, 
{0x91, 0x3f}, 
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x05},
{0x95, 0x0a}, //18},
{0x97, 0x30},
{0x99, 0x35},
{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x02},
{0xa5, 0x04},
{0xa6, 0x04},
{0xa7, 0x06},
{0xa8, 0x05},
{0xa9, 0x08},
{0xaa, 0x05},
{0xab, 0x08},      
{0xb0, 0x22}, //Out2
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},
{0xb6, 0x22}, //Out1 
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},
{0xbc, 0x1e}, //27},    //Indoor       
{0xbd, 0x24}, //30},          
{0xbe, 0x20}, //2a},          
{0xbf, 0x1e}, //27},          
{0xc0, 0x24}, //30},          
{0xc1, 0x20}, //2a},
{0xc2, 0x1e}, //Dark1
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},
{0xc8, 0x18}, //Dark2
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},
{0xce, 0x18}, //Dark3 
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
{0x03, 0x14},
{0x10, 0x11},
{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY
{0x20, 0x80}, //X
{0x21, 0x80}, //Y
{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},
{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},
{0x40, 0x7a}, 
{0x50, 0x5e}, 
{0x60, 0x54}, 
{0x70, 0x5e}, 
{0x03, 0x15},
{0x10, 0x0f},
{0x14, 0x46}, 
{0x15, 0x36}, 
{0x16, 0x26}, 
{0x17, 0x3f}, 
{0x30, 0x93}, 
{0x31, 0x42}, 
{0x32, 0x11}, 
{0x33, 0x0d}, 
{0x34, 0x65}, 
{0x35, 0x18}, 
{0x36, 0x0a}, 
{0x37, 0x36}, 
{0x38, 0x80}, 
{0x40, 0xa0}, 
{0x41, 0x20},
{0x42, 0x00}, 
{0x43, 0x82}, 
{0x44, 0x87}, 
{0x45, 0x09}, 
{0x46, 0x81}, 
{0x47, 0x9d}, 
{0x48, 0x1e}, 
{0x50, 0x95}, 
{0x51, 0x07}, 
{0x52, 0x0e}, 
{0x53, 0x05}, 
{0x54, 0x8b}, 
{0x55, 0x06}, 
{0x56, 0x09}, 
{0x57, 0x07}, 
{0x58, 0x90}, 
{0x80, 0x03}, 
{0x85, 0x40}, 
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e}, // Double_AG 5e->37
{0x19, 0x5d}, // Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},        
{0x30, 0x00}, //Gamma indoor
{0x31, 0x05},
{0x32, 0x10},
{0x33, 0x2a},
{0x34, 0x5b},
{0x35, 0x7e},
{0x36, 0x97},
{0x37, 0xa9},
{0x38, 0xba},
{0x39, 0xc8},
{0x3a, 0xd3},
{0x3b, 0xdc},
{0x3c, 0xe3},
{0x3d, 0xe9},
{0x3e, 0xee},
{0x3f, 0xf2},
{0x40, 0xf6},
{0x41, 0xfb},
{0x42, 0xff},
{0x50, 0x00}, //outdoor
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x64},
{0x55, 0x83},
{0x56, 0x97},
{0x57, 0xa6},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc8},
{0x5b, 0xd1},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},
{0x70, 0x05}, //Dark
{0x71, 0x17},
{0x72, 0x27},
{0x73, 0x41},
{0x74, 0x6c},
{0x75, 0x87},
{0x76, 0x9d},
{0x77, 0xb0},
{0x78, 0xc0},
{0x79, 0xcb},
{0x7a, 0xd3},
{0x7b, 0xdc},
{0x7c, 0xe3},
{0x7d, 0xe9},
{0x7e, 0xee},
{0x7f, 0xf2},
{0x80, 0xf6},
{0x81, 0xfb},
{0x82, 0xff},
{0x03, 0x17},
{0x10, 0xf7},
{0xC4, 0x3c}, //FLK200 
{0xC5, 0x32}, //FLK240 
{0x03, 0x18},
{0x10, 0x00}, //Scaling Off
{0x03, 0x20},
{0x11, 0x0c},//1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x01}, //05}, //AE Weight ON   
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},
{0x28, 0xef}, //DG enable
{0x29, 0x0d}, //ad->0d
{0x2a, 0xFF}, //FF->03, Fixed Frame set : 0x03
{0x2b, 0x34}, //34->35 Fixed Frame set : 0x35
{0x2c, 0xc3}, //c2},
{0x2d, 0xff},
{0x2e, 0x33}, //13}, //33}, adp off
{0x30, 0xf8}, //78}, //f8->78
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x26}, //22},
{0x3a, 0xde},
{0x3b, 0x26}, //22},
{0x3c, 0xde},
{0x41, 0xa0}, //Fast AE
{0x43, 0x08},
{0x44, 0x1a},
{0x45, 0x40},
{0x46, 0xf0},
{0x47, 0xff},
{0x4d, 0x04},
{0x50, 0x45},
{0x51, 0x88},
{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},
{0x60, 0x00},
{0x61, 0x00},
{0x62, 0x00}, 
{0x63, 0x00}, 
{0x64, 0x16}, //05}, 
{0x65, 0x94}, //50}, 
{0x66, 0x1a}, //06}, 
{0x67, 0xa4}, //90}, 
{0x68, 0x1a}, //06}, 
{0x69, 0xa4}, //90}, 
{0x6a, 0x16}, //05}, 
{0x6b, 0x94}, //50}, 
{0x6c, 0x00}, 
{0x6d, 0x00}, 
{0x6e, 0x00},
{0x6f, 0x00},
{0x70, 0x3d}, //3d}, //40}, //74}, Y Target
{0x71, 0x82}, //82(+8)
{0x76, 0x43},
{0x77, 0x02}, //04}, 
{0x78, 0x22}, //23}, //24
{0x79, 0x29}, //44}, //48}, //46}    
{0x7a, 0x23}, 
{0x7b, 0x22}, 
{0x7d, 0x23}, 
#ifdef T_OSCAR
{0x83, 0x04}, //EXP Normal 10.00 fps 
{0x84, 0x93}, 
{0x85, 0xe0},
#else
{0x83, 0x01}, //EXP Normal 15.00 fps 
{0x84, 0x86}, 
{0x85, 0xa0},
#endif
{0x86, 0x01}, //EXPMin 6000.00 fps
{0x87, 0xf4}, 
{0x88, 0x09}, //EXP Max 5.00 fps 
{0x89, 0x27}, 
{0x8a, 0xc0}, 
{0x8B, 0x75}, //EXP100 
{0x8C, 0x30}, 
{0x8D, 0x61}, //EXP120 
{0x8E, 0xa8}, 
{0x9c, 0x0d}, //EXP Limit 857.14 fps 
{0x9d, 0xac}, 
{0x9e, 0x01}, //EXP Unit 
{0x9f, 0xf4},  
{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xe0}, 
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x38}, //2c}, //19}, 
{0xbd, 0x37}, //2b}, //18}, 
{0xbe, 0x36}, //2a},
{0xbf, 0x36}, //2a},
{0xc0, 0x14}, 
{0xc1, 0x30}, //25}, //14}, //2b},
{0xc2, 0x30}, //25}, //14}, //2b},
{0xc3, 0x30}, //25}, //14}, //2b},
{0xc4, 0x08}, //10},
{0xc8, 0x60}, //70}, //40->80 DG MAX 
{0xc9, 0x40},
{0x03, 0x22},
{0x10, 0xfd}, //AWB mode
{0x11, 0x2e},
{0x19, 0x01}, //Low On
{0x20, 0x10},
{0x21, 0x84}, //80},
{0x24, 0x01},
{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x22}, 
{0x39, 0x34},
{0x40, 0x81}, //f1}, //fa}, //Y limit      
{0x41, 0x44}, //CDIFF
{0x42, 0x22}, //33}, //CSUM
{0x43, 0x81}, //f6},
{0x44, 0x44},
{0x45, 0x33},
{0x46, 0x00},   
{0x50, 0xb2}, //skin_color_th1
{0x51, 0x81}, //skin_color_th2
{0x52, 0x98}, //skin_color_th3
{0x80, 0x40}, //38}, //R gain
{0x81, 0x20}, //G gain
{0x82, 0x35}, //B gain             
{0x83, 0x5e}, //50}, // Indoor
{0x84, 0x24}, //20}, 
{0x85, 0x50}, //59}, //53}, 
{0x86, 0x24}, //20},              
{0x87, 0x49}, //outdoor 1  
{0x88, 0x39},
{0x89, 0x37}, 
{0x8a, 0x29},             
{0x8b, 0x41}, //outdoor 2
{0x8c, 0x39}, 
{0x8d, 0x34}, 
{0x8e, 0x29}, 
{0x8f, 0x57}, //4F}, //Slope
{0x90, 0x55}, //4F}, 
{0x91, 0x52}, //4E}, 
{0x92, 0x4d}, //4B}, 
{0x93, 0x48}, //45}, 
{0x94, 0x3f}, //3b}, 
{0x95, 0x34}, 
{0x96, 0x2e}, 
{0x97, 0x26}, 
{0x98, 0x22}, 
{0x99, 0x21}, 
{0x9a, 0x21}, 
{0x9b, 0x66}, 
{0x9c, 0x66}, 
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},
{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},
{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, //700fps
{0xa6, 0xcf},
{0xad, 0x40},
{0xae, 0x4a},
{0xaf, 0x28}, //low temp Rgain
{0xb0, 0x26}, //low temp Rgain
{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xa0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
{0x03, 0x48},
{0x70, 0x05}, // PLL Setting //
{0x71, 0x30}, //18->30 Pllx1->Pllx2
{0x72, 0x85}, 
{0x70, 0x85}, // PLL Enable
{0x03, 0x48},
{0x03, 0x48},
{0x03, 0x48},
{0x03, 0x48},
{0x70, 0x95}, //CLK_GEN_ENABLE
{0x10, 0x1c}, // MIPI TX Setting
{0x11, 0x00}, //0x00 : not contious, 0x10 : continous
{0x12, 0x00},
{0x14, 0x30}, //0x10},
{0x16, 0x04},
{0x19, 0x00},
{0x1a, 0x32}, //0x22},
{0x1b, 0x17}, //0x0d},
{0x1c, 0x0e}, // hs_rqst_tlpx [ 5: 0]
{0x1d, 0x0f}, // hs_rqst_tlpx[5:0]
{0x1e, 0x08}, // 0x14}, HS GO Ths-zero  decimal 1 ~20 
{0x1f, 0x06}, //04}, // Ths_trail_time decimal 1 ~20
{0x20, 0x00}, // Ths_exit , lp ths exit time  [ 0 - 8 ]
{0x23, 0x01},
{0x24, 0x1e},
{0x25, 0x00},
{0x26, 0x00},
{0x27, 0x01},
{0x28, 0x00},
{0x2a, 0x06},
{0x2b, 0x40},
{0x2c, 0x04},
{0x2d, 0xb0},
{0x30, 0x40},
{0x31, 0x06},
{0x32, 0x06}, 
{0x33, 0x0a}, // Tclk_post , tclk post time [ 3:0]
{0x34, 0x02}, //01}, // HS_PRPR-Tclk prepare [ 2: 0]
{0x35, 0x01},
{0x36, 0x03}, //01},
{0x37, 0x07},
{0x38, 0x02},
{0x39, 0x02},
{0x50, 0x00},
{0x03, 0x20},
{0x10, 0xcc}, // AUTO
{0x03, 0x22},
{0x10, 0xf9},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
#ifndef F_STREAM_ON_OFF	
{0x03, 0x00},
{0x01, 0x30},
#endif

#endif/*1*/

#else

//20120508
#ifndef F_STREAM_ON_OFF	
{0x03, 0x00},
{0x01, 0x31}, //sleep on
#endif
{0x01, 0x33}, //soft reset
{0x01, 0x31},
{0x08, 0x2f}, //20}, 
{0x0A, 0x00}, //3F}, 
{0x03, 0x20}, //page 20
{0x10, 0x0c}, //ae off
{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off
{0x03, 0x00},
{0x0b, 0xaa}, //ESD Check Register
{0x0c, 0xaa}, //ESD Check Register
{0x0d, 0xaa}, //ESD Check Register
{0x10, 0x15}, //11}, //Sub 1 + Preview 1 mode
{0x11, 0x80}, //B[2] Fixed Frame XY flip (90:Default)
{0x12, 0x04},
{0x20, 0x00},
{0x21, 0x0c}, 
{0x22, 0x00},
{0x23, 0x14},
{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},
{0x28, 0x0c},
{0x29, 0x04},
{0x2A, 0x02},
{0x2B, 0x04},
{0x2C, 0x06},
{0x2D, 0x02},
{0x40, 0x01}, //Hblank 360
{0x41, 0x68}, 
{0x42, 0x00}, //Vblank 20
{0x43, 0x14}, 
{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},
{0x80, 0x2e}, //BLC
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x14}, //BLC_TIME_TH_ON
{0x91, 0x14}, //BLC_TIME_TH_OFF 
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},
{0x99, 0x43}, //OutDoor  BLC
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
{0xa0, 0x01}, //00}, //Dark BLC
{0xa2, 0x02},
{0xa4, 0x02},
{0xa6, 0x02},
{0xa8, 0x43}, //Normal BLC
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},
{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00}, //Power Saving
{0x2f, 0x00}, //Power Saving
{0x30, 0x05}, //For Hi-253 never no change 0x05
{0x50, 0x20},
{0x52, 0x01},
{0x53, 0xc1}, //Don't Touch Register
{0x54, 0xc0}, //Don't Touch Register
{0x55, 0x1c},
{0x56, 0x11},
{0x58, 0x22},
{0x59, 0x20}, 
{0x5d, 0xa2},
{0x5e, 0x5a},
{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},
{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},
{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},
{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},
{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},
{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},
{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},
{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa}, 
{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},
{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x14}, //DCDC_TIME_TH_ON
{0xd5, 0x14}, //DCDC_TIME_TH_OFF 
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},
{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},
{0x03, 0x03}, //03 Page
{0x10, 0x10},
{0x03, 0x10}, //10 Page
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x00},
{0x40, 0x00},
{0x41, 0x10}, //00}, //14}, //Dy offset
{0x48, 0x80}, //Contrast Off (88:On)
{0x50, 0xd0}, //SKT 3
{0x60, 0x67},
{0x61, 0x70}, //6a}, //7a}, 7a}, Sat B 
{0x62, 0x6b}, //65}, //70}, 74}, Sat R
{0x63, 0xe0}, //Double_AG 50->d0
{0x64, 0x80}, //40->80 
{0x66, 0x42},
{0x67, 0x20},
{0x6a, 0x8a}, //80}, //8a}, //80}, //8a
{0x6b, 0x74}, //84}, //74
{0x6c, 0x7e}, //7a}, //7e
{0x6d, 0x8a}, //8e}, //80}, //8e
{0x03, 0x11}, //11 Page
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, //Blue Max-Filter Delete
{0x13, 0xbb},
{0x26, 0x31}, //Double_AG 31->20
{0x27, 0x34}, //Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},
{0x30, 0x70}, //Out2 D-LPF th
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},
{0x36, 0x70}, //Out1 D-LPF th
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x09},
{0x3a, 0x06},
{0x3b, 0x03},
{0x3c, 0x80}, //Indoor D-LPF th
{0x3d, 0x18},
{0x3e, 0x40},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},
{0x42, 0x80}, //Dark1 D-LPF th
{0x43, 0x18},
{0x44, 0x40},
{0x45, 0x13},
{0x46, 0x10},
{0x47, 0x10},
{0x48, 0x90}, //Dark2 D-LPF th
{0x49, 0x40},
{0x4a, 0x58},
{0x4b, 0x13},
{0x4c, 0x10},
{0x4d, 0x11},
{0x4e, 0x80}, //Dark3 D-LPF th
{0x4f, 0x30},
{0x50, 0x80},
{0x51, 0x13},
{0x52, 0x10},
{0x53, 0x13},
{0x54, 0x11},
{0x55, 0x0D},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},
{0x5a, 0x1f},
{0x5b, 0x3F},
{0x5c, 0x00},
{0x60, 0x3f},
{0x62, 0x10},
{0x70, 0x06},
{0x03, 0x12}, //12 Page
{0x20, 0x0f},
{0x21, 0x0f},
{0x25, 0x30},
{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},
{0x30, 0x30},
{0x31, 0x38},
{0x32, 0x42},
{0x33, 0x60},
{0x34, 0x70},
{0x35, 0x80},
{0x36, 0xa0},
{0x40, 0xa0}, //Out2 th
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},
{0x46, 0xb0}, //Out1 th
{0x47, 0x55},
{0x48, 0xa0},
{0x49, 0x90},
{0x4a, 0x90},
{0x4b, 0x80},
{0x4c, 0xb0}, //Indoor th
{0x4d, 0x40},
{0x4e, 0xB0},
{0x4f, 0x90},
{0x50, 0xC0},
{0x51, 0x80},
{0x52, 0xb0}, //Dark1 th
{0x53, 0x60},
{0x54, 0xc0},
{0x55, 0xc0},
{0x56, 0xc0},
{0x57, 0x70},
{0x58, 0x90}, //Dark2 th
{0x59, 0x40},
{0x5a, 0xd0},
{0x5b, 0xd0},
{0x5c, 0xd0},
{0x5d, 0x70},
{0x5e, 0x88}, //Dark3 th
{0x5f, 0x40},
{0x60, 0xe0},
{0x61, 0xe0},
{0x62, 0xe0},
{0x63, 0x80},
{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register
{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register
{0x74, 0x25},
{0x75, 0x15},
{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x5d}, //For Preview  
{0xD0, 0x0c}, //Don't Touch register 
{0xD1, 0x80},
{0xD2, 0x17}, //67},
{0xD3, 0x00},
{0xD4, 0x00},
{0xD5, 0x0f}, //02},
{0xD6, 0xff},
{0xD7, 0xff}, //18}, //End              
{0x3b, 0x06},
{0x3c, 0x06},
{0xc5, 0x30}, //55->48
{0xc6, 0x2a}, //48->40
{0x03, 0x13}, //13 Page 
{0x10, 0xab},
{0x11, 0x7b},
{0x12, 0x02}, //06},
{0x14, 0x00},
{0x20, 0x08}, //15}, 
{0x21, 0x05}, //13}, 
{0x22, 0x33},
{0x23, 0x04},
{0x24, 0x09},
{0x25, 0x08}, 
{0x26, 0x20},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},
{0x2b, 0x06}, //Low clip th
{0x2c, 0x07},
{0x25, 0x08},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},
{0x50, 0x10}, //Out2 Edge
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0f},
{0x56, 0x10}, //Out1 Edge
{0x57, 0x13},
{0x58, 0x12},
{0x59, 0x0c},
{0x5a, 0x0f},
{0x5b, 0x0f},
{0x5c, 0x0a}, //Indoor Edge
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},
{0x62, 0x08}, //Dark1 Edge
{0x63, 0x09},
{0x64, 0x08},
{0x65, 0x06},
{0x66, 0x07},
{0x67, 0x06},
{0x68, 0x07}, //Dark2 Edge
{0x69, 0x08},
{0x6a, 0x07},
{0x6b, 0x06},
{0x6c, 0x07},
{0x6d, 0x06},
{0x6e, 0x07}, //Dark3 Edge
{0x6f, 0x08},
{0x70, 0x07},
{0x71, 0x06},
{0x72, 0x07},
{0x73, 0x06},
{0x80, 0xFD}, //2DY
{0x81, 0x1f},
{0x82, 0x01},
{0x83, 0x31},
{0x90, 0x3f}, 
{0x91, 0x3f}, 
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x05},
{0x95, 0x0a}, //18},
{0x97, 0x30},
{0x99, 0x35},
{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x02},
{0xa5, 0x04},
{0xa6, 0x04},
{0xa7, 0x06},
{0xa8, 0x05},
{0xa9, 0x08},
{0xaa, 0x05},
{0xab, 0x08},     
{0xb0, 0x22}, //Out2 
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},
{0xb6, 0x22}, //Out1 
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},
{0xbc, 0x1e}, //27}, //Indoor 
{0xbd, 0x24}, //30},
{0xbe, 0x20}, //2a},
{0xbf, 0x1e}, //27},
{0xc0, 0x24}, //30},
{0xc1, 0x20}, //2a},
{0xc2, 0x1e}, //Dark1
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},
{0xc8, 0x18}, //Dark2
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},
{0xce, 0x18}, //Dark3
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
{0x03, 0x14}, //14 Page
{0x10, 0x11},
{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY
{0x20, 0x80}, //X
{0x21, 0x80}, //Y
{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},
{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},
{0x40, 0x7a}, 
{0x50, 0x5e}, 
{0x60, 0x54}, 
{0x70, 0x5e}, 
{0x03, 0x15}, //15 Page
{0x10, 0x0f},
{0x14, 0x46}, //CMCOFSGH
{0x15, 0x36}, //CMCOFSGM
{0x16, 0x26}, //CMCOFSGL
{0x17, 0x3f}, //2f}, //CMC SIGN           
{0x30, 0x9b}, //8f}, //CMC
{0x31, 0x59},
{0x32, 0x02}, //0a},
{0x33, 0x17}, //15},
{0x34, 0x65}, //5b},
{0x35, 0x0e}, //06},
{0x36, 0x08}, //07},
{0x37, 0x45}, //40},
{0x38, 0x8d}, //87},              
{0x40, 0xa0}, //94}, //CMC MOFS
{0x41, 0x20},
{0x42, 0x00}, //89},
{0x43, 0x82}, //84},
{0x44, 0x87}, //03},
{0x45, 0x09}, //01},
{0x46, 0x81}, //88},
{0x47, 0x9d}, //9c},
{0x48, 0x1e}, //24}, //28},             
{0x50, 0x8a}, //02}, //CMC POFS
{0x51, 0x14}, //82},
{0x52, 0x8a}, //00},
{0x53, 0x06}, //07},
{0x54, 0x07}, //11},
{0x55, 0x8d}, //98},
{0x56, 0x01}, //00},
{0x57, 0x10}, //0b},
{0x58, 0x91}, //8b},
{0x80, 0x03}, //00}, //03},
{0x85, 0x40}, //80}, //40},
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
{0x03, 0x16}, //16 Page
{0x10, 0x31},
{0x18, 0x5e}, // Double_AG 5e->37
{0x19, 0x5d}, // Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},        
{0x30, 0x00}, //Gamma indoor
{0x31, 0x05},
{0x32, 0x10},
{0x33, 0x2a},
{0x34, 0x5b},
{0x35, 0x7e},
{0x36, 0x97},
{0x37, 0xa9},
{0x38, 0xba},
{0x39, 0xc8},
{0x3a, 0xd3},
{0x3b, 0xdc},
{0x3c, 0xe3},
{0x3d, 0xe9},
{0x3e, 0xee},
{0x3f, 0xf2},
{0x40, 0xf6},
{0x41, 0xfb},
{0x42, 0xff},
{0x50, 0x00}, //Gamma outdoor
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x64},
{0x55, 0x83},
{0x56, 0x97},
{0x57, 0xa6},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc8},
{0x5b, 0xd1},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},
{0x70, 0x05}, //Dark
{0x71, 0x17},
{0x72, 0x27},
{0x73, 0x41},
{0x74, 0x6c},
{0x75, 0x87},
{0x76, 0x9d},
{0x77, 0xb0},
{0x78, 0xc0},
{0x79, 0xcb},
{0x7a, 0xd3},
{0x7b, 0xdc},
{0x7c, 0xe3},
{0x7d, 0xe9},
{0x7e, 0xee},
{0x7f, 0xf2},
{0x80, 0xf6},
{0x81, 0xfb},
{0x82, 0xff},
{0x03, 0x17}, //17 Page
{0x10, 0xf7},
{0xC4, 0x3c}, //FLK200 
{0xC5, 0x32}, //FLK240 
{0x03, 0x18}, //18 Page
{0x10, 0x00}, //Scaling Off
{0x03, 0x20}, //20 Page
{0x11, 0x0c}, //1c}, EXP Nor
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x01}, //05}, //AE Weight ON   
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},
{0x28, 0xef}, //DG enable
{0x29, 0x0d}, //ad->0d
{0x2a, 0xFF}, //FF->03, Fixed Frame set : 0x03
{0x2b, 0x34}, //34->35 Fixed Frame set : 0x35
{0x2c, 0xc3}, //c2},
{0x2d, 0xff},
{0x2e, 0x33}, //13}, //33}, adp off
{0x30, 0xf8}, //f8->78
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x26}, //22},
{0x3a, 0xde}, //de},
{0x3b, 0x26}, //22},
{0x3c, 0xde}, //de},
{0x41, 0xa0}, //Fast AE
{0x43, 0x08},
{0x44, 0x1a},
{0x45, 0x40},
{0x46, 0xf0},
{0x47, 0xff},
{0x4d, 0x04},
{0x50, 0x45},
{0x51, 0x88},
{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},
{0x60, 0x00},
{0x61, 0x00},
{0x62, 0x00}, 
{0x63, 0x00}, 
{0x64, 0x16}, //05}, 
{0x65, 0x94}, //50}, 
{0x66, 0x1a}, //06}, 
{0x67, 0xa4}, //90}, 
{0x68, 0x1a}, //06}, 
{0x69, 0xa4}, //90}, 
{0x6a, 0x16}, //05}, 
{0x6b, 0x94}, //50}, 
{0x6c, 0x00}, 
{0x6d, 0x00}, 
{0x6e, 0x00},
{0x6f, 0x00},
{0x70, 0x3d}, //40}, //74}, Y Target
{0x71, 0x82}, //82(+8)
{0x76, 0x43},
{0x77, 0x02}, //04},
{0x78, 0x22}, //23}, //24
{0x79, 0x29}, //46},     
{0x7a, 0x23}, 
{0x7b, 0x22}, 
{0x7d, 0x23},
#ifdef T_OSCAR
{0x83, 0x04}, //EXP Normal 10.00 fps 
{0x84, 0x93}, 
{0x85, 0xe0},  
#else
{0x83, 0x01}, //EXP Normal 15.00 fps 
{0x84, 0x86}, 
{0x85, 0xa0},  
#endif
{0x86, 0x01}, //EXPMin 6000.00 fps
{0x87, 0xf4}, 
{0x88, 0x09}, //EXP Max 5.00 fps 
{0x89, 0x27}, 
{0x8a, 0xc0}, 
{0x8B, 0x75}, //EXP100 
{0x8C, 0x30}, 
{0x8D, 0x61}, //EXP120 
{0x8E, 0xa8}, 
{0x9c, 0x0d}, //EXP Limit 857.14 fps 
{0x9d, 0xac}, 
{0x9e, 0x01}, //EXP Unit 
{0x9f, 0xf4},  
{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xe0}, 
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x38}, //2c}, //19}, 
{0xbd, 0x37}, //2b}, //18}, 
{0xbe, 0x36}, //2a},
{0xbf, 0x36}, //2a},
{0xc0, 0x14}, 
{0xc1, 0x30}, //25}, //14}, //2b},
{0xc2, 0x30}, //25}, //14}, //2b},
{0xc3, 0x30}, //25}, //14}, //2b},
{0xc4, 0x08}, //10},
{0xc8, 0x60}, //70}, //40->80 DG MAX 
{0xc9, 0x40},
{0x03, 0x22}, //22 Page
{0x10, 0xfd}, //AWB mode
{0x11, 0x2e},
{0x19, 0x01}, //Low On
{0x20, 0x10},
{0x21, 0x84}, //80},
{0x24, 0x01},
{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x22}, 
{0x39, 0x34},
{0x40, 0x81}, //f1}, //fa}, //Y limit      
{0x41, 0x44}, //CDIFF
{0x42, 0x22}, //33}, //CSUM
{0x43, 0x81}, //f6},
{0x44, 0x44},
{0x45, 0x33},
{0x46, 0x00},   
{0x50, 0xb2}, //skin_color_th1
{0x51, 0x81}, //skin_color_th2
{0x52, 0x98}, //skin_color_th3
{0x80, 0x40}, //38}, //R gain
{0x81, 0x20}, //G gain
{0x82, 0x35}, //B gain               
{0x83, 0x5e}, //50}, // Indoor
{0x84, 0x24}, //20}, 
{0x85, 0x50}, //59}, //53}, 
{0x86, 0x24}, //20},              
{0x87, 0x49}, //outdoor 1  
{0x88, 0x39},
{0x89, 0x37}, 
{0x8a, 0x29},             
{0x8b, 0x41}, //outdoor 2
{0x8c, 0x39}, 
{0x8d, 0x34}, 
{0x8e, 0x29}, 
{0x8f, 0x57}, //4F}, 
{0x90, 0x55}, //4F}, 
{0x91, 0x52}, //4E}, 
{0x92, 0x4d}, //4B}, 
{0x93, 0x48}, //45}, 
{0x94, 0x3f}, //3b}, 
{0x95, 0x34}, //34}, 
{0x96, 0x2e}, //2e}, 
{0x97, 0x26}, //26}, 
{0x98, 0x22}, //22}, 
{0x99, 0x21}, //21}, 
{0x9a, 0x21}, //21}, 
{0x9b, 0x66}, 
{0x9c, 0x66},
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},
{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},
{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, //700fps
{0xa6, 0xcf},
{0xad, 0x40},
{0xae, 0x4a},
{0xaf, 0x28}, //low temp Rgain
{0xb0, 0x26}, //low temp Rgain
{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xa0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
{0x03, 0x48}, //48 Page MIPI           
{0x70, 0x05}, //PLL Setting //
{0x71, 0x30}, //18->30 Pllx1->Pllx2
{0x72, 0x85}, 
{0x70, 0x85}, //PLL Enable
{0x03, 0x48},
{0x03, 0x48},
{0x03, 0x48},
{0x03, 0x48},
{0x70, 0x95}, //CLK_GEN_ENABLE
{0x10, 0x1c}, //MIPI TX Setting
{0x11, 0x00}, //0x00 : not contious, 0x10 : continous
{0x12, 0x00},
{0x14, 0x30}, //0x10},
{0x16, 0x04},
{0x19, 0x00},
{0x1a, 0x32}, //0x22},
{0x1b, 0x17}, //0x0d},
{0x1c, 0x0e}, 
{0x1d, 0x0f}, 
{0x1e, 0x08}, //0x14}, 
{0x1f, 0x06}, //04}, 
{0x20, 0x00}, //02}, 
{0x23, 0x01},
{0x24, 0x1e},
{0x25, 0x00},
{0x26, 0x00},
{0x27, 0x01},
{0x28, 0x00},
{0x2a, 0x06},
{0x2b, 0x40},
{0x2c, 0x04},
{0x2d, 0xb0},
{0x30, 0x40},
{0x31, 0x06},
{0x32, 0x06}, 
{0x33, 0x0a},
{0x34, 0x02}, //01}, 
{0x35, 0x01},
{0x36, 0x03}, //01},
{0x37, 0x07},
{0x38, 0x02},
{0x39, 0x02},
{0x50, 0x00},
{0x03, 0x20},
{0x10, 0xcc}, // AUTO
{0x03, 0x22},
{0x10, 0xf9},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
#ifndef F_STREAM_ON_OFF
{0x03, 0x00},
{0x01, 0x30},
#endif
#endif/*T_OSCAR*/
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_brightness[][YACD5C1SBDBC_BRIGHTNESS_PARM] = {//[9][2]
    {//m4
        {0x03, 0x10}, //Page 10
        {0x40, 0xc0}, // -4Step
    },
    {//m3
        {0x03, 0x10}, //Page 10
        {0x40, 0xb0}, // -3Step
    },
    {//m2
        {0x03, 0x10}, //Page 10
        {0x40, 0xa0}, // -2Step
    },
    {//m1
        {0x03, 0x10}, //Page 10
        {0x40, 0x90}, // -1Step
    },
    {//0
        {0x03, 0x10}, //Page 10
        {0x40, 0x00}, // 0Step
    },
    {//p1
        {0x03, 0x10}, //Page 10
        {0x40, 0x10}, // +1Step
    },
    {//p2
        {0x03, 0x10}, //Page 10
        {0x40, 0x20}, // +2Step
    },
    {//p3
        {0x03, 0x10}, //Page 10
        {0x40, 0x30}, // +3Step
    },
    {//p4
        {0x03, 0x10}, //Page 10
        {0x40, 0x40}, // +4Step
    },
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_effect[][YACD5C1SBDBC_EFFECT_PARM] = {//[14][8]
    {//Color effect Auto
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Mono
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x33},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Negative
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x38},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {// Solarize2
        {0x03, 0x10},
        {0x11, 0x0B},
        {0x12, 0x00},
        {0x13, 0x00},
        {0x40, 0x00},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xCC},
    },
    {//Sepia
        {0x03,0x10},
        {0x11,0x03},
        {0x12,0x33},
        {0x13,0x00},
        {0x40,0x80},
        {0x44,0x70},
        {0x45,0x98},
        {0x46,0xF0},
    },
    {//Color effect Auto //POSTERIZE,
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Color effect Auto //WHITEBOARD
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Color effect Auto //BLACKBOARD
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Aqua
    	{0x03, 0x10},         
    	{0x11, 0x03},         
    	{0x12, 0x33}, //0x03},         
    	{0x13, 0x00},         
    	{0x40, 0x00},         
    	{0x44, 0xb0},         
    	{0x45, 0x40}, 
    	{0x46, 0xF0},
    },
    {//Color effect Auto //EMBOSS
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Sketch
        {0x03, 0x10},
        {0x11, 0x13},
        {0x12, 0x30},
        {0x13, 0x02},
        {0x40, 0x20},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Color effect Auto //NEON
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
#if 0    
    {//Color effect Auto //WHITEBOARD_C
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },
    {//Color effect Auto //BLACKBOARD_C
        {0x03, 0x10},
        {0x11, 0x03},
        {0x12, 0x30},
        {0x13, 0x00},
        {0x40, 0x80},
        {0x44, 0x80},
        {0x45, 0x80},
        {0x46, 0xF0},
    },    
#endif
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_exposure_mode[][YACD5C1SBDBC_EXPOSURE_MODE_PARM] = {//[4][17]
#if 0
#ifdef F_PANTECH_CAMERA_FIX_CFG_EXPOSURE
    { CameraParameters::AUTO_EXPOSURE_OFF,  CAMERA_AEC_OFF },
#endif
    { CameraParameters::AUTO_EXPOSURE_FRAME_AVG,  CAMERA_AEC_FRAME_AVERAGE },
    { CameraParameters::AUTO_EXPOSURE_CENTER_WEIGHTED, CAMERA_AEC_CENTER_WEIGHTED },
    { CameraParameters::AUTO_EXPOSURE_SPOT_METERING, CAMERA_AEC_SPOT_METERING }
#endif
    {//Default AE Weight 
        {0x03, 0x20},
        {0x60, 0x00},
        {0x61, 0x00},
        {0x62, 0x00}, 
        {0x63, 0x00}, 
        {0x64, 0x16}, //05}, 
        {0x65, 0x94}, //50}, 
        {0x66, 0x1a}, //06}, 
        {0x67, 0xa4}, //90}, 
        {0x68, 0x1a}, //06}, 
        {0x69, 0xa4}, //90}, 
        {0x6a, 0x16}, //05}, 
        {0x6b, 0x94}, //50}, 
        {0x6c, 0x00}, 
        {0x6d, 0x00}, 
        {0x6e, 0x00},
        {0x6f, 0x00},
    },
    {//"Average"
        {0x03, 0x20},
    	{0x60, 0x00}, 
    	{0x61, 0x00}, 
    	{0x62, 0x00}, 
    	{0x63, 0x00}, 
    	{0x64, 0x00}, 
    	{0x65, 0x00}, 
    	{0x66, 0x00}, 
    	{0x67, 0x00}, 
    	{0x68, 0x00}, 
    	{0x69, 0x00}, 
    	{0x6a, 0x00}, 
    	{0x6b, 0x00}, 
    	{0x6c, 0x00}, 
    	{0x6d, 0x00}, 
    	{0x6e, 0x00}, 
    	{0x6f, 0x00},
    },
    {//"Center"
        {0x03, 0x20},
        {0x60, 0x00},
        {0x61, 0x00},
        {0x62, 0x00}, 
        {0x63, 0x00}, 
        {0x64, 0x16}, //05}, 
        {0x65, 0x94}, //50}, 
        {0x66, 0x1a}, //06}, 
        {0x67, 0xa4}, //90}, 
        {0x68, 0x1a}, //06}, 
        {0x69, 0xa4}, //90}, 
        {0x6a, 0x16}, //05}, 
        {0x6b, 0x94}, //50}, 
        {0x6c, 0x00}, 
        {0x6d, 0x00}, 
        {0x6e, 0x00},
        {0x6f, 0x00},              
    },
    {//Default AE Weight //SPOT_METERING
        {0x03, 0x20},
    	{0x60, 0x00}, 
    	{0x61, 0x00}, 
    	{0x62, 0x00}, 
    	{0x63, 0x00}, 
    	{0x64, 0x05}, 
    	{0x65, 0x50}, 
    	{0x66, 0x07}, 
    	{0x67, 0xd0}, 
    	{0x68, 0x07}, 
    	{0x69, 0xd0}, 
    	{0x6a, 0x05}, 
    	{0x6b, 0x50}, 
    	{0x6c, 0x00}, 
    	{0x6d, 0x00}, 
    	{0x6e, 0x00}, 
    	{0x6f, 0x00},
    },
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_wb[][YACD5C1SBDBC_WB_PARM] = {//[4][17]
#if 0
#ifdef F_PANTECH_CAMERA_FIX_CFG_WB
        { CameraParameters::WHITE_BALANCE_OFF,             CAMERA_WB_OFF },
#endif
        { CameraParameters::WHITE_BALANCE_AUTO,            CAMERA_WB_AUTO },
        { CameraParameters::WHITE_BALANCE_INCANDESCENT,    CAMERA_WB_INCANDESCENT },
        { CameraParameters::WHITE_BALANCE_FLUORESCENT,     CAMERA_WB_FLUORESCENT },
        { CameraParameters::WHITE_BALANCE_DAYLIGHT,        CAMERA_WB_DAYLIGHT },
        { CameraParameters::WHITE_BALANCE_CLOUDY_DAYLIGHT, CAMERA_WB_CLOUDY_DAYLIGHT }
#endif
    {
        //White Balance Auto
        {0x03, 0x22}, //Page 22
    	{0x11, 0x2e}, //AWB CTL2
    	{0x80, 0x38}, //Rgain
    	{0x82, 0x38}, //Bgain
    	{0x83, 0x5e}, //Rmax
    	{0x84, 0x24}, //Rmin
    	{0x85, 0x59}, //Bmax
    	{0x86, 0x24}, //Bmin
    },
    {
        //White Balance Auto
        {0x03, 0x22}, //Page 22
    	{0x11, 0x2e}, //AWB CTL2
    	{0x80, 0x38}, //Rgain
    	{0x82, 0x38}, //Bgain
    	{0x83, 0x5e}, //Rmax
    	{0x84, 0x24}, //Rmin
    	{0x85, 0x59}, //Bmax
    	{0x86, 0x24}, //Bmin
    },
    {
        //White Balance Auto
        {0x03, 0x22}, //Page 22
    	{0x11, 0x2e}, //AWB CTL2
    	{0x80, 0x38}, //Rgain
    	{0x82, 0x38}, //Bgain
    	{0x83, 0x5e}, //Rmax
    	{0x84, 0x24}, //Rmin
    	{0x85, 0x59}, //Bmax
    	{0x86, 0x24}, //Bmin
    },    
    {
        //White Balance Inca A(Tunsten) 
        {0x03,0x22},//Page 22
    	{0x11,0x28},
    	{0x80,0x27}, 
    	{0x82,0x4c}, 
    	{0x83,0x29}, 
    	{0x84,0x25}, 
    	{0x85,0x4e}, 
    	{0x86,0x4a}, 
    },
    {
        //White Balance Fluorescent  
        {0x03, 0x22}, //Page 22
    	{0x11, 0x28},
    	{0x80, 0x32}, 
    	{0x82, 0x3d}, 
    	{0x83, 0x34}, 
    	{0x84, 0x30}, 
    	{0x85, 0x3f}, 
    	{0x86, 0x3b}, 
        },
    {
        //White Balance sunny(day light) 
        {0x03, 0x22}, //Page 22
    	{0x11, 0x28},
    	{0x80, 0x46}, 
    	{0x82, 0x2b}, 
    	{0x83, 0x48}, 
    	{0x84, 0x44}, 
    	{0x85, 0x2d}, 
    	{0x86, 0x29},            
    },
    {
        //Wite Balance Cloudy
        {0x03, 0x22}, //Page 22
    	{0x11, 0x28},
    	{0x80, 0x5e},
    	{0x82, 0x20},
    	{0x83, 0x60}, 
    	{0x84, 0x5c},
    	{0x85, 0x22}, 
    	{0x86, 0x1d},
    },
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_preview_fps[][YACD5C1SBDBC_PREVIEW_FPS_PARM] = {//[25][57]
    {//Fixed 5 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST        
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x08}, //EXP Max 5.22 fps 
        {0x89, 0xc6}, 
        {0x8a, 0x18},  
        {0x91, 0x09}, //EXP Fix 5.00 fps
        {0x92, 0x27}, 
        {0x93, 0xc0}, 
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x13}, //BLC_TIME_TH_ON
        {0x91, 0x13}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF           
        {0x03, 0x02}, //PAGE 2 //DCDC
        {0xd4, 0x13}, //DCDC_TIME_TH_ON
        {0xd5, 0x13}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 6 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x07}, //EXP Max 6.32 fps 
        {0x89, 0x3f}, 
        {0x8a, 0x78},  
        {0x91, 0x07}, //EXP Fix 6.00 fps
        {0x92, 0xa1}, 
        {0x93, 0x20},  
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x0f}, //BLC_TIME_TH_ON
        {0x91, 0x0f}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF 
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x0f}, //DCDC_TIME_TH_ON
        {0xd5, 0x0f}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 7 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x06}, //EXP Max 7.06 fps 
        {0x89, 0x7c}, 
        {0x8a, 0x28}, 
        {0x91, 0x06}, //EXP Fix 7.00 fps
        {0x92, 0x89}, 
        {0x93, 0xd4}, 
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x0e}, //BLC_TIME_TH_ON
        {0x91, 0x0e}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x0e}, //DCDC_TIME_TH_ON
        {0xd5, 0x0e}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 8 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x05}, //EXP Max 8.57 fps 
        {0x89, 0x57}, 
        {0x8a, 0x30}, 
        {0x91, 0x05}, //EXP Fix 8.00 fps
        {0x92, 0xb8}, 
        {0x93, 0xd8}, 
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x0b}, //BLC_TIME_TH_ON
        {0x91, 0x0b}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF 
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x0b}, //DCDC_TIME_TH_ON
        {0xd5, 0x0b}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 9 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x04}, //EXP Max 9.23 fps 
        {0x89, 0xf5}, 
        {0x8a, 0x88}, 
        {0x91, 0x05}, //EXP Fix 9.00 fps
        {0x92, 0x15}, 
        {0x93, 0xc2},  
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x0a}, //BLC_TIME_TH_ON
        {0x91, 0x0a}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x0a}, //DCDC_TIME_TH_ON
        {0xd5, 0x0a}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 10 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x04}, //EXP Max 10.91 fps 
        {0x89, 0x32}, 
        {0x8a, 0x38},  
        {0x91, 0x04}, //EXP Fix 10.00 fps
        {0x92, 0x93}, 
        {0x93, 0xe0},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x09}, //BLC_TIME_TH_ON
        {0x91, 0x09}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF 
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x09}, //DCDC_TIME_TH_ON
        {0xd5, 0x09}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off
    },
    {//Fixed 11 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x03}, //EXP Max 12.00 fps 
        {0x89, 0xd0}, 
        {0x8a, 0x90},  
        {0x91, 0x04}, //EXP Fix 11.01 fps
        {0x92, 0x28}, 
        {0x93, 0x74}, 
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x08}, //BLC_TIME_TH_ON
        {0x91, 0x08}, //BLC_TIME_TH_OFF 
        {0x92, 0xc8}, //BLC_AG_TH_ON
        {0x93, 0xc0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x08}, //DCDC_TIME_TH_ON
        {0xd5, 0x08}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 12 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x03}, //EXP Max 13.33 fps 
        {0x89, 0x6e}, 
        {0x8a, 0xe8}, 
        {0x91, 0x03}, //EXP Fix 12.00 fps
        {0x92, 0xd0}, 
        {0x93, 0x90},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x07}, //BLC_TIME_TH_ON
        {0x91, 0x07}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x07}, //DCDC_TIME_TH_ON
        {0xd5, 0x07}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 13 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x03}, //EXP Max 13.33 fps 
        {0x89, 0x6e}, 
        {0x8a, 0xe8},  
        {0x91, 0x03}, //EXP Fix 13.00 fps
        {0x92, 0x85}, 
        {0x93, 0x5e},  
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x07}, //BLC_TIME_TH_ON
        {0x91, 0x07}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF 
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x07}, //DCDC_TIME_TH_ON
        {0xd5, 0x07}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 14 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x03}, //EXP Max 15.00 fps 
        {0x89, 0x0d}, 
        {0x8a, 0x40},  
        {0x91, 0x03}, //EXP Fix 14.00 fps
        {0x92, 0x44}, 
        {0x93, 0xea}, 
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x06}, //BLC_TIME_TH_ON
        {0x91, 0x06}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x06}, //DCDC_TIME_TH_ON
        {0xd5, 0x06}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 15 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 17.14 fps 
        {0x89, 0xab}, 
        {0x8a, 0x98}, 
        {0x91, 0x03}, //EXP Fix 15.00 fps
        {0x92, 0x0d}, 
        {0x93, 0x40}, 
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 16 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 17.14 fps 
        {0x89, 0xab}, 
        {0x8a, 0x98},  
        {0x91, 0x02}, //EXP Fix 16.00 fps
        {0x92, 0xdc}, 
        {0x93, 0x6c}, 
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 17 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x91, 0x02}, //EXP Fix 17.02 fps
        {0x92, 0xb0}, 
        {0x93, 0x7a},  
        {0x91, 0x02}, //EXP Fix 17.02 fps
        {0x92, 0xb0}, 
        {0x93, 0x7a},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 19 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 20 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 21 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 22 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 23 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 24 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},        
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 25 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 26 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 27 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 28 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 29 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },
    {//Fixed 18 fps//Fixed 30 fps
        {0x03, 0x20},
        {0x18, 0x38}, //AE reset on
        {0x03, 0x00},
        {0x10, 0x15}, //Sub 1 + Preview 1 mode
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},
        {0x03, 0x20}, //Page 20
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x88, 0x02}, //EXP Max 20.00 fps 
        {0x89, 0x49}, 
        {0x8a, 0xf0}, 
        {0x91, 0x02}, //EXP Fix 18.02 fps
        {0x92, 0x8a}, 
        {0x93, 0x64},
        {0x03, 0x17}, //Page 17 
        {0xC4, 0x3c}, //FLK200 
        {0xC5, 0x32}, //FLK240  
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x05}, //BLC_TIME_TH_ON
        {0x91, 0x05}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x05}, //DCDC_TIME_TH_ON
        {0xd5, 0x05}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00}, 	
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x00},
        {0x03, 0x20},             
        {0x18, 0x30}, //AE reset off 
    },    
    {//Variable fps//Fixed 31 fps
        {0x03, 0x20},                                            
        {0x18, 0x38}, //AE reset on                                    
//        {0x28, 0xef}, //DG enable                                      
        {0x03, 0x00},                                                  
        {0x10, 0x15}, //Sub 1 + Preview 1 mode                         
#ifdef F_PANTECH_CAMERA_2M_REG_TEST                
        {0x11, 0x90}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x80}, //B[2] Fixed Frame XY flip (90:Default)
#endif
        {0x12, 0x04},                                                  
        {0x03, 0x20}, //Page 20                                        
        {0x2a, 0xff}, //FF->03, Fixed Frame set : 0x03                 
        {0x2b, 0x34}, //34->35 Fixed Frame set : 0x35                                                                                
        {0x88, 0x09}, //EXP Max 5.00 fps 
        {0x89, 0x27}, 
        {0x8a, 0xc0},                                                                                                     
        {0x03, 0x17}, //Page 17                                        
        {0xC4, 0x3c}, //FLK200                                         
        {0xC5, 0x32}, //FLK240                                         
        {0x03, 0x00}, //PAGE 0                                         
        {0x90, 0x14}, //BLC_TIME_TH_ON
        {0x91, 0x14}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF                                 
        {0x03, 0x02}, //PAGE 2                                         
        {0xd4, 0x14}, //DCDC_TIME_TH_ON
        {0xd5, 0x14}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF                                                                                              
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},                                                  
        {0x03, 0x00},  
        {0x03, 0x00},    
        {0x03, 0x00},       
        {0x03, 0x00},          
        {0x03, 0x00},                                                
        {0x03, 0x20},                                                  
        {0x18, 0x30}, //AE reset off
    }    
};
static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_preview_24fps_for_motion_detect[][YACD5C1SBDBC_PREVIEW_24FPS_PARM] = {
    {
#if 1//fixed 30fps
        {0x03, 0x00},                     
        {0x01, 0x31}, //Sleep ON                    
        {0x03, 0x20}, //AE OFF 
        {0x10, 0x0C},         
        {0x03, 0x22}, //AWF OFF
        {0x10, 0x69}, 
        {0x03, 0x20},         
        {0x18, 0x38}, //AE Reset ON                          
        {0x03, 0x00},         
        {0x10, 0x17}, //sub1 pre2     
#ifdef F_PANTECH_CAMERA_2M_REG_TEST
        {0x11, 0x94}, //B[2] Fixed Frame XY flip (90:Default)
#else
        {0x11, 0x84}, //Fixed Framerate
#endif
        {0x12, 0x04},                         
        {0x03, 0x18},         
        {0x10, 0x00}, 
        {0x03, 0x00}, //Page 0
        {0x40, 0x01}, //Hblank 352
        {0x41, 0x60}, 
        {0x42, 0x00}, //Vblank 48
        {0x43, 0x30}, 
        {0x03, 0x20},
        {0x2a, 0x03}, //FF->03, Fixed Frame set : 0x03
        {0x2b, 0x35}, //34->35 Fixed Frame set : 0x35
        {0x83, 0x01}, //EXP Normal 30.00 fps 
        {0x84, 0x86}, 
        {0x85, 0x78}, 
        {0x86, 0x01}, //EXPMin 10204.08 fps
        {0x87, 0x26}, 
        {0x88, 0x01}, //EXP Max 40.00 fps 
        {0x89, 0x24}, 
        {0x8a, 0xda}, 
        {0x8B, 0x75}, //EXP100 
        {0x8C, 0x24}, 
        {0x8D, 0x61}, //EXP120 
        {0x8E, 0x9e}, 
        {0x91, 0x01}, //EXP Fix 30.01 fps
        {0x92, 0x86}, 
        {0x93, 0x78}, 
        {0x9c, 0x08}, //EXP Limit 1457.73 fps 
        {0x9d, 0x0a}, 
        {0x9e, 0x01}, //EXP Unit 
        {0x9f, 0x26}, 
        {0x03, 0x20}, //Page 20 
        {0x2b, 0x34}, 
        {0x30, 0x78}, 
        {0x03, 0x00}, //PAGE 0
        {0x90, 0x03}, //BLC_TIME_TH_ON
        {0x91, 0x03}, //BLC_TIME_TH_OFF 
        {0x92, 0xd8}, //BLC_AG_TH_ON
        {0x93, 0xd0}, //BLC_AG_TH_OFF
        {0x03, 0x02}, //PAGE 2
        {0xd4, 0x03}, //DCDC_TIME_TH_ON
        {0xd5, 0x03}, //DCDC_TIME_TH_OFF 
        {0xd6, 0xd8}, //DCDC_AG_TH_ON
        {0xd7, 0xd0}, //DCDC_AG_TH_OFF
        {0x03, 0x48},  //MIPI//     
        {0x70, 0x05},         
        {0x71, 0x30},         
        {0x72, 0x81},         
        {0x70, 0x85},                            
        {0x03, 0x48},              
        {0x03, 0x48},              
        {0x03, 0x48},              
        {0x03, 0x48},                                     
        {0x70, 0x95},              
        {0x10, 0x1c},              
        {0x11, 0x00},              
        {0x12, 0x00},              
        {0x14, 0x30},              
        {0x16, 0x04},              
        {0x19, 0x00},              
        {0x1a, 0x32},              
        {0x1b, 0x17},              
        {0x1c, 0x0a}, //0c},         
        {0x1d, 0x0e}, //0f},         
        {0x1e, 0x07},              
        {0x1f, 0x05},              
        {0x20, 0x00},              
        {0x23, 0x01},              
        {0x24, 0x1e},              
        {0x25, 0x00},              
        {0x26, 0x00},              
        {0x27, 0x01},              
        {0x28, 0x00},              
        {0x2a, 0x06},              
        {0x2b, 0x40},              
        {0x2c, 0x04},              
        {0x2d, 0xb0},              
        {0x30, 0x40}, //800x600 MiPi Output       
        {0x31, 0x06},         
        {0x32, 0x0f},         
        {0x33, 0x0a},         
        {0x34, 0x03}, //01},         
        {0x35, 0x03},         
        {0x36, 0x01},         
        {0x37, 0x07},         
        {0x38, 0x02},         
        {0x39, 0x03},         
        {0x50, 0x00},        
        {0x03, 0x20},
        {0x10, 0x8c},  // 60Hz
        {0x03, 0x22},
        {0x10, 0xf9},      
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},         
        {0x03, 0x00},                  
        {0x03, 0x00},         
        {0x01, 0x30}, //Sleep off
        {0x03, 0x20},         
        {0x18, 0x30}, //AE Reset OFF
#endif//fixed 30fps        
    },
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_reflect[][YACD5C1SBDBC_REFLECT_PARM] = {//[4][17]
#if 0
    { CameraParameters::REFLECT_OFF, 0 },
    { CameraParameters::REFLECT_MIRROR,  1 },
    { CameraParameters::REFLECT_WATER,  2 },
    { CameraParameters::REFLECT_MIRROR_WATER,  3 },
#endif
#if 0//def T_OSCAR  // for OSCAR_JB issue (beauty mode).
    {//"Defaut"
        {0x03, 0x00},
        {0x11, 0x80}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },
    {//mirror "Flip X"
        {0x03, 0x00},
        {0x11, 0x81}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },        
    {//water "Flip Y"
        {0x03, 0x00},
        {0x11, 0x82}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },
    {//mirror_water "Flip XY"
        {0x03, 0x00},
        {0x11, 0x83}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },    
#else
    {//"Defaut"
        {0x03, 0x00},
        {0x11, 0x90}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },
    {//mirror "Flip X"
        {0x03, 0x00},
        {0x11, 0x91}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },        
    {//water "Flip Y"
        {0x03, 0x00},
        {0x11, 0x92}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },
    {//mirror_water "Flip XY"
        {0x03, 0x00},
        {0x11, 0x93}, //B[0]: X flip, B[1]: Y flip  (90:Default)
    },    
#endif
};

static struct msm_camera_i2c_reg_conf yacd5c1sbdbc_cfg_checkzsl[][YACD5C1SBDBC_CHECK_ZSL_PARM] = { //[0][4]
    {//[AE, AWB Off SET]
        {0x03, 0x20}, //AE OFF 
        {0x10, 0x0C},         
        {0x03, 0x22}, //AWF OFF
        {0x10, 0x69}, 
    },
};

#endif
