/* Copyright (c) 2011, PANTECH. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

#include "sensor_i2c.h"


//PANTECH_CAMERA_TODO
//static const si2c_cmd_t s5k4ecgx_cfg_init[] = {
static si2c_cmd_t s5k4ecgx_cfg_init[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0010, 0x0001, 0}, //S/W Reset
{SI2C_WR, SI2C_A2D2, 0x1030, 0x0000, 0}, //contint_host_int
{SI2C_WR, SI2C_A2D2, 0x0014, 0x0001, 0}, //sw_load_complete - Release CORE (Arm) from reset state
{SI2C_DELAY, SI2C_A1D1, 0, 0, 10},		 //Delay 10ms

{SI2C_WR, SI2C_A2D2, 0x0028, 0xD000, 0}, //Driving Current
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1082, 0},
{SI2C_WR, SI2C_A2D2, 0x0f12, 0x0000, 0}, //cregs_d0_d4_cd10 //D4[9:8], D3[7:6], D2[5:4], D1[3:2], D0[1:0]
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1084, 0},
{SI2C_WR, SI2C_A2D2, 0x0f12, 0x0000, 0}, //cregs_d5_d9_cd10 //D9[9:8], D8[7:6], D7[5:4], D6[3:2], D5[1:0]
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1088, 0},
{SI2C_WR, SI2C_A2D2, 0x0f12, 0x0000, 0}, //cregs_clks_output_cd10 //SDA[11:10], SCL[9:8], PCLK[7:6], VSYNC[3:2], HSYNC[1:0]

{SI2C_WR, SI2C_A2D2, 0x0028, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x007A, 0},
{SI2C_WR, SI2C_A2D2, 0x0f12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0xE406, 0}, //[7]f_ladlc_en [6:5]f max [4]fadlc_en [3:2]L max [1]ladlc_en [0]adlc_ch_sel
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0092, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0xE410, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3804, 0}, //[15:8]fadlc_filter_co_b, [7:0]fadlc_filter_co_a
{SI2C_WR, SI2C_A2D2, 0x002A, 0xE41A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0010, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0xE420, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0003, 0}, //adlc_fadlc_filter_refresh
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0060, 0}, //adlc_filter_level_diff_threshold
{SI2C_WR, SI2C_A2D2, 0x002A, 0xE42E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0004, 0}, //dithered l-ADLC(4bit)
{SI2C_WR, SI2C_A2D2, 0x002A, 0xF400, 0},

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5A3C, 0}, //[15:8]stx_width, [7:0]dstx_width
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0023, 0}, //[14]binning_test [13]gain_mode [11:12]row_id [10]cfpn_test [9]pd_pix [8]teg_en, [7]adc_res, [6]smp_en, [5]ldb_en, [4]ld_en, [3]clp_en [2]srx_en, [1]dshut_en, [0]dcds_en
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8080, 0}, //CDS option
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03AF, 0}, //[11:6]rst_mx, [5:0]sig_mx
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000A, 0}, //Avg mode
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xAA54, 0}, //x1~x1.49:No MS, x1.5~x3.99:MS2, x4~x16:MS4
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0}, //RMP option [6]1: RES gain
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x464E, 0}, //[14]msoff_en, [13:8]off_rst, [7:0]adc_sat
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0240, 0}, //bist_sig_width_e
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0240, 0}, //bist_sig_width_o
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0}, //[9]dbs_bist_en, [8:0]bist_rst_width
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1000, 0}, //[15]aac_en, [14]GCLK_DIV2_EN, [13:10]dl_cont [9:8]dbs_mode, [7:0]dbs_option

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x55FF, 0}, //bias [15:12]pix, [11:8]pix_bst [7:4]comp2, [3:0]comp1
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xD000, 0}, //[15:8]clp_lvl, [7:0]ref_option, [5]pix_bst_en
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0}, //[7:0]monit
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0}, //[15:8]dbr_tune_tgsl, [7:0]dbr_tune_pix
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0401, 0}, //[15:8]dbr_tune_ntg, [7:0]dbr_tune_rg
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0022, 0}, //[15:8]reg_option, [7:4]rosc_tune_ncp, [3:0]rosc_tune_cp
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0088, 0}, //PD [8]inrush_ctrl, [7]fblv, [6]reg_ntg, [5]reg_tgsl, [4]reg_rg, [3]reg_pix, [2]ncp_rosc, [1]cp_rosc, [0]cp
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x009F, 0}, //[9]capa_ctrl_en, [8:7]fb_lv, [6:5]dbr_clk_sel, [4:0]cp_capa
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //[15:0]blst_en_cintr
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1800, 0}, //[11]blst_en, [10]rfpn_test, [9]sl_off, [8]tx_off, [7:0]rdv_option
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0088, 0}, //[15:0]pmg_reg_tune
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //[15:1]analog_dummy, [0]pd_reg_test 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2428, 0}, //[13:11]srx_gap1, [10:8]srx_gap0, [7:0]stx_gap
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //[0]atx_option
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03EE, 0}, //aig_avg_half
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //[0]hvs_test_reg
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //[0]dbus_bist_auto
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //[7:0]dbr_option
{SI2C_WR,  SI2C_A2D2, 0x002A, 0xF552, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0708, 0}, //[7:0]lat_st, [15:8]lat_width
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x080C, 0}, //[7:0]hold_st, [15:8]hold_width

{SI2C_WR,  SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR,  SI2C_A2D2, 0x002A, 0x3AF8, 0},
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5F8, 0},	// 70003AF8 // START of Patch Data
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4B44, 0},	// 70003AFA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4944, 0},	// 70003AFC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4845, 0},	// 70003AFE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2200, 0},	// 70003B00
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC008, 0},	// 70003B02
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6001, 0},	// 70003B04
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4944, 0},	// 70003B06
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4844, 0},	// 70003B08
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2401, 0},	// 70003B0A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B0C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFCA4, 0},	// 70003B0E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4943, 0},	// 70003B10
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4844, 0},	// 70003B12
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2702, 0},	// 70003B14
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0022, 0},	// 70003B16
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B18
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC9E, 0},	// 70003B1A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0260, 0},	// 70003B1C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4C42, 0},	// 70003B1E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8020, 0},	// 70003B20
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2600, 0},	// 70003B22
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8066, 0},	// 70003B24
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4941, 0},	// 70003B26
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4841, 0},	// 70003B28
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6041, 0},	// 70003B2A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4941, 0},	// 70003B2C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4842, 0},	// 70003B2E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x003A, 0},	// 70003B30
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2503, 0},	// 70003B32
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B34
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC90, 0},	// 70003B36
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x483D, 0},	// 70003B38
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4940, 0},	// 70003B3A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x30C0, 0},	// 70003B3C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x63C1, 0},	// 70003B3E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4F3B, 0},	// 70003B40
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x483F, 0},	// 70003B42
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3F80, 0},	// 70003B44
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6438, 0},	// 70003B46
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x483E, 0},	// 70003B48
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x493F, 0},	// 70003B4A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6388, 0},	// 70003B4C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003B4E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x493E, 0},	// 70003B50
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x483F, 0},	// 70003B52
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2504, 0},	// 70003B54
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B56
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC7F, 0},	// 70003B58
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003B5A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x493D, 0},	// 70003B5C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x483E, 0},	// 70003B5E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2505, 0},	// 70003B60
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B62
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF8A7, 0},	// 70003B64
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x483C, 0},	// 70003B66
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003B68
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x493C, 0},	// 70003B6A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2506, 0},	// 70003B6C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1D80, 0},	// 70003B6E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B70
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF8A0, 0},	// 70003B72
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4838, 0},	// 70003B74
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003B76
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4939, 0},	// 70003B78
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2507, 0},	// 70003B7A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x300C, 0},	// 70003B7C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B7E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF899, 0},	// 70003B80
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4835, 0},	// 70003B82
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003B84
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4937, 0},	// 70003B86
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2508, 0},	// 70003B88
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3010, 0},	// 70003B8A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B8C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF892, 0},	// 70003B8E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003B90
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4935, 0},	// 70003B92
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4835, 0},	// 70003B94
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2509, 0},	// 70003B96
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003B98
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC5E, 0},	// 70003B9A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003B9C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4934, 0},	// 70003B9E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4834, 0},	// 70003BA0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x250A, 0},	// 70003BA2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003BA4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC58, 0},	// 70003BA6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003BA8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4933, 0},	// 70003BAA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4833, 0},	// 70003BAC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x250B, 0},	// 70003BAE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003BB0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC52, 0},	// 70003BB2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003BB4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4932, 0},	// 70003BB6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4832, 0},	// 70003BB8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x250C, 0},	// 70003BBA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003BBC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC4C, 0},	// 70003BBE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003BC0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4931, 0},	// 70003BC2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4831, 0},	// 70003BC4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x250D, 0},	// 70003BC6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003BC8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC46, 0},	// 70003BCA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003BCC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4930, 0},	// 70003BCE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4830, 0},	// 70003BD0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x250E, 0},	// 70003BD2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003BD4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC40, 0},	// 70003BD6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003BD8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x492F, 0},	// 70003BDA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x482F, 0},	// 70003BDC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x250F, 0},	// 70003BDE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003BE0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC3A, 0},	// 70003BE2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8626, 0},	// 70003BE4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x20FF, 0},	// 70003BE6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1C40, 0},	// 70003BE8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8660, 0},	// 70003BEA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x482C, 0},	// 70003BEC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x64F8, 0},	// 70003BEE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x492C, 0},	// 70003BF0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x482D, 0},	// 70003BF2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2410, 0},	// 70003BF4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003BF6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003BF8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC2E, 0},	// 70003BFA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x492B, 0},	// 70003BFC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x482C, 0},	// 70003BFE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0022, 0},	// 70003C00
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003C02
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFC29, 0},	// 70003C04
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBCF8, 0},	// 70003C06
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 70003C08
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 70003C0A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x019C, 0},	// 70003C0C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4EC2, 0},	// 70003C0E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x73FF, 0},	// 70003C10
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C12
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1F90, 0},	// 70003C14
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C16
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3CCD, 0},	// 70003C18
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C1A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE38B, 0},	// 70003C1C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C1E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3D05, 0},	// 70003C20
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C22
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC3B1, 0},	// 70003C24
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C26
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4780, 0},	// 70003C28
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C2A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3D63, 0},	// 70003C2C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C2E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0080, 0},	// 70003C30
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C32
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3D9F, 0},	// 70003C34
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C36
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB49D, 0},	// 70003C38
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C3A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3E4B, 0},	// 70003C3C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C3E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3DFF, 0},	// 70003C40
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C42
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFFFF, 0},	// 70003C44
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x00FF, 0},	// 70003C46
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x17E0, 0},	// 70003C48
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C4A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3FC7, 0},	// 70003C4C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C4E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x053D, 0},	// 70003C50
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C52
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C54
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0A89, 0},	// 70003C56
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6CD2, 0},	// 70003C58
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C5A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x02C9, 0},	// 70003C5C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C5E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C60
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0A9A, 0},	// 70003C62
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C64
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x02D2, 0},	// 70003C66
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4015, 0},	// 70003C68
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C6A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9E65, 0},	// 70003C6C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C6E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4089, 0},	// 70003C70
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C72
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7C49, 0},	// 70003C74
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C76
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x40FD, 0},	// 70003C78
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C7A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7C63, 0},	// 70003C7C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C7E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4119, 0},	// 70003C80
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C82
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8F01, 0},	// 70003C84
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C86
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x41BB, 0},	// 70003C88
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C8A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7F3F, 0},	// 70003C8C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C8E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4249, 0},	// 70003C90
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C92
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x98C5, 0},	// 70003C94
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C96
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43B5, 0},	// 70003C98
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003C9A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6099, 0},	// 70003C9C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003C9E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x430F, 0},	// 70003CA0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003CA2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4365, 0},	// 70003CA4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003CA6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xA70B, 0},	// 70003CA8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003CAA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4387, 0},	// 70003CAC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70003CAE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x400D, 0},	// 70003CB0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70003CB2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB570, 0},	// 70003CB4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000C, 0},	// 70003CB6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0015, 0},	// 70003CB8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0029, 0},	// 70003CBA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003CBC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFBD4, 0},	// 70003CBE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49F8, 0},	// 70003CC0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x00A8, 0},	// 70003CC2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x500C, 0},	// 70003CC4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC70, 0},	// 70003CC6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 70003CC8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 70003CCA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6808, 0},	// 70003CCC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003CCE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003CD0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6849, 0},	// 70003CD2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0409, 0},	// 70003CD4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C09, 0},	// 70003CD6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4AF3, 0},	// 70003CD8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8992, 0},	// 70003CDA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2A00, 0},	// 70003CDC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD00D, 0},	// 70003CDE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2300, 0},	// 70003CE0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1A89, 0},	// 70003CE2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD400, 0},	// 70003CE4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000B, 0},	// 70003CE6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0419, 0},	// 70003CE8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C09, 0},	// 70003CEA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x23FF, 0},	// 70003CEC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x33C1, 0},	// 70003CEE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1810, 0},	// 70003CF0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4298, 0},	// 70003CF2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD800, 0},	// 70003CF4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0003, 0},	// 70003CF6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0418, 0},	// 70003CF8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003CFA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4AEB, 0},	// 70003CFC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8150, 0},	// 70003CFE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8191, 0},	// 70003D00
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4770, 0},	// 70003D02
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5F3, 0},	// 70003D04
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0004, 0},	// 70003D06
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB081, 0},	// 70003D08
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9802, 0},	// 70003D0A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6800, 0},	// 70003D0C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0600, 0},	// 70003D0E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0E00, 0},	// 70003D10
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2201, 0},	// 70003D12
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0015, 0},	// 70003D14
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0021, 0},	// 70003D16
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3910, 0},	// 70003D18
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x408A, 0},	// 70003D1A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x40A5, 0},	// 70003D1C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4FE4, 0},	// 70003D1E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0016, 0},	// 70003D20
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C10, 0},	// 70003D22
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA03, 0},	// 70003D24
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8839, 0},	// 70003D26
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43A9, 0},	// 70003D28
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8039, 0},	// 70003D2A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE002, 0},	// 70003D2C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8879, 0},	// 70003D2E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43B1, 0},	// 70003D30
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8079, 0},	// 70003D32
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003D34
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFBA0, 0},	// 70003D36
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C10, 0},	// 70003D38
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA03, 0},	// 70003D3A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8839, 0},	// 70003D3C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4329, 0},	// 70003D3E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8039, 0},	// 70003D40
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE002, 0},	// 70003D42
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8879, 0},	// 70003D44
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4331, 0},	// 70003D46
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8079, 0},	// 70003D48
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49DA, 0},	// 70003D4A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8809, 0},	// 70003D4C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2900, 0},	// 70003D4E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD102, 0},	// 70003D50
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003D52
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB99, 0},	// 70003D54
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 70003D56
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9902, 0},	// 70003D58
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6008, 0},	// 70003D5A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBCFE, 0},	// 70003D5C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 70003D5E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 70003D60
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB538, 0},	// 70003D62
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9C04, 0},	// 70003D64
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0015, 0},	// 70003D66
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70003D68
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9400, 0},	// 70003D6A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003D6C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB94, 0},	// 70003D6E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4AD1, 0},	// 70003D70
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8811, 0},	// 70003D72
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2900, 0},	// 70003D74
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD00F, 0},	// 70003D76
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8820, 0},	// 70003D78
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4281, 0},	// 70003D7A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD20C, 0},	// 70003D7C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8861, 0},	// 70003D7E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8853, 0},	// 70003D80
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4299, 0},	// 70003D82
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD200, 0},	// 70003D84
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1E40, 0},	// 70003D86
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003D88
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003D8A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8020, 0},	// 70003D8C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8851, 0},	// 70003D8E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8061, 0},	// 70003D90
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4368, 0},	// 70003D92
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1840, 0},	// 70003D94
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6060, 0},	// 70003D96
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC38, 0},	// 70003D98
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 70003D9A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 70003D9C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5F8, 0},	// 70003D9E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0004, 0},	// 70003DA0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6808, 0},	// 70003DA2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003DA4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003DA6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2201, 0},	// 70003DA8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0015, 0},	// 70003DAA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0021, 0},	// 70003DAC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3910, 0},	// 70003DAE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x408A, 0},	// 70003DB0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x40A5, 0},	// 70003DB2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4FBE, 0},	// 70003DB4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0016, 0},	// 70003DB6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C10, 0},	// 70003DB8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA03, 0},	// 70003DBA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8839, 0},	// 70003DBC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43A9, 0},	// 70003DBE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8039, 0},	// 70003DC0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE002, 0},	// 70003DC2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8879, 0},	// 70003DC4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43B1, 0},	// 70003DC6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8079, 0},	// 70003DC8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003DCA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB6D, 0},	// 70003DCC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C10, 0},	// 70003DCE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA03, 0},	// 70003DD0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8838, 0},	// 70003DD2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4328, 0},	// 70003DD4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8038, 0},	// 70003DD6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE002, 0},	// 70003DD8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8878, 0},	// 70003DDA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4330, 0},	// 70003DDC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8078, 0},	// 70003DDE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x48B6, 0},	// 70003DE0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8800, 0},	// 70003DE2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003DE4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD507, 0},	// 70003DE6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4BB5, 0},	// 70003DE8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7819, 0},	// 70003DEA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4AB5, 0},	// 70003DEC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7810, 0},	// 70003DEE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7018, 0},	// 70003DF0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7011, 0},	// 70003DF2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49B4, 0},	// 70003DF4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8188, 0},	// 70003DF6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBCF8, 0},	// 70003DF8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 70003DFA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 70003DFC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB538, 0},	// 70003DFE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x48B2, 0},	// 70003E00
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4669, 0},	// 70003E02
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003E04
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB58, 0},	// 70003E06
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x48B1, 0},	// 70003E08
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49B0, 0},	// 70003E0A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x69C2, 0},	// 70003E0C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2400, 0},	// 70003E0E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x31A8, 0},	// 70003E10
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2A00, 0},	// 70003E12
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD008, 0},	// 70003E14
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x61C4, 0},	// 70003E16
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x684A, 0},	// 70003E18
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6242, 0},	// 70003E1A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6282, 0},	// 70003E1C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x466B, 0},	// 70003E1E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x881A, 0},	// 70003E20
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6302, 0},	// 70003E22
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x885A, 0},	// 70003E24
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6342, 0},	// 70003E26
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6A02, 0},	// 70003E28
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2A00, 0},	// 70003E2A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD00A, 0},	// 70003E2C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6204, 0},	// 70003E2E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6849, 0},	// 70003E30
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6281, 0},	// 70003E32
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x466B, 0},	// 70003E34
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8819, 0},	// 70003E36
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6301, 0},	// 70003E38
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8859, 0},	// 70003E3A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6341, 0},	// 70003E3C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49A5, 0},	// 70003E3E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88C9, 0},	// 70003E40
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x63C1, 0},	// 70003E42
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003E44
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB40, 0},	// 70003E46
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE7A6, 0},	// 70003E48
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5F0, 0},	// 70003E4A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB08B, 0},	// 70003E4C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x20FF, 0},	// 70003E4E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1C40, 0},	// 70003E50
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49A1, 0},	// 70003E52
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x89CC, 0},	// 70003E54
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4E9E, 0},	// 70003E56
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6AB1, 0},	// 70003E58
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4284, 0},	// 70003E5A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD101, 0},	// 70003E5C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x489F, 0},	// 70003E5E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6081, 0},	// 70003E60
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6A70, 0},	// 70003E62
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0200, 0},	// 70003E64
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003E66
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB37, 0},	// 70003E68
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003E6A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003E6C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4A96, 0},	// 70003E6E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A11, 0},	// 70003E70
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9109, 0},	// 70003E72
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2101, 0},	// 70003E74
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0349, 0},	// 70003E76
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4288, 0},	// 70003E78
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD200, 0},	// 70003E7A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0001, 0},	// 70003E7C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4A92, 0},	// 70003E7E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8211, 0},	// 70003E80
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4D97, 0},	// 70003E82
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8829, 0},	// 70003E84
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9108, 0},	// 70003E86
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4A8B, 0},	// 70003E88
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2303, 0},	// 70003E8A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3222, 0},	// 70003E8C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1F91, 0},	// 70003E8E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003E90
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB28, 0},	// 70003E92
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8028, 0},	// 70003E94
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x488E, 0},	// 70003E96
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4987, 0},	// 70003E98
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6BC2, 0},	// 70003E9A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6AC0, 0},	// 70003E9C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4282, 0},	// 70003E9E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD201, 0},	// 70003EA0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8CC8, 0},	// 70003EA2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8028, 0},	// 70003EA4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88E8, 0},	// 70003EA6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9007, 0},	// 70003EA8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2240, 0},	// 70003EAA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4310, 0},	// 70003EAC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x80E8, 0},	// 70003EAE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 70003EB0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0041, 0},	// 70003EB2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x194B, 0},	// 70003EB4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x001E, 0},	// 70003EB6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3680, 0},	// 70003EB8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8BB2, 0},	// 70003EBA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xAF04, 0},	// 70003EBC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x527A, 0},	// 70003EBE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4A7D, 0},	// 70003EC0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x188A, 0},	// 70003EC2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8897, 0},	// 70003EC4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x83B7, 0},	// 70003EC6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x33A0, 0},	// 70003EC8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x891F, 0},	// 70003ECA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xAE01, 0},	// 70003ECC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5277, 0},	// 70003ECE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A11, 0},	// 70003ED0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8119, 0},	// 70003ED2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1C40, 0},	// 70003ED4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003ED6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003ED8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2806, 0},	// 70003EDA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD3E9, 0},	// 70003EDC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003EDE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB09, 0},	// 70003EE0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003EE2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFB0F, 0},	// 70003EE4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4F79, 0},	// 70003EE6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x37A8, 0},	// 70003EE8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 70003EEA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD10A, 0},	// 70003EEC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1FE0, 0},	// 70003EEE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x38FD, 0},	// 70003EF0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD001, 0},	// 70003EF2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1CC0, 0},	// 70003EF4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD105, 0},	// 70003EF6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4874, 0},	// 70003EF8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8829, 0},	// 70003EFA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3818, 0},	// 70003EFC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6840, 0},	// 70003EFE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4348, 0},	// 70003F00
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6078, 0},	// 70003F02
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4972, 0},	// 70003F04
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6878, 0},	// 70003F06
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6B89, 0},	// 70003F08
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4288, 0},	// 70003F0A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD300, 0},	// 70003F0C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0008, 0},	// 70003F0E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6078, 0},	// 70003F10
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 70003F12
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0041, 0},	// 70003F14
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xAA04, 0},	// 70003F16
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5A53, 0},	// 70003F18
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x194A, 0},	// 70003F1A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x269C, 0},	// 70003F1C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x52B3, 0},	// 70003F1E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xAB01, 0},	// 70003F20
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5A59, 0},	// 70003F22
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x32A0, 0},	// 70003F24
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8111, 0},	// 70003F26
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1C40, 0},	// 70003F28
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003F2A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003F2C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2806, 0},	// 70003F2E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD3F0, 0},	// 70003F30
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4965, 0},	// 70003F32
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9809, 0},	// 70003F34
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8208, 0},	// 70003F36
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9808, 0},	// 70003F38
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8028, 0},	// 70003F3A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9807, 0},	// 70003F3C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x80E8, 0},	// 70003F3E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1FE0, 0},	// 70003F40
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x38FD, 0},	// 70003F42
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD13B, 0},	// 70003F44
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4D64, 0},	// 70003F46
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x89E8, 0},	// 70003F48
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1FC1, 0},	// 70003F4A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x39FF, 0},	// 70003F4C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD136, 0},	// 70003F4E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4C5F, 0},	// 70003F50
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8AE0, 0},	// 70003F52
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003F54
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFADE, 0},	// 70003F56
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0006, 0},	// 70003F58
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8B20, 0},	// 70003F5A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003F5C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFAE2, 0},	// 70003F5E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9000, 0},	// 70003F60
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6AA1, 0},	// 70003F62
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6878, 0},	// 70003F64
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1809, 0},	// 70003F66
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0200, 0},	// 70003F68
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003F6A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFAB5, 0},	// 70003F6C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70003F6E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70003F70
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0022, 0},	// 70003F72
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3246, 0},	// 70003F74
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0011, 0},	// 70003F76
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x310A, 0},	// 70003F78
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2305, 0},	// 70003F7A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003F7C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFAB2, 0},	// 70003F7E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x66E8, 0},	// 70003F80
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6B23, 0},	// 70003F82
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0002, 0},	// 70003F84
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0031, 0},	// 70003F86
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0018, 0},	// 70003F88
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003F8A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFAD3, 0},	// 70003F8C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x466B, 0},	// 70003F8E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8518, 0},	// 70003F90
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6EEA, 0},	// 70003F92
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6B60, 0},	// 70003F94
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9900, 0},	// 70003F96
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003F98
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFACC, 0},	// 70003F9A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x466B, 0},	// 70003F9C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8558, 0},	// 70003F9E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0029, 0},	// 70003FA0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x980A, 0},	// 70003FA2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3170, 0},	// 70003FA4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003FA6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFACD, 0},	// 70003FA8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0028, 0},	// 70003FAA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3060, 0},	// 70003FAC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A02, 0},	// 70003FAE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4946, 0},	// 70003FB0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3128, 0},	// 70003FB2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x808A, 0},	// 70003FB4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A42, 0},	// 70003FB6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x80CA, 0},	// 70003FB8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A80, 0},	// 70003FBA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8108, 0},	// 70003FBC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB00B, 0},	// 70003FBE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBCF0, 0},	// 70003FC0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 70003FC2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 70003FC4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB570, 0},	// 70003FC6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2400, 0},	// 70003FC8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4D46, 0},	// 70003FCA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4846, 0},	// 70003FCC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8881, 0},	// 70003FCE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4846, 0},	// 70003FD0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8041, 0},	// 70003FD2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2101, 0},	// 70003FD4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8001, 0},	// 70003FD6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003FD8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFABC, 0},	// 70003FDA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4842, 0},	// 70003FDC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3820, 0},	// 70003FDE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8BC0, 0},	// 70003FE0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70003FE2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFABF, 0},	// 70003FE4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4B42, 0},	// 70003FE6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x220D, 0},	// 70003FE8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0712, 0},	// 70003FEA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x18A8, 0},	// 70003FEC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8806, 0},	// 70003FEE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x00E1, 0},	// 70003FF0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x18C9, 0},	// 70003FF2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x81CE, 0},	// 70003FF4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8846, 0},	// 70003FF6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x818E, 0},	// 70003FF8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8886, 0},	// 70003FFA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x824E, 0},	// 70003FFC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88C0, 0},	// 70003FFE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8208, 0},	// 70004000
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3508, 0},	// 70004002
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x042D, 0},	// 70004004
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C2D, 0},	// 70004006
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1C64, 0},	// 70004008
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0424, 0},	// 7000400A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C24, 0},	// 7000400C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C07, 0},	// 7000400E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD3EC, 0},	// 70004010
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE658, 0},	// 70004012
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB510, 0},	// 70004014
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4834, 0},	// 70004016
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4C34, 0},	// 70004018
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88C0, 0},	// 7000401A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8060, 0},	// 7000401C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2001, 0},	// 7000401E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8020, 0},	// 70004020
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4831, 0},	// 70004022
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3820, 0},	// 70004024
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8BC0, 0},	// 70004026
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004028
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFA9C, 0},	// 7000402A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88E0, 0},	// 7000402C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4A31, 0},	// 7000402E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 70004030
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD003, 0},	// 70004032
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4930, 0},	// 70004034
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8849, 0},	// 70004036
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2900, 0},	// 70004038
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD009, 0},	// 7000403A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2001, 0},	// 7000403C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x03C0, 0},	// 7000403E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8050, 0},	// 70004040
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x80D0, 0},	// 70004042
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 70004044
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8090, 0},	// 70004046
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8110, 0},	// 70004048
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC10, 0},	// 7000404A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 7000404C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 7000404E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8050, 0},	// 70004050
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8920, 0},	// 70004052
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x80D0, 0},	// 70004054
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8960, 0},	// 70004056
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70004058
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1400, 0},	// 7000405A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8090, 0},	// 7000405C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x89A1, 0},	// 7000405E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0409, 0},	// 70004060
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1409, 0},	// 70004062
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8111, 0},	// 70004064
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x89E3, 0},	// 70004066
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A24, 0},	// 70004068
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2B00, 0},	// 7000406A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD104, 0},	// 7000406C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x17C3, 0},	// 7000406E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0F5B, 0},	// 70004070
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1818, 0},	// 70004072
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x10C0, 0},	// 70004074
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8090, 0},	// 70004076
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C00, 0},	// 70004078
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD1E6, 0},	// 7000407A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x17C8, 0},	// 7000407C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0F40, 0},	// 7000407E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1840, 0},	// 70004080
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x10C0, 0},	// 70004082
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8110, 0},	// 70004084
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE7E0, 0},	// 70004086
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB510, 0},	// 70004088
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000C, 0},	// 7000408A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4919, 0},	// 7000408C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2204, 0},	// 7000408E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6820, 0},	// 70004090
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5E8A, 0},	// 70004092
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0140, 0},	// 70004094
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1A80, 0},	// 70004096
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0280, 0},	// 70004098
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8849, 0},	// 7000409A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 7000409C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFA6A, 0},	// 7000409E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6020, 0},	// 700040A0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE7D2, 0},	// 700040A2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x38D4, 0},	// 700040A4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040A6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x17D0, 0},	// 700040A8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040AA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5000, 0},	// 700040AC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD000, 0},	// 700040AE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1100, 0},	// 700040B0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD000, 0},	// 700040B2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x171A, 0},	// 700040B4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040B6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4780, 0},	// 700040B8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040BA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2FCA, 0},	// 700040BC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040BE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2FC5, 0},	// 700040C0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040C2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2FC6, 0},	// 700040C4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040C6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2ED8, 0},	// 700040C8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040CA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2BD0, 0},	// 700040CC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040CE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x17E0, 0},	// 700040D0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040D2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2DE8, 0},	// 700040D4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040D6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x37E0, 0},	// 700040D8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040DA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x210C, 0},	// 700040DC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040DE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1484, 0},	// 700040E0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040E2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xA006, 0},	// 700040E4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700040E6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0724, 0},	// 700040E8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040EA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xA000, 0},	// 700040EC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD000, 0},	// 700040EE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2270, 0},	// 700040F0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040F2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2558, 0},	// 700040F4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040F6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x146C, 0},	// 700040F8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 700040FA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB510, 0},	// 700040FC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000C, 0},	// 700040FE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49C7, 0},	// 70004100
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2208, 0},	// 70004102
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6820, 0},	// 70004104
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5E8A, 0},	// 70004106
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0140, 0},	// 70004108
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1A80, 0},	// 7000410A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0280, 0},	// 7000410C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88C9, 0},	// 7000410E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004110
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFA30, 0},	// 70004112
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6020, 0},	// 70004114
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE798, 0},	// 70004116
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5FE, 0},	// 70004118
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000C, 0},	// 7000411A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6825, 0},	// 7000411C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6866, 0},	// 7000411E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x68A0, 0},	// 70004120
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9001, 0},	// 70004122
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x68E7, 0},	// 70004124
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1BA8, 0},	// 70004126
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x42B5, 0},	// 70004128
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA00, 0},	// 7000412A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1B70, 0},	// 7000412C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9000, 0},	// 7000412E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49BB, 0},	// 70004130
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x48BC, 0},	// 70004132
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x884A, 0},	// 70004134
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8843, 0},	// 70004136
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x435A, 0},	// 70004138
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2304, 0},	// 7000413A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5ECB, 0},	// 7000413C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0A92, 0},	// 7000413E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x18D2, 0},	// 70004140
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x02D2, 0},	// 70004142
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C12, 0},	// 70004144
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88CB, 0},	// 70004146
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8880, 0},	// 70004148
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4343, 0},	// 7000414A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0A98, 0},	// 7000414C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2308, 0},	// 7000414E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5ECB, 0},	// 70004150
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x18C0, 0},	// 70004152
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x02C0, 0},	// 70004154
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70004156
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0411, 0},	// 70004158
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 7000415A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1409, 0},	// 7000415C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1400, 0},	// 7000415E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1A08, 0},	// 70004160
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x49B0, 0},	// 70004162
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x39E0, 0},	// 70004164
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6148, 0},	// 70004166
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9801, 0},	// 70004168
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3040, 0},	// 7000416A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7880, 0},	// 7000416C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 7000416E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD103, 0},	// 70004170
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9801, 0},	// 70004172
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0029, 0},	// 70004174
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004176
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFA03, 0},	// 70004178
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8839, 0},	// 7000417A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9800, 0},	// 7000417C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4281, 0},	// 7000417E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD814, 0},	// 70004180
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8879, 0},	// 70004182
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9800, 0},	// 70004184
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4281, 0},	// 70004186
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD20C, 0},	// 70004188
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9801, 0},	// 7000418A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0029, 0},	// 7000418C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 7000418E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9FF, 0},	// 70004190
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9801, 0},	// 70004192
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0029, 0},	// 70004194
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004196
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9FB, 0},	// 70004198
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9801, 0},	// 7000419A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0029, 0},	// 7000419C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 7000419E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9F7, 0},	// 700041A0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE003, 0},	// 700041A2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9801, 0},	// 700041A4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0029, 0},	// 700041A6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700041A8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9F2, 0},	// 700041AA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9801, 0},	// 700041AC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0032, 0},	// 700041AE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0039, 0},	// 700041B0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700041B2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9F5, 0},	// 700041B4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6020, 0},	// 700041B6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE5D0, 0},	// 700041B8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB57C, 0},	// 700041BA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x489A, 0},	// 700041BC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xA901, 0},	// 700041BE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0004, 0},	// 700041C0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700041C2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF979, 0},	// 700041C4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x466B, 0},	// 700041C6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88D9, 0},	// 700041C8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8898, 0},	// 700041CA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4B95, 0},	// 700041CC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3346, 0},	// 700041CE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1E9A, 0},	// 700041D0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700041D2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9ED, 0},	// 700041D4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4894, 0},	// 700041D6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4992, 0},	// 700041D8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3812, 0},	// 700041DA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3140, 0},	// 700041DC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A42, 0},	// 700041DE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x888B, 0},	// 700041E0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x18D2, 0},	// 700041E2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8242, 0},	// 700041E4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8AC2, 0},	// 700041E6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88C9, 0},	// 700041E8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1851, 0},	// 700041EA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x82C1, 0},	// 700041EC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0020, 0},	// 700041EE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4669, 0},	// 700041F0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700041F2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF961, 0},	// 700041F4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x488D, 0},	// 700041F6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x214D, 0},	// 700041F8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8301, 0},	// 700041FA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2196, 0},	// 700041FC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8381, 0},	// 700041FE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x211D, 0},	// 70004200
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3020, 0},	// 70004202
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8001, 0},	// 70004204
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004206
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9DB, 0},	// 70004208
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 7000420A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9E1, 0},	// 7000420C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4888, 0},	// 7000420E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4C88, 0},	// 70004210
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6E00, 0},	// 70004212
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x60E0, 0},	// 70004214
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x466B, 0},	// 70004216
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8818, 0},	// 70004218
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8859, 0},	// 7000421A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0025, 0},	// 7000421C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1A40, 0},	// 7000421E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3540, 0},	// 70004220
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x61A8, 0},	// 70004222
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x487F, 0},	// 70004224
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9900, 0},	// 70004226
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3060, 0},	// 70004228
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 7000422A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF9D9, 0},	// 7000422C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x466B, 0},	// 7000422E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8819, 0},	// 70004230
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1DE0, 0},	// 70004232
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x30F9, 0},	// 70004234
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8741, 0},	// 70004236
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8859, 0},	// 70004238
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8781, 0},	// 7000423A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 7000423C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x71A0, 0},	// 7000423E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x74A8, 0},	// 70004240
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC7C, 0},	// 70004242
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xBC08, 0},	// 70004244
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4718, 0},	// 70004246
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5F8, 0},	// 70004248
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0005, 0},	// 7000424A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6808, 0},	// 7000424C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 7000424E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70004250
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x684A, 0},	// 70004252
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0412, 0},	// 70004254
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C12, 0},	// 70004256
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x688E, 0},	// 70004258
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x68CC, 0},	// 7000425A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4970, 0},	// 7000425C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x884B, 0},	// 7000425E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4343, 0},	// 70004260
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0A98, 0},	// 70004262
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2304, 0},	// 70004264
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5ECB, 0},	// 70004266
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x18C0, 0},	// 70004268
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x02C0, 0},	// 7000426A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 7000426C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88CB, 0},	// 7000426E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4353, 0},	// 70004270
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0A9A, 0},	// 70004272
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2308, 0},	// 70004274
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5ECB, 0},	// 70004276
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x18D1, 0},	// 70004278
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x02C9, 0},	// 7000427A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C09, 0},	// 7000427C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2701, 0},	// 7000427E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x003A, 0},	// 70004280
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x40AA, 0},	// 70004282
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9200, 0},	// 70004284
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x002A, 0},	// 70004286
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3A10, 0},	// 70004288
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4097, 0},	// 7000428A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2D10, 0},	// 7000428C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA06, 0},	// 7000428E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4A69, 0},	// 70004290
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9B00, 0},	// 70004292
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8812, 0},	// 70004294
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x439A, 0},	// 70004296
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4B67, 0},	// 70004298
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x801A, 0},	// 7000429A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE003, 0},	// 7000429C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4B66, 0},	// 7000429E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x885A, 0},	// 700042A0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43BA, 0},	// 700042A2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x805A, 0},	// 700042A4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0023, 0},	// 700042A6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0032, 0},	// 700042A8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700042AA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF981, 0},	// 700042AC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2D10, 0},	// 700042AE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA05, 0},	// 700042B0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4961, 0},	// 700042B2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x9A00, 0},	// 700042B4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8808, 0},	// 700042B6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4310, 0},	// 700042B8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8008, 0},	// 700042BA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE003, 0},	// 700042BC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x485E, 0},	// 700042BE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8841, 0},	// 700042C0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4339, 0},	// 700042C2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8041, 0},	// 700042C4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4D5B, 0},	// 700042C6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 700042C8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3580, 0},	// 700042CA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88AA, 0},	// 700042CC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5E30, 0},	// 700042CE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2100, 0},	// 700042D0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700042D2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF98D, 0},	// 700042D4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8030, 0},	// 700042D6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 700042D8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x88AA, 0},	// 700042DA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x5E20, 0},	// 700042DC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2100, 0},	// 700042DE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700042E0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF986, 0},	// 700042E2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8020, 0},	// 700042E4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE587, 0},	// 700042E6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB510, 0},	// 700042E8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700042EA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF989, 0},	// 700042EC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4A53, 0},	// 700042EE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8D50, 0},	// 700042F0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 700042F2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD007, 0},	// 700042F4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x494E, 0},	// 700042F6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x31C0, 0},	// 700042F8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x684B, 0},	// 700042FA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4950, 0},	// 700042FC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4283, 0},	// 700042FE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD202, 0},	// 70004300
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8D90, 0},	// 70004302
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x81C8, 0},	// 70004304
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE6A0, 0},	// 70004306
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8DD0, 0},	// 70004308
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x81C8, 0},	// 7000430A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE69D, 0},	// 7000430C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5F8, 0},	// 7000430E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004310
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF97E, 0},	// 70004312
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4D49, 0},	// 70004314
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8E28, 0},	// 70004316
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 70004318
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD01F, 0},	// 7000431A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4E49, 0},	// 7000431C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4844, 0},	// 7000431E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x68B4, 0},	// 70004320
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6800, 0},	// 70004322
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4284, 0},	// 70004324
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD903, 0},	// 70004326
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1A21, 0},	// 70004328
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0849, 0},	// 7000432A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1847, 0},	// 7000432C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE006, 0},	// 7000432E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4284, 0},	// 70004330
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD203, 0},	// 70004332
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1B01, 0},	// 70004334
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0849, 0},	// 70004336
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1A47, 0},	// 70004338
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE000, 0},	// 7000433A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0027, 0},	// 7000433C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0020, 0},	// 7000433E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x493B, 0},	// 70004340
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3120, 0},	// 70004342
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7A0C, 0},	// 70004344
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C00, 0},	// 70004346
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD004, 0},	// 70004348
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0200, 0},	// 7000434A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0039, 0},	// 7000434C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 7000434E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF8C3, 0},	// 70004350
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8668, 0},	// 70004352
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C00, 0},	// 70004354
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD000, 0},	// 70004356
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x60B7, 0},	// 70004358
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE54D, 0},	// 7000435A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x20FF, 0},	// 7000435C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1C40, 0},	// 7000435E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8668, 0},	// 70004360
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE549, 0},	// 70004362
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB510, 0},	// 70004364
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000C, 0},	// 70004366
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6820, 0},	// 70004368
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 7000436A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 7000436C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4933, 0},	// 7000436E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8E0A, 0},	// 70004370
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2A00, 0},	// 70004372
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD003, 0},	// 70004374
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8E49, 0},	// 70004376
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0200, 0},	// 70004378
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 7000437A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF8AD, 0},	// 7000437C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6020, 0},	// 7000437E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0400, 0},	// 70004380
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0C00, 0},	// 70004382
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE661, 0},	// 70004384
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB570, 0},	// 70004386
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x680C, 0},	// 70004388
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4D2F, 0},	// 7000438A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0020, 0},	// 7000438C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6F29, 0},	// 7000438E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004390
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF946, 0},	// 70004392
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6F69, 0},	// 70004394
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1D20, 0},	// 70004396
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004398
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF942, 0},	// 7000439A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4827, 0},	// 7000439C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8E00, 0},	// 7000439E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 700043A0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD006, 0},	// 700043A2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4922, 0},	// 700043A4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2214, 0},	// 700043A6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3168, 0},	// 700043A8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0008, 0},	// 700043AA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x383C, 0},	// 700043AC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700043AE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF93F, 0},	// 700043B0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE488, 0},	// 700043B2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB5F8, 0},	// 700043B4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0004, 0},	// 700043B6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4D24, 0},	// 700043B8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8B68, 0},	// 700043BA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 700043BC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD012, 0},	// 700043BE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4823, 0},	// 700043C0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8A00, 0},	// 700043C2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x06C0, 0},	// 700043C4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD50E, 0},	// 700043C6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4822, 0},	// 700043C8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7800, 0},	// 700043CA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2800, 0},	// 700043CC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD00A, 0},	// 700043CE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x481D, 0},	// 700043D0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6FC1, 0},	// 700043D2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2000, 0},	// 700043D4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700043D6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF923, 0},	// 700043D8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8B28, 0},	// 700043DA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2201, 0},	// 700043DC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2180, 0},	// 700043DE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 700043E0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF92C, 0},	// 700043E2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8328, 0},	// 700043E4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2101, 0},	// 700043E6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000D, 0},	// 700043E8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0020, 0},	// 700043EA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3810, 0},	// 700043EC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4081, 0},	// 700043EE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x40A5, 0},	// 700043F0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4F11, 0},	// 700043F2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x000E, 0},	// 700043F4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C10, 0},	// 700043F6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA03, 0},	// 700043F8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8838, 0},	// 700043FA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43A8, 0},	// 700043FC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8038, 0},	// 700043FE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE002, 0},	// 70004400
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8878, 0},	// 70004402
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x43B0, 0},	// 70004404
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8078, 0},	// 70004406
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF000, 0},	// 70004408
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF920, 0},	// 7000440A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2C10, 0},	// 7000440C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xDA03, 0},	// 7000440E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8838, 0},	// 70004410
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4328, 0},	// 70004412
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8038, 0},	// 70004414
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE4EF, 0},	// 70004416
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8878, 0},	// 70004418
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4330, 0},	// 7000441A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8078, 0},	// 7000441C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE4EB, 0},	// 7000441E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2558, 0},	// 70004420
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70004422
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2AB8, 0},	// 70004424
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70004426
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x145E, 0},	// 70004428
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 7000442A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2698, 0},	// 7000442C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 7000442E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2BB8, 0},	// 70004430
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70004432
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2998, 0},	// 70004434
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70004436
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1100, 0},	// 70004438
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD000, 0},	// 7000443A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4780, 0},	// 7000443C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 7000443E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE200, 0},	// 70004440
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD000, 0},	// 70004442
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x210C, 0},	// 70004444
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70004446
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004448
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 7000444A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x308C, 0},	// 7000444C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 7000444E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB040, 0},	// 70004450
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xD000, 0},	// 70004452
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3858, 0},	// 70004454
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7000, 0},	// 70004456
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004458
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 7000445A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 7000445C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000445E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004460
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 70004462
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x1789, 0},	// 70004464
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0001, 0},	// 70004466
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004468
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 7000446A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 7000446C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000446E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004470
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 70004472
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x16F1, 0},	// 70004474
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0001, 0},	// 70004476
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004478
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 7000447A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 7000447C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000447E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004480
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 70004482
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC3B1, 0},	// 70004484
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004486
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004488
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 7000448A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 7000448C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000448E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004490
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 70004492
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC36D, 0},	// 70004494
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004496
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004498
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 7000449A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 7000449C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000449E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700044A0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700044A2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF6D7, 0},	// 700044A4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700044A6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700044A8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700044AA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700044AC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700044AE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700044B0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700044B2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xB49D, 0},	// 700044B4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700044B6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700044B8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700044BA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700044BC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700044BE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700044C0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700044C2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7EDF, 0},	// 700044C4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700044C6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700044C8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700044CA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700044CC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700044CE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700044D0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700044D2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x448D, 0},	// 700044D4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700044D6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700044D8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700044DA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF004, 0},	// 700044DC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE51F, 0},	// 700044DE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x29EC, 0},	// 700044E0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0001, 0},	// 700044E2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700044E4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700044E6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700044E8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700044EA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700044EC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700044EE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2EF1, 0},	// 700044F0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700044F2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700044F4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700044F6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700044F8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700044FA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700044FC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700044FE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xEE03, 0},	// 70004500
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004502
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004504
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004506
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004508
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000450A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 7000450C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000450E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xA58B, 0},	// 70004510
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004512
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004514
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004516
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004518
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000451A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 7000451C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000451E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7C49, 0},	// 70004520
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004522
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004524
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004526
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004528
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000452A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 7000452C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000452E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7C63, 0},	// 70004530
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004532
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004534
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004536
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004538
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000453A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 7000453C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000453E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2DB7, 0},	// 70004540
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004542
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004544
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004546
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004548
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000454A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 7000454C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000454E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xEB3D, 0},	// 70004550
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004552
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004554
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004556
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004558
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000455A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 7000455C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000455E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF061, 0},	// 70004560
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004562
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004564
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004566
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004568
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 7000456A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 7000456C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000456E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF0EF, 0},	// 70004570
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 70004572
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004574
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004576
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF004, 0},	// 70004578
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE51F, 0},	// 7000457A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x2824, 0},	// 7000457C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0001, 0},	// 7000457E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004580
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004582
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004584
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 70004586
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004588
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000458A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8EDD, 0},	// 7000458C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 7000458E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004590
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004592
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004594
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 70004596
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004598
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000459A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8DCB, 0},	// 7000459C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 7000459E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700045A0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700045A2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700045A4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700045A6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700045A8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700045AA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x8E17, 0},	// 700045AC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700045AE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700045B0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700045B2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700045B4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700045B6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700045B8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700045BA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x98C5, 0},	// 700045BC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700045BE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700045C0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700045C2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700045C4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700045C6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700045C8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700045CA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7C7D, 0},	// 700045CC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700045CE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700045D0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700045D2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700045D4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700045D6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700045D8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700045DA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7E31, 0},	// 700045DC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700045DE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700045E0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700045E2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700045E4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700045E6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700045E8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700045EA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7EAB, 0},	// 700045EC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700045EE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 700045F0
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 700045F2
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 700045F4
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 700045F6
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 700045F8
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 700045FA
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x7501, 0},	// 700045FC
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 700045FE
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004600
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004602
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004604
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 70004606
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004608
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000460A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF63F, 0},	// 7000460C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 7000460E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004610
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004612
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004614
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 70004616
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004618
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000461A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x3D0B, 0},	// 7000461C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 7000461E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004620
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004622
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004624
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 70004626
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004628
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 7000462A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x29BF, 0},	// 7000462C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0001, 0},	// 7000462E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 70004630
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 70004632
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xF004, 0},	// 70004634
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE51F, 0},	// 70004636
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x26D8, 0},	// 70004638
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0001, 0},	// 7000463A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 7000463C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 7000463E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004640
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 70004642
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004644
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 70004646
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x306B, 0},	// 70004648
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 7000464A
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x4778, 0},	// 7000464C
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x46C0, 0},	// 7000464E
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xC000, 0},	// 70004650
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE59F, 0},	// 70004652
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xFF1C, 0},	// 70004654
{SI2C_BWR, SI2C_A2D2,0x0F12, 0xE12F, 0},	// 70004656
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x6099, 0},	// 70004658
{SI2C_BWR, SI2C_A2D2,0x0F12, 0x0000, 0},	// 7000465A // End of Patch Data

{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0722, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //skl_OTP_usWaitTime This register should be positioned in fornt of D0001000
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0726, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //skl_bUseOTPfunc This is OTP on/off function
{SI2C_WR, SI2C_A2D2, 0x002A, 0x08D6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //ash_bUseOTPData
{SI2C_WR, SI2C_A2D2, 0x002A, 0x146E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_otp_disable
{SI2C_WR, SI2C_A2D2, 0x002A, 0x08DC, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //ash_bUseGasAlphaOTP

{SI2C_WR, SI2C_A2D2, 0x0028, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},

{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x08B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //wbt_bUseOutdoorASH
{SI2C_WR, SI2C_A2D2, 0x002A, 0x08BC, 0},

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00AB, 0}, //TVAR_ash_AwbAshCord_0_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0}, //TVAR_ash_AwbAshCord_1_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //TVAR_ash_AwbAshCord_2_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0125, 0}, //TVAR_ash_AwbAshCord_3_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x015F, 0}, //TVAR_ash_AwbAshCord_4_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0170, 0}, //TVAR_ash_AwbAshCord_5_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01C0, 0}, //TVAR_ash_AwbAshCord_6_ 

{SI2C_WR, SI2C_A2D2, 0x002A, 0x08F6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5300, 0}, //TVAR_ash_GASAlpha_0__0_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_0__1_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_0__2_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3900, 0}, //TVAR_ash_GASAlpha_0__3_ 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5200, 0}, //TVAR_ash_GASAlpha_1__0_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_1__1_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_1__2_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_1__3_ 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5000, 0}, //TVAR_ash_GASAlpha_2__0_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_2__1_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_2__2_ 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4200, 0}, //TVAR_ash_GASAlpha_2__3_ 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_3__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_3__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_3__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_3__3_

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_4__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_4__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_4__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_4__3_

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_5__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_5__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_5__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_5__3_

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_6__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_6__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_6__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0}, //TVAR_ash_GASAlpha_6__3_

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4A00, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x08F4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //ash_bUseGasAlpha

{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x18BC, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05B6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05BA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0007, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05BA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x024E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05B6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05BA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x024F, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0075, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00CF, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0075, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00F0, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x029E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05B2, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F8, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0228, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0208, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0238, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0218, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0238, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0009, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00DE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05C0, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00DF, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00E4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F8, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01FD, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05B6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05BB, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F8, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0077, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x007E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x024F, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x025E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09D1, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09D5, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09D5, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0326, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09D1, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09D5, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0327, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0084, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x008D, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00AA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03AD, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09CD, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02DE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02BE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02EE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02CE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02EE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0009, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0095, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09DB, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0096, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x009B, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02B3, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09D1, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x09D6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02AE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0009, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0327, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0336, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1AF8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x5A3C, 0}, //senHal_TuneStr_AngTuneData1_2_D000F400 register at subsampling
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1896, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //senHal_SamplingType	0002 03EE: PLA setting
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //senHal_SamplingMode 0 : 2 PLA / 1 : 4PLA
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0}, //senHal_PLAOption	[0] VPLA enable  [1] HPLA enable
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1B00, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xF428, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x189E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0FB0, 0}, //senHal_ExpMinPixels
{SI2C_WR, SI2C_A2D2, 0x002A, 0x18AC, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0}, //senHal_uAddColsBin
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0}, //senHal_uAddColsNoBin
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05C0, 0}, //senHal_uMinColsBin
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05C0, 0}, //senHal_uMinColsNoBin
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1AEA, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8080, 0}, //senHal_SubF404Tune
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0}, //senHal_FullF404Tune
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1AE0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //senHal_bSenAAC
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1A72, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //senHal_bSRX	SRX off
{SI2C_WR, SI2C_A2D2, 0x002A, 0x18A2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0004, 0}, //senHal_NExpLinesCheckFine extend Forbidden area line
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1A6A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x009A, 0}, //senHal_usForbiddenRightOfs extend right Forbidden area line
{SI2C_WR, SI2C_A2D2, 0x002A, 0x385E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x024C, 0}, //Mon_Sen_uExpPixelsOfs
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0EE6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //setot_bUseDigitalHbin
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1B2A, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0}, //senHal_TuneStr2_usAngTuneGainTh
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D6, 0}, //senHal_TuneStr2_AngTuneF4CA_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x008D, 0}, //senHal_TuneStr2_AngTuneF4CA_1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00CF, 0}, //senHal_TuneStr2_AngTuneF4C2_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0084, 0}, //senHal_TuneStr2_AngTuneF4C2_1_

{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x01FC, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_IPRM_LedGpio
{SI2C_WR, SI2C_A2D2, 0x002A, 0x01FE, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0}, //REG_TC_IPRM_CM_Init_AfModeType VCM IIC
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_IPRM_CM_Init_PwmConfig1
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0204, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0061, 0}, //REG_TC_IPRM_CM_Init_GpioConfig1 AF Enable GPIO 6
{SI2C_WR, SI2C_A2D2, 0x002A, 0x020C, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2F0C, 0}, //REG_TC_IPRM_CM_Init_Mi2cBits
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0190, 0}, //REG_TC_IPRM_CM_Init_Mi2cRateKhz IIC Speed

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0294, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //REG_TC_AF_FstWinStartX
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00E3, 0}, //REG_TC_AF_FstWinStartY
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0200, 0}, //REG_TC_AF_FstWinSizeX
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0238, 0}, //REG_TC_AF_FstWinSizeY
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01C6, 0}, //REG_TC_AF_ScndWinStartX
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0166, 0}, //REG_TC_AF_ScndWinStartY
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0074, 0}, //REG_TC_AF_ScndWinSizeX
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0132, 0}, //REG_TC_AF_ScndWinSizeY
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_AF_WinSizesUpdated

{SI2C_WR, SI2C_A2D2, 0x002A, 0x070E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00C0, 0}, //skl_af_StatOvlpExpFactor

{SI2C_WR, SI2C_A2D2, 0x002A, 0x071E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //skl_af_bAfStatOff
{SI2C_WR, SI2C_A2D2, 0x002A, 0x163C, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //af_search_usAeStable
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1648, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x9002, 0}, //af_search_usSingleAfFlags
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1652, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //af_search_usFinePeakCount
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //af_search_usFineMaxScale
{SI2C_WR, SI2C_A2D2, 0x002A, 0x15E0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0902, 0}, //af_pos_usFineStepNumSize

{SI2C_WR, SI2C_A2D2, 0x002A, 0x164C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0003, 0}, //af_search_usMinPeakSamples
{SI2C_WR, SI2C_A2D2, 0x002A, 0x163E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00E5, 0}, //af_search_usPeakThr Full search (E5 90%)
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0098, 0}, //af_search_usPeakThrLow
{SI2C_WR, SI2C_A2D2, 0x002A, 0x15D4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //af_pos_usHomePos
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xD000, 0}, //af_pos_usLowConfPos
{SI2C_WR, SI2C_A2D2, 0x002A, 0x169A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xFF95, 0}, //af_search_usConfCheckOrder_1_
{SI2C_WR, SI2C_A2D2, 0x002A, 0x166A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0280, 0}, //af_search_usConfThr_4_
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1676, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03A0, 0}, //af_search_usConfThr_10_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0320, 0}, //af_search_usConfThr_11_
{SI2C_WR, SI2C_A2D2, 0x002A, 0x16BC, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0030, 0}, //af_stat_usMinStatVal
{SI2C_WR, SI2C_A2D2, 0x002A, 0x16E0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0060, 0}, //af_scene_usSceneLowNormBrThr
{SI2C_WR, SI2C_A2D2, 0x002A, 0x16D4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0010, 0}, //af_stat_usBpfThresh
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1656, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //af_search_usCapturePolicy
{SI2C_WR, SI2C_A2D2, 0x002A, 0x15E6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x003C, 0}, //af_pos_usCaptureFixedPos

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0007, 0}, //af_pos_usTableLastInd
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000A, 0}, //af_pos_usTable_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x001E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0032, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0044, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0055, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0078, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0091, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00B4, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1722, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8000, 0}, //afd_usParam_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0006, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3FF0, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03E8, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00E0, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x028C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0003, 0}, //REG_TC_AF_AfCmd

{SI2C_WR, SI2C_A2D2, 0x002A, 0x145E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0582, 0}, //awbb_GainsInit_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0400, 0}, //awbb_GainsInit_1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0701, 0}, //awbb_GainsInit_2_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1464, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0}, //awbb_WpFilterMinThr
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0190, 0}, //awbb_WpFilterMaxThr

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00F0, 0}, //awbb_WpFilterCoef
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0}, //awbb_WpFilterSize
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //awbb_GridEnable

{SI2C_WR, SI2C_A2D2, 0x002A, 0x144E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_RGainOff
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_BGainOff
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_GGainOff
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C2, 0}, //awbb_Alpha_Comp_Mode
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //awbb_Rpl_InvalidOutDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //awbb_UseGrThrCorr

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0074, 0}, //awbb_Use_Filters
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //awbb_CorrectMinNumPatches

{SI2C_WR, SI2C_A2D2, 0x002A, 0x11F0, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x012C, 0}, //awbb_IntcR
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0121, 0}, //awbb_IntcB
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02DF, 0}, //awbb_GLocusR
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0314, 0}, //awbb_GLocusB


{SI2C_WR, SI2C_A2D2, 0x002A, 0x120E, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_MovingScale10
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x05FD, 0}, //awbb_GamutWidthThr1
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x036B, 0}, //awbb_GamutHeightThr1
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0}, //awbb_GamutWidthThr2
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x001A, 0}, //awbb_GamutHeightThr2

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1278, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEF7, 0}, //awbb_SCDetectionMap_SEC_StartR_B
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0021, 0}, //awbb_SCDetectionMap_SEC_StepR_B
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0FA0, 0}, //awbb_SCDetectionMap_SEC_SunnyNB
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x07D0, 0}, //awbb_SCDetectionMap_SEC_StepNB
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01C8, 0}, //awbb_SCDetectionMap_SEC_LowTempR_B
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0096, 0}, //awbb_SCDetectionMap_SEC_SunnyNBZone
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0}, //awbb_SCDetectionMap_SEC_LowTempR_BZone

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1224, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0032, 0}, //awbb_LowBr
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x001E, 0}, //awbb_LowBr_NBzone
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00E2, 0}, //awbb_YThreshHigh
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0}, //awbb_YThreshLow_Norm 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //awbb_YThreshLow_Low

{SI2C_WR, SI2C_A2D2, 0x002A, 0x2BA4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0006, 0}, //Mon_AWB_ByPassMode

{SI2C_WR, SI2C_A2D2, 0x002A, 0x11FC, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000C, 0}, //awbb_MinNumOfFinalPatches

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1208, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0020, 0}, //awbb_MinNumOfChromaclassifpatches

{SI2C_WR, SI2C_A2D2, 0x002A, 0x101C, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0370, 0},	//awbb_IndoorGrZones_m_BGrid_0__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03C6, 0},	//awbb_IndoorGrZones_m_BGrid_0__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x034E, 0},	//awbb_IndoorGrZones_m_BGrid_1__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03DE, 0},	//awbb_IndoorGrZones_m_BGrid_1__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0328, 0},	//awbb_IndoorGrZones_m_BGrid_2__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03E0, 0},	//awbb_IndoorGrZones_m_BGrid_2__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E2, 0},	//awbb_IndoorGrZones_m_BGrid_3__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03CE, 0},	//awbb_IndoorGrZones_m_BGrid_3__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x027C, 0},	//awbb_IndoorGrZones_m_BGrid_4__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03AA, 0},	//awbb_IndoorGrZones_m_BGrid_4__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0248, 0},	//awbb_IndoorGrZones_m_BGrid_5__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0380, 0},	//awbb_IndoorGrZones_m_BGrid_5__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0224, 0},	//awbb_IndoorGrZones_m_BGrid_6__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x034E, 0},	//awbb_IndoorGrZones_m_BGrid_6__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0216, 0},	//awbb_IndoorGrZones_m_BGrid_7__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x031A, 0},	//awbb_IndoorGrZones_m_BGrid_7__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0210, 0},	//awbb_IndoorGrZones_m_BGrid_8__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02FA, 0},	//awbb_IndoorGrZones_m_BGrid_8__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//awbb_IndoorGrZones_m_BGrid_9__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02EC, 0},	//awbb_IndoorGrZones_m_BGrid_9__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F2, 0},	//awbb_IndoorGrZones_m_BGrid_10__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E0, 0},	//awbb_IndoorGrZones_m_BGrid_10__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01E4, 0},	//awbb_IndoorGrZones_m_BGrid_11__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02DC, 0},	//awbb_IndoorGrZones_m_BGrid_11__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01DC, 0},	//awbb_IndoorGrZones_m_BGrid_12__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02D2, 0},	//awbb_IndoorGrZones_m_BGrid_12__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01D6, 0},	//awbb_IndoorGrZones_m_BGrid_13__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02BE, 0},	//awbb_IndoorGrZones_m_BGrid_13__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01E0, 0},	//awbb_IndoorGrZones_m_BGrid_14__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x029A, 0},	//awbb_IndoorGrZones_m_BGrid_14__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_15__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_15__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_16__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_16__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_17__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_17__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_18__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_18__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_19__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_IndoorGrZones_m_BGrid_19__m_right


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1070, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0013, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1074, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00EC, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1078, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x028C, 0},	//awbb_OutdoorGrZones_m_BGrid_0__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02C0, 0},	//awbb_OutdoorGrZones_m_BGrid_0__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0250, 0},	//awbb_OutdoorGrZones_m_BGrid_1__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E8, 0},	//awbb_OutdoorGrZones_m_BGrid_1__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0228, 0},	//awbb_OutdoorGrZones_m_BGrid_2__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02EA, 0},	//awbb_OutdoorGrZones_m_BGrid_2__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x021C, 0},	//awbb_OutdoorGrZones_m_BGrid_3__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E0, 0},	//awbb_OutdoorGrZones_m_BGrid_3__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0214, 0},	//awbb_OutdoorGrZones_m_BGrid_4__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02DA, 0},	//awbb_OutdoorGrZones_m_BGrid_4__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0210, 0},	//awbb_OutdoorGrZones_m_BGrid_5__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02D4, 0},	//awbb_OutdoorGrZones_m_BGrid_5__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//awbb_OutdoorGrZones_m_BGrid_6__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02D2, 0},	//awbb_OutdoorGrZones_m_BGrid_6__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01FC, 0},	//awbb_OutdoorGrZones_m_BGrid_7__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02D0, 0},	//awbb_OutdoorGrZones_m_BGrid_7__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F6, 0},	//awbb_OutdoorGrZones_m_BGrid_8__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02CC, 0},	//awbb_OutdoorGrZones_m_BGrid_8__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F2, 0},	//awbb_OutdoorGrZones_m_BGrid_9__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02C2, 0},	//awbb_OutdoorGrZones_m_BGrid_9__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01EE, 0},	//awbb_OutdoorGrZones_m_BGrid_10__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02B8, 0},	//awbb_OutdoorGrZones_m_BGrid_10__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0208, 0},	//awbb_OutdoorGrZones_m_BGrid_11__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0282, 0},	//awbb_OutdoorGrZones_m_BGrid_11__m_right


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x10AC, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000C, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x10B0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x01DA, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x10B4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0366, 0},	//awbb_LowBrGrZones_m_BGrid_0__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03E2, 0},	//awbb_LowBrGrZones_m_BGrid_0__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E2, 0},	//awbb_LowBrGrZones_m_BGrid_1__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0416, 0},	//awbb_LowBrGrZones_m_BGrid_1__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0264, 0},	//awbb_LowBrGrZones_m_BGrid_2__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x040A, 0},	//awbb_LowBrGrZones_m_BGrid_2__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01EE, 0},	//awbb_LowBrGrZones_m_BGrid_3__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03C6, 0},	//awbb_LowBrGrZones_m_BGrid_3__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CE, 0},	//awbb_LowBrGrZones_m_BGrid_4__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x035A, 0},	//awbb_LowBrGrZones_m_BGrid_4__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01C8, 0},	//awbb_LowBrGrZones_m_BGrid_5__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0324, 0},	//awbb_LowBrGrZones_m_BGrid_5__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01A8, 0},	//awbb_LowBrGrZones_m_BGrid_6__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0308, 0},	//awbb_LowBrGrZones_m_BGrid_6__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01A0, 0},	//awbb_LowBrGrZones_m_BGrid_7__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02FA, 0},	//awbb_LowBrGrZones_m_BGrid_7__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01AC, 0},	//awbb_LowBrGrZones_m_BGrid_8__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0286, 0},	//awbb_LowBrGrZones_m_BGrid_8__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_LowBrGrZones_m_BGrid_9__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_LowBrGrZones_m_BGrid_9__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_LowBrGrZones_m_BGrid_10__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_LowBrGrZones_m_BGrid_10__m_right
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_LowBrGrZones_m_BGrid_11__m_left
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_LowBrGrZones_m_BGrid_11__m_right


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0006, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x10E8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000B, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x10EC, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00D2, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x10F0, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03D4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_CrclLowT_R_c
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D8, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_CrclLowT_B_c
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2284, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //awbb_CrclLowT_Rad_c

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1434, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x029B, 0}, //awbb_GridConst_1_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x033A, 0}, //awbb_GridConst_1_1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03CF, 0}, //awbb_GridConst_1_2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0FF1, 0}, //awbb_GridConst_2_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x105A, 0}, //awbb_GridConst_2_1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1141, 0}, //awbb_GridConst_2_2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x10A0, 0}, //awbb_GridConst_2_3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x11E8, 0}, //awbb_GridConst_2_4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1183, 0}, //awbb_GridConst_2_5_

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00B2, 0}, //awbb_GridCoeff_R_1
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00B8, 0}, //awbb_GridCoeff_B_1
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00CA, 0}, //awbb_GridCoeff_R_2
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x009D, 0}, //awbb_GridCoeff_B_2

{SI2C_WR, SI2C_A2D2, 0x002A, 0x13A4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC4, 0},	//D65 awbb_GridCorr_R_0__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFCE, 0},	//D65 CW awbb_GridCorr_R_0__1_ // tc
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//CW awbb_GridCorr_R_0__2_// tc
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//A awbb_GridCorr_R_0__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0046, 0},	//A awbb_GridCorr_R_0__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0096, 0},	//H awbb_GridCorr_R_0__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC4, 0},	//D65 awbb_GridCorr_R_1__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFCE, 0},	//D65 CW awbb_GridCorr_R_1__1_// tc
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//CW awbb_GridCorr_R_1__2_// tc
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//A awbb_GridCorr_R_1__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0046, 0},	//A awbb_GridCorr_R_1__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0096, 0},	//H awbb_GridCorr_R_1__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC4, 0},	//D65awbb_GridCorr_R_2__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFCE, 0},	//D65 CW awbb_GridCorr_R_2__1_// tc
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//CW awbb_GridCorr_R_2__2_// tc
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//A awbb_GridCorr_R_2__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0046, 0},	//A awbb_GridCorr_R_2__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0096, 0},	//H awbb_GridCorr_R_2__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0},	//awbb_GridCorr_B_0__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0},	//awbb_GridCorr_B_0__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_0__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//FFE0 0000 awbb_GridCorr_B_0__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//FFE0 0000 awbb_GridCorr_B_0__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//FFE0 0000 awbb_GridCorr_B_0__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0},	//awbb_GridCorr_B_1__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0},	//awbb_GridCorr_B_1__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_1__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_1__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_1__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_1__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0},	//awbb_GridCorr_B_2__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0},	//awbb_GridCorr_B_2__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_2__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_2__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_2__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_B_2__5_

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//FFC0 awbb_GridCorr_R_Out_0__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//FFD0 awbb_GridCorr_R_Out_0__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//FFD0 awbb_GridCorr_R_Out_0__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//FFD0 awbb_GridCorr_R_Out_0__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//0000 awbb_GridCorr_R_Out_0__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//0000 awbb_GridCorr_R_Out_0__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_R_Out_1__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_R_Out_1__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_R_Out_1__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//awbb_GridCorr_R_Out_1__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//awbb_GridCorr_R_Out_1__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//awbb_GridCorr_R_Out_1__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_R_Out_2__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_R_Out_2__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//awbb_GridCorr_R_Out_2__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//awbb_GridCorr_R_Out_2__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//awbb_GridCorr_R_Out_2__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC0, 0},	//awbb_GridCorr_R_Out_2__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_0__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_0__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_0__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_0__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_0__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_0__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0}, 	//awbb_GridCorr_B_Out_1__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_1__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_1__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_1__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_1__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_1__5_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_2__0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_2__1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFDC, 0},	//awbb_GridCorr_B_Out_2__2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_2__3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_2__4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//awbb_GridCorr_B_Out_2__5_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x01F8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x5DC0, 0}, //REG_TC_IPRM_InClockLSBs
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0212, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_IPRM_UseNPviClocks
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_TC_IPRM_UseNMipiClocks
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_TC_IPRM_NumberOfMipiLanes

{SI2C_WR, SI2C_A2D2, 0x002A, 0x021A, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x34BC, 0}, //REG_TC_IPRM_OpClk4KHz_0
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_TC_IPRM_MinOutRate4KHz_0
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_TC_IPRM_MaxOutRate4KHz_0

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_TC_IPRM_OpClk4KHz_1
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_TC_IPRM_MinOutRate4KHz_1
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_TC_IPRM_MaxOutRate4KHz_1

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0F30, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //AFC_D_ConvAccelerPower

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0F2A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //AFC_Default BIT[0] 1:60Hz 0:50Hz
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x077F, 0}, //REG_TC_DBG 7F: 60Hz  5F:50Hz

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x003C, 0}, //TVAR_ae_BrAve

{SI2C_WR, SI2C_A2D2, 0x002A, 0x148A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000F, 0}, //ae_StatMode

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0588, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //lt_uInitPostToleranceCnt

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0544, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0111, 0}, //lt_uLimitHigh
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00EF, 0}, //lt_uLimitLow

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0608, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //lt_ExpGain_uSubsamplingmode
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //lt_ExpGain_uNonSubsampling

{SI2C_WR, SI2C_A2D2, 0x002a, 0x0610, 0}, //lt_ExpGain_ExpCurveGainMaxStr_0__ulExpIn_0
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A3C, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0D05, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4008, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x7000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x9C00, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xAD00, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xF1D4, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xDC00, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xDC00, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0638, 0}, //lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A3C, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0D05, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6810, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8214, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x060C, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0540, 0}, //lt_ExpGain_ExpCurveGainMaxStr
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0200, 0}, //lt_ExpGain_ExpCurveGainMaxStr_0__uMaxDigGain
{SI2C_WR, SI2C_A2D2, 0x002A, 0x05a2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1000, 0}, //lt_uMaxTotGain

{SI2C_WR, SI2C_A2D2, 0x002A, 0x06B8, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x452C, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0}, //lt_uMaxLei

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1492, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //ae_WeightTbl_16[0]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0}, 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0302, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0203, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0302, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0203, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x08A6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D2, 0}, //SARR_AwbCcmCord[0]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x010E, 0}, //SARR_AwbCcmCord[1]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x011E, 0}, //SARR_AwbCcmCord[2]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x012D, 0}, //SARR_AwbCcmCord[3]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0160, 0}, //SARR_AwbCcmCord[4]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0182, 0}, //SARR_AwbCcmCord[5]

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0898, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4800, 0}, //TVAR_wbt_pBaseCcms
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x08A0, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x48D8, 0}, //TVAR_wbt_pOutdoorCcm
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x7000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x4800, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0162, 0},	//H TVAR_wbt_pBaseCcms[0]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC1, 0},	//TVAR_wbt_pBaseCcms[1]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFE6, 0},	//TVAR_wbt_pBaseCcms[2]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFE49, 0},	//TVAR_wbt_pBaseCcms[3]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01B3, 0},	//TVAR_wbt_pBaseCcms[4]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEA3, 0},	//TVAR_wbt_pBaseCcms[5]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED5, 0},	//TVAR_wbt_pBaseCcms[6]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFB0, 0},	//TVAR_wbt_pBaseCcms[7]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x023B, 0},	//TVAR_wbt_pBaseCcms[8]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x009E, 0},	//TVAR_wbt_pBaseCcms[9]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x018F, 0},	//TVAR_wbt_pBaseCcms[10] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED8, 0},	//TVAR_wbt_pBaseCcms[11] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x013F, 0},	//TVAR_wbt_pBaseCcms[12] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEF8, 0},	//TVAR_wbt_pBaseCcms[13] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D8, 0},	//TVAR_wbt_pBaseCcms[14] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEB0, 0},	//TVAR_wbt_pBaseCcms[15] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x019E, 0},	//TVAR_wbt_pBaseCcms[16] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0082, 0},	//TVAR_wbt_pBaseCcms[17] 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0162, 0}, 	//TVAR_wbt_pBaseCcms[18]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC1, 0}, 	//TVAR_wbt_pBaseCcms[19] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFE6, 0}, 	//TVAR_wbt_pBaseCcms[20] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFE49, 0}, 	//TVAR_wbt_pBaseCcms[21] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01B3, 0}, 	//TVAR_wbt_pBaseCcms[22] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEA3, 0}, 	//TVAR_wbt_pBaseCcms[23] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED5, 0}, 	//TVAR_wbt_pBaseCcms[24] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFB0, 0}, 	//TVAR_wbt_pBaseCcms[25] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x023B, 0}, 	//TVAR_wbt_pBaseCcms[26] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x009E, 0}, 	//TVAR_wbt_pBaseCcms[27] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x018F, 0}, 	//TVAR_wbt_pBaseCcms[28] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED8, 0}, 	//TVAR_wbt_pBaseCcms[29] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x013F, 0}, 	//TVAR_wbt_pBaseCcms[30] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEF8, 0}, 	//TVAR_wbt_pBaseCcms[31] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D8, 0}, 	//TVAR_wbt_pBaseCcms[32] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEB0, 0}, 	//TVAR_wbt_pBaseCcms[33] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x019E, 0}, 	//TVAR_wbt_pBaseCcms[34] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0082, 0}, 	//TVAR_wbt_pBaseCcms[35] 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01D2, 0},	//TVAR_wbt_pBaseCcms[36]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF88, 0},	//TVAR_wbt_pBaseCcms[37] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC3, 0},	//TVAR_wbt_pBaseCcms[38] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED7, 0},	//TVAR_wbt_pBaseCcms[39] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0113, 0},	//TVAR_wbt_pBaseCcms[40] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF13, 0},	//TVAR_wbt_pBaseCcms[41] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFA2, 0},	//TVAR_wbt_pBaseCcms[42] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0},	//TVAR_wbt_pBaseCcms[43] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x020A, 0},	//TVAR_wbt_pBaseCcms[44] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x011C, 0},	//TVAR_wbt_pBaseCcms[45] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D3, 0},	//TVAR_wbt_pBaseCcms[46] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF35, 0},	//TVAR_wbt_pBaseCcms[47] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x018D, 0},	//TVAR_wbt_pBaseCcms[48] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF04, 0},	//TVAR_wbt_pBaseCcms[49] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x015D, 0},	//TVAR_wbt_pBaseCcms[50] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEC1, 0},	//TVAR_wbt_pBaseCcms[51] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0188, 0},	//TVAR_wbt_pBaseCcms[52] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x006B, 0},	//TVAR_wbt_pBaseCcms[53] 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01D2, 0},	//TVAR_wbt_pBaseCcms[54]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF88, 0},	//TVAR_wbt_pBaseCcms[55] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC3, 0},	//TVAR_wbt_pBaseCcms[56] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED7, 0},	//TVAR_wbt_pBaseCcms[57] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0113, 0}, 	//TVAR_wbt_pBaseCcms[58] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF13, 0}, 	//TVAR_wbt_pBaseCcms[59] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFA2, 0}, 	//TVAR_wbt_pBaseCcms[60] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFD8, 0}, 	//TVAR_wbt_pBaseCcms[61] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x020A, 0}, 	//TVAR_wbt_pBaseCcms[62] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x011C, 0}, 	//TVAR_wbt_pBaseCcms[63] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D3, 0}, 	//TVAR_wbt_pBaseCcms[64] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF35, 0}, 	//TVAR_wbt_pBaseCcms[65] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x018D, 0}, 	//TVAR_wbt_pBaseCcms[66] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF04, 0}, 	//TVAR_wbt_pBaseCcms[67] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x015D, 0}, 	//TVAR_wbt_pBaseCcms[68] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEC1, 0},	//TVAR_wbt_pBaseCcms[69] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0188, 0},	//TVAR_wbt_pBaseCcms[70] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x006B, 0},	//TVAR_wbt_pBaseCcms[71] 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CA, 0},	//TVAR_wbt_pBaseCcms[72]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF8B, 0},	//TVAR_wbt_pBaseCcms[73] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC3, 0},	//TVAR_wbt_pBaseCcms[74] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEE1, 0},	//TVAR_wbt_pBaseCcms[75] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0105, 0}, 	//TVAR_wbt_pBaseCcms[76] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF15, 0}, 	//TVAR_wbt_pBaseCcms[77] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFAE, 0}, 	//TVAR_wbt_pBaseCcms[78] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFE0, 0}, 	//TVAR_wbt_pBaseCcms[79] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F2, 0}, 	//TVAR_wbt_pBaseCcms[80] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0115, 0}, 	//TVAR_wbt_pBaseCcms[81] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D5, 0}, 	//TVAR_wbt_pBaseCcms[82] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF32, 0}, 	//TVAR_wbt_pBaseCcms[83] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x017F, 0}, 	//TVAR_wbt_pBaseCcms[84] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF19, 0}, 	//TVAR_wbt_pBaseCcms[85] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0152, 0}, 	//TVAR_wbt_pBaseCcms[86] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED4, 0},	//TVAR_wbt_pBaseCcms[87] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0175, 0},	//TVAR_wbt_pBaseCcms[88] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0067, 0},	//TVAR_wbt_pBaseCcms[89] 

{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CA, 0}, 	//TVAR_wbt_pBaseCcms[90]  
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF8B, 0}, 	//TVAR_wbt_pBaseCcms[91] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFC3, 0}, 	//TVAR_wbt_pBaseCcms[92] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEE1, 0}, 	//TVAR_wbt_pBaseCcms[93] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0105, 0}, 	//TVAR_wbt_pBaseCcms[94] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF15, 0}, 	//TVAR_wbt_pBaseCcms[95] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFAE, 0}, 	//TVAR_wbt_pBaseCcms[96] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFE0, 0}, 	//TVAR_wbt_pBaseCcms[97] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F2, 0}, 	//TVAR_wbt_pBaseCcms[98] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0115, 0}, 	//TVAR_wbt_pBaseCcms[99] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D5, 0}, 	//TVAR_wbt_pBaseCcms[100]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF32, 0}, 	//TVAR_wbt_pBaseCcms[101]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x017F, 0}, 	//TVAR_wbt_pBaseCcms[102]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF19, 0}, 	//TVAR_wbt_pBaseCcms[103]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0152, 0}, 	//TVAR_wbt_pBaseCcms[104]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFED4, 0},	//TVAR_wbt_pBaseCcms[105]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0175, 0},	//TVAR_wbt_pBaseCcms[106]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0067, 0},	//TVAR_wbt_pBaseCcms[107]


{SI2C_WR, SI2C_A2D2, 0x002A, 0x48d8, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01D4, 0},	//TVAR_wbt_pOutdoorCcm[0] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF9D, 0},	//TVAR_wbt_pOutdoorCcm[1] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFE8, 0},	//TVAR_wbt_pOutdoorCcm[2] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEA9, 0},	//TVAR_wbt_pOutdoorCcm[3] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0143, 0},	//TVAR_wbt_pOutdoorCcm[4] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF01, 0},	//TVAR_wbt_pOutdoorCcm[5] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFB7, 0},	//TVAR_wbt_pOutdoorCcm[6] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFF5, 0},	//TVAR_wbt_pOutdoorCcm[7] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0237, 0},	//TVAR_wbt_pOutdoorCcm[8] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00B9, 0},	//TVAR_wbt_pOutdoorCcm[9] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0126, 0},	//TVAR_wbt_pOutdoorCcm[10]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF33, 0},	//TVAR_wbt_pOutdoorCcm[11]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CE, 0},	//TVAR_wbt_pOutdoorCcm[12]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF83, 0},	//TVAR_wbt_pOutdoorCcm[13]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0195, 0},	//TVAR_wbt_pOutdoorCcm[14]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFEF3, 0},	//TVAR_wbt_pOutdoorCcm[15]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x014F, 0},	//TVAR_wbt_pOutdoorCcm[16]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0137, 0},	//TVAR_wbt_pOutdoorCcm[17]


{SI2C_WR, SI2C_A2D2, 0x002A, 0x0734, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//saRR_usDualGammaLutRGBIndoor[0][0] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000A, 0},	//saRR_usDualGammaLutRGBIndoor[0][1] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0016, 0},	//saRR_usDualGammaLutRGBIndoor[0][2] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//saRR_usDualGammaLutRGBIndoor[0][3] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0066, 0},	//saRR_usDualGammaLutRGBIndoor[0][4] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D5, 0},	//saRR_usDualGammaLutRGBIndoor[0][5] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0138, 0},	//saRR_usDualGammaLutRGBIndoor[0][6] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0163, 0},	//saRR_usDualGammaLutRGBIndoor[0][7] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0189, 0},	//saRR_usDualGammaLutRGBIndoor[0][8] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01C6, 0},	//saRR_usDualGammaLutRGBIndoor[0][9] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F8, 0},	//saRR_usDualGammaLutRGBIndoor[0][10]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0222, 0},	//saRR_usDualGammaLutRGBIndoor[0][11]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0247, 0},	//saRR_usDualGammaLutRGBIndoor[0][12]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0282, 0},	//saRR_usDualGammaLutRGBIndoor[0][13]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02B5, 0},	//saRR_usDualGammaLutRGBIndoor[0][14]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x030F, 0},	//saRR_usDualGammaLutRGBIndoor[0][15]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x035F, 0},	//saRR_usDualGammaLutRGBIndoor[0][16]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03A2, 0},	//saRR_usDualGammaLutRGBIndoor[0][17]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03D8, 0},	//saRR_usDualGammaLutRGBIndoor[0][18]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03FF, 0},	//saRR_usDualGammaLutRGBIndoor[0][19]


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//saRR_usDualGammaLutRGBIndoor[1][0] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000A, 0},	//saRR_usDualGammaLutRGBIndoor[1][1] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0016, 0},	//saRR_usDualGammaLutRGBIndoor[1][2] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//saRR_usDualGammaLutRGBIndoor[1][3] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0066, 0},	//saRR_usDualGammaLutRGBIndoor[1][4] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D5, 0},	//saRR_usDualGammaLutRGBIndoor[1][5] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0138, 0},	//saRR_usDualGammaLutRGBIndoor[1][6] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0163, 0},	//saRR_usDualGammaLutRGBIndoor[1][7] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0189, 0},	//saRR_usDualGammaLutRGBIndoor[1][8] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01C6, 0},	//saRR_usDualGammaLutRGBIndoor[1][9] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F8, 0},	//saRR_usDualGammaLutRGBIndoor[1][10]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0222, 0},	//saRR_usDualGammaLutRGBIndoor[1][11]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0247, 0},	//saRR_usDualGammaLutRGBIndoor[1][12]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0282, 0},	//saRR_usDualGammaLutRGBIndoor[1][13]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02B5, 0},	//saRR_usDualGammaLutRGBIndoor[1][14]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x030F, 0},	//saRR_usDualGammaLutRGBIndoor[1][15]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x035F, 0},	//saRR_usDualGammaLutRGBIndoor[1][16]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03A2, 0},	//saRR_usDualGammaLutRGBIndoor[1][17]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03D8, 0},	//saRR_usDualGammaLutRGBIndoor[1][18]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03FF, 0},	//saRR_usDualGammaLutRGBIndoor[1][19]


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//saRR_usDualGammaLutRGBIndoor[2][0] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000A, 0},	//saRR_usDualGammaLutRGBIndoor[2][1] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0016, 0},	//saRR_usDualGammaLutRGBIndoor[2][2] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0030, 0},	//saRR_usDualGammaLutRGBIndoor[2][3] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0066, 0},	//saRR_usDualGammaLutRGBIndoor[2][4] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D5, 0},	//saRR_usDualGammaLutRGBIndoor[2][5] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0138, 0},	//saRR_usDualGammaLutRGBIndoor[2][6] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0163, 0},	//saRR_usDualGammaLutRGBIndoor[2][7] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0189, 0},	//saRR_usDualGammaLutRGBIndoor[2][8] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01C6, 0},	//saRR_usDualGammaLutRGBIndoor[2][9] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F8, 0},	//saRR_usDualGammaLutRGBIndoor[2][10]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0222, 0},	//saRR_usDualGammaLutRGBIndoor[2][11]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0247, 0},	//saRR_usDualGammaLutRGBIndoor[2][12]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0282, 0},	//saRR_usDualGammaLutRGBIndoor[2][13]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02B5, 0},	//saRR_usDualGammaLutRGBIndoor[2][14]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x030F, 0},	//saRR_usDualGammaLutRGBIndoor[2][15]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x035F, 0},	//saRR_usDualGammaLutRGBIndoor[2][16]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03A2, 0},	//saRR_usDualGammaLutRGBIndoor[2][17]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03D8, 0},	//saRR_usDualGammaLutRGBIndoor[2][18]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03FF, 0},	//saRR_usDualGammaLutRGBIndoor[2][19]


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //saRR_usDualGammaLutRGBOutdoor[0][0] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0}, //saRR_usDualGammaLutRGBOutdoor[0][1] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0}, //saRR_usDualGammaLutRGBOutdoor[0][2] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0}, //saRR_usDualGammaLutRGBOutdoor[0][3] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0}, //saRR_usDualGammaLutRGBOutdoor[0][4] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D8, 0}, //saRR_usDualGammaLutRGBOutdoor[0][5] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0148, 0}, //saRR_usDualGammaLutRGBOutdoor[0][6] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0174, 0}, //saRR_usDualGammaLutRGBOutdoor[0][7] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0198, 0}, //saRR_usDualGammaLutRGBOutdoor[0][8] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01D4, 0}, //saRR_usDualGammaLutRGBOutdoor[0][9] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0208, 0}, //saRR_usDualGammaLutRGBOutdoor[0][10]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0234, 0}, //saRR_usDualGammaLutRGBOutdoor[0][11]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0260, 0}, //saRR_usDualGammaLutRGBOutdoor[0][12]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02A8, 0}, //saRR_usDualGammaLutRGBOutdoor[0][13]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E4, 0}, //saRR_usDualGammaLutRGBOutdoor[0][14]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0340, 0}, //saRR_usDualGammaLutRGBOutdoor[0][15]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0380, 0}, //saRR_usDualGammaLutRGBOutdoor[0][16]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03B0, 0}, //saRR_usDualGammaLutRGBOutdoor[0][17]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03D8, 0}, //saRR_usDualGammaLutRGBOutdoor[0][18]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03F9, 0}, //saRR_usDualGammaLutRGBOutdoor[0][19]


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //saRR_usDualGammaLutRGBOutdoor[1][0] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0}, //saRR_usDualGammaLutRGBOutdoor[1][1] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0}, //saRR_usDualGammaLutRGBOutdoor[1][2] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0}, //saRR_usDualGammaLutRGBOutdoor[1][3] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0}, //saRR_usDualGammaLutRGBOutdoor[1][4] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D8, 0}, //saRR_usDualGammaLutRGBOutdoor[1][5] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0148, 0}, //saRR_usDualGammaLutRGBOutdoor[1][6] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0174, 0}, //saRR_usDualGammaLutRGBOutdoor[1][7] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0198, 0}, //saRR_usDualGammaLutRGBOutdoor[1][8] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01D4, 0}, //saRR_usDualGammaLutRGBOutdoor[1][9] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0208, 0}, //saRR_usDualGammaLutRGBOutdoor[1][10]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0234, 0}, //saRR_usDualGammaLutRGBOutdoor[1][11]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0260, 0}, //saRR_usDualGammaLutRGBOutdoor[1][12]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02A8, 0}, //saRR_usDualGammaLutRGBOutdoor[1][13]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E4, 0}, //saRR_usDualGammaLutRGBOutdoor[1][14]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0340, 0}, //saRR_usDualGammaLutRGBOutdoor[1][15]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0380, 0}, //saRR_usDualGammaLutRGBOutdoor[1][16]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03B0, 0}, //saRR_usDualGammaLutRGBOutdoor[1][17]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03D8, 0}, //saRR_usDualGammaLutRGBOutdoor[1][18]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03F9, 0}, //saRR_usDualGammaLutRGBOutdoor[1][19]


{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //saRR_usDualGammaLutRGBOutdoor[2][0] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0004, 0}, //saRR_usDualGammaLutRGBOutdoor[2][1] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0}, //saRR_usDualGammaLutRGBOutdoor[2][2] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0}, //saRR_usDualGammaLutRGBOutdoor[2][3] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0}, //saRR_usDualGammaLutRGBOutdoor[2][4] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D8, 0}, //saRR_usDualGammaLutRGBOutdoor[2][5] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0148, 0}, //saRR_usDualGammaLutRGBOutdoor[2][6] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0174, 0}, //saRR_usDualGammaLutRGBOutdoor[2][7] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0198, 0}, //saRR_usDualGammaLutRGBOutdoor[2][8] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01D4, 0}, //saRR_usDualGammaLutRGBOutdoor[2][9] 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0208, 0}, //saRR_usDualGammaLutRGBOutdoor[2][10]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0234, 0}, //saRR_usDualGammaLutRGBOutdoor[2][11]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0260, 0}, //saRR_usDualGammaLutRGBOutdoor[2][12]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02A8, 0}, //saRR_usDualGammaLutRGBOutdoor[2][13]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02E4, 0}, //saRR_usDualGammaLutRGBOutdoor[2][14]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0340, 0}, //saRR_usDualGammaLutRGBOutdoor[2][15]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0380, 0}, //saRR_usDualGammaLutRGBOutdoor[2][16]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03B0, 0}, //saRR_usDualGammaLutRGBOutdoor[2][17]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03D8, 0}, //saRR_usDualGammaLutRGBOutdoor[2][18]
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03F9, 0}, //saRR_usDualGammaLutRGBOutdoor[2][19]


{SI2C_WR, SI2C_A2D2, 0x002A, 0x0944, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0050, 0}, //afit_uNoiseIndInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00B0, 0}, //afit_uNoiseIndInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0196, 0}, //afit_uNoiseIndInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0245, 0}, //afit_uNoiseIndInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0}, //afit_uNoiseIndInDoor

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0938, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, // on/off AFIT by NB option
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0014, 0}, //SARR_uNormBrInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00D2, 0}, //SARR_uNormBrInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0384, 0}, //SARR_uNormBrInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x07D0, 0}, //SARR_uNormBrInDoor
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1388, 0}, //SARR_uNormBrInDoor

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0976, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0070, 0}, //afit_usGamutTh
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0}, //afit_usNeargrayOffset
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //afit_bUseSenBpr
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CC, 0}, //afit_usBprThr_0_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CC, 0}, //afit_usBprThr_1_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CC, 0}, //afit_usBprThr_2_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CC, 0}, //afit_usBprThr_3_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01CC, 0}, //afit_usBprThr_4_
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0180, 0}, //afit_NIContrastAFITValue
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0196, 0}, //afit_NIContrastTh

{SI2C_WR, SI2C_A2D2, 0x002A, 0x098C, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//7000098C//AFIT16_BRIGHTNESS			
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//7000098E//AFIT16_CONTRAST 													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0016, 0},	//70000990//AFIT16_SATURATION													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000992//AFIT16_SHARP_BLUR													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000994//AFIT16_GLAMOUR														   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0},	//70000996//AFIT16_bnr_edge_high												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0064, 0},	//70000998//AFIT16_postdmsc_iLowBright											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0384, 0},	//7000099A//AFIT16_postdmsc_iHighBright 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x005F, 0},	//7000099C//AFIT16_postdmsc_iLowSat 											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},	//7000099E//AFIT16_postdmsc_iHighSat											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0070, 0},	//700009A0//AFIT16_postdmsc_iTune												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},	//700009A2//AFIT16_yuvemix_mNegRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00A0, 0},	//700009A4//AFIT16_yuvemix_mNegRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//700009A6//AFIT16_yuvemix_mNegRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},	//700009A8//AFIT16_yuvemix_mPosRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},	//700009AA//AFIT16_yuvemix_mPosRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00A0, 0},	//700009AC//AFIT16_yuvemix_mPosRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1430, 0},	//700009AE//AFIT8_bnr_edge_low	[7:0] AFIT8_bnr_repl_thresh 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//700009B0//AFIT8_bnr_repl_force  [7:0] AFIT8_bnr_iHotThreshHigh				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0204, 0},	//700009B2//AFIT8_bnr_iHotThreshLow   [7:0] AFIT8_bnr_iColdThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3604, 0},	//700009B4//AFIT8_bnr_iColdThreshLow   [7:0] AFIT8_bnr_DispTH_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x032A, 0},	//700009B6//AFIT8_bnr_DispTH_High	[7:0] AFIT8_bnr_DISP_Limit_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0403, 0},	//700009B8//AFIT8_bnr_DISP_Limit_High	[7:0] AFIT8_bnr_iDistSigmaMin			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1B06, 0},	//700009BA//AFIT8_bnr_iDistSigmaMax   [7:0] AFIT8_bnr_iDiffSigmaLow 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6015, 0},	//700009BC//AFIT8_bnr_iDiffSigmaHigh   [7:0] AFIT8_bnr_iNormalizedSTD_TH		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0},	//700009BE//AFIT8_bnr_iNormalizedSTD_Limit	 [7:0] AFIT8_bnr_iDirNRTune 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6080, 0},	//700009C0//AFIT8_bnr_iDirMinThres	 [7:0] AFIT8_bnr_iDirFltDiffThresHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4080, 0},	//700009C2//AFIT8_bnr_iDirFltDiffThresLow	[7:0] AFIT8_bnr_iDirSmoothPowerHigh    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0640, 0},	//700009C4//AFIT8_bnr_iDirSmoothPowerLow   [7:0] AFIT8_bnr_iLowMaxSlopeAllowed	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//700009C6//AFIT8_bnr_iHighMaxSlopeAllowed	 [7:0] AFIT8_bnr_iLowSlopeThresh	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2003, 0},	//700009C8//AFIT8_bnr_iHighSlopeThresh	 [7:0] AFIT8_bnr_iSlopenessTH			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF01, 0},	//700009CA//AFIT8_bnr_iSlopeBlurStrength   [7:0] AFIT8_bnr_iSlopenessLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//700009CC//AFIT8_bnr_AddNoisePower1   [7:0] AFIT8_bnr_AddNoisePower2			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0400, 0},	//700009CE//AFIT8_bnr_iRadialTune	[7:0] AFIT8_bnr_iRadialPower				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x365A, 0},	//700009D0//AFIT8_bnr_iRadialLimit	 [7:0] AFIT8_ee_iFSMagThLow 				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x102A, 0},	//700009D2//AFIT8_ee_iFSMagThHigh	[7:0] AFIT8_ee_iFSVarThLow					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//700009D4//AFIT8_ee_iFSVarThHigh	[7:0] AFIT8_ee_iFSThLow 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0600, 0},	//700009D6//AFIT8_ee_iFSThHigh	 [7:0] AFIT8_ee_iFSmagPower 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5A0F, 0},	//700009D8//AFIT8_ee_iFSVarCountTh	 [7:0] AFIT8_ee_iRadialLimit				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0505, 0},	//700009DA//AFIT8_ee_iRadialPower	[7:0] AFIT8_ee_iSmoothEdgeSlope 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1802, 0},	//700009DC//AFIT8_ee_iROADThres   [7:0] AFIT8_ee_iROADMaxNR 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//700009DE//AFIT8_ee_iROADSubMaxNR	 [7:0] AFIT8_ee_iROADSubThres				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2006, 0},	//700009E0//AFIT8_ee_iROADNeiThres	 [7:0] AFIT8_ee_iROADNeiMaxNR				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3028, 0},	//700009E2//AFIT8_ee_iSmoothEdgeThres	[7:0] AFIT8_ee_iMSharpen				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0418, 0},	//700009E4//AFIT8_ee_iWSharpen	 [7:0] AFIT8_ee_iMShThresh						   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//700009E6//AFIT8_ee_iWShThresh   [7:0] AFIT8_ee_iReduceNegative				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0800, 0},	//700009E8//AFIT8_ee_iEmbossCentAdd   [7:0] AFIT8_ee_iShDespeckle				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1804, 0},	//700009EA//AFIT8_ee_iReduceEdgeThresh	 [7:0] AFIT8_dmsc_iEnhThresh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4008, 0},	//700009EC//AFIT8_dmsc_iDesatThresh   [7:0] AFIT8_dmsc_iDemBlurHigh 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0540, 0},	//700009EE//AFIT8_dmsc_iDemBlurLow	 [7:0] AFIT8_dmsc_iDemBlurRange 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8006, 0},	//700009F0//AFIT8_dmsc_iDecisionThresh	 [7:0] AFIT8_dmsc_iCentGrad 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0},	//700009F2//AFIT8_dmsc_iMonochrom	[7:0] AFIT8_dmsc_iGBDenoiseVal				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//700009F4//AFIT8_dmsc_iGRDenoiseVal   [7:0] AFIT8_dmsc_iEdgeDesatThrHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1800, 0},	//700009F6//AFIT8_dmsc_iEdgeDesatThrLow   [7:0] AFIT8_dmsc_iEdgeDesat			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0},	//700009F8//AFIT8_dmsc_iNearGrayDesat	[7:0] AFIT8_dmsc_iEdgeDesatLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1E10, 0},	//700009FA//AFIT8_postdmsc_iBCoeff	 [7:0] AFIT8_postdmsc_iGCoeff				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//700009FC//AFIT8_postdmsc_iWideMult   [7:0] AFIT8_yuvemix_mNegSlopes_0 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//700009FE//AFIT8_yuvemix_mNegSlopes_1	 [7:0] AFIT8_yuvemix_mNegSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},	//70000A00//AFIT8_yuvemix_mNegSlopes_3	 [7:0] AFIT8_yuvemix_mPosSlopes_0		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000A02//AFIT8_yuvemix_mPosSlopes_1	 [7:0] AFIT8_yuvemix_mPosSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0405, 0},	//70000A04//AFIT8_yuvemix_mPosSlopes_3	 [7:0] AFIT8_yuviirnr_iXSupportY		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0205, 0},	//70000A06//AFIT8_yuviirnr_iXSupportUV	 [7:0] AFIT8_yuviirnr_iLowYNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0304, 0},	//70000A08//AFIT8_yuviirnr_iHighYNorm	[7:0] AFIT8_yuviirnr_iLowUVNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0409, 0},	//70000A0A//AFIT8_yuviirnr_iHighUVNorm	 [7:0] AFIT8_yuviirnr_iYNormShift		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000A0C//AFIT8_yuviirnr_iUVNormShift   [7:0] AFIT8_yuviirnr_iVertLength_Y	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0407, 0},	//70000A0E//AFIT8_yuviirnr_iVertLength_UV	[7:0] AFIT8_yuviirnr_iDiffThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1C04, 0},	//70000A10//AFIT8_yuviirnr_iDiffThreshH_Y	[7:0] AFIT8_yuviirnr_iDiffThreshL_UV   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0214, 0},	//70000A12//AFIT8_yuviirnr_iDiffThreshH_UV	 [7:0] AFIT8_yuviirnr_iMaxThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1002, 0},	//70000A14//AFIT8_yuviirnr_iMaxThreshH_Y   [7:0] AFIT8_yuviirnr_iMaxThreshL_UV	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0610, 0},	//70000A16//AFIT8_yuviirnr_iMaxThreshH_UV	[7:0] AFIT8_yuviirnr_iYNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1A02, 0},	//70000A18//AFIT8_yuviirnr_iYNRStrengthH   [7:0] AFIT8_yuviirnr_iUVNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4A18, 0},	//70000A1A//AFIT8_yuviirnr_iUVNRStrengthH	[7:0] AFIT8_byr_gras_iShadingPower	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000A1C//AFIT8_RGBGamma2_iLinearity	 [7:0] AFIT8_RGBGamma2_iDarkReduce		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0348, 0},	//70000A1E//AFIT8_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0180, 0},	//70000A20//AFIT8_RGB2YUV_iRGBGain	 [7:0] AFIT8_bnr_nClustLevel_H				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A0A, 0},	//70000A22//AFIT8_bnr_iClustMulT_H	 [7:0] AFIT8_bnr_iClustMulT_C				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000A24//AFIT8_bnr_iClustThresh_H   [7:0] AFIT8_bnr_iClustThresh_C			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2A36, 0},	//70000A26//AFIT8_bnr_iDenThreshLow   [7:0] AFIT8_bnr_iDenThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//70000A28//AFIT8_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2A36, 0},	//70000A2A//AFIT8_ee_iLowShDenoise	 [7:0] AFIT8_ee_iHighShDenoise				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},	//70000A2C//AFIT8_ee_iLowSharpClamp   [7:0] AFIT8_ee_iHighSharpClamp			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0808, 0},	//70000A2E//AFIT8_ee_iReduceEdgeMinMult   [7:0] AFIT8_ee_iReduceEdgeSlope		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A01, 0},	//70000A30//AFIT8_bnr_nClustLevel_H_Bin   [7:0] AFIT8_bnr_iClustMulT_H_Bin		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x010A, 0},	//70000A32//AFIT8_bnr_iClustMulT_C_Bin	 [7:0] AFIT8_bnr_iClustThresh_H_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3601, 0},	//70000A34//AFIT8_bnr_iClustThresh_C_Bin   [7:0] AFIT8_bnr_iDenThreshLow_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x242A, 0},	//70000A36//AFIT8_bnr_iDenThreshHigh_Bin   [7:0] AFIT8_ee_iLowSharpPower_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3660, 0},	//70000A38//AFIT8_ee_iHighSharpPower_Bin   [7:0] AFIT8_ee_iLowShDenoise_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF2A, 0},	//70000A3A//AFIT8_ee_iHighShDenoise_Bin   [7:0] AFIT8_ee_iLowSharpClamp_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x08FF, 0},	//70000A3C//AFIT8_ee_iHighSharpClamp_Bin   [7:0] AFIT8_ee_iReduceEdgeMinMult_Bin   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},	//70000A3E//AFIT8_ee_iReduceEdgeSlope_Bin [7:0] 								   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//70000A40//AFITB_bnr_nClustLevel_C 	 [0]										
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000A42//AFIT16_BRIGHTNESS			
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000A44//AFIT16_CONTRAST 													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000C, 0},	//70000A46//AFIT16_SATURATION													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000A48//AFIT16_SHARP_BLUR													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000A4A//AFIT16_GLAMOUR														   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0},	//70000A4C//AFIT16_bnr_edge_high												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0064, 0},	//70000A4E//AFIT16_postdmsc_iLowBright											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0384, 0},	//70000A50//AFIT16_postdmsc_iHighBright 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0051, 0},	//70000A52//AFIT16_postdmsc_iLowSat 											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},	//70000A54//AFIT16_postdmsc_iHighSat											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0070, 0},	//70000A56//AFIT16_postdmsc_iTune												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},	//70000A58//AFIT16_yuvemix_mNegRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00A0, 0},	//70000A5A//AFIT16_yuvemix_mNegRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000A5C//AFIT16_yuvemix_mNegRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},	//70000A5E//AFIT16_yuvemix_mPosRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0},	//70000A60//AFIT16_yuvemix_mPosRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000A62//AFIT16_yuvemix_mPosRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1430, 0},	//70000A64//AFIT8_bnr_edge_low	[7:0] AFIT8_bnr_repl_thresh 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//70000A66//AFIT8_bnr_repl_force  [7:0] AFIT8_bnr_iHotThreshHigh				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0204, 0},	//70000A68//AFIT8_bnr_iHotThreshLow   [7:0] AFIT8_bnr_iColdThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2404, 0},	//70000A6A//AFIT8_bnr_iColdThreshLow   [7:0] AFIT8_bnr_DispTH_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x031B, 0},	//70000A6C//AFIT8_bnr_DispTH_High	[7:0] AFIT8_bnr_DISP_Limit_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0103, 0},	//70000A6E//AFIT8_bnr_DISP_Limit_High	[7:0] AFIT8_bnr_iDistSigmaMin			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1205, 0},	//70000A70//AFIT8_bnr_iDistSigmaMax   [7:0] AFIT8_bnr_iDiffSigmaLow 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x400D, 0},	//70000A72//AFIT8_bnr_iDiffSigmaHigh   [7:0] AFIT8_bnr_iNormalizedSTD_TH		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000A74//AFIT8_bnr_iNormalizedSTD_Limit	 [7:0] AFIT8_bnr_iDirNRTune 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2080, 0},	//70000A76//AFIT8_bnr_iDirMinThres	 [7:0] AFIT8_bnr_iDirFltDiffThresHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3040, 0},	//70000A78//AFIT8_bnr_iDirFltDiffThresLow	[7:0] AFIT8_bnr_iDirSmoothPowerHigh    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0630, 0},	//70000A7A//AFIT8_bnr_iDirSmoothPowerLow   [7:0] AFIT8_bnr_iLowMaxSlopeAllowed	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000A7C//AFIT8_bnr_iHighMaxSlopeAllowed	 [7:0] AFIT8_bnr_iLowSlopeThresh	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2003, 0},	//70000A7E//AFIT8_bnr_iHighSlopeThresh	 [7:0] AFIT8_bnr_iSlopenessTH			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF01, 0},	//70000A80//AFIT8_bnr_iSlopeBlurStrength   [7:0] AFIT8_bnr_iSlopenessLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0404, 0},	//70000A82//AFIT8_bnr_AddNoisePower1   [7:0] AFIT8_bnr_AddNoisePower2			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0},	//70000A84//AFIT8_bnr_iRadialTune	[7:0] AFIT8_bnr_iRadialPower				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x245A, 0},	//70000A86//AFIT8_bnr_iRadialLimit	 [7:0] AFIT8_ee_iFSMagThLow 				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1018, 0},	//70000A88//AFIT8_ee_iFSMagThHigh	[7:0] AFIT8_ee_iFSVarThLow					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000A8A//AFIT8_ee_iFSVarThHigh	[7:0] AFIT8_ee_iFSThLow 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0B00, 0},	//70000A8C//AFIT8_ee_iFSThHigh	 [7:0] AFIT8_ee_iFSmagPower 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5A0F, 0},	//70000A8E//AFIT8_ee_iFSVarCountTh	 [7:0] AFIT8_ee_iRadialLimit				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0505, 0},	//70000A90//AFIT8_ee_iRadialPower	[7:0] AFIT8_ee_iSmoothEdgeSlope 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1802, 0},	//70000A92//AFIT8_ee_iROADThres   [7:0] AFIT8_ee_iROADMaxNR 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000A94//AFIT8_ee_iROADSubMaxNR	 [7:0] AFIT8_ee_iROADSubThres				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2006, 0},	//70000A96//AFIT8_ee_iROADNeiThres	 [7:0] AFIT8_ee_iROADNeiMaxNR				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3428, 0},	//70000A98//AFIT8_ee_iSmoothEdgeThres	[7:0] AFIT8_ee_iMSharpen				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x041C, 0},	//70000A9A//AFIT8_ee_iWSharpen	 [7:0] AFIT8_ee_iMShThresh						   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000A9C//AFIT8_ee_iWShThresh   [7:0] AFIT8_ee_iReduceNegative				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0800, 0},	//70000A9E//AFIT8_ee_iEmbossCentAdd   [7:0] AFIT8_ee_iShDespeckle				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1004, 0},	//70000AA0//AFIT8_ee_iReduceEdgeThresh	 [7:0] AFIT8_dmsc_iEnhThresh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4008, 0},	//70000AA2//AFIT8_dmsc_iDesatThresh   [7:0] AFIT8_dmsc_iDemBlurHigh 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0540, 0},	//70000AA4//AFIT8_dmsc_iDemBlurLow	 [7:0] AFIT8_dmsc_iDemBlurRange 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8006, 0},	//70000AA6//AFIT8_dmsc_iDecisionThresh	 [7:0] AFIT8_dmsc_iCentGrad 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0},	//70000AA8//AFIT8_dmsc_iMonochrom	[7:0] AFIT8_dmsc_iGBDenoiseVal				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000AAA//AFIT8_dmsc_iGRDenoiseVal   [7:0] AFIT8_dmsc_iEdgeDesatThrHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1800, 0},	//70000AAC//AFIT8_dmsc_iEdgeDesatThrLow   [7:0] AFIT8_dmsc_iEdgeDesat			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0},	//70000AAE//AFIT8_dmsc_iNearGrayDesat	[7:0] AFIT8_dmsc_iEdgeDesatLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1E10, 0},	//70000AB0//AFIT8_postdmsc_iBCoeff	 [7:0] AFIT8_postdmsc_iGCoeff				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000AB2//AFIT8_postdmsc_iWideMult   [7:0] AFIT8_yuvemix_mNegSlopes_0 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000AB4//AFIT8_yuvemix_mNegSlopes_1	 [7:0] AFIT8_yuvemix_mNegSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},	//70000AB6//AFIT8_yuvemix_mNegSlopes_3	 [7:0] AFIT8_yuvemix_mPosSlopes_0		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000AB8//AFIT8_yuvemix_mPosSlopes_1	 [7:0] AFIT8_yuvemix_mPosSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0405, 0},	//70000ABA//AFIT8_yuvemix_mPosSlopes_3	 [7:0] AFIT8_yuviirnr_iXSupportY		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0205, 0},	//70000ABC//AFIT8_yuviirnr_iXSupportUV	 [7:0] AFIT8_yuviirnr_iLowYNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0304, 0},	//70000ABE//AFIT8_yuviirnr_iHighYNorm	[7:0] AFIT8_yuviirnr_iLowUVNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0409, 0},	//70000AC0//AFIT8_yuviirnr_iHighUVNorm	 [7:0] AFIT8_yuviirnr_iYNormShift		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000AC2//AFIT8_yuviirnr_iUVNormShift   [7:0] AFIT8_yuviirnr_iVertLength_Y	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0407, 0},	//70000AC4//AFIT8_yuviirnr_iVertLength_UV	[7:0] AFIT8_yuviirnr_iDiffThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1F04, 0},	//70000AC6//AFIT8_yuviirnr_iDiffThreshH_Y	[7:0] AFIT8_yuviirnr_iDiffThreshL_UV   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0218, 0},	//70000AC8//AFIT8_yuviirnr_iDiffThreshH_UV	 [7:0] AFIT8_yuviirnr_iMaxThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1102, 0},	//70000ACA//AFIT8_yuviirnr_iMaxThreshH_Y   [7:0] AFIT8_yuviirnr_iMaxThreshL_UV	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0611, 0},	//70000ACC//AFIT8_yuviirnr_iMaxThreshH_UV	[7:0] AFIT8_yuviirnr_iYNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1A02, 0},	//70000ACE//AFIT8_yuviirnr_iYNRStrengthH   [7:0] AFIT8_yuviirnr_iUVNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8018, 0},	//70000AD0//AFIT8_yuviirnr_iUVNRStrengthH	[7:0] AFIT8_byr_gras_iShadingPower	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000AD2//AFIT8_RGBGamma2_iLinearity	 [7:0] AFIT8_RGBGamma2_iDarkReduce		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0380, 0},	//70000AD4//AFIT8_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0180, 0},	//70000AD6//AFIT8_RGB2YUV_iRGBGain	 [7:0] AFIT8_bnr_nClustLevel_H				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A0A, 0},	//70000AD8//AFIT8_bnr_iClustMulT_H	 [7:0] AFIT8_bnr_iClustMulT_C				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000ADA//AFIT8_bnr_iClustThresh_H   [7:0] AFIT8_bnr_iClustThresh_C			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1B24, 0},	//70000ADC//AFIT8_bnr_iDenThreshLow   [7:0] AFIT8_bnr_iDenThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//70000ADE//AFIT8_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1D22, 0},	//70000AE0//AFIT8_ee_iLowShDenoise	 [7:0] AFIT8_ee_iHighShDenoise				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},	//70000AE2//AFIT8_ee_iLowSharpClamp   [7:0] AFIT8_ee_iHighSharpClamp			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0808, 0},	//70000AE4//AFIT8_ee_iReduceEdgeMinMult   [7:0] AFIT8_ee_iReduceEdgeSlope		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A01, 0},	//70000AE6//AFIT8_bnr_nClustLevel_H_Bin   [7:0] AFIT8_bnr_iClustMulT_H_Bin		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x010A, 0},	//70000AE8//AFIT8_bnr_iClustMulT_C_Bin	 [7:0] AFIT8_bnr_iClustThresh_H_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2401, 0},	//70000AEA//AFIT8_bnr_iClustThresh_C_Bin   [7:0] AFIT8_bnr_iDenThreshLow_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x241B, 0},	//70000AEC//AFIT8_bnr_iDenThreshHigh_Bin   [7:0] AFIT8_ee_iLowSharpPower_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1E60, 0},	//70000AEE//AFIT8_ee_iHighSharpPower_Bin   [7:0] AFIT8_ee_iLowShDenoise_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF18, 0},	//70000AF0//AFIT8_ee_iHighShDenoise_Bin   [7:0] AFIT8_ee_iLowSharpClamp_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x08FF, 0},	//70000AF2//AFIT8_ee_iHighSharpClamp_Bin   [7:0] AFIT8_ee_iReduceEdgeMinMult_Bin   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},	//70000AF4//AFIT8_ee_iReduceEdgeSlope_Bin [7:0] 								   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//70000AF6//AFITB_bnr_nClustLevel_C 	 [0]										
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000AF8//AFIT16_BRIGHTNESS			
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000AFA//AFIT16_CONTRAST 													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000AFC//AFIT16_SATURATION													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000AFE//AFIT16_SHARP_BLUR													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000B00//AFIT16_GLAMOUR														   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0},	//70000B02//AFIT16_bnr_edge_high												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0064, 0},	//70000B04//AFIT16_postdmsc_iLowBright											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0384, 0},	//70000B06//AFIT16_postdmsc_iHighBright 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0043, 0},	//70000B08//AFIT16_postdmsc_iLowSat 											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},	//70000B0A//AFIT16_postdmsc_iHighSat											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0070, 0},	//70000B0C//AFIT16_postdmsc_iTune												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},	//70000B0E//AFIT16_yuvemix_mNegRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00A0, 0},	//70000B10//AFIT16_yuvemix_mNegRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000B12//AFIT16_yuvemix_mNegRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},	//70000B14//AFIT16_yuvemix_mPosRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0},	//70000B16//AFIT16_yuvemix_mPosRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000B18//AFIT16_yuvemix_mPosRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1430, 0},	//70000B1A//AFIT8_bnr_edge_low	[7:0] AFIT8_bnr_repl_thresh 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//70000B1C//AFIT8_bnr_repl_force  [7:0] AFIT8_bnr_iHotThreshHigh				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0204, 0},	//70000B1E//AFIT8_bnr_iHotThreshLow   [7:0] AFIT8_bnr_iColdThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1B04, 0},	//70000B20//AFIT8_bnr_iColdThreshLow   [7:0] AFIT8_bnr_DispTH_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0312, 0},	//70000B22//AFIT8_bnr_DispTH_High	[7:0] AFIT8_bnr_DISP_Limit_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0},	//70000B24//AFIT8_bnr_DISP_Limit_High	[7:0] AFIT8_bnr_iDistSigmaMin			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0C03, 0},	//70000B26//AFIT8_bnr_iDistSigmaMax   [7:0] AFIT8_bnr_iDiffSigmaLow 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2806, 0},	//70000B28//AFIT8_bnr_iDiffSigmaHigh   [7:0] AFIT8_bnr_iNormalizedSTD_TH		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0},	//70000B2A//AFIT8_bnr_iNormalizedSTD_Limit	 [7:0] AFIT8_bnr_iDirNRTune 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1580, 0},	//70000B2C//AFIT8_bnr_iDirMinThres	 [7:0] AFIT8_bnr_iDirFltDiffThresHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2020, 0},	//70000B2E//AFIT8_bnr_iDirFltDiffThresLow	[7:0] AFIT8_bnr_iDirSmoothPowerHigh    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0620, 0},	//70000B30//AFIT8_bnr_iDirSmoothPowerLow   [7:0] AFIT8_bnr_iLowMaxSlopeAllowed	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000B32//AFIT8_bnr_iHighMaxSlopeAllowed	 [7:0] AFIT8_bnr_iLowSlopeThresh	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2003, 0},	//70000B34//AFIT8_bnr_iHighSlopeThresh	 [7:0] AFIT8_bnr_iSlopenessTH			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF01, 0},	//70000B36//AFIT8_bnr_iSlopeBlurStrength   [7:0] AFIT8_bnr_iSlopenessLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0404, 0},	//70000B38//AFIT8_bnr_AddNoisePower1   [7:0] AFIT8_bnr_AddNoisePower2			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0},	//70000B3A//AFIT8_bnr_iRadialTune	[7:0] AFIT8_bnr_iRadialPower				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x145A, 0},	//70000B3C//AFIT8_bnr_iRadialLimit	 [7:0] AFIT8_ee_iFSMagThLow 				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1010, 0},	//70000B3E//AFIT8_ee_iFSMagThHigh	[7:0] AFIT8_ee_iFSVarThLow					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000B40//AFIT8_ee_iFSVarThHigh	[7:0] AFIT8_ee_iFSThLow 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0E00, 0},	//70000B42//AFIT8_ee_iFSThHigh	 [7:0] AFIT8_ee_iFSmagPower 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5A0F, 0},	//70000B44//AFIT8_ee_iFSVarCountTh	 [7:0] AFIT8_ee_iRadialLimit				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0504, 0},	//70000B46//AFIT8_ee_iRadialPower	[7:0] AFIT8_ee_iSmoothEdgeSlope 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1802, 0},	//70000B48//AFIT8_ee_iROADThres   [7:0] AFIT8_ee_iROADMaxNR 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000B4A//AFIT8_ee_iROADSubMaxNR	 [7:0] AFIT8_ee_iROADSubThres				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2006, 0},	//70000B4C//AFIT8_ee_iROADNeiThres	 [7:0] AFIT8_ee_iROADNeiMaxNR				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3828, 0},	//70000B4E//AFIT8_ee_iSmoothEdgeThres	[7:0] AFIT8_ee_iMSharpen				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0428, 0},	//70000B50//AFIT8_ee_iWSharpen	 [7:0] AFIT8_ee_iMShThresh						   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000B52//AFIT8_ee_iWShThresh   [7:0] AFIT8_ee_iReduceNegative				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8000, 0},	//70000B54//AFIT8_ee_iEmbossCentAdd   [7:0] AFIT8_ee_iShDespeckle				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A04, 0},	//70000B56//AFIT8_ee_iReduceEdgeThresh	 [7:0] AFIT8_dmsc_iEnhThresh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4008, 0},	//70000B58//AFIT8_dmsc_iDesatThresh   [7:0] AFIT8_dmsc_iDemBlurHigh 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0540, 0},	//70000B5A//AFIT8_dmsc_iDemBlurLow	 [7:0] AFIT8_dmsc_iDemBlurRange 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8006, 0},	//70000B5C//AFIT8_dmsc_iDecisionThresh	 [7:0] AFIT8_dmsc_iCentGrad 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0},	//70000B5E//AFIT8_dmsc_iMonochrom	[7:0] AFIT8_dmsc_iGBDenoiseVal				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000B60//AFIT8_dmsc_iGRDenoiseVal   [7:0] AFIT8_dmsc_iEdgeDesatThrHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1800, 0},	//70000B62//AFIT8_dmsc_iEdgeDesatThrLow   [7:0] AFIT8_dmsc_iEdgeDesat			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0},	//70000B64//AFIT8_dmsc_iNearGrayDesat	[7:0] AFIT8_dmsc_iEdgeDesatLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1E10, 0},	//70000B66//AFIT8_postdmsc_iBCoeff	 [7:0] AFIT8_postdmsc_iGCoeff				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000B68//AFIT8_postdmsc_iWideMult   [7:0] AFIT8_yuvemix_mNegSlopes_0 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000B6A//AFIT8_yuvemix_mNegSlopes_1	 [7:0] AFIT8_yuvemix_mNegSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},	//70000B6C//AFIT8_yuvemix_mNegSlopes_3	 [7:0] AFIT8_yuvemix_mPosSlopes_0		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000B6E//AFIT8_yuvemix_mPosSlopes_1	 [7:0] AFIT8_yuvemix_mPosSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0405, 0},	//70000B70//AFIT8_yuvemix_mPosSlopes_3	 [7:0] AFIT8_yuviirnr_iXSupportY		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0207, 0},	//70000B72//AFIT8_yuviirnr_iXSupportUV	 [7:0] AFIT8_yuviirnr_iLowYNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0304, 0},	//70000B74//AFIT8_yuviirnr_iHighYNorm	[7:0] AFIT8_yuviirnr_iLowUVNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0409, 0},	//70000B76//AFIT8_yuviirnr_iHighUVNorm	 [7:0] AFIT8_yuviirnr_iYNormShift		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000B78//AFIT8_yuviirnr_iUVNormShift   [7:0] AFIT8_yuviirnr_iVertLength_Y	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0407, 0},	//70000B7A//AFIT8_yuviirnr_iVertLength_UV	[7:0] AFIT8_yuviirnr_iDiffThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2404, 0},	//70000B7C//AFIT8_yuviirnr_iDiffThreshH_Y	[7:0] AFIT8_yuviirnr_iDiffThreshL_UV   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0221, 0},	//70000B7E//AFIT8_yuviirnr_iDiffThreshH_UV	 [7:0] AFIT8_yuviirnr_iMaxThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1202, 0},	//70000B80//AFIT8_yuviirnr_iMaxThreshH_Y   [7:0] AFIT8_yuviirnr_iMaxThreshL_UV	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0613, 0},	//70000B82//AFIT8_yuviirnr_iMaxThreshH_UV	[7:0] AFIT8_yuviirnr_iYNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1A02, 0},	//70000B84//AFIT8_yuviirnr_iYNRStrengthH   [7:0] AFIT8_yuviirnr_iUVNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8018, 0},	//70000B86//AFIT8_yuviirnr_iUVNRStrengthH	[7:0] AFIT8_byr_gras_iShadingPower	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000B88//AFIT8_RGBGamma2_iLinearity	 [7:0] AFIT8_RGBGamma2_iDarkReduce		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000B8A//AFIT8_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0180, 0},	//70000B8C//AFIT8_RGB2YUV_iRGBGain	 [7:0] AFIT8_bnr_nClustLevel_H				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A0A, 0},	//70000B8E//AFIT8_bnr_iClustMulT_H	 [7:0] AFIT8_bnr_iClustMulT_C				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000B90//AFIT8_bnr_iClustThresh_H   [7:0] AFIT8_bnr_iClustThresh_C			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x141D, 0},	//70000B92//AFIT8_bnr_iDenThreshLow   [7:0] AFIT8_bnr_iDenThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//70000B94//AFIT8_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0C0C, 0},	//70000B96//AFIT8_ee_iLowShDenoise	 [7:0] AFIT8_ee_iHighShDenoise				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},	//70000B98//AFIT8_ee_iLowSharpClamp   [7:0] AFIT8_ee_iHighSharpClamp			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0808, 0},	//70000B9A//AFIT8_ee_iReduceEdgeMinMult   [7:0] AFIT8_ee_iReduceEdgeSlope		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A01, 0},	//70000B9C//AFIT8_bnr_nClustLevel_H_Bin   [7:0] AFIT8_bnr_iClustMulT_H_Bin		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x010A, 0},	//70000B9E//AFIT8_bnr_iClustMulT_C_Bin	 [7:0] AFIT8_bnr_iClustThresh_H_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1B01, 0},	//70000BA0//AFIT8_bnr_iClustThresh_C_Bin   [7:0] AFIT8_bnr_iDenThreshLow_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2412, 0},	//70000BA2//AFIT8_bnr_iDenThreshHigh_Bin   [7:0] AFIT8_ee_iLowSharpPower_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0C60, 0},	//70000BA4//AFIT8_ee_iHighSharpPower_Bin   [7:0] AFIT8_ee_iLowShDenoise_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF0C, 0},	//70000BA6//AFIT8_ee_iHighShDenoise_Bin   [7:0] AFIT8_ee_iLowSharpClamp_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x08FF, 0},	//70000BA8//AFIT8_ee_iHighSharpClamp_Bin   [7:0] AFIT8_ee_iReduceEdgeMinMult_Bin   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},	//70000BAA//AFIT8_ee_iReduceEdgeSlope_Bin [7:0] 								   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//70000BAC//AFITB_bnr_nClustLevel_C 	 [0]										
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000BAE//AFIT16_BRIGHTNESS			
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000BB0//AFIT16_CONTRAST 													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000BB2//AFIT16_SATURATION													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000BB4//AFIT16_SHARP_BLUR													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000BB6//AFIT16_GLAMOUR														   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0},	//70000BB8//AFIT16_bnr_edge_high												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0064, 0},	//70000BBA//AFIT16_postdmsc_iLowBright											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0384, 0},	//70000BBC//AFIT16_postdmsc_iHighBright 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0032, 0},	//70000BBE//AFIT16_postdmsc_iLowSat 											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},	//70000BC0//AFIT16_postdmsc_iHighSat											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0070, 0},	//70000BC2//AFIT16_postdmsc_iTune												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},	//70000BC4//AFIT16_yuvemix_mNegRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00A0, 0},	//70000BC6//AFIT16_yuvemix_mNegRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000BC8//AFIT16_yuvemix_mNegRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},	//70000BCA//AFIT16_yuvemix_mPosRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0},	//70000BCC//AFIT16_yuvemix_mPosRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000BCE//AFIT16_yuvemix_mPosRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1430, 0},	//70000BD0//AFIT8_bnr_edge_low	[7:0] AFIT8_bnr_repl_thresh 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//70000BD2//AFIT8_bnr_repl_force  [7:0] AFIT8_bnr_iHotThreshHigh				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0204, 0},	//70000BD4//AFIT8_bnr_iHotThreshLow   [7:0] AFIT8_bnr_iColdThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1504, 0},	//70000BD6//AFIT8_bnr_iColdThreshLow   [7:0] AFIT8_bnr_DispTH_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x030F, 0},	//70000BD8//AFIT8_bnr_DispTH_High	[7:0] AFIT8_bnr_DISP_Limit_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0},	//70000BDA//AFIT8_bnr_DISP_Limit_High	[7:0] AFIT8_bnr_iDistSigmaMin			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0902, 0},	//70000BDC//AFIT8_bnr_iDistSigmaMax   [7:0] AFIT8_bnr_iDiffSigmaLow 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2004, 0},	//70000BDE//AFIT8_bnr_iDiffSigmaHigh   [7:0] AFIT8_bnr_iNormalizedSTD_TH		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0050, 0},	//70000BE0//AFIT8_bnr_iNormalizedSTD_Limit	 [7:0] AFIT8_bnr_iDirNRTune 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1140, 0},	//70000BE2//AFIT8_bnr_iDirMinThres	 [7:0] AFIT8_bnr_iDirFltDiffThresHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x201C, 0},	//70000BE4//AFIT8_bnr_iDirFltDiffThresLow	[7:0] AFIT8_bnr_iDirSmoothPowerHigh    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0620, 0},	//70000BE6//AFIT8_bnr_iDirSmoothPowerLow   [7:0] AFIT8_bnr_iLowMaxSlopeAllowed	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000BE8//AFIT8_bnr_iHighMaxSlopeAllowed	 [7:0] AFIT8_bnr_iLowSlopeThresh	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2003, 0},	//70000BEA//AFIT8_bnr_iHighSlopeThresh	 [7:0] AFIT8_bnr_iSlopenessTH			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF01, 0},	//70000BEC//AFIT8_bnr_iSlopeBlurStrength   [7:0] AFIT8_bnr_iSlopenessLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0404, 0},	//70000BEE//AFIT8_bnr_AddNoisePower1   [7:0] AFIT8_bnr_AddNoisePower2			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0},	//70000BF0//AFIT8_bnr_iRadialTune	[7:0] AFIT8_bnr_iRadialPower				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x145A, 0},	//70000BF2//AFIT8_bnr_iRadialLimit	 [7:0] AFIT8_ee_iFSMagThLow 				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1010, 0},	//70000BF4//AFIT8_ee_iFSMagThHigh	[7:0] AFIT8_ee_iFSVarThLow					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000BF6//AFIT8_ee_iFSVarThHigh	[7:0] AFIT8_ee_iFSThLow 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1000, 0},	//70000BF8//AFIT8_ee_iFSThHigh	 [7:0] AFIT8_ee_iFSmagPower 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5A0F, 0},	//70000BFA//AFIT8_ee_iFSVarCountTh	 [7:0] AFIT8_ee_iRadialLimit				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0503, 0},	//70000BFC//AFIT8_ee_iRadialPower	[7:0] AFIT8_ee_iSmoothEdgeSlope 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1802, 0},	//70000BFE//AFIT8_ee_iROADThres   [7:0] AFIT8_ee_iROADMaxNR 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C00//AFIT8_ee_iROADSubMaxNR	 [7:0] AFIT8_ee_iROADSubThres				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2006, 0},	//70000C02//AFIT8_ee_iROADNeiThres	 [7:0] AFIT8_ee_iROADNeiMaxNR				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x3C28, 0},	//70000C04//AFIT8_ee_iSmoothEdgeThres	[7:0] AFIT8_ee_iMSharpen				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x042C, 0},	//70000C06//AFIT8_ee_iWSharpen	 [7:0] AFIT8_ee_iMShThresh						   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000C08//AFIT8_ee_iWShThresh   [7:0] AFIT8_ee_iReduceNegative				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF00, 0},	//70000C0A//AFIT8_ee_iEmbossCentAdd   [7:0] AFIT8_ee_iShDespeckle				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0904, 0},	//70000C0C//AFIT8_ee_iReduceEdgeThresh	 [7:0] AFIT8_dmsc_iEnhThresh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4008, 0},	//70000C0E//AFIT8_dmsc_iDesatThresh   [7:0] AFIT8_dmsc_iDemBlurHigh 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0540, 0},	//70000C10//AFIT8_dmsc_iDemBlurLow	 [7:0] AFIT8_dmsc_iDemBlurRange 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8006, 0},	//70000C12//AFIT8_dmsc_iDecisionThresh	 [7:0] AFIT8_dmsc_iCentGrad 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0},	//70000C14//AFIT8_dmsc_iMonochrom	[7:0] AFIT8_dmsc_iGBDenoiseVal				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C16//AFIT8_dmsc_iGRDenoiseVal   [7:0] AFIT8_dmsc_iEdgeDesatThrHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1800, 0},	//70000C18//AFIT8_dmsc_iEdgeDesatThrLow   [7:0] AFIT8_dmsc_iEdgeDesat			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C1A//AFIT8_dmsc_iNearGrayDesat	[7:0] AFIT8_dmsc_iEdgeDesatLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1E10, 0},	//70000C1C//AFIT8_postdmsc_iBCoeff	 [7:0] AFIT8_postdmsc_iGCoeff				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000C1E//AFIT8_postdmsc_iWideMult   [7:0] AFIT8_yuvemix_mNegSlopes_0 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000C20//AFIT8_yuvemix_mNegSlopes_1	 [7:0] AFIT8_yuvemix_mNegSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},	//70000C22//AFIT8_yuvemix_mNegSlopes_3	 [7:0] AFIT8_yuvemix_mPosSlopes_0		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000C24//AFIT8_yuvemix_mPosSlopes_1	 [7:0] AFIT8_yuvemix_mPosSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0405, 0},	//70000C26//AFIT8_yuvemix_mPosSlopes_3	 [7:0] AFIT8_yuviirnr_iXSupportY		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0206, 0},	//70000C28//AFIT8_yuviirnr_iXSupportUV	 [7:0] AFIT8_yuviirnr_iLowYNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0304, 0},	//70000C2A//AFIT8_yuviirnr_iHighYNorm	[7:0] AFIT8_yuviirnr_iLowUVNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0409, 0},	//70000C2C//AFIT8_yuviirnr_iHighUVNorm	 [7:0] AFIT8_yuviirnr_iYNormShift		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0305, 0},	//70000C2E//AFIT8_yuviirnr_iUVNormShift   [7:0] AFIT8_yuviirnr_iVertLength_Y	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0406, 0},	//70000C30//AFIT8_yuviirnr_iVertLength_UV	[7:0] AFIT8_yuviirnr_iDiffThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2804, 0},	//70000C32//AFIT8_yuviirnr_iDiffThreshH_Y	[7:0] AFIT8_yuviirnr_iDiffThreshL_UV   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0228, 0},	//70000C34//AFIT8_yuviirnr_iDiffThreshH_UV	 [7:0] AFIT8_yuviirnr_iMaxThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1402, 0},	//70000C36//AFIT8_yuviirnr_iMaxThreshH_Y   [7:0] AFIT8_yuviirnr_iMaxThreshL_UV	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0618, 0},	//70000C38//AFIT8_yuviirnr_iMaxThreshH_UV	[7:0] AFIT8_yuviirnr_iYNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1A02, 0},	//70000C3A//AFIT8_yuviirnr_iYNRStrengthH   [7:0] AFIT8_yuviirnr_iUVNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8018, 0},	//70000C3C//AFIT8_yuviirnr_iUVNRStrengthH	[7:0] AFIT8_byr_gras_iShadingPower	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000C3E//AFIT8_RGBGamma2_iLinearity	 [7:0] AFIT8_RGBGamma2_iDarkReduce		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000C40//AFIT8_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0180, 0},	//70000C42//AFIT8_RGB2YUV_iRGBGain	 [7:0] AFIT8_bnr_nClustLevel_H				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A0A, 0},	//70000C44//AFIT8_bnr_iClustMulT_H	 [7:0] AFIT8_bnr_iClustMulT_C				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000C46//AFIT8_bnr_iClustThresh_H   [7:0] AFIT8_bnr_iClustThresh_C			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1117, 0},	//70000C48//AFIT8_bnr_iDenThreshLow   [7:0] AFIT8_bnr_iDenThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//70000C4A//AFIT8_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A0A, 0},	//70000C4C//AFIT8_ee_iLowShDenoise	 [7:0] AFIT8_ee_iHighShDenoise				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},	//70000C4E//AFIT8_ee_iLowSharpClamp   [7:0] AFIT8_ee_iHighSharpClamp			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0808, 0},	//70000C50//AFIT8_ee_iReduceEdgeMinMult   [7:0] AFIT8_ee_iReduceEdgeSlope		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A01, 0},	//70000C52//AFIT8_bnr_nClustLevel_H_Bin   [7:0] AFIT8_bnr_iClustMulT_H_Bin		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x010A, 0},	//70000C54//AFIT8_bnr_iClustMulT_C_Bin	 [7:0] AFIT8_bnr_iClustThresh_H_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1501, 0},	//70000C56//AFIT8_bnr_iClustThresh_C_Bin   [7:0] AFIT8_bnr_iDenThreshLow_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x240F, 0},	//70000C58//AFIT8_bnr_iDenThreshHigh_Bin   [7:0] AFIT8_ee_iLowSharpPower_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A60, 0},	//70000C5A//AFIT8_ee_iHighSharpPower_Bin   [7:0] AFIT8_ee_iLowShDenoise_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF0A, 0},	//70000C5C//AFIT8_ee_iHighShDenoise_Bin   [7:0] AFIT8_ee_iLowSharpClamp_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x08FF, 0},	//70000C5E//AFIT8_ee_iHighSharpClamp_Bin   [7:0] AFIT8_ee_iReduceEdgeMinMult_Bin   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},	//70000C60//AFIT8_ee_iReduceEdgeSlope_Bin [7:0] 								   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//70000C62//AFITB_bnr_nClustLevel_C 	 [0]										
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C64//AFIT16_BRIGHTNESS			
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C66//AFIT16_CONTRAST 													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C68//AFIT16_SATURATION													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C6A//AFIT16_SHARP_BLUR													   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000C6C//AFIT16_GLAMOUR														   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00C0, 0},	//70000C6E//AFIT16_bnr_edge_high												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0064, 0},	//70000C70//AFIT16_postdmsc_iLowBright											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0384, 0},	//70000C72//AFIT16_postdmsc_iHighBright 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0032, 0},	//70000C74//AFIT16_postdmsc_iLowSat 											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01F4, 0},	//70000C76//AFIT16_postdmsc_iHighSat											   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0070, 0},	//70000C78//AFIT16_postdmsc_iTune												   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},	//70000C7A//AFIT16_yuvemix_mNegRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x00A0, 0},	//70000C7C//AFIT16_yuvemix_mNegRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000C7E//AFIT16_yuvemix_mNegRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},	//70000C80//AFIT16_yuvemix_mPosRanges_0 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0060, 0},	//70000C82//AFIT16_yuvemix_mPosRanges_1 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//70000C84//AFIT16_yuvemix_mPosRanges_2 										   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1430, 0},	//70000C86//AFIT8_bnr_edge_low	[7:0] AFIT8_bnr_repl_thresh 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//70000C88//AFIT8_bnr_repl_force  [7:0] AFIT8_bnr_iHotThreshHigh				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0204, 0},	//70000C8A//AFIT8_bnr_iHotThreshLow   [7:0] AFIT8_bnr_iColdThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0F04, 0},	//70000C8C//AFIT8_bnr_iColdThreshLow   [7:0] AFIT8_bnr_DispTH_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x030C, 0},	//70000C8E//AFIT8_bnr_DispTH_High	[7:0] AFIT8_bnr_DISP_Limit_Low				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0003, 0},	//70000C90//AFIT8_bnr_DISP_Limit_High	[7:0] AFIT8_bnr_iDistSigmaMin			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0602, 0},	//70000C92//AFIT8_bnr_iDistSigmaMax   [7:0] AFIT8_bnr_iDiffSigmaLow 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1803, 0},	//70000C94//AFIT8_bnr_iDiffSigmaHigh   [7:0] AFIT8_bnr_iNormalizedSTD_TH		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0040, 0},	//70000C96//AFIT8_bnr_iNormalizedSTD_Limit	 [7:0] AFIT8_bnr_iDirNRTune 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0E20, 0},	//70000C98//AFIT8_bnr_iDirMinThres	 [7:0] AFIT8_bnr_iDirFltDiffThresHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2018, 0},	//70000C9A//AFIT8_bnr_iDirFltDiffThresLow	[7:0] AFIT8_bnr_iDirSmoothPowerHigh    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0620, 0},	//70000C9C//AFIT8_bnr_iDirSmoothPowerLow   [7:0] AFIT8_bnr_iLowMaxSlopeAllowed	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000C9E//AFIT8_bnr_iHighMaxSlopeAllowed	 [7:0] AFIT8_bnr_iLowSlopeThresh	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2003, 0},	//70000CA0//AFIT8_bnr_iHighSlopeThresh	 [7:0] AFIT8_bnr_iSlopenessTH			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF01, 0},	//70000CA2//AFIT8_bnr_iSlopeBlurStrength   [7:0] AFIT8_bnr_iSlopenessLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0404, 0},	//70000CA4//AFIT8_bnr_AddNoisePower1   [7:0] AFIT8_bnr_AddNoisePower2			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0200, 0},	//70000CA6//AFIT8_bnr_iRadialTune	[7:0] AFIT8_bnr_iRadialPower				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x145A, 0},	//70000CA8//AFIT8_bnr_iRadialLimit	 [7:0] AFIT8_ee_iFSMagThLow 				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1010, 0},	//70000CAA//AFIT8_ee_iFSMagThHigh	[7:0] AFIT8_ee_iFSVarThLow					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000CAC//AFIT8_ee_iFSVarThHigh	[7:0] AFIT8_ee_iFSThLow 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1200, 0},	//70000CAE//AFIT8_ee_iFSThHigh	 [7:0] AFIT8_ee_iFSmagPower 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x5A0F, 0},	//70000CB0//AFIT8_ee_iFSVarCountTh	 [7:0] AFIT8_ee_iRadialLimit				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0502, 0},	//70000CB2//AFIT8_ee_iRadialPower	[7:0] AFIT8_ee_iSmoothEdgeSlope 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1802, 0},	//70000CB4//AFIT8_ee_iROADThres   [7:0] AFIT8_ee_iROADMaxNR 					   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000CB6//AFIT8_ee_iROADSubMaxNR	 [7:0] AFIT8_ee_iROADSubThres				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2006, 0},	//70000CB8//AFIT8_ee_iROADNeiThres	 [7:0] AFIT8_ee_iROADNeiMaxNR				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4028, 0},	//70000CBA//AFIT8_ee_iSmoothEdgeThres	[7:0] AFIT8_ee_iMSharpen				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0430, 0},	//70000CBC//AFIT8_ee_iWSharpen	 [7:0] AFIT8_ee_iMShThresh						   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000CBE//AFIT8_ee_iWShThresh   [7:0] AFIT8_ee_iReduceNegative				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF00, 0},	//70000CC0//AFIT8_ee_iEmbossCentAdd   [7:0] AFIT8_ee_iShDespeckle				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0804, 0},	//70000CC2//AFIT8_ee_iReduceEdgeThresh	 [7:0] AFIT8_dmsc_iEnhThresh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4008, 0},	//70000CC4//AFIT8_dmsc_iDesatThresh   [7:0] AFIT8_dmsc_iDemBlurHigh 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0540, 0},	//70000CC6//AFIT8_dmsc_iDemBlurLow	 [7:0] AFIT8_dmsc_iDemBlurRange 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8006, 0},	//70000CC8//AFIT8_dmsc_iDecisionThresh	 [7:0] AFIT8_dmsc_iCentGrad 			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0020, 0},	//70000CCA//AFIT8_dmsc_iMonochrom	[7:0] AFIT8_dmsc_iGBDenoiseVal				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000CCC//AFIT8_dmsc_iGRDenoiseVal   [7:0] AFIT8_dmsc_iEdgeDesatThrHigh		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1800, 0},	//70000CCE//AFIT8_dmsc_iEdgeDesatThrLow   [7:0] AFIT8_dmsc_iEdgeDesat			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000CD0//AFIT8_dmsc_iNearGrayDesat	[7:0] AFIT8_dmsc_iEdgeDesatLimit		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1E10, 0},	//70000CD2//AFIT8_postdmsc_iBCoeff	 [7:0] AFIT8_postdmsc_iGCoeff				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000B, 0},	//70000CD4//AFIT8_postdmsc_iWideMult   [7:0] AFIT8_yuvemix_mNegSlopes_0 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000CD6//AFIT8_yuvemix_mNegSlopes_1	 [7:0] AFIT8_yuvemix_mNegSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0},	//70000CD8//AFIT8_yuvemix_mNegSlopes_3	 [7:0] AFIT8_yuvemix_mPosSlopes_0		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0607, 0},	//70000CDA//AFIT8_yuvemix_mPosSlopes_1	 [7:0] AFIT8_yuvemix_mPosSlopes_2		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0405, 0},	//70000CDC//AFIT8_yuvemix_mPosSlopes_3	 [7:0] AFIT8_yuviirnr_iXSupportY		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0205, 0},	//70000CDE//AFIT8_yuviirnr_iXSupportUV	 [7:0] AFIT8_yuviirnr_iLowYNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0304, 0},	//70000CE0//AFIT8_yuviirnr_iHighYNorm	[7:0] AFIT8_yuviirnr_iLowUVNorm 		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0409, 0},	//70000CE2//AFIT8_yuviirnr_iHighUVNorm	 [7:0] AFIT8_yuviirnr_iYNormShift		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0306, 0},	//70000CE4//AFIT8_yuviirnr_iUVNormShift   [7:0] AFIT8_yuviirnr_iVertLength_Y	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0407, 0},	//70000CE6//AFIT8_yuviirnr_iVertLength_UV	[7:0] AFIT8_yuviirnr_iDiffThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x2C04, 0},	//70000CE8//AFIT8_yuviirnr_iDiffThreshH_Y	[7:0] AFIT8_yuviirnr_iDiffThreshL_UV   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x022C, 0},	//70000CEA//AFIT8_yuviirnr_iDiffThreshH_UV	 [7:0] AFIT8_yuviirnr_iMaxThreshL_Y    
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1402, 0},	//70000CEC//AFIT8_yuviirnr_iMaxThreshH_Y   [7:0] AFIT8_yuviirnr_iMaxThreshL_UV	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0618, 0},	//70000CEE//AFIT8_yuviirnr_iMaxThreshH_UV	[7:0] AFIT8_yuviirnr_iYNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x1A02, 0},	//70000CF0//AFIT8_yuviirnr_iYNRStrengthH   [7:0] AFIT8_yuviirnr_iUVNRStrengthL	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x8018, 0},	//70000CF2//AFIT8_yuviirnr_iUVNRStrengthH	[7:0] AFIT8_byr_gras_iShadingPower	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000CF4//AFIT8_RGBGamma2_iLinearity	 [7:0] AFIT8_RGBGamma2_iDarkReduce		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0080, 0},	//70000CF6//AFIT8_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0180, 0},	//70000CF8//AFIT8_RGB2YUV_iRGBGain	 [7:0] AFIT8_bnr_nClustLevel_H				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A0A, 0},	//70000CFA//AFIT8_bnr_iClustMulT_H	 [7:0] AFIT8_bnr_iClustMulT_C				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//70000CFC//AFIT8_bnr_iClustThresh_H   [7:0] AFIT8_bnr_iClustThresh_C			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0C0F, 0},	//70000CFE//AFIT8_bnr_iDenThreshLow   [7:0] AFIT8_bnr_iDenThreshHigh			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//70000D00//AFIT8_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0808, 0},	//70000D02//AFIT8_ee_iLowShDenoise	 [7:0] AFIT8_ee_iHighShDenoise				   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},	//70000D04//AFIT8_ee_iLowSharpClamp   [7:0] AFIT8_ee_iHighSharpClamp			   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0808, 0},	//70000D06//AFIT8_ee_iReduceEdgeMinMult   [7:0] AFIT8_ee_iReduceEdgeSlope		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A01, 0},	//70000D08//AFIT8_bnr_nClustLevel_H_Bin   [7:0] AFIT8_bnr_iClustMulT_H_Bin		   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x010A, 0},	//70000D0A//AFIT8_bnr_iClustMulT_C_Bin	 [7:0] AFIT8_bnr_iClustThresh_H_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0F01, 0},	//70000D0C//AFIT8_bnr_iClustThresh_C_Bin   [7:0] AFIT8_bnr_iDenThreshLow_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x240C, 0},	//70000D0E//AFIT8_bnr_iDenThreshHigh_Bin   [7:0] AFIT8_ee_iLowSharpPower_Bin	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0860, 0},	//70000D10//AFIT8_ee_iHighSharpPower_Bin   [7:0] AFIT8_ee_iLowShDenoise_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFF08, 0},	//70000D12//AFIT8_ee_iHighShDenoise_Bin   [7:0] AFIT8_ee_iLowSharpClamp_Bin 	   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x08FF, 0},	//70000D14//AFIT8_ee_iHighSharpClamp_Bin   [7:0] AFIT8_ee_iReduceEdgeMinMult_Bin   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0008, 0},	//70000D16//AFIT8_ee_iReduceEdgeSlope_Bin [7:0] 								   
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//70000D18//AFITB_bnr_nClustLevel_C 	 [0]										
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x23CE, 0},	//70000D19//ConstAfitBaseVals
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFDC8, 0},	//70000D1A//ConstAfitBaseVals
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x112E, 0},	//70000D1B//ConstAfitBaseVals
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x93A5, 0},	//70000D1C//ConstAfitBaseVals
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0xFE67, 0},	//70000D1D//ConstAfitBaseVals
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//70000D1E//ConstAfitBaseVals


{SI2C_WR, SI2C_A2D2, 0x002A, 0x0250, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A00, 0},	//REG_TC_GP_PrevReqInputWidth
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0780, 0},	//REG_TC_GP_PrevReqInputHeight
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},	//REG_TC_GP_PrevInputWidthOfs
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000c, 0},	//REG_TC_GP_PrevInputHeightOfs
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A00, 0},	//REG_TC_GP_CapReqInputWidth
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0780, 0},	//REG_TC_GP_CapReqInputHeight
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0010, 0},	//REG_TC_GP_CapInputWidthOfs
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000c, 0},	//REG_TC_GP_CapInputHeightOfs


{SI2C_WR, SI2C_A2D2, 0x002A, 0x0494, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A00, 0},	//REG_TC_PZOOM_ZoomInputWidth	 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0780, 0},	//REG_TC_PZOOM_ZoomInputHeight	 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_PZOOM_ZoomInputWidthOfs 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_PZOOM_ZoomInputHeightOfs
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A00, 0},	//REG_TC_CZOOM_ZoomInputWidth	 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0780, 0},	//REG_TC_CZOOM_ZoomInputHeight	 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_CZOOM_ZoomInputWidthOfs 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_CZOOM_ZoomInputHeightOfs


{SI2C_WR, SI2C_A2D2, 0x002A, 0x0262, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_bUseReqInputInPre 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_bUseReqInputInCap

{SI2C_WR, SI2C_A2D2, 0x002A, 0x02A6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0500, 0}, //REG_0TC_PCFG_usWidth
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x03C0, 0}, //REG_0TC_PCFG_usHeight
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0}, //REG_0TC_PCFG_Format
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_0TC_PCFG_usMaxOut4KHzRate
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_0TC_PCFG_usMinOut4KHzRate
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //REG_0TC_PCFG_OutClkPerPix88
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0}, //REG_0TC_PCFG_uBpp88
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_OIFMask
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01E0, 0}, //REG_0TC_PCFG_usJpegPacketSize
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usJpegTotalPackets
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_uClockInd
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0535, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x014D, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02D0, 0}, 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000F, 0}, //REG_0TC_PCFG_uPrevMirror
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000F, 0}, //REG_0TC_PCFG_uCaptureMirror

{SI2C_WR, SI2C_A2D2, 0x002A, 0x02D6, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A00, 0}, //REG_1TC_PCFG_usWidth
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0780, 0}, //REG_1TC_PCFG_usHeight
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0}, //REG_1TC_PCFG_Format
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_1TC_PCFG_usMaxOut4KHzRate
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_1TC_PCFG_usMinOut4KHzRate
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //REG_1TC_PCFG_OutClkPerPix88
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0}, //REG_1TC_PCFG_uBpp88
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_1TC_PCFG_PVIMask
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_1TC_PCFG_OIFMask
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01E0, 0}, //REG_1TC_PCFG_usJpegPacketSize
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_1TC_PCFG_usJpegTotalPackets
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_1TC_PCFG_uClockInd
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_1TC_PCFG_usFrTimeType
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_1TC_PCFG_FrRateQualityType
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02A6, 0}, //REG_1TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x02A6, 0}, //REG_1TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0300, 0}, 
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000F, 0}, //REG_1TC_PCFG_uPrevMirror
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x000F, 0}, //REG_1TC_PCFG_uCaptureMirror

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0396, 0},
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_CCFG_uCaptureMode
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0A00, 0}, //REG_0TC_CCFG_usWidth
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0780, 0}, //REG_0TC_CCFG_usHeight
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0005, 0}, //REG_0TC_CCFG_Format
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_0TC_CCFG_usMaxOut4KHzRate
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x4F1A, 0}, //REG_0TC_CCFG_usMinOut4KHzRate
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //REG_0TC_CCFG_OutClkPerPix88
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0300, 0}, //REG_0TC_CCFG_uBpp88
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_CCFG_PVIMask
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_CCFG_OIFMask
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x01E0, 0}, //REG_0TC_CCFG_usJpegPacketSize
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_CCFG_usJpegTotalPackets
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_CCFG_uClockInd
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_CCFG_usFrTimeType
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_CCFG_FrRateQualityType
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0535, 0}, //REG_0TC_CCFG_usMaxFrTimeMsecMult10
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_CCFG_usMinFrTimeMsecMult10

{SI2C_WR, SI2C_A2D2, 0x002A, 0x022C, 0},	
{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_IPRM_InitParamsUpdated

{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0f12, 0x0001, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActiveCapConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_CapOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_CapConfigChanged

{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
//{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
//{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreview
//{SI2C_BWR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreviewChanged

{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x01A6, 0}, //ESD Check
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0A0A, 0},

{SI2C_WR, SI2C_A2D2, 0x0028, 0x147C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0180, 0}, //bp_uMaxBrightnessFactor
{SI2C_WR, SI2C_A2D2, 0x0028, 0x1482, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0180, 0}, //bp_uMinBrightnessFactor

{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},

//{SI2C_DELAY, SI2C_A1D1, 0, 0, 150},
//{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_start_stream[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_DELAY, SI2C_A1D1, 0, 0, 150}, //Delay 300ms
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_stop_stream[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0}, 
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_DELAY, SI2C_A1D1, 0, 0, 150}, //Delay 300ms
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_preview_2560_1920[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026e, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActiveCapConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026a, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_CapOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_CapConfigChanged			
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync

//{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreview
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreviewChanged

// 5M 15fps setting
//{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
//{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
//{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0}, 
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
//{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_1TC_PCFG_FrRateQualityType
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x02CA, 0}, //REG_1TC_PCFG_usMaxFrTimeMsecMult10
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_1TC_PCFG_usMinFrTimeMsecMult10
//{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_ActivePrevConfig
//{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
//{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
//{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
//{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 150},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},

};

static const si2c_cmd_t s5k4ecgx_cfg_preview[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0242, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_EnableCapture
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0244, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnableCaptureChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 120},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_snapshot[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActiveCapConfig
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_CapConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0242, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnableCapture
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0244, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnableCaptureChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 120},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_af_trigger[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x028E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x028C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0005, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_0[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x003C, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_m1[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0036, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_m2[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0030, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_m3[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x002A, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_m4[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0024, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_p1[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0047, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_p2[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0052, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_p3[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0057, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_brightness_p4[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0068, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_normal_2560_1920[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x003C, 0},	//TVAR_ae_BrAve

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1492, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//ae_WeightTbl_16_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//ae_WeightTbl_16_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_7_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_8_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_9_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_10_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_11_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_12_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0302, 0},	//ae_WeightTbl_16_13_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0203, 0},	//ae_WeightTbl_16_14_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_15_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_16_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0302, 0},	//ae_WeightTbl_16_17_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0203, 0},	//ae_WeightTbl_16_18_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_19_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_20_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_21_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_22_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_23_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_24_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_25_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_26_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_27_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_28_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_29_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_30_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_31_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A28, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0ADE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0B94, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0C4A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0D00, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0234, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_UserSaturation 	   
{SI2C_WR, SI2C_A2D2, 0x002A, 0x06B8, 0},					
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x452C, 0},					
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0005, 0},	//lt_uMaxLei 
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A1E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0348, 0}, 	//350 //_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0638, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0A3C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_1_					 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0D05, 0}, 	//D04
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_2_					 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6810, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x8214, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_7_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_8_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_9_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x02C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x02A6, 0},	//15fps REG_0TC_PCFG_usMaxFrTimeMsecMult10 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x02A6, 0},	//15fps REG_0TC_PCFG_usMinFrTimeMsecMult10 

{SI2C_WR, SI2C_A2D2, 0x002A, 0x03B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0535, 0},	//REG_0TC_CCFG_usMaxFrTimeMsecMult10 //0535h:7.5fps
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, 	//29A //REG_0TC_CCFG_usMinFrTimeMsecMult10

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0938, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//afit_bUseNB_Afit

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0F2A, 0},	//AFC_Default60Hz	 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//00:50Hz 01:60Hz  

{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x077F, 0},	//REG_TC_DBG_AutoAlgEnBits

{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_SF_USER_IsoType 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_SF_USER_IsoVal
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_SF_USER_IsoChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x06C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0200, 0},	//lt_bUseSecISODgain

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1648, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x9002, 0},	//af_search_usSingleAfFlags
{SI2C_WR, SI2C_A2D2, 0x002A, 0x15E8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0007, 0},		//af_pos_usTableLastInd
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000A, 0},		//af_pos_usTable_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x001E, 0},		//af_pos_usTable_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0032, 0},		//af_pos_usTable_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0044, 0},		//af_pos_usTable_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0055, 0},		//af_pos_usTable_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0078, 0},		//af_pos_usTable_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0091, 0},		//af_pos_usTable_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00B4, 0},		//af_pos_usTable_7_


{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_CapConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreview
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreviewChanged

{SI2C_DELAY, SI2C_A1D1, 0, 0, 350},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_scene_normal_1280_960[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x003C, 0},	//TVAR_ae_BrAve

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1492, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0100, 0},	//ae_WeightTbl_16_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//ae_WeightTbl_16_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_7_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_8_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_9_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_10_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_11_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_12_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0302, 0},	//ae_WeightTbl_16_13_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0203, 0},	//ae_WeightTbl_16_14_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_15_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_16_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0302, 0},	//ae_WeightTbl_16_17_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0203, 0},	//ae_WeightTbl_16_18_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_19_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_20_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_21_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},	//ae_WeightTbl_16_22_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_23_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_24_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},	//ae_WeightTbl_16_25_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},	//ae_WeightTbl_16_26_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_27_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_28_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_29_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_30_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},	//ae_WeightTbl_16_31_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A28, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0ADE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0B94, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0C4A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0D00, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6024, 0},	//_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0234, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_UserSaturation 	   
{SI2C_WR, SI2C_A2D2, 0x002A, 0x06B8, 0},					
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x452C, 0},					
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0005, 0},	//lt_uMaxLei 
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A1E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0348, 0}, 	//350 //_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0638, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0A3C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_1_					 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0D05, 0}, 	//D04
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_2_					 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6810, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x8214, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_7_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_8_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xC350, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_9_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x02C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0535, 0},	//7.5fps REG_0TC_PCFG_usMaxFrTimeMsecMult10 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x014D, 0},	//30fps REG_0TC_PCFG_usMinFrTimeMsecMult10 

{SI2C_WR, SI2C_A2D2, 0x002A, 0x03B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0535, 0},	//REG_0TC_CCFG_usMaxFrTimeMsecMult10 //0535h:7.5fps
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, 	//29A //REG_0TC_CCFG_usMinFrTimeMsecMult10

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0938, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//afit_bUseNB_Afit

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0F2A, 0},	//AFC_Default60Hz	 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//00:50Hz 01:60Hz  

{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x077F, 0},	//REG_TC_DBG_AutoAlgEnBits

{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_SF_USER_IsoType 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_SF_USER_IsoVal
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_SF_USER_IsoChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x06C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0200, 0},	//lt_bUseSecISODgain

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1648, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x9002, 0},	//af_search_usSingleAfFlags
{SI2C_WR, SI2C_A2D2, 0x002A, 0x15E8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0007, 0},		//af_pos_usTableLastInd
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000A, 0},		//af_pos_usTable_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x001E, 0},		//af_pos_usTable_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0032, 0},		//af_pos_usTable_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0044, 0},		//af_pos_usTable_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0055, 0},		//af_pos_usTable_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0078, 0},		//af_pos_usTable_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0091, 0},		//af_pos_usTable_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00B4, 0},		//af_pos_usTable_7_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_CapConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreview
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreviewChanged

{SI2C_DELAY, SI2C_A1D1, 0, 0, 350},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_portrait[] = {
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A28, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x4020, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0ADE, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x4020, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0B94, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x4020, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0C4A, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x4020, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0D00, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x4020, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_landscape[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1492, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0}, //ae_WeightTbl_16[0]
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A28, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xE082, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0ADE, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xE082, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0B94, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xE082, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0C4A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xE082, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0D00, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xE082, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0234, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0030, 0}, //REG_TC_UserSaturation 
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_party_indoor[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0938, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //afit_bUseNB_Afit
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x065F, 0}, //REG_TC_DBG 7F: 60Hz  5F:50Hz	  
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_SF_USER_FlickerQuant	  
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_FlickerQuantChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_IsoType   
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0340, 0}, //REG_SF_USER_IsoVal	  
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_IsoChanged 
{SI2C_WR, SI2C_A2D2, 0x002A, 0x06C2, 0},						  
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //lt_bUseSecISODgain	
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0234, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0030, 0}, //REG_TC_UserSaturation 
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_sports_2560_1920[] = {
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0638, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0A3C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0D05, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0938, 0},  
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, // on/off AFIT by NB option

{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0003, 0}, //REG_SF_USER_IsoType 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0200, 0}, //REG_SF_USER_IsoVal
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_IsoChanged				

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_ActivePrevConfig

{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange

{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_CapConfigChanged

{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreview
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreviewChanged
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_sports_1280_960[] = {
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0638, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0A3C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0D05, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x3408, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0938, 0},  
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	// on/off AFIT by NB option

{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0003, 0}, //REG_SF_USER_IsoType 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0200, 0}, //REG_SF_USER_IsoVal
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_IsoChanged				

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig

{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange

{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_CapConfigChanged

{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreview
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_EnablePreviewChanged
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_night_2560_1920[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x06B8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},	//lt_uMaxLei
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00FF, 0},	//lt_usMinExp

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A1E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x15C0, 0},	//_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0638, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1478, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A0A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6810, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6810, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xD020, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0428, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A80, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0006, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_7_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A80, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0006, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_8_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A80, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0006, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_9_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x02C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x09C4, 0},	//REG_0TC_PCFG_usMaxFrTimeMsecMult10 //09C4h:4fps
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x02A6, 0},	//REG_0TC_PCFG_usMinFrTimeMsecMult10 //01F4h:15fps

{SI2C_WR, SI2C_A2D2, 0x002A, 0x03B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1388, 0},	//REG_0TC_CCFG_usMaxFrTimeMsecMult10 //1388h:2fps
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1388, 0},	//REG_0TC_CCFG_usMinFrTimeMsecMult10 //1388h:2fps

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1648, 0},	//af_search_usSingleAfFlags
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x9000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x15E8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0007, 0},		//af_pos_usTableLastInd
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000A, 0},		//af_pos_usTable_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x001E, 0},		//af_pos_usTable_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0032, 0},		//af_pos_usTable_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0044, 0},		//af_pos_usTable_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0055, 0},		//af_pos_usTable_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0078, 0},		//af_pos_usTable_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0091, 0},		//af_pos_usTable_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00B4, 0},		//af_pos_usTable_7_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_CapConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreview
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreviewChanged
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_scene_night_1280_960[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x06B8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xFFFF, 0},	//lt_uMaxLei
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00FF, 0},	//lt_usMinExp

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A1E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x15C0, 0},	//_ccm_oscar_iSaturation   [7:0] AFIT8_RGB2YUV_iYOffset

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0638, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1478, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A0A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6810, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x6810, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xD020, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0428, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A80, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0006, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_7_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A80, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0006, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_8_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1A80, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0006, 0},	//lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_9_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x02C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x09C4, 0},	//REG_0TC_PCFG_usMaxFrTimeMsecMult10 //09C4h:4fps
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x01F4, 0},	//REG_0TC_PCFG_usMinFrTimeMsecMult10 //01F4h:20fps

{SI2C_WR, SI2C_A2D2, 0x002A, 0x03B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1388, 0},	//REG_0TC_CCFG_usMaxFrTimeMsecMult10 //1388h:2fps
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x1388, 0},	//REG_0TC_CCFG_usMinFrTimeMsecMult10 //1388h:2fps

{SI2C_WR, SI2C_A2D2, 0x002A, 0x1648, 0},	//af_search_usSingleAfFlags
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x9000, 0},

{SI2C_WR, SI2C_A2D2, 0x002A, 0x15E8, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0007, 0},		//af_pos_usTableLastInd
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x000A, 0},		//af_pos_usTable_0_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x001E, 0},		//af_pos_usTable_1_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0032, 0},		//af_pos_usTable_2_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0044, 0},		//af_pos_usTable_3_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0055, 0},		//af_pos_usTable_4_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0078, 0},		//af_pos_usTable_5_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0091, 0},		//af_pos_usTable_6_
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00B4, 0},		//af_pos_usTable_7_

{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},	//REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0270, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_CapConfigChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreview
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},	//REG_TC_GP_EnablePreviewChanged
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_beach_snow[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1484, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0045, 0}, //TVAR_ae_BrAve
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0938, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //afit_bUseNB_Afit
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x065F, 0}, 
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_SF_USER_FlickerQuant	   
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_FlickerQuantChanged
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04D0, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_IsoType    
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x00D0, 0}, //REG_SF_USER_IsoVal	   
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_SF_USER_IsoChanged 
{SI2C_WR, SI2C_A2D2, 0x002A, 0x06C2, 0},						   
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0100, 0}, //lt_bUseSecISODgain	
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0234, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0030, 0}, //REG_TC_UserSaturation
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_sunset[] = {
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},  
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0777, 0}, //REG_TC_DBG 7F: 60Hz  5F:50Hz
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BA, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x05E0, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0400, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0530, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_scene_text[] = {
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0A28, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xA060, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0ADE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xA060, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0B94, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xA060, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0C4A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xA060, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0D00, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0xA060, 0}, //_ee_iLowSharpPower   [7:0] AFIT8_ee_iHighSharpPower	
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_effect_mono[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_effect_negative[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0003, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_effect_off[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_effect_sepia[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0004, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_effect_solarize[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x023C, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_exposure_center[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1492, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0100, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0302, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0203, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0302, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0203, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0201, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0102, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0202, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},	//REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_exposure_average[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1492, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},	//REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_exposure_spot[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x1492, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x010F, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0F01, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x010F, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0F01, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0101, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},	//REG_TC_GP_PrevConfigChanged
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed7[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0594, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0594, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed8[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x04E2, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x04E2, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed10[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x03E8, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x03E8, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed14[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x02CA, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x02CA, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed15[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x029A, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x029A, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed20[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x01F4, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x01F4, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed24[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x01A0, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x01A0, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed25[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0190, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0190, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};

static const si2c_cmd_t s5k4ecgx_cfg_fps_fixed30[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x014D, 0}, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x014D, 0}, //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};



/* 7.5 ~ 30 fps 1280_960, PANTECH_CAMERA_TODO */

static const si2c_cmd_t s5k4ecgx_cfg_fps_variable[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02B4, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0002, 0}, //REG_0TC_PCFG_PVIMask
{SI2C_WR, SI2C_A2D2, 0x002A, 0x02BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_0TC_PCFG_usFrTimeType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_0TC_PCFG_FrRateQualityType
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0535, 0}, //7.5fps //REG_0TC_PCFG_usMaxFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x014d, 0}, //30fps //REG_0TC_PCFG_usMinFrTimeMsecMult10
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0266, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0000, 0}, //REG_TC_GP_ActivePrevConfig
{SI2C_WR, SI2C_A2D2, 0x002A, 0x026A, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevOpenAfterChange
{SI2C_WR, SI2C_A2D2, 0x002A, 0x024E, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_NewConfigSync
{SI2C_WR, SI2C_A2D2, 0x002A, 0x0268, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0}, //REG_TC_GP_PrevConfigChanged
{SI2C_DELAY, SI2C_A1D1, 0, 0, 150},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};



static const si2c_cmd_t s5k4ecgx_cfg_reflect_mirror[] = {
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_reflect_mirror_water[] = {
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_reflect_off[] = {
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_reflect_water[] = {
{SI2C_DELAY, SI2C_A1D1, 0, 0, 100},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_wb_auto[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x077F, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_wb_cloudy[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0777, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BA, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x06D0, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x03D0, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0520, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_wb_daylight[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0777, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BA, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0620, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x03D0, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0580, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_wb_fluorescent[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0}, 
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0777, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BA, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0600, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0440, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x09E0, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


static const si2c_cmd_t s5k4ecgx_cfg_wb_incandescent[] = {
{SI2C_WR, SI2C_A2D2, 0xFCFC, 0xD000, 0},
{SI2C_WR, SI2C_A2D2, 0x0028, 0x7000, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04E6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0777, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BA, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0430, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04BE, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x03D0, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C2, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x09F0, 0},
{SI2C_WR, SI2C_A2D2, 0x002A, 0x04C6, 0},
{SI2C_WR, SI2C_A2D2, 0x0F12, 0x0001, 0},
{SI2C_EOC, SI2C_A1D1, 0, 0, 0},
};


const si2c_const_param_t s5k4ecgx_const_params[SI2C_PID_MAX] = {
{SI2C_INIT,		s5k4ecgx_cfg_init},

{SI2C_PREVIEW,		s5k4ecgx_cfg_preview},
{SI2C_SNAPSHOT,		s5k4ecgx_cfg_snapshot},
{SI2C_ZSL,		s5k4ecgx_cfg_preview_2560_1920},
{SI2C_START_STREAM,		s5k4ecgx_cfg_start_stream},
{SI2C_STOP_STREAM, 	s5k4ecgx_cfg_stop_stream},

{SI2C_AF_TRIGGER,	s5k4ecgx_cfg_af_trigger},

{SI2C_BRIGHTNESS_0,	s5k4ecgx_cfg_brightness_0},
{SI2C_BRIGHTNESS_M1,	s5k4ecgx_cfg_brightness_m1},
{SI2C_BRIGHTNESS_M2,	s5k4ecgx_cfg_brightness_m2},
{SI2C_BRIGHTNESS_M3,	s5k4ecgx_cfg_brightness_m3},
{SI2C_BRIGHTNESS_M4,	s5k4ecgx_cfg_brightness_m4},
{SI2C_BRIGHTNESS_P1,	s5k4ecgx_cfg_brightness_p1},
{SI2C_BRIGHTNESS_P2,	s5k4ecgx_cfg_brightness_p2},
{SI2C_BRIGHTNESS_P3,	s5k4ecgx_cfg_brightness_p3},
{SI2C_BRIGHTNESS_P4,	s5k4ecgx_cfg_brightness_p4},

{SI2C_SCENE_NORMAL,			s5k4ecgx_cfg_scene_normal_1280_960},
{SI2C_SCENE_ZSL_NORMAL,		s5k4ecgx_cfg_scene_normal_2560_1920},
{SI2C_SCENE_PORTRAIT,		s5k4ecgx_cfg_scene_portrait},
{SI2C_SCENE_LANDSCAPE,		s5k4ecgx_cfg_scene_landscape},
{SI2C_SCENE_PARTY_INDOOR,	s5k4ecgx_cfg_scene_party_indoor},
{SI2C_SCENE_SPORTS,			s5k4ecgx_cfg_scene_sports_1280_960},
{SI2C_SCENE_ZSL_SPORTS,		s5k4ecgx_cfg_scene_sports_2560_1920},
{SI2C_SCENE_NIGHT,			s5k4ecgx_cfg_scene_night_1280_960},
{SI2C_SCENE_ZSL_NIGHT,		s5k4ecgx_cfg_scene_night_2560_1920},
{SI2C_SCENE_BEACH,			s5k4ecgx_cfg_scene_beach_snow},
{SI2C_SCENE_SNOW,			s5k4ecgx_cfg_scene_beach_snow},
{SI2C_SCENE_SUNSET,			s5k4ecgx_cfg_scene_sunset},
{SI2C_SCENE_TEXT,			s5k4ecgx_cfg_scene_text},

{SI2C_EFFECT_MONO,	s5k4ecgx_cfg_effect_mono},
{SI2C_EFFECT_NEGATIVE,	s5k4ecgx_cfg_effect_negative},
{SI2C_EFFECT_OFF,	s5k4ecgx_cfg_effect_off},
{SI2C_EFFECT_SEPIA,	s5k4ecgx_cfg_effect_sepia},
{SI2C_EFFECT_SOLARIZE,	s5k4ecgx_cfg_effect_solarize},

{SI2C_EXPOSURE_AVERAGE,	s5k4ecgx_cfg_exposure_average},
{SI2C_EXPOSURE_CENTER,	s5k4ecgx_cfg_exposure_center},
{SI2C_EXPOSURE_SPOT,	s5k4ecgx_cfg_exposure_spot},

{SI2C_FPS_FIXED7,	s5k4ecgx_cfg_fps_fixed7},
{SI2C_FPS_FIXED8,	s5k4ecgx_cfg_fps_fixed8},
{SI2C_FPS_FIXED10,	s5k4ecgx_cfg_fps_fixed10},
{SI2C_FPS_FIXED14,	s5k4ecgx_cfg_fps_fixed14},
{SI2C_FPS_FIXED15,	s5k4ecgx_cfg_fps_fixed15},
{SI2C_FPS_FIXED20,	s5k4ecgx_cfg_fps_fixed20},
{SI2C_FPS_FIXED24,	s5k4ecgx_cfg_fps_fixed24},
{SI2C_FPS_FIXED25,	s5k4ecgx_cfg_fps_fixed25},
{SI2C_FPS_FIXED30,	s5k4ecgx_cfg_fps_fixed30},
{SI2C_FPS_VARIABLE,	s5k4ecgx_cfg_fps_variable},

{SI2C_REFLECT_MIRROR,	s5k4ecgx_cfg_reflect_mirror},
{SI2C_REFLECT_MIRROR_WATER,	s5k4ecgx_cfg_reflect_mirror_water},
{SI2C_REFLECT_OFF,	s5k4ecgx_cfg_reflect_off},
{SI2C_REFLECT_WATER,	s5k4ecgx_cfg_reflect_water},

{SI2C_WB_AUTO,		s5k4ecgx_cfg_wb_auto},
{SI2C_WB_CLOUDY,	s5k4ecgx_cfg_wb_cloudy},
{SI2C_WB_DAYLIGHT,	s5k4ecgx_cfg_wb_daylight},
{SI2C_WB_FLUORESCENT,	s5k4ecgx_cfg_wb_fluorescent},
{SI2C_WB_INCANDESCENT,	s5k4ecgx_cfg_wb_incandescent},
};
