/* Copyright (c) 2011-2012, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/mfd/pm8xxx/pm8921-bms.h>

#ifdef CONFIG_PANTECH_BMS_BATTERY_TYPE
#if defined(CONFIG_MACH_MSM8960_STARQ)
//STANDARD BATTERY
static struct single_row_lut fcc_temp_std = {
	.x		= {-20, 0, 25, 40, 60},
        .y		= {1701, 1701, 1703, 1703, 1707}, 
	.cols	= 5
};
static struct single_row_lut fcc_sf_std = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_std = { 
        .rows           = 28,
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 65},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
    	.sf		= {
    				{551, 226, 100, 86, 82},
    				{531, 226, 103, 88, 83},
    				{512, 224, 105, 89, 85},
    				{503, 223, 108, 92, 87},
    				{499, 221, 111, 94, 89},
    				{498, 216, 113, 96, 92},
    				{498, 214, 114, 98, 94},
    				{503, 214, 112, 99, 95},
    				{516, 215, 101, 88, 86},
    				{539, 217, 98, 85, 84},
    				{576, 223, 98, 85, 85},
    				{640, 233, 98, 86, 87},
    				{720, 249, 101, 86, 89},
    				{822, 270, 106, 89, 89},
    				{920, 294, 111, 93, 87},
    				{1020, 318, 113, 93, 88},
    				{1134, 337, 111, 91, 88},
    				{1330, 370, 109, 90, 88},
    				{1618, 412, 107, 88, 88},
    				{1756, 430, 108, 89, 89},
    				{1974, 467, 111, 91, 90},
    				{2283, 510, 114, 93, 92},
    				{2773, 575, 118, 95, 94},
    				{3557, 645, 123, 97, 93},
    				{4902, 722, 125, 95, 90},
    				{7291, 841, 128, 94, 92},
    				{11939, 1104, 139, 98, 97},
    				{20984, 1596, 165, 107, 116},
    		},

};
static struct sf_lut pc_sf_std = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_std = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4178, 4175, 4171, 4167, 4164}, // 100
				{4107, 4113, 4113, 4111, 4111}, // 95
				{4053, 4068, 4068, 4065, 4065}, // 90
				{3993, 4019, 4024, 4023, 4023}, // 85
				{3946, 3975, 3985, 3985, 3984}, // 80
				{3911, 3937, 3953, 3952, 3950}, // 75
				{3878, 3900, 3923, 3921, 3920}, // 70
				{3849, 3868, 3896, 3895, 3892}, // 65
				{3827, 3842, 3864, 3866, 3863}, // 60
				{3810, 3820, 3825, 3827, 3825}, // 55
				{3794, 3800, 3803, 3803, 3802}, // 50
				{3782, 3788, 3789, 3787, 3786}, // 45
				{3769, 3778, 3776, 3774, 3774},  // 40
				{3757, 3771, 3769, 3765, 3764}, // 35
				{3746, 3764, 3765, 3760, 3752}, // 30
				{3734, 3753, 3758, 3751, 3734}, // 25
				{3721, 3733, 3740, 3730, 3712}, // 20
				{3703, 3705, 3704, 3696, 3679}, // 15
				{3678, 3685, 3673, 3667, 3656}, // 10
				{3670, 3680, 3671, 3665, 3654}, // 9
				{3659, 3676, 3668, 3663, 3652}, //8
				{3648, 3670, 3665, 3660, 3647}, // 7
				{3633, 3664, 3660, 3654, 3636}, // 6
				{3613, 3654, 3650, 3641, 3607}, // 5
				{3585, 3632, 3623, 3609, 3557}, // 4
				{3544, 3587, 3572, 3553, 3490}, // 3
				{3484, 3518, 3497, 3473, 3404}, // 2
				{3386, 3412, 3392, 3359, 3308}, // 1
				{3200, 3200, 3200, 3200, 3200} // 0
	}
};
struct pm8921_bms_battery_data  pantech_battery_std = {
	.fcc			= 1680,
	.fcc_temp_lut		= &fcc_temp_std,
	.fcc_sf_lut		= &fcc_sf_std,
	.pc_temp_ocv_lut	= &pc_temp_ocv_std,
	.pc_sf_lut		= &pc_sf_std,
	.rbatt_sf_lut		=&rbatt_sf_std,
	.default_rbatt_mohm		=185,
	.delta_rbatt_mohm	= 60,		
};

//LARGE BATTERY
static struct single_row_lut fcc_temp_ext = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {3064, 3083, 3086, 3081, 3081},
	.cols	= 5
};
static struct single_row_lut fcc_sf_ext = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_ext = { 
        .rows           = 28, 
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
                                        {396, 188, 100, 90, 87},
                                        {395, 191, 102, 93, 90},
                                        {389, 191, 105, 94, 92},
                                        {380, 188, 106, 96, 94},
                                        {379, 186, 108, 98, 96},
                                        {377, 185, 109, 99, 97},
                                       {376, 184, 109, 100, 98},
                                       {378, 184, 103, 100, 99},
                                        {387, 185, 100, 91, 91},
                                        {403, 185, 100, 91, 90},
                                        {424, 185, 101, 92, 93},
                                        {447, 187, 103, 94, 95},
                                        {475, 194, 104, 95, 97},
                                        {519, 205, 107, 97, 96},
                                       {571, 217, 111, 100, 95},
                                        {638, 230, 112, 99, 96},
                                        {737, 257, 108, 97, 96},
                                        {916, 305, 105, 93, 92},
                                        {628, 239, 100, 91, 91},
                                        {686, 248, 102, 93, 93},
                                        {764, 259, 104, 95, 94},
                                        {872, 273, 106, 96, 96},
                                       {1025, 292, 108, 98, 97},
                                       {1241, 317, 110, 97, 94},
                                       {1602, 349, 110, 96, 95},
                                      {2193, 400, 112, 98, 100},
                                     {3438, 491, 119, 106, 125}, 
                                    {16290, 766, 142, 145, 441},
        }
};
static struct sf_lut pc_sf_ext = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_ext = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4195, 4193, 4190, 4187, 4183},
				{4116, 4131, 4132, 4130, 4129},
				{4063, 4081, 4085, 4084, 4082},
				{4005, 4032, 4043, 4041, 4040},
				{3949, 3982, 4001, 4001, 4000},
				{3915, 3942, 3967, 3967, 3965},
				{3880, 3909, 3936, 3935, 3933},
				{3846, 3878, 3904, 3907, 3905},
				{3817, 3852, 3863, 3875, 3875},
				{3796, 3828, 3834, 3833, 3835},
				{3781, 3807, 3811, 3810, 3811},
				{3769, 3788, 3794, 3793, 3794},
				{3759, 3775, 3782, 3779, 3780},
				{3748, 3765, 3772, 3769, 3768},
				{3737, 3754, 3765, 3761, 3754},
				{3726, 3738, 3755, 3749, 3735},
				{3712, 3719, 3734, 3725, 3712},
				{3693, 3703, 3701, 3692, 3680},
				{3667, 3686, 3676, 3669, 3659},
				{3658, 3680, 3674, 3667, 3658},
				{3648, 3675, 3671, 3665, 3655},
				{3636, 3669, 3668, 3661, 3650},
				{3621, 3659, 3661, 3650, 3635},
				{3601, 3641, 3641, 3621, 3604},
				{3573, 3606, 3600, 3574, 3554},
				{3532, 3550, 3541, 3509, 3489},
				{3469, 3468, 3461, 3425, 3411},
				{3369, 3349, 3350, 3320, 3319},
				{3200, 3200, 3200, 3200, 3200}
	}
};
struct pm8921_bms_battery_data  pantech_battery_ext = {
	.fcc			= 3000,
	.fcc_temp_lut		= &fcc_temp_ext,
	.fcc_sf_lut		= &fcc_sf_ext,
	.pc_temp_ocv_lut	= &pc_temp_ocv_ext,
	.pc_sf_lut		= &pc_sf_ext,
	.rbatt_sf_lut		=&rbatt_sf_ext,
	.default_rbatt_mohm		=125,
	.delta_rbatt_mohm	= 60,		
};
#elif defined (CONFIG_MACH_MSM8960_EF45K) || defined (CONFIG_MACH_MSM8960_EF47S) || defined (CONFIG_MACH_MSM8960_VEGAPVW)
//STANDARD BATTERY
//20120117 p13782 : LG battery cal data 
static struct single_row_lut fcc_temp_std = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1943, 1977, 1977, 1977, 1973},
	.cols	= 5
};
static struct single_row_lut fcc_sf_std = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_std = { 
        .rows           = 28, 
	.cols	= 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
                                       {564, 231, 100, 87, 83},
                                       {582, 237, 101, 88, 84},
                                       {665, 237, 103, 90, 85},
                                       {623, 237, 105, 91, 87},
                                       {602, 239, 108, 93, 88},
                                       {586, 240, 111, 95, 90},
                                       {583, 237, 113, 97, 91},
                                       {575, 235, 115, 100, 93},
                                       {576, 233, 116, 102, 95},
                                       {590, 232, 111, 101, 96},
                                       {610, 233, 104, 92, 89},
                                       {648, 235, 103, 90, 86},
                                       {704, 237, 104, 91, 87},
                                       {777, 247, 105, 93, 90},
                                       {876, 264, 105, 93, 91},
                                       {1066, 286, 106, 90, 86},
                                       {1286, 309, 109, 91, 87},
                                       {1630, 341, 112, 92, 86},
                                       {2618, 396, 126, 99, 92},
                                      {3007, 412, 132, 101, 93},
                                      {3596, 432, 137, 103, 94},
                                      {4637, 458, 144, 105, 94},
                                      {5878, 488, 150, 105, 92},
                                      {7548, 534, 155, 105, 93},
                                      {9745, 641, 168, 109, 95},
                                    {13049, 852, 185, 115, 100}, 
                                   {21477, 1210, 212, 125, 108},
                                   {45029, 1854, 257, 142, 120},
        }
};
static struct sf_lut pc_sf_std = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_std = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4342, 4339, 4334, 4329, 4321},
				{4246, 4262, 4264, 4260, 4254},
				{4175, 4200, 4204, 4201, 4196},
				{4114, 4143, 4148, 4145, 4140},
				{4055, 4091, 4094, 4092, 4087},
				{3985, 4039, 4044, 4042, 4038},
				{3931, 3984, 3998, 3997, 3993},
				{3883, 3937, 3958, 3956, 3952},
				{3849, 3894, 3916, 3919, 3915},
				{3829, 3857, 3870, 3874, 3873},
				{3814, 3827, 3835, 3835, 3834},
				{3801, 3800, 3810, 3810, 3809},
				{3787, 3786, 3792, 3792, 3791},
				{3774, 3777, 3777, 3776, 3775},
				{3761, 3768, 3767, 3763, 3758},
				{3746, 3755, 3759, 3751, 3738},
				{3729, 3740, 3739, 3730, 3716},
				{3701, 3700, 3699, 3692, 3680},
				{3666, 3678, 3672, 3667, 3658},
				{3655, 3675, 3670, 3665, 3656},
				{3642, 3672, 3667, 3663, 3654},
				{3626, 3667, 3664, 3659, 3650},
				{3603, 3660, 3658, 3653, 3640},
				{3574, 3644, 3639, 3631, 3613},
				{3536, 3608, 3598, 3589, 3568},
				{3487, 3555, 3541, 3533, 3512},
				{3420, 3480, 3468, 3462, 3441},
				{3324, 3374, 3370, 3365, 3348},
				{3200, 3200, 3200, 3200, 3200}
	}
};
struct pm8921_bms_battery_data  pantech_battery_std = {
	.fcc			= 2000,
	.fcc_temp_lut		= &fcc_temp_std,
	.fcc_sf_lut		= &fcc_sf_std,
	.pc_temp_ocv_lut	= &pc_temp_ocv_std,
	.pc_sf_lut		= &pc_sf_std,
	.rbatt_sf_lut		=&rbatt_sf_std,
	.default_rbatt_mohm		=177,
	.delta_rbatt_mohm	= 60,		
};

//LARGE BATTERY
//20120117 p13782 : SDI battery cal data
static struct single_row_lut fcc_temp_ext = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2050, 2059, 2060, 2057, 2060},
	.cols	= 5
};
static struct single_row_lut fcc_sf_ext = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_ext = { 
        .rows           = 28, 
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
                                        {596,286,100,81,72},
                                        {564,269,102,82,74},
                                        {544,257,104,83,75},
                                        {528,251,106,84,77},
                                        {519,249,108,86,79},
                                        {513,246,111,88,80},
                                        {513,243,113,91,82},
                                        {526,243,114,93,85},
                                        {541,247,105,88,83},
                                        {558,252,102,81,74},
                                        {576,258,103,82,75},
                                        {596,275,105,84,78},
                                       {629,293,107,85,80},
                                       {705,310,114,86,82},
                                       {825,331,127,90,80},
                                       {1031,353,143,93,80},
                                       {1428,379,156,95,81},
                                      {2344,419,174,99,80},
                                      {2395,450,167,93,77},
                                      {2999,484,177,94,78},
                                      {3811,523,190,97,80},
                                      {5068,592,210,103,83},
                                      {7008,738,237,110,85},
                                      {10259,1010,278,121,88},
                                      {15910,1484,328,135,88},
                                    {26351,2460,392,156,90},
                                   {44586,4255,507,189,99}, 
                                   {77062,8359,832,288,186},
        }
};
static struct sf_lut pc_sf_ext = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_ext = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4344, 4341, 4336, 4331, 4324},
				{4225, 4257, 4266, 4264, 4262},
				{4144, 4191, 4206, 4205, 4204},
				{4071, 4132, 4149, 4148, 4147},
				{3997, 4078, 4095, 4094, 4093},
				{3932, 4025, 4044, 4043, 4043},
				{3878, 3968, 3998, 3997, 3997},
				{3840, 3917, 3956, 3956, 3955},
				{3820, 3876, 3910, 3914, 3916},
				{3804, 3843, 3863, 3868, 3869},
				{3789, 3813, 3830, 3832, 3832},
				{3775, 3793, 3807, 3808, 3808},
				{3761, 3783, 3787, 3789, 3789},
				{3747, 3774, 3774, 3773, 3774},
				{3733, 3765, 3766, 3763, 3756},
				{3720, 3753, 3758, 3751, 3738},
				{3706, 3730, 3737, 3729, 3715},
				{3688, 3697, 3694, 3689, 3674},
				{3660, 3675, 3665, 3662, 3656},
				{3652, 3671, 3663, 3660, 3654},
				{3643, 3667, 3660, 3657, 3651},
				{3632, 3663, 3657, 3653, 3646},
				{3618, 3656, 3651, 3647, 3634},
				{3599, 3641, 3637, 3631, 3604},
				{3571, 3611, 3606, 3597, 3554},
				{3529, 3560, 3555, 3542, 3488},
				{3462, 3485, 3482, 3466, 3402},
				{3359, 3376, 3376, 3362, 3302},
				{3200, 3200, 3200, 3200, 3200}
	}
};
struct pm8921_bms_battery_data  pantech_battery_ext = {
	.fcc			= 1950,
	.fcc_temp_lut		= &fcc_temp_ext,
	.fcc_sf_lut		= &fcc_sf_ext,
	.pc_temp_ocv_lut	= &pc_temp_ocv_ext,
	.pc_sf_lut		= &pc_sf_ext,
	.rbatt_sf_lut		=&rbatt_sf_ext,
	.default_rbatt_mohm		=188,
	.delta_rbatt_mohm	= 60,		
};
#elif defined (CONFIG_MACH_MSM8960_EF46L)
//STANDARD BATTERY
//20120117 p13782 : LG battery cal data 
static struct single_row_lut fcc_temp_std = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1943, 1977, 1977, 1977, 1973},
	.cols	= 5
};
static struct single_row_lut fcc_sf_std = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_std = { 
        .rows           = 28, 
	.cols	= 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
                                       {564, 231, 100, 87, 83},
                                       {582, 237, 101, 88, 84},
                                       {665, 237, 103, 90, 85},
                                       {623, 237, 105, 91, 87},
                                       {602, 239, 108, 93, 88},
                                       {586, 240, 111, 95, 90},
                                       {583, 237, 113, 97, 91},
                                       {575, 235, 115, 100, 93},
                                       {576, 233, 116, 102, 95},
                                       {590, 232, 111, 101, 96},
                                       {610, 233, 104, 92, 89},
                                       {648, 235, 103, 90, 86},
                                       {704, 237, 104, 91, 87},
                                       {777, 247, 105, 93, 90},
                                       {876, 264, 105, 93, 91},
                                       {1066, 286, 106, 90, 86},
                                       {1286, 309, 109, 91, 87},
                                       {1630, 341, 112, 92, 86},
                                       {2618, 396, 126, 99, 92},
                                      {3007, 412, 132, 101, 93},
                                      {3596, 432, 137, 103, 94},
                                      {4637, 458, 144, 105, 94},
                                      {5878, 488, 150, 105, 92},
                                      {7548, 534, 155, 105, 93},
                                      {9745, 641, 168, 109, 95},
                                    {13049, 852, 185, 115, 100}, 
                                   {21477, 1210, 212, 125, 108},
                                   {45029, 1854, 257, 142, 120},
        }
};
static struct sf_lut pc_sf_std = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_std = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4342, 4339, 4334, 4329, 4321},
				{4246, 4262, 4264, 4260, 4254},
				{4175, 4200, 4204, 4201, 4196},
				{4114, 4143, 4148, 4145, 4140},
				{4055, 4091, 4094, 4092, 4087},
				{3985, 4039, 4044, 4042, 4038},
				{3931, 3984, 3998, 3997, 3993},
				{3883, 3937, 3958, 3956, 3952},
				{3849, 3894, 3916, 3919, 3915},
				{3829, 3857, 3870, 3874, 3873},
				{3814, 3827, 3835, 3835, 3834},
				{3801, 3800, 3810, 3810, 3809},
				{3787, 3786, 3792, 3792, 3791},
				{3774, 3777, 3777, 3776, 3775},
				{3761, 3768, 3767, 3763, 3758},
				{3746, 3755, 3759, 3751, 3738},
				{3729, 3740, 3739, 3730, 3716},
				{3701, 3700, 3699, 3692, 3680},
				{3666, 3678, 3672, 3667, 3658},
				{3655, 3675, 3670, 3665, 3656},
				{3642, 3672, 3667, 3663, 3654},
				{3626, 3667, 3664, 3659, 3650},
				{3603, 3660, 3658, 3653, 3640},
				{3574, 3644, 3639, 3631, 3613},
				{3536, 3608, 3598, 3589, 3568},
				{3487, 3555, 3541, 3533, 3512},
				{3420, 3480, 3468, 3462, 3441},
				{3324, 3374, 3370, 3365, 3348},
				{3200, 3200, 3200, 3200, 3200}
	}
};
struct pm8921_bms_battery_data  pantech_battery_std = {
	.fcc			= 2000,
	.fcc_temp_lut		= &fcc_temp_std,
	.fcc_sf_lut		= &fcc_sf_std,
	.pc_temp_ocv_lut	= &pc_temp_ocv_std,
	.pc_sf_lut		= &pc_sf_std,
	.rbatt_sf_lut		=&rbatt_sf_std,
	.default_rbatt_mohm		=177,
	.delta_rbatt_mohm	= 60,		
};

//LARGE BATTERY
//20120117 p13782 : SDI battery cal data
static struct single_row_lut fcc_temp_ext = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2050, 2059, 2060, 2057, 2060},
	.cols	= 5
};
static struct single_row_lut fcc_sf_ext = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_ext = { 
        .rows           = 28, 
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
                                        {596,286,100,81,72},
                                        {564,269,102,82,74},
                                        {544,257,104,83,75},
                                        {528,251,106,84,77},
                                        {519,249,108,86,79},
                                        {513,246,111,88,80},
                                        {513,243,113,91,82},
                                        {526,243,114,93,85},
                                        {541,247,105,88,83},
                                        {558,252,102,81,74},
                                        {576,258,103,82,75},
                                        {596,275,105,84,78},
                                       {629,293,107,85,80},
                                       {705,310,114,86,82},
                                       {825,331,127,90,80},
                                       {1031,353,143,93,80},
                                       {1428,379,156,95,81},
                                      {2344,419,174,99,80},
                                      {2395,450,167,93,77},
                                      {2999,484,177,94,78},
                                      {3811,523,190,97,80},
                                      {5068,592,210,103,83},
                                      {7008,738,237,110,85},
                                      {10259,1010,278,121,88},
                                      {15910,1484,328,135,88},
                                    {26351,2460,392,156,90},
                                   {44586,4255,507,189,99}, 
                                   {77062,8359,832,288,186},
        }
};
static struct sf_lut pc_sf_ext = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_ext = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4344, 4341, 4336, 4331, 4324},
				{4225, 4257, 4266, 4264, 4262},
				{4144, 4191, 4206, 4205, 4204},
				{4071, 4132, 4149, 4148, 4147},
				{3997, 4078, 4095, 4094, 4093},
				{3932, 4025, 4044, 4043, 4043},
				{3878, 3968, 3998, 3997, 3997},
				{3840, 3917, 3956, 3956, 3955},
				{3820, 3876, 3910, 3914, 3916},
				{3804, 3843, 3863, 3868, 3869},
				{3789, 3813, 3830, 3832, 3832},
				{3775, 3793, 3807, 3808, 3808},
				{3761, 3783, 3787, 3789, 3789},
				{3747, 3774, 3774, 3773, 3774},
				{3733, 3765, 3766, 3763, 3756},
				{3720, 3753, 3758, 3751, 3738},
				{3706, 3730, 3737, 3729, 3715},
				{3688, 3697, 3694, 3689, 3674},
				{3660, 3675, 3665, 3662, 3656},
				{3652, 3671, 3663, 3660, 3654},
				{3643, 3667, 3660, 3657, 3651},
				{3632, 3663, 3657, 3653, 3646},
				{3618, 3656, 3651, 3647, 3634},
				{3599, 3641, 3637, 3631, 3604},
				{3571, 3611, 3606, 3597, 3554},
				{3529, 3560, 3555, 3542, 3488},
				{3462, 3485, 3482, 3466, 3402},
				{3359, 3376, 3376, 3362, 3302},
				{3200, 3200, 3200, 3200, 3200}
	}
};
struct pm8921_bms_battery_data  pantech_battery_ext = {
	.fcc			= 1950,
	.fcc_temp_lut		= &fcc_temp_ext,
	.fcc_sf_lut		= &fcc_sf_ext,
	.pc_temp_ocv_lut	= &pc_temp_ocv_ext,
	.pc_sf_lut		= &pc_sf_ext,
	.rbatt_sf_lut		=&rbatt_sf_ext,
	.default_rbatt_mohm		=188,
	.delta_rbatt_mohm	= 60,		
};
#elif defined (CONFIG_MACH_MSM8960_OSCAR)
//STANDARD BATTERY
static struct single_row_lut fcc_temp_std = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1759, 1801, 1802, 1801, 1794},
	.cols	= 5
};
static struct single_row_lut fcc_sf_std = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_std = { 
        .rows           = 28, 
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
                                        {570, 254, 100, 86, 84},
                                        {584, 255, 102, 88, 86},
                                        {659, 252, 105, 90, 87},
                                        {637, 249, 108, 93, 89},
                                        {626, 249, 110, 95, 91},
                                        {610, 247, 112, 97, 93},
                                        {603, 248, 114, 99, 95},
                                        {609, 248, 113, 99, 96},
                                        {623, 252, 104, 90, 88},
                                        {654, 257, 103, 88, 86},
                                        {716, 263, 105, 90, 89},
                                        {825, 273, 108, 92, 91},
                                       {978, 288, 110 , 94, 94},
                                       {1197, 304, 115, 96, 92},
                                       {1539, 321, 120, 97, 89},
                                       {2102, 338, 124, 97, 91},
                                       {3089, 365, 124, 96, 89},
                                      {5145, 420, 143, 104, 95},
                                      {3548, 395, 138, 102, 94},
                                      {3905, 417, 142, 103, 95},
                                      {4665, 439, 147, 106, 95},
                                      {5382, 463, 153, 106, 93},
                                      {5700, 494, 156, 105, 93},
                                      {6843, 548, 162, 106, 94},
                                      {8441, 677, 174, 110, 96},
                                    {12187, 892, 191, 117, 102},
                                   {18257, 1255, 219, 130, 110}, 
                                   {23855, 2149, 275, 151, 133},
        }
};
static struct sf_lut pc_sf_std = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_std = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4342, 4339, 4334, 4328, 4319},
				{4253, 4267, 4268, 4264, 4257},
				{4180, 4205, 4209, 4206, 4200},
				{4112, 4148, 4153, 4151, 4145},
				{4048, 4093, 4099, 4097, 4092},
				{3984, 4040, 4050, 4047, 4042},
				{3933, 3984, 4002, 4001, 3997},
				{3890, 3938, 3962, 3961, 3956},
				{3861, 3896, 3920, 3922, 3918},
				{3839, 3860, 3867, 3869, 3869},
				{3822, 3830, 3835, 3836, 3835},
				{3806, 3804, 3812, 3812, 3812},
				{3791, 3786, 3793, 3792, 3792},
				{3777, 3773, 3777, 3776, 3776},
				{3762, 3761, 3767, 3764, 3758},
				{3745, 3745, 3756, 3751, 3736},
				{3724, 3725, 3735, 3728, 3713},
				{3695, 3706, 3693, 3686, 3672},
				{3649, 3684, 3672, 3667, 3657},
				{3638, 3680, 3670, 3665, 3655},
				{3628, 3674, 3668, 3663, 3653},
				{3612, 3668, 3663, 3659, 3648},
				{3592, 3658, 3655, 3650, 3633},
				{3565, 3636, 3632, 3622, 3601},
				{3527, 3599, 3588, 3577, 3556},
				{3473, 3547, 3530, 3520, 3498},
				{3402, 3475, 3456, 3446, 3429},
				{3307, 3369, 3358, 3353, 3341},
				{3200, 3200, 3200, 3200, 3200}
	}
};
struct pm8921_bms_battery_data  pantech_battery_std = {
	.fcc			= 1800,
	.fcc_temp_lut		= &fcc_temp_std,
	.fcc_sf_lut		= &fcc_sf_std,
	.pc_temp_ocv_lut	= &pc_temp_ocv_std,
	.pc_sf_lut		= &pc_sf_std,
	.rbatt_sf_lut		=&rbatt_sf_std,
	.default_rbatt_mohm		=187,
	.delta_rbatt_mohm	= 60,		
};

//LARGE BATTERY
static struct single_row_lut fcc_temp_ext = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1759, 1801, 1802, 1801, 1794},
	.cols	= 5
};
static struct single_row_lut fcc_sf_ext = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};
static struct sf_lut rbatt_sf_ext = { 
        .rows           = 28, 
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
                                        {570, 254, 100, 86, 84},
                                        {584, 255, 102, 88, 86},
                                        {659, 252, 105, 90, 87},
                                        {637, 249, 108, 93, 89},
                                        {626, 249, 110, 95, 91},
                                        {610, 247, 112, 97, 93},
                                        {603, 248, 114, 99, 95},
                                        {609, 248, 113, 99, 96},
                                        {623, 252, 104, 90, 88},
                                        {654, 257, 103, 88, 86},
                                        {716, 263, 105, 90, 89},
                                        {825, 273, 108, 92, 91},
                                       {978, 288, 110 , 94, 94},
                                       {1197, 304, 115, 96, 92},
                                       {1539, 321, 120, 97, 89},
                                       {2102, 338, 124, 97, 91},
                                       {3089, 365, 124, 96, 89},
                                      {5145, 420, 143, 104, 95},
                                      {3548, 395, 138, 102, 94},
                                      {3905, 417, 142, 103, 95},
                                      {4665, 439, 147, 106, 95},
                                      {5382, 463, 153, 106, 93},
                                      {5700, 494, 156, 105, 93},
                                      {6843, 548, 162, 106, 94},
                                      {8441, 677, 174, 110, 96},
                                    {12187, 892, 191, 117, 102},
                                   {18257, 1255, 219, 130, 110}, 
                                   {23855, 2149, 275, 151, 133},
        }
};
static struct sf_lut pc_sf_ext = {
	.rows		= 1,
	.cols		= 1,
	.row_entries		= {0},
	.percent	= {100},
	.sf		= {
				{100}
	}
};
static struct pc_temp_ocv_lut  pc_temp_ocv_ext = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4342, 4339, 4334, 4328, 4319},
				{4253, 4267, 4268, 4264, 4257},
				{4180, 4205, 4209, 4206, 4200},
				{4112, 4148, 4153, 4151, 4145},
				{4048, 4093, 4099, 4097, 4092},
				{3984, 4040, 4050, 4047, 4042},
				{3933, 3984, 4002, 4001, 3997},
				{3890, 3938, 3962, 3961, 3956},
				{3861, 3896, 3920, 3922, 3918},
				{3839, 3860, 3867, 3869, 3869},
				{3822, 3830, 3835, 3836, 3835},
				{3806, 3804, 3812, 3812, 3812},
				{3791, 3786, 3793, 3792, 3792},
				{3777, 3773, 3777, 3776, 3776},
				{3762, 3761, 3767, 3764, 3758},
				{3745, 3745, 3756, 3751, 3736},
				{3724, 3725, 3735, 3728, 3713},
				{3695, 3706, 3693, 3686, 3672},
				{3649, 3684, 3672, 3667, 3657},
				{3638, 3680, 3670, 3665, 3655},
				{3628, 3674, 3668, 3663, 3653},
				{3612, 3668, 3663, 3659, 3648},
				{3592, 3658, 3655, 3650, 3633},
				{3565, 3636, 3632, 3622, 3601},
				{3527, 3599, 3588, 3577, 3556},
				{3473, 3547, 3530, 3520, 3498},
				{3402, 3475, 3456, 3446, 3429},
				{3307, 3369, 3358, 3353, 3341},
				{3200, 3200, 3200, 3200, 3200}
	}
};
struct pm8921_bms_battery_data  pantech_battery_ext = {
	.fcc			= 1800,
	.fcc_temp_lut		= &fcc_temp_ext,
	.fcc_sf_lut		= &fcc_sf_ext,
	.pc_temp_ocv_lut	= &pc_temp_ocv_ext,
	.pc_sf_lut		= &pc_sf_ext,
	.rbatt_sf_lut		=&rbatt_sf_ext,
	.default_rbatt_mohm		=187,
	.delta_rbatt_mohm	= 60,		
};
#else
//STANDARD BATTERY
static struct single_row_lut fcc_temp_std = {
	.x	= {-20, 0, 25, 40, 65},
	.y	= {1607, 1706, 1706, 1703, 1713},
	.cols	= 5,
};
static struct single_row_lut fcc_sf_std = {
	.x	= {100, 200, 300, 400, 500},
	.y	= {100, 100, 100, 100, 100},
	.cols	= 5,
};
static struct sf_lut rbatt_sf_std = { 
        .rows           = 28, 
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
     				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
     				{100, 100, 100, 100, 100},
      				{100, 100, 100, 100, 100},
       				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
        }
};
static struct sf_lut pc_sf_std = {
	.rows		= 10,
	.cols		= 5,
	.row_entries		= {100, 200, 300, 400, 500},
	.percent	= {100, 90, 80, 70, 60, 50, 40, 30, 20, 10},
	.sf		= {
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},					
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100}
	},
};
static struct pc_temp_ocv_lut  pc_temp_ocv_std = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 65},		
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55,
				50, 45, 40, 35, 30, 25, 20, 15, 10, 9,
				8, 7, 6, 5, 4, 3, 2, 1, 0
	},
	.ocv		= {
			{4330, 4327, 4322, 4317, 4321},
			{4248, 4257, 4258, 4256, 4262},
			{4180, 4198, 4203, 4200, 4207},
			{4118, 4144, 4150, 4148, 4154},
			{4053, 4093, 4099, 4097, 4103},
			{3992, 4042, 4052, 4050, 4054},
			{3943, 3989, 4007, 4007, 4010},
			{3907, 3944, 3968, 3967, 3970},
			{3883, 3904, 3929, 3931, 3933},
			{3863, 3870, 3883, 3886, 3891},
			{3847, 3840, 3846, 3847, 3852},
			{3831, 3815, 3821, 3822, 3823},
			{3815, 3796, 3801, 3801, 3803},
			{3800, 3782, 3786, 3784, 3786},
			{3784, 3768, 3774, 3771, 3772},
			{3767, 3753, 3764, 3760, 3751},
			{3749, 3736, 3750, 3744, 3728},
			{3728, 3719, 3723, 3717, 3704},
			{3700, 3701, 3688, 3682, 3673},
			{3693, 3697, 3685, 3679, 3668},
			{3687, 3692, 3681, 3675, 3663},
			{3680, 3688, 3677, 3671, 3658},
			{3673, 3684, 3674, 3667, 3655},
			{3661, 3679, 3671, 3666, 3653},
			{3650, 3673, 3669, 3663, 3651},
			{3638, 3666, 3665, 3660, 3649},
			{3626, 3654, 3658, 3653, 3644},
			{3614, 3633, 3639, 3635, 3630},
			{3600, 3600, 3600, 3600, 3600}
	},
};
struct pm8921_bms_battery_data  pantech_battery_std = {
	.fcc			= 1830,
	.fcc_temp_lut		= &fcc_temp_std,
	.fcc_sf_lut		= &fcc_sf_std,
	.pc_temp_ocv_lut	= &pc_temp_ocv_std,
	.pc_sf_lut		= &pc_sf_std,
	.rbatt_sf_lut		=&rbatt_sf_std,
	.default_rbatt_mohm		=128,
	.delta_rbatt_mohm	= 60,		
};

//LARGE BATTERY
static struct single_row_lut fcc_temp_ext = {
	.x	= {-20, 0, 25, 40, 65},
	.y	= {1607, 1706, 1706, 1703, 1713},
	.cols	= 5,
};
static struct single_row_lut fcc_sf_ext = {
	.x	= {100, 200, 300, 400, 500},
	.y	= {100, 100, 100, 100, 100},
	.cols	= 5,
};
static struct sf_lut rbatt_sf_ext = { 
        .rows           = 28, 
        .cols           = 5,
        /* row_entries are temperature */
        .row_entries            = {-20, 0, 25, 40, 60},
        .percent        = {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
        .sf                     = {
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
     				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
     				{100, 100, 100, 100, 100},
      				{100, 100, 100, 100, 100},
       				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
    				{100, 100, 100, 100, 100},
        }
};
static struct sf_lut pc_sf_ext = {
	.rows		= 10,
	.cols		= 5,
	.row_entries		= {100, 200, 300, 400, 500},
	.percent	= {100, 90, 80, 70, 60, 50, 40, 30, 20, 10},
	.sf		= {
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},					
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100},
			{100, 100, 100, 100, 100}
	},
};
static struct pc_temp_ocv_lut  pc_temp_ocv_ext = {
	.rows		= 29,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 65},		
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55,
				50, 45, 40, 35, 30, 25, 20, 15, 10, 9,
				8, 7, 6, 5, 4, 3, 2, 1, 0
	},
	.ocv		= {
			{4330, 4327, 4322, 4317, 4321},
			{4248, 4257, 4258, 4256, 4262},
			{4180, 4198, 4203, 4200, 4207},
			{4118, 4144, 4150, 4148, 4154},
			{4053, 4093, 4099, 4097, 4103},
			{3992, 4042, 4052, 4050, 4054},
			{3943, 3989, 4007, 4007, 4010},
			{3907, 3944, 3968, 3967, 3970},
			{3883, 3904, 3929, 3931, 3933},
			{3863, 3870, 3883, 3886, 3891},
			{3847, 3840, 3846, 3847, 3852},
			{3831, 3815, 3821, 3822, 3823},
			{3815, 3796, 3801, 3801, 3803},
			{3800, 3782, 3786, 3784, 3786},
			{3784, 3768, 3774, 3771, 3772},
			{3767, 3753, 3764, 3760, 3751},
			{3749, 3736, 3750, 3744, 3728},
			{3728, 3719, 3723, 3717, 3704},
			{3700, 3701, 3688, 3682, 3673},
			{3693, 3697, 3685, 3679, 3668},
			{3687, 3692, 3681, 3675, 3663},
			{3680, 3688, 3677, 3671, 3658},
			{3673, 3684, 3674, 3667, 3655},
			{3661, 3679, 3671, 3666, 3653},
			{3650, 3673, 3669, 3663, 3651},
			{3638, 3666, 3665, 3660, 3649},
			{3626, 3654, 3658, 3653, 3644},
			{3614, 3633, 3639, 3635, 3630},
			{3600, 3600, 3600, 3600, 3600}
	},
};
struct pm8921_bms_battery_data  pantech_battery_ext = {
	.fcc			= 1830,
	.fcc_temp_lut		= &fcc_temp_ext,
	.fcc_sf_lut		= &fcc_sf_ext,
	.pc_temp_ocv_lut	= &pc_temp_ocv_ext,
	.pc_sf_lut		= &pc_sf_ext,
	.rbatt_sf_lut		=&rbatt_sf_ext,
	.default_rbatt_mohm		=128,
	.delta_rbatt_mohm	= 60,		
};
#endif //defined(CONFIG_MACH_MSM8960_STARQ)

#else //CONFIG_PANTECH_BMS_BATTERY_TYPE

static struct single_row_lut palladium_1500_fcc_temp = {
	.x	= {-30, -20, -10, 0, 10, 25, 40, 60},
	.y	= {1103, 1179, 1284, 1330, 1420, 1511, 1541, 1571},
	.cols	= 8,
};

static struct single_row_lut palladium_1500_fcc_sf = {
	.x	= {100, 200, 300, 400, 500},
	.y	= {97, 93, 93, 90, 87},
	.cols	= 5,
};

static struct sf_lut palladium_1500_pc_sf = {
	.rows		= 10,
	.cols		= 5,
	/* row_entries are chargecycles */
	.row_entries	= {100, 200, 300, 400, 500},
	.percent	= {100, 90, 80, 70, 60, 50, 40, 30, 20, 10},
	.sf		= {
			{97, 93, 93, 90, 87},
			{97, 93, 93, 90, 87},
			{98, 94, 92, 89, 86},
			{98, 94, 92, 89, 86},
			{99, 94, 92, 88, 86},
			{99, 95, 92, 88, 87},
			{99, 95, 92, 88, 87},
			{99, 95, 92, 88, 87},
			{99, 95, 92, 88, 87},
			{99, 95, 92, 88, 87}
	},
};

static struct sf_lut palladium_1500_rbatt_sf = {
	.rows		= 19,
	.cols		= 5,
	/* row_entries are temperature */
	.row_entries	= {-20, 0, 20, 40, 65},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50,
				45, 40, 35, 30, 25, 20, 15, 10
	},
	.sf		= {
					{645, 301, 100, 80, 69},
					{616, 290, 100, 79, 69},
					{586, 279, 100, 78, 68},
					{564, 270, 100, 78, 68},
					{546, 262, 100, 78, 68},
					{537, 256, 100, 79, 68},
					{536, 253, 100, 79, 69},
					{552, 258, 100, 81, 71},
					{618, 284, 100, 80, 72},
					{643, 290, 100, 77, 68},
					{673, 294, 100, 77, 68},
					{720, 296, 100, 77, 69},
					{769, 294, 100, 76, 68},
					{821, 288, 100, 74, 67},
					{892, 284, 100, 74, 61},
					{1003, 290, 100, 71, 58},
					{1192, 307, 100, 70, 58},
					{1579, 345, 100, 68, 57},
					{1261, 324, 100, 68, 57},
	}
};
static struct pc_temp_ocv_lut palladium_1500_pc_temp_ocv = {
	.rows		= 29,
	.cols		= 8,
	.temp		= {-30, -20, -10, 0, 10, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55,
				50, 45, 40, 35, 30, 25, 20, 15, 10, 9,
				8, 7, 6, 5, 4, 3, 2, 1, 0
	},
	.ocv		= {
			{3673, 3814, 3945, 4025, 4106, 4176, 4218, 4260},
			{3613, 3751, 3880, 3959, 4038, 4107, 4149, 4190},
			{3573, 3710, 3837, 3916, 3994, 4062, 4103, 4144},
			{3534, 3670, 3796, 3873, 3951, 4019, 4059, 4099},
			{3491, 3625, 3749, 3826, 3902, 3969, 4009, 4049},
			{3464, 3597, 3721, 3796, 3872, 3939, 3978, 4018},
			{3436, 3568, 3691, 3766, 3841, 3907, 3946, 3985},
			{3407, 3537, 3659, 3733, 3808, 3873, 3912, 3951},
			{3377, 3507, 3627, 3701, 3775, 3840, 3878, 3917},
			{3355, 3484, 3604, 3677, 3751, 3815, 3853, 3891},
			{3339, 3467, 3586, 3659, 3732, 3796, 3834, 3872},
			{3324, 3452, 3570, 3643, 3716, 3780, 3818, 3855},
			{3312, 3440, 3558, 3630, 3703, 3766, 3804, 3842},
			{3303, 3430, 3548, 3620, 3692, 3756, 3793, 3831},
			{3297, 3424, 3541, 3614, 3686, 3749, 3787, 3824},
			{3288, 3414, 3531, 3603, 3675, 3738, 3776, 3813},
			{3272, 3398, 3514, 3586, 3658, 3720, 3757, 3795},
			{3240, 3365, 3480, 3551, 3622, 3684, 3721, 3758},
			{3224, 3348, 3463, 3533, 3604, 3666, 3702, 3739},
			{3221, 3344, 3459, 3530, 3600, 3662, 3695, 3728},
			{3216, 3340, 3454, 3525, 3595, 3657, 3686, 3715},
			{3212, 3335, 3449, 3520, 3590, 3652, 3677, 3703},
			{3203, 3326, 3440, 3510, 3580, 3642, 3664, 3686},
			{3185, 3307, 3420, 3490, 3560, 3621, 3639, 3657},
			{3176, 3298, 3411, 3481, 3550, 3611, 3626, 3640},
			{3151, 3272, 3384, 3453, 3522, 3583, 3593, 3604},
			{3106, 3225, 3335, 3446, 3472, 3531, 3538, 3545},
			{3021, 3217, 3245, 3417, 3429, 3435, 3439, 3442},
			{3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000}
	},
};

struct pm8921_bms_battery_data palladium_1500_data = {
	.fcc			= 1500,
	.fcc_temp_lut		= &palladium_1500_fcc_temp,
	.fcc_sf_lut		= &palladium_1500_fcc_sf,
	.pc_temp_ocv_lut	= &palladium_1500_pc_temp_ocv,
	.pc_sf_lut		= &palladium_1500_pc_sf,
	.rbatt_sf_lut		= &palladium_1500_rbatt_sf,
	.default_rbatt_mohm	= 254,
	.delta_rbatt_mohm	= 60,
};

#endif //CONFIG_PANTECH_BMS_BATTERY_TYPE

